;; =========================================================================
;; main.asm
;;
;;                              MidiBox AY (YM)
;;                                    V2
;;
;; ==========================================================================

;; -------------------------------------------------------------------------
;; APPLICATION: MIDIBOX AY (YM) V2
;; CORE8, PIC 18F4685
;; For more Information see the Project Page:
;; http://www.midibox.org/dokuwiki/midibox_ay_3_8912
;; -------------------------------------------------------------------------
;;
;; MidiBox AY (YM) V2
;; By lemonhorse (2009-2011)
;; MIOS & MBHP by TK
;; All rights by TK

;; ---[MIOS header file ]---
#include "mios.h"

;; ---[useful macros ]---
#include "macros.h"

;; ---[vectors to MIOS functions (never change!) ]---
#include "mios_vectors.inc"

;; ---[user hooks (never change!) ]---
#include "user_vectors.inc"

;; ---[variables used by application ]-------------------------------------
#include "app_defines.h"

;; ---[configuration table for MIDI processor and rotary encoders ]---------
#include "mios_tables.inc"

;; ---[Custom LCD driver ]--------------------------------------------------
#include "app_lcd.inc"

;; --------[start screen]---------------------------------------------------
#include "start_screen.inc"

;; ----[AY LCD TEXT ]-------------------------------------------------------
#include "lcd_text.inc"

;; ==========================================================================
;;  General Application Settings
;; ==========================================================================

;; ---[include applicaion files]----------
#include "app_include.inc"


;; ==========================================================================
;;  All MIOS hooks in one file
;; ==========================================================================

;; --------------------------------------------------------------------------
;;  This function is called by MIOS after startup to initialize the 
;;  application
;; --------------------------------------------------------------------------
USER_Init
	;; initialize the shift registers
	;; use up to 16 shift registers
	movlw	16			
	call	MIOS_SRIO_NumberSet
	
	;; disable touch sensor
	clrw	
	call	MIOS_SRIO_TS_SensitivitySet

	;; --- INIT APPLICATION REGS--------------------------------------------
	;;  SET AY 3 8912 (SHADOW) REGISTERS 
	;;  WITH DEFAULT VALUES
	;;  and ADJUST VARIABLES (initial values)
	;;  @ midibox_ay_ini.inc
	call  	INIT_VARIABLES
	;;
	;; MIDI MERGER Conf.
	call	INIT_MIDI_CONF
	;;
	;; SET UP timer0 FOR FX TIMER
	call INIT_TIMER0
	;;
	;; initialize the USER_Timer (for Fx Timmer polling)
	call INIT_USER_Timer
	;;
	;; Check if INTERNAL PIC PATCH has been Written
	;; IF NOT WRITE INTERNAL PATCH 0 (to PIC EEPROM)
	call WRITE_PIC_EEPROM_PATCH_0_INI
	;; ----------------------------------------------------------------------
	;; QUIT USER INIT
	return

;; --------------------------------------------------------------------------
;;  This function is called by MIOS in the mainloop when nothing else is to do
;; --------------------------------------------------------------------------
USER_Tick
	;; DO call FX TAB Routines
	call 	FX_PIPELINE
	
	;; CHECK MIDI IN EVENT: ProgChange
	;; See: midi_evnt_handling.inc :: MIDI_EVNT_IS_Cx
	call	CHECK_MIDI_PatchChangeRequest
	
	;; CHECK BTN AUTO REPEAT 
	;; AND CSR BLINKING
	call 	CHECK_BTN_AUTO_REPEAT
	
	;; DO CURSOR BLINKING
	call	DO_CSR_BLINKING
	
	;; QUIT USER Tick
	return


;; --------------------------------------------------------------------------
;;  This function is periodically called by MIOS. The frequency has to be
;;  initialized with MIOS_Timer_Set
;;  Note that this is an interrupt service routine! Use FSR2 instead of FSR0
;;  and IRQ_TMPx instead of TMPx -- and make the routine as fast as possible!
;; --------------------------------------------------------------------------
USER_Timer
	;; Fx Timer call (polling)
	;; Function: INC FX TIMER +1 
	;; @ fx_timer.inc
	call 	FX_TIMER_POLLING
		
	return


;; --------------------------------------------------------------------------
;;  This function is called by MIOS when a debug command has been received
;;  via SysEx
;;  Input:
;;     o WREG, MIOS_PARAMETER1, MIOS_PARAMETER2, MIOS_PARAMETER3 like
;;       specified in the debug command
;;  Output:
;;     o return values WREG, MIOS_PARAMETER1, MIOS_PARAMETER2, MIOS_PARAMETER3
;; --------------------------------------------------------------------------
USER_MPROC_DebugTrigger
	return


;; --------------------------------------------------------------------------
;;  This function is called by MIOS when the display content should be 
;;  initialized. Thats the case during startup and after a temporary message
;;  has been printed on the screen
;; --------------------------------------------------------------------------
USER_DISPLAY_Init
	;; [1] - SHOW START SCREEN ON LCD -
	call AY_START_SCREEN
	;;
	;; [2] -[appl. main cycle start]---
	;; JUMP TO >> MAIN MENU
	goto MENUE_SWITCH_DO


;; --------------------------------------------------------------------------
;;  This function is called in the mainloop when no temporary message is shown
;;  on screen. Print the realtime messages here
;; --------------------------------------------------------------------------
USER_DISPLAY_Tick
	;; REDRAW MAIN MENU IF A Control Change (CC, etc.)
	;; OR MOD WHEEL / PITCH BEND
	;; MATCH THE CURRENT MAIN MENU
	call	CHECK_EVENT_MENU_REDRAW
	
	return
	


;; --------------------------------------------------------------------------
;;  This function is called by MIOS when a complete MIDI event has been received
;;  Input:
;;     o first  MIDI event byte in MIOS_PARAMETER1
;;     o second MIDI event byte in MIOS_PARAMETER2
;;     o third  MIDI event byte in MIOS_PARAMETER3
;; --------------------------------------------------------------------------
USER_MPROC_NotifyReceivedEvent
	;; A MIDI EVENT HAS BEEN RECEIVED 
	goto LABEL_MIDI_HANDLING_START

;; --------------------------------------------------------------------------
;;  This function is called by MIOS when a MIDI event has been received
;;  which has been specified in the CONFIG_MIDI_IN table (mios_tables.inc)
;;  Input:
;;     o number of entry in WREG
;;     o first  MIDI event byte in MIOS_PARAMETER1
;;     o second MIDI event byte in MIOS_PARAMETER2
;;     o third  MIDI event byte in MIOS_PARAMETER3
;; --------------------------------------------------------------------------
USER_MPROC_NotifyFoundEvent
	return


;; --------------------------------------------------------------------------
;;  This function is called by MIOS when a MIDI event has not been completly
;;  received within 2 seconds
;; --------------------------------------------------------------------------
USER_MPROC_NotifyTimeout
	return


;; --------------------------------------------------------------------------
;;  This function is called by MIOS when a MIDI byte has been received
;;  Input:
;;     o received MIDI byte in WREG and MIOS_PARAMETER1
;; --------------------------------------------------------------------------
USER_MPROC_NotifyReceivedByte
	return

;; --------------------------------------------------------------------------
;;  This function is called by MIOS before the transfer of a MIDI byte. 
;;  It can be used to monitor the Tx activity or to do any other actions
;;  (e.g. to switch a pin for multiplexed MIDI Outs) before the byte will 
;;  be sent.
;;  Note that this is an interrupt service routine! Use FSR2 instead of FSR0
;;  and IRQ_TMPx instead of TMPx -- and make the routine as fast as possible!
;;  Input:
;;     o transmitted byte in WREG
;; --------------------------------------------------------------------------
USER_MIDI_NotifyTx
	return

;; --------------------------------------------------------------------------
;;  This function is called by MIOS when a MIDI byte has been received.
;;  It can be used to monitor the Rx activity or to do any action - e.g.
;;  to react on realtime events like MIDI clock (0xf8) with a minimum latency
;;  Note that this is an interrupt service routine! Use FSR2 instead of FSR0
;;  and IRQ_TMPx instead of TMPx -- and make the routine as fast as possible!
;;  Input:
;;     o received byte in WREG
;; --------------------------------------------------------------------------
USER_MIDI_NotifyRx
	return



;; --------------------------------------------------------------------------
;;  This function is called by MIOS when an button has been toggled
;;  Input:
;;     o Button number in WREG and MIOS_PARAMETER1
;;     o Button value MIOS_PARAMETER2:
;;       - 1 if button has been released (=5V)
;;       - 0 if button has been pressed  (=0V)
;; --------------------------------------------------------------------------
USER_DIN_NotifyToggle
; 	;; A BTN HAS BEEN PRESSED or DEPRESSED
; 	;; STORE BTN NUMBER VALUE & BTN STATE (PRESSED OR DEPREASSED)
	movff	MIOS_PARAMETER1, VAR_CURRENT_DIN_BTN_VALUE
	movff	MIOS_PARAMETER2, VAR_CURRENT_DIN_BTN_STATE

	goto BTN_VALUE_TO_ROUTINE_SWITCH_BOARD
	
	
;; --------------------------------------------------------------------------
;;  This function is called by MIOS when an encoder has been moved
;;  Input:
;;     o Encoder number in WREG and MIOS_PARAMETER1
;;     o signed incrementer value in MIOS_PARAMETER2:
;;       - is positive when encoder has been turned clockwise
;;       - is negative when encoder has been turned counter clockwise
;; --------------------------------------------------------------------------
USER_ENC_NotifyChange
	return


;; --------------------------------------------------------------------------
;;  This function is called by MIOS before the shift register are loaded
;;  Note that this is an interrupt service routine! Use FSR2 instead of FSR0
;;  and IRQ_TMPx instead of TMPx -- and make the routine as fast as possible
;; --------------------------------------------------------------------------
USER_SR_Service_Prepare
	return


;; --------------------------------------------------------------------------
;;  This function is called by MIOS after the shift register have been loaded
;;  Note that this is an interrupt service routine! Use FSR2 instead of FSR0
;;  and IRQ_TMPx instead of TMPx -- and make the routine as fast as possible
;; --------------------------------------------------------------------------
USER_SR_Service_Finish
	return

;; --------------------------------------------------------------------------
;;  This function is called by MIOS when a pot has been moved
;;  Input:
;;     o Pot number in WREG and MIOS_PARAMETER1
;;     o LSB value in MIOS_PARAMETER2
;;     o MSB value in MIOS_PARAMETER3
;; --------------------------------------------------------------------------
USER_AIN_NotifyChange
	return

	

	END



	