;; midi_evnt_handling.inc


; Aftertouch
MIDI_EVNT_IS_Ax	
	;; not implemented yet	
	return


;; Program Change (Patch Change Request)
MIDI_EVNT_IS_Cx
	
	;; ---[CHK: PrgChng MIDI EVENT CH = TONE A MIDI CH ?]--------------------------
	;; PROGRAM CHANGE EVENT MIDI CHANNEL 	= MIDI_CURRENT_EVNT_CHANNEL
	;; TONE A MIDI CHANNEL 					= MIDI_CHANNEL_TONE_A_USER
	movf	MIDI_CHANNEL_TONE_A_USER, W
	cpfseq	MIDI_CURRENT_EVNT_CHANNEL
	
			;; MIDI CH < >
			return
			
	;; ---[CURRENT MIDI CH (OF PROGRAM CHANGE MIDI EVENT) = MIDI CH TONE A]-------- 
	
	;; CHECK: PATCH LOAD STILL IN PROGRESS?
	movff	BNKD_VAR_PATCH_STATE_FLAGS, VAR_TMP7
	GOTO_IFCLR VAR_TMP7, BIT7_MIDI_PROGRAMM_CHANGE_RECEIVED,  ACCESS, MIDI_EVNT_IS_Cx_GO_ON
	;; PATCH LOAD STILL IN PROGRESS, EXIT HERE
	return

MIDI_EVNT_IS_Cx_GO_ON
	;; DO: STORE PROGRAM CHANGE PATCH NUMBER 
	;; (MIDI IN: PRGRAMM CHANGE (PATCH NUMBER))
	movff	MIDI_EVNT1, BNKD_VAR_BROWSE_PATCH_NR
	
	;; DO SET STATE FLAG: 
	;; SET: Patch Change Request Flag (BIT7 @ BNKD_VAR_PATCH_STATE_FLAGS)
	;; BIT7 @ BNKD_VAR_PATCH_STATE_FLAGS = 1 = A MIDI PROGRAM CHANGE EVENT HAS TAKEN PLACE 
	;; (THE PROGRAM CHANGE EVENT HAS BEEN SET)
	;; BIT7 @ BNKD_VAR_PATCH_STATE_FLAGS = 0 = NO PROGRAM CHANGE EVENT 
	;; (THE PROGRAM CHANGE EVENT HAS BEEN CLEARD)
 	movff	BNKD_VAR_PATCH_STATE_FLAGS, VAR_TMP7
 	bsf		VAR_TMP7, BIT7_MIDI_PROGRAMM_CHANGE_RECEIVED
 	movff	VAR_TMP7, BNKD_VAR_PATCH_STATE_FLAGS		

	return

; Channel Pressure
MIDI_EVNT_IS_Dx	
	;; not implemented yet	
	return


;; System Exclusive messages not really supported, sends only the first byte for realtime events
;; SysEx streams etc. have to be send by the user routines
MIDI_EVNT_IS_Fx
	;; not implemented yet	
	return

