;; FUNCTION:
;; PATCH NAME EDITING
;; PATCH NAME = 8x ASC VALUE (8 RAM BYTES)


PATCH_NAME_EDITING
	;; -------------------------------------------------------------------------------
	;; ----------[PATCH NAME EDITING MODE HANDLING (WITH SEL / ESC BTN)       ]-------
	;; ----------[CHECK: DO THE USER WANT TO EXIT PATCH NAME EDITING MODE?    ]-------	
	;; CURRENT BTN = ESC ?
	;; DO EXIT EDITING MODE
	movlw  CONST_BTN_ESC
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; ESC = SET PATCH NAME EDITING MODE = OFF
			goto 	BTN_SUB_ROUTINE_SELECT_MENU_1
			
	;; ----------[CHECK: DO THE USER WANT TO TOGGLE PATCH NAME EDITING MODE? ]-------	
	;; CURRENT BTN = SEL BTN ?
	movlw  CONST_BTN_SEL
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; TOGGLE PATCH NAME EDITING MODE
			;; IF EDITING MODE = OFF: DO SET PATCH NAME EDITING MODE = ON
			;; IF EDITING MODE = ON : DO SET PATCH NAME EDITING MODE = OFF
			goto 	BTN_SUB_ROUTINE_SELECT_MENU_1
	
	;; -----[STATE: THE USER WANT NOT TO EXIT EDIT MODE         ]---------------------
	;; -------------------------------------------------------------------------------
	

	;;------[CHECK: CURRENT MENU = 1?                           ]---------------------
	movlw  CONST_MAIN_MENU_01
	cpfseq VAR_CURRENT_MAIN_MENU
			;; ------[STATE: MAIN MENU < > 1                    ]---------------------
			;; ------[DO: EXIT HERE                             ]---------------------
			return
	
	;; -----[STATE: MAIN MENU = 1                                ]--------------------
	;; -----[CHECK: CURRENT ITEM POS = ITEM 1 = PATCHNAME ?      ]--------------------
	movff 	BNKD_VAR_LCD_CURSOR_POS_MAIN_MENU_PATCH_INFO, VAR_TMP_RAM_BYTE_COPY_CLIPBOARD
	movlw 	CONST_MENU_ITEM_POS1
	cpfseq 	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD
			;; -[STATE: CURSOR POS <> ITEM 1 (PATCHNAME)        ]---------------------
			;; -[DO: EXIT HERE                                  ]---------------------
			return
	
			;; -[STATE: CURSOR POS = ITEM 1 (PATCHNAME)         ]---------------------
			;; -[DO: GO ON                                      ]---------------------

	;; ---[DO: LOAD CURRENT ASC VALUE @ CURRENT PATCH NAME @ CURSOR POS     ]---------
	;; ---[DO WRITE ASC VALUE TO -> BNKD_VAR_CURRENT_ASC_VALUE_PATCH_NAME   ]---------
	call	CURRENT_ASC_VALUE_PATCH_NAME_LOADING
	

;; ---------------------[BTN HANDLING]------------------------------------------------
	
	;; ---[CHECK: WICH BTN HAS BEEN PRESSED?                    ]---------------------
	
	;; LEFT	 -> CURSOR POS = LFT (POS -1)
	movlw  CONST_BTN_POS_LEFT
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; CURSOR POS = CURSER POS -1
			goto	DEC_PATCH_NAME_CURSOR_POS

	;; RIGHT -> CURSOR POS = RGT (POS +1)
	movlw  CONST_BTN_POS_RIGHT
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; CURSOR POS = CURSER POS +1
			goto	INC_PATCH_NAME_CURSOR_POS

	;; VALUE DWN	-> ITEM VALUE -1
	movlw  CONST_BTN_VALUE_DEC
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; CURRENT ASC VALUE = CURRENT ASC VALUE -1
			goto	PATCH_NAME_CURRENT_ASC_CHAR_VALUE_DEC
	
	;; VALUE UP	-> ITEM VALUE +1
	movlw  CONST_BTN_VALUE_INC
	cpfsgt VAR_CURRENT_DIN_BTN_VALUE
			;; CURRENT ASC VALUE = CURRENT ASC VALUE +1
			goto	PATCH_NAME_CURRENT_ASC_CHAR_VALUE_INC

	;; NO BTN MATCH, SO EXIT HERE
	return

;; --------------------------------------------------------------------------------------------------


;; --------------------------------------------------------------------------------------------------
;; -------------[Start of PATCH NAME EDITING Routines                    ]---------------------------
;; --------------------------------------------------------------------------------------------------

;; -------------[BTN [+] VALUE -> INC ASC VALUE                          ]---------------------------
PATCH_NAME_CURRENT_ASC_CHAR_VALUE_INC
	;;	ASC CHAR VALUE = ASC CHAR VALUE +1
	movff 	BNKD_VAR_CURRENT_ASC_VALUE_PATCH_NAME, VAR_TMP_RAM_BYTE_COPY_CLIPBOARD
	incf	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, F
	
	movlw	CONST_PATCH_NAME_ASC_MIN_VALUE
	cpfslt	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD	;; CURRENT ASC VALUE < "0"
			;; NO
			rgoto PATCH_NAME_CURRENT_ASC_CHAR_VALUE_INC_CHK_JMP
			
			;; YES
			;; WRITE "0" to CURRENT ASC VALUE
			movlw	CONST_PATCH_NAME_ASC_MIN_VALUE
			movwf	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD
			rgoto 	PATCH_NAME_CURRENT_ASC_CHAR_VALUE_INC_FINISH
			
PATCH_NAME_CURRENT_ASC_CHAR_VALUE_INC_CHK_JMP
	;; MEMO:
	;; USER WILL HAVE JUST ASC VALUES AS [0-9] and [A-Z]
	;; NO OTHER ASC VALUES ARE VALID HERE
	;; AFTER ASC "9" ASC = ":" WILL BE THERE
	;; IF ASC = ":" JUMP AND LOAD ASC "A" AS CURRENT ASC VALUE
	movlw	CONST_PATCH_NAME_ASC_JMP_TO_ASC_A_VALUE
	cpfseq	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD
		;; NO JMP
		rgoto PATCH_NAME_CURRENT_ASC_CHAR_VALUE_INC_CHK_Z
		;; DO JMP
		rgoto PATCH_NAME_CURRENT_ASC_CHAR_VALUE_INC_JMP_A_ASC
		
PATCH_NAME_CURRENT_ASC_CHAR_VALUE_INC_JMP_A_ASC
		;; JMP from ":" -> "A"
		;; WRITE "A" TO BNKD_VAR_CURRENT_ASC_VALUE_PATCH_NAME
		movlw	CONST_PATCH_NAME_ASC_A_VALUE
		movwf	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD

PATCH_NAME_CURRENT_ASC_CHAR_VALUE_INC_CHK_Z
		;; -[CHECK: ASC VALUE > "Z" ?        ]--------------------------------------------------------
		movlw	CONST_PATCH_NAME_ASC_MAX_VALUE_Z
		cpfsgt	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD
				;; NO
				rgoto	PATCH_NAME_CURRENT_ASC_CHAR_VALUE_INC_FINISH
			;; YES, GO ON
			;; WRITE ASC "Z" = CURRENT ASC VALUE
			movlw	CONST_PATCH_NAME_ASC_MAX_VALUE_Z
			movwf	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD

PATCH_NAME_CURRENT_ASC_CHAR_VALUE_INC_FINISH
		;; WRITE TMP VAR TO BNKD_VAR_CURRENT_ASC_VALUE_PATCH_NAME
		movff 	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, BNKD_VAR_CURRENT_ASC_VALUE_PATCH_NAME
		;; GO AND WRITE CURRENT ASC VALUE TO PATCH NAME VAR
		rgoto 	ONE_ASC_VALUE_PATCH_NAME_WRITING

;; --------------------------------------------------------------------------------------------------


;; ------------[[-] BTN HAS BEEN PRESSED -> DEC ASC VALUE]--------------------------------------------
PATCH_NAME_CURRENT_ASC_CHAR_VALUE_DEC
	;; ---[DO: CURRENT ASC VALUE -1            ]------------------------------------------------------
	;; CURRENT ASC VALUE = CURRENT ASC VALUE -1
	movff 	BNKD_VAR_CURRENT_ASC_VALUE_PATCH_NAME, VAR_TMP_RAM_BYTE_COPY_CLIPBOARD
	decf	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, F
	
	;; BIGGEST VALID ASV VALUE = "Z"
	;; CHK: CURRENT ASC VALUE > ASC "Z" ?
	movlw	CONST_PATCH_NAME_ASC_MAX_VALUE_Z
	cpfsgt	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD
		;; NO
		;; GO AND CHECK IF ASC VALUE < "0"
		rgoto	PATCH_NAME_CURRENT_ASC_CHK_ASC_LT_0

		;; YES
		;; MOV ASC VALUE "Z" TO CURRENT ASC VALUE 
		movlw	CONST_PATCH_NAME_ASC_MAX_VALUE_Z
		movwf	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD
		rgoto	PATCH_NAME_CURRENT_ASC_CHAR_VALUE_DEC_FINISH
			
PATCH_NAME_CURRENT_ASC_CHK_ASC_LT_0
		;; CHK ASC < "0"
		movlw	CONST_PATCH_NAME_ASC_MIN_VALUE
		cpfslt	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD
			;; NO, DO CHK ASC = "@"
			rgoto PATCH_NAME_CURRENT_ASC_CHK_ASC_AT
			;; Yes, DO RESET ASC to "0"
			rgoto PATCH_NAME_CURRENT_ASC_CHAR_VALUE_INC_JMP_0_ASC
		
PATCH_NAME_CURRENT_ASC_CHK_ASC_AT
		;; CHECK IF THERE IS A JMP CASE
		;; CHECK IF THERE IS A JMP FROM ASC "@" -> ASC "9"
		;; CHECK: CURRENT ASC VALUE = "@"?
		movlw	CONST_PATCH_NAME_ASC_JMP_TO_ASC_9_VALUE
		cpfseq	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD
			;; NO
			rgoto	PATCH_NAME_CURRENT_ASC_CHAR_VALUE_DEC_FINISH
			;; YES, WRITE ASC "9" TO CURRENT ASC VALUE
			movlw	CONST_PATCH_NAME_ASC_9_VALUE
			movwf	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD
			rgoto	PATCH_NAME_CURRENT_ASC_CHAR_VALUE_DEC_FINISH
			
PATCH_NAME_CURRENT_ASC_CHAR_VALUE_INC_JMP_0_ASC
		;; JMP to -> "0"
		;; WRITE "0" TO BNKD_VAR_CURRENT_ASC_VALUE_PATCH_NAME
		movlw	CONST_PATCH_NAME_ASC_MIN_VALUE
		movwf	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD
		
PATCH_NAME_CURRENT_ASC_CHAR_VALUE_DEC_FINISH
		movff 	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, BNKD_VAR_CURRENT_ASC_VALUE_PATCH_NAME
		;; GO AND WRITE CURRENT ASC VALUE TO PATCH NAME VAR
		rgoto 	ONE_ASC_VALUE_PATCH_NAME_WRITING


;; --------------------------------------------------------------------------------------------------

;; ----[WRITE THE CURRENT ASC VALUE @ THE CURRENT CURSOR POS TO THE PATCH NAME ]---------------------
ONE_ASC_VALUE_PATCH_NAME_WRITING
		movff 	BNKD_VAR_POS_CURSOR_PATCH_NAME, VAR_TMP_RAM_BYTE_COPY_CLIPBOARD
		movf 	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, W
		JUMPTABLE_2BYTES 8        ; (PATCH NAME = 8 ASC VALUES)
				rgoto        WRITE_BNKD_VAR_POS_CURSOR_PATCH_NAME1
 				rgoto        WRITE_BNKD_VAR_POS_CURSOR_PATCH_NAME2
 				rgoto        WRITE_BNKD_VAR_POS_CURSOR_PATCH_NAME3
 				rgoto        WRITE_BNKD_VAR_POS_CURSOR_PATCH_NAME4
 				rgoto        WRITE_BNKD_VAR_POS_CURSOR_PATCH_NAME5
 				rgoto        WRITE_BNKD_VAR_POS_CURSOR_PATCH_NAME6
 				rgoto        WRITE_BNKD_VAR_POS_CURSOR_PATCH_NAME7
 				rgoto        WRITE_BNKD_VAR_POS_CURSOR_PATCH_NAME8

WRITE_BNKD_VAR_POS_CURSOR_PATCH_NAME1
	movff BNKD_VAR_CURRENT_ASC_VALUE_PATCH_NAME, BNKD_VAR_PATCH_NAME_ASC_0
		rgoto WRITE_ASC_VALUE_PATCH_NAME_ON_LCD

WRITE_BNKD_VAR_POS_CURSOR_PATCH_NAME2
	movff BNKD_VAR_CURRENT_ASC_VALUE_PATCH_NAME, BNKD_VAR_PATCH_NAME_ASC_1
		rgoto WRITE_ASC_VALUE_PATCH_NAME_ON_LCD

WRITE_BNKD_VAR_POS_CURSOR_PATCH_NAME3
	movff BNKD_VAR_CURRENT_ASC_VALUE_PATCH_NAME, BNKD_VAR_PATCH_NAME_ASC_2
		rgoto WRITE_ASC_VALUE_PATCH_NAME_ON_LCD

WRITE_BNKD_VAR_POS_CURSOR_PATCH_NAME4
	movff BNKD_VAR_CURRENT_ASC_VALUE_PATCH_NAME, BNKD_VAR_PATCH_NAME_ASC_3
		rgoto WRITE_ASC_VALUE_PATCH_NAME_ON_LCD

WRITE_BNKD_VAR_POS_CURSOR_PATCH_NAME5
	movff BNKD_VAR_CURRENT_ASC_VALUE_PATCH_NAME, BNKD_VAR_PATCH_NAME_ASC_4
		rgoto WRITE_ASC_VALUE_PATCH_NAME_ON_LCD

WRITE_BNKD_VAR_POS_CURSOR_PATCH_NAME6
	movff BNKD_VAR_CURRENT_ASC_VALUE_PATCH_NAME, BNKD_VAR_PATCH_NAME_ASC_5
		rgoto WRITE_ASC_VALUE_PATCH_NAME_ON_LCD

WRITE_BNKD_VAR_POS_CURSOR_PATCH_NAME7
	movff BNKD_VAR_CURRENT_ASC_VALUE_PATCH_NAME, BNKD_VAR_PATCH_NAME_ASC_6
		rgoto WRITE_ASC_VALUE_PATCH_NAME_ON_LCD

WRITE_BNKD_VAR_POS_CURSOR_PATCH_NAME8
	movff BNKD_VAR_CURRENT_ASC_VALUE_PATCH_NAME, BNKD_VAR_PATCH_NAME_ASC_7
		rgoto WRITE_ASC_VALUE_PATCH_NAME_ON_LCD

;; ----[WRITE THE CURRENT ASC VALUE @ THE CURRENT CURSOR POS TO LCD     ]---------------------
WRITE_ASC_VALUE_PATCH_NAME_ON_LCD
		 	;; ----[STATE: MENU1                                        ]---------------------
			;; ----[STATE: PATCH NAME IS @ LCD ROW1                     ]---------------------
			;; ----[DO SET CURSOR                                       ]---------------------
		 	movlw 	LCD_ROW1 + 8 
		 	movff 	BNKD_VAR_POS_CURSOR_PATCH_NAME, VAR_TMP_RAM_BYTE_COPY_CLIPBOARD
			addwf   VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, W
		 	call    MIOS_LCD_CursorSet
		 	;; ----[DO: WRITE ASCII CHAR ON LCD                         ]---------------------
		 	movff   BNKD_VAR_CURRENT_ASC_VALUE_PATCH_NAME, VAR_TMP_RAM_BYTE_COPY_CLIPBOARD
		 	movf 	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, W
		 	call    MIOS_LCD_PrintChar
		 	
		 	;; ----[DO: BLINKING CSR HANDLING                           ]---------------------
		 	;; -------------------------------------------------------------------------------
			movff	BNKD_VAR_POS_CURSOR_PATCH_NAME, VAR_CURSOR_BLINKING_POS
			movlw 	0x08	;; +OFFSET (PATCH NAME LCD POSITION) 
			addwf	VAR_CURSOR_BLINKING_POS, F
			movff	BNKD_VAR_CURRENT_ASC_VALUE_PATCH_NAME, VAR_CURSOR_BLINKING_CSR_CHAR
			;; ----[END BLINKING CSR HANDLING                           ]---------------------
			;; -------------------------------------------------------------------------------

			;; ----[DO: SET THE "PATCH NAME WAS EDITED" BIT5            ]---------------------
			;; THE USER EDITED THE PATCH NAME
			movff	BNKD_VAR_PATCH_STATE_FLAGS, VAR_TMP_RAM_BYTE_COPY_CLIPBOARD
			bsf		VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, BIT5_PATCH_NAME_WAS_EDITED_BY_USER
			movff	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, BNKD_VAR_PATCH_STATE_FLAGS

			;; ----[CHECK: CSR POS PATCH NAME > 7 (PATCH_NAME_CURSOR_POS_MAX)? ]--------------
			movff	BNKD_VAR_POS_CURSOR_PATCH_NAME, VAR_TMP_RAM_BYTE_COPY_CLIPBOARD
			movlw 	CONST_PATCH_NAME_CURSOR_POS_MAX
			cpfsgt 	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD
					;; NO,
					;; OK - JUST EXIT HERE
					return

					;; YES,
					;; WRITE PATCH_NAME_CURSOR_POS_MAX to CURSOR PATCH NAME POS
					movlw CONST_PATCH_NAME_CURSOR_POS_MAX
					movwf VAR_TMP_RAM_BYTE_COPY_CLIPBOARD
					movff VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, BNKD_VAR_POS_CURSOR_PATCH_NAME
					;; ----[DO: BLINKING CSR HANDLING                           ]---------------------
					movff	BNKD_VAR_POS_CURSOR_PATCH_NAME, VAR_CURSOR_BLINKING_POS
					movlw 	0x08	;; +OFFSET (PATCH NAME LCD POSITION) 
					addwf	VAR_CURSOR_BLINKING_POS, F
					;; EXIT HERE
			 		return



;; ---------------------------------------------------------------------------------------------------

;; -------------------------[PATCH NAME CSR POS +1  ]------------------------------------------------
INC_PATCH_NAME_CURSOR_POS
	;; INC BNKD_VAR_POS_CURSOR_PATCH_NAME [0-7]
	;; IF BNKD_VAR_POS_CURSOR_PATCH_NAME = 7 (CURSOR POS MAX) do not inc
	movff BNKD_VAR_POS_CURSOR_PATCH_NAME, VAR_TMP_RAM_BYTE_COPY_CLIPBOARD
	
	movlw 	CONST_PATCH_NAME_CURSOR_POS_MAX
	cpfseq 	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD
	
		;; NO, POS is not 7 (CURSOR POS MAX)
		rgoto DO_INC_PATCH_NAME_CURSOR_POS

		;; YES = CURSOR POS MAX
		;; DO NOT INC CURSOR POS
		return

DO_INC_PATCH_NAME_CURSOR_POS
	;; ------[CSR HANDLING                                        ]----
	;; ------[IF THERE IS A "BLACK CSR" WRITE ASC VALUE           ]----
	;; ------[DO REWRITE CURRENT ASC CHAR @ CURRENT CSR POS FIRST ]----
	movff	VAR_CURSOR_BLINKING_POS, WREG
	call    MIOS_LCD_CursorSet
    movff	VAR_CURSOR_BLINKING_CSR_CHAR, WREG
    call    MIOS_LCD_PrintChar
    
	;; ------[DO: INC CSR POS @ PATCH NAME +1         ]----------
	incf VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, F
	movff VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, BNKD_VAR_POS_CURSOR_PATCH_NAME

	;; ------[BLINKING CSR HANDLING                   ]----------
	;; ------[DO: SET BLINKING CSR NEW POS            ]----------
	movff	BNKD_VAR_POS_CURSOR_PATCH_NAME, VAR_CURSOR_BLINKING_POS
	movlw	0x08		;; +OFFSET (PATCH NAME LCD POSITION) 
	addwf	VAR_CURSOR_BLINKING_POS, F
	;; ------[SET CURRENT BLINKING CSR ASC VALUE      ]----------
	;; ------[DO: LOAD CURRENT ASC VALUE              ]----------
	call	CURRENT_ASC_VALUE_PATCH_NAME_LOADING
	;; ------[DO WRITE ASC TO BLINKING CSR ASC VALUE  ]----------
	movff	BNKD_VAR_CURRENT_ASC_VALUE_PATCH_NAME, VAR_CURSOR_BLINKING_CSR_CHAR
	;; ----------------------------------------------------------

	return


;; -------------------------[PATCH NAME CSR POS -1  ]-------------------------------------------------
DEC_PATCH_NAME_CURSOR_POS
	;; DEC BNKD_VAR_POS_CURSOR_PATCH_NAME [0-7]
	;; IF BNKD_VAR_POS_CURSOR_PATCH_NAME = 0 DO NOT DEC
	movff 	BNKD_VAR_POS_CURSOR_PATCH_NAME, VAR_TMP_RAM_BYTE_COPY_CLIPBOARD
	clrw 	
	cpfseq 	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD
	
		;; NO, POS is not 0
		;; SO IT'S ALLRIGHT TO DEC CURSOR POS -1
		rgoto DO_DEC_PATCH_NAME_CURSOR_POS

		;; YES
		;; DO NOT DEC POS
		return

DO_DEC_PATCH_NAME_CURSOR_POS	
	;; ------[CSR HANDLING                                        ]----
	;; ------[IF THERE IS A "BLACK CSR" WRITE ASC VALUE           ]----
	;; ------[DO REWRITE CURRENT ASC CHAR @ CURRENT CSR POS FIRST ]----
	movff	VAR_CURSOR_BLINKING_POS, WREG
	call    MIOS_LCD_CursorSet
    movff	VAR_CURSOR_BLINKING_CSR_CHAR, WREG
    call    MIOS_LCD_PrintChar

	;; ------[DO: DEC CSR POS @ PATCH NAME -1         ]----------
	decf 	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, F
	movff 	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, BNKD_VAR_POS_CURSOR_PATCH_NAME

	;; ------[CSR HANDLING                                    ]----
	;; ------[DO: SET THE NEW BLINKING CSR POS                ]----------
	movff	BNKD_VAR_POS_CURSOR_PATCH_NAME, VAR_CURSOR_BLINKING_POS
	movlw	0x08		;; +OFFSET (PATCH NAME LCD POSITION) 
	addwf	VAR_CURSOR_BLINKING_POS, F
	;; ------[SET CURRENT BLINKING CSR ASC VALUE      ]----------
	;; ------[DO: LOAD CURRENT ASC VALUE              ]----------
	call	CURRENT_ASC_VALUE_PATCH_NAME_LOADING
	;; ------[DO WRITE ASC TO BLINKING CSR ASC VALUE  ]----------
	movff	BNKD_VAR_CURRENT_ASC_VALUE_PATCH_NAME, VAR_CURSOR_BLINKING_CSR_CHAR
	;; -----------------------------------------------------------
	
	return



;; ---------------------------------------------------------------------------------------------------
;; ----------------------------[    SUB ROUTINE CALL   ]----------------------------------------------
;; FUNCTION:
;; WRITE CURRENT ASC VALUE @ THE CURRENT CURSOR POS TO BNKD_VAR_CURRENT_ASC_VALUE_PATCH_NAME
CURRENT_ASC_VALUE_PATCH_NAME_LOADING
		movff 	BNKD_VAR_POS_CURSOR_PATCH_NAME, VAR_TMP_RAM_BYTE_COPY_CLIPBOARD
		movf 	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, W
		JUMPTABLE_2BYTES 8        ; THERE ARE 8 CURSOR POS @ THE PATCH NAME
				rgoto        LOAD_ASC_VALUE_PATCH_NAME_POS1
 				rgoto        LOAD_ASC_VALUE_PATCH_NAME_POS2
 				rgoto        LOAD_ASC_VALUE_PATCH_NAME_POS3
 				rgoto        LOAD_ASC_VALUE_PATCH_NAME_POS4
 				rgoto        LOAD_ASC_VALUE_PATCH_NAME_POS5
 				rgoto        LOAD_ASC_VALUE_PATCH_NAME_POS6
 				rgoto        LOAD_ASC_VALUE_PATCH_NAME_POS7
 				rgoto        LOAD_ASC_VALUE_PATCH_NAME_POS8

LOAD_ASC_VALUE_PATCH_NAME_POS1
	movff BNKD_VAR_PATCH_NAME_ASC_0, BNKD_VAR_CURRENT_ASC_VALUE_PATCH_NAME
	return

LOAD_ASC_VALUE_PATCH_NAME_POS2
	movff BNKD_VAR_PATCH_NAME_ASC_1, BNKD_VAR_CURRENT_ASC_VALUE_PATCH_NAME
	return

LOAD_ASC_VALUE_PATCH_NAME_POS3
	movff BNKD_VAR_PATCH_NAME_ASC_2, BNKD_VAR_CURRENT_ASC_VALUE_PATCH_NAME
	return

LOAD_ASC_VALUE_PATCH_NAME_POS4
	movff BNKD_VAR_PATCH_NAME_ASC_3, BNKD_VAR_CURRENT_ASC_VALUE_PATCH_NAME
	return

LOAD_ASC_VALUE_PATCH_NAME_POS5
	movff BNKD_VAR_PATCH_NAME_ASC_4, BNKD_VAR_CURRENT_ASC_VALUE_PATCH_NAME
	return

LOAD_ASC_VALUE_PATCH_NAME_POS6
	movff BNKD_VAR_PATCH_NAME_ASC_5, BNKD_VAR_CURRENT_ASC_VALUE_PATCH_NAME
	return

LOAD_ASC_VALUE_PATCH_NAME_POS7
	movff BNKD_VAR_PATCH_NAME_ASC_6, BNKD_VAR_CURRENT_ASC_VALUE_PATCH_NAME
	return

LOAD_ASC_VALUE_PATCH_NAME_POS8
	movff BNKD_VAR_PATCH_NAME_ASC_7, BNKD_VAR_CURRENT_ASC_VALUE_PATCH_NAME
	return

;; ----------------------------[ END SUB ROUTINE CALL  ]----------------------------------------------
;; ---------------------------------------------------------------------------------------------------

