;; fx_pipeline.inc
;; ---------------
;; fucnction: perform fx routines if fx tab mode @ a|b|c is on
;; this function is called by USER_Tick periodically
;; 
;; USES:
;;	*	BNKD_VAR_Fx_MIDI_NOTE_ON_OR_OFF
;;	*	BNKD_VAR_FX_USER_ON_OFF_ABC
;;	*	BNKD_VAR_FX_MIDI_NOTE_ON_SESSION
;;	*	BNKD_VAR_FX_PIPELINE_SESSION_NUMBER
;;	*	BNKD_VAR_FX_TIMER
;;	*	BNKD_VAR_STATE_FX_NOP_MODE
;;	* 	VAR_FX_TAB_ENTRY_CURRENT_TIME_PRE_EXECUTION
;;	*	VAR_FX_TAB_ENTRY_CURRENT_FUNCTION
;;  *   VAR_FX_TAB_ENTRY_CURRENT_PARAM
;;	... FX_FUNC_000 - FX_FUNC_041 {....}

FX_PIPELINE
	;; JUMPED IN HERE FROM main.asm @ USER_Tick
	;; ------------------------------------------------ 
	
	;; CHECK IF FX TAB @ A|B|C = ON ?
	;; CURRENT MIDI CH ABC          [x|x|x|x|x|x|C|B|A]
	;; USER FX TAB ON or OFF      @ [x|x|x|x|x|x|C|B|A]
	movff	BNKD_VAR_Fx_MIDI_NOTE_ON_OR_OFF, TMP4
	movff	BNKD_VAR_FX_USER_ON_OFF_ABC, TMP5
	movf	TMP4, W
	;; AND (Boolean expression)
	;; NOTE ON                 A|B|C
	;; USER FX TAB ON or OFF   A|B|C
	andwf	TMP5, W
	;; STORE RESULT IN CLIPBOARD
	movwf	TMP4
		;; GO ON WITH FX PROZESSING IF:
		;; 			A|B|C 	NOTE 		ON 
		;; MATCH  	A|B|C 	Fx User 	ON 
		;; ELSE EXIT FX PROZESSING
		;; --------------------------------------
		;; RESULT > 0?
		clrw
		cpfsgt TMP4
			;; NO, 
			;; RESULT = 0
			;; USER adjustment FX TAB = OFF @ A|B|C
			;; NO FX TAB ACTION HERE
			return

			;; YES 
			;; LET's GO ON WITH FX PROCESSING

	;; ---[STATE: THERE IS A *NOTE ON* MIDI EVENT   ]------------------------------------
	;; ---[STATE: FX TAB = ON @ A|B|C               ]------------------------------------
	;; ---[CHECK: IS THERE A NEW FX TAB SESSION ?   ]------------------------------------
	;;    NOTE:
	;;    THERE IS A NEW NEW FX TAB SESSION VALUE with every new NOTE ON EVENT
	;;	  SEE note_on_pipeline_a.inc, note_on_pipeline_b.inc, note_on_pipeline_c.inc
	movff	BNKD_VAR_FX_MIDI_NOTE_ON_SESSION,    TMP4
	movff	BNKD_VAR_FX_PIPELINE_SESSION_NUMBER, TMP5
	movf 	TMP4, W		;; = BNKD_VAR_FX_MIDI_NOTE_ON_SESSION
	cpfseq 	TMP5		;; = BNKD_VAR_FX_PIPELINE_SESSION_NUMBER
		;; NO, 
		;; ---[STATE: FX NOTE ON SESSION <> FX PIPELINE SESSION   ]---------------------
		;; ---[STATE: THERE MUST HAVE BEEN ANOTHER NOTE ON EVENT  ]--------------------- 
		;; ---[NEXT: DO REFRESH FX SESSION                        ]---------------------
		rgoto FX_NEW_SESSION_RESET_POS

		;; YES,
		;; ---[STATE: FX NOTE ON SESSION = FX PIPELINE SESSION    ]---------------------
		;; ---[STATE: WE CAN GO ON WITH FX TAB PROCESSING         ]---------------------
		;; ---[BUT FIRST WE HAVE TO CHECK IF FX TAB POS > 31      ]---------------------
		rgoto CHECK_IF_FX_POS_CURRENT_SESSION_IS_NOP


FX_NEW_SESSION_RESET_POS
		;; -------[STATE: THERE MUST HAVE BEEN ANOTHER NOTE ON EVENT  ]---------------------
		;; -------[DO: REFRESH FX PIPELINE SESSION                    ]---------------------
		movff	BNKD_VAR_FX_MIDI_NOTE_ON_SESSION, BNKD_VAR_FX_PIPELINE_SESSION_NUMBER
		;; -------[DO: RESET CURRENT FX TAB POS                       ]---------------------
		clrf	VAR_POINTER_TO_CURRENT_FX_TAB_ENTRY									
		;; -------[DO: RESET FX Timer                                 ]---------------------
		clrf 	TMP4								
		movff	TMP4, BNKD_VAR_FX_TIMER
		;; -------[DO RESET NOP MODE = OFF                            ]---------------------
		clrf 	TMP4
		movff	TMP4, BNKD_VAR_STATE_FX_NOP_MODE	
		;; -------[NEXT: LOAD FX TAB ENTRY                            ]---------------------
		rgoto LOAD_FX_TAB_ENTRY_CURRENT_POS


CHECK_IF_FX_POS_CURRENT_SESSION_IS_NOP
		;; -------[CHECK IF CURRENT FX TAB ENTRY = NOP (NO OPERATION) ]---------------------
		;; NOTE: 
		;; = 0 = Fx NOP IS OF (FX OPERATION IS ON)
		;; > 0 = Fx NOP IS ON (FX OPERATION IS OFF)
		movff	BNKD_VAR_STATE_FX_NOP_MODE, TMP4
		clrw 	
		cpfseq 	TMP4	;; = BNKD_VAR_STATE_FX_NOP_MODE
		
			;; NO,
			;; ---[STATE: NOP MODE = ON            ]----
			;; NOTE: NOP MODE ON = DO NO FX PROCESSING
			;; SO EXIT HERE 
			return

			;; YES,
			;; ---[STATE: NOP MODE = OFF               ]----
			;; ---[DO: GO ON WITH FX TAB PROCESSING    ]---- 
LOAD_FX_TAB_ENTRY_CURRENT_POS
	;; UPDATE CURRENT Fx 
	;; POINTER TO FX SESSION CURRENT POS [Pos Range: 0 to 31]
	;; --------------------------------------------------------------------------------------------------
	;; LOAD:
	;; VAR_FX_TAB_ENTRY_CURRENT_FUNCTION				@ THE CURRENT Fx POS = VAR_POINTER_TO_CURRENT_FX_TAB_ENTRY
	;; VAR_FX_TAB_ENTRY_CURRENT_TIME_PRE_EXECUTION		@ THE CURRENT Fx POS = VAR_POINTER_TO_CURRENT_FX_TAB_ENTRY
	;; VAR_FX_TAB_ENTRY_CURRENT_PARAM					@ THE CURRENT Fx POS = VAR_POINTER_TO_CURRENT_FX_TAB_ENTRY
	call LOAD_FX_TAB_CURRENT_ENTRY		
	
		
	;; ----[CHECK THE FX TAB POS DELAY TIME PERIOD        ]----------------------------------------------
	;; ----[USE THE FX TIMER                              ]----------------------------------------------
	;; PRINCIPLE: 
	;; IS Fx Timer (triggert by Timer0) [0-255] > VAR_FX_TAB_ENTRY_CURRENT_TIME_PRE_EXECUTION [0-200]
	;; ----[CHECK: FX TIMER > FX TAB ENTRY DELAY ?        ]----------------------------------------------
	movff	BNKD_VAR_FX_TIMER, TMP4
	movf 	VAR_FX_TAB_ENTRY_CURRENT_TIME_PRE_EXECUTION, W
	cpfsgt 	TMP4				  ;; = FX_TIMER
		;; NO,
		;; ---[STATE: CURRENT Fx Pre Delay Time takes more Timer0 Cycles ]-------------------------------
		;; ---[DO: EXIT HERE AND HAVE A NOTHER TRY                       ]-------------------------------
		return

	;; YES,
	;; -------[STATE: FX TIMER > VAR_FX_TAB_ENTRY_CURRENT_TIME_PRE_EXECUTION ]-----------------------------
	;; -------[DO: EXECUTE CURRENT FX TAB FUNCTION                         ]-----------------------------

	;; Fx Functions
	;; ------------------------
	;; FUNCTIONS [0x00 to 0x25]
	;; ------------------------
	;; 0  0x00 => End FX TAB PROCESSING	(Fx Off)
	;; 1  0x01 => On  Tone A		
	;; 2  0x02 => Off Tone A
	;; 3  0x03 => On  Tone B
	;; 4  0x04 => Off Tone B
	;; 5  0x05 => On  Tone C
	;; 6  0x06 => Off Tone C
	;; 7  0x07 => +Tune A	[Data: 0-255]
	;; 8  0x08 => -Tune A	[Data: 0-255]
	;; 9  0x09 => +Tune B	[Data: 0-255]
	;; 10 0x0A => -Tune B	[Data: 0-255]
	;; 11 0x0B => +Tune C	[Data: 0-255]
	;; 12 0x0C => -Tune C	[Data: 0-255]
	;; 13 0x0D => Vol.A	[Data: 0-15] (This function overrides the ENVELOPE Mode during the Fx period)
	;; 14 0x0E => Vol.B	[Data: 0-15] (This function overrides the ENVELOPE Mode during the Fx period)
	;; 15 0x0F => Vol.C	[Data: 0-15] (This function overrides the ENVELOPE Mode during the Fx period)
	;; 16 0x10 => On  Noise A
	;; 17 0x11 => Off Noise A
	;; 18 0x12 => On  Noise B
	;; 19 0x13 => Off Noise B
	;; 20 0x14 => On  Noise C 
	;; 21 0x15 => Off Noise C
	;; 22 0x16 => Noise Frq. [Data: 0-31]
	;; 23 0x17 => ENV ON  A
	;; 24 0x18 => ENV OFF A
	;; 25 0x19 => ENV ON  B
	;; 26 0x1A => ENV OFF B
	;; 27 0x1B => ENV ON  C
	;; 28 0x1C => ENV OFF C
	;; 29 0x1D => ENV Shape	[Data: 0-15]
	;; 30 0x1E => ENV Fine	[Data: 0-255]
	;; 31 0x1F => ENV Coar	[Data: 0-255]
	;; 32 0x20 => WRITE NOTE ON #1 ==> Tone A
	;; 33 0x21 => WRITE NOTE ON #2 ==> Tone A
	;; 34 0x22 => WRITE NOTE ON #3 ==> Tone A
	;; 35 0x23 => WRITE NOTE ON #1 ==> Tone B
	;; 36 0x24 => WRITE NOTE ON #2 ==> Tone B
	;; 37 0x25 => WRITE NOTE ON #3 ==> Tone B
	;; 38 0x26 => WRITE NOTE ON #1 ==> Tone C
	;; 39 0x27 => WRITE NOTE ON #2 ==> Tone C
	;; 40 0x28 => WRITE NOTE ON #3 ==> Tone C
	;; 41 0x29 => GOTO Fx POS [Data: 0-31]

	;; JUMP TO THE CURRENT FX TAB FUNCTION
	movf VAR_FX_TAB_ENTRY_CURRENT_FUNCTION, W
	JUMPTABLE_4BYTES 42 ;; [0 to 41]
        	goto        FX_FUNC_000 ;;   0x00	End Fx (Fx Off)
        	goto        FX_FUNC_001 ;;   0x01	On  Tone A
        	goto        FX_FUNC_002 ;;   0x02	Off Tone A
        	goto        FX_FUNC_003 ;;   0x03	On  Tone B
        	goto        FX_FUNC_004 ;; 	 ...	Off Tone B
        	goto        FX_FUNC_005 ;; 			On  Tone C
        	goto        FX_FUNC_006 ;; 			Off Tone C
        	goto        FX_FUNC_007 ;; 			...
        	goto        FX_FUNC_008
        	goto        FX_FUNC_009
        	goto        FX_FUNC_010
        	goto        FX_FUNC_011
        	goto        FX_FUNC_012
        	goto        FX_FUNC_013
        	goto        FX_FUNC_014
        	goto        FX_FUNC_015
        	goto        FX_FUNC_016
        	goto        FX_FUNC_017
        	goto        FX_FUNC_018
			goto        FX_FUNC_019
			goto        FX_FUNC_020
			goto        FX_FUNC_021
			goto        FX_FUNC_022
			goto        FX_FUNC_023
			goto        FX_FUNC_024
			goto        FX_FUNC_025
			goto        FX_FUNC_026
			goto        FX_FUNC_027
			goto        FX_FUNC_028
			goto        FX_FUNC_029
			goto        FX_FUNC_030
			goto        FX_FUNC_031
			goto        FX_FUNC_032
			goto        FX_FUNC_033
			goto        FX_FUNC_034
			goto        FX_FUNC_035
			goto        FX_FUNC_036
			goto        FX_FUNC_037
			goto        FX_FUNC_038
			goto        FX_FUNC_039
			goto        FX_FUNC_040
			goto        FX_FUNC_041


FX_FUNC_000
	;; 0x00 => End Fx (Fx Off)
	;; Do NOTHING and Quit Here
	return
	
FX_FUNC_001	
	;; 0x01 => On Tone A
	;; TONE A ON

	;; USER SETTING FILTER 
	;; MIDI TONE ON FILTER 
	;; OR ==> VAR_AY_CHIP_REG7_ENABLE_ABC_NOISE_IO
	
	
	;; USER SETTING => TONE A|B|C ON/OFF [FILTER]:
	;; move USER SWITCH settings to W REG
	movf VAR_TONE_NOISE_ABC_USER_ON_OFF_SWITCH, W 
			;; ABC TONE + NOISE ON/OFF USER SWITCH
			;; USER CLEAR or SET A BIT BY SWITCHING
			;; TONE/NOISE A/B/C 

	;; MIDI EVENT FILTER:
	;; *OR* [VAR_TONE_NOISE_ABC_USER_ON_OFF_SWITCH] WITH [MIDI_TONE_ABC_ON_OFF]
	;; MEMO: => MIDI EVENTS SET OR CLEAR BITS @ MIDI_TONE_ABC_ON_OFF
	;; MEMO: => CLEAR BIT = [TONE / NOISE] *ON*
	 
	
	iorwf MIDI_TONE_ABC_ON_OFF, W	
		;; OR VAR_TONE_NOISE_ABC_USER_ON_OFF_SWITCH
		;; WITH MIDI_TONE_ABC_ON_OFF
		;; NOW JUST THE RIGHT TONE/NOISE IS SWITCHED
		;; MOVE THE RESULT TO W REG
	
        ;; WRITE W REG TO THE SHADOW AY CHIP REG 7 
        ;; ==> VAR_AY_CHIP_REG7_ENABLE_ABC_NOISE_IO
        movwf VAR_AY_CHIP_REG7_ENABLE_ABC_NOISE_IO

	;; TONE A ON
	movff 	VAR_AY_CHIP_REG7_ENABLE_ABC_NOISE_IO, BNKD_VAR_Fx_TEMP
	movff	BNKD_VAR_Fx_TEMP, TMP4
	bcf  	TMP4, BIT0_TONE_A_ON_OFF	
	movff	TMP4, BNKD_VAR_Fx_TEMP
	
		;; SEND DATA TO AY REG 7 (AY Chip)
		movlw CONST_AY_CHIP_ADR_07_TONE_NOISE_ON_OFF	; REG ADRESS 	=> AY REGISTER FOR AY CHIP REG 7
		movwf VAR_AY_CHIP_REG_ADDRESS 					; ADDRESS FOR 	=> AY_SR_Write
        
        	;; COPY DATA
        	movff BNKD_VAR_Fx_TEMP, VAR_AY_CHIP_REG_DATA
        
		;; --------------[SEND DATA TO AY REG 7]-----------------------------------------------------
		call LABEL_AY_SR_Write	; WRITING 8BIT DATA (VAR_AY_CHIP_REG_ADDRESS, VAR_AY_CHIP_REG_DATA)TO AY REG(X) ROUTINE
		;; ==========================================================================================	
		
			goto INC_FX_POS_FOR_THE_NEXT_FX_EXECUTION

FX_FUNC_002
	;; 0x02 => Off Tone A
	;; TONE A OFF
	
	
	;; USER SETTING FILTER 
	;; MIDI TONE ON FILTER 
	;; OR ==> VAR_AY_CHIP_REG7_ENABLE_ABC_NOISE_IO
	
	
	;; USER SETTING => TONE A|B|C ON/OFF [FILTER]:
	;; move USER SWITCH settings to W REG
	movf VAR_TONE_NOISE_ABC_USER_ON_OFF_SWITCH, W 
			;; ABC TONE + NOISE ON/OFF USER SWITCH
			;; USER CLEAR or SET A BIT BY SWITCHING
			;; TONE/NOISE A/B/C 

	;; MIDI EVENT FILTER:
	;; *OR* [VAR_TONE_NOISE_ABC_USER_ON_OFF_SWITCH] WITH [MIDI_TONE_ABC_ON_OFF]
	;; MEMO: => MIDI EVENTS SET OR CLEAR BITS @ MIDI_TONE_ABC_ON_OFF
	;; MEMO: => CLEAR BIT = [TONE / NOISE] *ON*
	 
	
	iorwf MIDI_TONE_ABC_ON_OFF, W	
		;; OR VAR_TONE_NOISE_ABC_USER_ON_OFF_SWITCH
		;; WITH MIDI_TONE_ABC_ON_OFF
		;; NOW JUST THE RIGHT TONE/NOISE IS SWITCHED
		;; MOVE THE RESULT TO W REG
	
        ;; WRITE W REG TO THE SHADOW AY CHIP REG 7 
        ;; ==> VAR_AY_CHIP_REG7_ENABLE_ABC_NOISE_IO
        movwf VAR_AY_CHIP_REG7_ENABLE_ABC_NOISE_IO

	
	;; TONE A OFF
	movff	BNKD_VAR_Fx_TEMP, TMP4
	movff 	VAR_AY_CHIP_REG7_ENABLE_ABC_NOISE_IO, TMP4
	bsf  	TMP4, BIT0_TONE_A_ON_OFF
	movff	TMP4, BNKD_VAR_Fx_TEMP
		;; SEND DATA TO AY REG 7 (AY Chip)
		movlw CONST_AY_CHIP_ADR_07_TONE_NOISE_ON_OFF	; REG ADRESS 	=> AY REGISTER FOR AY CHIP REG 7
		movwf VAR_AY_CHIP_REG_ADDRESS 			; ADDRESS FOR 	=> AY_SR_Write
        
        	;; STORE REG7 DATA
        	movff BNKD_VAR_Fx_TEMP, VAR_AY_CHIP_REG_DATA
        
		;; --------------[SEND DATA TO AY REG 7]-----------------------------------------------------
		call LABEL_AY_SR_Write	; WRITING 8BIT DATA (VAR_AY_CHIP_REG_ADDRESS, VAR_AY_CHIP_REG_DATA)TO AY REG(X) ROUTINE
		;; ==========================================================================================


				goto INC_FX_POS_FOR_THE_NEXT_FX_EXECUTION

FX_FUNC_003
	;; 0x03 => On  Tone B
	
	;; USER SETTING FILTER 
	;; MIDI TONE ON FILTER 
	;; OR ==> VAR_AY_CHIP_REG7_ENABLE_ABC_NOISE_IO
	
	
	;; USER SETTING => TONE A|B|C ON/OFF [FILTER]:
	;; move USER SWITCH settings to W REG
	movf VAR_TONE_NOISE_ABC_USER_ON_OFF_SWITCH, W 
			;; ABC TONE + NOISE ON/OFF USER SWITCH
			;; USER CLEAR or SET A BIT BY SWITCHING
			;; TONE/NOISE A/B/C 

	;; MIDI EVENT FILTER:
	;; *OR* [VAR_TONE_NOISE_ABC_USER_ON_OFF_SWITCH] WITH [MIDI_TONE_ABC_ON_OFF]
	;; MEMO: => MIDI EVENTS SET OR CLEAR BITS @ MIDI_TONE_ABC_ON_OFF
	;; MEMO: => CLEAR BIT = [TONE / NOISE] *ON*
	 
	
	iorwf MIDI_TONE_ABC_ON_OFF, W	
		;; OR VAR_TONE_NOISE_ABC_USER_ON_OFF_SWITCH
		;; WITH MIDI_TONE_ABC_ON_OFF
		;; NOW JUST THE RIGHT TONE/NOISE IS SWITCHED
		;; MOVE THE RESULT TO W REG
	
        ;; WRITE W REG TO THE SHADOW AY CHIP REG 7 
        ;; ==> VAR_AY_CHIP_REG7_ENABLE_ABC_NOISE_IO
        movwf VAR_AY_CHIP_REG7_ENABLE_ABC_NOISE_IO


	movff 	VAR_AY_CHIP_REG7_ENABLE_ABC_NOISE_IO, BNKD_VAR_Fx_TEMP
	movff	BNKD_VAR_Fx_TEMP, TMP4
	bcf  	TMP4, BIT1_TONE_B_ON_OFF
	movff	TMP4, BNKD_VAR_Fx_TEMP
	
		;; SEND DATA TO AY REG 7
		movlw CONST_AY_CHIP_ADR_07_TONE_NOISE_ON_OFF	; REG ADRESS 	=> AY REGISTER FOR AY CHIP REG 7
		movwf VAR_AY_CHIP_REG_ADDRESS 			; ADDRESS FOR 	=> AY_SR_Write
        
        	;; COPY DATA
        	movff BNKD_VAR_Fx_TEMP, VAR_AY_CHIP_REG_DATA
        
		;; --------------[SEND DATA TO AY REG 7]-----------------------------------------------------
		call LABEL_AY_SR_Write	; WRITING 8BIT DATA (VAR_AY_CHIP_REG_ADDRESS, VAR_AY_CHIP_REG_DATA)TO AY REG(X) ROUTINE
		;; ==========================================================================================	
		

				goto INC_FX_POS_FOR_THE_NEXT_FX_EXECUTION

FX_FUNC_004
	;; 0x04 => Off Tone B

	;; USER SETTING FILTER 
	;; MIDI TONE ON FILTER 
	;; OR ==> VAR_AY_CHIP_REG7_ENABLE_ABC_NOISE_IO
	
	
	;; USER SETTING => TONE A|B|C ON/OFF [FILTER]:
	;; move USER SWITCH settings to W REG
	movf VAR_TONE_NOISE_ABC_USER_ON_OFF_SWITCH, W 
			;; ABC TONE + NOISE ON/OFF USER SWITCH
			;; USER CLEAR or SET A BIT BY SWITCHING
			;; TONE/NOISE A/B/C 

	;; MIDI EVENT FILTER:
	;; *OR* [VAR_TONE_NOISE_ABC_USER_ON_OFF_SWITCH] WITH [MIDI_TONE_ABC_ON_OFF]
	;; MEMO: => MIDI EVENTS SET OR CLEAR BITS @ MIDI_TONE_ABC_ON_OFF
	;; MEMO: => CLEAR BIT = [TONE / NOISE] *ON*
	 
	
	iorwf MIDI_TONE_ABC_ON_OFF, W	
		;; OR VAR_TONE_NOISE_ABC_USER_ON_OFF_SWITCH
		;; WITH MIDI_TONE_ABC_ON_OFF
		;; NOW JUST THE RIGHT TONE/NOISE IS SWITCHED
		;; MOVE THE RESULT TO W REG
	
        ;; WRITE W REG TO THE SHADOW AY CHIP REG 7 
        ;; ==> VAR_AY_CHIP_REG7_ENABLE_ABC_NOISE_IO
        movwf VAR_AY_CHIP_REG7_ENABLE_ABC_NOISE_IO


	movff 	VAR_AY_CHIP_REG7_ENABLE_ABC_NOISE_IO, BNKD_VAR_Fx_TEMP
	movff	BNKD_VAR_Fx_TEMP, TMP4
	bsf  	TMP4, BIT1_TONE_B_ON_OFF	
	movff	TMP4, BNKD_VAR_Fx_TEMP 
	
		;; SEND DATA TO AY REG 7
		movlw CONST_AY_CHIP_ADR_07_TONE_NOISE_ON_OFF	; REG ADRESS 	=> AY REGISTER FOR AY CHIP REG 7
		movwf VAR_AY_CHIP_REG_ADDRESS 			; ADDRESS FOR 	=> AY_SR_Write
        
        	;; STORE DATA 
        	movff BNKD_VAR_Fx_TEMP, VAR_AY_CHIP_REG_DATA
        
		;; --------------[SEND DATA TO AY REG 7]-----------------------------------------------------
		call LABEL_AY_SR_Write	; WRITING 8BIT DATA (VAR_AY_CHIP_REG_ADDRESS, VAR_AY_CHIP_REG_DATA)TO AY REG(X) ROUTINE
		;; ==========================================================================================

		goto INC_FX_POS_FOR_THE_NEXT_FX_EXECUTION

FX_FUNC_005
	;; 0x05 => On  Tone C

	;; USER SETTING FILTER 
	;; MIDI TONE ON FILTER 
	;; OR ==> VAR_AY_CHIP_REG7_ENABLE_ABC_NOISE_IO
	
	
	;; USER SETTING => TONE A|B|C ON/OFF [FILTER]:
	;; move USER SWITCH settings to W REG
	movf VAR_TONE_NOISE_ABC_USER_ON_OFF_SWITCH, W 
			;; ABC TONE + NOISE ON/OFF USER SWITCH
			;; USER CLEAR or SET A BIT BY SWITCHING
			;; TONE/NOISE A/B/C 

	;; MIDI EVENT FILTER:
	;; *OR* [VAR_TONE_NOISE_ABC_USER_ON_OFF_SWITCH] WITH [MIDI_TONE_ABC_ON_OFF]
	;; MEMO: => MIDI EVENTS SET OR CLEAR BITS @ MIDI_TONE_ABC_ON_OFF
	;; MEMO: => CLEAR BIT = [TONE / NOISE] *ON*
	 
	
	iorwf MIDI_TONE_ABC_ON_OFF, W	
		;; OR VAR_TONE_NOISE_ABC_USER_ON_OFF_SWITCH
		;; WITH MIDI_TONE_ABC_ON_OFF
		;; NOW JUST THE RIGHT TONE/NOISE IS SWITCHED
		;; MOVE THE RESULT TO W REG
	
        ;; WRITE W REG TO THE SHADOW AY CHIP REG 7 
        ;; ==> VAR_AY_CHIP_REG7_ENABLE_ABC_NOISE_IO
        movwf VAR_AY_CHIP_REG7_ENABLE_ABC_NOISE_IO

	;; On  Tone C
	movff VAR_AY_CHIP_REG7_ENABLE_ABC_NOISE_IO, BNKD_VAR_Fx_TEMP
	movff BNKD_VAR_Fx_TEMP, TMP4
	bcf   TMP4, BIT2_TONE_C_ON_OFF
	movff TMP4, BNKD_VAR_Fx_TEMP
	
		;; SEND DATA TO AY REG 7
		movlw CONST_AY_CHIP_ADR_07_TONE_NOISE_ON_OFF	; REG ADRESS 	=> AY REGISTER FOR AY CHIP REG 7
		movwf VAR_AY_CHIP_REG_ADDRESS 		; ADDRESS FOR 	=> AY_SR_Write

		;; COPY DATA
        movff BNKD_VAR_Fx_TEMP, VAR_AY_CHIP_REG_DATA

		;; --------------[SEND DATA TO AY REG 7]-----------------------------------------------------
		call LABEL_AY_SR_Write	; WRITING 8BIT DATA (VAR_AY_CHIP_REG_ADDRESS, VAR_AY_CHIP_REG_DATA)TO AY REG(X) ROUTINE
		;; ==========================================================================================	
		
		goto INC_FX_POS_FOR_THE_NEXT_FX_EXECUTION

FX_FUNC_006
	;; 0x06 => Off Tone C

	;; USER SETTING FILTER 
	;; MIDI TONE ON FILTER 
	;; OR ==> VAR_AY_CHIP_REG7_ENABLE_ABC_NOISE_IO
	
	
	;; USER SETTING => TONE A|B|C ON/OFF [FILTER]:
	;; move USER SWITCH settings to W REG
	movf VAR_TONE_NOISE_ABC_USER_ON_OFF_SWITCH, W 
			;; ABC TONE + NOISE ON/OFF USER SWITCH
			;; USER CLEAR or SET A BIT BY SWITCHING
			;; TONE/NOISE A/B/C 

	;; MIDI EVENT FILTER:
	;; *OR* [VAR_TONE_NOISE_ABC_USER_ON_OFF_SWITCH] WITH [MIDI_TONE_ABC_ON_OFF]
	;; MEMO: => MIDI EVENTS SET OR CLEAR BITS @ MIDI_TONE_ABC_ON_OFF
	;; MEMO: => CLEAR BIT = [TONE / NOISE] *ON*
	 
	
	iorwf MIDI_TONE_ABC_ON_OFF, W	
		;; OR VAR_TONE_NOISE_ABC_USER_ON_OFF_SWITCH
		;; WITH MIDI_TONE_ABC_ON_OFF
		;; NOW JUST THE RIGHT TONE/NOISE IS SWITCHED
		;; MOVE THE RESULT TO W REG
	
        ;; WRITE W REG TO THE SHADOW AY CHIP REG 7 
        ;; ==> VAR_AY_CHIP_REG7_ENABLE_ABC_NOISE_IO
        movwf VAR_AY_CHIP_REG7_ENABLE_ABC_NOISE_IO

	;; Off Tone C
	movff VAR_AY_CHIP_REG7_ENABLE_ABC_NOISE_IO, BNKD_VAR_Fx_TEMP
	movff BNKD_VAR_Fx_TEMP, TMP4
	bsf   TMP4, BIT2_TONE_C_ON_OFF
	movff TMP4, BNKD_VAR_Fx_TEMP
	
		;; SEND DATA TO AY REG 7
		movlw CONST_AY_CHIP_ADR_07_TONE_NOISE_ON_OFF	; REG ADRESS 	=> AY REGISTER FOR AY CHIP REG 7
		movwf VAR_AY_CHIP_REG_ADDRESS 		; ADDRESS FOR 	=> AY_SR_Write
        
        ;; COPY DATA
        movff BNKD_VAR_Fx_TEMP, VAR_AY_CHIP_REG_DATA
        
		;; --------------[SEND DATA TO AY REG 7]-----------------------------------------------------
		call LABEL_AY_SR_Write	; WRITING 8BIT DATA (VAR_AY_CHIP_REG_ADDRESS, VAR_AY_CHIP_REG_DATA)TO AY REG(X) ROUTINE
		;; ==========================================================================================
			
		goto INC_FX_POS_FOR_THE_NEXT_FX_EXECUTION


FX_FUNC_007
	;; PLUS Tune A	[Data: 0-255]
	;; Fx Call for Tune +
	
	;; TUNE COARSE A|B|C => BNKD_FX_TUNE_COARSE_TEMP
	;; TUNE FINE   A|B|C => BNKD_FX_TUNE_FINE_TEMP
	movff VAR_TONE_A_TUNE_COARSE_MIDI, BNKD_FX_TUNE_COARSE_TEMP
	movff VAR_TONE_A_TUNE_FINE_MIDI, BNKD_FX_TUNE_FINE_TEMP

	
	;; [ADD TUNE +] TUNE [PLUS] CURRENT Fx DATA BYTE
	call FX_TUNE_PLUS

	;; BNKD_FX_TUNE_COARSE_TEMP  => TUNE COARSE A|B|C
	;; BNKD_FX_TUNE_FINE_TEMP    => TUNE FINE   A|B|C
	movff BNKD_FX_TUNE_COARSE_TEMP, VAR_TONE_A_TUNE_COARSE_MIDI
	movff BNKD_FX_TUNE_FINE_TEMP, VAR_TONE_A_TUNE_FINE_MIDI

		;; SEND TUNE A TO AY CHIP
		movlw CONST_AY_CHIP_ADR_01_TONE_A_FREQUENCY_PERIOD_COARSE; ADRESS => AY REGISTER
		movwf VAR_AY_CHIP_REG_ADDRESS 			; ADDRESS FOR => AY_SR_Write
	
		movf  VAR_TONE_A_TUNE_COARSE_MIDI, W	; DATA FOR AY REG X
		movwf VAR_AY_CHIP_REG_DATA 				; FOR => AY_SR_Write (WRITE DATA TO AY REG)
	
			call LABEL_AY_SR_Write		; WRITING 8BIT DATA 
										;(VAR_AY_CHIP_REG_ADDRESS, VAR_AY_CHIP_REG_DATA)TO AY REG(X) ROUTINE	

		movlw CONST_AY_CHIP_ADR_00_TONE_A_FREQUENCY_FINE	; ADRESS => AY REGISTER
		movwf VAR_AY_CHIP_REG_ADDRESS 				; ADDRESS FOR => AY_SR_Write

		movf  VAR_TONE_A_TUNE_FINE_MIDI, W	; DATA FOR AY REG X
		movwf VAR_AY_CHIP_REG_DATA 			; FOR => AY_SR_Write (WRITE DATA TO AY REG)
	
			call LABEL_AY_SR_Write		; WRITING 8BIT DATA 
										;; (VAR_AY_CHIP_REG_ADDRESS, VAR_AY_CHIP_REG_DATA)TO AY REG(X) ROUTINE

	
		goto INC_FX_POS_FOR_THE_NEXT_FX_EXECUTION

FX_FUNC_008
	;; MINUS Tune A	[Data: 0-255]
	;; TUNE COARSE A|B|C => BNKD_FX_TUNE_COARSE_TEMP
	;; TUNE FINE   A|B|C => BNKD_FX_TUNE_FINE_TEMP
	movff VAR_TONE_A_TUNE_COARSE_MIDI, BNKD_FX_TUNE_COARSE_TEMP
	movff VAR_TONE_A_TUNE_FINE_MIDI, BNKD_FX_TUNE_FINE_TEMP

	
	;; [TUNE -] CURRENT TUNE [MINUS] CURRENT Fx DATA
	call FX_TUNE_MINUS

	;; BNKD_FX_TUNE_COARSE_TEMP  => TUNE COARSE A|B|C
	;; BNKD_FX_TUNE_FINE_TEMP    => TUNE FINE   A|B|C
	movff BNKD_FX_TUNE_COARSE_TEMP, VAR_TONE_A_TUNE_COARSE_MIDI
	movff BNKD_FX_TUNE_FINE_TEMP, VAR_TONE_A_TUNE_FINE_MIDI

		;; SEND TUNE A TO AY CHIP
		movlw CONST_AY_CHIP_ADR_01_TONE_A_FREQUENCY_PERIOD_COARSE	; ADRESS => AY REGISTER
		movwf VAR_AY_CHIP_REG_ADDRESS 						; ADDRESS FOR => AY_SR_Write
	
		movf  VAR_TONE_A_TUNE_COARSE_MIDI, W	; DATA FOR AY REG X
		movwf VAR_AY_CHIP_REG_DATA 				; FOR => AY_SR_Write (WRITE DATA TO AY REG)
	
			call LABEL_AY_SR_Write		; WRITING 8BIT DATA 
										;(VAR_AY_CHIP_REG_ADDRESS, VAR_AY_CHIP_REG_DATA)TO AY REG(X) ROUTINE	

		movlw CONST_AY_CHIP_ADR_00_TONE_A_FREQUENCY_FINE 	; ADRESS => AY REGISTER
		movwf VAR_AY_CHIP_REG_ADDRESS 				; ADDRESS FOR => AY_SR_Write

		movf  VAR_TONE_A_TUNE_FINE_MIDI, W	; DATA FOR AY REG X
		movwf VAR_AY_CHIP_REG_DATA 			; FOR => AY_SR_Write (WRITE DATA TO AY REG)
	
			call LABEL_AY_SR_Write		; WRITING 8BIT DATA 
										;; (VAR_AY_CHIP_REG_ADDRESS, VAR_AY_CHIP_REG_DATA)TO AY REG(X) ROUTINE
	
		goto INC_FX_POS_FOR_THE_NEXT_FX_EXECUTION

FX_FUNC_009
	;; 0x09 => PLUS Tune B	[Data: 0-255]
	;; Fx Call for Tune +
	
	;; TUNE COARSE A|B|C => BNKD_FX_TUNE_COARSE_TEMP
	;; TUNE FINE   A|B|C => BNKD_FX_TUNE_FINE_TEMP
	movff VAR_TONE_B_TUNE_COARSE_MIDI, BNKD_FX_TUNE_COARSE_TEMP
	movff VAR_TONE_B_TUNE_FINE_MIDI, BNKD_FX_TUNE_FINE_TEMP

	
	;; [ADD TUNE +] TUNE TEMP - CURRENT Fx DATA BYTE
	call FX_TUNE_PLUS

	;; BNKD_FX_TUNE_COARSE_TEMP  => TUNE COARSE A|B|C
	;; BNKD_FX_TUNE_FINE_TEMP    => TUNE FINE   A|B|C
	movff BNKD_FX_TUNE_COARSE_TEMP, VAR_TONE_A_TUNE_COARSE_MIDI
	movff BNKD_FX_TUNE_FINE_TEMP,   VAR_TONE_B_TUNE_FINE_MIDI

		;; SEND TUNE B TO AY CHIP
		movlw CONST_AY_CHIP_ADR_03_TONE_B_FREQUENCY_PERIOD_COARSE	; ADRESS => AY REGISTER
		movwf VAR_AY_CHIP_REG_ADDRESS 						; ADDRESS FOR => AY_SR_Write
	
		movf  VAR_TONE_B_TUNE_COARSE_MIDI, W	; DATA FOR AY REG X
		movwf VAR_AY_CHIP_REG_DATA 				; FOR => AY_SR_Write (WRITE DATA TO AY REG)
	
			call LABEL_AY_SR_Write		; WRITING 8BIT DATA 
										;(VAR_AY_CHIP_REG_ADDRESS, VAR_AY_CHIP_REG_DATA)TO AY REG(X) ROUTINE	

		movlw CONST_AY_CHIP_ADR_02_TONE_B_FREQUENCY_PERIOD_FINE	; ADRESS => AY REGISTER
		movwf VAR_AY_CHIP_REG_ADDRESS 						; ADDRESS FOR => AY_SR_Write

		movf  VAR_TONE_B_TUNE_FINE_MIDI, W	; DATA FOR AY REG X
		movwf VAR_AY_CHIP_REG_DATA 			; FOR => AY_SR_Write (WRITE DATA TO AY REG)
	
			call LABEL_AY_SR_Write		; WRITING 8BIT DATA 
										;; (VAR_AY_CHIP_REG_ADDRESS, VAR_AY_CHIP_REG_DATA)TO AY REG(X) ROUTINE
		
		goto INC_FX_POS_FOR_THE_NEXT_FX_EXECUTION

FX_FUNC_010
	;; 0x0A => MINUS Tune B	[Data: 0-255]
	;; TUNE COARSE A|B|C => BNKD_FX_TUNE_COARSE_TEMP
	;; TUNE FINE   A|B|C => BNKD_FX_TUNE_FINE_TEMP
	movff VAR_TONE_B_TUNE_COARSE_MIDI, BNKD_FX_TUNE_COARSE_TEMP
	movff VAR_TONE_B_TUNE_FINE_MIDI, BNKD_FX_TUNE_FINE_TEMP

	
	;; [TUNE -] CURRENT TUNE [MINUS] CURRENT Fx DATA
	call FX_TUNE_MINUS

	;; BNKD_FX_TUNE_COARSE_TEMP  => TUNE COARSE A|B|C
	;; BNKD_FX_TUNE_FINE_TEMP    => TUNE FINE   A|B|C
	movff BNKD_FX_TUNE_COARSE_TEMP, VAR_TONE_B_TUNE_COARSE_MIDI
	movff BNKD_FX_TUNE_FINE_TEMP,   VAR_TONE_B_TUNE_FINE_MIDI

		;; SEND TUNE A TO AY CHIP
		movlw CONST_AY_CHIP_ADR_03_TONE_B_FREQUENCY_PERIOD_COARSE	; ADRESS => AY REGISTER
		movwf VAR_AY_CHIP_REG_ADDRESS 						; ADDRESS FOR => AY_SR_Write
	
		movf  VAR_TONE_B_TUNE_COARSE_MIDI, W	; DATA FOR AY REG X
		movwf VAR_AY_CHIP_REG_DATA 				; FOR => AY_SR_Write (WRITE DATA TO AY REG)
	
			call LABEL_AY_SR_Write		; WRITING 8BIT DATA 
										;(VAR_AY_CHIP_REG_ADDRESS, VAR_AY_CHIP_REG_DATA)TO AY REG(X) ROUTINE	

		movlw CONST_AY_CHIP_ADR_02_TONE_B_FREQUENCY_PERIOD_FINE	; ADRESS => AY REGISTER
		movwf VAR_AY_CHIP_REG_ADDRESS 						; ADDRESS FOR => AY_SR_Write

		movf  VAR_TONE_B_TUNE_FINE_MIDI, W	; DATA FOR AY REG X
		movwf VAR_AY_CHIP_REG_DATA 			; FOR => AY_SR_Write (WRITE DATA TO AY REG)
	
			call LABEL_AY_SR_Write		; WRITING 8BIT DATA 
										;; (VAR_AY_CHIP_REG_ADDRESS, VAR_AY_CHIP_REG_DATA)TO AY REG(X) ROUTINE
 
	goto INC_FX_POS_FOR_THE_NEXT_FX_EXECUTION

FX_FUNC_011
	;; 0x0B => +Tune C	[Data: 0-255]
	;; Fx Call for Tune +
	
	;; TUNE COARSE A|B|C => BNKD_FX_TUNE_COARSE_TEMP
	;; TUNE FINE   A|B|C => BNKD_FX_TUNE_FINE_TEMP
	movff VAR_TONE_C_TUNE_COARSE_MIDI, BNKD_FX_TUNE_COARSE_TEMP
	movff VAR_TONE_C_TUNE_FINE_MIDI, BNKD_FX_TUNE_FINE_TEMP

	
	;; [ADD TUNE +] TUNE TEMP - CURRENT Fx DATA BYTE
	call FX_TUNE_PLUS

	;; BNKD_FX_TUNE_COARSE_TEMP  => TUNE COARSE A|B|C
	;; BNKD_FX_TUNE_FINE_TEMP    => TUNE FINE   A|B|C
	movff BNKD_FX_TUNE_COARSE_TEMP, VAR_TONE_A_TUNE_COARSE_MIDI
	movff BNKD_FX_TUNE_FINE_TEMP, VAR_TONE_C_TUNE_FINE_MIDI

		;; SEND TUNE C TO AY CHIP
		movlw CONST_AY_CHIP_ADR_05_TONE_C_TONE_PERIOD_COARSE	; ADRESS => AY REGISTER
		movwf VAR_AY_CHIP_REG_ADDRESS 					; ADDRESS FOR => AY_SR_Write
	
		movf  VAR_TONE_C_TUNE_COARSE_MIDI, W	; DATA FOR AY REG X
		movwf VAR_AY_CHIP_REG_DATA 				; FOR => AY_SR_Write (WRITE DATA TO AY REG)
		
			call LABEL_AY_SR_Write		; WRITING 8BIT DATA 
										;(VAR_AY_CHIP_REG_ADDRESS, VAR_AY_CHIP_REG_DATA)TO AY REG(X) ROUTINE	

		movlw CONST_AY_CHIP_ADR_04_TONE_C_FREQUENCY_PERIOD_FINE	; ADRESS => AY REGISTER
		movwf VAR_AY_CHIP_REG_ADDRESS 			; ADDRESS FOR => AY_SR_Write

		movf  VAR_TONE_C_TUNE_FINE_MIDI, W	; DATA FOR AY REG X
		movwf VAR_AY_CHIP_REG_DATA 			; FOR => AY_SR_Write (WRITE DATA TO AY REG)
	
			call LABEL_AY_SR_Write		; WRITING 8BIT DATA 
										;; (VAR_AY_CHIP_REG_ADDRESS, VAR_AY_CHIP_REG_DATA)TO AY REG(X) ROUTINE

	goto INC_FX_POS_FOR_THE_NEXT_FX_EXECUTION

FX_FUNC_012
	;; 0x0C => -Tune C	[Data: 0-255]
	;; TUNE COARSE A|B|C => BNKD_FX_TUNE_COARSE_TEMP
	;; TUNE FINE   A|B|C => BNKD_FX_TUNE_FINE_TEMP
	movff VAR_TONE_C_TUNE_COARSE_MIDI, BNKD_FX_TUNE_COARSE_TEMP
	movff VAR_TONE_C_TUNE_FINE_MIDI, BNKD_FX_TUNE_FINE_TEMP

	
	;; [TUNE -] CURRENT TUNE [MINUS] CURRENT Fx DATA
	call FX_TUNE_MINUS

	;; BNKD_FX_TUNE_COARSE_TEMP  => TUNE COARSE A|B|C
	;; BNKD_FX_TUNE_FINE_TEMP    => TUNE FINE   A|B|C
	movff BNKD_FX_TUNE_COARSE_TEMP, VAR_TONE_C_TUNE_COARSE_MIDI
	movff BNKD_FX_TUNE_FINE_TEMP,   VAR_TONE_C_TUNE_FINE_MIDI

		;; SEND TUNE A TO AY CHIP
		movlw CONST_AY_CHIP_ADR_05_TONE_C_TONE_PERIOD_COARSE	; ADRESS => AY REGISTER
		movwf VAR_AY_CHIP_REG_ADDRESS 					; ADDRESS FOR => AY_SR_Write
	
		movf  VAR_TONE_C_TUNE_COARSE_MIDI, W	; DATA FOR AY REG X
		movwf VAR_AY_CHIP_REG_DATA 				; FOR => AY_SR_Write (WRITE DATA TO AY REG)
	
			call LABEL_AY_SR_Write		; WRITING 8BIT DATA 
										;(VAR_AY_CHIP_REG_ADDRESS, VAR_AY_CHIP_REG_DATA)TO AY REG(X) ROUTINE	

		movlw CONST_AY_CHIP_ADR_04_TONE_C_FREQUENCY_PERIOD_FINE	; ADRESS => AY REGISTER
		movwf VAR_AY_CHIP_REG_ADDRESS 						; ADDRESS FOR => AY_SR_Write

		movf  VAR_TONE_C_TUNE_FINE_MIDI, W	; DATA FOR AY REG X
		movwf VAR_AY_CHIP_REG_DATA 			; FOR => AY_SR_Write (WRITE DATA TO AY REG)
	
			call LABEL_AY_SR_Write		; WRITING 8BIT DATA 
										;; (VAR_AY_CHIP_REG_ADDRESS, VAR_AY_CHIP_REG_DATA)TO AY REG(X) ROUTINE

	goto INC_FX_POS_FOR_THE_NEXT_FX_EXECUTION

FX_FUNC_013
	;; 0x0D FUNCTION WRITE => Vol.A	[Data: 0-15]
	;; FORMAT VALUE TO 0-15 (DELETE values > 15)
	
	movlw VOLUME_ABC_MAX_VALUE ;; B'00001111'
	cpfsgt VAR_FX_TAB_ENTRY_CURRENT_PARAM
		;; =< 15
		rgoto FX_FUNC_013_WRITE_TO_AY_CHIP
	 	
	 	;; >15	
	 	;; FORMAT VALUE TO 0-15 (DELETE values > 15)
	 	movlw B'00001111'
	 	movwf VAR_FX_TAB_ENTRY_CURRENT_PARAM
		
FX_FUNC_013_WRITE_TO_AY_CHIP		
		;; SEND DATA TO AY CHIP
		movlw CONST_AY_CHIP_ADR_08_TONE_A_VOLUME_ENV_MODE_ON_OFF ; REG ADRESS 	=> AY REGISTER 
		movwf VAR_AY_CHIP_REG_ADDRESS 		; ADDRESS FOR 	=> AY_SR_Write
        	;; COPY DATA
        	;; WRITE VOL Tone A
        	movff VAR_FX_TAB_ENTRY_CURRENT_PARAM, VAR_AY_CHIP_REG_DATA
		;; --------------[SEND DATA TO AY CHIP]-----------------------------------------------------
		call LABEL_AY_SR_Write	; WRITING 8BIT DATA (VAR_AY_CHIP_REG_ADDRESS, VAR_AY_CHIP_REG_DATA)TO AY REG(X) ROUTINE
		;; ==========================================================================================
	
	goto INC_FX_POS_FOR_THE_NEXT_FX_EXECUTION

FX_FUNC_014
	;; 0x0E => Vol.B	[Data: 0-15]
	movlw VOLUME_ABC_MAX_VALUE  ;; B'00001111'
	cpfsgt VAR_FX_TAB_ENTRY_CURRENT_PARAM
		;; <= 15
		rgoto FX_FUNC_014_WRITE_TO_AY_CHIP
	 	
	 	;; > 15	
	 	;; FORMAT VALUE TO 0-15 (DELETE values > 15)
	 	movlw B'00001111'
	 	movwf VAR_FX_TAB_ENTRY_CURRENT_PARAM
		
FX_FUNC_014_WRITE_TO_AY_CHIP		
		;; SEND DATA TO AY REG 9
		movlw CONST_AY_CHIP_ADR_09_TONE_B_VOLUME_ENV_MODE_ON_OFF	; REG ADRESS 	=> AY REGISTER 
		movwf VAR_AY_CHIP_REG_ADDRESS 		; ADDRESS FOR 	=> AY_SR_Write
        	;; COPY DATA
        	;; WRITE VOL Tone B
        	movff VAR_FX_TAB_ENTRY_CURRENT_PARAM, VAR_AY_CHIP_REG_DATA
		;; --------------[SEND DATA TO AY CHIP]-----------------------------------------------------
		call LABEL_AY_SR_Write	; WRITING 8BIT DATA (VAR_AY_CHIP_REG_ADDRESS, VAR_AY_CHIP_REG_DATA)TO AY REG(X) ROUTINE
		;; ==========================================================================================
	
	goto INC_FX_POS_FOR_THE_NEXT_FX_EXECUTION

FX_FUNC_015
	;; 0x0F => Vol.C	[Data: 0-15]
	movlw VOLUME_ABC_MAX_VALUE  ;; B'00001111'
	cpfsgt VAR_FX_TAB_ENTRY_CURRENT_PARAM
		;; <=15
		rgoto FX_FUNC_015_WRITE_TO_AY_CHIP
	 	
	 	;; >15	
	 	;; FORMAT VALUE TO 0-15 (DELETE values > 15)
	 	movlw B'00001111'
	 	movwf VAR_FX_TAB_ENTRY_CURRENT_PARAM
		
FX_FUNC_015_WRITE_TO_AY_CHIP		
		;; SEND DATA TO AY REG 10
		movlw CONST_AY_CHIP_ADR_10_TONE_C_VOLUME_ENV_MODE_ON_OFF	; REG ADRESS 	=> AY REGISTER 
		movwf VAR_AY_CHIP_REG_ADDRESS 		; ADDRESS FOR 	=> AY_SR_Write
        	;; COPY DATA
        	movff VAR_FX_TAB_ENTRY_CURRENT_PARAM, VAR_AY_CHIP_REG_DATA
        	;; WRITE VOL Tone C
		;; --------------[SEND DATA TO AY CHIP]-----------------------------------------------------
		call LABEL_AY_SR_Write	; WRITING 8BIT DATA (VAR_AY_CHIP_REG_ADDRESS, VAR_AY_CHIP_REG_DATA)TO AY REG(X) ROUTINE
		;; ==========================================================================================
			
	goto INC_FX_POS_FOR_THE_NEXT_FX_EXECUTION

FX_FUNC_016
	;; On  Noise A
	;; USER SETTING FILTER 
	;; MIDI TONE ON FILTER 
	;; OR ==> VAR_AY_CHIP_REG7_ENABLE_ABC_NOISE_IO
	
	;; USER SETTING => TONE A|B|C ON/OFF [FILTER]:
	;; move USER SWITCH settings to W REG
	movf VAR_TONE_NOISE_ABC_USER_ON_OFF_SWITCH, W 
			;; ABC TONE + NOISE ON/OFF USER SWITCH
			;; USER CLEAR or SET A BIT BY SWITCHING
			;; TONE/NOISE A/B/C 

	;; MIDI EVENT FILTER:
	;; *OR* [VAR_TONE_NOISE_ABC_USER_ON_OFF_SWITCH] WITH [MIDI_TONE_ABC_ON_OFF]
	;; MEMO: => MIDI EVENTS SET OR CLEAR BITS @ MIDI_TONE_ABC_ON_OFF
	;; MEMO: => CLEAR BIT = [TONE / NOISE] *ON*
	 
	
	iorwf MIDI_TONE_ABC_ON_OFF, W	
		;; OR VAR_TONE_NOISE_ABC_USER_ON_OFF_SWITCH
		;; WITH MIDI_TONE_ABC_ON_OFF
		;; NOW JUST THE RIGHT TONE/NOISE IS SWITCHED
		;; MOVE THE RESULT TO W REG
	
        ;; WRITE W REG TO THE SHADOW AY CHIP REG 7 
        ;; ==> VAR_AY_CHIP_REG7_ENABLE_ABC_NOISE_IO
        movwf VAR_AY_CHIP_REG7_ENABLE_ABC_NOISE_IO
		movff VAR_AY_CHIP_REG7_ENABLE_ABC_NOISE_IO, BNKD_VAR_Fx_TEMP
	
	;; On  Noise A
	movff BNKD_VAR_Fx_TEMP, TMP4
	bcf   TMP4, BIT3_NOISE_A_ON_OFF
	movff TMP4, BNKD_VAR_Fx_TEMP
			
		;; ==========================================================================================
		;; SEND DATA TO AY REG 7
		movlw CONST_AY_CHIP_ADR_07_TONE_NOISE_ON_OFF	; REG ADRESS 	=> AY REGISTER FOR AY CHIP REG 7
		movwf VAR_AY_CHIP_REG_ADDRESS 					; ADDRESS FOR 	=> AY_SR_Write
        ;; COPY DATA
        movff BNKD_VAR_Fx_TEMP, VAR_AY_CHIP_REG_DATA
		;; --------------[SEND DATA TO AY REG 7]-----------------------------------------------------
		call LABEL_AY_SR_Write	; WRITING 8BIT DATA (VAR_AY_CHIP_REG_ADDRESS, VAR_AY_CHIP_REG_DATA)TO AY REG(X) ROUTINE
		;; ==========================================================================================
	
	goto INC_FX_POS_FOR_THE_NEXT_FX_EXECUTION

FX_FUNC_017
	;; Off Noise A
	;; USER SETTING FILTER 
	;; MIDI TONE ON FILTER 
	;; OR ==> VAR_AY_CHIP_REG7_ENABLE_ABC_NOISE_IO
	
	;; USER SETTING => TONE A|B|C ON/OFF [FILTER]:
	;; move USER SWITCH settings to W REG
	movf VAR_TONE_NOISE_ABC_USER_ON_OFF_SWITCH, W 
			;; ABC TONE + NOISE ON/OFF USER SWITCH
			;; USER CLEAR or SET A BIT BY SWITCHING
			;; TONE/NOISE A/B/C 

	;; MIDI EVENT FILTER:
	;; *OR* [VAR_TONE_NOISE_ABC_USER_ON_OFF_SWITCH] WITH [MIDI_TONE_ABC_ON_OFF]
	;; MEMO: => MIDI EVENTS SET OR CLEAR BITS @ MIDI_TONE_ABC_ON_OFF
	;; MEMO: => CLEAR BIT = [TONE / NOISE] *ON*
	 
	
	iorwf MIDI_TONE_ABC_ON_OFF, W	
		;; OR VAR_TONE_NOISE_ABC_USER_ON_OFF_SWITCH
		;; WITH MIDI_TONE_ABC_ON_OFF
		;; NOW JUST THE RIGHT TONE/NOISE IS SWITCHED
		;; MOVE THE RESULT TO W REG
	
        ;; WRITE W REG TO THE SHADOW AY CHIP REG 7 
        ;; ==> VAR_AY_CHIP_REG7_ENABLE_ABC_NOISE_IO
        movwf VAR_AY_CHIP_REG7_ENABLE_ABC_NOISE_IO
		movff VAR_AY_CHIP_REG7_ENABLE_ABC_NOISE_IO, BNKD_VAR_Fx_TEMP
	
	;; OFF  Noise A
	movff BNKD_VAR_Fx_TEMP, TMP4
	bsf   TMP4, BIT3_NOISE_A_ON_OFF
	movff TMP4, BNKD_VAR_Fx_TEMP
	
		;; ==========================================================================================	
		;; SEND DATA TO AY REG 7
		movlw CONST_AY_CHIP_ADR_07_TONE_NOISE_ON_OFF	; REG ADRESS 	=> AY REGISTER FOR AY CHIP REG 7
		movwf VAR_AY_CHIP_REG_ADDRESS 					; ADDRESS FOR 	=> AY_SR_Write
        ;; COPY DATA
        movff BNKD_VAR_Fx_TEMP, VAR_AY_CHIP_REG_DATA
		;; --------------[SEND DATA TO AY REG 7]-----------------------------------------------------
		call LABEL_AY_SR_Write	; WRITING 8BIT DATA (VAR_AY_CHIP_REG_ADDRESS, VAR_AY_CHIP_REG_DATA)TO AY REG(X) ROUTINE
		;; ==========================================================================================
	
	goto INC_FX_POS_FOR_THE_NEXT_FX_EXECUTION

FX_FUNC_018
	;; On  Noise B
	;; USER SETTING FILTER 
	;; MIDI TONE ON FILTER 
	;; OR ==> VAR_AY_CHIP_REG7_ENABLE_ABC_NOISE_IO
	
	;; USER SETTING => TONE A|B|C ON/OFF [FILTER]:
	;; move USER SWITCH settings to W REG
	movf VAR_TONE_NOISE_ABC_USER_ON_OFF_SWITCH, W 
			;; ABC TONE + NOISE ON/OFF USER SWITCH
			;; USER CLEAR or SET A BIT BY SWITCHING
			;; TONE/NOISE A/B/C 

	;; MIDI EVENT FILTER:
	;; *OR* [VAR_TONE_NOISE_ABC_USER_ON_OFF_SWITCH] WITH [MIDI_TONE_ABC_ON_OFF]
	;; MEMO: => MIDI EVENTS SET OR CLEAR BITS @ MIDI_TONE_ABC_ON_OFF
	;; MEMO: => CLEAR BIT = [TONE / NOISE] *ON*
	 
	
	iorwf MIDI_TONE_ABC_ON_OFF, W	
		;; OR VAR_TONE_NOISE_ABC_USER_ON_OFF_SWITCH
		;; WITH MIDI_TONE_ABC_ON_OFF
		;; NOW JUST THE RIGHT TONE/NOISE IS SWITCHED
		;; MOVE THE RESULT TO W REG
	
		;; WRITE W REG TO THE SHADOW AY CHIP REG 7 
		;; ==> VAR_AY_CHIP_REG7_ENABLE_ABC_NOISE_IO
		movwf VAR_AY_CHIP_REG7_ENABLE_ABC_NOISE_IO
		movff VAR_AY_CHIP_REG7_ENABLE_ABC_NOISE_IO, BNKD_VAR_Fx_TEMP

	;; On  Noise B
	movff BNKD_VAR_Fx_TEMP, TMP4
	bcf   TMP4, BIT4_NOISE_B_ON_OFF	
	movff TMP4, BNKD_VAR_Fx_TEMP
	
		;; ==========================================================================================	
		;; SEND DATA TO AY REG 7
		movlw CONST_AY_CHIP_ADR_07_TONE_NOISE_ON_OFF	; REG ADRESS 	=> AY REGISTER FOR AY CHIP REG 7
		movwf VAR_AY_CHIP_REG_ADDRESS 		; ADDRESS FOR 	=> AY_SR_Write
        	;; COPY DATA
        	movff BNKD_VAR_Fx_TEMP, VAR_AY_CHIP_REG_DATA
		;; --------------[SEND DATA TO AY REG 7]-----------------------------------------------------
		call LABEL_AY_SR_Write	; WRITING 8BIT DATA (VAR_AY_CHIP_REG_ADDRESS, VAR_AY_CHIP_REG_DATA)TO AY REG(X) ROUTINE
		;; ==========================================================================================

	goto INC_FX_POS_FOR_THE_NEXT_FX_EXECUTION

FX_FUNC_019
	;; Off Noise B

	;; USER SETTING FILTER 
	;; MIDI TONE ON FILTER 
	;; OR ==> VAR_AY_CHIP_REG7_ENABLE_ABC_NOISE_IO
	
	;; USER SETTING => TONE A|B|C ON/OFF [FILTER]:
	;; move USER SWITCH settings to W REG
	movf VAR_TONE_NOISE_ABC_USER_ON_OFF_SWITCH, W 
			;; ABC TONE + NOISE ON/OFF USER SWITCH
			;; USER CLEAR or SET A BIT BY SWITCHING
			;; TONE/NOISE A/B/C 

	;; MIDI EVENT FILTER:
	;; *OR* [VAR_TONE_NOISE_ABC_USER_ON_OFF_SWITCH] WITH [MIDI_TONE_ABC_ON_OFF]
	;; MEMO: => MIDI EVENTS SET OR CLEAR BITS @ MIDI_TONE_ABC_ON_OFF
	;; MEMO: => CLEAR BIT = [TONE / NOISE] *ON*
	 
	
	iorwf MIDI_TONE_ABC_ON_OFF, W	
		;; OR VAR_TONE_NOISE_ABC_USER_ON_OFF_SWITCH
		;; WITH MIDI_TONE_ABC_ON_OFF
		;; NOW JUST THE RIGHT TONE/NOISE IS SWITCHED
		;; MOVE THE RESULT TO W REG
	
        ;; WRITE W REG TO THE SHADOW AY CHIP REG 7 
        ;; ==> VAR_AY_CHIP_REG7_ENABLE_ABC_NOISE_IO
        movwf VAR_AY_CHIP_REG7_ENABLE_ABC_NOISE_IO
		movff VAR_AY_CHIP_REG7_ENABLE_ABC_NOISE_IO, BNKD_VAR_Fx_TEMP
	 
	;; Off Noise B
	movff BNKD_VAR_Fx_TEMP, TMP4
	bsf   TMP4, BIT4_NOISE_B_ON_OFF	
	movff TMP4, BNKD_VAR_Fx_TEMP

		;; ==========================================================================================
		;; SEND DATA TO AY REG 7
		movlw CONST_AY_CHIP_ADR_07_TONE_NOISE_ON_OFF ; REG ADRESS 	=> AY REGISTER FOR AY CHIP REG 7
		movwf VAR_AY_CHIP_REG_ADDRESS 		; ADDRESS FOR 	=> AY_SR_Write
        	;; COPY DATA
        	movff BNKD_VAR_Fx_TEMP, VAR_AY_CHIP_REG_DATA
		;; --------------[SEND DATA TO AY REG 7]-----------------------------------------------------
		call LABEL_AY_SR_Write	; WRITING 8BIT DATA (VAR_AY_CHIP_REG_ADDRESS, VAR_AY_CHIP_REG_DATA)TO AY REG(X) ROUTINE
		;; ==========================================================================================

	goto INC_FX_POS_FOR_THE_NEXT_FX_EXECUTION

FX_FUNC_020
	;; On  Noise C 
	
	;; USER SETTING FILTER 
	;; MIDI TONE ON FILTER 
	;; OR ==> VAR_AY_CHIP_REG7_ENABLE_ABC_NOISE_IO
	
	;; USER SETTING => TONE A|B|C ON/OFF [FILTER]:
	;; move USER SWITCH settings to W REG
	movf VAR_TONE_NOISE_ABC_USER_ON_OFF_SWITCH, W 
			;; ABC TONE + NOISE ON/OFF USER SWITCH
			;; USER CLEAR or SET A BIT BY SWITCHING
			;; TONE/NOISE A/B/C 

	;; MIDI EVENT FILTER:
	;; *OR* [VAR_TONE_NOISE_ABC_USER_ON_OFF_SWITCH] WITH [MIDI_TONE_ABC_ON_OFF]
	;; MEMO: => MIDI EVENTS SET OR CLEAR BITS @ MIDI_TONE_ABC_ON_OFF
	;; MEMO: => CLEAR BIT = [TONE / NOISE] *ON*
	 
	iorwf MIDI_TONE_ABC_ON_OFF, W	
		;; OR VAR_TONE_NOISE_ABC_USER_ON_OFF_SWITCH
		;; WITH MIDI_TONE_ABC_ON_OFF
		;; NOW JUST THE RIGHT TONE/NOISE IS SWITCHED
		;; MOVE THE RESULT TO W REG
	
        ;; WRITE W REG TO THE SHADOW AY CHIP REG 7 
        ;; ==> VAR_AY_CHIP_REG7_ENABLE_ABC_NOISE_IO
        movwf VAR_AY_CHIP_REG7_ENABLE_ABC_NOISE_IO
		movff VAR_AY_CHIP_REG7_ENABLE_ABC_NOISE_IO, BNKD_VAR_Fx_TEMP
	
	;; On  Noise C 
	movff BNKD_VAR_Fx_TEMP, TMP4
	bcf   TMP4, BIT5_NOISE_C_ON_OFF	
	movff TMP4, BNKD_VAR_Fx_TEMP
	
		;; ==========================================================================================
		;; SEND DATA TO AY REG 7
		movlw CONST_AY_CHIP_ADR_07_TONE_NOISE_ON_OFF 	; REG ADRESS 	=> AY REGISTER FOR AY CHIP REG 7
		movwf VAR_AY_CHIP_REG_ADDRESS 			; ADDRESS FOR 	=> AY_SR_Write
        	;; COPY DATA
        	movff BNKD_VAR_Fx_TEMP, VAR_AY_CHIP_REG_DATA
		;; --------------[SEND DATA TO AY REG 7]-----------------------------------------------------
		call LABEL_AY_SR_Write	; WRITING 8BIT DATA (VAR_AY_CHIP_REG_ADDRESS, VAR_AY_CHIP_REG_DATA)TO AY REG(X) ROUTINE
		;; ==========================================================================================
			
	goto INC_FX_POS_FOR_THE_NEXT_FX_EXECUTION

FX_FUNC_021
	;; Off Noise C
	
	;; USER SETTING FILTER 
	;; MIDI TONE ON FILTER 
	;; OR ==> VAR_AY_CHIP_REG7_ENABLE_ABC_NOISE_IO
	;; USER SETTING => TONE A|B|C ON/OFF [FILTER]:
	;; move USER SWITCH settings to W REG
	movf VAR_TONE_NOISE_ABC_USER_ON_OFF_SWITCH, W 
			;; ABC TONE + NOISE ON/OFF USER SWITCH
			;; USER CLEAR or SET A BIT BY SWITCHING
			;; TONE/NOISE A/B/C 

	;; MIDI EVENT FILTER:
	;; *OR* [VAR_TONE_NOISE_ABC_USER_ON_OFF_SWITCH] WITH [MIDI_TONE_ABC_ON_OFF]
	;; MEMO: => MIDI EVENTS SET OR CLEAR BITS @ MIDI_TONE_ABC_ON_OFF
	;; MEMO: => CLEAR BIT = [TONE / NOISE] *ON*
	 
	iorwf MIDI_TONE_ABC_ON_OFF, W	
		;; OR VAR_TONE_NOISE_ABC_USER_ON_OFF_SWITCH
		;; WITH MIDI_TONE_ABC_ON_OFF
		;; NOW JUST THE RIGHT TONE/NOISE IS SWITCHED
		;; MOVE THE RESULT TO W REG
	
        ;; WRITE W REG TO THE SHADOW AY CHIP REG 7 
        ;; ==> VAR_AY_CHIP_REG7_ENABLE_ABC_NOISE_IO
        movwf VAR_AY_CHIP_REG7_ENABLE_ABC_NOISE_IO
		movff VAR_AY_CHIP_REG7_ENABLE_ABC_NOISE_IO, BNKD_VAR_Fx_TEMP
	
	;; Off Noise C
	movff BNKD_VAR_Fx_TEMP, TMP4
	bsf   TMP4, BIT5_NOISE_C_ON_OFF	
	movff TMP4, BNKD_VAR_Fx_TEMP
	
		;; ==========================================================================================	
		;; SEND DATA TO AY REG 7
		movlw CONST_AY_CHIP_ADR_07_TONE_NOISE_ON_OFF		; REG ADRESS 	=> AY REGISTER FOR AY CHIP REG 7
		movwf VAR_AY_CHIP_REG_ADDRESS 						; ADDRESS FOR 	=> AY_SR_Write
        	;; COPY DATA
        	movff BNKD_VAR_Fx_TEMP, VAR_AY_CHIP_REG_DATA
		;; --------------[SEND DATA TO AY REG 7]-----------------------------------------------------
		call LABEL_AY_SR_Write	; WRITING 8BIT DATA (VAR_AY_CHIP_REG_ADDRESS, VAR_AY_CHIP_REG_DATA)TO AY REG(X) ROUTINE
		;; ==========================================================================================
			
	goto INC_FX_POS_FOR_THE_NEXT_FX_EXECUTION

FX_FUNC_022
	;;  Noise Frq.	[Data: 0-31]
	movlw NOISE_PERIOD_MAX_VALUE ;; NOISE PERIOD MAX VALUE = B'00011111', 31 dec, 01F hex
	cpfsgt VAR_FX_TAB_ENTRY_CURRENT_PARAM
		;; OK, GO ON
		;; VAR_FX_TAB_ENTRY_CURRENT_PARAM is not out of range [0-31]
		rgoto FX_FUNC_022_GO_ON
		
		;; write noise period max MAX VALUE [fX DATA WAS OUT OF RAGE] 
		movlw	NOISE_PERIOD_MAX_VALUE
		movwf	VAR_FX_TAB_ENTRY_CURRENT_PARAM
		
FX_FUNC_022_GO_ON		
	;; REVERSE NOISE PERIOD VALUE 
	;; [THE NOISE PERIOD VALUE IS REVERSED ON LCD ALSO]
	;; [FX DATA]  0 => [AY CHIP REG 6 REVERSE VALUE] = 31
	;; [FX DATA]  1 => [AY CHIP REG 6 REVERSE VALUE] = 30
	;; [FX DATA]  2 => [AY CHIP REG 6 REVERSE VALUE] = 29
	;; [FX DATA]  3 => [AY CHIP REG 6 REVERSE VALUE] = 28
	;; ...
	;; [FX DATA] 31 => [AY CHIP REG 6REVERSE VALUE]  = 0
	movlw NOISE_PERIOD_MAX_VALUE  ;; 31
	movwf VAR_AY_CHIP_R6_NOISE_PERIOD_REVERSE_VALUE
	movf VAR_FX_TAB_ENTRY_CURRENT_PARAM, W
	subwf VAR_AY_CHIP_R6_NOISE_PERIOD_REVERSE_VALUE, F
		;; ==========================================================================================
		;; SEND DATA TO AY REG 6
		movlw CONST_AY_CHIP_ADR_06_NOISE_PERIOD ; REG ADRESS 	=> AY REGISTER FOR AY CHIP REG 6
		movwf VAR_AY_CHIP_REG_ADDRESS 		  	; ADDRESS FOR 	=> AY_SR_Write
        	;; COPY DATA
        	movff VAR_AY_CHIP_R6_NOISE_PERIOD_REVERSE_VALUE, VAR_AY_CHIP_REG_DATA
		;; --------------[SEND DATA TO AY CHIP]-----------------------------------------------------
		call LABEL_AY_SR_Write	; WRITING 8BIT DATA (VAR_AY_CHIP_REG_ADDRESS, VAR_AY_CHIP_REG_DATA)TO AY REG(X) ROUTINE
		;; ==========================================================================================
			
	goto INC_FX_POS_FOR_THE_NEXT_FX_EXECUTION

FX_FUNC_023
	;; ENV ON A
	
	;; get CURRENT envelope shape
	call ENVELOPE_TRANSLATOR_CALL
			
	movff VAR_AY_CHIP_REG8_CH_A_AMPLITUDE, BNKD_VAR_Fx_TEMP
	;; SET bit 4 => ENV MODE ON A
	movff BNKD_VAR_Fx_TEMP, TMP4 
	bsf	  TMP4, BIT4_ENVELOPE_ON_OFF
	movff TMP4, BNKD_VAR_Fx_TEMP
	
		;; ==========================================================================================
		;; SEND DATA TO AY CHIP
		movlw CONST_AY_CHIP_ADR_08_TONE_A_VOLUME_ENV_MODE_ON_OFF	; SELECT ADRESS => SET REGISTER OF AY CHIP
		movwf VAR_AY_CHIP_REG_ADDRESS 						; ADDRESS FOR 	=> AY_SR_Write
        	;; COPY DATA
        	movff BNKD_VAR_Fx_TEMP, VAR_AY_CHIP_REG_DATA
		;; --------------[SEND DATA TO AY CHIP]-----------------------------------------------------
		call LABEL_AY_SR_Write	; WRITING 8BIT DATA (VAR_AY_CHIP_REG_ADDRESS, VAR_AY_CHIP_REG_DATA)TO AY REG(X) ROUTINE
		;; ==========================================================================================
		;;; -------------[WRITE ENVELOPE SHAPE/CYCLE]------------------
		;; SEND DATA TO AY REG 13 (ENV. SHAPE Cycle REG)
		;; SET AY REGISTER
		movlw  CONST_AY_CHIP_ADR_13_ENVELOPE_SHAPE_AND_CYCLE	
		movwf  VAR_AY_CHIP_REG_ADDRESS 		
		;; WRITE GLOBAL [A|B|C] ENVELOPE SHAPE DATA TO AY CHIP
		movff  VAR_AY_CHIP_REG13_ENV_SHAPE_CYCLE, VAR_AY_CHIP_REG_DATA
		;; --------------[SEND DATA TO AY REG 13]-----------------------------------------------------
		call LABEL_AY_SR_Write	; WRITING 8BIT DATA (VAR_AY_CHIP_REG_ADDRESS, VAR_AY_CHIP_REG_DATA)TO AY REG(X) ROUTINE
		;; ==========================================================================================
	
	rgoto INC_FX_POS_FOR_THE_NEXT_FX_EXECUTION

FX_FUNC_024
	;; ENV OFF A
	movff VAR_AY_CHIP_REG8_CH_A_AMPLITUDE, BNKD_VAR_Fx_TEMP
	;; SET bit 4 => ENV MODE ON A
	movff BNKD_VAR_Fx_TEMP, TMP4
	bcf	  TMP4, BIT4_ENVELOPE_ON_OFF
	movff TMP4, BNKD_VAR_Fx_TEMP
	
		;; ==========================================================================================
		;; SEND DATA TO AY CHIP
		movlw CONST_AY_CHIP_ADR_08_TONE_A_VOLUME_ENV_MODE_ON_OFF	; SET AY CHIP REGISTER 	
		movwf VAR_AY_CHIP_REG_ADDRESS 								; => AY_SR_Write
        	;; COPY DATA
        	movff BNKD_VAR_Fx_TEMP, VAR_AY_CHIP_REG_DATA
		;; --------------[SEND DATA TO AY CHIP]-----------------------------------------------------
		call LABEL_AY_SR_Write	; WRITING 8BIT DATA (VAR_AY_CHIP_REG_ADDRESS, VAR_AY_CHIP_REG_DATA)TO AY REG(X) ROUTINE
		;; ==========================================================================================
			
	goto INC_FX_POS_FOR_THE_NEXT_FX_EXECUTION


FX_FUNC_025
	;; ENV ON B

	;; get CURRENT envelope shape
	call ENVELOPE_TRANSLATOR_CALL

	movff VAR_AY_CHIP_REG9_CH_B_AMPLITUDE, BNKD_VAR_Fx_TEMP
	;; SET bit 4 => ENV MODE ON B
	movff BNKD_VAR_Fx_TEMP, TMP4
	bsf	  TMP4, BIT4_ENVELOPE_ON_OFF
	movff TMP4, BNKD_VAR_Fx_TEMP

		;; ==========================================================================================
		;; SEND DATA TO AY CHIP
		movlw CONST_AY_CHIP_ADR_09_TONE_B_VOLUME_ENV_MODE_ON_OFF ; SELECT ADRESS => SET REGISTER OF AY CHIP
		movwf VAR_AY_CHIP_REG_ADDRESS 		; ADDRESS FOR 	=> AY_SR_Write
        	;; COPY DATA
        	movff BNKD_VAR_Fx_TEMP, VAR_AY_CHIP_REG_DATA
		;; --------------[SEND DATA TO AY CHIP]-----------------------------------------------------
		call LABEL_AY_SR_Write	; WRITING 8BIT DATA (VAR_AY_CHIP_REG_ADDRESS, VAR_AY_CHIP_REG_DATA)TO AY REG(X) ROUTINE
		;; ==========================================================================================
		;;; -------------[WRITE ENVELOPE SHAPE/CYCLE]------------------
		;; SEND DATA TO AY REG 13 (ENV. SHAPE Cycle REG)
		;; SET AY REGISTER
		movlw  CONST_AY_CHIP_ADR_13_ENVELOPE_SHAPE_AND_CYCLE	
		movwf  VAR_AY_CHIP_REG_ADDRESS 		
		;; WRITE GLOBAL [A|B|C] ENVELOPE SHAPE DATA TO AY CHIP
		movff  VAR_AY_CHIP_REG13_ENV_SHAPE_CYCLE, VAR_AY_CHIP_REG_DATA
		;; --------------[SEND DATA TO AY REG 13]-----------------------------------------------------
		call LABEL_AY_SR_Write	; WRITING 8BIT DATA (VAR_AY_CHIP_REG_ADDRESS, VAR_AY_CHIP_REG_DATA)TO AY REG(X) ROUTINE
		;; ==========================================================================================
			
	goto INC_FX_POS_FOR_THE_NEXT_FX_EXECUTION

FX_FUNC_026
	;; ENV OFF B
	movff VAR_AY_CHIP_REG9_CH_B_AMPLITUDE, BNKD_VAR_Fx_TEMP
	movff BNKD_VAR_Fx_TEMP, TMP4
	;; SET bit 4 => ENV MODE ON A
	bcf	TMP4, BIT4_ENVELOPE_ON_OFF
	movff TMP4, BNKD_VAR_Fx_TEMP
	
		;; ==========================================================================================
		;; SEND DATA TO AY CHIP
		movlw CONST_AY_CHIP_ADR_09_TONE_B_VOLUME_ENV_MODE_ON_OFF  ; SET AY CHIP REGISTER 	
		movwf VAR_AY_CHIP_REG_ADDRESS 						; => AY_SR_Write
        	;; COPY DATA
        	movff BNKD_VAR_Fx_TEMP, VAR_AY_CHIP_REG_DATA
		;; --------------[SEND DATA TO AY CHIP]-----------------------------------------------------
		call LABEL_AY_SR_Write	; WRITING 8BIT DATA (VAR_AY_CHIP_REG_ADDRESS, VAR_AY_CHIP_REG_DATA)TO AY REG(X) ROUTINE
		;; ==========================================================================================
		goto INC_FX_POS_FOR_THE_NEXT_FX_EXECUTION


FX_FUNC_027
	;; ENV ON C

	;; get CURRENT envelope shape
	call ENVELOPE_TRANSLATOR_CALL	

	movff VAR_AY_CHIP_REG10_CH_C_AMPLITUDE, BNKD_VAR_Fx_TEMP
	movff BNKD_VAR_Fx_TEMP, TMP4
	;; SET bit 4 => ENV MODE ON C
	bsf	TMP4, BIT4_ENVELOPE_ON_OFF
	movff TMP4, BNKD_VAR_Fx_TEMP
	
		;; ==========================================================================================
		;; SEND DATA TO AY CHIP
		movlw CONST_AY_CHIP_ADR_10_TONE_C_VOLUME_ENV_MODE_ON_OFF  ; SELECT ADRESS => SET REGISTER OF AY CHIP
		movwf VAR_AY_CHIP_REG_ADDRESS 						; ADDRESS FOR 	=> AY_SR_Write
        	;; COPY DATA
        	movff BNKD_VAR_Fx_TEMP, VAR_AY_CHIP_REG_DATA
		;; --------------[SEND DATA TO AY CHIP]-----------------------------------------------------
		call LABEL_AY_SR_Write	; WRITING 8BIT DATA (VAR_AY_CHIP_REG_ADDRESS, VAR_AY_CHIP_REG_DATA)TO AY REG(X) ROUTINE
		;; ==========================================================================================
		;;; -------------[WRITE ENVELOPE SHAPE/CYCLE]------------------
		;; SEND DATA TO AY REG 13 (ENV. SHAPE Cycle REG)
		;; SET AY REGISTER
		movlw  CONST_AY_CHIP_ADR_13_ENVELOPE_SHAPE_AND_CYCLE	
		movwf  VAR_AY_CHIP_REG_ADDRESS 		
		;; WRITE GLOBAL [A|B|C] ENVELOPE SHAPE DATA TO AY CHIP
		movff  VAR_AY_CHIP_REG13_ENV_SHAPE_CYCLE, VAR_AY_CHIP_REG_DATA
		;; --------------[SEND DATA TO AY REG 13]-----------------------------------------------------
		call LABEL_AY_SR_Write	; WRITING 8BIT DATA (VAR_AY_CHIP_REG_ADDRESS, VAR_AY_CHIP_REG_DATA)TO AY REG(X) ROUTINE
		;; ==========================================================================================
			
	goto INC_FX_POS_FOR_THE_NEXT_FX_EXECUTION

FX_FUNC_028
	;; ENV OFF C
	movff VAR_AY_CHIP_REG10_CH_C_AMPLITUDE, BNKD_VAR_Fx_TEMP
	movff BNKD_VAR_Fx_TEMP, TMP4
	;; SET bit 4 => ENV MODE ON A
	bcf	TMP4, BIT4_ENVELOPE_ON_OFF
	movff TMP4, BNKD_VAR_Fx_TEMP
	
		;; ==========================================================================================
		;; SEND DATA TO AY CHIP
		movlw CONST_AY_CHIP_ADR_10_TONE_C_VOLUME_ENV_MODE_ON_OFF 	; SET AY CHIP REGISTER 	
		movwf VAR_AY_CHIP_REG_ADDRESS 								; => AY_SR_Write
        	;; COPY DATA
        	movff BNKD_VAR_Fx_TEMP, VAR_AY_CHIP_REG_DATA
		;; --------------[SEND DATA TO AY CHIP]-----------------------------------------------------
		call LABEL_AY_SR_Write	; WRITING 8BIT DATA (VAR_AY_CHIP_REG_ADDRESS, VAR_AY_CHIP_REG_DATA)TO AY REG(X) ROUTINE
		;; ==========================================================================================
				
	goto INC_FX_POS_FOR_THE_NEXT_FX_EXECUTION

FX_FUNC_029
	;; WRITE ENV Shape/CYCLE	[Data: 1-8]
	movlw	CONST_ENVELOPE_SHAPE_MAX_VALUE_8 ; ENVELOPE SHAPE 1-8 (8 = Max Value)
	cpfsgt 	VAR_FX_TAB_ENTRY_CURRENT_PARAM
		;; NO,
		goto FX_FUNC_029_SHAOE_VALUE_CONVERSATION
	 	;; YES,
	 	;; FORMAT VALUE TO 0-8 (DELETE values > 8)
	 	movlw CONST_ENVELOPE_SHAPE_MAX_VALUE_8
	 	movwf VAR_FX_TAB_ENTRY_CURRENT_PARAM
		
FX_FUNC_029_SHAOE_VALUE_CONVERSATION
		
	;; ENVELOPE SHAPES TRANSLATION:
	;; MBAY CS ENV SHAPE 1 => AY Chip REG VALUE: 0-3	=> \__		[SHAPE 1]
	;; MBAY CS ENV SHAPE 2 => AY Chip REG VALUE: 4-7	=> /|_		[SHAPE 2]
	;; MBAY CS ENV SHAPE 3 => AY Chip REG VALUE: 8		=> |\|\		[SHAPE 3]
	;; MBAY CS ENV SHAPE 4 => AY Chip REG VALUE: 10		=> \/\/\	[SHAPE 4]
	;; MBAY CS ENV SHAPE 5 => AY Chip REG VALUE: 11		=> \|		[SHAPE 5]
	;; MBAY CS ENV SHAPE 6 => AY Chip REG VALUE: 12		=> /|/|		[SHAPE 6]
	;; MBAY CS ENV SHAPE 7 => AY Chip REG VALUE: 13		=> /		[SHAPE 7]
	;; MBAY CS ENV SHAPE 8 => AY Chip REG VALUE: 14		=> /\/\		[SHAPE 8]

	;; JUMP TO ENV SHAPE
	movf VAR_FX_TAB_ENTRY_CURRENT_PARAM, W
	JUMPTABLE_4BYTES 9 ;; [0-8 => ENV SHAPE 1-8]
		goto	FX_FUNC_029_SHAPE_1		;; (if VALUE=0 set ENV 1)
		goto	FX_FUNC_029_SHAPE_1		;; ENV 1 [ENV LED 1]
		goto 	FX_FUNC_029_SHAPE_2		;; ENV 2 [ENV LED 2]
		goto 	FX_FUNC_029_SHAPE_3		;; ENV 3 [ENV LED 3]
		goto 	FX_FUNC_029_SHAPE_4		;; ENV 4 [ENV LED 4]
		goto 	FX_FUNC_029_SHAPE_5		;; ENV 5 [ENV LED 5]
		goto 	FX_FUNC_029_SHAPE_6		;; ENV 6 [ENV LED 6]
		goto 	FX_FUNC_029_SHAPE_7		;; ENV 7 [ENV LED 7]
		goto 	FX_FUNC_029_SHAPE_8		;; ENV 8 [ENV LED 8]

FX_FUNC_029_SHAPE_1
	;; SET ENV SHAPE 
	movlw 0x03
	movwf VAR_FX_TAB_ENTRY_CURRENT_PARAM
	rgoto FX_FUNC_029_WRITE_TO_AY_CHIP

FX_FUNC_029_SHAPE_2
	;; SET ENV SHAPE
	movlw 0x07
	movwf VAR_FX_TAB_ENTRY_CURRENT_PARAM
	rgoto FX_FUNC_029_WRITE_TO_AY_CHIP

FX_FUNC_029_SHAPE_3
	;; SET ENV SHAPE
	movlw 0x08
	movwf VAR_FX_TAB_ENTRY_CURRENT_PARAM
	rgoto FX_FUNC_029_WRITE_TO_AY_CHIP


FX_FUNC_029_SHAPE_4
	;; SET ENV SHAPE
	movlw 0x0A
	movwf VAR_FX_TAB_ENTRY_CURRENT_PARAM
	rgoto FX_FUNC_029_WRITE_TO_AY_CHIP

FX_FUNC_029_SHAPE_5
	;; SET ENV SHAPE
	movlw 0x0B
	movwf VAR_FX_TAB_ENTRY_CURRENT_PARAM
	rgoto FX_FUNC_029_WRITE_TO_AY_CHIP


FX_FUNC_029_SHAPE_6
    ;; SET ENV SHAPE
	movlw 0x0C
	movwf VAR_FX_TAB_ENTRY_CURRENT_PARAM
	rgoto FX_FUNC_029_WRITE_TO_AY_CHIP

FX_FUNC_029_SHAPE_7
	;; SET ENV SHAPE
	movlw 0x0D
	movwf VAR_FX_TAB_ENTRY_CURRENT_PARAM
	rgoto FX_FUNC_029_WRITE_TO_AY_CHIP

FX_FUNC_029_SHAPE_8
	;; SET ENV SHAPE
	movlw 0x0E
	movwf VAR_FX_TAB_ENTRY_CURRENT_PARAM
	rgoto FX_FUNC_029_WRITE_TO_AY_CHIP

		
FX_FUNC_029_WRITE_TO_AY_CHIP	
		;; SEND DATA TO AY CHIP - ENV SHAPE CYCLE
		movlw CONST_AY_CHIP_ADR_13_ENVELOPE_SHAPE_AND_CYCLE  	; REG ADRESS 	=> AY REGISTER 13
		movwf VAR_AY_CHIP_REG_ADDRESS 							; ADDRESS FOR 	=> AY_SR_Write
        	
		;; ==========================================================================================
        	;; COPY DATA
        	movff VAR_FX_TAB_ENTRY_CURRENT_PARAM, VAR_AY_CHIP_REG_DATA
		;; --------------[SEND DATA TO AY CHIP]-----------------------------------------------------
		call LABEL_AY_SR_Write	; WRITING 8BIT DATA (VAR_AY_CHIP_REG_ADDRESS, VAR_AY_CHIP_REG_DATA)TO AY REG(X) ROUTINE
		;; ==========================================================================================
	
	goto INC_FX_POS_FOR_THE_NEXT_FX_EXECUTION


FX_FUNC_030
	;; ENV PERIOD Fine	[Data: 0-255]
		;; ==========================================================================================
		;; SEND DATA TO AY CHIP
		movlw CONST_AY_CHIP_ADR_11_GLOBAL_ENVELOPE_FINE 	; REG ADRESS 	=> AY REGISTER 11
		movwf VAR_AY_CHIP_REG_ADDRESS 						; ADDRESS FOR 	=> AY_SR_Write
        	;; COPY DATA
        	movff VAR_FX_TAB_ENTRY_CURRENT_PARAM, VAR_AY_CHIP_REG_DATA
		;; --------------[SEND DATA TO AY CHIP]-----------------------------------------------------
		call LABEL_AY_SR_Write	; WRITING 8BIT DATA (VAR_AY_CHIP_REG_ADDRESS, VAR_AY_CHIP_REG_DATA)TO AY REG(X) ROUTINE
		;; ==========================================================================================

		;; -------------[WRITE ENVELOPE DO CYCLE (ENV ON)]------------------------
		;; WRITE ENV. SHAPE & CYCLE
		;; SEND ENV DATA TO AY REG 13 (ENV. SHAPE/Cycle REG)
		movlw CONST_AY_CHIP_ADR_13_ENVELOPE_SHAPE_AND_CYCLE ; REG ADRESS of AY REGISTER
		movwf VAR_AY_CHIP_REG_ADDRESS 		
		;; WRITE ENVELOPE SHAPE CYCLE DATA TO AY CHIP
		movff VAR_AY_CHIP_REG13_ENV_SHAPE_CYCLE, VAR_AY_CHIP_REG_DATA
		;; --------------[SEND DATA TO AY REG 13]-----------------------------------------------------
		;; WRITING 8BIT DATA (VAR_AY_CHIP_REG_ADDRESS, VAR_AY_CHIP_REG_DATA)TO AY REG(X) ROUTINE
		call LABEL_AY_SR_Write	
		;; ==========================================================================================
	
	goto INC_FX_POS_FOR_THE_NEXT_FX_EXECUTION

FX_FUNC_031
	;; WRITE ENV PERIOD Coarse	[Data: 0-255]
		;; ==========================================================================================
		;; SEND DATA TO AY CHIP
		movlw CONST_AY_CHIP_ADR_12_GLOBAL_ENVELOPE_COARSE 	; REG ADRESS 	=> AY REGISTER 12
		movwf VAR_AY_CHIP_REG_ADDRESS 						; ADDRESS FOR 	=> AY_SR_Write
        	;; COPY DATA
        	movff VAR_FX_TAB_ENTRY_CURRENT_PARAM, VAR_AY_CHIP_REG_DATA
		;; --------------[SEND DATA TO AY CHIP]-----------------------------------------------------
		call LABEL_AY_SR_Write	; WRITING 8BIT DATA (VAR_AY_CHIP_REG_ADDRESS, VAR_AY_CHIP_REG_DATA)TO AY REG(X) ROUTINE
		;; ==========================================================================================

		;; -------------[WRITE ENVELOPE DO CYCLE (ENV ON)]------------------------
		;; WRITE ENV. SHAPE & CYCLE
		;; SEND ENV DATA TO AY REG 13 (ENV. SHAPE/Cycle REG)
		movlw CONST_AY_CHIP_ADR_13_ENVELOPE_SHAPE_AND_CYCLE ; REG ADRESS of AY REGISTER
		movwf VAR_AY_CHIP_REG_ADDRESS 		
		;; WRITE ENVELOPE SHAPE CYCLE DATA TO AY CHIP
		movff VAR_AY_CHIP_REG13_ENV_SHAPE_CYCLE, VAR_AY_CHIP_REG_DATA
		;; --------------[SEND DATA TO AY REG 13]-----------------------------------------------------
		;; WRITING 8BIT DATA (VAR_AY_CHIP_REG_ADDRESS, VAR_AY_CHIP_REG_DATA)TO AY REG(X) ROUTINE
		call LABEL_AY_SR_Write	
		;; ==========================================================================================
	
	goto INC_FX_POS_FOR_THE_NEXT_FX_EXECUTION

FX_FUNC_032
	;; WRITE NOTE ON #1 ==> Tone A
	
		;; SEND DATA TO AY CHIP
		movlw CONST_AY_CHIP_ADR_00_TONE_A_FREQUENCY_FINE	; REG ADRESS 	=> AY REGISTER 0
		movwf VAR_AY_CHIP_REG_ADDRESS 		; ADDRESS FOR 	=> AY_SR_Write
        	

		;; ==========================================================================================
        	;; COPY DATA
        	movff BNKD_VAR_FX_NOTE_ON_1_TUNE_FINE, VAR_AY_CHIP_REG_DATA
		;; --------------[SEND DATA TO AY CHIP]-----------------------------------------------------
		call LABEL_AY_SR_Write	; WRITING 8BIT DATA (VAR_AY_CHIP_REG_ADDRESS, VAR_AY_CHIP_REG_DATA)TO AY REG(X) ROUTINE
		;; ==========================================================================================
		movlw CONST_AY_CHIP_ADR_01_TONE_A_FREQUENCY_PERIOD_COARSE	; REG ADRESS 	=> AY REGISTER 12
		movwf VAR_AY_CHIP_REG_ADDRESS 		; ADDRESS FOR 	=> AY_SR_Write
        	;; COPY DATA
        	movff BNKD_VAR_FX_NOTE_ON_1_TUNE_COARSE, VAR_AY_CHIP_REG_DATA
		;; --------------[SEND DATA TO AY CHIP]-----------------------------------------------------
		call LABEL_AY_SR_Write	; WRITING 8BIT DATA (VAR_AY_CHIP_REG_ADDRESS, VAR_AY_CHIP_REG_DATA)TO AY REG(X) ROUTINE
		;; ==========================================================================================
				
	goto INC_FX_POS_FOR_THE_NEXT_FX_EXECUTION

FX_FUNC_033
	;; WRITE NOTE ON #1 ==> Tone B
		;; SEND DATA TO AY CHIP
		movlw CONST_AY_CHIP_ADR_02_TONE_B_FREQUENCY_PERIOD_FINE  ; REG ADRESS 	=> AY REGISTER 12
		movwf VAR_AY_CHIP_REG_ADDRESS 		; ADDRESS FOR 	=> AY_SR_Write
		;; ==========================================================================================        	
        	;; COPY DATA
        	movff BNKD_VAR_FX_NOTE_ON_1_TUNE_FINE, VAR_AY_CHIP_REG_DATA
		;; --------------[SEND DATA TO AY CHIP]-----------------------------------------------------
		call LABEL_AY_SR_Write	; WRITING 8BIT DATA (VAR_AY_CHIP_REG_ADDRESS, VAR_AY_CHIP_REG_DATA)TO AY REG(X) ROUTINE
		;; ==========================================================================================
		movlw CONST_AY_CHIP_ADR_03_TONE_B_FREQUENCY_PERIOD_COARSE ; REG ADRESS 	=> AY REGISTER 12
		movwf VAR_AY_CHIP_REG_ADDRESS 		; ADDRESS FOR 	=> AY_SR_Write
        	;; COPY DATA
        	movff BNKD_VAR_FX_NOTE_ON_1_TUNE_COARSE, VAR_AY_CHIP_REG_DATA
		;; --------------[SEND DATA TO AY CHIP]-----------------------------------------------------
		call LABEL_AY_SR_Write	; WRITING 8BIT DATA (VAR_AY_CHIP_REG_ADDRESS, VAR_AY_CHIP_REG_DATA)TO AY REG(X) ROUTINE
		;; ==========================================================================================
	
	goto INC_FX_POS_FOR_THE_NEXT_FX_EXECUTION

FX_FUNC_034
	;; WRITE NOTE ON #1 ==> Tone C
		
		;; SEND DATA TO AY CHIP
		movlw CONST_AY_CHIP_ADR_04_TONE_C_FREQUENCY_PERIOD_FINE ; REG ADRESS 	=> AY REGISTER
		movwf VAR_AY_CHIP_REG_ADDRESS 		; ADDRESS FOR 	=> AY_SR_Write
		
		;; ==========================================================================================        	
        	;; COPY DATA
        	movff BNKD_VAR_FX_NOTE_ON_1_TUNE_FINE, VAR_AY_CHIP_REG_DATA
		;; --------------[SEND DATA TO AY CHIP]-----------------------------------------------------
		call LABEL_AY_SR_Write	; WRITING 8BIT DATA (VAR_AY_CHIP_REG_ADDRESS, VAR_AY_CHIP_REG_DATA)TO AY REG(X) ROUTINE
		;; ==========================================================================================
		movlw CONST_AY_CHIP_ADR_05_TONE_C_TONE_PERIOD_COARSE ; REG ADRESS 	=> AY REGISTER
		movwf VAR_AY_CHIP_REG_ADDRESS 		; ADDRESS FOR 	=> AY_SR_Write
        	;; COPY DATA
        	movff BNKD_VAR_FX_NOTE_ON_1_TUNE_COARSE, VAR_AY_CHIP_REG_DATA
		;; --------------[SEND DATA TO AY CHIP]-----------------------------------------------------
		call LABEL_AY_SR_Write	; WRITING 8BIT DATA (VAR_AY_CHIP_REG_ADDRESS, VAR_AY_CHIP_REG_DATA)TO AY REG(X) ROUTINE
		;; ==========================================================================================
	
	goto INC_FX_POS_FOR_THE_NEXT_FX_EXECUTION

FX_FUNC_035
	;; 0x1F => WRITE NOTE ON #2 ==> Tone A
	;; SEND DATA TO AY CHIP
	movlw CONST_AY_CHIP_ADR_00_TONE_A_FREQUENCY_FINE  ; REG ADRESS 	=> AY REGISTER 
	movwf VAR_AY_CHIP_REG_ADDRESS 				; ADDRESS FOR 	=> AY_SR_Write
		
		;; ==========================================================================================        	
        	;; COPY DATA
        	movff BNKD_VAR_FX_NOTE_ON_2_TUNE_FINE, VAR_AY_CHIP_REG_DATA
		;; --------------[SEND DATA TO AY CHIP]-----------------------------------------------------
		call LABEL_AY_SR_Write	; WRITING 8BIT DATA (VAR_AY_CHIP_REG_ADDRESS, VAR_AY_CHIP_REG_DATA)TO AY REG(X) ROUTINE
		;; ==========================================================================================
		movlw CONST_AY_CHIP_ADR_01_TONE_A_FREQUENCY_PERIOD_COARSE  ; REG ADRESS 	=> AY REGISTER 
		movwf VAR_AY_CHIP_REG_ADDRESS 		; ADDRESS FOR 	=> AY_SR_Write
        	;; COPY DATA
        	movff BNKD_VAR_FX_NOTE_ON_2_TUNE_COARSE, VAR_AY_CHIP_REG_DATA
		;; --------------[SEND DATA TO AY CHIP]-----------------------------------------------------
		call LABEL_AY_SR_Write	; WRITING 8BIT DATA (VAR_AY_CHIP_REG_ADDRESS, VAR_AY_CHIP_REG_DATA)TO AY REG(X) ROUTINE
		;; ==========================================================================================
				
	goto INC_FX_POS_FOR_THE_NEXT_FX_EXECUTION

FX_FUNC_036
	;; 0x20 => WRITE NOTE ON #2 ==> Tone B
	;; SEND DATA TO AY CHIP
	movlw CONST_AY_CHIP_ADR_02_TONE_B_FREQUENCY_PERIOD_FINE  ; REG ADRESS 	=> AY REGISTER 
	movwf VAR_AY_CHIP_REG_ADDRESS 		; ADDRESS FOR 	=> AY_SR_Write
		;; ==========================================================================================
        	;; COPY DATA
        	movff BNKD_VAR_FX_NOTE_ON_2_TUNE_FINE, VAR_AY_CHIP_REG_DATA
		;; --------------[SEND DATA TO AY CHIP]-----------------------------------------------------
		call LABEL_AY_SR_Write	; WRITING 8BIT DATA (VAR_AY_CHIP_REG_ADDRESS, VAR_AY_CHIP_REG_DATA)TO AY REG(X) ROUTINE
		;; ==========================================================================================
		movlw CONST_AY_CHIP_ADR_03_TONE_B_FREQUENCY_PERIOD_COARSE  ; REG ADRESS 	=> AY REGISTER 
		movwf VAR_AY_CHIP_REG_ADDRESS 		; ADDRESS FOR 	=> AY_SR_Write
        	;; COPY DATA
        	movff BNKD_VAR_FX_NOTE_ON_2_TUNE_COARSE, VAR_AY_CHIP_REG_DATA
		;; --------------[SEND DATA TO AY CHIP]-----------------------------------------------------
		call LABEL_AY_SR_Write	; WRITING 8BIT DATA (VAR_AY_CHIP_REG_ADDRESS, VAR_AY_CHIP_REG_DATA)TO AY REG(X) ROUTINE
		;; ==========================================================================================
		
	goto INC_FX_POS_FOR_THE_NEXT_FX_EXECUTION

FX_FUNC_037
	;; 0x21 => WRITE NOTE ON #2 ==> Tone C
	;; SEND DATA TO AY CHIP
		
		;; ==========================================================================================
		movlw CONST_AY_CHIP_ADR_04_TONE_C_FREQUENCY_PERIOD_FINE  ; REG ADRESS 	=> AY REGISTER 
		movwf VAR_AY_CHIP_REG_ADDRESS 		; ADDRESS FOR 	=> AY_SR_Write
		;; COPY DATA
        	movff BNKD_VAR_FX_NOTE_ON_2_TUNE_FINE, VAR_AY_CHIP_REG_DATA
		;; --------------[SEND DATA TO AY CHIP]-----------------------------------------------------
		call LABEL_AY_SR_Write	; WRITING 8BIT DATA (VAR_AY_CHIP_REG_ADDRESS, VAR_AY_CHIP_REG_DATA)TO AY REG(X) ROUTINE
		;; ==========================================================================================
		movlw CONST_AY_CHIP_ADR_05_TONE_C_TONE_PERIOD_COARSE  ; REG ADRESS 	=> AY REGISTER 
		movwf VAR_AY_CHIP_REG_ADDRESS 		; ADDRESS FOR 	=> AY_SR_Write
        	;; COPY DATA
        	movff BNKD_VAR_FX_NOTE_ON_2_TUNE_COARSE, VAR_AY_CHIP_REG_DATA
		;; --------------[SEND DATA TO AY CHIP]-----------------------------------------------------
		call LABEL_AY_SR_Write	; WRITING 8BIT DATA (VAR_AY_CHIP_REG_ADDRESS, VAR_AY_CHIP_REG_DATA)TO AY REG(X) ROUTINE
		;; ==========================================================================================

	goto INC_FX_POS_FOR_THE_NEXT_FX_EXECUTION

FX_FUNC_038
	;; WRITE NOTE ON #3 ==> Tone A
		;; ==========================================================================================
		;; SEND DATA TO AY CHIP
		movlw CONST_AY_CHIP_ADR_00_TONE_A_FREQUENCY_FINE  	; REG ADRESS 	=> AY REGISTER 
		movwf VAR_AY_CHIP_REG_ADDRESS 						; ADDRESS FOR 	=> AY_SR_Write
        	;; COPY DATA
        	movff BNKD_VAR_FX_NOTE_ON_3_TUNE_FINE, VAR_AY_CHIP_REG_DATA
		;; --------------[SEND DATA TO AY CHIP]-----------------------------------------------------
		call LABEL_AY_SR_Write	; WRITING 8BIT DATA (VAR_AY_CHIP_REG_ADDRESS, VAR_AY_CHIP_REG_DATA)TO AY REG(X) ROUTINE
		;; ==========================================================================================
		movlw CONST_AY_CHIP_ADR_01_TONE_A_FREQUENCY_PERIOD_COARSE  ; REG ADRESS 	=> AY REGISTER 
		movwf VAR_AY_CHIP_REG_ADDRESS 		; ADDRESS FOR 	=> AY_SR_Write
        	;; COPY DATA
        	movff BNKD_VAR_FX_NOTE_ON_3_TUNE_COARSE, VAR_AY_CHIP_REG_DATA
		;; --------------[SEND DATA TO AY CHIP]-----------------------------------------------------
		call LABEL_AY_SR_Write	; WRITING 8BIT DATA (VAR_AY_CHIP_REG_ADDRESS, VAR_AY_CHIP_REG_DATA)TO AY REG(X) ROUTINE
		;; ==========================================================================================
			
	goto INC_FX_POS_FOR_THE_NEXT_FX_EXECUTION

FX_FUNC_039
	;; 0x23 => WRITE NOTE ON #3 ==> Tone B
		;; ==========================================================================================
		;; SEND DATA TO AY CHIP
		movlw CONST_AY_CHIP_ADR_02_TONE_B_FREQUENCY_PERIOD_FINE  ; REG ADRESS 	=> AY REGISTER 
		movwf VAR_AY_CHIP_REG_ADDRESS 		; ADDRESS FOR 	=> AY_SR_Write
        	;; COPY DATA
        	movff BNKD_VAR_FX_NOTE_ON_3_TUNE_FINE, VAR_AY_CHIP_REG_DATA
		;; --------------[SEND DATA TO AY CHIP]-----------------------------------------------------
		call LABEL_AY_SR_Write	; WRITING 8BIT DATA (VAR_AY_CHIP_REG_ADDRESS, VAR_AY_CHIP_REG_DATA)TO AY REG(X) ROUTINE
		;; ==========================================================================================
		movlw CONST_AY_CHIP_ADR_03_TONE_B_FREQUENCY_PERIOD_COARSE  ; REG ADRESS 	=> AY REGISTER 
		movwf VAR_AY_CHIP_REG_ADDRESS 		; ADDRESS FOR 	=> AY_SR_Write
        	;; COPY DATA
        	movff BNKD_VAR_FX_NOTE_ON_3_TUNE_COARSE, VAR_AY_CHIP_REG_DATA
		;; --------------[SEND DATA TO AY CHIP]-----------------------------------------------------
		call LABEL_AY_SR_Write	; WRITING 8BIT DATA (VAR_AY_CHIP_REG_ADDRESS, VAR_AY_CHIP_REG_DATA)TO AY REG(X) ROUTINE
		;; ==========================================================================================
			
	goto INC_FX_POS_FOR_THE_NEXT_FX_EXECUTION

FX_FUNC_040
	;; WRITE NOTE ON #3 ==> Tone C
		;; ==========================================================================================
		;; SEND DATA TO AY CHIP
		movlw CONST_AY_CHIP_ADR_04_TONE_C_FREQUENCY_PERIOD_FINE  ; REG ADRESS 	=> AY REGISTER 
		movwf VAR_AY_CHIP_REG_ADDRESS 		; ADDRESS FOR 	=> AY_SR_Write
        ;; COPY DATA
        movff BNKD_VAR_FX_NOTE_ON_3_TUNE_FINE, VAR_AY_CHIP_REG_DATA
		;; --------------[SEND DATA TO AY CHIP]-----------------------------------------------------
		call LABEL_AY_SR_Write	; WRITING 8BIT DATA (VAR_AY_CHIP_REG_ADDRESS, VAR_AY_CHIP_REG_DATA)TO AY REG(X) ROUTINE
		;; ==========================================================================================
		movlw CONST_AY_CHIP_ADR_05_TONE_C_TONE_PERIOD_COARSE ; REG ADRESS 	=> AY REGISTER 
		movwf VAR_AY_CHIP_REG_ADDRESS 							; ADDRESS FOR 	=> AY_SR_Write
        ;; COPY DATA
        movff BNKD_VAR_FX_NOTE_ON_3_TUNE_COARSE, VAR_AY_CHIP_REG_DATA
		;; --------------[SEND DATA TO AY CHIP]-----------------------------------------------------
		call LABEL_AY_SR_Write	; WRITING 8BIT DATA (VAR_AY_CHIP_REG_ADDRESS, VAR_AY_CHIP_REG_DATA)TO AY REG(X) ROUTINE
		;; ==========================================================================================
			
			
	goto INC_FX_POS_FOR_THE_NEXT_FX_EXECUTION


FX_FUNC_041
	;; GOTO Fx POS 	[Data: 0-31]
	;; set FX_POS_CURRENT
	movff VAR_FX_TAB_ENTRY_CURRENT_PARAM, VAR_POINTER_TO_CURRENT_FX_TAB_ENTRY
	
	;; IS THE GOTO POS VALID?
	movlw FX_POS_MAX_31 
	cpfsgt VAR_POINTER_TO_CURRENT_FX_TAB_ENTRY
		;; FX POS IS OK
		rgoto FX_FUNC_041_RESET_FX_TIMER
	 		
	 	;; FX_POS IS OUT OF RANG 
	 	;; SET FX POS TO MAX = POS 31
	 	movlw FX_POS_MAX_31 
	 	movwf VAR_POINTER_TO_CURRENT_FX_TAB_ENTRY

	
FX_FUNC_041_RESET_FX_TIMER			
	;; RESET FX Timer for the next Fx Pos Cycle
	clrf 	TMP4
	movff	TMP4, BNKD_VAR_FX_TIMER
	
	;; GO AND LOAD NEW POS
	goto FX_PIPELINE_LOAD_FX_TAB_ENTRY_AND_EXIT

;; -------------------------------------------------------------------------
;; -------------------------------------------------------------------------
;; -------------------------------------------------------------------------


INC_FX_POS_FOR_THE_NEXT_FX_EXECUTION
	;; INC FX TAB ENTRY POS +1

	;; First: RESET FX Timer for the next Fx Pos Cycle
	clrf 	TMP4
	movff	TMP4, BNKD_VAR_FX_TIMER
	
	;; INC FX TAB CURRENT ENTRY	+1
	incf 	VAR_POINTER_TO_CURRENT_FX_TAB_ENTRY, F
	
	;; CHECK IF Fx Tab ENTRY Pos > 31
	;; VALID RANGE OF FX TAB = 0 to 31
	movlw FX_POS_MAX_31  
	cpfsgt VAR_POINTER_TO_CURRENT_FX_TAB_ENTRY
		;; NO - OK QUIT HERE
		goto FX_PIPELINE_LOAD_FX_TAB_ENTRY_AND_EXIT

		;; YES - END OF FX TAB
		;; SET Fx NOP = ON = END OF Fx
		;; SET FX MODE TO NOP (NO Fx OPERATION)
		setf 	TMP4
		movff	TMP4, BNKD_VAR_STATE_FX_NOP_MODE	;; SET Fx NOP
		;; exit here
		return

FX_PIPELINE_LOAD_FX_TAB_ENTRY_AND_EXIT
			;; LOAD FX TAB ENTRY 
			call LOAD_FX_TAB_CURRENT_ENTRY
			;; EXIT
			;; END OF CURRENT FX CYCLE			
			return


;; ----------------------------------------------------------------

;; ----------------------------------------------------------------
;; #####################  Fx Calls  ###############################
;; ----------------------------------------------------------------
;; Call: Load FX TAB CURRENT ENTRY 
;; * POINTER TO FX TAB ENTRY =	VAR_POINTER_TO_CURRENT_FX_TAB_ENTRY 
;; * 

LOAD_FX_TAB_CURRENT_ENTRY
	;; SUBROUTINE used by Fx pipeline 
	;; DO INDIRECT RAM ACCESS via FSR0
	movlw CONST_BSR2_SELECT_Fx_RAM_BANK 		;; SET IDIRECT RAM ACCESS REG FSR0 
	movwf FSR0H									;; RAM BANK: FX TAB RAM EREA
					
	;; LOAD FX FUNCTION BYTE (FX FUNCTION VALUE)
	movlw CONST_RAM_ADR_OFFSET_FX_FUNCTION			;; OFFSET @ RAM BANK 2 @ The RAM AREA of FX FUNCTIONS (in the Fx Data Area)	
	addwf VAR_POINTER_TO_CURRENT_FX_TAB_ENTRY, W	;; + POINTER TO CURRENT FX TAB ENTRY (POS 0 to 31)
	movwf FSR0L				 						;; STORE CURRENT FX TAB ENTRY OFFSET 
	movff INDF0, VAR_FX_TAB_ENTRY_CURRENT_FUNCTION 	;; WRITE FX FUNCTION @ CURRENT Session Pos to Working Register

	;; LOAD FX Data Reg. @ CURRENT SESSION Pos (in the Fx Data Area)	
	movlw RAM_OFFSET_FX_DATA					;; OFFSET @ RAM BANK 2 @ The RAM AREA of FX Data (in the Fx Data Area)	
	addwf VAR_POINTER_TO_CURRENT_FX_TAB_ENTRY, W		;; + (0 to 31 [32]) => Fx Tab Pos
	movwf FSR0L		;; SET CURRENT OFFSET to Fx DATA @ current Fx SESSION Pos.
	movff INDF0, VAR_FX_TAB_ENTRY_CURRENT_PARAM		;; WRITE FX Data @ CURRENT SESSION POS to Working Register

	;; LOAD FX TIME DELAY @ CURRENT SESSION Pos (in the Fx Data Area)
	movlw RAM_OFFSET_FX_TIME_PRE_EXECUTION  		;; OFFSET @ RAM BANK 2 -  
													;; The RAM AREA of FX TIME DELAY REGS (in the Fx Data Area)	 
	addwf VAR_POINTER_TO_CURRENT_FX_TAB_ENTRY, W	;; + (0 to 31 [32]) => Fx Tab Pos
	movwf FSR0L										;; SET CURRENT OFFSET To Ind. Reg Adress
	movff INDF0, VAR_FX_TAB_ENTRY_CURRENT_TIME_PRE_EXECUTION	;; WRITE FX Pre Execution Time 
													;; @ CURRENT Session Pos to Working Register
		;; End of Subroutine
		return

;; --------------------------------------------------------------------------



;; ##############################################################################
;; Fx Call to Load TUNE #1, #2 + #3
WRITE_FX_TUNE_1_2_3
		;; For Fx Tunes #123
		;; Save the last 3 Note On Values
		;; 1) Fx Tune #2 	=> Fx Tune #3 (last but two Tune)
		;; 2) Fx Tune #1 	=> Fx Tune #2 (last but one Tune)
		;; 3) CURRENT Note On 	=> Fx Tune #1 (last Tune)
		movff BNKD_VAR_FX_NOTE_ON_2_TUNE_COARSE, BNKD_VAR_FX_NOTE_ON_3_TUNE_COARSE
		movff BNKD_VAR_FX_NOTE_ON_2_TUNE_FINE,   BNKD_VAR_FX_NOTE_ON_3_TUNE_FINE

		movff BNKD_VAR_FX_NOTE_ON_1_TUNE_COARSE, BNKD_VAR_FX_NOTE_ON_2_TUNE_COARSE
		movff BNKD_VAR_FX_NOTE_ON_1_TUNE_FINE,   BNKD_VAR_FX_NOTE_ON_2_TUNE_FINE
		
		movff VAR_TONE_A_TUNE_COARSE_MIDI, BNKD_VAR_FX_NOTE_ON_1_TUNE_COARSE
		movff VAR_TONE_A_TUNE_FINE_MIDI,   BNKD_VAR_FX_NOTE_ON_1_TUNE_FINE
		
		;; exit here
		return


;; ##############################################################################
;; ##############################################################################
;; Fx Call for Tune +
;; (1)
;; TUNE COARSE A|B|C => BNKD_FX_TUNE_COARSE_TEMP
;; TUNE FINE   A|B|C => BNKD_FX_TUNE_FINE_TEMP
;; bevor call
;;
;; (2)
;; BNKD_FX_TUNE_FINE_TEMP - CURRENT Fx DATA BYTE
;; 
;; (3)
;; BORROW HANDLING IF NEEDED (DEC BNKD_FX_TUNE_COARSE_TEMP -1)
;; (3a) SET BNKD_FX_TUNE_COARSE_TEMP and BNKD_FX_TUNE_FINE_TEMP Min. Value if needed
;; 
;; (4)
;; after return
;; BNKD_FX_TUNE_COARSE_TEMP  => TUNE COARSE A|B|C
;; BNKD_FX_TUNE_FINE_TEMP    => TUNE FINE   A|B|C
FX_TUNE_PLUS
	;; F > W
	movf VAR_FX_TAB_ENTRY_CURRENT_PARAM, W
	
	
	;; BNKD_FX_TUNE_FINE_TEMP - CURRENT Fx DATA BYTE
	movff	BNKD_FX_TUNE_FINE_TEMP, TMP4
	;; 	setze das Carry-Flag
	setc
	subwfb 	TMP4, F	
			;; ---[DO: CHECK BORROW BIT---------------------------------
			;; IF THE BORROW BIT appear DEC BORROR BIT @ COARSE TUNE REG
			;; bnc = BRANCH IF NOT CARRY
			bnc FX_TUNE_PLUS_BORROW_BIT_HANDLING
		
			;; NO BORROW BIT
			;; ALL DONE EXIT
			movff	TMP4, BNKD_FX_TUNE_FINE_TEMP
			return

		

FX_TUNE_PLUS_BORROW_BIT_HANDLING
			movff	TMP4, BNKD_FX_TUNE_FINE_TEMP
			;; CHECK IF COARSE IS ALLREADY B'0000 0000'
			movff	BNKD_FX_TUNE_COARSE_TEMP, TMP4
			movlw  	0x00
			cpfseq 	TMP4
				;; COARSE TUNE REG IS > 0
				rgoto FX_TUNE_PLUS_BORROW_BIT_HANDLING_DEC_COARSE
			
				;; COARSE TUNE REG IS = 0
				rgoto FX_TUNE_PLUS_BORROW_BIT_HANDLING_SET_HIGHEST_TUNE

FX_TUNE_PLUS_BORROW_BIT_HANDLING_DEC_COARSE
				;; SUBTRACT THE BORROW BIT FROM COARSE TUNE REG
				movff	BNKD_FX_TUNE_COARSE_TEMP, TMP4
				decf 	TMP4, F
				movff	TMP4, BNKD_FX_TUNE_COARSE_TEMP
				;; ALL DONE EXIT
				return

FX_TUNE_PLUS_BORROW_BIT_HANDLING_SET_HIGHEST_TUNE
				;; highest Value of FINE TUNE REG IF COARSE TUNE REG IS 0
				movlw CONST_FINE_TUNE_MIN_VALUE_B00001010
				movff WREG, BNKD_FX_TUNE_FINE_TEMP
				;; ALL DONE EXIT
				return
	

;; ##############################################################################
;; FX Call for Tune -
;; (1)
;; TUNE COARSE A|B|C => BNKD_FX_TUNE_COARSE_TEMP
;; TUNE FINE   A|B|C => BNKD_FX_TUNE_FINE_TEMP
;; bevor call
;;
;; (2)
;; BNKD_FX_TUNE_COARSE_TEMP + CURRENT Fx DATA BYTE
;; 
;; (3)
;; CARRY BIT HANDLING IF NEEDED (INC BNKD_FX_TUNE_COARSE_TEMP +1)
;; (3a) SET BNKD_FX_TUNE_COARSE_TEMP and BNKD_FX_TUNE_FINE_TEMP Max Value if needed
;; 
;; (4)
;; after return
;; BNKD_FX_TUNE_COARSE_TEMP  => TUNE COARSE A|B|C
;; BNKD_FX_TUNE_FINE_TEMP    => TUNE FINE   A|B|C
FX_TUNE_MINUS
	;; COPY CURRENT FX DATA BYTE TO WREG
	movf VAR_FX_TAB_ENTRY_CURRENT_PARAM, W
	
	movff 	BNKD_FX_TUNE_FINE_TEMP, TMP4
	clrc ;; CLEAR CARRY BIT @ STATUS REG
	;; BNKD_FX_TUNE_FINE_TEMP REG [PLUS] CURRENT Fx DATA BYTE
	addwfc TMP4, F	
			;; CHECK CARRY BIT (BRACH IF IT IS SET) 
			bc FX_TUNE_MINUS_CARRY_BIT_HANDLING
		
			;; NO CARRY BIT
			;; ALL DONE EXIT
			movff 	TMP4, BNKD_FX_TUNE_FINE_TEMP
			return

		

FX_TUNE_MINUS_CARRY_BIT_HANDLING
			;; CHECK IF COARSE REG IS ALLREADY B'0000 1111' DEC. 15, HEX 0x0F
			movff	BNKD_FX_TUNE_COARSE_TEMP, TMP4
			movlw 	CONST_COARSE_TUNE_MAX_MINUS_1_B00001110
			cpfsgt 	TMP4
				;; COARSE TUNE REG IS < 0x0F (VALID)
				rgoto FX_TUNE_MINUS_CARRY_BIT_HANDLING_INC_COARSE
				
				;; VALUE NOT VALID 
				;; COARSE TUNE REG IS > 0x0E = 0x0F or greater so +1 inc Carry will 
				;; not be a VALID value
				rgoto FX_TUNE_MINUS_CARRY_BIT_HANDLING_SET_LOWEST_TUNE
				
FX_TUNE_MINUS_CARRY_BIT_HANDLING_INC_COARSE
				;; INC THE CARRY BIT @ COARSE TUNE REG
				movff	BNKD_FX_TUNE_COARSE_TEMP, TMP4
				incf 	TMP4, F
				movff	TMP4, BNKD_FX_TUNE_COARSE_TEMP
				;; ALL DONE EXIT
				return

FX_TUNE_MINUS_CARRY_BIT_HANDLING_SET_LOWEST_TUNE
		;; Lowest Value of COARSE TUNE REG IS B'0000 1111' / DEC. 15 / HEX 0x0F
		movlw CONST_COARSE_TUNE_MAX_VALUE_B00001111
		movff WREG, BNKD_FX_TUNE_COARSE_TEMP
		;; Lowest Value of FINE TUNE REG IS in this case 0xD2
		movlw CONST_FINE_TUNE_MAX_VALUE_B11010010
		movff WREG, BNKD_FX_TUNE_FINE_TEMP
		return


;; ##############################################################################
;; ##############################################################################
;; ----------------------------[END Fx Calls]------------------------------------
