
;; FUNCTION:
;; WRITE TONE ABC VOLUME (AMPLITUDE) MAIN MENU TO THE LCD
;; CHECK IF ENVELOPE MODE IS ON - IF YES THAN PRINT [ENV.ON] (priority 1)
;; CHECK IF VELOCITY TO VOLUME IS ON - IF YES THAN PRINT [VELOCITY] (priority 2)
;; CHECK THE AMPLITUDE/VOLUME - PRINT THE VALUE (0-15) ON LCD (priority 3)

MENU_04_ABC_AMPLITUDE
	;; -----------------[CS F1-F8 BTN LED'S = OFF ]-----------------------------------------
	call	LED_F1_on
	call	LED_F2_on
	call	LED_F3_on
	call	LED_F4_on
	call	LED_F5_on
	call	LED_F6_on
	call	LED_F7_off
	call	LED_F8_off
	
	;; ------------------[CLEAR LCD               ]------------------------------------------
	call    MIOS_LCD_Clear

MENU4_JUMP_IN_POINT_FOR_CC_VALUE_LCD_MENU_REFRESH

	;; ------------------[AMPLITUDE TONE A        ]------------------------------------------
	;; WRITE MENUE HEADLINE @ LCD ROW1
    TABLE_ADDR TEXT_AY_MENU_AMPLITUDE_HEADLINE
    call    MIOS_LCD_PrintString
	;; TONE A @ ROW2
	TABLE_ADDR TEXT_AY_MENU_AMPLITUDE_CH_A
    call    MIOS_LCD_PrintString
	movlw   LCD_ROW2 + 13
	call    MIOS_LCD_CursorSet
	;; WRITE VOLUME TONE A VALUE
	movf    VAR_AY_CHIP_REG8_CH_A_AMPLITUDE, W
	call	MIOS_LCD_PrintBCD2

	;; -----[CHECK: VELOCITY @ TONE A is ON or OFF?       ]-------------------------
	;; BIT0 CLEAR? 
	btfsc VAR_VELOCITY_TO_ABC_NOISE_PERIOD_ON_OFF, BIT0_VELOCITY_ON_OFF_TONE_A
		;; NO,
		;; BIT0 = SET => VELOCITY TO VOLUME ON
		rgoto  MENU4_TONE_A_VELOCITY_IS_ON
		
		;; YES,
		;; BIT0 = CLEAR => VELOCITY IS *NOT* VOLUME
		;; GO AND CHK ENVELOPE @ TONE A?
		rgoto  MENU4_CHK_ENV_MODE_CH_A

MENU4_TONE_A_VELOCITY_IS_ON
		;; WRITE [VELOCETY] on LCD @ TONE A
		TABLE_ADDR TEXT_AY_MENU_AMPLITUDE_CH_A_VELOC
		call    MIOS_LCD_PrintString
		;; GO AND CHK ENV ON @ TONE A

MENU4_CHK_ENV_MODE_CH_A
	;; IS ENV MODE @ TONE A (BIT4) ON OR OFF?
	btfsc VAR_AY_CHIP_REG8_CH_A_AMPLITUDE, BIT4_ENVELOPE_ON_OFF
	      ;; ENV @ TONE = SET
	      rgoto MENU4_ENV_MODE_TONE_A_SET

	      ;; ENV MODE @ TONE A = OFF
	      ;; GO ON CHECK TONE B 
	      rgoto MENU4_AMPLITUDE_TONE_B

;; --------------------[AMPLITUDE TONE B]----------------------------------------
MENU4_AMPLITUDE_TONE_B
        ;; AMPLITUDE CH B
        TABLE_ADDR TEXT_AY_MENU_AMPLITUDE_CH_B
        call    MIOS_LCD_PrintString

        movlw   LCD_ROW3 + 13
        call    MIOS_LCD_CursorSet

		movf    VAR_AY_CHIP_REG9_CH_B_AMPLITUDE, W
	    call   	MIOS_LCD_PrintBCD2


	;; ---------------[CHECK: VELOCITY @ TONE B ON?  ]--------------------------
	;; BIT1 CLEAR? 
	btfsc VAR_VELOCITY_TO_ABC_NOISE_PERIOD_ON_OFF, BIT1_VELOCITY_ON_OFF_TONE_B
		;; NO - BIT1 = SET => VELOCITY TO VOLUME
		rgoto  MENU4_TONE_B_VELOCITY_IS_ON
		
		;; YES - BIT1 = CLEAR => VELOCITY IS *NOT* VOLUME
		;; GO ON CHECK ENV MODE TONE B
		rgoto  MENU4_CHK_ENV_MODE_TONE_B


MENU4_TONE_B_VELOCITY_IS_ON
		TABLE_ADDR TEXT_AY_MENU_AMPLITUDE_CH_B_VELOC
		call    MIOS_LCD_PrintString
		;; GO ON CHECK ENV MODE TONE B

MENU4_CHK_ENV_MODE_TONE_B
	;; IS ENVELOPE MODE (BIT4) ON OR OFF?
    btfsc VAR_AY_CHIP_REG9_CH_B_AMPLITUDE, BIT4_ENVELOPE_ON_OFF
		
		;; ENV MODE @ TONE B = ON
		rgoto MENU4_ENV_MODE_TONE_B_SET
		
		;; ENV MODE @ TONE B = OFF
		;; GO ON WITH TONE C
		rgoto MENU4_AMPLITUDE_TONE_C

;; ---------------------[AMPLITUDE TONE C]-------------------------------
MENU4_AMPLITUDE_TONE_C
        ;; AMPLITUDE CH C
        TABLE_ADDR TEXT_AY_MENU_AMPLITUDE_CH_C
        call    MIOS_LCD_PrintString

        movlw   LCD_ROW4 + 13
        call    MIOS_LCD_CursorSet

		movf    VAR_AY_CHIP_REG10_CH_C_AMPLITUDE, W
	    call    MIOS_LCD_PrintBCD2


	;; IS VELOCITY TONE C ON or OFF
	;; BIT2 CLEAR? 
	btfsc VAR_VELOCITY_TO_ABC_NOISE_PERIOD_ON_OFF, BIT2_VELOCITY_ON_OFF_TONE_C
		;; NO - BIT2 = SET => VELOCITY TO VOLUME
		rgoto  MENU4_AMPLITUDE_CH_C_VELOCITY_ON
		;; YES - BIT2 = CLEAR => VELOCITY IS *NOT* VOLUME
		rgoto  MENU4_AMPLITUDE_CHK_ENV_MODE_TONE_C

MENU4_AMPLITUDE_CH_C_VELOCITY_ON
		TABLE_ADDR TEXT_AY_MENU_AMPLITUDE_CH_C_VELOC
		call    MIOS_LCD_PrintString
		;; GO ON AND CHK ENV MODE TONE C

MENU4_AMPLITUDE_CHK_ENV_MODE_TONE_C
	;; IS ENVELOPE MODE @ TONE C (BIT4) ON OR OFF?
    btfsc VAR_AY_CHIP_REG10_CH_C_AMPLITUDE, BIT4_ENVELOPE_ON_OFF
       	;; ENVELOPE MODE ON
		rgoto MENU4_ENV_MODE_TONE_C_SET
			
		;; ENVELOPE MODE OFF
		;; GO ON WITH CSR/ITEM POS PROCESSING


;; ---------------------[CHECK MENU4 CSR POS                      ]------------------------
;; ----------------------------------------------------------------------------------------
;; MENU4: DO CHECK CSR/ITEM POS
;; ----------------------------------------------------------------------------------------
MENU4_FIND_CURRENT_CRS_POS
	;; CSR @ AMPLITUDE A?
	;; -------------[CHECK: CSR POS = 1 ?                   ]------------------------------
	;; -------------[POS = USER VOLUME @ TONE A             ]------------------------------
	movff BNKD_VAR_LCD_CURSOR_POS_MAIN_MENU_AMPLITUDE, VAR_TMP_RAM_BYTE_COPY_CLIPBOARD
	
	movlw 	CONST_MENU_ITEM_POS1
	cpfseq 	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD 
		;; NO,
		;; CSR <> ITEM POS 1
		rgoto MENU4_CHK_CRS_POS2
		
		;; YES
		;; CSR IS @ AMPLITUDE A
		;; WRITE ">" @ POS ITEM1
		;; CSR = ITEM POS 1
		movlw 	CSR_POS_MENU4_ITEM1
		call    MIOS_LCD_CursorSet
		movlw   '~'
		call    MIOS_LCD_PrintChar
		;; BLINKING CSR HANDLING
		movlw 	CSR_POS_MENU4_ITEM1
		movff	WREG, VAR_CURSOR_BLINKING_POS
		movlw   '~'
		movff	WREG, VAR_CURSOR_BLINKING_CSR_CHAR
			
MENU4_CHK_CRS_POS2
	;; -------------[CHECK: CSR POS = 2 ?                   ]------------------------------
	;; -------------[POS = USER VOLUME @ TONE B             ]------------------------------
	movff BNKD_VAR_LCD_CURSOR_POS_MAIN_MENU_AMPLITUDE, VAR_TMP_RAM_BYTE_COPY_CLIPBOARD
	
	movlw 	CONST_MENU_ITEM_POS2
	cpfseq 	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD 
			
		;; NO,
		;; CSR <> ITEM POS 2
		rgoto MENU4_CHK_CRS_POS3

		;; YES
		;; CSR POS = ITEM POS 2
		movlw 	CSR_POS_MENU4_ITEM2
		call    MIOS_LCD_CursorSet
		movlw   '~'
		call    MIOS_LCD_PrintChar
		;; BLINKING CSR HANDLING
		movlw 	CSR_POS_MENU4_ITEM2
		movff	WREG, VAR_CURSOR_BLINKING_POS
		movlw   '~'
		movff	WREG, VAR_CURSOR_BLINKING_CSR_CHAR
			
MENU4_CHK_CRS_POS3
	;; -------------[CHECK: CRS POS = 3 ?                   ]------------------------------
	;; -------------[POS = USER VOLUME @ TONE C             ]------------------------------
	movff BNKD_VAR_LCD_CURSOR_POS_MAIN_MENU_AMPLITUDE, VAR_TMP_RAM_BYTE_COPY_CLIPBOARD
	
	movlw 	CONST_MENU_ITEM_POS3
	cpfseq 	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD
		;; NO,
		;; CSR <> ITEM POS 3
		;; exit here
		return
		
		;; YES,
		;; CSR POS = ITEM POS 3
		movlw 	CSR_POS_MENU4_ITEM3
		call    MIOS_LCD_CursorSet
		movlw   '~'
		call    MIOS_LCD_PrintChar
		;; BLINKING CSR HANDLING
		movlw 	CSR_POS_MENU4_ITEM3
		movff	WREG, VAR_CURSOR_BLINKING_POS
		movlw   '~'
		movff	WREG, VAR_CURSOR_BLINKING_CSR_CHAR
		;; exit here
		return


;; ##################################################################################################
;; --------------------------------------------------------------------------------------------------
;; SUB ROUTINE:
;; --------------------------------------------------------------------------------------------------	
;; ----[IF ENV MODE IS SET (ENV = ON) SO WRITE ENV = ON INFO OVER FIXED AMPLITUE VALUE ON LCD]-------
;; --------------------------------------------------------------------------------------------------

MENU4_ENV_MODE_TONE_A_SET
	;; WRITE TO LCD "ENV IS SET" TONE A
	TABLE_ADDR TEXT_AY_MENU_AMPLITUDE_CH_A_ENV
    call    MIOS_LCD_PrintString
    rgoto 	MENU4_AMPLITUDE_TONE_B

MENU4_ENV_MODE_TONE_B_SET
	;; WRITE TO LCD "ENV IS SET" TONE B
	TABLE_ADDR TEXT_AY_MENU_AMPLITUDE_CH_B_ENV
    call    MIOS_LCD_PrintString
    rgoto 	MENU4_AMPLITUDE_TONE_C

MENU4_ENV_MODE_TONE_C_SET	
	;; WRITE TO LCD "ENV IS SET" TONE C
	TABLE_ADDR TEXT_AY_MENU_AMPLITUDE_CH_C_ENV
    call    MIOS_LCD_PrintString
    rgoto 	MENU4_FIND_CURRENT_CRS_POS 

;; --------[END SUB ROUTINE]-------------------------------------------------------------------------


	
