;; FUNCTION:
;; USER - VELOCITY HANDLING

MENU_07_VELOCITY
	;; CS F1-F8 BTN LED'S = OFF
	call	LED_F1_on
	call	LED_F2_on
	call	LED_F3_on
	call	LED_F4_off
	call	LED_F5_on
	call	LED_F6_on
	call	LED_F7_on
	call	LED_F8_on


	call    MIOS_LCD_Clear


MENU_07_VELOCITY_LCD_REFRESH_JUMP_IN_POINT
	;; WRITE LCD ROW1
	TABLE_ADDR TEXT_AY_VELOCITY_CONFIG_ROW1
	call    MIOS_LCD_PrintString

	;; SET CURSOR ROW1 VELOCITY TONE A
	movlw   LCD_ROW1 + 0x0e
	call    MIOS_LCD_CursorSet
	
	;; CHECK AY_VELOCITY_ON_OFF @TONE A
	btfss VAR_VELOCITY_TO_ABC_NOISE_PERIOD_ON_OFF, BIT0_VELOCITY_ON_OFF_TONE_A
		
		;; NO, BIT IS NOT SET
		;; NO VELOCITY TO VOLUME @ TONE A
		rgoto MENU_07_VELOCITY_OFF_TONE_A
	
		;; YES - BIT IS SET
		;; VELOCITY IS SET TO VOLUME @ TONE A
		rgoto MENU_07_VELOCITY_ON_TONE_A

MENU_07_VELOCITY_OFF_TONE_A
	movlw   '-'
	call    MIOS_LCD_PrintChar
	movlw   '-'
	call    MIOS_LCD_PrintChar
	rgoto MENU_07_VELOCITY_TONE_B


MENU_07_VELOCITY_ON_TONE_A
	movlw   'O'
	call    MIOS_LCD_PrintChar
	movlw   'N'
	call    MIOS_LCD_PrintChar
	rgoto MENU_07_VELOCITY_TONE_B
      
MENU_07_VELOCITY_TONE_B  
	;; PRINT - VELOCITY TO TONE B - LCD ROW2
	TABLE_ADDR TEXT_AY_VELOCITY_CONFIG_ROW2
	call    MIOS_LCD_PrintString

	;; SET CURSOR ROW2 VELOCITY TONE B
	movlw   LCD_ROW2 + 0x0e
	call    MIOS_LCD_CursorSet
	
	;; CHECK AY_VELOCITY_ON_OFF @TONE B
	btfss VAR_VELOCITY_TO_ABC_NOISE_PERIOD_ON_OFF, BIT1_VELOCITY_ON_OFF_TONE_B
		
		;; NO, BIT IS NOT SET
		;; NO VELOCITY TO VOLUME @ TONE B
		rgoto MENU_07_VELOCITY_OFF_TONE_B
	
		;; YES - BIT IS SET
		;; VELOCITY IS SET TO VOLUME @ TONE B
		rgoto MENU_07_VELOCITY_ON_TONE_B

MENU_07_VELOCITY_OFF_TONE_B
	movlw   '-'
	call    MIOS_LCD_PrintChar
	movlw   '-'
	call    MIOS_LCD_PrintChar
	rgoto MENU_07_VELOCITY_TONE_C


MENU_07_VELOCITY_ON_TONE_B
	movlw   'O'
	call    MIOS_LCD_PrintChar
	movlw   'N'
	call    MIOS_LCD_PrintChar
	rgoto MENU_07_VELOCITY_TONE_C

MENU_07_VELOCITY_TONE_C 
	;; PRINT - VELOCITY TO TONE C-- LCD ROW3
	TABLE_ADDR TEXT_AY_VELOCITY_CONFIG_ROW3
	call    MIOS_LCD_PrintString

	;; SET CURSOR ROW3 VELOCITY TONE C
	movlw   LCD_ROW3 + 0x0e
	call    MIOS_LCD_CursorSet
	
	;; CHECK AY_VELOCITY_ON_OFF @TONE C
	btfss VAR_VELOCITY_TO_ABC_NOISE_PERIOD_ON_OFF, BIT2_VELOCITY_ON_OFF_TONE_C
		
		;; NO, BIT IS NOT SET
		;; NO VELOCITY TO VOLUME @ TONE C
		rgoto MENU_07_VELOCITY_OFF_TONE_C
	
		;; YES - BIT IS SET
		;; VELOCITY IS SET TO VOLUME @ TONE C
		rgoto MENU_07_VELOCITY_ON_TONE_C

MENU_07_VELOCITY_OFF_TONE_C
	movlw   '-'
	call    MIOS_LCD_PrintChar
	movlw   '-'
	call    MIOS_LCD_PrintChar
	rgoto MENU_07_VELOCITY_NOISE_RATE


MENU_07_VELOCITY_ON_TONE_C
	movlw   'O'
	call    MIOS_LCD_PrintChar
	movlw   'N'
	call    MIOS_LCD_PrintChar
	;; go on with Noise Rate
	
MENU_07_VELOCITY_NOISE_RATE
	;; WRITE - VELOCITY TO NOISE RATE - ON LCD ROW4
	TABLE_ADDR TEXT_AY_VELOCITY_CONFIG_ROW4
	call    MIOS_LCD_PrintString

	
	
	;;---------------[CHECK AY_VELOCITY_ON_OFF @NOISE PERIOD]-----------------------------
	btfss VAR_VELOCITY_TO_ABC_NOISE_PERIOD_ON_OFF, BIT3_VELOCITY_TO_NOISE_PERIOD_ON_OFF
		
		;; NO, BIT IS NOT SET
		;; NO VELOCITY TO RATE @ NOISE
		rgoto MENU_07_VELOCITY_OFF_NOISE_RATE
	
		;; YES - BIT IS SET
		;; VELOCITY IS SET TO RATE @ NOISE
		rgoto MENU_07_VELOCITY_ON_NOISE_RATE

MENU_07_VELOCITY_OFF_NOISE_RATE
	;; SET CURSOR ROW4 VELOCITY TO NOISE RATE
	movlw   LCD_ROW4 + 0x0e
	call    MIOS_LCD_CursorSet
	movlw   '-'
	call    MIOS_LCD_PrintChar
	movlw   '-'
	call    MIOS_LCD_PrintChar
	rgoto 	MENU_07_VELOCITY_CHECK_EDITING_MODE_ITEM_1


MENU_07_VELOCITY_ON_NOISE_RATE

	;; CHECK VELOCITY NOISE RATE = TONE A
	btfss VAR_VELOCITY_TO_ABC_NOISE_PERIOD_ON_OFF, BIT5_VELOCITY_A_TO_NOISE_PERIOD_ON_OFF
		
		;; NO, BIT5 IS NOT SET
		;; CHECK TONE B
		rgoto MENU_07_VELOCITY_ON_NOISE_RATE_CHK_TONE_B
	
		;; YES - BIT5 IS SET
		;; VELOCITY IS @ TONE A
		rgoto MENU_07_VELOCITY_ON_NOISE_RATE_IS_TONE_A


MENU_07_VELOCITY_ON_NOISE_RATE_IS_TONE_A
	;; VELOCITY NOISE FREQ @ TONE A = ON 
	movlw   LCD_ROW4 + 0x0e
	call    MIOS_LCD_CursorSet
	movlw   '@'
	call    MIOS_LCD_PrintChar
	movlw   'A'
	call    MIOS_LCD_PrintChar
	rgoto 	MENU_07_VELOCITY_CHECK_EDITING_MODE_ITEM_1


MENU_07_VELOCITY_ON_NOISE_RATE_CHK_TONE_B
	;; CHECK VELOCITY NOISE RATE = TONE B
	btfss VAR_VELOCITY_TO_ABC_NOISE_PERIOD_ON_OFF, BIT6_VELOCITY_B_TO_NOISE_PERIOD_ON_OFF
		
		;; NO, BIT6 IS NOT SET
		;; CHECK TONE C
		rgoto MENU_07_VELOCITY_ON_NOISE_RATE_CHK_TONE_C
	
		;; YES - BIT6 IS SET
		;; VELOCITY IS @ TONE b
		rgoto MENU_07_VELOCITY_ON_NOISE_RATE_IS_TONE_B

MENU_07_VELOCITY_ON_NOISE_RATE_IS_TONE_B
	;; VELOCITY NOISE FREQ @ TONE B = ON 
	movlw   LCD_ROW4 + 0x0e
	call    MIOS_LCD_CursorSet
	movlw   '@'
	call    MIOS_LCD_PrintChar
	movlw   'B'
	call    MIOS_LCD_PrintChar
	rgoto 	MENU_07_VELOCITY_CHECK_EDITING_MODE_ITEM_1


MENU_07_VELOCITY_ON_NOISE_RATE_CHK_TONE_C
	;; CHECK VELOCITY NOISE RATE = TONE C
	btfss VAR_VELOCITY_TO_ABC_NOISE_PERIOD_ON_OFF, BIT7_VELOCITY_C_TO_NOISE_PERIOD_ON_OFF
		
		;; NO, BIT7 IS NOT SET
		;; ERROR
		rgoto MENU_07_VELOCITY_ON_NOISE_RATE_ERROR
	
		;; YES - BIT7 IS SET
		;; VELOCITY IS @ TONE C
		rgoto MENU_07_VELOCITY_ON_NOISE_RATE_IS_TONE_C

MENU_07_VELOCITY_ON_NOISE_RATE_ERROR
	;; ERROR - DONT WRITE TO LCD BUT GO ON
	rgoto MENU_07_VELOCITY_CHECK_EDITING_MODE_ITEM_1


MENU_07_VELOCITY_ON_NOISE_RATE_IS_TONE_C
	;; VELOCITY NOISE FREQ @ TONE C = ON 
	movlw   LCD_ROW4 + 0x0e
	call    MIOS_LCD_CursorSet
	movlw   '@'
	call    MIOS_LCD_PrintChar
	movlw   'C'
	call    MIOS_LCD_PrintChar
	
	
;; -------------[CHECK CSR POS                 ]---------------------------------------------
MENU_07_VELOCITY_CHECK_EDITING_MODE_ITEM_1
	;; CSR POS = 1?
	;; VELOCITY @ TONE A?
	movff BNKD_VAR_LCD_CURSOR_POS_MAIN_MENU_VELOCITY_CONFIG, VAR_TMP_RAM_BYTE_COPY_CLIPBOARD
	movlw CONST_MENU_ITEM_POS1					
	cpfseq VAR_TMP_RAM_BYTE_COPY_CLIPBOARD 		
			
		;; NO
		rgoto MENU_07_VELOCITY_CHECK_ITEM2

		;; YES
		;; CSR POS VELOCITY -> @ TONE A
		;; WRITE ">" ON CSR POS 1
		movlw 	CSR_POS_MENU7_ITEM1
		call    MIOS_LCD_CursorSet
		movlw   '~'
		call    MIOS_LCD_PrintChar
		;; BLINKING CSR HANDLING
		movlw 	CSR_POS_MENU7_ITEM1
		movff	WREG, VAR_CURSOR_BLINKING_POS
		movlw   '~'
		movff	WREG, VAR_CURSOR_BLINKING_CSR_CHAR


MENU_07_VELOCITY_CHECK_ITEM2
	;; CSR POS = 2?
	;; VELOCITY @ TONE B?
	movff BNKD_VAR_LCD_CURSOR_POS_MAIN_MENU_VELOCITY_CONFIG, VAR_TMP_RAM_BYTE_COPY_CLIPBOARD
	movlw CONST_MENU_ITEM_POS2	
	cpfseq VAR_TMP_RAM_BYTE_COPY_CLIPBOARD 
			
		;; NO
		rgoto MENU_07_VELOCITY_CHECK_ITEM3

		;; YES
		;; CSR POS VELOCITY -> @ TONE B
		;; WRITE ">" CSR ON CSR POS 2
		movlw 	CSR_POS_MENU7_ITEM2
		call    MIOS_LCD_CursorSet
		movlw   '~'
	    call    MIOS_LCD_PrintChar
		;; BLINKING CSR HANDLING
		movlw 	CSR_POS_MENU7_ITEM2
		movff	WREG, VAR_CURSOR_BLINKING_POS
		movlw   '~'
		movff	WREG, VAR_CURSOR_BLINKING_CSR_CHAR
		
MENU_07_VELOCITY_CHECK_ITEM3
 	;; CSR POS = 3?
	movff BNKD_VAR_LCD_CURSOR_POS_MAIN_MENU_VELOCITY_CONFIG, VAR_TMP_RAM_BYTE_COPY_CLIPBOARD
	movlw CONST_MENU_ITEM_POS3				
	cpfseq VAR_TMP_RAM_BYTE_COPY_CLIPBOARD 
			
		;; NO
		rgoto MENU_07_VELOCITY_CHK_ITEM4

		;; YES
		;; CSR POS VELOCITY -> TONE C
		;; WRITE ">" ON LCD ROW3
		movlw   CSR_POS_MENU7_ITEM3
		call    MIOS_LCD_CursorSet
		movlw   '~'
		call    MIOS_LCD_PrintChar
		;; BLINKING CSR HANDLING
		movlw 	CSR_POS_MENU7_ITEM3
		movff	WREG, VAR_CURSOR_BLINKING_POS
		movlw   '~'
		movff	WREG, VAR_CURSOR_BLINKING_CSR_CHAR
		

MENU_07_VELOCITY_CHK_ITEM4
 	;; CSR POS = 4?
	movff BNKD_VAR_LCD_CURSOR_POS_MAIN_MENU_VELOCITY_CONFIG, VAR_TMP_RAM_BYTE_COPY_CLIPBOARD
	movlw CONST_MENU_ITEM_POS4					
	cpfseq VAR_TMP_RAM_BYTE_COPY_CLIPBOARD 		
			
		;; NO
		return

		;; YES
		;; CSR POS VELOCITY -> NOISE RATE 
		;; WRITE ">" CSR ON LCD ROW4
		movlw   CSR_POS_MENU7_ITEM4
		call    MIOS_LCD_CursorSet
		movlw   '~'
		call    MIOS_LCD_PrintChar
		;; BLINKING CSR HANDLING
		movlw 	CSR_POS_MENU7_ITEM4
		movff	WREG, VAR_CURSOR_BLINKING_POS
		movlw   '~'
		movff	WREG, VAR_CURSOR_BLINKING_CSR_CHAR
		;; EXIT HERE
		return

