FORMAT_BANKSTICK_ROUTINE
	;; FUNCTION:
	;; DO FORMAT BANKSTICK
	;; --------------------------------------------------------------------------------
	;; USES:
	;; IN		-> BNKD_VAR_PATCH_STATE_FLAGS
	;; IN & OUT	-> BNKD_VAR_FORMAT_BANKSTICK_CYCLE_COUNTER
	;; IN & OUT	-> VAR_TMP_RAM_BYTE_COPY_CLIPBOARD (TMP)
	;; IN		-> CONST_MAIN_MENU_01 
	;; IN		-> CONST_MENU_ITEM_POS3
	;; IN		-> VAR_CURRENT_MAIN_MENU 
	;; IN		-> BNKD_VAR_LCD_CURSOR_POS_MAIN_MENU_PATCH_INFO
	;;  	OUT	-> VAR_TMP_RAM_BYTE_COPY_CLIPBOARD  (BIT3_FORMAT_BANKSTICK_MODE_ON)
	;; DO		-> call BLANK_PATCH_NAME
	
	
	;; CHECK:
	;; BANKSTICK AVAILABLE?
	;; -------------[STATE: SELECTED PATCH = BANKSTICK PATCH]------------------------
	;; -------------[CHECK: BANKSTICK AVAILABLE?]------------------------------------
	movff	BNKD_VAR_PATCH_STATE_FLAGS, VAR_TMP_RAM_BYTE_COPY_CLIPBOARD
	btfss	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, BIT0_BANKSTICK_FOUND
			;; ---[BANKSTICK NOT AVAILABLE]----------------
			;; BIT0 = CLR = NO BANKSTICK FOUND
			;; EXIT HERE
			goto MENUE_SWITCH_DO
			
			;; ---[BANKSTICK IS AVAILABLE]----------------
			;; BIT0 = 1 = BANKSTICK IS AVAILABLE
	
	;; CHECK: MENU = MAIN MENU 1
	movlw	CONST_MAIN_MENU_01
	cpfseq 	VAR_CURRENT_MAIN_MENU
		;; NO IT'S NOT MAIN MENU1
		;; Exit Here
		return
		
		;; YES, MENU1
		;; GO ON...

		;; SO DO FORMAT CURRENT BANKSTICK
		;; SET THE "DO FORMAT THE BANKSTICK BIT"
		movff 	BNKD_VAR_PATCH_STATE_FLAGS, VAR_TMP_RAM_BYTE_COPY_CLIPBOARD	
		bsf		VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, BIT3_FORMAT_BANKSTICK_MODE_ON
		movff 	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, BNKD_VAR_PATCH_STATE_FLAGS	
			
		;; RESET (CLEAR) PATCHNAME
		call FORMAT_BS_DEFAULT_NAME
		
		;; CLR ROW3 @ LCD (F1 F2 F8)
		TABLE_ADDR LCD_CLEAR_ROW3
		call MIOS_LCD_PrintString
		
		;; Overrite "->" POS @ LCD ROW1 + 2
		movlw   LCD_ROW1 + 5
        call    MIOS_LCD_CursorSet
		movlw   ' '
        call    MIOS_LCD_PrintChar
		movlw   LCD_ROW2 + 5
        call    MIOS_LCD_CursorSet
		movlw   'F'
        call    MIOS_LCD_PrintChar
		
		
		;; CS HANDLING
		call	LED_F1_off
		call	LED_F2_off
		call	LED_F8_off
						
		;; GO AND DO FORMAT BANKSTICK
		goto PATCH_WRITE_DO_FORMAT_BANKSTICK	
	


;; ---------------------------------------------------------------------------------------------------
;; ----------------[SUB ROUTINE: FORMAT BANKSTICK PATCHES PATCH BY PATCH]-----------------------------
;; ---------------------------------------------------------------------------------------------------
;; ---------------------------------------------------------------------------------------------------
;; ------------------------[FORMAT BANKSTICK JUMP IN POINT]-------------------------------------------
PATCH_WRITE_DO_FORMAT_BANKSTICK
	;; FORMAT BANKSTICK (STEP 1)
	;; SELECT (A NEW) PATCH NUMBER 
	;; -----------------------------------------------------------------------------------------------
	;; MEMO:
	;; INI VALUE BNKD_VAR_FORMAT_BANKSTICK_CYCLE_COUNTER	= 0
	;; DO INC BNKD_VAR_FORMAT_BANKSTICK_CYCLE_COUNTER		+ 1
	;; -> BNKD_VAR_FORMAT_BANKSTICK_CYCLE_COUNTER:          DO COUNT FROM 1 to 128
	;;
	;;    BNKD_VAR_FORMAT_BANKSTICK_CYCLE_COUNTER	 		= 128 ( = BANKSTICK_MAX_PATCH_NUMBER +1) 
	;;    WILL BE THE "EXIT THE FORMAT BANSTICK ROUTINE" TRIGGER VALUE
	;; -----------------------------------------------------------------------------------------------

	;; ---------------------[INC FORMATTING CYCLE COUNTER +1       ]----------------------------------
	;; INC BNKD_VAR_FORMAT_BANKSTICK_CYCLE_COUNTER           +1  
	movff	BNKD_VAR_FORMAT_BANKSTICK_CYCLE_COUNTER, VAR_TMP_RAM_BYTE_COPY_CLIPBOARD
	incf 	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, F
	movff	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, BNKD_VAR_FORMAT_BANKSTICK_CYCLE_COUNTER
	
	;; ---------------------[SET BNKD_VAR_BROWSE_PATCH_NR          ]---------------------------------
	;; ----------------------------------------------------------------------------------------------
	;; FORMAT BANKSTICK (STEP 1a)
	;; ----------------------------------------------------------------------------------------------
	;; WRITE BNKD_VAR_FORMAT_BANKSTICK_CYCLE_COUNTER TO BNKD_VAR_BROWSE_PATCH_NR
	movff BNKD_VAR_FORMAT_BANKSTICK_CYCLE_COUNTER, BNKD_VAR_BROWSE_PATCH_NR
	
	;; ---------------------[WRITE LCD ROW4                        ]---------------------------------
	;; ----------------------------------------------------------------------------------------------
	;; FORMAT BANKSTICK (STEP 2)
	;; ----------------------------------------------------------------------------------------------
	;; CLEAR LCD ROW4
	TABLE_ADDR LCD_CLEAR_ROW4
	call    MIOS_LCD_PrintString
	
	
	
	;; WRITE "FORMAT PATCH:" on LCD ROW4
	TABLE_ADDR TEXT_AY_MB_AY_PATCH_FORMATTING_BS
	call    MIOS_LCD_PrintString
	
	;; WE DO A FORMATTING PATCH BY PATCH ROUTINE 
	;; Write THE CURRENT PATCH NR on LCD
	movlw 	LCD_ROW2 + 9
	call    MIOS_LCD_CursorSet
	movff	BNKD_VAR_FORMAT_BANKSTICK_CYCLE_COUNTER, VAR_TMP_RAM_BYTE_COPY_CLIPBOARD2
	decf	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD2, F	;; (PATCH NUMBER OFFSET -1)
	movf	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD2, W
	call 	MIOS_LCD_PrintBCD3
	
	;;--[WRITE PROGRESS BAR ON LCD @ ROW3]---------------------------------------------------------
	;; FORMAT progress bar @ LCD ROW3 
	;; BNKD_VAR_FORMAT_BANKSTICK_CYCLE_COUNTER /8
	rrncf	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD2, F
	bcf		VAR_TMP_RAM_BYTE_COPY_CLIPBOARD2, 7
	rrncf	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD2, F
	bcf		VAR_TMP_RAM_BYTE_COPY_CLIPBOARD2, 7
	rrncf	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD2, F
	bcf		VAR_TMP_RAM_BYTE_COPY_CLIPBOARD2, 7
	;; SET CURSOR
	movlw	LCD_ROW3
	addwf   VAR_TMP_RAM_BYTE_COPY_CLIPBOARD2, W
    call    MIOS_LCD_CursorSet
	;; DO WRITE ">>>>>>..."	ON LCD
	movlw   '~'
    call    MIOS_LCD_PrintChar
	;;; --------------------------------------------------------------------------------------------
	
	;; ---------------------[CHECK: IF FORMATTING IS FINISHED      ]-------------------------------- 
	;; ---------------------------------------------------------------------------------------------
	;; FORMAT BANKSTICK (STEP 3)
	;; ---------------------------------------------------------------------------------------------
	;; CHECK: BNKD_VAR_FORMAT_BANKSTICK_CYCLE_COUNTER	 > BANKSTICK_MAX_PATCH_NUMBER ?
	;; IF NOT: DO ANOTHER BANKSTICK PATCH WRITE
	movff	BNKD_VAR_FORMAT_BANKSTICK_CYCLE_COUNTER, VAR_TMP_RAM_BYTE_COPY_CLIPBOARD
	movlw	CONST_BANKSTICK_MAX_PATCH_NUMBER
	cpfsgt 	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD	
			;; ------------[STATE: CYCLE COUNTER < or = BS PATCH NUMBER MAX VALUE]------------------
			;; ------------[STATE: GO ON FORMAT THE BANKSTICK                    ]------------------
			;; ------------[DO:    FORMAT/WRITE ANOTHER BS PATCH                 ]------------------
			;; SEE @ patch_write.inc
			goto DO_STORE_PATCH_ON_PIC_EEPROM_OR_BANKSTICK
		
	;; ----------[STATE: CYCLE COUNTER > BS PATCH NUMBER MAX VALUE     ]----------------------------
	;; ----------[STATE: ALL BS PATCHES ARE FORMATTED (WRITTEN)        ]----------------------------
	;; ----------[STATE: NOW FINALIZE THE BANKSTICK FORMATTING PROCESS ]----------------------------
	;; ----------[DO: SET BNKD_VAR_FORMAT_BANKSTICK_CYCLE_COUNTER to 0 ]----------------------------
	clrf	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD
	movff 	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, BNKD_VAR_FORMAT_BANKSTICK_CYCLE_COUNTER	
		
	;; ---------------------------------------------------------------------------------------------
	;; ----------[DO: SET BNKD_VAR_CURRENT_PATCH_NR = 1                ]----------------------------
	;; ----------[DO: SET BNKD_VAR_BROWSE_PATCH_NR  = 1                ]----------------------------
	movlw CONST_DEFAULT_PATCH_NUMBER_AFTER_BS_FORMATTING
	movwf VAR_TMP_RAM_BYTE_COPY_CLIPBOARD
	movff VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, BNKD_VAR_CURRENT_PATCH_NR
	movff BNKD_VAR_CURRENT_PATCH_NR, BNKD_VAR_BROWSE_PATCH_NR
	
	;; ---------------------------------------------------------------------------------------------
	;; ----------[DO: SWITCH OFF THE "DO FORMAT BANKSTICK" MODE       ]-----------------------------
	;; ----------[DO CLR BIT3 @ BNKD_VAR_PATCH_STATE_FLAGS       ]-----------------------------
	movff 	BNKD_VAR_PATCH_STATE_FLAGS, VAR_TMP_RAM_BYTE_COPY_CLIPBOARD
	bcf		VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, BIT3_FORMAT_BANKSTICK_MODE_ON
	movff 	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, BNKD_VAR_PATCH_STATE_FLAGS
	;; ---------------------------------------------------------------------------------------------
	
	;; DO A LITTLE DELAY FOR SHOWING THAT ALL 127 PATCHES ARE FORMATTED ON LCD
	clrf	VAR_TMP_PATCH_DATA_CLIPBOARD
PATCH_WRITE_DO_FORMAT_BANKSTICK_DELAY_FOR_LCD
	movlw   255
    call	MIOS_Delay
    incf	VAR_TMP_PATCH_DATA_CLIPBOARD, F
    movlw	0x05	;; DO THE "HOW LONG" TIME JUSTAGE HERE 
    cpfsgt	VAR_TMP_PATCH_DATA_CLIPBOARD
		;; DO DELAY CYCLE
		goto	PATCH_WRITE_DO_FORMAT_BANKSTICK_DELAY_FOR_LCD
		
		;; EXIT DELAY CYCLE &
		;; GO ON
	
	;; EXIT THE BANKSTICK FORMATTING CYCLE HERE
	;; AND WRITE MAIN MENU1 on LCD
	goto MENU_01_PATCH
			

;; -------------------------[END: FORMATTING BANKSTICK SUB ROUTINE]---------------------------------
;; -------------------------------------------------------------------------------------------------


;; -------------------------------------------------------------------------------------------------
;; -------------------------------------------------------------------------------------------------
;; ----------------[SUBROUTINE: Format BS NAME ]----------------------------------------------------
;; -------------------------------------------------------------------------------------------------
FORMAT_BS_DEFAULT_NAME
	;; Default BS PATCH NAME
	;; WRITE "NewPatch"
	;; FOR INITIAL "NO PATCH LOADED AND
	;; FOR NEW FORMATTED BANKSTICK PATCH NAME
	;; 8x PATCH KEY ASC
	movlw 	"B"
	movwf 	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD
	movff 	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, BNKD_VAR_PATCH_NAME_ASC_0
	movlw 	"k"
	movwf 	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD
	movff 	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, BNKD_VAR_PATCH_NAME_ASC_1
	movlw 	"S"
	movwf 	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD
	movff 	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, BNKD_VAR_PATCH_NAME_ASC_2
	movlw 	"t"
	movwf 	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD
	movff 	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, BNKD_VAR_PATCH_NAME_ASC_3
	movlw 	"P"
	movwf 	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD
	movff 	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, BNKD_VAR_PATCH_NAME_ASC_4
	movlw 	"t"
	movwf 	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD
	movff 	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, BNKD_VAR_PATCH_NAME_ASC_5
	movlw 	"c"
	movwf 	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD
	movff 	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, BNKD_VAR_PATCH_NAME_ASC_6
	movlw 	"h"
	movwf 	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD
	movff 	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, BNKD_VAR_PATCH_NAME_ASC_7
		
	;; exit here
	return