;; ############################################################
;; #                                                          #
;; #  FUNCTION: WRITE FLAG VAR                                #
;; #  IN => BNKD_VAR_PATCH_STATE_FLAGS                        #
;; #  														  #
;; #  FLAG DETAILS 					 						  #
;; #  BNKD_VAR_PATCH_STATE_FLAGS @ app_defines.h  		  #
;; #  SEE BNKD_VAR_PATCH_STATE_FLAGS -> BIT0-7			  #
;; ############################################################



;; =======================================================================================
;; ---------------------------------------------------------------------------------------
;; ---------------------[ SUB ROUTINE: CHECK BS AVAILABLE?]-------------------------------
;; ---------------------------------------------------------------------------------------
WRITE_FLAG_BANKSTICK_AVAILABLE
	;; CHECK IF BS IS AVAILABLE
	;; RESET ADRESS LOW-BYTE
	clrf 	MIOS_PARAMETER1
	;; RESET ADRESS HIGH-BYTE
	clrf 	MIOS_PARAMETER2
	;; CHECK IF BS IS AVAILABLE
	;; TRY TO READ A BYTE @ BS ADR 0
	call 	MIOS_BANKSTICK_Read
			
		;; NOW CHECK BS STATE
		;; ------------------------------------------------------------------------------------------------
		;; BRANCH TO PATCH_STATE_BANKSTICK_NOT_AVAILABLE IF BS IS *NOT* AVAILABLE
		BRA_IFCLR MIOS_BOX_STAT, MIOS_BOX_STAT_BS_AVAILABLE, ACCESS, PATCH_STATE_BANKSTICK_NOT_AVAILABLE	
		;; ------------------------------------------------------------------------------------------------
		;; BANKSTICK FOUND, OK
		goto PATCH_STATE_BANKSTICK_IS_AVAILABLE
		;; ------------------------------------------------------------------------------------------------

PATCH_STATE_BANKSTICK_NOT_AVAILABLE
			;; WRITE BNKD_VAR_PATCH_STATE_FLAGS			
			;; NO BANKSTICK FOUND
			;; CLEAR BIT0
			movff	BNKD_VAR_PATCH_STATE_FLAGS, VAR_TMP_RAM_BYTE_COPY_CLIPBOARD
			bcf		VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, BIT0_BANKSTICK_FOUND
			;; IF THERE IS NO BANKSTICK, THERE CAN NOT BE A BANKSTICK PATCH FINGERPRINT
			;; SO CLR ALSO BIT1 @ BNKD_VAR_PATCH_STATE_FLAGS
			bcf 	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, BIT1_FINGERPRINT_FOUND
			movff	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, BNKD_VAR_PATCH_STATE_FLAGS
			
			;; exit here 
			return

PATCH_STATE_BANKSTICK_IS_AVAILABLE
			;; DO WRITE PATCH_MENU_STATE_FLAG	
			;; BANKSTICK FOUND
			;; SET BIT0
			movff	BNKD_VAR_PATCH_STATE_FLAGS, VAR_TMP_RAM_BYTE_COPY_CLIPBOARD
			bsf		VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, BIT0_BANKSTICK_FOUND
			movff	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, BNKD_VAR_PATCH_STATE_FLAGS

			;; exit here
			return
;; ----------------------------------------------------------------------------------------------
;; ------------------[END SUB ROUTINE: CHECK BS AVAILABLE?]--------------------------------------
;; ----------------------------------------------------------------------------------------------
;; ==============================================================================================

;; ----------------------------------------------------------------------------------------------
;; ----------------[SUB ROUTINE: WRITE PIC EEPROM or BS PATCH FLAG]------------------------------
;; ------[CHECK: PATCH = INTERNAL PIC EEPROM PATCH 0 or BANKSTICK PATCH 1-128]-------------------
;; ----------------------------------------------------------------------------------------------
WRITE_FLAG_SELECTED_PATCH_IS_EEPROM_OR_BANKSTICK

	;; MEMO: 
	;; INITIAL VALUE BIT2 @ BNKD_VAR_PATCH_STATE_FLAGS = 0 = CLEAR = EEPROM PATCH 0
	;; ------------------------------------------------------------------------------------------
	
	;; CHECK:
	;; BNKD_VAR_BROWSE_PATCH_NR = 0 ?
	movff	BNKD_VAR_BROWSE_PATCH_NR, VAR_TMP_RAM_BYTE_COPY_CLIPBOARD
	clrw 
	cpfseq 	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD
		;; BNKD_VAR_BROWSE_PATCH_NR < > 0
		;; SO BNKD_VAR_BROWSE_PATCH_NR = BANSTICK PATCH
		goto  PATCH_STATE_BANKSTICK_PATCH_TRUE
	
		
		;;  BNKD_VAR_BROWSE_PATCH_NR = 0 
		;;  STATE BS PATCH 			 = FALSE
		;;  STATE PIC EEPROM PATCH 0 = TRUE
		;;  CLR BIT2
		;;  BIT2 = 0 = BNKD_VAR_BROWSE_PATCH_NR = INTERNAL (PIC EEPROM)
		movff	BNKD_VAR_PATCH_STATE_FLAGS, VAR_TMP_RAM_BYTE_COPY_CLIPBOARD
		bcf 	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, BIT2_IF_CLR_PIC_EEPROM_PATCH_IS_SELECTED
		movff	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, BNKD_VAR_PATCH_STATE_FLAGS
		
		;; exit here
		return


PATCH_STATE_BANKSTICK_PATCH_TRUE
		;; BNKD_VAR_CURRENT_PATCH_NR > 0
		;; BIT2 = 1 = CURRENT PATCH = BANKSTICK (1-128)
		movff	BNKD_VAR_PATCH_STATE_FLAGS, VAR_TMP_RAM_BYTE_COPY_CLIPBOARD
		bsf 	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, BIT2_IF_SET_BS_PATCH_IS_SELECTED
		movff	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, BNKD_VAR_PATCH_STATE_FLAGS
		
		;; exit here
		return

;; -------------[END: SUB ROUTINE - WRITE PIC EEPROM or BS PATCH FLAG]----------------------------
;; -----------------------------------------------------------------------------------------------



;; -----------------------------------------------------------------------------------------------
;; ------------------------------------[SUB ROUTINE: CHECK FINGERPRINT ]--------------------------
WRITE_FLAG_CURRENT_PATCH_FINGERPRINT
    ;; --------------------------------[WRITE FINGERPRINT FLAG         ]--------------------------
	;; FUNCTION:
	;; READ THE *Fingerprint* BYTE 
	;; DO LOAD FINGERPRINT BYTE FROM EEPROM or BANKSTICK
	;; CHECK:
	;; FINGERPRINT OKAY?
	;;	* YES: SET BIT 1 OF BNKD_VAR_PATCH_STATE_FLAGS
	;;	* NO : CLR BIT 1 OF BNKD_VAR_PATCH_STATE_FLAGS
	;;
	;; USES:
	;; IN & OUT	-> BNKD_VAR_PATCH_STATE_FLAGS
	;; IN & OUT	-> EEADRH, EEADR (PIC PATCH 0)
	;; call     -> MIOS_EEPROM_Read 
	;; ------------------------------------------
	;; CHECK:
	;; BNKD_VAR_PATCH_STATE_FLAGS
	;; BIT2 = 0 = PATCH = EEPROM PATCH (0 = PIC INTERNAL PATCH)
	;; BIT2 = 1 = PATCH = BANKSTICK PATCH (1-128)
	movff	BNKD_VAR_PATCH_STATE_FLAGS, VAR_TMP_RAM_BYTE_COPY_CLIPBOARD
	btfsc	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, BIT2_CHK_IF_PIC_EEPROM_PATCH_OR_BS_PATCH
			;; ---[STATE: BIT2 @ BNKD_VAR_PATCH_STATE_FLAGS = SET ]----------
			;; ---[STATE: CURRENT PATCH = BANKSTICK PATCH              ]----------
			;; ---[DO: GO AND CHECK BANKSTICK PATCH FINGERPRINT        ]----------
			goto WRITE_CURRET_PATCH_FINGERPRINT_FLAG_BS
		
		;; ---[STATE: BIT2 @ BNKD_VAR_PATCH_STATE_FLAGS = CLR     ]----------
		;; ---[STATE: CURRENT PATCH = INT PIC PATCH                    ]----------
		;; ---[DO: CHECK THE FINGERPRINT @ PIC EEPROM                  ]---------- 
		;; MEMO:
		;; INT PATCH FINGERPRINT BYTE VALUE = PIC_INT_EEPROM_FINGERPRINT (0x12)
		;; ELSE THE INT PATCH DATA IS NOT VALID
		clrw
		movwf	EEADRH									;; CLR PIC EEPROM ADR HIGH BYTE
		movlw   CONST_ADR_PIC_EEPROM_PATCH_FINGERPRINT	;; SET PIC EEPROM ADR LOW BYTE TO FINGERPRINT ADR 
       	movwf   EEADR									;; MOVE PIC EEPROM FINGERPRINT ADR TO PIC EEPROM ADR LOW BYTE 
        call    MIOS_EEPROM_Read   						;; Read Byte from EEPROM and INC EEADR +1 (AUTO INC ADR)

		;; STORE FINGERPRINT BYTE from PIC EEPROM IN VAR_TMP_RAM_BYTE_COPY_CLIPBOARD2
        movwf	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD2	

		;; RESET FINGERPRINT BIT to 1 (*)
		movff	BNKD_VAR_PATCH_STATE_FLAGS, VAR_TMP_RAM_BYTE_COPY_CLIPBOARD
		bsf		VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, BIT1_FINGERPRINT_FOUND
		movff	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, BNKD_VAR_PATCH_STATE_FLAGS

		;; CHECK PIC EEPROM FINGERPRINT 
		;; FINGERPRINT = CONST_PIC_INT_EEPROM_FINGERPRINT (MIOS_PARAMETER1) ?
		movlw 	CONST_PIC_INT_EEPROM_FINGERPRINT_VALUE
        cpfseq	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD2				
        	;; NO,
        	;; Fingerprint < > CONST_PIC_INT_EEPROM_FINGERPRINT
		  	;; THERE IS NO VALID FINGERPRINT 
        	;; PIC EEPROM PATCH FINGERPRINT NOT FOUND
        	;; CLEAR FINGERPRINT BIT
        	goto	CLR_FLAG_CURRENT_PATCH_FINGERPRINT
		
        	;; YES, FINGERBRINT BYTE IS OKAY
			;; PIC EEPROM FINGERPRINT FOUND
			;; "FINGERPRINT OK BIT" ALLREADY HAD BEEN SET - SEE (*)
			;; --------------------------------------------------------------------------------
				
			;; SO EXIT HERE
			return

CLR_FLAG_CURRENT_PATCH_FINGERPRINT
			;; FINGERPRINT IS NOT OKAY
			;; CLR FINGERPRINT FLAG
			movff	BNKD_VAR_PATCH_STATE_FLAGS, VAR_TMP_RAM_BYTE_COPY_CLIPBOARD
		    bcf		VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, BIT1_FINGERPRINT_FOUND
			movff	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, BNKD_VAR_PATCH_STATE_FLAGS
			;; --------------------------------------------------------------------------------	
			;; EXIT HERE
			return

;; =========================[END: CHECK INTERNAL (PIC EEPROM) PATCH FINGERPRINT]===================


;; =========================[CHECK BS PATCH FINGERPRINT                        ]===================
WRITE_CURRET_PATCH_FINGERPRINT_FLAG_BS
		;; =======================[LOAD BANKSTICK PATCH FINGERPRINT]===============================
		;; MEMO: BANKSTICK DATA STRUCTURE
		;; BANKSTICK ADRESS GOT A HIGH and a LOW BYTE [16 BIT ADRESS]
		;; [HIGH BYTE ADR] [LOW BYTE ADR]
		;; [  0000 0000      0000 0000  ] 16 BIT BANKSTICK ADR
		;; THE [HIGH BYTE ADR] = [PATCH NUMBER (-1)] | RANGE: 0 to 127 | = PATCH NUMBER POINTER
		;; THE [LOW  BYTE ADR] = PATCH DATA AREA     | RANGE: 0 to 255 | = PATCH DATA POINTER
		;; EVERY SINGLE BANKSTICK PATCH GOT A OWN 255 BYTES DATA AREA. THE [LOW BYTE ADR] IS THE POINTER
		;; TO EVERY SINGLE DATA BYTE OF A SINGLE PATCH. IN OTHER WORDS THE [LOW BYTE] IS THE PATCH
		;; DATA POINTER. THE [HIGH BYTE ADR] DO DEFINE THE PATCH NUMBER (0 to 127). IN OTHER WORDS
		;; THE [HIGH BYTE ADR] IS THE POINTER THE BANKSTICK PATCH NUMBER.
		
		;; -----------[SET BS FINGERPRINT ADR   ]--------------------------------------------------
		;; ----------------------------------------------------------------------------------------
		;; -----------[SET BANKSTICK LOWBYTE ADR]--------------------------------------------------
		;; DO Store *LOW-BYTE* BS ADRESS in MIOS_PARAMETER1 
		;; DO SET LOW BYTE BANKSTICK ADRRESS to 0 = BS FINGERPRINT ADR
		clrf        MIOS_PARAMETER1
       	;; -----------[SET BANKSTICK ADR HIGHBYTE]-------------------------------------------------
       	;; Store HIGH-byte BANKSTICK ADRESS in MIOS_PARAMETER2
       	;; FINGERPRINT (HIGH BYTE) = PATCH NR = [1 to 127]
       	movff       BNKD_VAR_BROWSE_PATCH_NR, MIOS_PARAMETER2
       		;; -1 OFFSET
       		;; ------------------------------------------------------------------------------------
       		;; MEMO - HIGH BYTE ADR OFFSET:
       		;; EVERY BANKSTICK PATCH NEED A HIGH BYTE OFFSET of -1
       		;; SO THAT PATCH Nr 1   => HIGH BYTE = 0
       		;; SO THAT PATCH Nr 2   => HIGH BYTE = 1
       		;; SO THAT PATCH Nr 3   => HIGH BYTE = 2
       		;; ...
       		;; SO THAT PATCH Nr 127 => HIGH BYTE = 126
       		;; THE HIGHEST BANKSTICK ADR = 7FFF 
       		;; => [7F(ADR.HIGH_BYTE)FF(ADR.LOW_BYTE)]
       		;; THERE WOULD BE NO ADR SPACE for A PATCH
       		;; STARTING WITH A HIGH BYTE ADR @ 127 (!)
       		;; SO THE LAST VALID HIGH BYTE ADR = 126 
       		;; ------------------------------------------------------------------------------------
        	decf        MIOS_PARAMETER2, F
        	;; ------------------------------------------------------------------------------------
        	;; LOAD BANKSTICK FINGERPRINT  
        	;; @ CURRENT PATCH FINGERPRINT ADR 
        	call    MIOS_BANKSTICK_Read        ; load FINGERPRINT-BYTE from BankStick
        	movwf	VAR_TMP_PATCH_DATA_CLIPBOARD
            ;; branch to error exception
            ;; routine if neccesary
        	; BRA_IFCLR MIOS_BOX_STAT, MIOS_BOX_STAT_BS_AVAILABLE, ACCESS, PATCH_DATA_LOADING_Failed
			
			;; CHECK FINGERPRINT OK ?
        	;; MUST BE CONST BANKSTICK_PATCH_FINGERPRINT
        	;; RESET BS PATCH FINGERPRINT STATE = OK (*)
        	movff	BNKD_VAR_PATCH_STATE_FLAGS, VAR_TMP_RAM_BYTE_COPY_CLIPBOARD
			bsf		VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, BIT1_FINGERPRINT_FOUND
			movff	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, BNKD_VAR_PATCH_STATE_FLAGS
			
			;; NOW CHECK IF FINGERPRINT IS REALLY OK
			movlw 	CONST_BANKSTICK_PATCH_FINGERPRINT_VALUE
        	cpfseq	VAR_TMP_PATCH_DATA_CLIPBOARD
       			;; NO,
			    ;; THERE IS NO VALID FINGERPRINT @ BS 
			    ;; Fingerprint < > CONST_BANKSTICK_PATCH_FINGERPRINT
        		;; CLR BIT6 = BS PATCH FINGERPRINT NOT FOUND
        		goto CLR_FLAG_CURRET_BS_PATCH_FINGERPRINT

        		;; YES,
				;; Fingerprint @ BS = OK
				;; "FINGERPRINT OK BIT" ALLREADY HAD BEEN SET (*)
				;; ----------------------------------------------------------------------
				;; ---------[STATE: BANKSTICK FINGERPRINT  = OK]-------------------------
				;; ----------------------------------------------------------------------
				return

CLR_FLAG_CURRET_BS_PATCH_FINGERPRINT
						movff	BNKD_VAR_PATCH_STATE_FLAGS, VAR_TMP_RAM_BYTE_COPY_CLIPBOARD	
						bcf		VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, BIT1_FINGERPRINT_FOUND
						movff	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, BNKD_VAR_PATCH_STATE_FLAGS
						;; EXIT HERE
						return
						
;; -----------------[END: CHECK FINGERPRINT SUB ROUTONE                     ]---------------
;; -----------------------------------------------------------------------------------------



;; -----------------------------------------------------------------------------------------
;; -----------------[SUB ROUTONE: SET PATCH HAD BEEN WRITTEN OR LOADED FLAG ]---------------
SET_FLAG_PATCH_HAS_BEEN_WRITTEN_OR_LOADED
		;; MEMO:
		;; BIT4 = 1 = SET = 1) CURRENT PATCH NR =  BROWSE PATCH NR
		;; BIT4 = 1 = SET = 2) A PATCH HAD BEEN WRITTEN
		;; BIT4 = 1 = SET = 3) A PATCH HAD BEEN LOADED

		;; BIT4 = 0 = CURRENT PATCH NR < > BROWSE PATCH NR
		
		;; SET BIT 4
		movff	BNKD_VAR_PATCH_STATE_FLAGS, VAR_TMP_RAM_BYTE_COPY_CLIPBOARD
		bsf		VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, BIT4_PATCH_HAS_BEEN_LOADED_OR_WRITTEN
		movff	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, BNKD_VAR_PATCH_STATE_FLAGS
			;; exit here
			return

;; -----------------------------------------------------------------------------------------



SET_FLAG_PATCH_NAME_EDITING_MODE_ON
	;; TO DO
	;; BNKD_VAR_PATCH_STATE_FLAGS
	;; BIT5 = 1 = PATCH NAME HAS BEEN EDITED BY USER
	;; BIT5 = 0 = PATCH NAME HAS NOT BEEN EDITED BY USER
	;; SET BIT 5
	movff	BNKD_VAR_PATCH_STATE_FLAGS, VAR_TMP_RAM_BYTE_COPY_CLIPBOARD
	bsf		VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, BIT5_PATCH_NAME_WAS_EDITED_BY_USER
	movff	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, BNKD_VAR_PATCH_STATE_FLAGS
	return

	
	
SET_FLAG_PATCH_NAME_EDITING_MODE_OFF
	;; TO DO
	;; BNKD_VAR_PATCH_STATE_FLAGS
	;; BIT5 = 1 = PATCH NAME HAS BEEN EDITED BY USER
	;; BIT5 = 0 = PATCH NAME HAS NOT BEEN EDITED BY USER
	movff	BNKD_VAR_PATCH_STATE_FLAGS, VAR_TMP_RAM_BYTE_COPY_CLIPBOARD
	bcf		VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, BIT5_PATCH_NAME_WAS_EDITED_BY_USER
	movff	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, BNKD_VAR_PATCH_STATE_FLAGS
	return
	
	
	
	
	
	
	
