;; #########################################################################################
;; -----------------------------------------------------------------------------------------
;; -------------------------------[:: SUBROUTINES ::]---------------------------------------
;; -----------------------------------------------------------------------------------------
;; #########################################################################################

;; ----------------------------------------------------------------------------------------
;; ----------------------------[SUB ROUTINE: Write PATCH Fingerprint]----------------------
;; ----------------------------------------------------------------------------------------
SUB_ROUTINE_DO_WRITE_PATCH_FINGERPRINT
	;; FUNCTION:
	;; DO WRITE THE FINGERPRINT BYTE TO PIC EEPROM PATCH
	;;     IF PIC EEPROM PATCH IS SELECTED SET EEADR = 0x01
	;;
	;; OR WRITE THE FINGERPRINT BYTE TO BS PATCH
	;;    IF BS PATCH IS SELECTED DO ALSO WRITE THE PATCH NUMBER TO BS PATCH
	;;    SET BNKD_VAR_BANKSTICK_LOW_BYTE_ADR_COUNTER = 0x02
	;;
	;; PIC EEPROM USES
	;; IN 		-> BNKD_VAR_PATCH_STATE_FLAGS
	;; IN 		-> CONST_PIC_INT_EEPROM_FINGERPRINT
	;;    	OUT	-> EEADRH (WILL BE SET TO 0x00)
	;; 		OUT	-> EEADR  (WILL BE SET TO 0x01)
	;;
	;; BANKSTICK USES
	;; IN 		-> BNKD_VAR_PATCH_STATE_FLAGS
	;; IN		-> BNKD_VAR_BROWSE_PATCH_NR	(PATCH NUMBER VALUE & HIGH BYTE BS ADR -1)
	;; IN		-> CONST_BANKSTICK_PATCH_FINGERPRINT
	;; 		OUT	-> MIOS_PARAMETER1 			(LOW  BYTE BS ADR -> call MIOS_BANKSTICK_Write)
	;; 		OUT	-> MIOS_PARAMETER2 			(HIGH BYTE BS ADR -> call MIOS_BANKSTICK_Write)
	;;		OUT	-> BNKD_VAR_BANKSTICK_LOW_BYTE_ADR_COUNTER (SET TO 0x02)
	
	;; --------------------------------------------------------------------------------
	
	;; WRITE FINGERPRINT to EEPROM or BANKSTICK?
	;; --------------------------------------------------------------------------------
	;; CHECK:
	;; VIA BNKD_VAR_PATCH_STATE_FLAGS
	;; BIT2 = 0 = WRITE EEPROM PATCH (PIC INTERNAL PATCH)
	;; BIT2 = 1 = WRITE BANKSTICK PATCH
	movff	BNKD_VAR_PATCH_STATE_FLAGS, VAR_TMP_RAM_BYTE_COPY_CLIPBOARD
	btfsc	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, BIT2_CHK_IF_PIC_EEPROM_PATCH_OR_BS_PATCH
			;; =====[WRITE FINGERPRINT TO BS PATCH ]============
			;; BANKSTICK PATCH IS SELECTED (BIT2 = SET)
			;; GO AND WRITE FINGERPRINT TO BS PATCH 
			goto WRITE_PATCH_FINGERPRINT_BANKSTICK
			;; =================================================
				
		;; =========[WRITE INTERNAL EEPROM PATCH FINGERPRINT]===
		;; BNKD_VAR_PATCH_STATE_FLAGS BIT2 = CLEAR
		;; PATCH = INTERNAL (PIC EEPROM)
		;; INITIALIZE EEPROM ADRESS and WRITE FINGERPRINT
		;; -----------------------------------------------------
		;; SET EEPROM ADR HIGH BYTE
		clrf        EEADRH
		;; SET EEPROM ADR LOW BYTE
		movlw       CONST_ADR_PIC_EEPROM_PATCH_FINGERPRINT
		movwf       EEADR
		;; STORE FINGERPRINT DATA BYTE in WREG
		movlw       CONST_PIC_INT_EEPROM_FINGERPRINT_VALUE
		;; WRITE FINGERPRINT TO EEPROM 
		call        MIOS_EEPROM_Write
		;; EEADR will be incremented TO 0x01
		;; ----------[END: WRITING FINGERPRINT TO EEPROM]--------
		;; Exit SUB ROUTINE
		return
		;; ======================================================


WRITE_PATCH_FINGERPRINT_BANKSTICK
		;; ==================[WRITE BANKSTICK PATCH FINGERPRINT]===========================
		;; --------------------------------------------------------------------------------
		;; 1) INITIALIZE BANKSTICK ADRESS 
		;; 2) WRITE FINGERPRINT TO BANKSTICK PATCH [1-127] 									@ CURRENT PATCH ADR0
		;; 3) WRITE BNKD_VAR_BROWSE_PATCH_NR TO BANKSTICK PATCH NUMBER [VALUE 1-127]		@ CURRENT PATCH ADR1
		;; 4) SET BNKD_VAR_BANKSTICK_LOW_BYTE_ADR_COUNTER to 2 (NOW CURRENT PATCH ADR = 2 	@ CURRENT PATCH)
		;; --------------------------------------------------------------------------------
		;; ------------------[SET BANKSTICK ADR LOWBYTE]-----------------------------------
		;; Store LOW-byte (FINGERPRINT) BANKSTICK ADRESS in MIOS_PARAMETER1
		;; (LOW BYTE) = PATCH [1-128] BANSKSTICK ADRESS0 [+ HIGHBYTE OFFSET] 
		;; SET LOW BYTE BANKSTICK ADRRESS to 0
		clrf        MIOS_PARAMETER1
       	;; -----------[SET BANKSTICK ADR HIGHBYTE]-------------------------------------
       	;; Store HIGH-BYTE BANKSTICK ADRESS in MIOS_PARAMETER2
       	;; HIGH BYTE = BNKD_VAR_BROWSE_PATCH_NR = [1 to 128]
       	movff       BNKD_VAR_BROWSE_PATCH_NR, MIOS_PARAMETER2
       		;; -1 OFFSET
       		;; ---------------------------------------------------------------------
       		;; MEMO - HIGH BYTE ADR OFFSET:
       		;; EVERY BANKSTICK PATCH NEED A HIGH BYTE OFFSET of -1
       		;; SO THAT PATCH Nr 1   => HIGH BYTE = 0
       		;; SO THAT PATCH Nr 2   => HIGH BYTE = 1
       		;; SO THAT PATCH Nr 3   => HIGH BYTE = 2
       		;; ...
       		;; SO THAT PATCH Nr 127 => HIGH BYTE = 126
       		;; THE HIGHEST BANKSTICK ADR = 7FFF 
       		;; => [7F(ADR.HIGH_BYTE)FF(ADR.LOW_BYTE)]
       		;; THERE WOULD BE NO ADR SPACE for A PATCH
       		;; STARTING WITH A HIGH BYTE ADR @ 127 (!)
       		;; SO THE LAST VALID HIGH BYTE ADR = 126 
       		;; ----------------------------------------------------------------------
        	decf	MIOS_PARAMETER2, F 
        	;; ----------------------------------------------------------------------
        	;; WRITE BANKSTICK FINGERPRINT TO PATCH [1-127] FINGERPRINT BYTE 
        	;; @ CURRENT PATCH ADR 0x00
        	movlw   CONST_BANKSTICK_PATCH_FINGERPRINT_VALUE
        	;; ... TO BANKSTICK
        	call	MIOS_BANKSTICK_Write        		; BS ADR will be incremented +1
        	;; bnz        BSProgrammingFailed       	; branch to your exception handler
			;; ----------------------------------------------------------------------

			;; MEMO:
			;; BS LOW BYTE ADR AUTO INC +1 HAS TAKEN PLACE AFTER WRITING ADR 0x00
			;; SO NOW WE WRITE BS PATCH LOW BYTE ADR 0x01
			movff	  BNKD_VAR_BROWSE_PATCH_NR, VAR_TMP_PATCH_DATA_CLIPBOARD
        	movf      VAR_TMP_PATCH_DATA_CLIPBOARD, W
        	;; ... TO BANKSTICK
        	call      MIOS_BANKSTICK_Write       	 ; (address will be incremented
        	                                         ;  after write)
        	;; bnz        BSProgrammingFailed        ; branch to your exception handler
			
			;; BS PATCH ADR 0x00 = FINGERPRINT
			;; BS PATCH ADR 0x01 = PATCH NUMBER VALUE
			;; SO SET BS LOW BYTE COUNTER TO 2
			movlw	CONST_SET_BS_LOW_BYTE_ADR_COUNTER_TO_2
			movwf	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD
			movff 	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, BNKD_VAR_BANKSTICK_LOW_BYTE_ADR_COUNTER

			;; THE FINGERPRINT & PATCH NUMBER VALUE HAS BEEN WRITTEN TO THE CURRENT BS PATCH
			;; SO EXIT HERE
			return
			;; ==============[END: WRITE BANKSTICK PATCH FINGERPRINT]======================

;; ----------------------------------------------------------------------------------------
;; ------------------------[END SUB ROUTINE: Write PATCH Fingerprint]----------------------
;; ----------------------------------------------------------------------------------------



;; -----------------------------------------------------------------------------------------
;; ---------------[SUB ROUTINE: WRITE DATA BYTE TO EEPROM OR BANKSTICK]---------------------
;; -----------------------------------------------------------------------------------------
SUB_ROUTINE_WRITE_PATCH_DATA_BYTE
	;; -------------------------------------------------------------------------------------
	;; -------------------------------------------------------------------------------------
	;; FUNCTION:
	;; WRITE A DATA BYTE 
	;; TO PIC EEPROM PATCH 		-> INC EEADR (PIC EEPROM) +1 
	;; OR TO BANKSTICK PATCH 	-> INC BNKD_VAR_BANKSTICK_LOW_BYTE_ADR_COUNTER +1
	;; -------------------------------------------------------------------------------------
	;; USES:
	;; IN		-> BNKD_VAR_PATCH_STATE_FLAGS (BIT2 SELECT BS OR PIC EEPROM PATCH)
	;; -------------------------------------------------------------------------------------
	;; PIC EEPROM PATCH USES:
	;; IN		-> VAR_TMP_PATCH_DATA_CLIPBOARD  (PATCH DATA BYTE)
	;; IN & OUT	-> EEADR (EEPROM Address Register Low Byte: ADR = ADR +1)
	;; -------------------------------------------------------------------------------------
	;; BANKSTICK PATCH USES:
	;; IN		-> VAR_TMP_PATCH_DATA_CLIPBOARD (PATCH DATA BYTE)
	;; IN		-> BNKD_VAR_BROWSE_PATCH_NR					(BS ADR HIGH BYTE)
	;; IN & OUT	-> BNKD_VAR_BANKSTICK_LOW_BYTE_ADR_COUNTER 	(BS ADR  LOW BYTE) +1 AFTER DATA WRITING 
	;;   	OUT	-> MIOS_PARAMETER1		(LOW  BYTE BS ADR -> call MIOS_BANKSTICK_Write)
	;; 		OUT	-> MIOS_PARAMETER2		(HIGH BYTE BA ARD -> call MIOS_BANKSTICK_Write)
	;;  	OUT	-> VAR_TMP_RAM_BYTE_COPY_CLIPBOARD (BNKD RAM BYTE -> TMP)
	;; -------------------------------------------------------------------------------------
	;; -------------------------------------------------------------------------------------
	
	;; CHECK: 
	;; PIC EEPROM OR BANKSTICK PATCH VIA BNKD_VAR_PATCH_STATE_FLAGS
	;; BIT2 = CLR = WRITE DATA BYTE TO EEPROM PATCH (PIC INTERNAL PATCH)
	;; BIT2 = SET = WRITE DATA BYTE TO BANKSTICK PATCH
	movff	BNKD_VAR_PATCH_STATE_FLAGS, VAR_TMP_RAM_BYTE_COPY_CLIPBOARD
	btfsc	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, BIT2_CHK_IF_PIC_EEPROM_PATCH_OR_BS_PATCH
			;; ======================================
			;; ===[WRITE DATA BYTE TO BANKSTICK]=====
			;; BECAUSE BIT2 IS SET	
			goto WRITE_PATCH_DATA_BYTE_TO_BANKSTICK
			;; ======================================
		
		;; ===[WRITE DATA BYTE TO INTERNAL EEPROM]===
		;; BECAUSE BIT2 IS CLEAR
		;; WRITE A BYTE to INTERNAL PATCH (PIC EEPROM)
		;; ==========================================
		;; FUNCTION:
		;; WRITE A DATA BYTE TO PIC EEPROM
		;; USES:
		;; -> VAR_TMP_PATCH_DATA_CLIPBOARD
		;; -------------------------------------------
		movf 	VAR_TMP_PATCH_DATA_CLIPBOARD, W
		call    MIOS_EEPROM_Write
		;; BYTE HAS BEEN WRITTEN TO EEPROM
		;; EEADR EEPROM Address Register Low Byte Auto INC
		;; EEADR = EEPROM ADR LOW BYTE = EEPROM ADR LOW BYTE +1
		;; EXIT THIS SUBROUTINE
		return
		;; ----[END: WRITE DATA BYTE TO INTERNAL EEPROM]------------------------------------

WRITE_PATCH_DATA_BYTE_TO_BANKSTICK
			;; FUNCTION:
			;; WRITE A DATA BYTE TO THE BANKSTICK
			;; USES:
			;; -> BNKD_VAR_BROWSE_PATCH_NR
			;; -> BNKD_VAR_BANKSTICK_LOW_BYTE_ADR_COUNTER
			;; -> VAR_TMP_PATCH_DATA_CLIPBOARD
			;; -> MIOS_PARAMETER1
			;; -> MIOS_PARAMETER2
			;; -> VAR_TMP_RAM_BYTE_COPY_CLIPBOARD (TMP)
			;;
			;; ===================[WRITE DATA BYTE TO BANKSTICK  ]================
			;; -------------------------------------------------------------------
			;; -------------------------------------------------------------------
			;; -------------------[SET BS ADR                    ]----------------
			;; -------------------[SET BS ADR HIGH-BYTE          ]----------------
      		;; store HIGH-byte of THE BANKSTICK Address in MIOS_PARAMETER2
			movff   BNKD_VAR_BROWSE_PATCH_NR, MIOS_PARAMETER2
			;; -------------------[ADJUST BS HIGH BYTE ADRESS    ]----------------
			;; -------------------[ADJUST HIGH-BYTE ADRESS -1    ]----------------
			;; DEC THE -1 PATCH NUMBER OFFSET TO ADJUST THE VALID PATCH
			decf	MIOS_PARAMETER2, F	
			;; -------------------------------------------------------------------
			;; -------------------[SET BS ADR LOW-BYTE           ]----------------
			;; STORE LOW-BYTE of BANKSTICK ADRESS in MIOS_PARAMETER1
			movff    BNKD_VAR_BANKSTICK_LOW_BYTE_ADR_COUNTER, MIOS_PARAMETER1
			;; -------------------[BS ADDRESS IS ADJUSTED NOW    ]----------------
			;; -------------------------------------------------------------------
			;; -------------------------------------------------------------------
			;; STORE THE CURRENT PATCH DATA BYTE IN WREG
			movf	VAR_TMP_PATCH_DATA_CLIPBOARD, W
			;; WRITE THE CURRENT DATA BYTE (WREG) TO BANKSTICK
			call    MIOS_BANKSTICK_Write	
			;; bnz   BSProgrammingFailed       		; branch to your exception handler
			;; BYTE HAS BEEN WRITTEN TO BAKSTICK
			;; --------------------------------------------------------------------
			;; BANKSTICK ADR = BANKSTICK ADR +1 (LOW BYTE)
			;; WE CAN NOT USE BANKSTICK ADR AUTO INC +1
			;; SO WE DO IT THIS WAY :-)
			movff	BNKD_VAR_BANKSTICK_LOW_BYTE_ADR_COUNTER, VAR_TMP_RAM_BYTE_COPY_CLIPBOARD
			incf	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, F
			movff	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, BNKD_VAR_BANKSTICK_LOW_BYTE_ADR_COUNTER
			;; --------------------------------------------------------------------  
			;; NOW THE STORE BYTE in BANKSTICK ROUTINE IS DONE
			;; SO LET'S EXIT HERE
			return
			;; ===============[END: WRITE DATA BYTE TO BANKSTICK  ]================
;; ---------------------------------------------------------------------------------------------
;; -----------------[END: WRITE DATA BYTE TO EEPROM OR BANKSTICK SUB ROUTINE]-------------------
;; ---------------------------------------------------------------------------------------------



;; ---------------------------------------------------------------------------------------------
;; -----------------------[SUB ROUTINE: STORE PATCH NAME              ]-------------------------
;; ---------------------------------------------------------------------------------------------

SUB_ROUTINE_WRITE_PATCH_NAME
	;; FUNCTION:
	;; WRITE PATCH NAME TO CURRENT PATCH
	;; WRITE 8 ASC VALUES (8 DATA BYTES) TO PIC EEPROM PATCH OR BANKSTICK PATCH
	;; ---------------------------------------------------------------------------------------
	;; PIC EEPROM PATCH USES:
	;; IN		-> CONST_PIC_EEPROM_ASC_NAME_ADR_LOW_BYTE
	;; 		OUT -> EEADR	(PIC EEPROM ADR LOW BYTE)
	;; IN & OUT -> VAR_TMP_RAM_BYTE_COPY_CLIPBOARD (TMP)
	;; IN		-> BNKD_VAR_PATCH_NAME_ASC_0 ... 8
	;; CALL		-> call 	SUB_ROUTINE_WRITE_PATCH_DATA_BYTE
	;; ---------------------------------------------------------------------------------------
	;; BANKSTICK PATCH USES:
	;; IN		-> CONST_BS_ASC_NAME_ADR_LOW_BYTE
	;;  	OUT -> BNKD_VAR_BANKSTICK_LOW_BYTE_ADR_COUNTER
	;; IN		-> BNKD_VAR_PATCH_NAME_ASC_0 ... 8
	;; IN & OUT	-> VAR_TMP_PATCH_DATA_CLIPBOARD (TMP)
	;; CALL		-> call 	SUB_ROUTINE_WRITE_PATCH_DATA_BYTE
	;; ---------------------------------------------------------------------------------------
	;; EEPROM:
	;; PATCH DATA BYTE ADR 0 has been Written (FINGERPRINT BYTE) - 
	;; FINGERPRINT ADR 	= 0x00
	;; ASC1				= 0x01
	;; ASC2				= 0x02
	;; ASC3				= 0x03
	;; ...
	;; ASC8				= 0x08
	;;
	;;     ---OR---
	;;
	;; BANKSTICK: 
	;; BANKSTICK ADR [PATCH OFFSET + 0] has been written with the BANKSTICK (FINGERPRINT BYTE)
	;; FINGERPRINT  ADR = 0x00
	;; PATCH NUMBER ADR = 0x01
	;; ASC1				= 0x02
	;; ASC2				= 0x03
	;; ASC3				= 0x04
	;; ...
	;; ASC8				= 0x09
	;;
	;;
	;; EEPROM      ADR 0 = FINGERPRINT BYTE
	;; NEXT EEPROM ADR THAT WILL BE WRITTEN           = 0x01 <----------
	;; 
	;; BANKSTICK ADR 0 = FINGERPRINT BYTE
	;; BANKSTICK ADR 1 = PATCH NUMBER BYTE
	;; NEXT BANKSTICK PATCH ADR THAT WILL BE WRITTEN  = 0x02 <----------
	
	
	;; PIC EEPROM INT. PATCH 0
	;; SET LOW BYTE ADR FOR WRITING 8x ASC VALUE (PATCHNAME) @ PIC EEPROM
	;; LOW BYTE address FOR THE PIC EEPROM is in EEADR 
	movlw	CONST_ADR_LOW_BYTE_PIC_EEPROM_ASC_NAME
	movwf	EEADR
	
	;; SET LOW BYTE ADR BS PATCH 1-128
	;; SET BS LOW BYTE ADR FOR READING 8x ASC (PATCHNAME)	@ BANKSTICK
	movlw	CONST_ADR_LOW_BYTE_BANKSTICKS_ASC_NAME
	movwf	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD
	movff	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, BNKD_VAR_BANKSTICK_LOW_BYTE_ADR_COUNTER
	

	;; PATCH NAME (STORE 8 ASC VALUES)
	;; ----------------------------------------------------------------------------------------------------
	;; WRITE PATCH DATA BYTE [INTERNAL PATCH - ADR 0x01 @ EEPROM] OR [BANKSTICK PATCH ADR 0x02 @ BANKSTICK]
	movff	BNKD_VAR_PATCH_NAME_ASC_0, VAR_TMP_PATCH_DATA_CLIPBOARD
	call 	SUB_ROUTINE_WRITE_PATCH_DATA_BYTE
	
	;; WRITE PATCH DATA BYTE [INTERNAL PATCH - ADR 0x02 @ EEPROM] OR [BANKSTICK PATCH ADR 0x03 @ BANKSTICK]
	movff	BNKD_VAR_PATCH_NAME_ASC_1, VAR_TMP_PATCH_DATA_CLIPBOARD
	call 	SUB_ROUTINE_WRITE_PATCH_DATA_BYTE
	
	;; WRITE PATCH DATA BYTE [INTERNAL PATCH - ADR 0x03 @ EEPROM] OR [BANKSTICK PATCH ADR 0x04 @ BANKSTICK]
	movff	BNKD_VAR_PATCH_NAME_ASC_2, VAR_TMP_PATCH_DATA_CLIPBOARD
	call 	SUB_ROUTINE_WRITE_PATCH_DATA_BYTE
	
	;; WRITE PATCH DATA BYTE [INTERNAL PATCH - ADR 0x04 @ EEPROM] OR [BANKSTICK PATCH ADR 0x05 @ BANKSTICK]
	movff	BNKD_VAR_PATCH_NAME_ASC_3, VAR_TMP_PATCH_DATA_CLIPBOARD
	call 	SUB_ROUTINE_WRITE_PATCH_DATA_BYTE
	
	;; WRITE PATCH DATA BYTE [INTERNAL PATCH - ADR 0x05 @ EEPROM] OR [BANKSTICK PATCH ADR 0x06 @ BANKSTICK]
	movff	BNKD_VAR_PATCH_NAME_ASC_4, VAR_TMP_PATCH_DATA_CLIPBOARD
	call 	SUB_ROUTINE_WRITE_PATCH_DATA_BYTE
	
	;; WRITE PATCH DATA BYTE [INTERNAL PATCH - ADR 0x06 @ EEPROM] OR [BANKSTICK PATCH ADR 0x07 @ BANKSTICK]
	movff	BNKD_VAR_PATCH_NAME_ASC_5, VAR_TMP_PATCH_DATA_CLIPBOARD
	call 	SUB_ROUTINE_WRITE_PATCH_DATA_BYTE
	
 	;; WRITE PATCH DATA BYTE [INTERNAL PATCH - ADR 0x07 @ EEPROM] OR [BANKSTICK PATCH ADR 0x08 @ BANKSTICK]
	movff	BNKD_VAR_PATCH_NAME_ASC_6, VAR_TMP_PATCH_DATA_CLIPBOARD
	call 	SUB_ROUTINE_WRITE_PATCH_DATA_BYTE
	
	;; WRITE PATCH DATA BYTE [INTERNAL PATCH - ADR 0x08 @ EEPROM] OR [BANKSTICK PATCH ADR 0x09 @ BANKSTICK]
	movff	BNKD_VAR_PATCH_NAME_ASC_7, VAR_TMP_PATCH_DATA_CLIPBOARD
	call 	SUB_ROUTINE_WRITE_PATCH_DATA_BYTE

	;; PATCH NAME STORED (8x ASC)
	;; EXIT SUB ROUTINE
	return

;; ---------------------------------------------------------------------------------------------
;; -----------------------[END SUB ROUTINE: STORE PATCH NAME          ]-------------------------
;; ---------------------------------------------------------------------------------------------


;; ---------------------------------------------------------------------------------------------
;; -----------------------[SUB ROUTINE: STORE PATCH DATA              ]-------------------------
;; ---------------------------------------------------------------------------------------------
;; STORE PATCH DATA
SUB_ROUTINE_WRITE_PATCH_DATA
	;; ------------------------[SET LOW BYTE ADR FOR PATCH DATA WRITING]------------------------
	;; PIC EEPROM INT. PATCH Nr. 0
	;; SET LOW BYTE ADR FOR READING PATCH DATA
	;; LOW BYTE address FOR THE PIC EEPROM is in EEADR 
	movlw	CONST_ADR_LOW_BYTE_PIC_EEPROM_PATCH_DATA
	movwf	EEADR
	
	;; BS PATCH 1-128
	;; SET BS LOW BYTE ADR FOR READING PATCH DATA
	movlw	CONST_ADR_LOW_BYTE_BANKSTICK_PATCH_DATA
	movwf	BNKD_VAR_BANKSTICK_LOW_BYTE_ADR_COUNTER
	;; ---------------------------------------------------------------------------
	
	;; -----------------------[DO STORE PATCH DATA]-------------------------------
	;;
	;; PATCH DATA BYTE 009
	;; PATCH DATA BYTE [INTERNAL PATCH - ADR 0x09 @ EEPROM] [BANKSTICK PATCH ADR 0x0A @ BANKSTICK]
	movff 	VAR_TONE_A_TUNE_FINE_USER, VAR_TMP_PATCH_DATA_CLIPBOARD
	call 	SUB_ROUTINE_WRITE_PATCH_DATA_BYTE
	
	;; PATCH DATA BYTE 010
	;; PATCH DATA BYTE [INTERNAL PATCH - ADR 0x0A @ EEPROM] [BANKSTICK PATCH ADR 0x0B @ BANKSTICK]
	movff 	VAR_TONE_B_TUNE_FINE_USER, VAR_TMP_PATCH_DATA_CLIPBOARD
	call 	SUB_ROUTINE_WRITE_PATCH_DATA_BYTE
	
	;; PATCH DATA BYTE 011
	;; etc. ...
	movff VAR_TONE_C_TUNE_FINE_USER, VAR_TMP_PATCH_DATA_CLIPBOARD
	call 	SUB_ROUTINE_WRITE_PATCH_DATA_BYTE
	
	;; PATCH DATA BYTE 012 ...
	movff VAR_TONE_A_TUNE_COARSE_USER, VAR_TMP_PATCH_DATA_CLIPBOARD
	call 	SUB_ROUTINE_WRITE_PATCH_DATA_BYTE

	movff VAR_TONE_B_TUNE_COARSE_USER, VAR_TMP_PATCH_DATA_CLIPBOARD
	call 	SUB_ROUTINE_WRITE_PATCH_DATA_BYTE
	
	movff VAR_TONE_C_TUNE_COARSE_USER,VAR_TMP_PATCH_DATA_CLIPBOARD
	call 	SUB_ROUTINE_WRITE_PATCH_DATA_BYTE
	
	movff MIDI_CHANNEL_TONE_A_USER, VAR_TMP_PATCH_DATA_CLIPBOARD
	call 	SUB_ROUTINE_WRITE_PATCH_DATA_BYTE
	
	movff MIDI_CHANNEL_TONE_B_USER, VAR_TMP_PATCH_DATA_CLIPBOARD
	call 	SUB_ROUTINE_WRITE_PATCH_DATA_BYTE
	
	movff MIDI_CHANNEL_TONE_C_USER, VAR_TMP_PATCH_DATA_CLIPBOARD
	call 	SUB_ROUTINE_WRITE_PATCH_DATA_BYTE
	
	movff VAR_VELOCITY_TO_ABC_NOISE_PERIOD_ON_OFF, VAR_TMP_PATCH_DATA_CLIPBOARD
	call 	SUB_ROUTINE_WRITE_PATCH_DATA_BYTE

	movff VAR_AY_CHIP_REG6_NOISE_PERIOD, VAR_TMP_PATCH_DATA_CLIPBOARD
	call 	SUB_ROUTINE_WRITE_PATCH_DATA_BYTE
	
	movff VAR_AY_CHIP_REG8_CH_A_AMPLITUDE, VAR_TMP_PATCH_DATA_CLIPBOARD
	call 	SUB_ROUTINE_WRITE_PATCH_DATA_BYTE

	movff VAR_AY_CHIP_REG9_CH_B_AMPLITUDE, VAR_TMP_PATCH_DATA_CLIPBOARD
	call 	SUB_ROUTINE_WRITE_PATCH_DATA_BYTE

	movff VAR_AY_CHIP_REG10_CH_C_AMPLITUDE, VAR_TMP_PATCH_DATA_CLIPBOARD
	call 	SUB_ROUTINE_WRITE_PATCH_DATA_BYTE

	movff VAR_AY_CHIP_REG11_ENV_PERIOD_FINE, VAR_TMP_PATCH_DATA_CLIPBOARD
	call 	SUB_ROUTINE_WRITE_PATCH_DATA_BYTE
	
	movff VAR_AY_CHIP_REG12_ENV_PERIOD_COARSE, VAR_TMP_PATCH_DATA_CLIPBOARD
	call 	SUB_ROUTINE_WRITE_PATCH_DATA_BYTE
	
	movff VAR_ENV_SHAPE_0_15_to_1_8_TRANSLATOR, VAR_TMP_PATCH_DATA_CLIPBOARD
	call 	SUB_ROUTINE_WRITE_PATCH_DATA_BYTE

	movff VAR_TONE_NOISE_ABC_USER_ON_OFF_SWITCH, VAR_TMP_PATCH_DATA_CLIPBOARD
	call 	SUB_ROUTINE_WRITE_PATCH_DATA_BYTE

	;; WRITE:
	;; PATCH DATA BYTE 027
	;; INTERNAL PATCH DATA BYTE   [INTERNAL EEPROM PATCH - ADR 0x1B (027 DEC)@ EEPROM   ] 
	;; BANKSTICK PATCH DATA BAYTE [BANKSTICK PATCH         ADR 0x1C (028 DEC)@ BANKSTICK]
	movff 	BNKD_VAR_FX_USER_ON_OFF_ABC, VAR_TMP_PATCH_DATA_CLIPBOARD
	call 	SUB_ROUTINE_WRITE_PATCH_DATA_BYTE
	
			;; PATCH DATA STORED
			;; EXIT HERE
			return

;; ---------------------------------------------------------------------------------------------
;; -----------------------[END SUB ROUTINE: STORE PATCH DATA          ]-------------------------
;; ---------------------------------------------------------------------------------------------


;; ---------------------------------------------------------------------------------------------
;; -----------------------[SUB ROUTINE: STORE PATCH Fx DATA           ]-------------------------
;; ---------------------------------------------------------------------------------------------
;; STORE PATCH ALL FX DATA
SUB_ROUTINE_WRITE_CURRENT_PATCH_FX_DATA

	;; -----------------------------------------------------------------------------------------
	;; --------[PREPARE to STORE Fx (Fx FUNCTION, Fx DATA, Fx TIME)]----------------------------
	;;    PREPARE TO WRITE ALL Fx REGS to PIC EEPROM (INTernal Patch) or BANKSTICK
	;; -----------------------------------------------------------------------------------------
	movlw CONST_BSR2_SELECT_Fx_RAM_BANK		;; INDIRECT RAM ADDRESSING - SELECT RAM BANK
	movwf FSR0H								;; SET THE RAM BANK (WRITE TO IND. FILE SELECT REGISTER HIBYTE)
	clrf  VAR_Fx_LOAD_WRITE_ADR_COUNTER_TMP	;; RESET WRITE CYCLE [0-31] COUNTER
	;; -----------------------------------------------------------------------------------------
	;; ---------[END: PREPARE to SAVE Fx (Fx FUNCTION, Fx DATA, Fx TIME)]-----------------------
	;; -----------------------------------------------------------------------------------------

	;; CHECK: 
	;; DO WE WRITE DATA TO EEPROM or BANKSTICK?
	;; VIA BNKD_VAR_PATCH_STATE_FLAGS
	;; BIT2 = 0 = WRITE Fx DATA to EEPROM (PIC INTERNAL PATCH)
	;; BIT2 = 1 = WRITE Fx DATA to BANKSTICK 
	movff	BNKD_VAR_PATCH_STATE_FLAGS, VAR_TMP_RAM_BYTE_COPY_CLIPBOARD
	btfsc	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, BIT2_CHK_IF_PIC_EEPROM_PATCH_OR_BS_PATCH
			;; BANKSTICK
			;; BIT2 = SET	
			goto WRITE_ALL_FX_PATCH_DATA_TO_BANKSTICK
		
			;; INTERNAL PTACH 0
			;; BIT2 = CLEAR
			;; WRITE PATCH FINGERPRINT INTERNAL 
			goto WRITE_ALL_FX_PATCH_DATA_TO_EEPROM
			

	;; -----------------------------------------------------------------------------------
	;; -----------------------[START: WRITE Fx DATA TO EEPROM]----------------------------
	;; -----------------------------------------------------------------------------------
WRITE_ALL_FX_PATCH_DATA_TO_EEPROM	
	
	;; DO LOOP 32x 
WRITE_PATCH_FX_FUNC_TO_EEPROM
	;; -----------------------------------------------------------------------------------
	;; ----------------------[WRITE Fx *Func* to EEPROM]----------------------------------
	;; LOAD FX FUNCTION [POS 0-31] from PIC RAM
	;; Fx FUNCTIONS @ CURRENT Fx Pos [0-31]	
	movlw CONST_RAM_ADR_OFFSET_FX_FUNCTION		;; PIC RAM BANK OFFSET - fx functions 
	addwf VAR_Fx_LOAD_WRITE_ADR_COUNTER_TMP, W 		;; OFFSET + (0 to 31 [32]) => Fx Tab Pos
	movwf FSR0L									;; CURRENT Fx Func. ADR. (current Fx Func. Pos.)
 	movff INDF0, VAR_TMP_PATCH_DATA_CLIPBOARD 				;; WRITE FX FUNCTION (CURRENT Pos) to TMP
	;; ------------------------------------------------------------------------------
	;; WRITE Fx FUNTION @ POS [0-31] TO EEPROM
	movlw	CONST_EEPROM_OFFSET_ADR_FX_FUNCTION		;; CONST: EEPROM OFFSET (0x20)
	addwf	VAR_Fx_LOAD_WRITE_ADR_COUNTER_TMP, W	;; ADD EEPROM OFFSET + POS
	movwf	EEADR 									;; SETUP EEPROM ADRESS [OFFSET+POS] for WRITING
	movf	VAR_TMP_PATCH_DATA_CLIPBOARD, W        	;; WRITE FX FUNCTION @ CURRENT Pos TO WREG
	call	MIOS_EEPROM_Write        				;; WRITE FX FUNCTION @ CURRENT Pos TO PIC EEPROM 
													;; (EEADR will be incremented)
	;; ------------------------------------------------------------------------------
	;; ------------------------------------------------------------------------------
		;; POS = POS +1
		incf 	VAR_Fx_LOAD_WRITE_ADR_COUNTER_TMP, F ;; pos = pos +1 | pos range 0 to 31 [32 pos gesamt]
		;; check if pos = 32 [range = 0 to 31]
		movlw 	FX_POS_MAX_PLUS1 ;; dec 31+1
		cpfseq 	VAR_Fx_LOAD_WRITE_ADR_COUNTER_TMP
			
			;; POS < 32
			;; Do another Fx Func WRITE CYCLE
			;; write 32x
			goto WRITE_PATCH_FX_FUNC_TO_EEPROM
			
			;; POS = 32
			;; ALL Fx Func. REGS HAD BEEN SAVED TO EEPROM
			;; RESET WRITE CYCLE [0-31] COUNTER
			;; go on with Write Fx DATA
			clrf VAR_Fx_LOAD_WRITE_ADR_COUNTER_TMP
	;; ---------------[END: Fx Func to EEPROM WRITING CYCLE]-------------------------
	;; ------------------------------------------------------------------------------
	

	;; ---------------[WRITE Fx DATA to EEPROM WRITING CYCLE]------------------------
WRITE_PATCH_FX_DATA_TO_EEPROM
	;; DO 32x 
	;; LOAD Fx DATA [POS 0-31] from PIC RAM
	;; Fx DATA @ CURRENT Fx Pos [0-31]	
	;; LOAD FX DATA
	;; Fx DATA Reg. @ CURRENT Fx Pos [0-31]	
	movlw RAM_OFFSET_FX_DATA 					;; PIC RAM OFFSET - to fx DATA Registers
	addwf VAR_Fx_LOAD_WRITE_ADR_COUNTER_TMP, W 	;; OFFSETT + POS (0 to 31 [32]) => Fx Tab. Pos
	movwf FSR0L									;; LOAD CURRENT OFFSET IND. ADR. 
												;; for Fx DATA Registers @ current Fx Pos.
	movff INDF0, VAR_TMP_PATCH_DATA_CLIPBOARD 	;; WRITE FX DATA @ CURRENT Pos to TEMP
	;; --------------------------------------------------------------------------------------
	movlw	EEPROM_OFFSET_FX_DATA				;; LOAD EEPROM OFFSET
	addwf	VAR_Fx_LOAD_WRITE_ADR_COUNTER_TMP, W	;; EEPROM OFFSET + POS (0-31)
	movwf   EEADR 								;; SET EEPROM ADRESS [OFFSET+POS]
        movf    VAR_TMP_PATCH_DATA_CLIPBOARD, W    		;; WRITE FX DATA @ CURRENT Pos TO WREG
        call    MIOS_EEPROM_Write    			;; WRITE FX DATA @ CURRENT Pos TO PIC EEPROM 
												;; EEADR will be incremented (AUTO INC)
	;; ------------------------------------------------------------------------------
		incf VAR_Fx_LOAD_WRITE_ADR_COUNTER_TMP, F ;; pos = pos +1 | pos range 0 to 31 [32 pos gesamt]
		
		;; check if pos = FX_POS_MAX_PLUS1	(32 =  Fx Tab Max. +1 (31+1))
		movlw 	FX_POS_MAX_PLUS1	 ;; dec 32
		cpfseq 	VAR_Fx_LOAD_WRITE_ADR_COUNTER_TMP
			
			;; Fx Tab. Pos < 32
			;; GO ON WITH AONTHER "WRITE FX DATA TO EEPROM" CYCLE
			goto WRITE_PATCH_FX_DATA_TO_EEPROM
			
			;; POS = 32
			;; ALL Fx DATA REGS HAD BEEN SAVED TO EEPROM
			;; RESET WRITE CYCLE [0-31] COUNTER
			;; go on with Write Fx TIME
			clrf VAR_Fx_LOAD_WRITE_ADR_COUNTER_TMP
	;; ---------------[END: Fx DATA to EEPROM WRITING CYCLE]--------------------------------

WRITE_PATCH_FX_TIME_TO_EEPROM
	;; DO 32x 
	;; ---------------[Fx PRE DELAY TIME to EEPROM WRITING CYCLE]---------------------------
	;; LOAD FX PRE DELAY TIME
	;; Fx PRE DELAY TIME Reg. @ CURRENT Fx Pos [0-31]	
	movlw RAM_OFFSET_FX_TIME_PRE_EXECUTION		;; PIC RAM OFFSET - to fx functions 
	addwf VAR_Fx_LOAD_WRITE_ADR_COUNTER_TMP, W 		;; OFFSET + (0 to 31 [32]) => Fx Tab Pos
	movwf FSR0L									;; LOAD CURRENT OFFSET IND. ADR. 
												;; for Fx TIME Registers @ current Fx Pos.
 	movff INDF0, VAR_TMP_PATCH_DATA_CLIPBOARD 			;; WRITE FX FUNCTION @ CURRENT Pos to TEMP
	;; --------------------------------------------------------------------------------------
	movlw	EEPROM_OFFSET_FX_TIME_PRE_EXECUTION  	;; EEPROM OFFSET (!)
	addwf	VAR_Fx_LOAD_WRITE_ADR_COUNTER_TMP, W	;; OFFSET + POS
	movwf   EEADR 					;; SET EEPROM ADRESS [OFFSET+POS]
        movf    VAR_TMP_PATCH_DATA_CLIPBOARD, W     		;; WRITE FX FUNCTION @ CURRENT Pos TO WREG
        call    MIOS_EEPROM_Write        		;; WRITE FX FUNCTION @ CURRENT Pos TO PIC EEPROM 
									;; (EEADR will be incremented)
	;; ------------------------------------------------------------------------------
	
		incf VAR_Fx_LOAD_WRITE_ADR_COUNTER_TMP, F ;; pos = pos +1 | pos range 0 to 31 [32 pos gesamt]
		
		;; check if pos = FX_POS_MAX_PLUS1	(32 =  Fx Tab Max. +1 (31+1))
		movlw 	FX_POS_MAX_PLUS1 ;; Fx Tab Pos > Fx Pos Max  ?
		cpfseq  VAR_Fx_LOAD_WRITE_ADR_COUNTER_TMP
			
			;; VAR_Fx_LOAD_WRITE_ADR_COUNTER_TMP < 32
			;; DO ANOTHER CYCLE
			;; TILL VAR_Fx_LOAD_WRITE_ADR_COUNTER_TMP = FX_POS_MAX_PLUS1
			goto WRITE_PATCH_FX_TIME_TO_EEPROM
			
		
	;; ---------------[END: Fx PRE DELAY TIME to EEPROM WRITING CYCLE]----------------
				
				;; FX DATA HAS BEEN WRITTEN
				;; EXIT HERE
				return

;; ---------------------------------------------------------------------------
;; ----------------[END: WRITE Fx DATA TO PIC EEPROM ]------------------------
;; ---------------------------------------------------------------------------
;; ---------------------------------------------------------------------------


;; ---------------------------------------------------------------------------
;; ---------------------------------------------------------------------------
;; ----------------[START: WRITE Fx DATA TO BANKSTICK]------------------------
;; ---------------------------------------------------------------------------
;; ---------------------------------------------------------------------------
WRITE_ALL_FX_PATCH_DATA_TO_BANKSTICK
	
	;; DO LOOP 32x 
WRITE_PATCH_FX_FUNC_TO_BANKSTICK
	;; -------------------------------------------------------------------------------
	;; ---------------[WRITE Fx *Functions* to BANKSTICK]----------------------------------
	;; LOAD FX FUNCTION [POS 0-31] from PIC RAM
	;; Fx FUNCTIONS @ CURRENT Fx Pos [0-31]	
	movlw CONST_RAM_ADR_OFFSET_FX_FUNCTION	;; CONST: PIC RAM BANK OFFSET - fx functions Area 
	addwf VAR_Fx_LOAD_WRITE_ADR_COUNTER_TMP, W 	;; OFFSET + (POS 0 to 31 [32]) => Fx Tab Pos
	movwf FSR0L								;; CURRENT Fx Func. ADR. (current Fx Func. Pos.)
 	movff INDF0, VAR_TMP_PATCH_DATA_CLIPBOARD 			;; WRITE FX FUNCTION (CURRENT Pos) to TMP
	;; ------------------------------------------------------------------------------
	;; MEMO:
	;; HOW DOES THIS ROUTINE CHOOSE THE RIGHT BANKSTICK ADRESS?
	;; VAR_Fx_LOAD_WRITE_ADR_COUNTER_TMP WAS ALREADY CLEARD (WRITE CYCLE COUNTER [0-31])
	;; THE BANKSTICK ADRESS WAS predefined by the *WRITE_PATCH_FINGERPRINT_BANKSTICK* ROUTINE
	;; THE WRITE_PATCH_FINGERPRINT_BANKSTICK ROUTINE DO:
	;; * SET THE BANKSTICK *HIGH BYTE* ADR to the *CURRENT PATCH NUMBER* -1 [[[RANGE: 1 to 128] -1] (=> 0 to 127)]
	;; * CLEAR THE BANKSTICK LOW ADR BYTE COUNTER to 0
	;; * WRITE THE FINGERPRINT BYTE @ PATCH DATA LOW BYTE ADR. 0 (THEN THE LOW ADR. BYTE = 1 (AUTO INC))
	;; * WRITE THE PATCH NUMBER BYTE @ PATCH DATA LOW BYTE ARD. 1 (THEN THE LOW ADR. BYTE = 2 (AUTO INC))
	;; * SET THE BNKD_VAR_BANKSTICK_LOW_BYTE_ADR_COUNTER to 2 (not relevant here)
	;; -------------------------------------------------------------------------------
	;; -----[DO WRITE BYTE TO BANKSTICK]----------------------------------------------
	movf    VAR_TMP_PATCH_DATA_CLIPBOARD, W        		;; WRITE FX FUNCTION @ CURRENT Pos TO WREG
	call   	MIOS_BANKSTICK_Write        		;; WRITE [FX FUNCTION] @ CURRENT Pos TO PIC BANKSTICK
												;; (BANKSTICK address will be incremented after write)

		;; -------------------------------------------------
		;; -------------------------------------------------
		;; Cycle POS = CYCLE POS +1
		incf VAR_Fx_LOAD_WRITE_ADR_COUNTER_TMP, F ;; pos = pos +1 | pos range 0 to 31 [32 BYTES]
		;; Check:
		;; Pos = 32 ?
		movlw 	FX_POS_MAX_PLUS1 ;; dec 31+1
		cpfseq 	VAR_Fx_LOAD_WRITE_ADR_COUNTER_TMP
			;; NO,
			;; Cycle POS < 32
			;; Do another RAM READ / BANKSTICK WRITE CYCLE
			;; DO 32 CYCLES
			goto WRITE_PATCH_FX_FUNC_TO_BANKSTICK
			
			;; YES,
			;; POS = 32
			;; ALL Fx Func. REGISTERS HAVE BEEN SAVED TO BANKSTICK PATCH
			;; RESET WRITE CYCLE [0-31] COUNTER
			;; GO ON with Write Fx DATA
			clrf VAR_Fx_LOAD_WRITE_ADR_COUNTER_TMP
			;; ----------------------------------------------------------------------
	;; -------------------[END: Fx Func to BS WRITING CYCLE]-------------------------
	;; ------------------------------------------------------------------------------

	;; -------------------[WRITE Fx DATA to BS WRITING CYCLE]------------------------
WRITE_PATCH_FX_DATA_TO_BANKSTICK
	;; DO 32x 
	;; LOAD Fx DATA [POS 0-31] from PIC RAM
	;; Fx DATA @ CURRENT Fx Pos [0-31]	
	;; LOAD FX DATA
	;; Fx DATA Reg. @ CURRENT Fx Pos [0-31]	
	movlw RAM_OFFSET_FX_DATA 				;; PIC RAM ADR OFFSET -> to fx DATA Registers
	addwf VAR_Fx_LOAD_WRITE_ADR_COUNTER_TMP, W 	;; OFFSETT + POS (0 to 31 [32 BYTES]) => Fx Tab. Pos
	movwf FSR0L								;; LOAD CURRENT OFFSET IND. ADR. for Fx DATA Registers @ current Fx Pos.
	movff INDF0, VAR_TMP_PATCH_DATA_CLIPBOARD 			;; WRITE FX DATA @ CURRENT Pos to TEMP
	;; ----------------------------------------------------------------------------------
	;; ------------------[DO WRITE BYTE TO BANKSTICK]------------------------------------
	movf	VAR_TMP_PATCH_DATA_CLIPBOARD, W        	;; WRITE FX FUNCTION @ CURRENT Pos TO WREG
	call   	MIOS_BANKSTICK_Write       		;; WRITE [FX DATA]   @ CURRENT Pos TO BANKSTICK
							;; MEMO: BANKSTICK ADDRESS will be incremented after write
		;; ----------------------------------------------------------------------------------
		;; ----------------------------------------------------------------------------------
		;; Cycle POS = CYCLE POS +1
		incf 	VAR_Fx_LOAD_WRITE_ADR_COUNTER_TMP, F 	;; CYCLE POS = CYCLE POS +1 | POS RANGE 0 to 31 
		;; CECK:
		;; POS = 32?
		movlw 	FX_POS_MAX_PLUS1 					;; => 31+1 (VALID RANGE 0-31 == 32 BYTES) 
		cpfseq 	VAR_Fx_LOAD_WRITE_ADR_COUNTER_TMP
			;; NO,
			;; Cycle POS < 32
			;; Do ANOTHER CYCLE 
			;; READ A RAM BYTE
			;; STORE BYTE IN BANKSTICK 
			;; DO WRITE 32 BYTES FROM RAM TO BANKSTICK 
			goto WRITE_PATCH_FX_DATA_TO_BANKSTICK
			
			;; YES,
			;; POS = 32
			;; ALL Fx DATA REGS HAVE BEEN SAVED TO BANKSTICK PATCH
			;; RESET WRITE CYCLE [0-31] COUNTER
			;; Go on with Write Fx TIME
			clrf VAR_Fx_LOAD_WRITE_ADR_COUNTER_TMP
			;; -----------------------------------------------------------------------------
			;; -----------------------------------------------------------------------------
	;; ---------------[END: Fx DATA to BS WRITING CYCLE]------------------------------------

WRITE_PATCH_FX_TIME_TO_BANKSTICK
	;; DO 32x 
	;; ---------------[Fx PRE DELAY TIME to EEPROM WRITING CYCLE]---------------------------
	;; LOAD FX PRE DELAY TIME
	;; Fx PRE DELAY TIME Reg. @ CURRENT Fx Pos [0-31]	
	movlw RAM_OFFSET_FX_TIME_PRE_EXECUTION		;; PIC RAM OFFSET - to fx functions 
	addwf VAR_Fx_LOAD_WRITE_ADR_COUNTER_TMP, W 		;; OFFSET + (0 to 31 [32]) => Fx Tab Pos
	movwf FSR0L									;; LOAD CURRENT OFFSET IND. ADR. 
												;; for Fx TIME Registers @ current Fx Pos.
 	movff INDF0, VAR_TMP_PATCH_DATA_CLIPBOARD 				;; WRITE FX FUNCTION @ CURRENT Pos to TEMP
	;; --------------------------------------------------------------------------------------
	;; -----[DO WRITE BYTE TO BANKSTICK]-----------------------------------------------------
	movf   	VAR_TMP_PATCH_DATA_CLIPBOARD, W   	;; WRITE FX FUNCTION @ CURRENT Pos TO WREG
	call   	MIOS_BANKSTICK_Write        		;; WRITE [FX PRE EXECUTION TIME] @ CURRENT Pos TO BANKSTICK
												;; (BANKSTICK address will be incremented after write)
		;; ----------------------------------------------------------------------------------
		;; ----------------------------------------------------------------------------------
		;; Cycle POS = CYCLE POS +1
		incf VAR_Fx_LOAD_WRITE_ADR_COUNTER_TMP, F ;; pos = pos +1 | pos range 0 to 31 [32]
		;; Check if pos = 32 
		movlw 	FX_POS_MAX_PLUS1 ;; dec 31+1
		cpfseq 	VAR_Fx_LOAD_WRITE_ADR_COUNTER_TMP
			;; NO,
			;; Cycle POS < 32
			;; Do another RAM READ / BANKSTICK WRITE CYCLE
			;; DO 32 RAM READ / BANKSTICK WRITE CYCLES
			goto WRITE_PATCH_FX_TIME_TO_BANKSTICK
			;; ------------------------------------------------------------------------------
			;; YES,
			;; POS = 32
			;; ALL Fx TIME REGS HAVE BEEN SAVED TO BANKSTICK PATCH
			;; RESET WRITE CYCLE [0-31] COUNTER
			clrf VAR_Fx_LOAD_WRITE_ADR_COUNTER_TMP
			;; -------------------------------------------------------------------------------
	
				;; EXIT HERE
				return

;; ---------------------------------------------------------------------------
;; ---------------------------------------------------------------------------
;; -----------------------[END: WRITE Fx DATA TO BANKSTICK]-------------------
;; ---------------------------------------------------------------------------



;; #########################################################################################
;; -----------------------------------------------------------------------------------------
;; ---------------------------[:: END SUBROUTINES ::]---------------------------------------
;; -----------------------------------------------------------------------------------------
;; #########################################################################################

