;; FUNCTION:
;; DO CURSOR BLINKING IF NOTHIG ELE IS TO DO

DO_CSR_BLINKING
	;; DO NO CUSOR BLINKING IF A BTN IS PRESSED
	;; IF A BTN IS PRESSED EXIT HERE
	;; IS = PRESSED   (BTN STATE  = 0)
	;; IS = DEPRESSED (BTN STATE  = 1)
	movlw 	CONST_PRESSED_BTN_STATE_VALUE0	
	cpfsgt 	VAR_CURRENT_DIN_BTN_STATE
		
			;; -[BTN STATE = PRESSED]---
			;; -[DO RESET TRIGGER   ]---
			goto	DO_CSR_BLINKING_COUNTER_RESET
		
	;; GO ON,
	;; --------[BTN STATE = DEPRESSED                ]-------------------------
	;; --------[DO: INC BLINKING 16BIT CSR TIMER1 +1 ]------------------------- 
	movlw CONST_BSR1_SELECT_RAM_BANK1 				;; SET IDIRECT RAM ACCESS
	movwf FSR1H 									;; SET HIGH BYTE ADR @ FSR1 == INDF1
	movlw CONST_RAM_ADR_OFFSET_CSR_16BIT_TIMER1
	movwf FSR1L 									;; SET LOW  BYTE ADR @ FSR1 == INDF1
	;; -------[DO INC 16BIT CSR BLINKING TIMER1 +1   ]-------------------------
	;; -------[DO USE MIOS_HLP_16bitAddSaturate      ]-------------------------
	;; NOTE MIOS_HLP_16bitAddSaturate:
	;; The function call MIOS_HLP_16bitAddSaturate adds a signed 8-bit 
	;; value (1 to 255 / -1 to -255) to a 16 bit value and saturates
	;; That means: if the resulting value is greater than the given MAX VALUE, 
	;; the result will be saturated to the max value. 
	;; If the resulting value is less than 0, the result will be saturated to 0
	;; Important: the 16-bit value must be aligned to an even word address (0x10, 0x12, 0x14, ...). 
	;; First address contains the low-byte and the second address contains the high-byte 
	;;
	;; ---[DO: SET MIOS_HLP_16bitAddSaturate max-value = 0xFFFF ]-------------
	movlw 0xFF 					; low-byte of max value
	movwf MIOS_PARAMETER1		; in MIOS_PARAMETER1
	movlw 0xFF 					; high-byte of max value
	movwf MIOS_PARAMETER2		; in MIOS_PARAMETER2
	;; ---[DO: INC 16BIT TIMER +1                               ]-------------
	movlw 1 					; incrementer is +1
	;; -------[call MIOS_HLP_16bitAddSaturate                   ]-------------
	call MIOS_HLP_16bitAddSaturate
	;; NOTICE:
	;; THE INCREMETER WAS ADDED TO THE 16BIT TIMER or THE 16BIT TIMER WAS saturated.
	;; THERE IS AN OTHER RESULT IN WREG AND MIOS_PARAMETER1 
	;; = 1 if the value has been changed          (16BIT TIMER IS NOT saturated = 16BIT TIMER IS = 16BIT TIMER + INCREMETER)
	;; = 0 if the value is equal to the old value (16BIT TIMER IS saturated     = 0 or max-value)
	clrw
	cpfseq	MIOS_PARAMETER1
		;; 16BIT TIMER1 IS NOT SATURATED 
		;; EXIT HERE (do count on ...)
		return

	;; 16BIT BLINKING CSR TIMER1 IS SATURATED (max-value)
	;; ---[DO: RESET BLINKING CSR TIMER1            ]------------------------
	clrw	
	movff	WREG, BNKD_VAR_CRS_BLINKING_TIMER1L
	movff	WREG, BNKD_VAR_CRS_BLINKING_TIMER1H
			
	;; ---[DO: SET LOW BYTE ADR 16BIT BLINKING CSR TIMER2 @ FSR1 == INDF1]--
	movlw CONST_RAM_ADR_OFFSET_CSR_16BIT_TIMER2
	movwf FSR1L 									
	;; ---[DO INC 16BIT CSR BLINKING TIMER2 +1     ]------------------------
	;; ---[DO USE MIOS_HLP_16bitAddSaturate        ]------------------------
	;; ---[SET max-value = 0x01ff                  ]------------------------
	;; NOTICE: 
	;; SET CSR BLINKING TIME HERE !
	movlw 0xFF 										; low-byte of max value
	movwf MIOS_PARAMETER1
	movlw 0x01 										; high-byte of max value
	movwf MIOS_PARAMETER2
	movlw 4 										; incrementer is +4
	call MIOS_HLP_16bitAddSaturate
	;; NOTICE:
	;; THE INCREMETER WAS ADDED TO THE 16BIT TIMER2 or THE 16BIT TIMER2 IS saturated.
	;; THERE IS AN OTHER RESULT IN WREG AND MIOS_PARAMETER1 
	;; = 1 if the value has been changed (16BIT TIMER IS NOT saturated)
	;; = 0 if the value is equal to the old value (16BIT TIMER IS saturated)
	clrw
	cpfseq	MIOS_PARAMETER1
		;; MIOS_PARAMETER1 <> 0
		;; BLINKING CSR TIMER2 HIGH BYTE = NOT saturated
		;; EXIT HERE (TIMER2: do count on ... )
		return

		;; BLINKING CSR TIMER2 = saturated (max-value)
		;; ----[DO: RESET BLINKING CSR TIMER2 ]----------------------------
		clrw	
		movff	WREG, BNKD_VAR_CRS_BLINKING_TIMER2L
		movff	WREG, BNKD_VAR_CRS_BLINKING_TIMER2H
			
	;; NOTICE:
	;; THE THE TIMER1+2 DRIVEN "BLINKING COUNTER" TRIGGERS THE CURSOR BLINKING PERIOD
	;; INC BLINKING COUNTER VALUE +1
	movff	BNKD_VAR_CRS_BLINKING_TRIGGER, MIOS_PARAMETER1
	incf	MIOS_PARAMETER1, F
	movff	MIOS_PARAMETER1, BNKD_VAR_CRS_BLINKING_TRIGGER
	
	;; -----------[CHK: BLINKING TRIGER < 100 ?  ]--------------------------
	;; BLINKING TRIGGER VALUE IS STILL IN MIOS_PARAMETER1
	movlw	0x64	; 100
	cpfslt	MIOS_PARAMETER1
		
		;; NO,
		;; -------[STATE: BLINKING TRIGER = OR > 100  ]---------------------
		;; -------[DO: EXIT HERE                      ]---------------------
		return
		
	;; YES,
	;; -------[STATE: BLINKING TRIGER < 100           ]---------------------
	;; Go on with blinking Routine
	;; -----------[CHK: BLINKING TRIGER = 0 ?         ]---------------------
	movlw	0x01	; 1
	cpfseq	MIOS_PARAMETER1

		;; NO,
		;; BLINKING TRIGER <> 1
		goto CHK_WRITE_CSR_ASC


		;; YES,
		;; BLINKING TRIGER =  1
		goto DO_DEL_CSR_ASC
		
		
CHK_WRITE_CSR_ASC
	;; ----------[CHK: DO WE HAVE TO WRITE THE CSR ASC VALUE AGAIN?]---------
	;; ADJUST THE TIME OF THE BLACK CSR PERIOD HERE
	;; A HIGER VALUE MEANS A LONGER BLACK CSR PERIOD
	;; 0x60 = MAX VALUE
	movlw	0x15	
	cpfseq	MIOS_PARAMETER1
		
		;; NO
		return
		
		;; YES
		;; -----[DO REWRITE CURRENT ASC CHAR @ CURRENT CSR POS   ]------------
		movff	VAR_CURSOR_BLINKING_POS, WREG
		call    MIOS_LCD_CursorSet
        movff	VAR_CURSOR_BLINKING_CSR_CHAR, WREG
        call    MIOS_LCD_PrintChar
		;; EXIT HERE
		return


DO_DEL_CSR_ASC
		;; ----[WRITE A "BLACK CRS"  @ CURRENT CSR POS          ]------------
		movff	VAR_CURSOR_BLINKING_POS, WREG
		call    MIOS_LCD_CursorSet
        movlw	0xFF	;; BLACK CSR
        call    MIOS_LCD_PrintChar
		;; EXIT HERE
		return
	

;; ---------------[DO: RESET CSR BLINKING TRIGGER]-------------------------------
DO_CSR_BLINKING_COUNTER_RESET
		;; ---[DO: RESET BLINKING CSR TIMER1            ]------------------------
		clrw	
		movff	WREG, BNKD_VAR_CRS_BLINKING_TIMER1L
		movff	WREG, BNKD_VAR_CRS_BLINKING_TIMER1H		
		
		;; ----[DO: RESET BLINKING CSR TIMER2           ]------------------------
		clrw	
		movff	WREG, BNKD_VAR_CRS_BLINKING_TIMER2L
		movff	WREG, BNKD_VAR_CRS_BLINKING_TIMER2H
		
		;; ----[DO: RESET BLINKING CSR TRIGGER          ]------------------------
		clrw
		movff	WREG, BNKD_VAR_CRS_BLINKING_TRIGGER
		;; EXIT HERE
		return

;; ---------------[DO: A SHORT CSR BLINKING SKIP ]-------------------------------
DO_CSR_BLINKING_COUNTER_INTERMISSION
		;; ---[DO: RESET BLINKING CSR TIMER1            ]------------------------
		clrw	
		movff	WREG, BNKD_VAR_CRS_BLINKING_TIMER1L
		movff	WREG, BNKD_VAR_CRS_BLINKING_TIMER1H		
		
		;; ----[DO: RESET BLINKING CSR TIMER2           ]------------------------
		clrw	
		movff	WREG, BNKD_VAR_CRS_BLINKING_TIMER2L
		movff	WREG, BNKD_VAR_CRS_BLINKING_TIMER2H
		
		;; ----[DO: SET BLINKING CSR TRIGGER TO 102     ]------------------------
		movlw	0x66	; 102
		movff	WREG, BNKD_VAR_CRS_BLINKING_TRIGGER
		;; EXIT HERE
		return