; MIDI DATA:
; ----------
; MIDI_EVNT0		= MIDI DATA BYTE 0 (1)	
; MIDI_EVNT1		= MIDI DATA BYTE 1 (2)
; MIDI_EVNT_VALUE	= MIDI DATA BYTE 2 (3)
;
; MIDI_CURRENT_EVNT_CHANNEL 	= MIDI CHANNEL (0-15 internal / 1-16 external)


LABEL_MIDI_HANDLING_START
	;; Write The MIDI EVENT to 
	;; MIDI_EVNT0, MIDI_EVNT1 AND MIDI_EVNT_VALUE
	
	;; STORE MIDI CHANNEL AND MIDI STATUS (MIDI EVENT TYPE) 
	movff	MIOS_PARAMETER1, MIDI_EVNT0 
	
	;; STORE MIDI DATA BYTE1 (0-127)
	movff	MIOS_PARAMETER2, MIDI_EVNT1
	
	;; STORE MIDI DATA BYTE2 (0-127)
	movff	MIOS_PARAMETER3, MIDI_EVNT_VALUE

	
	;; STORE MIDI EVENT CHANNEL 
	;; CHECK MIDI CHANNEL 0-15 (1-16)
	;; MIDI CH: BIT0-3 = MIDI_EVNT0 BIT0 to 3 (xxxxnnnn)
	;; MIDI CH = nnnn = 0-15 dec. (0x00 to 0x0F)
	;; Extract the MIDI CHANNEL
	movlw 0x0F 				;;  => BIN 00001111
  	andwf MIDI_EVNT0, W 	;; AND BIN 00001111 WITH VAR
  	;; NOW THE MIDI CH IS STORED IN WREG 
  	;; WRITE THE CURRENT MIDI CHANNEL TO MIDI CHANNEL VAR 
 	movwf MIDI_CURRENT_EVNT_CHANNEL 

 	
	
	;; MIDI EVENT HANDLING
	;; Branch depending on the MIDI EVENT
	;; THIS IS THE MIDI EVENT JUMP TABLE :-)
	SET_BSR	MIDI_EVNT0
	swapf	MIDI_EVNT0, W, BANKED
	andlw	0x07

	JUMPTABLE_4BYTES 8 ; 8 entries
		goto	MIDI_EVNT_IS_8x	; Note Off 			=> note_off.inc
		goto	MIDI_EVNT_IS_9x	; Note On			=> note_on.inc
		goto	MIDI_EVNT_IS_Ax	; Aftertouch		=> midi_evnt_handling.inc
		goto	MIDI_EVNT_IS_Bx	; Controller		=> midi_controller.inc
		goto	MIDI_EVNT_IS_Cx	; Program Change	=> midi_evnt_handling.inc
		goto	MIDI_EVNT_IS_Dx	; Channel Pressure	=> midi_evnt_handling.inc
		goto	MIDI_EVNT_IS_Ex	; Pitch Bend		=> midi_evnt_pitch_wheel.inc
		goto	MIDI_EVNT_IS_Fx	; not supported, 
				

;; ------[END OF MIDI EVENT FUNCTION]----
MIDI_EVNT_End

	return
	