;; function: initialisation of application variables etc. 

INIT_VARIABLES
;; JUMPED IN HERE FROM USER_Init (main.asm)

;; ---[INITIAL RESET ->> AY (YM) CHIP
;; ---[MBHP 4xDOUT PIN 31 (MBHP DOUTx4 J6 DO)
;; ---[NEEDED FOR SOME AY (YM) CHIPS FOR NOISE ENABLE
	;; NO RESET = +5V @ RESET PIN
	movlw HW_RESET_AY_CHIP	
	call MIOS_DOUT_PinSet1
	;; wait for exact 250 ms
    movlw       250
 	;; RESET = 0V @ RESET PIN
	movlw HW_RESET_AY_CHIP	;; See: app_defines.h
	call MIOS_DOUT_PinSet0
	; wait for exact 250 ms
    movlw       250
    call        MIOS_Delay
	;; NO RESET = +5V @ RESET PIN
	movlw HW_RESET_AY_CHIP	;; See: app_defines.h
	call MIOS_DOUT_PinSet1


;; -----------------------------------------------------------------
;;  SETTING THE AY 3 8912 (SHADOW) REGISTERS AFTER STARTUP
;;  Initialize the AY REGISTERS 0 to 14
;;  AND SETUP AY APPLICATION WORKING REGISTER
;;  Initialize the AY DOUT LED's CS
;; -----------------------------------------------------------------

;; =================================================================
;; -----------------------------------------------------------------
;; -----[SET AY 3 8912 REGISTERS TO STARTUP DEFAULT VALUES]--------- 
;; -----------------------------------------------------------------
; AY ADRESS 	=> VAR_AY_CHIP_REG_ADDRESS [8BIT, DEC. 0-16, HEX 0x00 - 0x10]
; AY DATA		=> VAR_AY_CHIP_REG_DATA	[8BIT, DEC. 0-255, HEX 0x00 - 0xFF]
	
	;; AY REG 0 - TONE PERIOD FINE CH A [TUNE LOW BYTE]
	movlw CONST_AY_CHIP_ADR_00_TONE_A_FREQUENCY_FINE  	; ADRESS => AY REGISTER
	movwf VAR_AY_CHIP_REG_ADDRESS 						; ADDRESS FOR => AY_SR_Write
	;; DEFINE AY REG DEFAULT VALUE HERE
	movlw INI_REG0_FINE_TUNE_A							; 8 BIT DATA FOR AY REG 0  
	movwf VAR_AY_CHIP_REG_DATA 							; FOR => AY_SR_Write (WRITE DATA TO AY REG)
		; WRITING 8BIT DATA (VAR_AY_CHIP_REG_ADDRESS, VAR_AY_CHIP_REG_DATA)TO AY REG(X) ROUTINE	
		call LABEL_AY_SR_Write	

	
	;; AY REG 1 - TONE PERIOD COASE CH A [4BIT]
	movlw CONST_AY_CHIP_ADR_01_TONE_A_FREQUENCY_PERIOD_COARSE	; ADRESS => AY REGISTER
	movwf VAR_AY_CHIP_REG_ADDRESS 							; ADDRESS FOR => AY_SR_Write
	;; DEFINE AY REG DEFAULT VALUE HERE
	movlw INI_REG1_COARSE_TUNE_A							; THE 4BIT VALUE OF THE AY REG DATA [0x00 - 0x0F]
	movwf VAR_AY_CHIP_REG_DATA 								; FOR => AY_SR_Write
		; WRITING 8BIT DATA (VAR_AY_CHIP_REG_ADDRESS, VAR_AY_CHIP_REG_DATA)TO AY REG(X) ROUTINE
		call LABEL_AY_SR_Write	


	;; AY REG 2 - TONE PERIOD FINE CH B [8BIT]
	movlw CONST_AY_CHIP_ADR_02_TONE_B_FREQUENCY_PERIOD_FINE	; ADRESS => AY REGISTER
	movwf VAR_AY_CHIP_REG_ADDRESS 						; ADDRESS FOR => AY_SR_Write
	;; DEFINE AY REG DEFAULT VALUE HERE
	movlw INI_REG2_FINE_TUNE_B							; 8 BIT DATA
	movwf VAR_AY_CHIP_REG_DATA 							; FOR => AY_SR_Write
		; WRITING 8BIT DATA (VAR_AY_CHIP_REG_ADDRESS, VAR_AY_CHIP_REG_DATA)TO AY REG(X) ROUTINE	
		call LABEL_AY_SR_Write	

		
	
	;; AY REG 3 - TONE PERIOD COASE CH B [4BIT]
	movlw CONST_AY_CHIP_ADR_03_TONE_B_FREQUENCY_PERIOD_COARSE	; ADRESS => AY REGISTER
	movwf VAR_AY_CHIP_REG_ADDRESS								; ADDRESS FOR => AY_SR_Write
	;; DEFINE AY REG DEFAULT VALUE HERE
	movlw INI_REG3_COARSE_TUNE_B						; 4 BIT DATA
	movwf VAR_AY_CHIP_REG_DATA 							; FOR => AY_SR_Write
		; WRITING 8BIT DATA (VAR_AY_CHIP_REG_ADDRESS, VAR_AY_CHIP_REG_DATA)TO AY REG(X) ROUTINE
		call LABEL_AY_SR_Write	


	;; AY REG 4 - TONE PERIOD FINE CH C [8BIT]
	movlw CONST_AY_CHIP_ADR_04_TONE_C_FREQUENCY_PERIOD_FINE	; ADRESS => AY REGISTER
	movwf VAR_AY_CHIP_REG_ADDRESS 						; ADDRESS FOR => AY_SR_Write
	;; DEFINE AY REG DEFAULT VALUE HERE
	movlw INI_REG4_FINE_TUNE_C							; 8 BIT DATA
	movwf VAR_AY_CHIP_REG_DATA 							; FOR => AY_SR_Write
		; WRITING 8BIT DATA (VAR_AY_CHIP_REG_ADDRESS, VAR_AY_CHIP_REG_DATA)TO AY REG(X) ROUTINE	
		call LABEL_AY_SR_Write	
		
	
	
	;; AY REG 5 - TONE PERIOD COASE CH C [4BIT]
	movlw CONST_AY_CHIP_ADR_05_TONE_C_TONE_PERIOD_COARSE		; ADRESS => AY REGISTER
	movwf VAR_AY_CHIP_REG_ADDRESS						; ADDRESS FOR => AY_SR_Write
	;; DEFINE AY REG DEFAULT VALUE HERE
	movlw INI_REG5_COARSE_TUNE_C						; 4 BIT DATA
	movwf VAR_AY_CHIP_REG_DATA 							; FOR => AY_SR_Write
		; WRITING 8BIT DATA (VAR_AY_CHIP_REG_ADDRESS, VAR_AY_CHIP_REG_DATA)TO AY REG(X) ROUTINE
		call LABEL_AY_SR_Write	
		

	;; AY REG 6 - NOISE PERIOD [5BIT]
	movlw CONST_AY_CHIP_ADR_06_NOISE_PERIOD					; ADRESS => AY REGISTER
	movwf VAR_AY_CHIP_REG_ADDRESS							; ADDRESS FOR => AY_SR_Write
	;; DEFINE AY REG DEFAULT VALUE HERE
	movlw INI_REG6_NOISE_PERIOD							; [0-31] 5 BIT DATA [BIN xxx1 1111]
	movwf VAR_AY_CHIP_REG6_NOISE_PERIOD					; WRITE => AY SHADOW REGISTER
	movwf VAR_AY_CHIP_REG_DATA 							; FOR => AY_SR_Write
		; WRITING 8BIT DATA (VAR_AY_CHIP_REG_ADDRESS, VAR_AY_CHIP_REG_DATA)TO AY REG(X) ROUTINE
		call LABEL_AY_SR_Write	
		


	;; AY REG 7
	;; TONE ABC ON/OFF
	;; MIX NOISE TO TONE ABC 
	;; [IO PORT A (+B): NOT IN USE YET] 
	movlw CONST_AY_CHIP_ADR_07_TONE_NOISE_ON_OFF		; REG 7 => AY ENABLE IOA, TONE CH ABC, NOISE ABC
												; SEE NOTES @ APP_DEFINES.H => AY_R7_ENABLE_ABC_NOISE_IO
	movwf VAR_AY_CHIP_REG_ADDRESS 				; ADDRESS FOR => AY_SR_Write

	movlw INI_REG7_TONE_ABC_NOISE_ABC_IO_AB			
	movwf VAR_AY_CHIP_REG7_ENABLE_ABC_NOISE_IO ; WRITE INI VALUE TO => AY SHADOW REGISTER 7

		;; TONE ABC is ON but there is NO MIDI NOTE On EVENT YET SO:
		;; MIDIFILTER ALL OFF
		movlw CONST_MIDI_FILTER_ALL_OFF_BIN_00111111		; BIN 00111111
		;; OR AY SHADOW REGISTER7 with MIDI FILTER VALUE [ALL OFF]
		iorwf VAR_AY_CHIP_REG7_ENABLE_ABC_NOISE_IO, W		; BIN 11111000 (AY_R7_ENABLE_ABC_NOISE_IO)
	  														; BIN 00111111	
	  														; =   11111111 ([TONE ABC OFF / NOISE ABC OFF])	
	;; WRITE REGISTER7 [with MIDI FILTER] to AY REGISTER7
	movwf VAR_AY_CHIP_REG_DATA 		; FOR => AY_SR_Write
		; WRITING 8BIT DATA (VAR_AY_CHIP_REG_ADDRESS, VAR_AY_CHIP_REG_DATA)TO AY REG(X) ROUTINE
		call LABEL_AY_SR_Write	
		

	;; AY REG 8 - THE VOLUME / AMPLITUDE OF THE CH. A SIGNAL
	movlw CONST_AY_CHIP_ADR_08_TONE_A_VOLUME_ENV_MODE_ON_OFF	; REG 8 
	movwf VAR_AY_CHIP_REG_ADDRESS 								; ADDRESS FOR => AY_SR_Write
	movlw INI_REG8_VOLUME_A_ENVELOPE_ON_OFF
	movwf VAR_AY_CHIP_REG8_CH_A_AMPLITUDE						; WRITE => AY SHADOW REGISTER 8
	movwf VAR_AY_CHIP_REG_DATA 									; FOR => AY_SR_Write
		; WRITING 8BIT DATA (VAR_AY_CHIP_REG_ADDRESS, VAR_AY_CHIP_REG_DATA)TO AY REG(X) ROUTINE
		call LABEL_AY_SR_Write	


	;; AY REG 9 - THE VOLUME / AMPLITUDE OF THE CH. B SIGNAL
	movlw CONST_AY_CHIP_ADR_09_TONE_B_VOLUME_ENV_MODE_ON_OFF	; REG 9 
	movwf VAR_AY_CHIP_REG_ADDRESS 								; ADDRESS FOR => AY_SR_Write
	movlw INI_REG9_VOLUME_B_ENVELOPE_ON_OFF
	movwf VAR_AY_CHIP_REG9_CH_B_AMPLITUDE						; WRITE => AY SHADOW REGISTER 9
	movwf VAR_AY_CHIP_REG_DATA 									; FOR => AY_SR_Write
		; WRITING 8BIT DATA (VAR_AY_CHIP_REG_ADDRESS, VAR_AY_CHIP_REG_DATA)TO AY REG(X) ROUTINE
		call LABEL_AY_SR_Write	


	;; AY REG 10 - THE VOLUME / AMPLITUDE OF THE CH. C SIGNAL
	movlw CONST_AY_CHIP_ADR_10_TONE_C_VOLUME_ENV_MODE_ON_OFF	; REG 10 
	movwf VAR_AY_CHIP_REG_ADDRESS 								; ADDRESS FOR => AY_SR_Write
	movlw INI_REG10_VOLUME_C_ENVELOPE_ON_OFF
	movwf VAR_AY_CHIP_REG10_CH_C_AMPLITUDE						; WRITE => AY SHADOW REGISTER 10
	movwf VAR_AY_CHIP_REG_DATA 									; FOR => AY_SR_Write
		; WRITING 8BIT DATA (VAR_AY_CHIP_REG_ADDRESS, VAR_AY_CHIP_REG_DATA)TO AY REG(X) ROUTINE
		call LABEL_AY_SR_Write	


	;; AY REG 11 - FREQUENCY OF THE ENVELOPE (FINE)
	movlw CONST_AY_CHIP_ADR_11_GLOBAL_ENVELOPE_FINE	; REG 11
	movwf VAR_AY_CHIP_REG_ADDRESS 					; ADDRESS FOR => AY_SR_Write
	;; DEFINE AY REG DEFAULT VALUE HERE
	movlw INI_REG11_ENVELOPE_FINE
	movwf VAR_AY_CHIP_REG11_ENV_PERIOD_FINE	; WRITE => AY SHADOW REGISTER 11
	movwf VAR_AY_CHIP_REG_DATA 						; FOR => AY_SR_Write
		; WRITING 8BIT DATA (VAR_AY_CHIP_REG_ADDRESS, VAR_AY_CHIP_REG_DATA)TO AY REG(X) ROUTINE
		call LABEL_AY_SR_Write	



	;; AY REG 12 - FREQUENCY OF THE ENVELOPE (COASE)
	movlw CONST_AY_CHIP_ADR_12_GLOBAL_ENVELOPE_COARSE 	; REG 12
	movwf VAR_AY_CHIP_REG_ADDRESS 						; ADDRESS FOR => AY_SR_Write
	;; DEFINE AY REG DEFAULT VALUE HERE
	movlw INI_REG12_ENVELOPE_COARSE
	movwf VAR_AY_CHIP_REG12_ENV_PERIOD_COARSE	; WRITE => AY SHADOW REGISTER 12
	movwf VAR_AY_CHIP_REG_DATA 							; FOR => AY_SR_Write
		; WRITING 8BIT DATA (VAR_AY_CHIP_REG_ADDRESS, VAR_AY_CHIP_REG_DATA)TO AY REG(X) ROUTINE
		call LABEL_AY_SR_Write	
	
	
	;; AY REG 13 - ENVELOPE SHAPE (+ENVELOPE CYCLE)
	;; IF "AMPLITUDE MODE" *BIT 5* IS SET @ TONE ABC
  	;; FOR DETAILS SEE AY-3-8912 DATASHEET
	movlw CONST_AY_CHIP_ADR_13_ENVELOPE_SHAPE_AND_CYCLE	; REG 13
	movwf VAR_AY_CHIP_REG_ADDRESS 						; ADDRESS FOR => AY_SR_Write
	;; DEFINE AY REG DEFAULT VALUE HERE
	movlw INI_REG13_ENVELOPE_SHAPE
	movwf VAR_AY_CHIP_REG13_ENV_SHAPE_CYCLE	; WRITE => AY SHADOW REGISTER 13
	movwf VAR_AY_CHIP_REG_DATA 						; FOR => AY_SR_Write
		; WRITING 8BIT DATA (VAR_AY_CHIP_REG_ADDRESS, VAR_AY_CHIP_REG_DATA)TO AY REG(X) ROUTINE
		call LABEL_AY_SR_Write	

	
	;; AY REG 14 - WRITE BIN '10101010' TO AY PORT A
	movlw CONST_AY_CHIP_ADR_14_IO_PORT_A_DATA			; REG 14 => AY PORT A ADRESS
	movwf VAR_AY_CHIP_REG_ADDRESS						; ADDRESS FOR => AY_SR_Write
	;; DEFINE AY REG DEFAULT VALUE HERE
	movlw INI_REG14_IO_A							; WRITE BIN '10101010' TO AY PORT A
	movwf VAR_AY_CHIP_REG_DATA 						; FOR => AY_SR_Write
	
		call LABEL_AY_SR_Write	

;; --------------------------------------------------------------------------
;; ==========================================================================


;; ==========================================================================
;; --------------------------------------------------------------------------
;;  SET ENVELOPE SHAPE
;;  Initialize the AY DOUT LED's
;; --------------------------------------------------------------------------
	
	call LED_ToneA_on
	call LED_ToneB_on
	call LED_ToneC_on
	
	;; ENVELOPE SHAPE	
	movlw 	INI_REG13_ENVELOPE_SHAPE
	movwf 	VAR_ENV_SHAPE_0_15_to_1_8_TRANSLATOR
	call 	LED_Envelope_Shape_1_on

;; --------------------------------------------------------------------------
;; ==========================================================================

;; ==========================================================================
;; --------------------------------------------------------------------------
;;  Initialize WORKING REGISTER
;; --------------------------------------------------------------------------
	
	;; START UP MENU = MENU 0
	movlw 	CONST_INI_START_UP_MAIN_MENU
	movwf	VAR_CURRENT_MAIN_MENU
	

	;; INITAL VALUES LCD MAIN MENU COURSER POSITION
	movlw 	INI_COURSER_POS	
	movff   WREG, BNKD_VAR_LCD_CURSOR_POS_MAIN_MENU_CHOICE_MENU	
	movff   WREG, BNKD_VAR_LCD_CURSOR_POS_MAIN_MENU_PATCH_INFO
	movff   WREG, BNKD_VAR_LCD_CURSOR_POS_MAIN_MENU_ABC_TUNE
	movff   WREG, BNKD_VAR_LCD_CURSOR_POS_MAIN_MENU_ABC_NOISE
	movff   WREG, BNKD_VAR_LCD_CURSOR_POS_MAIN_MENU_AMPLITUDE
	movff   WREG, BNKD_VAR_LCD_CURSOR_POS_MAIN_MENU_ENVELOPE
	movff   WREG, BNKD_VAR_LCD_CURSOR_POS_MAIN_MENU_MIDI_CONFIG
	movff   WREG, BNKD_VAR_LCD_CURSOR_POS_MAIN_MENU_VELOCITY_CONFIG
	movff 	WREG, BNKD_VAR_LCD_CURSOR_POS_MAIN_MENU_FX
	
	;; RESET COUNTER
	clrw	
	movff	WREG, BNKD_VAR_CRS_BLINKING_TIMER1L
	movff	WREG, BNKD_VAR_CRS_BLINKING_TIMER1H
	movff	WREG, BNKD_VAR_CRS_BLINKING_TIMER2L
	movff	WREG, BNKD_VAR_CRS_BLINKING_TIMER2H
	
	;; INI TUNE TONE ABC VALUES 
	movlw 	CONST_INI_TUNE_FINE_USER
	movwf 	VAR_TONE_A_TUNE_FINE_USER
	movwf  	VAR_TONE_B_TUNE_FINE_USER
	movwf 	VAR_TONE_C_TUNE_FINE_USER 
	
	movlw 	CONST_INI_TUNE_COARSE_USER
	movwf	VAR_TONE_A_TUNE_COARSE_USER
	movwf	VAR_TONE_B_TUNE_COARSE_USER
	movwf	VAR_TONE_C_TUNE_COARSE_USER
	
	movlw 	INI_TONE_A_MIDI_CHANNEL_USER
	movwf	MIDI_CHANNEL_TONE_A_USER
	
	movlw 	INI_TONE_B_MIDI_CHANNEL_USER
	movwf	MIDI_CHANNEL_TONE_B_USER
	
	movlw 	INI_TONE_C_MIDI_CHANNEL_USER
	movwf	MIDI_CHANNEL_TONE_C_USER

	;; MIDI SWITCH ABC TONE/NOISE ON OF
	movlw 	INI_MIDI_ALL_OFF	
			; INITIAL VALUE = BIN 00 111 111
			; AY REG 07     =     IO CBA CBA
			; 	    		=     BA
			; 	    		=        NOISE
			; 	    		=            TONE
	movwf   MIDI_TONE_ABC_ON_OFF
	
	;; THE USER SWITCH FOR TONE/NOISE ABC ON/OFF
	movlw INI_USER_TONE_ABC_NOISE_ABC_ON_OFF
	movwf VAR_TONE_NOISE_ABC_USER_ON_OFF_SWITCH 	
	
	;; VELOCITY TO TONE A C B AND NOISE RATE ON/OFF
	movlw INI_VELOCITY_TO_ACB_NOISE_PERIOD
	movwf VAR_VELOCITY_TO_ABC_NOISE_PERIOD_ON_OFF
	
	;; => midi_evnt_pipeline.inc
	clrf VAR_MIDI_VELOCITY_TO_AY_CHIP_VOLUME
	clrf VAR_MIDI_VELOCITY_TO_AY_CHIP_NOISE_PERIOD
	
	
	;; => user_tick_lcd_redraw.inc
	clrf VAR_MIDI_EVENT_CC_PB_MODWHEEL_FLAG
	
	
	;; -----------[PATCH DATA - BANKSTICK NR]---------------
	;; -----------------------------------------------------
	;; SET BANKSTICK [0 to 7]
	;; DEFAULT BANKSTICK = 1
	;; INTERNAL: 	BANKSTICK 1 = 0x00
	;; 				BANKSTICK 2 = 0x01
	;; 				...
	;; 				BANKSTICK 8 = 0x07
	;; 
	;; FUNCTION 	MIOS_BANKSTICK_CtrlSet
	;; DESCRIPTION 	sets the BankStick control register
	;; bit 2-0: selects the BankStick (1 of 8, address defined with pin A0-A2 of the EEPROM)
	;; bit 7: if set, the verify during BankStick write will be disabled
	movlw       CONST_SELECT_CONF_DEFAULT_BANKSTICK	;; SET DEFAULT BS @ app_defines.h
    call        MIOS_BANKSTICK_CtrlSet  			;; Do default Select BankStick via MIOS_BANKSTICK_CtrlSet
	;; ----------------------------------------------------
	
	;; -------[CLEAR / RESET PATCH NAME]-------------------
	call BLANK_PATCH_NAME

	
	;; POS1 PATCH NAME [POS1=0,...POS8=7]
	clrf 	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD
	movff 	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, BNKD_VAR_POS_CURSOR_PATCH_NAME
	
	;; PATCH NUMBER, STAE, ETC.
	clrf 	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD
	movff 	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, BNKD_VAR_CURRENT_PATCH_NR 				 ;; INITIAL PATCH NUMBER = 0 = INT (PIC EEPROM)
	movff 	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, BNKD_VAR_PATCH_STATE_FLAGS		 ;; See VAR_PATCH_MENU_STATE_FLAGS @ CONST DEF	
	movff	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, BNKD_VAR_FORMAT_BANKSTICK_CYCLE_COUNTER ;; See patch_write.inc 	
	
	;; USER: FX ABC off (See MAIN MENU 3 / Mixer)
	;; BIT0 = A (SET = ON / CLR = OFF)
	;; BIT1 = B (SET = ON / CLR = OFF)
	;; BIT2 = C (SET = ON / CLR = OFF)
	movlw INI_FX_USER_ON_OFF_ABC
	movwf VAR_TMP_RAM_BYTE_COPY_CLIPBOARD	
	movff VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, BNKD_VAR_FX_USER_ON_OFF_ABC
	
	
	;; RESET Fx
	clrf 	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD
	movff 	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, BNKD_VAR_Fx_MIDI_NOTE_ON_OR_OFF
	movff 	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, BNKD_VAR_FX_TIMER
	movff	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, BNKD_VAR_FX_FUNCTION_CURRENT
	movff 	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, BNKD_VAR_FX_DATA_CURRENT
	movff 	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, BNKD_VAR_FX_TIME_PRE_EXECUTION_CURRENT
	movff 	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, BNKD_VAR_FX_POS_CURRENT
	movff 	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, BNKD_VAR_STATE_FX_NOP_MODE
	movff 	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, VAR_POINTER_TO_CURRENT_FX_TAB_ENTRY
	movff 	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, VAR_FX_TAB_ENTRY_CURRENT_FUNCTION
	movff 	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, VAR_FX_TAB_ENTRY_CURRENT_TIME_PRE_EXECUTION
	
	;; user_tick_btn_auto_repeat.inc
	clrf 	VAR_BTN_SPECIAL_FLAGS
	clrf 	VAR_BTN_AUTO_REPEAT_GENERAL_COUNTER
	clrf	VAR_BTN_AUTO_REPEAT_COUNTER
	;; INI BTN STATE = DEPRESSED (NOT PRESSED)
	;; IS = PRESSED   (BTN STATE  = 0)
	;; IS = DEPRESSED (BTN STATE  = 1)
	movlw 	0x01
	movff	WREG, VAR_CURRENT_DIN_BTN_STATE	

	;; exit here
	return

;; ==============================================================================
;; ------------------------------------------------------------------------------
;; -------------------------[MIDI CONF.]-----------------------------------------


INIT_MIDI_CONF
	;; SET the MIDIbox AY Merger ON or OFF
	;; MEANS [MIDI DATA:IN] => [MIDI DATA:OUT]
	movlw 	INI_MIOS_MIDI_MERGER_ON_OFF
    call	MIOS_MIDI_MergerSet
	;; exit here
	    return


;; ==============================================================================
;; ------------------------------------------------------------------------------
;; ---------------------[TIMER0]-------------------------------------------------
INIT_TIMER0
;; JUMPED IN HERE FROM USER_Init

	 ;; TIMER0 is used as a MIDIBox AY Fx timer
	 ;; initialize (reset) timer0
	 
	 ;; ensure that timer0 interrupt not enabled!
	 ;; because the PIC based MIOS doesn't allow to add interrupt handlers 
     bcf     INTCON, T0IE

     ;; reset timer0 overflow (interrupt flag)
     bcf     INTCON, T0IF

    ;; ====[timer0 MEMO]======================================================
	;;  Bit 0 – 2     Timer prescale
	;;  Bit 3         Timer prescale assignment.  0=use prescal, 1=no prescale
	;;  Bit 4         Timer edge source (used only when counting)
	;;  Bit 5         Timer Source.  0=Internal, 1=Transitions on IO port 17
	;;  Bit 6         Timer mode.  0=16 bit mode, 1=8 bit mode
	;;  Bit 7         Timer On/Off.  0=Off, 1=On
	;;  ======================================================================
	;; -----------------------------------------
	;; SETUP timer0 for for MIDIBox AY Fx Option 
	;; ------------------------------------------
    ;; set to 16bit counter (BIT 6 = Clear), 
    ;; use internal clock source (BIT 5 = Clear), 
    ;; Ext. Clck adjust (Bit 4 = Clear) [nicht relevant, da int. Tacktquelle]
    ;; PSA (Vorteiler) BIT3 (= clear | Clear=on [slower] / SET=off [faster]) 
    ;; timer0 Prescaler [BIT 2,1,0]:
    ;; 000 = timer0/2 -> fast (this is what we need here :)
    ;; 001 = timer0/4
    ;; 010 = timer0/8
    ;; 011 = timer0/16
    ;; 100 = timer0/32
    ;; 101 = timer0/64
    ;; 110 = timer0/128
    ;; 111 = timer0/256 - slow
    movlw   B'00000000'
    movwf   T0CON

    ;; start timer0
    bsf     T0CON, TMR0ON		

	;; EXIT HERE
	return
;; ------------------------------------------------------------------------------

;; ==============================================================================
;; ------------------------------------------------------------------------------
INIT_USER_Timer
;; JUMPED IN HERE FROM USER_Init

	;; initialize the USER_Timer
	;; #########################
	;; The resolution of the timer is 100nS with Prescaler 1:1, 
	;; 200nS with 1:2, 
	;; 400nS with 1:4, 
	;; 800nS with 1:8. 
	;; The period (number of clocks) is specified as 16 bit value.
	;; prescaler value in WREG:
	;; 0x00: 1:1
	;; 0x01: 1:2
	;; 0x02: 1:4
	;; 0x03: 1:8
	;; number of ticks (low-byte)  in  MIOS_PARAMETER1
	;; number of ticks (high-byte) in  MIOS_PARAMETER2
	;; we want to setup the timer with a frequency of 500 Hz = 2 mS
	;; prescaler 1:1 should be used
	;; calculate the required number of clocks for this period:
	;; clocks = period / 100 nS = 2 mS / 100 nS = 20000
	;; calculate low and high byte:
	;; therefore:
	movlw        20000 & 0xff		;; BIN 00100000
	movwf        MIOS_PARAMETER1
	movlw        20000 >> 8			;; BIN 01001110
	movwf        MIOS_PARAMETER2
	movlw        0x00
	call  MIOS_TIMER_Init
	;; now the USER_Timer function is called every 2 mS!
	;; EXIT HERE
	return


;; ------------------------------------------------------------



BLANK_PATCH_NAME
;; -----------------------------------------------------------
;; ----------------[SUBROUTINE: BLANC PACH NAME]--------------
;; -----------------------------------------------------------
;; RESET PATCH NAME
;; WRITE ". . . . . . . ." 
;; FOR INITIAL "NO PATCH LOADED AND
;; FOR NEW FORMATTED BANKSTICK PATCH NAME
;; 8x PATCH KEY ASC
	movlw 	"."
	movwf 	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD
	movff 	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, BNKD_VAR_PATCH_NAME_ASC_0
	movff 	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, BNKD_VAR_PATCH_NAME_ASC_1
	movff 	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, BNKD_VAR_PATCH_NAME_ASC_2
	movff 	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, BNKD_VAR_PATCH_NAME_ASC_3
	movff 	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, BNKD_VAR_PATCH_NAME_ASC_4
	movff 	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, BNKD_VAR_PATCH_NAME_ASC_5
	movff 	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, BNKD_VAR_PATCH_NAME_ASC_6
	movff 	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, BNKD_VAR_PATCH_NAME_ASC_7
		
		;; exit here
		return


;; -----------------------------------------------------------
;; --------[SUBROUTINE: WRITE INITIAL PIC EEPROM ]------------
;; -----------------------------------------------------------
WRITE_PIC_EEPROM_PATCH_0_INI
	;; INI FUNCTION:
	;; CHECK IF INTERNAL PIC PATCH 0 WAS EVER BEEN WRITTEN
	;; IF NOT WRITE INTERNAL PATCH 0 (to PIC EEPROM)
	;; ---------------------------------------------------

	;; CHECK INTERNAL PATCH
	;; READ CURRENT PATCH FINGERPRINT (CURRENT PATCH = 0 AFTER START UP)
	call 	WRITE_FLAG_CURRENT_PATCH_FINGERPRINT
	
	;; CHECK
	;; PATCH 0 FINGERPRINT = SET = OKAY?
	movff	BNKD_VAR_PATCH_STATE_FLAGS, VAR_TMP_RAM_BYTE_COPY_CLIPBOARD
	btfsc	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, BIT1_CHECK_PATCH_FINGERPRINT 
		
				;; FINGERPRINT = SET
				;; INT PATCH 0 HAD BEEN WRITTEN OKAY
				;; EXIT HERE
				return

		;; NO FINGERPRINT @ INTERNAL PIC EEPROM (PATCH 0)!
		;; SO DO WRITE INTERNAL PATCH
		;; BUT FIRST SET Patch 0
		;; DEFALT ASC NAME to "IntPatch" 
		;; WRITE 8x PATCH KEY ASC
		movlw 	"I"
		movwf 	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD
		movff 	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, BNKD_VAR_PATCH_NAME_ASC_0
		movlw 	"n"
		movwf 	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD
		movff 	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, BNKD_VAR_PATCH_NAME_ASC_1
		movlw 	"t"
		movwf 	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD
		movff 	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, BNKD_VAR_PATCH_NAME_ASC_2
		movlw 	"P"
		movwf 	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD
		movff 	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, BNKD_VAR_PATCH_NAME_ASC_3
		movlw 	"a"
		movwf 	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD
		movff 	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, BNKD_VAR_PATCH_NAME_ASC_4
		movlw 	"t"
		movwf 	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD
		movff 	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, BNKD_VAR_PATCH_NAME_ASC_5
		movlw 	"c"
		movwf 	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD
		movff 	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, BNKD_VAR_PATCH_NAME_ASC_6
		movlw 	"h"
		movwf 	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD
		movff 	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, BNKD_VAR_PATCH_NAME_ASC_7
	

		;; WRITE DEFALT PATCH 
		;; TO PATCH 0 (=> PIC EEPROM PATCH)
		;; SEE: patch_write.inc
		goto	DO_STORE_PATCH_ON_PIC_EEPROM_OR_BANKSTICK
	
		;; RESET VAR_PATCH_MENU_STATE_FLAGS	
		clrf	BNKD_VAR_PATCH_STATE_FLAGS
		
		;; exit here
		return