;; FUNCTION:
;; NOTE OFF PROCESSING

;; A Note Off MIDI EVENT HAD BEEN RECEIVED
MIDI_EVNT_IS_8x	


MIDI_EVNT_IS_8x_CHECK_MIDI_CHANNEL_A

	;; -[DO: CHECK TONE A MIDI CHANNEL            ]----------------------------
	;; -[CHECK: CURRENT MIDI CH = TONE A MIDI CH? ]----------------------------
	movf 	MIDI_CURRENT_EVNT_CHANNEL, W
	cpfseq 	MIDI_CHANNEL_TONE_A_USER

		;; NO,
		;; ---[STATE: THERE IS NO NOTE OFF MIDI EVENT @ TONE A   ]------------
		;; ---[DO: GO AND CHK MIDI CH TONE B                     ]------------
		rgoto MIDI_EVNT_IS_8x_CHECK_MIDI_CHANNEL_B
		
	;; YES,
	;; ---[STATE: THERE IS A NOTE OFF MIDI EVENT @ TONE A   ]------------------
	;; ---[CHK: DO THE MIDI NOTE OFF MIDI EVENT correlate   ]------------------ 
	;; ---[     WITH THE LAST NOTE ON value @ TONE A?       ]------------------
	movf 	MIDI_EVNT1, W
	cpfseq 	MIDI_LAST_NOTE_ON_EVENT_VALUE_TONE_A
			;; current NOTE OFF value is < > CURRENT NOTE ON value
			;; so do nothing and exit here
			return

	;; ---[STATE: CURRENT NOTE OFF value = CURRENT NOTE ON value ]-------------
	;; ---[DO: *CLEAR* FX MIDI NOTE ON FLAG @ TONE A             ]-------------
	movff	BNKD_VAR_Fx_MIDI_NOTE_ON_OR_OFF, TMP1
	bcf 	TMP1, BIT0_TONE_A_ON_OFF
	movff	TMP1, BNKD_VAR_Fx_MIDI_NOTE_ON_OR_OFF
						
	;; ---[DO: CLR THE MIDI GATE PIN                             ]------------- 
	bcf AY_MIDI_NOTE_GATE_LAT, AY_MIDI_GATE_PIN_RD4_J14
	
	;; ---[DO SET TONE A VOLUME TO 0       ]-----------------------------------
	;;    BIT 0 - 3 VOLUME
	;; ---[DO SET TONE ENF MODE OFF        ]-----------------------------------
	;;    BIT 4 SET  = ENV ON
	;;    BIT 4 CLR  = ENV OFF
	;; SET REG8 to 0	
	movlw CONST_AY_CHIP_ADR_08_TONE_A_VOLUME_ENV_MODE_ON_OFF		; AY CHIP REG 8 
	movwf VAR_AY_CHIP_REG_ADDRESS 									; ADDRESS BYTE FOR => AY_SR_Write
	clrf 	TMP1
	movf	TMP1, W
	movwf 	VAR_AY_CHIP_REG_DATA 									; DATA BYTE FOR => AY_SR_Write
	; WRITING 8BIT DATA (VAR_AY_CHIP_REG_ADDRESS, VAR_AY_CHIP_REG_DATA)TO AY REG(X) ROUTINE
	call LABEL_AY_SR_Write	
	
	;; MIDI SWITCH TONE A NOISE A *OFF*
	;; CLEAR BIT0, BIT3
	;; => FILTER FOR REG 7
	;; => SWITCH OFF TONE A, NOISE A  
	bsf	MIDI_TONE_ABC_ON_OFF, BIT0_TONE_A_ON_OFF
	bsf	MIDI_TONE_ABC_ON_OFF, BIT3_NOISE_A_ON_OFF

	;; ---[LED: DO SET MIDI CH TONE A ACTIVITY = OFF
	;; ---[CS LED: MIDI CH TONE A ACTIVITY = OFF
	call LED_MIDI_CH_TONE_A_ACTIVITY_off
	;; ---[END OF TONE A MIDI NOTE OFF HANDLING
	;; ---[NEXT: CHECK TONE B MIDI NOTE OFF HANDLING
		

MIDI_EVNT_IS_8x_CHECK_MIDI_CHANNEL_B
	;; --[MIDI OFF EVENT: DO CHECK TONE B            ]----------------------------------------------------
	;; CHECK TONE B MIDI CHANNEL
	movf MIDI_CURRENT_EVNT_CHANNEL, W
	cpfseq MIDI_CHANNEL_TONE_B_USER

		;NO
		rgoto MIDI_EVNT_IS_8x_CHECK_MIDI_CHANNEL_C
		
	;; YES,
	;; ---[STATE: THE IS A NOTE OFF MIDI EVENT @ TONE B            ]------------
	;; ---[CHK: DO THE MIDI NOTE OFF VALUE correlate WITH THE LAST ]------------
	;;    [     NOTE ON value @ MIDI CH TONE B?                    ]------------
	movf 	MIDI_EVNT1, W
	cpfseq 	MIDI_LAST_NOTE_ON_EVENT_VALUE_TONE_B
			;; NO,
			;; current NOTE OFF value is <> CURRENT NOTE ON value
			;; so do nothing and exit here
		 	return
		
		;; YES,
		;; CURRENT NOTE OFF VALUE = CURRENT NOTE ON value
		;; *CLEAR* FX MIDI NOTE ON FLAG @ TONE B
		movff 	BNKD_VAR_Fx_MIDI_NOTE_ON_OR_OFF, TMP2
		bcf 	TMP2, BIT1_TONE_B_ON_OFF
		movff	TMP2, BNKD_VAR_Fx_MIDI_NOTE_ON_OR_OFF
		
	;; ---[DO SET TONE B VOLUME TO 0       ]-----------------------------------
	;;    BIT 0 - 3  = VOLUME
	;; ---[DO SET TONE ENF MODE OFF        ]-----------------------------------
	;;    BIT 4 SET  = ENV ON
	;;    BIT 4 CLR  = ENV OFF
	;; --[DO: SET REG9 to 0x00             ]-----------------------------------	
	movlw CONST_AY_CHIP_ADR_09_TONE_B_VOLUME_ENV_MODE_ON_OFF		; AY CHIP REG 8 
	movwf VAR_AY_CHIP_REG_ADDRESS 									; ADDRESS BYTE FOR => AY_SR_Write
	clrf 	TMP1
	movf	TMP1, W
	movwf 	VAR_AY_CHIP_REG_DATA 										; DATA BYTE FOR => AY_SR_Write
	; WRITING 8BIT DATA (VAR_AY_CHIP_REG_ADDRESS, VAR_AY_CHIP_REG_DATA)TO AY REG(X) ROUTINE
	call LABEL_AY_SR_Write	

MIDI_EVNT_IS_8x_SWITCH_OFF_TONE_B
	;; MIDI SWITCH TONE B NOISE B *OFF*
	;; CLEAR BIT1, BIT4
	;; => FILTER FOR REG 7
	;; => SWITCH OFF TONE B, NOISE B  
	bsf	MIDI_TONE_ABC_ON_OFF, BIT1_TONE_B_ON_OFF
	bsf	MIDI_TONE_ABC_ON_OFF, BIT4_NOISE_B_ON_OFF

	;; ---[LED: DO SET MIDI CH TONE B ACTIVITY = OFF
	;; ---[CS LED: MIDI CH TONE B ACTIVITY = OFF
	call LED_MIDI_CH_TONE_B_ACTIVITY_off
	;; ---[END OF TONE B MIDI NOTE OFF HANDLING
	;; ---[NEXT: CHECK TONE C MIDI NOTE OFF HANDLING


MIDI_EVNT_IS_8x_CHECK_MIDI_CHANNEL_C
	;; --[MIDI OFF EVENT: DO CHECK TONE C            ]----------------------------------------------------
	;; CHECK TONE C MIDI CHANNEL
	movf MIDI_CURRENT_EVNT_CHANNEL, W
	cpfseq MIDI_CHANNEL_TONE_C_USER

		;; NO,
		;; GO AND SEND DATA TO AY CHIP
		rgoto	MIDI_EVNT_IS_8x_SEND_NOTE_OFF_TO_AY_CHIP
		
	;; YES,
	;; NOTE OFF EVENT @ TONE C
	;; ---[CHK: DO THE MIDI NOTE OFF VALUE correlate WITH THE LAST ]------------
	;;    [     NOTE ON value @ MIDI CH TONE C?                    ]------------
	movf 	MIDI_EVNT1, W
	cpfseq 	MIDI_LAST_NOTE_ON_EVENT_VALUE_TONE_C
			;; NO,
			;; current NOTE OFF value is <> CURRENT NOTE ON value
			;; so do nothing and exit here
			return
		
		;; YES,
		;; current NOTE OFF value = CURRENT NOTE ON value
		;; *CLEAR* FX MIDI NOTE ON FLAG @ TONE C
		movff	BNKD_VAR_Fx_MIDI_NOTE_ON_OR_OFF, TMP3
		bcf 	TMP3, BIT2_TONE_C_ON_OFF
		movff	TMP3, BNKD_VAR_Fx_MIDI_NOTE_ON_OR_OFF 
		

	;; ---[DO SET TONE C VOLUME TO 0       ]-----------------------------------
	;;    BIT 0 - 3  = VOLUME
	;; ---[DO SET TONE ENF MODE OFF        ]-----------------------------------
	;;    BIT 4 SET  = ENV ON
	;;    BIT 4 CLR  = ENV OFF
	;; --[DO: SET REG10 to 0x00             ]-----------------------------------	
	movlw CONST_AY_CHIP_ADR_10_TONE_C_VOLUME_ENV_MODE_ON_OFF		; AY CHIP REG 10 
	movwf VAR_AY_CHIP_REG_ADDRESS 									; ADDRESS BYTE FOR => AY_SR_Write
	clrf 	TMP1
	movf	TMP1, W
	movwf 	VAR_AY_CHIP_REG_DATA 										; DATA BYTE FOR => AY_SR_Write
	; WRITING 8BIT DATA (VAR_AY_CHIP_REG_ADDRESS, VAR_AY_CHIP_REG_DATA)TO AY REG(X) ROUTINE
	call LABEL_AY_SR_Write	

MIDI_EVNT_IS_8x_SWITCH_OFF_TONE_C
	;; MIDI SWITCH TONE C NOISE C *OFF*
	;; CLEAR BIT2, BIT5
	;; => FILTER FOR REG 7
	;; => SWITCH OFF TONE C, NOISE C  
	bsf	MIDI_TONE_ABC_ON_OFF, BIT2_TONE_C_ON_OFF
	bsf	MIDI_TONE_ABC_ON_OFF, BIT5_NOISE_C_ON_OFF

	;; ---[LED: DO SET MIDI CH TONE C ACTIVITY = OFF
	;; ---[CS LED: MIDI CH TONE C ACTIVITY = OFF
	call LED_MIDI_CH_TONE_C_ACTIVITY_off
	;; ---[END OF TONE C MIDI NOTE OFF HANDLING


;; ----------------------------------------------------------------------------------
MIDI_EVNT_IS_8x_SEND_NOTE_OFF_TO_AY_CHIP
	;; ==============================================================================
	;; MIDIFILTER NOTE OFF @ AY REG 7
	;; SWITCH TONE  A|B|C OFF 
	;; SWITCH NOISE A|B|C OFF
	movlw 0xFF 	
	;; AND BIN 11111111
	;; WITH USER ON/OFF: TONE ABC / NOISE ABC 
	andwf VAR_TONE_NOISE_ABC_USER_ON_OFF_SWITCH, W 
	;; OR W-REG with TONE ABC MIDI ON/OFF
	iorwf MIDI_TONE_ABC_ON_OFF, W
	
	;; WRITE RESULT from W-REG TO AY REG7
	movwf VAR_AY_CHIP_REG_DATA 
	;; SEND DATA TO AY REG 7
	movlw CONST_AY_CHIP_ADR_07_TONE_NOISE_ON_OFF		; ADRESS => AY REGISTER
	movwf VAR_AY_CHIP_REG_ADDRESS 						; ADDRESS FOR => AY_SR_Write
	;; --------------[SEND DATA TO AY REG 7]------------------------------------------
	; WRITING 8BIT DATA (AY_REG_ADDRESS, AY_REG_DATA)TO AY REG(X) ROUTINE
	call LABEL_AY_SR_Write	
	;; ==============================================================================	
	
	;; Exit here
	return
	
	
; END - Note Off
