;; FUNCTION:
;; ---------
;; DO *NOTE ON* PROCESSING @ TONE B
;; 
;; DETAILS:
;; --------
;; THERE HAD BEEN B *NOTE ON* MIDI EVENT
;; JUMP IN HERE FROM ay_chip_note_on_to_hz_tab.inc
;; THE CURRENT MIDI NOTE ON TUNE WAS WRITTEN TO
;; * VAR_MIDI_TO_HZ_LOW_BYTE  (FINE TUNE VALUE)
;; * VAR_MIDI_TO_HZ_HIGH_BYTE (COARSE TUNE VALUE)
;;
;; 
;; PIPELINE WORKFLOW:
;; ------------------
;; * Check MIDI CH 
;; 
;; * CHECK / DO FX PROCESSING
;;
;; * CHECK / DO ENVELOPE HANDLING
;;
;; * CHECK / DO DETUNE (PITCH BEND) HANDLING
;;
;; * SEND TUNE TONE B to AY (YM) CHIP 
;;
;; * CHECK / DO TONE B VELOCITY / VOLUME HANDLING 
;;
;;
;; 	TONE A, B, C WORKFLOW
;; 	-------------------------------------
;; 	midi_evnt_note_on_pipeline_tone_a.inc
;; 			||
;;			\/
;;	midi_evnt_note_on_pipeline_tone_b.inc
;; 			||
;;			\/
;;	midi_evnt_note_on_pipeline_tone_c.inc
;;			||
;;			\/
;;	note_on_write_ay_reg7.inc
;;

;; ----------------------------------------------

;; -------------[START TONE B WORKFLOW]----------
;; ----------------------------------------------

MIDI_EVNT_NOTE_ON_CHECK_MIDI_CHANNEL_B
	;; CHECK IF NOTE ON EVENT = TONE B MIDI CHANNEL
 	;; IS MIDI EVENT MIDI CHANNEL = MIDI CHANNEL OF TONE B?
	movf 	MIDI_CURRENT_EVNT_CHANNEL, W
	cpfseq 	MIDI_CHANNEL_TONE_B_USER
			;NO - IT'S NOT MIDI CH TONE B
			goto MIDI_EVNT_NOTE_ON_CHECK_MIDI_CHANNEL_C
		
		;; YES
 		;; THERE IS A NOTE ON MIDI EVENT @ THE TONE B MIDI CHANNEL
		;; WRITE MIDI Hz VALUE to TUNE TONE B 
		;; WRITE MIDI Hz => TUNE TONE B 
		movff VAR_MIDI_TO_HZ_HIGH_BYTE, VAR_TONE_B_TUNE_COARSE_MIDI
		movff VAR_MIDI_TO_HZ_LOW_BYTE,  VAR_TONE_B_TUNE_FINE_MIDI

	;; ---[LED: DO SET MIDI CH TONE B ACTIVITY = ON
	;; CS LED: MIDI CH TONE B ACTIVITY = ON
	call LED_MIDI_CH_TONE_B_ACTIVITY_on
		
	;; NOTICE:
	;; @ AY REG7: BIT CLR = TONE/NOISE ABC ON 
	;; @ AY REG7: BIT SET = TONE/NOISE ABC OFF
	;; MIDI FILTER: SET TONE/NOISE B = ON = CLR MIDI FILTER TONE/NOISE B BIT 
	;; ---[STATE: MIDI EVENT MIDI CHANNEL = MIDI CHANNEL OF TONE B ]------------------		
	;; ---[DO: CLR BIT1_TONE_B_ON_OFF, CLR BIT4_NOISE_B_ON_OFF     ]------------------
	bcf	MIDI_TONE_ABC_ON_OFF, BIT1_TONE_B_ON_OFF
	bcf	MIDI_TONE_ABC_ON_OFF, BIT4_NOISE_B_ON_OFF
	
	;; SOME MIDI NOTE OFF HANDLING:
	;; STORE CURRENT *NOTE ON VALUE* @ MIDI_LAST_NOTE_ON_EVENT_VALUE_TONE_B
	;; FOR CHCKING if a FUTURE MIDI NOTE OFF value CORRELATES WITH THIS
	;; NOTE ON value.
	;; WE NEED THIS FOR A BETTER NOTE OFF HANDLING: 
	;; BECAUSE A FUTURE MIDI NOTE OFF EVENT VALUE 
	;; SHOULD HAVE THE SAME VALUE THAN THE CURRENT MIDI NOTE ON EVENT VALUE 
    movff     MIDI_EVNT1, MIDI_LAST_NOTE_ON_EVENT_VALUE_TONE_B


	;; CHECK IF FX B = ON or OFF
	movff	BNKD_VAR_FX_USER_ON_OFF_ABC, VAR_TMP_RAM_BYTE_COPY_CLIPBOARD
	btfss  	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, BIT1_FX_ON_OFF_TONE_B
			;; NO, BIT1 IS NOT SET - Fx @ TONE B = off
			;; DO NOT PERFORM Fx Note On Routines
			rgoto  MIDI_EVNT_NOTE_ON_TONE_B_CHCK_ENVELOPE_MODE
		
		;; YES - DO Fx Note On Routines 
		;; Save the last 3 Note Values
		call 	WRITE_FX_TUNE_1_2_3	
		
		;; SET FX MIDI *NOTE ON* FLAG @ TONE B
		movff	BNKD_VAR_Fx_MIDI_NOTE_ON_OR_OFF, VAR_TMP_RAM_BYTE_COPY_CLIPBOARD
		bsf 	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, BIT1_TONE_B_ON_OFF
		movff	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, BNKD_VAR_Fx_MIDI_NOTE_ON_OR_OFF
		
		;; CHANGE (inc) THE FX SESSION (WILL RESET FX POS)
		movff	BNKD_VAR_FX_MIDI_NOTE_ON_SESSION, VAR_TMP_RAM_BYTE_COPY_CLIPBOARD
		incf 	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, F
		movff	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, BNKD_VAR_FX_MIDI_NOTE_ON_SESSION
		;; ######################################################


MIDI_EVNT_NOTE_ON_TONE_B_CHCK_ENVELOPE_MODE
		;; -------------[ENVELOPE MODE?]------------------------
		;; CHECK: IS ENVELOPE MODE @ TONE B ON?
		;; BIT 4 SET 	= ENV. MODE ON
		;; BIT 4 CLEAT 	= ENV. MODE OFF
		btfsc VAR_AY_CHIP_REG9_CH_B_AMPLITUDE, BIT4_ENVELOPE_ON_OFF
        		;; YES - BIT 4 is SET - ENV. MODE ON
        		;; GOTO WRITE ENV REG AY CHIP
        		rgoto MIDI_EVNT_NOTE_ON_MIDI_CHANNEL_TONE_B_ENV_MODE
			;; NO - BIT 4 is CLEAR - ENV. MODE OFF
			;; NO NEED FOR WRITING AY REG 13
			rgoto MIDI_EVNT_NOTE_ON_CHECK_DETUNE_B
	
MIDI_EVNT_NOTE_ON_MIDI_CHANNEL_TONE_B_ENV_MODE
	;; TO DO WRITE ENV TIME (COARSE & FINE)
	;; PREPARE ITEM DATA FOR TRANSFERE TO AY CHIP VIA ay_sr.inc
	;; --------------------------------------------------------
	;; WRITE AY REG *ADRESS* TO VAR_AY_CHIP_REG_ADDRESS FOR => AY_SR_Write
	movlw CONST_AY_CHIP_ADR_12_GLOBAL_ENVELOPE_COARSE 	; ADRESS FOR	=> AY REGISTER
	movwf VAR_AY_CHIP_REG_ADDRESS 						; ADDRESS FOR 	=> AY_SR_Write
	;; WRITE AY REG *DATA* TO VAR_AY_CHIP_REG_DATA FOR => AY_SR_Write
	movff VAR_AY_CHIP_REG12_ENV_PERIOD_COARSE, VAR_AY_CHIP_REG_DATA 
	;; WRITING 8BIT DATA (VAR_AY_CHIP_REG_ADDRESS, VAR_AY_CHIP_REG_DATA)TO AY REG(X) ROUTINE
	call LABEL_AY_SR_Write
	;; PREPARE ITEM DATA FOR TRANSFERE TO AY CHIP VIA ay_sr.inc
	;; --------------------------------------------------------
	;; WRITE AY REG *ADRESS* TO VAR_AY_CHIP_REG_ADDRESS FOR => AY_SR_Write
	movlw CONST_AY_CHIP_ADR_11_GLOBAL_ENVELOPE_FINE 	; ADRESS => AY REGISTER
	movwf VAR_AY_CHIP_REG_ADDRESS 						; ADDRESS FOR => AY_SR_Write
	;; WRITE AY REG *DATA* TO VAR_AY_CHIP_REG_DATA FOR => AY_SR_Write
	movff VAR_AY_CHIP_REG11_ENV_PERIOD_FINE, VAR_AY_CHIP_REG_DATA 
	;; WRITING 8BIT DATA (VAR_AY_CHIP_REG_ADDRESS, VAR_AY_CHIP_REG_DATA)TO AY REG(X) ROUTINE
	;; @ay_sr.inc
	call LABEL_AY_SR_Write

	;; -------------[WRITE ENVELOPE SHAPE/CYCLE - ENVELOPE MODE TONE B ON]------------------
	;; SEND DATA TO AY REG 13 (ENV. SHAPE Cycle REG)
	;; SET AY REGISTER
	movlw  CONST_AY_CHIP_ADR_13_ENVELOPE_SHAPE_AND_CYCLE	
	movwf  VAR_AY_CHIP_REG_ADDRESS 		
        ;; WRITE GLOBAL [A|B|C] ENVELOPE SHAPE DATA TO AY CHIP
        movff  VAR_AY_CHIP_REG13_ENV_SHAPE_CYCLE, VAR_AY_CHIP_REG_DATA
	;; --------------[SEND DATA TO AY REG 13]-----------------------------------------------------
	call LABEL_AY_SR_Write	; WRITING 8BIT DATA (VAR_AY_CHIP_REG_ADDRESS, VAR_AY_CHIP_REG_DATA)TO AY REG(X) ROUTINE
	;; ==========================================================================================


	;; -------------[DETUNE B]------------------
MIDI_EVNT_NOTE_ON_CHECK_DETUNE_B


;; -------------[CHECK DETUNE B (PITCH BEND)]------------------------

;; * CHECK DETUNE (PITCH BEND)
;; 	* Coarse
;; 	* Fine 



;; -------------[NOW CHECK B COARSE DETUNE]----------------------
MIDI_EVNT_NOTE_ON_CHECK_TONE_B_COARSE_DETUNE
	;;CHECK USER COARSE DETUNE
	;:USER COARSE RANGE:
	;;(-)RANGE = [0 to 6]|OFFSET/ZERO = [7]| (+)RANGE = [8 to 15]
	;;
	;; AY_TONE_A_TUNE_COARSE_USER | COARSE TUNE
	;; ...
	;; 3 ========================>| -4
	;; 4 ========================>| -3
	;; 5 ========================>| -2
	;; 6 ========================>| -1
	;; 7 ========================>|  0
	;; 8 ========================>| +1
	;; 9 ========================>| +2
	
	;; IS USER COARSE TUNE = [7] ?
	movlw	OFFSET_COARSE_TUNE_IS_7
	cpfseq 	VAR_TONE_B_TUNE_COARSE_USER	
		;; NO - NOT 7, SO COARSE DETUNE IS GIVEN
		rgoto MIDI_EVNT_NOTE_ON_TONE_B_CHECK_COARSE_DETUNE_PLUS_OR_MINUS
		;; YES 7, SO NO COASE DETUNE IS GIVEN
		;; GO ON WITH DETUNE FINE
		rgoto 	MIDI_EVNT_NOTE_ON_CHECK_TONE_B_DETUNE_FINE


MIDI_EVNT_NOTE_ON_TONE_B_CHECK_COARSE_DETUNE_PLUS_OR_MINUS
	;; CHECK COARSE DETUNE = (+) or (-)
	;; COARSE TUNE IS <> 7 SO COARSE REG DETUNE
	;; IS GIVEN @ TONE B
	;; RANGE (-) = [0-6] |(No DETUNE) = [7] | (+) = [8-15]
	movlw	PROOF_POSITIVE_OR_NEGATIVE_VIA_0X06
	;; TONE B COASE TUNE > 6? (CHECK TUNE + OR -) 
	cpfsgt 	VAR_TONE_B_TUNE_COARSE_USER	
			;; NO
			;; SO COARSE DETUNE = (-) = RANGE [0 to 6]
			rgoto  MIDI_EVNT_NOTE_ON_TONE_B_COARSE_DETUNE_IS_MINUS
			;; YES
			;; SO COARSE DETUNE = (+) = RANGE [8 to 15]
			rgoto MIDI_EVNT_NOTE_ON_TONE_B_COARSE_DETUNE_IS_PLUS
			
MIDI_EVNT_NOTE_ON_TONE_B_COARSE_DETUNE_IS_MINUS
	;; DETUNE COARSE IS NEGATIVE
	;; -------------------------
	;; calculate COARSE DETUNE (-) VALUE:
	;; WREG [(0x07 (+1 [PLUS_1_CARRY_BIT_KILLER])] - F [(0x00 to 0x06)| (+1 Carry BIT (of subfwb))] 
	;; WRITE RESULT TO => [WREG (0x07 to 0x01)]
	;; TO GET THE (-) COARSE TUNE RESULT [RANGE: 0x07 to 0x01]
	
	
	;; (1) MOVE OFFSET TO WREG and
	;; (3)Subtract f from WREG 
	;; the CARRY bit will allway be set
	;; because WREG is (allways in this case) > f) 
	;; (2) SO WE NEED TO ADD +1 TO WREG
	;; for [+1 WREG] - [+1 Carry BIT] = 0 (the needed offset)
	movlw	OFFSET_COARSE_TUNE_IS_7 ;; (1)
	addlw 	PLUS_1_CARRY_BIT_KILLER ;; (2)
	subfwb	VAR_TONE_B_TUNE_COARSE_USER, W ;; (3)
	
	;; ADD (*) COARSE MINUS DETUNE [WREG (RANGE 0x01 to 0x07)] 
	;; TO THE COARSE "NOTE ON VALUE" 
	;; DON'T BE CONFUSED (*):
	;; DETUNE NEGATIVE => LOWER  FREQ = HIGHER TUNE REG VALUE
	;; DETUNE ADDITIVE => HIGHER FREQ = LOWER TUNE REG VALUE
	addwf	VAR_TONE_B_TUNE_COARSE_MIDI, F
	
	
	;; TONE B COASE TUNE > BIN 00001111? 
	movlw	CONST_NIBBLE_B00001111
	cpfsgt 	VAR_TONE_B_TUNE_COARSE_MIDI	

		;; NO - ALL RIGHT GO ON 	
		;; GO AND CHECK DETUNE FINE
		goto 	MIDI_EVNT_NOTE_ON_CHECK_TONE_B_DETUNE_FINE

			;; YES - COASE TUNE REG VALUE IS > 0x0F NO VALID VALUE FOR THE AY CHIP!
			;; SWITCH TUNE COARSE REG TO 0x0F
			;; GO AND WRITE MAXIMUM VALUE TO COARSE and FINE REG
			rgoto 	MIDI_EVNT_NOTE_ON_DETUNE_NEGATIVE_SET_COARSE_TUNE_B_TO_MAX_VALUE


MIDI_EVNT_NOTE_ON_DETUNE_NEGATIVE_SET_COARSE_TUNE_B_TO_MAX_VALUE
				;; WRITE MAXIMUM VALUE TO COARSE and FINE REG
				movlw CONST_COARSE_TUNE_MAX_VALUE_B00001111
				movwf VAR_TONE_B_TUNE_COARSE_MIDI
				movlw CONST_FINE_TUNE_MAX_VALUE_B11010010
				movwf VAR_TONE_B_TUNE_FINE_MIDI
		
		    			;; GO AND CHECK DETUNE FINE
					goto 	MIDI_EVNT_NOTE_ON_CHECK_TONE_B_DETUNE_FINE

;; -------------------[TONE B COARSE DETUNE]----------------------------

MIDI_EVNT_NOTE_ON_TONE_B_COARSE_DETUNE_IS_PLUS
	;; DETUNE IS ADDITIVE
	;; (+) RANGE COARSE USER [0x08 to 0x0F]
	movlw	OFFSET_COARSE_TUNE_IS_7
	subwf	VAR_TONE_B_TUNE_COARSE_USER, W		; - 0x07 (OFFSET IN W REG)
	movwf	VAR_AY_DETUNE_TEMP					; SAVE (+) COARSE DETUNE VALUE
	
	;; NOW COARSE DETUNE IS IN WREG
	;; (+) COARSE DETUNE RANGE => [0x01 to 0x08]		
	;; COMPARE W REG WITH COARSE TUNE MIDI VALUE
	;; IS THE COASE MIDI VALUE > COASE DETUNE VALUE IN W REG
	;; NEXT STEP: SUBTRACT [(+) DETUNE COARSE] FROM [MIDI COARSE TUNE]
	;; BUT FIRST WE MUST CHECK IF THERE WILL BE A VALID VALUE
	;; COMPARE WREG [(+) DETUNE COARSE] WITH [COARSE TUNE MIDI] 
	;; IS (F) [MIDI COARSE TUNE] > (W) [(+) DETUNE COARSE]?	
	cpfsgt 	VAR_TONE_B_TUNE_COARSE_MIDI
		;; IS (F) [MIDI COARSE TUNE] > (W) [(+) DETUNE COARSE]?
		;; NO - SO SET TUNE REGS TO HIGHEST FREQUENCY POSSIBLE
		rgoto 	MIDI_EVNT_NOTE_ON_SET_MIDI_TUNE_B_TO_MIN_VALUE_IS_HIGHEST_TUNE
		;; IS (F) [MIDI COARSE TUNE] > (W) [(+) DETUNE COARSE]?
		;; YES - OK GO ON
		rgoto 	MIDI_EVNT_NOTE_ON_TONE_B_COASE_DETUNE_ADDITIVE_GO_ON


MIDI_EVNT_NOTE_ON_SET_MIDI_TUNE_B_TO_MIN_VALUE_IS_HIGHEST_TUNE
			;; SET TUNE REGS TO HIGHEST FREQUENCY POSSIBLE
			;; THAT MEANS TO SET TUNE REGS TO MIN. VALUE
			;; MIN VALUE = HIGHEST TUNE
			movlw  CONST_COARSE_TUNE_MIN_VALUE_B00000000
			movwf  VAR_TONE_B_TUNE_COARSE_MIDI
			movlw  CONST_FINE_TUNE_MIN_VALUE_B00001010
			movwf  VAR_TONE_B_TUNE_FINE_MIDI
					;; GO ON WITH DETUNE FINE
					rgoto 	MIDI_EVNT_NOTE_ON_CHECK_TONE_B_DETUNE_FINE

MIDI_EVNT_NOTE_ON_TONE_B_COASE_DETUNE_ADDITIVE_GO_ON
			;; ADD USER COASE DETUNE TO FREQUENCY VALUE NOW
			;; THIS MEANS TO SUBTRACT COASE DETUNE VALUE from "NOTE ON" MIDI VALUE 
			;; YES THE ADDITIVE VALUE WILL BE SUBTRACTED (DON'T BE CONFUSED;)
			;; TUNE FREQUENCY "+" = "-" @ TUNE REGISTER
			movf 	VAR_AY_DETUNE_TEMP, W
			subwf	VAR_TONE_B_TUNE_COARSE_MIDI, F
					;; GO ON WITH DETUNE FINE
					rgoto 	MIDI_EVNT_NOTE_ON_CHECK_TONE_B_DETUNE_FINE


;; -------------[END OF DETUNE TONE COASE B ]--------------	

;; ----------------[CHECK DETUNE FINE]--------------------------------------
MIDI_EVNT_NOTE_ON_CHECK_TONE_B_DETUNE_FINE
	;;CHECK USER DETUNE [FINE]
	movlw	OFFSET_FINE_TUNE_IS_128
	;; TONE B FINE TUNE = 128? 
	;; 128 = INITIAL VALUE = NO USER DETUNE
	cpfseq 	VAR_TONE_B_TUNE_FINE_USER 	

			;; NO == NOT 128 - SO *DETUNE IS GIVEN*
			rgoto MIDI_EVNT_NOTE_ON_CHECK_TONE_B_FINE_DETUNE_MINUS_OR_PLUS

			;; YES == *NO FINE DETUNE IS GIVEN*
			;; GO ON - WRITE TUNE TONE B
			rgoto MIDI_EVNT_NOTE_ON_TONE_B_SEND_TUNE_TO_AY_CHIP


MIDI_EVNT_NOTE_ON_CHECK_TONE_B_FINE_DETUNE_MINUS_OR_PLUS
	
	movlw	PROOF_POSITIVE_OR_NEGATIVE_VIA_0X7F
	;; TONE B FINE TUNE > 127? 
	;; (CHECK IF USER DETUNE IS + OR -) 
	cpfsgt 	VAR_TONE_B_TUNE_FINE_USER	

			;; NO == USER FINE DETUNE (-)
			rgoto MIDI_EVNT_NOTE_ON_TONE_B_FINE_DETUNE_MINUS
			
			;; YES == USER FINE DETUNE (+)
			rgoto MIDI_EVNT_NOTE_ON_TONE_B_FINE_DETUNE_PLUS


MIDI_EVNT_NOTE_ON_TONE_B_FINE_DETUNE_MINUS	
;; DETUNE IS NEGATIVE (-) == LOWER FREQUENZY
	;; (+) RANGE OF: AY_TONE_A_TUNE_FINE_USER = [129 to 255] DETUNE IS POSITIVE (HERE)
	;; (-) RANGE OF: AY_TONE_A_TUNE_FINE_USER = [0   to 127] DETUNE IS NEGATIVE 
	;; (NO DETUNE) : AY_TONE_A_TUNE_FINE_USER = [128]
	
	;; WRITE 128 TO WREG
	;; WREG [(128) + (1 (CARRY KILLER))] - [[AY_TONE_A_TUNE_FINE_USER |(0 to 127)] + [+1 (CARRY)]]
	;; WRITE RESULT TO => [WREG]
	movlw	OFFSET_FINE_TUNE_IS_128
	addlw 	PLUS_1_CARRY_BIT_KILLER
	subfwb	VAR_TONE_B_TUNE_FINE_USER, W 
	;; WRITE RESULT TO [WREG] TO => [VAR_AY_DETUNE_TEMP]
	movwf	VAR_AY_DETUNE_TEMP
	
	;; So the [USER DETUNE RANGE] => [-1 to -128] 
	;; Expand the (-) RANGE to 8BIT (255):
	;; 2x (-1 to -128) => (-2 to -256(!))
	addwf	VAR_AY_DETUNE_TEMP, F
	;; -1 | => (1 to 255)
	decf	VAR_AY_DETUNE_TEMP, F
	;; WRITE [(-) DETUNE FINE] TO [WREG]
	;; (-) RANGE => [1 to 255]
	

;; ------[DETUNE NEGATIVE RATIO CHANGE?]------------------

	;; CHECK IF WE NEED TO CHANGE THE PITCH BEND RATIO
	;; CHECK IF MIDI TUNE COARSE REG > 3 
	;; 4 to 15 => NO RATIO CHANGE
	movlw	0x03	 
	cpfsgt 	VAR_TONE_B_TUNE_COARSE_MIDI	

			;; NO [MIDI TUNE COARSE REG = 0 to 3]
			;; THERE MUST BE A PITCH BEND RATIO CONVERSATION
			rgoto MIDI_EVNT_NOTE_ON_TONE_B_FINE_DETUNE_NEGATIVE_RATIO_CHANGE
			
			;; YES [MIDI TUNE COARSE REG > 3]
			;; THERE MUST BE *NO* PITCH BEND RATIO CHANGE
			rgoto MIDI_EVNT_NOTE_ON_TONE_B_FINE_DETUNE_NEGATIVE_GO_ON	

MIDI_EVNT_NOTE_ON_TONE_B_FINE_DETUNE_NEGATIVE_RATIO_CHANGE
	;; 0) PITCH BEND /16 ==> IF MIDI TUNE COARSE REG == 0
	;; 1) PITCH BEND / 8 ==> IF MIDI TUNE COARSE REG == 1
	;; 2) PITCH BEND / 4 ==> IF MIDI TUNE COARSE REG == 2
	;; 3) PITCH BEND / 2 ==> IF MIDI TUNE COARSE REG == 3
	movf VAR_TONE_B_TUNE_COARSE_MIDI, W
	JUMPTABLE_2BYTES 4
		rgoto        MIDI_EVNT_NOTE_ON_TONE_B_FINE_DETUNE_NEGATIVE_RATIO_CHANGE_DIVIDE_16x 	;; 0  ==> PITCH BAND VALUE /16
		rgoto        MIDI_EVNT_NOTE_ON_TONE_B_FINE_DETUNE_NEGATIVE_RATIO_CHANGE_DIVIDE_8x 	;; 1  ==> PITCH BAND VALUE /8
		rgoto        MIDI_EVNT_NOTE_ON_TONE_B_FINE_DETUNE_NEGATIVE_RATIO_CHANGE_DIVIDE_4x 	;; 2  ==> PITCH BAND VALUE /4
		rgoto        MIDI_EVNT_NOTE_ON_TONE_B_FINE_DETUNE_NEGATIVE_RATIO_CHANGE_DIVIDE_2x 	;; 3  ==> PITCH BAND VALUE /2
	
;; ADJUST PITCH BEND RATIO
;; JUMP IN HERE = PITCH BAND /16
MIDI_EVNT_NOTE_ON_TONE_B_FINE_DETUNE_NEGATIVE_RATIO_CHANGE_DIVIDE_16x
		rrncf	VAR_AY_DETUNE_TEMP, F
		bcf	VAR_AY_DETUNE_TEMP, 7
;; JUMP IN HERE = PITCH BAND /8
MIDI_EVNT_NOTE_ON_TONE_B_FINE_DETUNE_NEGATIVE_RATIO_CHANGE_DIVIDE_8x
		rrncf	VAR_AY_DETUNE_TEMP, F
		bcf	VAR_AY_DETUNE_TEMP, 7
;; JUMP IN HERE = PITCH BAND /4
MIDI_EVNT_NOTE_ON_TONE_B_FINE_DETUNE_NEGATIVE_RATIO_CHANGE_DIVIDE_4x
		rrncf	VAR_AY_DETUNE_TEMP, F
		bcf	VAR_AY_DETUNE_TEMP, 7
;; JUMP IN HERE = PITCH BAND /2
MIDI_EVNT_NOTE_ON_TONE_B_FINE_DETUNE_NEGATIVE_RATIO_CHANGE_DIVIDE_2x
		rrncf	VAR_AY_DETUNE_TEMP, F
		bcf	VAR_AY_DETUNE_TEMP, 7
	
;; ------[DETUNE RATIO CHANGE END]------------------

MIDI_EVNT_NOTE_ON_TONE_B_FINE_DETUNE_NEGATIVE_GO_ON	
	;; >> ADD (-) DETUNE to "NOTE ON" VALUE <<
	;; DON'T BE CONFUSED: 
	;; DETUNE NEGATIVE => LOWER  FREQ = HIGHER TUNE REG VALUE
	;; DETUNE ADDITIVE => HIGHER FREQ = LOWER TUNE REG VALUE
	clrc	;; CLEAR CARRY BIT
	movf	VAR_AY_DETUNE_TEMP, W
	addwf 	VAR_TONE_B_TUNE_FINE_MIDI, F
	
	    ;;  carry flag is set when an instruction overflows f.
	    ;;  branch if carry for INC the 4 BIT COARSE TUNE B REG
 	    bc MIDI_EVNT_NOTE_ON_FINE_DETUNE_NEGATIVE_REG_OVERFLOW_COARSE_REG_B_INC
			;; OK, QUIT HERE
			;; GO ON - WRITE TUNE TONE B
			rgoto MIDI_EVNT_NOTE_ON_TONE_B_SEND_TUNE_TO_AY_CHIP

MIDI_EVNT_NOTE_ON_FINE_DETUNE_NEGATIVE_REG_OVERFLOW_COARSE_REG_B_INC
	;; THE CARRY FLAG HAS BEEN SET (OVERFLOW OF FINE TUNE REG)
	;; CHECK MIDI COASE REG = 0x0F ? 
	;; IS COARSE TUNE REG > BIN xxxx1110 ? => 14 (15 = higest Value) 
	movlw	CONST_COARSE_TUNE_MAX_MINUS_1_B00001110
	cpfsgt 	VAR_TONE_B_TUNE_COARSE_MIDI	
			;; NO - COARSE REG TUNE RANGE IS [0 to 14]
			;; OK SO COASE REG IS VALID
			rgoto MIDI_EVNT_NOTE_ON_CARRY_COARSE_REG_B_INC

			;; YES - NO INC OF COARSE REG POSSIBLE
			;; WRITE MAXIMUM VALUE TO COARSE and FINE REG. 
			rgoto MIDI_EVNT_NOTE_ON_WRITE_MAXIMUM_VALUE_TO_FINE_AND_COARSE_REG_B


MIDI_EVNT_NOTE_ON_CARRY_COARSE_REG_B_INC	
	;; INC PITCH CARRY FROM FINE-TUNE REG 
	;; +1 to COASE TUNE REG 
	incf VAR_TONE_B_TUNE_COARSE_MIDI, F
	
		  		;; GO ON - WRITE TUNE TONE B
				rgoto MIDI_EVNT_NOTE_ON_TONE_B_SEND_TUNE_TO_AY_CHIP

MIDI_EVNT_NOTE_ON_WRITE_MAXIMUM_VALUE_TO_FINE_AND_COARSE_REG_B
	;; WRITE MAXIMUM VALUE TO COARSE and FINE REG
	movlw  CONST_COARSE_TUNE_MAX_VALUE_B00001111
	movwf  VAR_TONE_B_TUNE_COARSE_MIDI
	movlw  CONST_FINE_TUNE_MAX_VALUE_B11010010
	movwf  VAR_TONE_B_TUNE_FINE_MIDI
	
		 		;; GO ON - WRITE TUNE TONE B
				rgoto MIDI_EVNT_NOTE_ON_TONE_B_SEND_TUNE_TO_AY_CHIP


;; -----------[PITCH BEND TONE B == POSITIVE]--------------
MIDI_EVNT_NOTE_ON_TONE_B_FINE_DETUNE_PLUS
	;; DETUNE IS POSITIVE - HIGHER FREQUENCY
	;; (+) RANGE OF: VAR_TONE_B_TUNE_FINE_USER = [129 to 255] DETUNE IS POSITIVE (HERE)
	;; (-) RANGE OF: VAR_TONE_B_TUNE_FINE_USER = [0   to 127] DETUNE IS NEGATIVE 
	;; (NO DETUNE) : VAR_TONE_B_TUNE_FINE_USER = [128]
	
	;; OFFSET JUSTAGE
	;; WRITE 128 TO WREG
	movlw	OFFSET_FINE_TUNE_IS_128
	;; {[VAR_TONE_B_TUNE_FINE_USER | (129 to 255)] - [WREG|(128)]} WRITE TO => [WREG]
	subwf	VAR_TONE_B_TUNE_FINE_USER, W		
		;; RANGE JUSTAGE
		;; WRITE [WREG] TO => [VAR_AY_DETUNE_TEMP]
		;; RANGE == [+1 to +128]
		movwf	VAR_AY_DETUNE_TEMP
		;; 2x RANGE => [(+2 to +256)]
		addwf	VAR_AY_DETUNE_TEMP, F
		;; -1 => (+1 to +255)
		decf	VAR_AY_DETUNE_TEMP, F
		
;; ------[DETUNE RATIO CHANGE?]------------------
	;; CHECK IF WE NEED TO CHANGE THE PITCH BEND RATIO
	;; CHECK IF MIDI TUNE COARSE REG > 3 
	;; 4 to 15 => NO RATIO CHANGE
	movlw	0x03	 
	cpfsgt 	VAR_TONE_B_TUNE_COARSE_MIDI	

			;; NO [MIDI TUNE COARSE REG = 0 to 3]
			;; THERE MUST BE A PITCH BEND RATIO CONVERSATION
			rgoto MIDI_EVNT_NOTE_ON_TONE_B_FINE_DETUNE_POSITIVE_RATIO_CHANGE
			
			;; YES [MIDI TUNE COARSE REG > 3]
			;; THERE MUST BE *NO* PITCH BEND RATIO CHANGE
			rgoto MIDI_EVNT_NOTE_ON_TONE_B_FINE_DETUNE_POSITIVE_GO_ON

MIDI_EVNT_NOTE_ON_TONE_B_FINE_DETUNE_POSITIVE_RATIO_CHANGE	
	;; 0) PITCH BEND /16 ==> IF MIDI TUNE COARSE REG == 0
	;; 1) PITCH BEND / 8 ==> IF MIDI TUNE COARSE REG == 1
	;; 2) PITCH BEND / 4 ==> IF MIDI TUNE COARSE REG == 2
	;; 3) PITCH BEND / 2 ==> IF MIDI TUNE COARSE REG == 3
	movf VAR_TONE_B_TUNE_COARSE_MIDI, W
	JUMPTABLE_2BYTES 4
		rgoto        MIDI_EVNT_NOTE_ON_TONE_B_FINE_DETUNE_POSITIVE_RATIO_CHANGE_DIVIDE_16x 	;; 0  ==> PITCH BAND VALUE /16
		rgoto        MIDI_EVNT_NOTE_ON_TONE_B_FINE_DETUNE_POSITIVE_RATIO_CHANGE_DIVIDE_8x 	;; 1  ==> PITCH BAND VALUE /8
		rgoto        MIDI_EVNT_NOTE_ON_TONE_B_FINE_DETUNE_POSITIVE_RATIO_CHANGE_DIVIDE_4x 	;; 2  ==> PITCH BAND VALUE /4
		rgoto        MIDI_EVNT_NOTE_ON_TONE_B_FINE_DETUNE_POSITIVE_RATIO_CHANGE_DIVIDE_2x 	;; 3  ==> PITCH BAND VALUE /2
	
	
	
;; ADJUST PITCH BEND RATIO
;; JUMP IN HERE = PITCH BAND /16
MIDI_EVNT_NOTE_ON_TONE_B_FINE_DETUNE_POSITIVE_RATIO_CHANGE_DIVIDE_16x 
		rrncf	VAR_AY_DETUNE_TEMP, F
		bcf	VAR_AY_DETUNE_TEMP, 7
;; JUMP IN HERE = PITCH BAND /8
MIDI_EVNT_NOTE_ON_TONE_B_FINE_DETUNE_POSITIVE_RATIO_CHANGE_DIVIDE_8x
		rrncf	VAR_AY_DETUNE_TEMP, F
		bcf	VAR_AY_DETUNE_TEMP, 7
;; JUMP IN HERE = PITCH BAND /4
MIDI_EVNT_NOTE_ON_TONE_B_FINE_DETUNE_POSITIVE_RATIO_CHANGE_DIVIDE_4x
		rrncf	VAR_AY_DETUNE_TEMP, F
		bcf	VAR_AY_DETUNE_TEMP, 7
;; JUMP IN HERE = PITCH BAND /2
MIDI_EVNT_NOTE_ON_TONE_B_FINE_DETUNE_POSITIVE_RATIO_CHANGE_DIVIDE_2x
		rrncf	VAR_AY_DETUNE_TEMP, F
		bcf	VAR_AY_DETUNE_TEMP, 7

;; ------[DETUNE RATIO CHANGE END]------------------

;; WRITE DETUNE TO MIDI TUNE FINE REG
MIDI_EVNT_NOTE_ON_TONE_B_FINE_DETUNE_POSITIVE_GO_ON
	
		;; CHECK: DO WE NEED TO SUBTRACT THE NEGATIVE CARRY BIT
		;; FROM THE MIDI TUNE COARSE REG?
		;; IS [DETUNE FINE] > W [TONE FINE MIDI] ?
		;; // [DETUNE FINE] MUST BE = or < THEN [TONE FINE MIDI]
		;; // otherwise WE HAVE DO DEC -1 @ [COARSE MIDI REG]
		movf 	VAR_TONE_B_TUNE_FINE_MIDI, W 	;; W
		cpfsgt	VAR_AY_DETUNE_TEMP		 	;; F
						
			;; NO
			;; W [MIDI FINE REG] WAS > F [DETUNE FINE]
			;; or W [MIDI FINE REG] =  F [DETUNE FINE]
			;; SO WE CAN GO ON 
			rgoto MIDI_EVNT_NOTE_ON_FINE_DETUNE_POSITIVE_WRITE_DETUNE_TO_MIDI_VALUE_TONE_B
		
			;; YES 
			;; F [PITCH BEND] WAS > W [MIDI FINE REG]
			;; SO WE HAVE DO DEC -1 from  [COARSE MIDI REG]
			rgoto MIDI_EVNT_NOTE_ON_FINE_DETUNE_POSITIVE_COARSE_REG_B_DEC	


MIDI_EVNT_NOTE_ON_FINE_DETUNE_POSITIVE_WRITE_DETUNE_TO_MIDI_VALUE_TONE_B	
	;; WRITE THE POSITIVE PITCH BEND TO THE "NOTE ON MIDI VALUE" [FINE TUNE + COARSE TUNE REG]
	;; SUBTRACT DETUNE (THE POSITIVE PITCH BEND) from "NOTE ON" MIDI VALUE 
	;; THE POSITIVE VALUE WILL BE SUBTRACTED (DON'T BE CONFUSED;)
	;; TUNE "+" = "-" @ TUNE REG (LOGIC => AY SOUND CHIP)
	movf	VAR_AY_DETUNE_TEMP, W
	subwf	VAR_TONE_B_TUNE_FINE_MIDI, F
							;; OK, FINE DETUNE IS DONE
							;; GO ON - WRITE TUNE TONE B
							rgoto MIDI_EVNT_NOTE_ON_TONE_B_SEND_TUNE_TO_AY_CHIP



MIDI_EVNT_NOTE_ON_FINE_DETUNE_POSITIVE_COARSE_REG_B_DEC
	;; FIRST: WRITE THE POSITIVE PITCH BEND TO THE "NOTE ON MIDI VALUE" [FINE TUNE + COARSE TUNE REG]
	;; SUBTRACT DETUNE (THE POSITIVE PITCH BEND) from "NOTE ON" MIDI VALUE 
	;; THE POSITIVE VALUE WILL BE SUBTRACTED (DON'T BE CONFUSED;)
	;; TUNE "+" = "-" @ TUNE REG (LOGIC => AY SOUND CHIP)
	movf	VAR_AY_DETUNE_TEMP, W
	subwf	VAR_TONE_B_TUNE_FINE_MIDI, F
	
				;; WE HAVE TO DEC THE VALUE OF COARSE REG -1
				;; BUT CHECK MIDI COASE REG = 0x00 ? 
				;; BECAUSE => 0x00 = INVALID VALUE 
				movlw	0x00
				cpfseq 	VAR_TONE_B_TUNE_COARSE_MIDI

					;; NO - OK COARSE REG IS > 0 - SO GO ON WITH DEC COASE TUNE REG | -1
					rgoto MIDI_EVNT_NOTE_ON_FINE_DETUNE_POSITIVE_CARRYBIT_DEC_COARSE_REG_B_GO_ON

					;; YES - COARSE REG = 0 
					;; WE CAN NOT DEC. COARSE REG (ALLREADY 0x00)
					;; SO WRITE THE highest PITCH BEND DATA as possible TO THE 
					;; FINE AND COARSE REG instead
					rgoto MIDI_EVNT_NOTE_ON_FINE_DETUNE_POSITIVE_WRITE_HIGHEST_VALUE_PITCH_B


MIDI_EVNT_NOTE_ON_FINE_DETUNE_POSITIVE_CARRYBIT_DEC_COARSE_REG_B_GO_ON	
	
						;; DEC DETUNE CARRY FROM FINETUNE REG (MINUS CARY) 
						;; -1 to COASE TUNE REG 
						decf VAR_TONE_B_TUNE_COARSE_MIDI, F
	
						  	;; GO ON - WRITE TUNE TONE B
							rgoto MIDI_EVNT_NOTE_ON_TONE_B_SEND_TUNE_TO_AY_CHIP


MIDI_EVNT_NOTE_ON_FINE_DETUNE_POSITIVE_WRITE_HIGHEST_VALUE_PITCH_B
	
						;; THE TUNE WOULD BE OUT OF RANGE 
						;; SO SET FINE TUNE REG TO 0x0A (highest value that is VALID)
						;; COARSE TUNE REG IS ALLREADY 0x00
						movlw 	CONST_FINE_TUNE_MIN_VALUE_B00001010
						movwf	VAR_TONE_B_TUNE_FINE_MIDI
	
							;; GO ON - WRITE TUNE TONE B
							rgoto MIDI_EVNT_NOTE_ON_TONE_B_SEND_TUNE_TO_AY_CHIP

;; -------------[END OF DETUNE TONE B FINE ]--------------		


MIDI_EVNT_NOTE_ON_TONE_B_SEND_TUNE_TO_AY_CHIP
	;; -------------[SEND TUNE TONE B DATA TO AY CHIP]--------------
	;; SEND TUNE B TO AY CHIP
	movlw  CONST_AY_CHIP_ADR_03_TONE_B_FREQUENCY_PERIOD_COARSE			; ADRESS => AY REGISTER
	movwf  VAR_AY_CHIP_REG_ADDRESS 										; ADDRESS FOR => AY_SR_Write
	movf   VAR_TONE_B_TUNE_COARSE_MIDI, W								; DATA FOR AY REG X
	movwf  VAR_AY_CHIP_REG_DATA 										; FOR => AY_SR_Write (WRITE DATA TO AY REG)
	
		call LABEL_AY_SR_Write	; WRITING 8BIT DATA (VAR_AY_CHIP_REG_ADDRESS, VAR_AY_CHIP_REG_DATA)TO AY REG(X) ROUTINE	

	movlw  CONST_AY_CHIP_ADR_02_TONE_B_FREQUENCY_PERIOD_FINE			; ADDRESS => AY REGISTER
	movwf  VAR_AY_CHIP_REG_ADDRESS 										; ADDRESS FOR => AY_SR_Write
	movf   VAR_TONE_B_TUNE_FINE_MIDI, W	; DATA FOR AY REG X
	movwf  VAR_AY_CHIP_REG_DATA 			; FOR => AY_SR_Write (WRITE DATA TO AY REG)
	
		call LABEL_AY_SR_Write	; WRITING 8BIT DATA (VAR_AY_CHIP_REG_ADDRESS, VAR_AY_CHIP_REG_DATA)TO AY REG(X) ROUTINE

		
;; -------------[END OF DETUNE TONE B ]--------------		

;; ----------------------------[CHECK VELOCITY TO NOISE PERIOD @ TONE B]-------------------------

	;; CHECK IF BIT3 is SET
	btfss VAR_VELOCITY_TO_ABC_NOISE_PERIOD_ON_OFF, BIT3_VELOCITY_TO_NOISE_PERIOD_ON_OFF
		;; NO, BIT3 IS NOT SET
		;; THERE IS NO VELOCITY TO NOISE PERIOD
		;; SO GO ON WITCH CHECKING THE VELOCITY TO VOLUME @ TONE B
		rgoto MIDI_EVNT_NOTE_ON_TONE_B_CHECK_VELOCITY
	
		;; YES - BIT3 IS SET - CHECK IF VELOCITY TO NOISE PERID IS SET @ TONE B
	;; YES - BIT3 IS SET [VELOCITY TO NOISE PERIOD = ON]
	;; CHECK IF VELOCITY IS @ TONE B => BIT6
	btfss VAR_VELOCITY_TO_ABC_NOISE_PERIOD_ON_OFF, BIT6_VELOCITY_B_TO_NOISE_PERIOD_ON_OFF
		;; NO, BIT6 IS NOT SET
		;; THERE IS NO VELOCITY TO NOISE PERIOD @ TONE B 
		;; SO GO ON WITCH CHECKING THE VELOCITY TO VOLUME @ TONE B
		rgoto MIDI_EVNT_NOTE_ON_TONE_B_CHECK_VELOCITY
	
		;; YES - BIT6 IS SET - WRITE VELOCITY TONE A TO NOISE PERIOD 
	;; CONVERT MIDI DATA 7BIT (0-127) TO NOISE PERIOD 5BIT(0-31)
	;; [VOLUME TONE 5BIT] = [MIDI DATA 7BIT]/4

	;; WRITE MIDI DATA BYTE2 0-127 
	;; TO VAR_MIDI_VELOCITY_TO_AY_CHIP_NOISE_PERIOD
	movff	MIDI_EVNT_VALUE, VAR_MIDI_VELOCITY_TO_AY_CHIP_NOISE_PERIOD

    ;; convert VAR_MIDI_VELOCITY_TO_AY_CHIP_NOISE_PERIOD
    ;; divide ==> (MIDI DATA)/4
    rrncf 	VAR_MIDI_VELOCITY_TO_AY_CHIP_NOISE_PERIOD, F	 ;; /2
    bcf 		VAR_MIDI_VELOCITY_TO_AY_CHIP_NOISE_PERIOD, 7
    rrncf 	VAR_MIDI_VELOCITY_TO_AY_CHIP_NOISE_PERIOD, F	 ;; /4
    bcf 		VAR_MIDI_VELOCITY_TO_AY_CHIP_NOISE_PERIOD, 7

    movlw 0x1F ;; BIN 0001 1111
    andwf VAR_MIDI_VELOCITY_TO_AY_CHIP_NOISE_PERIOD, F

    ;; NOW THE VELOCITY IS IN THE 5 LOWER BITS (0-31 dec.)
    ;; VAR_MIDI_VELOCITY_TO_AY_CHIP_NOISE_PERIOD => BIN '000V VVVV'
	;; REVERSE VALUE
    movlw  CONST_VALUE32_FOR_NOISE_PERIOD_REVERSE_VALUE
    ;; BIN 0010 0000 (32 dec.) - [MIDI VELOCITY VALUE]/4
    subfwb VAR_MIDI_VELOCITY_TO_AY_CHIP_NOISE_PERIOD, F

	movlw 0x1F
	cpfsgt VAR_MIDI_VELOCITY_TO_AY_CHIP_NOISE_PERIOD

	      ;; NO, OK
	      rgoto MIDI_EVNT_NOTE_ON_TONE_B_WRITE_VELOCITY_TO_NOISE_PERIOD_NOW
	
    ;; YES - MAKE VAR VALID
	;; MAKE VELOCITY VALUE VALID [xxxV VVVV]
	movlw 0x1F 
	movwf VAR_MIDI_VELOCITY_TO_AY_CHIP_NOISE_PERIOD
	      
MIDI_EVNT_NOTE_ON_TONE_B_WRITE_VELOCITY_TO_NOISE_PERIOD_NOW	      
	;; -------------[SEND VELOCITY TO NOISE PERIOD REG 6]------------------------
	movlw CONST_AY_CHIP_ADR_06_NOISE_PERIOD	; REG ADRESS 	=> AY REGISTER
	movwf VAR_AY_CHIP_REG_ADDRESS 			; ADDRESS FOR 	=> AY_SR_Write

	;; WRITE VAR_MIDI_VELOCITY_TO_AY_CHIP_VOLUME TO VAR_AY_CHIP_REG_DATA
	movff VAR_MIDI_VELOCITY_TO_AY_CHIP_NOISE_PERIOD, VAR_AY_CHIP_REG_DATA

		;; --------------[SEND DATA TO AY REG X]-----------------------------------------------------
		call LABEL_AY_SR_Write	; WRITING 8BIT DATA (VAR_AY_CHIP_REG_ADDRESS, VAR_AY_CHIP_REG_DATA)TO AY REG(X) ROUTINE
		;; ==========================================================================================

	;; NEXT CHECK VELOCITY TONE B

;; ----------------------------[CHECK VELOCITY TONE B]-------------------------

MIDI_EVNT_NOTE_ON_TONE_B_CHECK_VELOCITY
	;; ---[CHECK: VELOYTY TO VOLUME TONE B (BIT1)       ]---------------------- 
	btfsc VAR_VELOCITY_TO_ABC_NOISE_PERIOD_ON_OFF, BIT1_VELOCITY_ON_OFF_TONE_B
		
		;; NO,
		;; BIT1 = SET 
		;; DO WRITE VELOCITY TO VOLUME
		rgoto  MIDI_EVNT_NOTE_ON_TONE_B_SEND_VELOCITY_TO_VOLUME
		
		
		;; YES
		;; BIT1 = CLR 
		;; DO NOT WRITE VELOCITY TO VOLUME
		;; DO NOT WRITE VELOCITY TO TONE B VOLUME
		;; WRITE USER VOLUME TO TONE B

	;; -------------[SEND REG9 AMPLITUDE TO TONE B - USER VOLUME 0-15]------------------------
	movlw CONST_AY_CHIP_ADR_09_TONE_B_VOLUME_ENV_MODE_ON_OFF  ; REG ADRESS 	=> AY REGISTER
	movwf VAR_AY_CHIP_REG_ADDRESS 				; ADDRESS FOR 	=> AY_SR_Write
        
	;; VAR_AY_CHIP_REG9_CH_B_AMPLITUDE TO VAR_AY_CHIP_REG_DATA
	movff VAR_AY_CHIP_REG9_CH_B_AMPLITUDE, VAR_AY_CHIP_REG_DATA

		;; --------------[SEND DATA TO AY REG X]-----------------------------------------------------
		call LABEL_AY_SR_Write	; WRITING 8BIT DATA (VAR_AY_CHIP_REG_ADDRESS, VAR_AY_CHIP_REG_DATA)TO AY REG(X) ROUTINE
		;; ==========================================================================================
		
	;; NEXT TONE C
	goto MIDI_EVNT_NOTE_ON_CHECK_MIDI_CHANNEL_C
	


MIDI_EVNT_NOTE_ON_TONE_B_SEND_VELOCITY_TO_VOLUME
	;; CONVERT MIDI DATA 7BIT (0-127) TO VOLUME TONE B 4BIT(0-15)
	;; {VOLUME TONE 4BIT} = {MIDI DATA 7BIT}/8

	;; WRITE MIDI DATA BYTE2 0-127 
	;; TO VAR_MIDI_VELOCITY_TO_AY_CHIP_VOLUME
	movff	MIDI_EVNT_VALUE, VAR_MIDI_VELOCITY_TO_AY_CHIP_VOLUME
	      
	          
	      ;; convert VAR_MIDI_VELOCITY_TO_AY_CHIP_VOLUME
	      ;; divide ==> (MIDI DATA)/8
	      rrncf 	VAR_MIDI_VELOCITY_TO_AY_CHIP_VOLUME, F	 ;; /2
	      bcf 	VAR_MIDI_VELOCITY_TO_AY_CHIP_VOLUME, 7
	      rrncf 	VAR_MIDI_VELOCITY_TO_AY_CHIP_VOLUME, F	 ;; /4
	      bcf 	VAR_MIDI_VELOCITY_TO_AY_CHIP_VOLUME, 7
	      rrncf 	VAR_MIDI_VELOCITY_TO_AY_CHIP_VOLUME, F	 ;; /8
	      bcf 	VAR_MIDI_VELOCITY_TO_AY_CHIP_VOLUME, 7

	      
	      movlw 0x0F ;; BIN 00001111
	      andwf VAR_MIDI_VELOCITY_TO_AY_CHIP_VOLUME, F

	      ;; NOW THE VELOCITY IS IN THE 4 LOWER BITS (0-15 dec.)
	      ;; VAR_MIDI_VELOCITY_TO_AY_CHIP_VOLUME => BIN '0000 VVVV'
	      
	      ;; COPY THE ENV. MODE BIT	      
	      ;; WRITE 0 TO BIT0-3 
	      movlw 0xF0 ;; BIN 1111 0000
	      andwf VAR_AY_CHIP_REG9_CH_B_AMPLITUDE, W

	      iorwf VAR_MIDI_VELOCITY_TO_AY_CHIP_VOLUME, W
	      movwf VAR_MIDI_VELOCITY_TO_AY_CHIP_VOLUME

	;; -------------[SEND VELOCITY AMPLITUDE TO TONE B - AY REG 9]------------------------
	movlw CONST_AY_CHIP_ADR_09_TONE_B_VOLUME_ENV_MODE_ON_OFF ; REG ADRESS 	=> AY REGISTER
	movwf VAR_AY_CHIP_REG_ADDRESS 				; ADDRESS FOR 	=> AY_SR_Write
        
	      ;; WRITE VELOCITY TO AY REG
	      movff VAR_MIDI_VELOCITY_TO_AY_CHIP_VOLUME, VAR_AY_CHIP_REG_DATA

		;; --------------[SEND DATA TO AY REG X]-----------------------------------------------------
		call LABEL_AY_SR_Write	; WRITING 8BIT DATA (VAR_AY_CHIP_REG_ADDRESS, VAR_AY_CHIP_REG_DATA)TO AY REG(X) ROUTINE
		;; ==========================================================================================
	     
			

;; -------------[END VELOCITY TONE B]---------------------------


;;; ---------------------------------[END TONE B WORKFLOW]-----------------------------------

				;; NEXT TONE C
				goto MIDI_EVNT_NOTE_ON_CHECK_MIDI_CHANNEL_C
				