;; -----------------------------------------------------------------------------------------------------
;; ----------[LOAD DATA BYTE from EEPROM OR BANKSTICK to PIC RAM (SUBROUTINE)]--------------------------
;; -----------------------------------------------------------------------------------------------------

SUB_ROUTINE_LOAD_PATCH_DATA_BYTE
	;; -------------------------------------------------------------------------------------------------
	;; FUNCTION:
	;; LOAD A BYTE FROM PIC EEPROM OR BANKSTICK PATCH
	;; DATA BYTE WILL BE STORED IN VAR_TMP_PATCH_DATA_CLIPBOARD
	;; 
	;; USES:
	;; IN		-> BNKD_VAR_PATCH_STATE_FLAGS
	;; IN & OUT -> VAR_TMP_PATCH_DATA_CLIPBOARD
	;; IN & OUT -> VAR_TMP_RAM_BYTE_COPY_CLIPBOARD
	;; CALL		-> MIOS_EEPROM_Read
	;; 
	;; IN & OUT	-> BNKD_VAR_BANKSTICK_LOW_BYTE_ADR_COUNTER => WILL BE +1 AFTER READING THE DATA BYTE
	;; IN		-> BNKD_VAR_BROWSE_PATCH_NR
	;; IN & OUT -> MIOS_PARAMETER1			;; BS LOW BYTE ADR
	;; IN & OUT -> MIOS_PARAMETER2			;; BS HIGH BYTE ADR
	;; call     -> MIOS_BANKSTICK_Read    	
	;; --------------------------------------------------------------------------------------------------
	
	;; CHECK:
	;; BNKD_VAR_PATCH_STATE_FLAGS
	;; BIT2 = 0 = LOAD EEPROM PATCH (PIC INTERNAL PATCH)
	;; BIT2 = 1 = LOAD BANKSTICK PATCH
	movff	BNKD_VAR_PATCH_STATE_FLAGS, VAR_TMP_RAM_BYTE_COPY_CLIPBOARD
	btfsc	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, BIT2_CHK_IF_PIC_EEPROM_PATCH_OR_BS_PATCH
			;; BIT2 = SET = BS PATCH SELECTED
			;; ===[LOAD DATA BYTE from BANKSTICK PATCH TO PIC RAM]====================
			goto SUB_ROUTINE_LOAD_PATCH_DATA_BYTE_FROM_BANKSTICK
				
		;; ===========[WRITE DATA BYTE TO INTERNAL EEPROM]============================
		;; BIT2 = CLEAR
		;; GO PIC EEPROM
		;; LOAD INTERNAL PATCH (from PIC EEPROM)
		call    MIOS_EEPROM_Read
		movwf	VAR_TMP_PATCH_DATA_CLIPBOARD
		;; LOADED BYTE HAS BEEN WRITTEN TO VAR_TMP_PATCH_DATA_CLIPBOARD
		;; EEPROM ADR = EEPROM ADR +1
		;; EXIT THIS SUBROUTINE
		return
		;; =====================================================================

SUB_ROUTINE_LOAD_PATCH_DATA_BYTE_FROM_BANKSTICK
			;; ===================[WRITE DATA BYTE TO BANKSTICK]================
			;  Store low-byte of address in MIOS_PARAMETER1
			movff    BNKD_VAR_BANKSTICK_LOW_BYTE_ADR_COUNTER, MIOS_PARAMETER1
      		; Store high-byte of address in MIOS_PARAMETER2
        	movff   BNKD_VAR_BROWSE_PATCH_NR, MIOS_PARAMETER2
        	decf	MIOS_PARAMETER2, F		;; ADR HIGH BYTE BS PATCH 
        									;; => BS PATCH NUMBER VALUE -1
        									;; => BS PATCH HIGH BYTE ADR -1 OFFSET
	
        	;; READ A DATA BYTE from BANKSTICK
        	call    MIOS_BANKSTICK_Read        		; BS LOW BYTE ADR will be +1
        	;; bnz   BSProgrammingFailed       		; branch to your exception handler

			;; STORE PATCH DATA BYTE TO VAR_TMP_PATCH_DATA_CLIPBOARD
        	movwf	VAR_TMP_PATCH_DATA_CLIPBOARD
			;; --------------------------------------------------------------------
			;; BANKSTICK ADR = BANKSTICK ADR +1 (LOW BYTE)
			movff	BNKD_VAR_BANKSTICK_LOW_BYTE_ADR_COUNTER, VAR_TMP_RAM_BYTE_COPY_CLIPBOARD
			incf	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, F
			movff	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, BNKD_VAR_BANKSTICK_LOW_BYTE_ADR_COUNTER
			;; --------------------------------------------------------------------  
			;; EXIT THIS SUBROUTINE
			return
			;; =====================================================================

;; ---------------------------------------------------------------------------------------------
;; -----------------------[END: READ DATA BYTE FROM EEPROM OR BANKSTICK SUBROUTINE]-------------
;; ---------------------------------------------------------------------------------------------


;; ---------------------------------------------------------------------------------------------
;; -------------------------------------[START SUBROUTINE: READ PATCH NAME]---------------------
;; ---------------------------------------------------------------------------------------------
SUB_ROUTINE_LOAD_PATCH_NAME
	
	;; ---------[SET ADR FOR ASC NAME LOAD FOR ---> PIC EEPROM INT. PATCH 0]--------------------
	;; SET LOW BYTE ADR FOR READING 8x ASC (PATCHNAME)
	;; LOW BYTE address FOR THE PIC EEPROM is in EEADR 
	;; -----------------------------------------------------------------------------------------
	movlw	CONST_ADR_LOW_BYTE_PIC_EEPROM_ASC_NAME
	movwf	EEADR
	
	;; ------------------------------------------------------------------------------
	;; --------[SET ADR FOR ASC NAME LOAD FOR ---> BS PATCH 1-127]-------------------
	;; SET BS LOW BYTE ADR FOR READING BS PATCH DATA
	;; ------------------------------------------------------------------------------
	movlw	CONST_ADR_LOW_BYTE_BANKSTICKS_ASC_NAME
	movwf	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD
	movff	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, BNKD_VAR_BANKSTICK_LOW_BYTE_ADR_COUNTER
	
	;; ------------------------------------------------------------------------------
	;; ---------[LOAD PATCH NAME (8x ASC)]-------------------------------------------
	
	;; LOAD DATA BYTE @ EEPROM ADR 0x01 | @ BANKSTICK PATCH DATA BYTE ADR 0x02
	call    SUB_ROUTINE_LOAD_PATCH_DATA_BYTE
	movff 	VAR_TMP_PATCH_DATA_CLIPBOARD, BNKD_VAR_PATCH_NAME_ASC_0
	
	
	
	;; LOAD DATA BYTE @ EEPROM ADR 0x02 | @ BANKSTICK PATCH DATA BYTE ADR 0x03
	call    SUB_ROUTINE_LOAD_PATCH_DATA_BYTE
	movff 	VAR_TMP_PATCH_DATA_CLIPBOARD, BNKD_VAR_PATCH_NAME_ASC_1


	
	;; LOAD DATA BYTE @ EEPROM ADR 0x03 | @ BANKSTICK PATCH DATA BYTE ADR 0x04
	call    SUB_ROUTINE_LOAD_PATCH_DATA_BYTE
	movff 	VAR_TMP_PATCH_DATA_CLIPBOARD, BNKD_VAR_PATCH_NAME_ASC_2


	;; @ EEPROM ADR 0x04 
	call    SUB_ROUTINE_LOAD_PATCH_DATA_BYTE
	movff 	VAR_TMP_PATCH_DATA_CLIPBOARD, BNKD_VAR_PATCH_NAME_ASC_3

	;; @ EEPROM ADR 0x05
	call    SUB_ROUTINE_LOAD_PATCH_DATA_BYTE
	movff 	VAR_TMP_PATCH_DATA_CLIPBOARD, BNKD_VAR_PATCH_NAME_ASC_4

	;; @ EEPROM ADR 0x06
	call    SUB_ROUTINE_LOAD_PATCH_DATA_BYTE
	movff 	VAR_TMP_PATCH_DATA_CLIPBOARD, BNKD_VAR_PATCH_NAME_ASC_5

	;; @ EEPROM ADR 0x07
	call    SUB_ROUTINE_LOAD_PATCH_DATA_BYTE
	movff 	VAR_TMP_PATCH_DATA_CLIPBOARD, BNKD_VAR_PATCH_NAME_ASC_6

	
	;; LOAD DATA BYTE @ EEPROM ADR 0x08 | @ BANKSTICK PATCH DATA BYTE ADR 0x09
	call    SUB_ROUTINE_LOAD_PATCH_DATA_BYTE
	movff 	VAR_TMP_PATCH_DATA_CLIPBOARD, BNKD_VAR_PATCH_NAME_ASC_7

		;; EXIT SUBROUTINE
		return

;; -------------------------------------------------------------------------------
;; -------------------------[END: READ PATCH NAME]--------------------------------
;; -------------------------------------------------------------------------------



;; -------------------------------------------------------------------------------
;; ---------[START SUBROUTINE: READ PATCH DATA WORKING REGISTER]------------------
;; -------------------------------------------------------------------------------
SUB_ROUTINE_LOAD_PATCH_WORKING_REGISTER
	;; ---------------------------------------------------------------------------
	;; -------------------[READ MIDIBOX AY PATCH DATA]----------------------------
	;; ---------------------------------------------------------------------------
	
	;; -------------------[SET LOW BYTE ADR FOR PATCH DATA READING]---------------
	;; PIC EEPROM INT. PATCH 0
	;; SET LOW BYTE ADR FOR READING PATCH DATA
	;; LOW BYTE address FOR THE PIC EEPROM is in EEADR 
	movlw	CONST_ADR_LOW_BYTE_PIC_EEPROM_PATCH_DATA
	movwf	EEADR
	
	;; BS PATCH 1-128
	;; SET BS LOW BYTE ADR FOR READING BS PATCH DATA
	movlw	CONST_ADR_LOW_BYTE_BANKSTICK_PATCH_DATA
	movwf	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD
	movff	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, BNKD_VAR_BANKSTICK_LOW_BYTE_ADR_COUNTER
	;; ---------------------------------------------------------------------------

	;; LOAD DATA BYTE @ EEPROM ADR 0x09 | @ BANKSTICK PATCH DATA BYTE ADR 0x0A
	call    SUB_ROUTINE_LOAD_PATCH_DATA_BYTE
	movff 	VAR_TMP_PATCH_DATA_CLIPBOARD, VAR_TONE_A_TUNE_FINE_USER
	
	;; LOAD DATA BYTE @ EEPROM ADR 0x0A | @ BANKSTICK PATCH DATA BYTE ADR 0x0B
	call    SUB_ROUTINE_LOAD_PATCH_DATA_BYTE
	movff 	VAR_TMP_PATCH_DATA_CLIPBOARD, VAR_TONE_B_TUNE_FINE_USER
	

	;; @ EEPROM ADR 0x0B		| @ BANKSTICK PATCH DATA BYTE ADR 0x0C
	call    SUB_ROUTINE_LOAD_PATCH_DATA_BYTE	
	movff 	VAR_TMP_PATCH_DATA_CLIPBOARD, VAR_TONE_C_TUNE_FINE_USER
	
	
	;; @ EEPROM ADR 0x0C		| @ BANKSTICK PATCH DATA BYTE ADR 0x0D
	call    SUB_ROUTINE_LOAD_PATCH_DATA_BYTE
	movff 	VAR_TMP_PATCH_DATA_CLIPBOARD, VAR_TONE_A_TUNE_COARSE_USER
	
	
	;; @ EEPROM ADR 0x0D		...
	call    SUB_ROUTINE_LOAD_PATCH_DATA_BYTE
	movff 	VAR_TMP_PATCH_DATA_CLIPBOARD, VAR_TONE_B_TUNE_COARSE_USER
	
	
	;; @ EEPROM ADR 0x0E
	call    SUB_ROUTINE_LOAD_PATCH_DATA_BYTE
	movff 	VAR_TMP_PATCH_DATA_CLIPBOARD, VAR_TONE_C_TUNE_COARSE_USER
	
	
	;; @ EEPROM ADR 0x0F
	call    SUB_ROUTINE_LOAD_PATCH_DATA_BYTE	
	movff 	VAR_TMP_PATCH_DATA_CLIPBOARD, MIDI_CHANNEL_TONE_A_USER
	
	
	;; @ EEPROM ADR 0x10
	call    SUB_ROUTINE_LOAD_PATCH_DATA_BYTE
	movff 	VAR_TMP_PATCH_DATA_CLIPBOARD, MIDI_CHANNEL_TONE_B_USER
	
	
	;; @ EEPROM ADR 0x11
	call    SUB_ROUTINE_LOAD_PATCH_DATA_BYTE
	movff 	VAR_TMP_PATCH_DATA_CLIPBOARD, MIDI_CHANNEL_TONE_C_USER
	
	
	;; @ EEPROM ADR 0x12
	call    SUB_ROUTINE_LOAD_PATCH_DATA_BYTE
	movff 	VAR_TMP_PATCH_DATA_CLIPBOARD, VAR_VELOCITY_TO_ABC_NOISE_PERIOD_ON_OFF
	

	;; @ EEPROM ADR 0x13
	call    SUB_ROUTINE_LOAD_PATCH_DATA_BYTE
	movff 	VAR_TMP_PATCH_DATA_CLIPBOARD, VAR_AY_CHIP_REG6_NOISE_PERIOD
	

	;; @ EEPROM ADR 0x14
	call    SUB_ROUTINE_LOAD_PATCH_DATA_BYTE	
	movff 	VAR_TMP_PATCH_DATA_CLIPBOARD, VAR_AY_CHIP_REG8_CH_A_AMPLITUDE
	
	;; ----------------[ CHK: TONE A ENV ON?  ]-------------------	
	;; CS LED ==> TONE A ENVELOPE MODE (BIT4)	
	;; IS "ENVELOPE MODE" (BIT4) ON OR OFF?
        btfss VAR_AY_CHIP_REG8_CH_A_AMPLITUDE, BIT4_ENVELOPE_ON_OFF
        	;; BIT 4 is CLEAR - ENV OFF
		goto EEPROM_PATCH_LOAD_LED_CS_ENV_A_OFF
		
		;; BIT 4 is SET - ENV ON
        	;; WRITE PATCH DATA TO LED CS
		call LED_EnvelopeModeA_on
		goto EEPROM_PATCH_LOAD_R9

			
EEPROM_PATCH_LOAD_LED_CS_ENV_A_OFF
		;; WRITE PATCH DATA TO LED CS
		call LED_EnvelopeModeA_off
		;; GO ON WITH EEPROM_PATCH_LOAD_R9
			
	;; ----------------[END]-------------------------------------	

EEPROM_PATCH_LOAD_R9
	;; @ EEPROM ADR 0x15
	call    SUB_ROUTINE_LOAD_PATCH_DATA_BYTE	
	movff 	VAR_TMP_PATCH_DATA_CLIPBOARD, VAR_AY_CHIP_REG9_CH_B_AMPLITUDE
	
	;; ----------------[CHK: TONE B ENV ON?  ]-------------------	
	;; CS LED ==> TONE B ENVELOPE MODE (BIT4)	
	;; IS "ENVELOPE MODE" (BIT4) ON OR OFF?
        btfss VAR_AY_CHIP_REG9_CH_B_AMPLITUDE, 4
        	;; BIT 4 is CLEAR
		goto EEPROM_PATCH_LOAD_LED_CS_ENV_B_OFF

		;; BIT 4 is SET
        	;; CS LED ENV @ TONE B = ON
		call LED_EnvelopeModeB_on
		goto EEPROM_PATCH_LOAD_R10


EEPROM_PATCH_LOAD_LED_CS_ENV_B_OFF
		;; CS LED ENV @ TONE B = OFF
		call LED_EnvelopeModeB_off
		;; GO ON WITH NEXT REG LOAD
	;; ------------------[END]-------------------------------------
	
EEPROM_PATCH_LOAD_R10
	;; @ EEPROM ADR 0x16
	call    SUB_ROUTINE_LOAD_PATCH_DATA_BYTE
	movff 	VAR_TMP_PATCH_DATA_CLIPBOARD, VAR_AY_CHIP_REG10_CH_C_AMPLITUDE
	;; ----------------[ CHK: TONE C ENV ON?  ]-------------------	
	;; CS LED ==> TONE C ENVELOPE MODE (BIT4)	
	;; IS "ENVELOPE MODE" (BIT4) ON OR OFF?
        btfss VAR_AY_CHIP_REG10_CH_C_AMPLITUDE, 4
        	;; BIT 4 is CLEAR
		goto EEPROM_PATCH_LOAD_LED_CS_ENV_C_OFF
		
		;; BIT 4 is SET
        	;; CS LED ENV @ TONE C = ONN
		call LED_EnvelopeModeC_on
		goto EEPROM_PATCH_LOAD_R11

;; CS LED ENV @ TONE B = OFF
EEPROM_PATCH_LOAD_LED_CS_ENV_C_OFF
		call LED_EnvelopeModeC_off
		;; GO ON WITH NEXT REG LOAD
	;; ----------------[ END ]-----------------------------------
		
EEPROM_PATCH_LOAD_R11
	;; @ EEPROM ADR 0x17
	call    SUB_ROUTINE_LOAD_PATCH_DATA_BYTE
	movff 	VAR_TMP_PATCH_DATA_CLIPBOARD, VAR_AY_CHIP_REG11_ENV_PERIOD_FINE
		;; PREPARE ITEM DATA FOR TRANSFERE TO AY CHIP VIA ay_sr.inc
		;; --------------------------------------------------------
		;; WRITE AY REG *ADRESS* TO VAR_AY_CHIP_REG_ADDRESS FOR => AY_SR_Write
		movlw CONST_AY_CHIP_ADR_11_GLOBAL_ENVELOPE_FINE 		; ADRESS => AY REGISTER
		movwf VAR_AY_CHIP_REG_ADDRESS 							; ADDRESS FOR => AY_SR_Write
		;; WRITE AY REG *DATA* TO VAR_AY_CHIP_REG_DATA FOR => AY_SR_Write
		movff VAR_AY_CHIP_REG11_ENV_PERIOD_FINE, VAR_AY_CHIP_REG_DATA 
			;; WRITING 8BIT DATA (VAR_AY_CHIP_REG_ADDRESS, VAR_AY_CHIP_REG_DATA)TO AY REG(X) ROUTINE
			;; @ay_sr.inc
			call LABEL_AY_SR_Write
		;; --------------------------------------------------------
	
	;; @ EEPROM ADR 0x18
	call    SUB_ROUTINE_LOAD_PATCH_DATA_BYTE
	movff 	VAR_TMP_PATCH_DATA_CLIPBOARD, VAR_AY_CHIP_REG12_ENV_PERIOD_COARSE

		;; PREPARE ITEM DATA FOR TRANSFERE TO AY CHIP VIA ay_sr.inc
		;; --------------------------------------------------------
		;; WRITE AY REG *ADRESS* TO VAR_AY_CHIP_REG_ADDRESS FOR => AY_SR_Write
		movlw CONST_AY_CHIP_ADR_12_GLOBAL_ENVELOPE_COARSE 	; ADRESS => AY REGISTER
		movwf VAR_AY_CHIP_REG_ADDRESS 						; ADDRESS FOR => AY_SR_Write
		;; WRITE AY REG *DATA* TO VAR_AY_CHIP_REG_DATA FOR => AY_SR_Write
		movff VAR_AY_CHIP_REG12_ENV_PERIOD_COARSE, VAR_AY_CHIP_REG_DATA 
	
			;; WRITING 8BIT DATA 
			;; (VAR_AY_CHIP_REG_ADDRESS, VAR_AY_CHIP_REG_DATA)TO AY REG(X) ROUTINE
			call LABEL_AY_SR_Write
		;; --------------------------------------------------------
	
	;; -------------[WRITE ENV SHAPE 1-8]--------------------------
	;; @ EEPROM ADR 0x19
	call    SUB_ROUTINE_LOAD_PATCH_DATA_BYTE
	movff 	VAR_TMP_PATCH_DATA_CLIPBOARD, VAR_ENV_SHAPE_0_15_to_1_8_TRANSLATOR
		;; FUNCTION:
		;; 1) TRANSLATE ENV SHAPE 1-8 (ENV SHAPES) to 0-15 (AY CHIP REG) 
		;; 2) Write Value to AY_R13_ENV_SHAPE_CYCLE (but do not write the AY_R13_ENV_SHAPE_CYCLE
		;;    Value to AY Chip, this would cause a immediate ENVELOPE-Action, this is up 
		;;    to MIDI Note On)
		;; 3) Set ENV CS LED
		call ENVELOPE_TRANSLATOR_CALL
	;; -------------[END: WRITE ENV SHAPE 1-8]---------------------


	;; @ EEPROM ADR 0x1A
	;; ----------------[ START @ EEPROM ADR 0x1A ]------------------
	;; -------------[LOAD TONE NOISE ON OFF SWITCH]-----------------
	call    SUB_ROUTINE_LOAD_PATCH_DATA_BYTE	
	movff 	VAR_TMP_PATCH_DATA_CLIPBOARD, VAR_TONE_NOISE_ABC_USER_ON_OFF_SWITCH
		;; WRITE TO CS LED
		;; IS BIT 0 CLEAR? [(=> TONE A) = 0 (=> ON)]?
		btfsc VAR_TONE_NOISE_ABC_USER_ON_OFF_SWITCH, BIT0_TONE_A_ON_OFF
        	
        		;; NO - BIT0 IS SET
        		;; BIT0 = SET => SO TONE A IS *OFF* 
        		;; (DONT BE CONFUSED HAVE A LOOK IN THE DATASHEET OF THE AY CHIP ;-)
        		goto PATCH_LOAD_CS_TONE_A_OFF
		
			;; YES - BIT0 *IS* = 0
			;; BIT0 = CLEAR => SO TONE A *IS* ON 
			call LED_ToneA_on
			;; GO ON WITH NEXT BIT (TONE B ON / OFF)
			goto PATCH_LOAD_CHK_TONE_B_ON_OFF


PATCH_LOAD_CS_TONE_A_OFF
		;; MB AY CS:
		call LED_ToneA_off
		;; GO ON WITH NEXT BIT (TONE B ON / OFF)


PATCH_LOAD_CHK_TONE_B_ON_OFF	
	;; IS BIT 1 = CLEAR? 
	;; [(TONE B BIT1) = CLEAR = (TONE B = ON)]?
        btfsc VAR_TONE_NOISE_ABC_USER_ON_OFF_SWITCH, BIT1_TONE_B_ON_OFF
        		;; NO - BIT1 IS IS = SET
        		;; BIT1 = 1 => SO TONE B IS *OFF* 
        		;; (DONT BE CONFUSED HAVE A LOOK IN THE DATASHEET OF THE AY CHIP ;-)
        		goto PATCH_LOAD_CS_TONE_B_OFF
		
			;; YES - BIT1 *IS* = 0
			;; BIT1 = 0 => SO TONE B *IS* ON 
			call LED_ToneB_on
			;; CHK NEXT BIT (TONE C)
			goto PATCH_LOAD_CHK_TONE_C

PATCH_LOAD_CS_TONE_B_OFF
			call LED_ToneB_off
			;; CHK NEXT BIT (TONE C)

PATCH_LOAD_CHK_TONE_C
	;; IS BIT 2 = CLEAR? [(=> TONE C) = 0 (=> ON)]?
    btfsc VAR_TONE_NOISE_ABC_USER_ON_OFF_SWITCH, BIT2_TONE_C_ON_OFF
        		;; NO - BIT2 IS IS = SET
        		;; BIT2 = 1 => SO TONE C IS *OFF*
        		goto PATCH_LOAD_CS_TONE_C_OFF
		
			;; YES - BIT2 *IS* = 0
			;; BIT2 = 0 => SO TONE C *IS* ON 
			call LED_ToneC_on
			;; GO AND CHK NOISE TONE A
			goto PATCH_LOAD_CHK_NOISE_A

PATCH_LOAD_CS_TONE_C_OFF
			call LED_ToneC_off
			;; GO AND CHK NOISE TONE A

PATCH_LOAD_CHK_NOISE_A
	;; IS BIT 3 = CLEAR [(=> NOISE A) = 0 (=> ON)]?
    btfsc VAR_TONE_NOISE_ABC_USER_ON_OFF_SWITCH, BIT3_NOISE_A_ON_OFF
        		;; NO - BIT3 IS IS = SET
        		;; BIT3 = 1 => SO NOISE A IS *OFF*
        		goto PATCH_LOAD_CS_NOISE_A_OFF
		
			;; YES - BIT3 *IS* = CLEAR
			;; BIT3 = 0 => SO NOISE A *IS* ON 
			call LED_NoiseA_on
			;; GO AND CHK NOISE TONE B
			goto PATCH_LOAD_CHK_NOISE_B

PATCH_LOAD_CS_NOISE_A_OFF
			call LED_NoiseA_off
			;; GO AND CHK NOISE TONE B

PATCH_LOAD_CHK_NOISE_B
	;; IS BIT 4 = CLEAR [(=> NOISE B) = 0 (=> ON)]?
    btfsc VAR_TONE_NOISE_ABC_USER_ON_OFF_SWITCH, BIT4_NOISE_B_ON_OFF
        		;; NO - BIT4 IS IS = SET
        		;; BIT4 = 1 => SO NOISE B IS *OFF*
        		goto PATCH_LOAD_CS_NOISE_B_OFF
		
			;; YES - BIT4 *IS* = 0
			;; BIT4 = 0 => SO NOISE B *IS* ON 
			call LED_NoiseB_on
			;; GO AND CHK NOISE TONE C
			goto PATCH_LOAD_CHK_NOISE_C

PATCH_LOAD_CS_NOISE_B_OFF
			call LED_NoiseB_off
			;; GO AND CHK NOISE TONE C

PATCH_LOAD_CHK_NOISE_C
	;; IS BIT 5 = CLEAR? [(=> NOISE C) = 0 (=> ON)]?
    btfsc VAR_TONE_NOISE_ABC_USER_ON_OFF_SWITCH, BIT5_NOISE_C_ON_OFF
        	
        		;; NO - BIT5 IS IS = 1
        		;; BIT5 = 1 => SO NOISE C IS *OFF*
        		goto EEPROM_PATCH_LOAD_CS_NOISE_C_OFF
		
			;; YES - BIT5 *IS* = 0
			;; BIT5 = 0 => SO NOISE C *IS* ON 
			call LED_NoiseC_on
			;; GO AND CHK IF USR Fx
			goto PATCH_LOAD_FX_USER_ON_OFF

EEPROM_PATCH_LOAD_CS_NOISE_C_OFF
			call LED_NoiseC_off
			;; GO AND CHK IF USR Fx
;; ---------------------[END: LOAD TONE NOISE ON OFF SWITCH]----------------


PATCH_LOAD_FX_USER_ON_OFF
	;; LOAD:
	;; PATCH DATA BYTE 027
	;; INTERNAL PATCH DATA BYTE   [INTERNAL EEPROM PATCH - ADR 0x1B (027 DEC)@ EEPROM   ] 
	;; BANKSTICK PATCH DATA BAYTE [BANKSTICK PATCH         ADR 0x1C (028 DEC)@ BANKSTICK]
	call    SUB_ROUTINE_LOAD_PATCH_DATA_BYTE	
	movff 	VAR_TMP_PATCH_DATA_CLIPBOARD, BNKD_VAR_FX_USER_ON_OFF_ABC
	
	;; USER: FX ABC off (See MAIN MENU 3 / Mixer)
	;; BIT0 = A (SET = ON / CLR = OFF)
	;; BIT1 = B (SET = ON / CLR = OFF)
	;; BIT2 = C (SET = ON / CLR = OFF)
	
	;; WRITE TO CS LED
	;; ------------[Fx @ TONE A]-------------------
	;; IS BIT 0 = SET? [(=> Fx A) = 1 (=> ON)]?
	movff	BNKD_VAR_FX_USER_ON_OFF_ABC, VAR_TMP_RAM_BYTE_COPY_CLIPBOARD
	btfss 	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, BIT0_FX_ON_OFF_TONE_A
	
        		;; BIT0 = CLEAR = 0
        		;; Fx TONE A IS *NOT* ENABLED 
        		goto PATCH_LOAD_LED_CS_FX_A_OFF
		
			;; BIT0 = SET = 1
			;; Fx @ TONE A *IS* ON 
			call LED_Fx_A_on
			;; GO AND CHECK FX @ TONE B
			goto PATCH_LOAD_CHK_FX_B

PATCH_LOAD_LED_CS_FX_A_OFF
			call LED_Fx_A_off
			;; GO AND CHECK FX @ TONE B

	;; ------------[Fx @ TONE B]-------------------
			
PATCH_LOAD_CHK_FX_B
	;; IS BIT 1 (=> Fx B) = 1 (=> ON)?
	movff	BNKD_VAR_FX_USER_ON_OFF_ABC, VAR_TMP_RAM_BYTE_COPY_CLIPBOARD
    btfss  	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, BIT1_FX_ON_OFF_TONE_B
        		;; BIT1 = CLEAR = 0
        		;; Fx B IS OFF 
        		goto PATCH_LOAD_LED_CS_FX_B_OFF
		
			;; BIT1 *IS* = 1
			;; Fx B *IS* ON 
			call LED_Fx_B_on
			;; GO AND CHK USER Fx TONE C 
			goto PATCH_LOAD_CHK_FX_C

PATCH_LOAD_LED_CS_FX_B_OFF
			call LED_Fx_B_off
			;; GO AND CHK USER Fx TONE C 

	;; ------------[Fx @ TONE C]-------------------
PATCH_LOAD_CHK_FX_C
	;; IS BIT 2 = SET [(=> Fx C) = 1 (=> ON)]?
	movff	BNKD_VAR_FX_USER_ON_OFF_ABC, VAR_TMP_RAM_BYTE_COPY_CLIPBOARD
    btfss   VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, BIT2_FX_ON_OFF_TONE_C
        		;; BIT2 = CLEAR = 0
        		;; Fx C IS OFF 
        		goto PATCH_LOAD_LED_CS_FX_C_OFF
		
			;; BIT2 *IS* = 1
			;; Fx C *IS* ON 
			call LED_Fx_C_on

				;; exit here
				return


PATCH_LOAD_LED_CS_FX_C_OFF
			call LED_Fx_C_off
			;; GO AND LOAD PATCH FX DATA
			
				;; exit here
				return

	;; ----------------------[END: USER FX OPTION ON/OFF]-------------------------
	;; ---------------------------------------------------------------------------

;; -------------------------------------------------------------------------------
;; -------------------------[END SUBROUTINE: READ PATCH DATA]---------------------
;; -------------------------------------------------------------------------------



;; -------------------------------------------------------------------------------
;; -------------------------[START SUB ROUTINE: LOAD FX DATA]---------------------
;; -------------------------------------------------------------------------------
SUB_ROUTINE_DO_LOAD_PATCH_FX

	;; ---------------------[DO LOAD Fx DATA BYTES]----------------------
	;; ---------------------------------------------------------------
	;; ------------[PREPEAR Fx DATA LOADING]----------------
	;; MEMO: 
	;; Load THE Fx DATA from EEPROM to PIC Fx RAM AREA
	;; SET BSR = 2
	movlw CONST_BSR2_SELECT_Fx_RAM_BANK				;; INDIRECT RAM ADDRESSING:
	movwf FSR0H										;; SET THE Fx RAM BANK 
	;; ;; CLR READ CYCLE POS. 
	clrf	VAR_Fx_LOAD_WRITE_ADR_COUNTER_TMP


	;; CHECK: LOAD DATA from EEPROM or BANKSTICK?
	;; -------------------------------------------------------
	;; BNKD_VAR_PATCH_STATE_FLAGS
	;; BIT2 = 0 = LOAD Fx DATA from EEPROM (PIC INTERNAL PATCH)
	;; BIT2 = 1 = LOAD Fx DATA from BANKSTICK 
	movff	BNKD_VAR_PATCH_STATE_FLAGS, VAR_TMP_RAM_BYTE_COPY_CLIPBOARD 
	btfsc	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, BIT2_CHK_IF_PIC_EEPROM_PATCH_OR_BS_PATCH
			
			;; LOAD Fx DATA FROM BANKSTICK
			;; BIT2 = SET	
			goto BANKSTICK_PATCH_LOAD_FX_FUNC_FROM_BANKSTICK
		
	;; LOAD FX DATA From INTERNAL PIC PATCH (EEPROM)
	;; BIT2 = CLEAR
	;; -----------[LOAD Fx Function (Pos 0-31)]---------------------------------
EEPROM_PATCH_DO_LOAD_FX_FUNC
	;; LOAD Fx FUNCTION BYTES CYCLE - DO 32x
	;; LOAD FX FUNCTION @ CURRENT Fx Pos from PIC EEPROM to PIC RAM
	;; -------------------------------------------------------------------------
 	movlw	CONST_EEPROM_OFFSET_ADR_FX_FUNCTION		;; Fx Functions AREA - EEPROM OFFSET (!)
	addwf	VAR_Fx_LOAD_WRITE_ADR_COUNTER_TMP, W	;; OFFSET + POS
	movwf	EEADR 									;; SET EEPROM ADRESS [OFFSET+POS]
	call	MIOS_EEPROM_Read       					;; READ FX FUNCTION BYTE @ CURRENT Pos of PIC EEPROM (EEADR will be incremented)
 	movwf	VAR_TMP_PATCH_DATA_CLIPBOARD       		;; WRITE FX FUNCTION @ CURRENT Pos TO TMP
 	
 	;; ------[ WRITE FX FUNCTION @ CURRENT Fx Pos ==> to PIC RAM ]---------------
 	;; --------------------------------------------------------------------------
	movlw	CONST_RAM_ADR_OFFSET_FX_FUNCTION		;; Fx RAM AREA OFFSET (!)
 	addwf   VAR_Fx_LOAD_WRITE_ADR_COUNTER_TMP, W    ;; + (0 to 31 [32]) => Fx Tab Pos
	movwf   FSR0L		        					;; LOAD CURRENT OFFSET IND. ADR. for Fx Fuction Reg. @ current Fx Pos.
 	movff   VAR_TMP_PATCH_DATA_CLIPBOARD, INDF0 	;; WRITE FX FUNCTION @ CURRENT Pos to Fx RAM
	
		;; ------------------[PERFORM CYCLE or Exit READ CYCLE]------------------
		;; ----------------------------------------------------------------------
		incf VAR_Fx_LOAD_WRITE_ADR_COUNTER_TMP, F 	;; FX TAB POS = POS +1 | POS RANGE 0 to 31 [32 pos]
		
		;; CHECK: 
		;; FX TAB POS = 32 [RANGE = 0 to 31]?
		movlw 	FX_POS_MAX_PLUS1 				;; dec 31+1
		cpfseq 	VAR_Fx_LOAD_WRITE_ADR_COUNTER_TMP
			
			;; < 32
			;; write 32x
			goto EEPROM_PATCH_DO_LOAD_FX_FUNC
		
			;; Pos = 32 
			;; RESET POS and EXIT THIS CYCLE
			clrf  VAR_Fx_LOAD_WRITE_ADR_COUNTER_TMP	;; reset pos
		;; ----------[PERFORM CYCLE or Exit READ CYCLE]----
			
;; -----------[END: LOAD Fx Function (Pos 0-31)]-------------------

;; -----------[LOAD Fx DATA (Pos 0-31)]----------------------------
EEPROM_PATCH_LOAD_FX_DATA_FROM_EEPROM
	;; LOAD Fx DATA BYTES CYCLE - DO 32x
 	movlw	EEPROM_OFFSET_FX_DATA					;; EEPROM OFFSET (!)
	addwf	VAR_Fx_LOAD_WRITE_ADR_COUNTER_TMP, W	;; OFFSET + POS
	movwf	EEADR 									;; SET EEPROM ADRESS [OFFSET+POS]
	call	MIOS_EEPROM_Read       ;; READ FX FUNCTION @ CURRENT Pos of PIC EEPROM (EEADR will be incremented)
	movwf   VAR_TMP_PATCH_DATA_CLIPBOARD      ;; WRITE FX FUNCTION @ CURRENT Pos TO MIOS_PARAMETER2
 	
 	;; WRITE FX FUNCTION @ CURRENT Fx Pos to PIC RAM
 	movlw	RAM_OFFSET_FX_DATA						;; Fx RAM AREA OFFSET (!)
 	addwf   VAR_Fx_LOAD_WRITE_ADR_COUNTER_TMP, W    ;; + (0 to 31 [32]) => Fx Tab Pos
	movwf   FSR0L		        					;; LOAD CURRENT OFFSET IND. ADR. for Fx Fuction Reg. @ current Fx Pos.
 	movff   VAR_TMP_PATCH_DATA_CLIPBOARD, INDF0 	;; WRITE FX FUNCTION @ CURRENT Pos to Fx RAM

		incf VAR_Fx_LOAD_WRITE_ADR_COUNTER_TMP, F 	;; pos = pos +1 | pos range 0 to 31 [32 pos gesamt]
		
		;; check if pos = 32 [range = 0 to 31]
		movlw 	FX_POS_MAX_PLUS1 ;; dec 31+1
		cpfseq VAR_Fx_LOAD_WRITE_ADR_COUNTER_TMP
			
			;; < 32
			;; write 32x
			;; DO ANOTHER CYCLE
			goto EEPROM_PATCH_LOAD_FX_DATA_FROM_EEPROM
			
			;; = 32
			;; QUIT THE CYCLE
			;; GO ON LOAD Fx Pre Exec. Time
			clrf  VAR_Fx_LOAD_WRITE_ADR_COUNTER_TMP	;; reset pos; 	

;; -----------------------------[END: LOAD Fx Function (Pos 0-31)]-------------------
			

;; -----------------------------[LOAD Fx TIME (Pos 0-31)]----------------------------
EEPROM_PATCH_LOAD_FX_TIME_FROM_EEPROM
	;; LOAD Fx Pre Exec. Time BYTES - DO CYCLE 32x	
 	movlw	EEPROM_OFFSET_FX_TIME_PRE_EXECUTION		;; EEPROM OFFSET (!)
	addwf	VAR_Fx_LOAD_WRITE_ADR_COUNTER_TMP, W	;; OFFSET + POS
	movwf	EEADR 									;; SET EEPROM ADRESS [OFFSET+POS]
	call	MIOS_EEPROM_Read        				;; READ FX FUNCTION @ CURRENT Pos of PIC EEPROM (EEADR will be incremented)
	movwf	VAR_TMP_PATCH_DATA_CLIPBOARD       		;; WRITE FX FUNCTION @ CURRENT Pos TO MIOS_PARAMETER2
 
 	;; WRITE FX FUNCTION @ CURRENT Fx Pos to PIC RAM
 	movlw	RAM_OFFSET_FX_TIME_PRE_EXECUTION      	;; Fx RAM AREA OFFSET (!)
 	addwf   VAR_Fx_LOAD_WRITE_ADR_COUNTER_TMP, W    ;; + (0 to 31 [32]) => Fx Tab Pos
	movwf   FSR0L		        					;; LOAD CURRENT OFFSET IND. ADR. for Fx Fuction Reg. @ current Fx Pos.
 	movff   VAR_TMP_PATCH_DATA_CLIPBOARD, INDF0 	;; WRITE FX FUNCTION @ CURRENT Pos to Fx RAM

		incf VAR_Fx_LOAD_WRITE_ADR_COUNTER_TMP, F 	;; pos = pos +1 | pos range 0 to 31 [32 pos gesamt]
		;; check if pos = 32 [range = 0 to 31]
		movlw FX_POS_MAX_PLUS1 ;; dec 31+1
		cpfseq VAR_Fx_LOAD_WRITE_ADR_COUNTER_TMP
			;; < 32
			;; write 32x
			goto EEPROM_PATCH_LOAD_FX_TIME_FROM_EEPROM
			;; = 32
			;; GO AND WRITE "L: OK" on LCD Row 4
			;; AND THEN WRITE PATCH NAME ON LCD ROW 1
			goto PATCH_LOAD_OK
;; --------------------------------------------------------------------------------------------------
;; -----------[END: LOAD Fx Functions from INTERNAL PATCH (PIC EEPROM) (Pos 0-31)]-------------------
;; --------------------------------------------------------------------------------------------------


;; --------------------------------------------------------------------------------------------------
;; -----------[START: LOAD Fx Functions from BANKSTICK (Pos 0-31)]-----------------------------------
;; --------------------------------------------------------------------------------------------------
BANKSTICK_PATCH_LOAD_FX_FUNC_FROM_BANKSTICK
	;; LOAD Fx FUNCTION BYTES CYCLE - DO 32x
	;; LOAD FX FUNCTIONS @ from BANKSTICK to PIC RAM
	;; -----------------------------------------------------------------
 	movlw	CONST_BANKSTICK_PATCH_OFFSET_FX_FUNCTION	;; Fx AREA - BANKSTICK OFFSET (!)
	addwf	VAR_Fx_LOAD_WRITE_ADR_COUNTER_TMP, W			;; OFFSET + POS
	;; store BANKSTICK low-byte of address in MIOS_PARAMETER1
	movwf    MIOS_PARAMETER1
	;; store BANKSTICK high-byte of address in MIOS_PARAMETER2
	movff   BNKD_VAR_BROWSE_PATCH_NR, MIOS_PARAMETER2
	decf	MIOS_PARAMETER2, F				;; ADR (HI BYTE) BS PATCH = CURRENT PATCH NR -1
	;; READ BYTE @ BANKSTICK
	call	MIOS_BANKSTICK_Read    			;; READ FX FUNCTION @ from BANKSTICK 
 	movwf   VAR_TMP_PATCH_DATA_CLIPBOARD    ;; WRITE FX FUNCTION @ TO TMP
 	;; --------------------------------------------------------------------
 	;; ------[ WRITE FX FUNCTION @ CURRENT Fx Pos ==> to PIC RAM ]---------
 	;; --------------------------------------------------------------------
	movlw	CONST_RAM_ADR_OFFSET_FX_FUNCTION					;; Fx RAM AREA OFFSET (!)
 	addwf   VAR_Fx_LOAD_WRITE_ADR_COUNTER_TMP, W      	;; + (0 to 31 [32]) => Fx Tab Pos
	movwf   FSR0L		        					;; LOAD CURRENT OFFSET IND. ADR. for Fx Fuction Reg. @ current Fx Pos.
 	movff   VAR_TMP_PATCH_DATA_CLIPBOARD, INDF0 				;; WRITE FX FUNCTION @ CURRENT Pos to Fx RAM
		;; ----------[PERFORM CYCLE or Exit READ CYCLE]----
		;; ------------------------------------------------
		incf VAR_Fx_LOAD_WRITE_ADR_COUNTER_TMP, F ;; pos = pos +1 | pos range 0 to 31 [32 pos]
		;; check if pos = 32 [range = 0 to 31]
		movlw 	FX_POS_MAX_PLUS1 ;; dec 31+1
		cpfseq 	VAR_Fx_LOAD_WRITE_ADR_COUNTER_TMP
			;; < 32
			;; write 32x
			goto BANKSTICK_PATCH_LOAD_FX_FUNC_FROM_BANKSTICK
			;; Pos = 32 
			;; RESET POS and EXIT THIS CYCLE
			clrf  VAR_Fx_LOAD_WRITE_ADR_COUNTER_TMP	;; reset pos
		;; ----------[PERFORM CYCLE or Exit READ CYCLE]----
;; -----------[END: LOAD Fx Function (Pos 0-31)]-------------------

;; -----------[LOAD Fx DATA (Pos 0-31)]-------------------
BANKSTICK_PATCH_LOAD_FX_DATA_FROM_BANKSTICK
	;; LOAD Fx DATA BYTES CYCLE - DO 32x
 	;; -----------------------------------------------------------------
 	movlw	BANKSTICK_OFFSET_FX_DATA				;; Fx AREA - BANKSTICK OFFSET (!)
	addwf	VAR_Fx_LOAD_WRITE_ADR_COUNTER_TMP, W	;; OFFSET + POS
	; store BANKSTICK low-byte of address in MIOS_PARAMETER1
	movwf   MIOS_PARAMETER1
    ; store BANKSTICK high-byte of address in MIOS_PARAMETER2
    movff   BNKD_VAR_BROWSE_PATCH_NR, MIOS_PARAMETER2
    decf	MIOS_PARAMETER2, F						;; ADR (HI BYTE) BS PATCH = CURRENT PATCH NR -1
    ;; READ BYTE @ BANKSTICK
    call    MIOS_BANKSTICK_Read    					;; READ FX FUNCTION BYTE from BANKSTICK
 	movwf   VAR_TMP_PATCH_DATA_CLIPBOARD       		;; WRITE FX FUNCTION TO TMP
 	;; ------------------------------------------------------------------------------
 	;; WRITE FX FUNCTION @ CURRENT Fx Pos to PIC RAM
 	movlw	RAM_OFFSET_FX_DATA						;; Fx RAM AREA OFFSET (!)
 	addwf   VAR_Fx_LOAD_WRITE_ADR_COUNTER_TMP, W    ;; + (0 to 31 [32]) => Fx Tab Pos
	movwf   FSR0L		        					;; LOAD CURRENT OFFSET IND. ADR. for Fx Fuction Reg. @ current Fx Pos.
 	movff   VAR_TMP_PATCH_DATA_CLIPBOARD, INDF0 	;; WRITE FX FUNCTION @ CURRENT Pos to Fx RAM
	
		;; READ CYCLE MANAGEMENT	
		incf VAR_Fx_LOAD_WRITE_ADR_COUNTER_TMP, F ;; pos = pos +1 | pos range 0 to 31 [32 pos gesamt]
		
		;; check if pos = 32 [range = 0 to 31]
		movlw 	FX_POS_MAX_PLUS1 ;; dec 31+1
		cpfseq VAR_Fx_LOAD_WRITE_ADR_COUNTER_TMP
			
			;; < 32
			;; write 32x
			;; DO ANOTHER CYCLE
			goto BANKSTICK_PATCH_LOAD_FX_DATA_FROM_BANKSTICK
			
			;; = 32
			;; QUIT THE CYCLE
			;; GO ON LOAD Fx Pre Exec. Time
			clrf  VAR_Fx_LOAD_WRITE_ADR_COUNTER_TMP	;; reset pos; 	

;; -----------------------------[END: LOAD Fx Function (Pos 0-31)]-------------------
			

;; -----------------------------[LOAD Fx TIME (Pos 0-31)]----------------------------
BANKSTICK_PATCH_LOAD_FX_TIME_FROM_BANKSTICK
	;; LOAD Fx Pre Exec. Time BYTES - DO CYCLE 32x	
 	;; -----------------------------------------------------------------
 	movlw	BANKSTICK_OFFSET_FX_TIME_PRE_EXECUTION	;; Fx AREA - BANKSTICK OFFSET (!)
	addwf	VAR_Fx_LOAD_WRITE_ADR_COUNTER_TMP, W		;; OFFSET + POS
	; store BANKSTICK low-byte of address in MIOS_PARAMETER1
	movwf    MIOS_PARAMETER1
    ;; store BANKSTICK high-byte of address in MIOS_PARAMETER2
    movff   BNKD_VAR_BROWSE_PATCH_NR	, MIOS_PARAMETER2
    decf	MIOS_PARAMETER2, F			;; ADR (HI BYTE) BS PATCH = CURRENT PATCH NR -1
        ;; READ BYTE @ BANKSTICK
        call    MIOS_BANKSTICK_Read    	;; READ FX FUNCTION BYTE from BANKSTICK
 		movwf   VAR_TMP_PATCH_DATA_CLIPBOARD       ;; WRITE FX FUNCTION TO TMP
 	;; ------------------------------------------------------------------------------
  	;; WRITE FX FUNCTION @ CURRENT Fx Pos to PIC RAM
 	movlw	RAM_OFFSET_FX_TIME_PRE_EXECUTION    ;; Fx RAM AREA OFFSET (!)
 	addwf   VAR_Fx_LOAD_WRITE_ADR_COUNTER_TMP, W    ;; + (0 to 31 [32]) => Fx Tab Pos
	movwf   FSR0L		        				;; LOAD CURRENT OFFSET IND. ADR. for Fx Fuction Reg. @ current Fx Pos.
 	movff   VAR_TMP_PATCH_DATA_CLIPBOARD, INDF0 			;; WRITE FX FUNCTION @ CURRENT Pos to Fx RAM
	
		incf VAR_Fx_LOAD_WRITE_ADR_COUNTER_TMP, F ;; pos = pos +1 | pos range 0 to 31 [32 pos gesamt]
		
		;; check if pos = 32 [range = 0 to 31]
		movlw FX_POS_MAX_PLUS1 ;; dec 31+1
		cpfseq VAR_Fx_LOAD_WRITE_ADR_COUNTER_TMP
			
			;; < 32
			;; write 32x
			goto BANKSTICK_PATCH_LOAD_FX_TIME_FROM_BANKSTICK
			
			;; = 32
			;; GO AND WRITE "L: OK" on LCD Row 4
			;; AND THEN WRITE PATCH NAME ON LCD ROW 1
			goto PATCH_LOAD_OK
;; --------------------------------------------------------------------------------
;; -------[END: LOAD Fx Functions from BANKSTICK (Pos 0-31)]-----------------------
;; --------------------------------------------------------------------------------

			;; exit here
			return

;; -------------------------------------------------------------------------------
;; -------------------------[START SUB ROUTINE: LOAD FX DATA]---------------------
;; -------------------------------------------------------------------------------


;; -------------------------------------------------------------------------------
;; ----------------------------------------[ERROR MESSAGE]------------------------
;; ------------------------------------- LOAD or WRITE FAILED --------------------

PATCH_DATA_LOADING_Failed
	;; ERROR - SORRY, NO PATCH WAS LOADED :-(
	;; Load ERROR SHOW on LCD ROW4
	;; Load ERROR SHOW on LCD ROW1
	TABLE_ADDR LCD_CLEAR_ROW1
	call    MIOS_LCD_PrintString
	TABLE_ADDR  TEXT_AY_MB_AY_NO_PATCH
	call    MIOS_LCD_PrintString
	
	;; Load ERROR SHOW on LCD ROW4
	TABLE_ADDR LCD_CLEAR_ROW4
	call    MIOS_LCD_PrintString
	TABLE_ADDR  TEXT_AY_MB_AY_PATCH_ERROR
	call    MIOS_LCD_PrintString
	;; EXIT	AFTER ERROR MESSAGE
	return

;; ----------------------------------------[ERROR MESSAGE]-----------------------------------
;; ------------------------------------- LOAD or WRITE FAILED -------------------------------

