;; FUNCTION:
;; WRITE A PATCH to PIC Eeprom PATCH OR Bankstick PATCH 

PATCH_WRITE_ROUTINE
	;; CHECK: MAIN MENU = 1 ?
	movlw	CONST_MAIN_MENU_01
	cpfseq 	VAR_CURRENT_MAIN_MENU
		;; -----[STATE: NOT MENU1            ]-------------------------------------------------------
		;; Exit Here
		return
	
		;; -----[STATE: MENU1 IS SELECTED                          ]---------------------------------
		;; -----[CHECK: CURRENT PATCH = EEPROM or BANKSTICK PATCH? ]---------------------------------
		;; DO WE HAVE TO WRITE to EEPROM or BANKSTICK?...
		;; CHECK VIA BNKD_VAR_PATCH_STATE_FLAGS
		;; BIT2 = CLR = WRITE EEPROM PATCH (PIC INTERNAL PATCH)
		;; BIT2 = SET = WRITE BANKSTICK PATCH
		movff	BNKD_VAR_PATCH_STATE_FLAGS, VAR_TMP_RAM_BYTE_COPY_CLIPBOARD
		btfss	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, BIT2_IF_SET_BS_PATCH_IS_SELECTED
				;; -----[STATE: SELECTED PATCH = PIC EEPROM PATCH]-----------------------------------
				;; -----[STATE: BIT2 = CLEAR                     ]-----------------------------------
				;; -----[NEXT : WRITE EEPROM PATCH               ]-----------------------------------
				;; MEMO:
				;; THE USER WANT TO WRITE A PATCH TO PIC EEPROM (INTERNAL PATCH)
				;; NO FUTHER CHECKING NEEDED - GO AND WRITE THE PATCH DATA 
				;; TO PIC EEPROM (PATCH NUMBER 0)
				goto DO_STORE_PATCH_ON_PIC_EEPROM_OR_BANKSTICK
				;; ----------------------------------------------------------------------------------

		;; -------------[STATE: USER SELECTED A BANKSTICK PATCH]-------------------------------------
		;; -------------[CHECK: BANKSTICK AVAILABLE?            ]------------------------------------
		movff	BNKD_VAR_PATCH_STATE_FLAGS, VAR_TMP_RAM_BYTE_COPY_CLIPBOARD
		btfss	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, BIT0_BANKSTICK_FOUND
					
			;; -[STATE: BANKSTICK NOT AVAILABLE         ]---------------------------------------------
			;; -[DO: EXIT HERE                          ]---------------------------------------------
			;; EXIT HERE
			return

			;; -[STATE:  BANKSTICK IS AVAILABLE         ]---------------------------------------------
			;; -[DO GO ON                               ]---------------------------------------------

	;; -------------[CHECK: BANKSTICK FORMAT MODE = ON? ]---------------------------------------------
	movff	BNKD_VAR_PATCH_STATE_FLAGS, VAR_TMP_RAM_BYTE_COPY_CLIPBOARD
	btfsc	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, BIT3_FORMAT_BANKSTICK_MODE_ON	
			;; -----[STATE: BIT3 = SET           ]---------------------------------------------------
			;; -----[STATE: BS FORMAT MODE = ON  ]---------------------------------------------------
			;; -----[GO AND DO FOARMAT BANKSTICK ]---------------------------------------------------
			;; -----[SEE @ format_bankstick.inc  ]---------------------------------------------------
			goto PATCH_WRITE_DO_FORMAT_BANKSTICK

		;; ---------[STATE: BIT3 = CLR                          ]------------------------------------
		;; ---------[STATE: THE "FORMAT BANKSTICK" MODE IS OFF  ]------------------------------------
		;; ---------[NEXT : DO CHECK IF BANKSTICK IS FORMATTED  ]------------------------------------

;; -----------------[STATE: SELECTED PATCH = BANKSTICK PATCH    ]------------------------------------
;; -----------------[STATE: BANKSTICK is AVAILABLE              ]------------------------------------
;; -----------------[STATE: "DO FORAMT BANKSTICK MODE" is OFF   ]------------------------------------
;; -----------------[CHECK: BANKSTICK FORMATTED?                ]------------------------------------ 
	movff	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, BNKD_VAR_PATCH_STATE_FLAGS
	btfss	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, BIT1_FINGERPRINT_FOUND
		;; ------------------[STATE: NO                               ]------------------------------
		;; ------------------[STATE: BIT1 = CLR                       ]------------------------------
		;; ------------------[STATE: BS IST NOT FORMATTED             ]------------------------------
		;; ------------------[STATE: SO WE CAN NOT WRITE PATCH TO BS  ]------------------------------
		;; ------------------[DO   : JUST EXIT HERE                   ]------------------------------
		return

		;; ------------------[STATE: YES                                  ]--------------------------
		;; ------------------[STATE: BIT1 = SET                           ]--------------------------
		;; ------------------[STATE: BANKSTICK IS FORMATTED               ]--------------------------
		;; ------------------[DO   : WRITE PATCH DATA TO BANKSTICK        ]--------------------------

;; --------------------------------------------------------------------------------------------------
;; -------------[STATE: SELECTED PATCH = BANKSTICK PATCH  ]------------------------------------------
;; -------------[STATE: BANKSTICK is AVAILABLE            ]------------------------------------------
;; -------------[STATE: DO FORAMT BANKSTICK MODE is OFF   ]------------------------------------------
;; -------------[STATE: BANKSTICK IS FORMATTED            ]------------------------------------------
;; -------------[DO   : WRITE DATA to BANKSTICK PATCH     ]------------------------------------------
;; --------------------------------------------------------------------------------------------------
DO_STORE_PATCH_ON_PIC_EEPROM_OR_BANKSTICK
;; MEMO:
;; ALSO JUMP IN POINT FROM BANKSTICK FORMAT SUBROUTINE (format_bankstick.inc)
	
	;; ------------------------------------------------------------------------------
	;; -------------------------[Write PATCH Fingerprint]----------------------------
	;; ------------------------------------------------------------------------------
	;; WRITE the FINGERPRINT BYTE TO PIC EEPROM (INTERNAL PATCH) or BANKSTICK PATCH [1-127]
	call 	SUB_ROUTINE_DO_WRITE_PATCH_FINGERPRINT	
	
	;; ------------------------------------------------------------------------------
	;; -------------------------[Write PATCH NAME]-----------------------------------
	;; ------------------------------------------------------------------------------
	;; DO STORE THE PATCH NAME IN CURRENT BS OR EEPROM PATCH 
	call	SUB_ROUTINE_WRITE_PATCH_NAME

	;; ------------------------------------------------------------------------------
	;; -------------------------[Write PATCH DATA]-----------------------------------
	;; ------------------------------------------------------------------------------
	;; STORE PATCH DATA (NO ASC NAME, NO FX, NO FINGERPRINT, NO BS PATCH NUMBER)
	call	SUB_ROUTINE_WRITE_PATCH_DATA

	;; ------------------------------------------------------------------------------
	;; -------------------------[Write PATCH Fx DATA]--------------------------------
	;; ------------------------------------------------------------------------------
	;; DO STORE PATCH DATA
	call	SUB_ROUTINE_WRITE_CURRENT_PATCH_FX_DATA
	
	
	
	;; --------------------------------------------------------------------------
	;; ----[AFTER WRITING THE PATCH THE CURRENT PATCH = = THE BROWSE PATCH]------ 
	;; --------------------------------------------------------------------------
	movff	BNKD_VAR_BROWSE_PATCH_NR, BNKD_VAR_CURRENT_PATCH_NR
	;; --------------------------------------------------------------------------		


	;; ------------------------------------------------------------------------------
	;; ------------[STATE: A PATCH HAD BEEN WRITTEN TO BANKSTICK or PIC EEPROM]------
	;; ------------[       OR A BANKSTICK PATCH HAD BEEN FORMATTED            ]------
	;; ------------------------------------------------------------------------------
	;; ------------------------------------------------------------------------------


	;; MEMO:
	;; WE NEED TO KNOW whether a FORMATTING PROCESS IS RUNNING OR NOT
	;; IF THE BANKSTICK FORMATTING PROCESS IS RUNNING LET'S FORMAT ANOTHER
	;; BANKSTICK PATCH TILL ALL BS PATCHES ARE FORMATTED - BUT IF THE USER STORED A 
	;; PATCH TO INTERNAL EEPROM or BANKSTICK THE "DO FORMAT BANKSTICK" BIT = OFF
	;; IN THIS CASE WE CAN GO ON WITH A LCD "OK" MESSAGE on LCD ROW4

	;; CHECK:
	;; IS THE "DO FORMAT BANKSTICK MODE" BIT = SET (ON) or CLR (OFF)
	movff	BNKD_VAR_PATCH_STATE_FLAGS, VAR_TMP_RAM_BYTE_COPY_CLIPBOARD
	btfss	VAR_TMP_RAM_BYTE_COPY_CLIPBOARD, BIT3_FORMAT_BANKSTICK_MODE_ON
			
		;; -------[STATE: FORMAT MODE = OFF                         ]---------
		;; -------[STATE: BNKD_VAR_PATCH_STATE_FLAGS BIT3 = CLR]---------
		;; -------[STATE: DO NOT FORMAT THE CURRENT BANKSTICK       ]---------
		;; -------[NEXT: GO AND WRITE "OK" on LCD                   ]---------
		goto PRINT_STATUS_PATCH_WRITING_OK_ON_LCD
			
		;; -------[STAE: FORMAT MODE = ON  ]----------------------------------
		;; -------------------------------------------------------------------
		;; MEMO:
		;; THIS IS THE JUMP OUT POINT FOR THE BANKSTICK FORMAT SUBROUTINE 
		;; SEE @ format_bankstick.inc
			
		
		;; -------------------------------------------------------------------
		;; --[STATE: BNKD_VAR_PATCH_STATE_FLAGS BIT3 = SET ]-------------
		;; --[STATE: FORMAT MODE = ON                           ]-------------
		;; --[DO: ANOTHER FORRMAT BANKSTICK CYCLE               ]-------------
		;; -------------------------------------------------------------------
		;; --[DO:    WAIT CYCLES for BANKSTICK FORMATTING       ]-------------
		;; --[DO:    Wait for 120 ms                            ]-------------
		;; NOTICE:
		;; THIS DELAY IS NEEDED FOR WRITING ALL PATCHES AT ONCE 
		;; THE PATCH DATA HAS TO BE WRITTEN 127 times
		;; WITHOUT THIS DELAY MIOS WILL CRASH AND REBOOT (!)
				;;	CS HANDLING:
				;;	DO A LITTLE F8 LED FLICKERING @ BS FORMATTING PROCESS
				call	LED_F8_on
		movlw	60
		call    MIOS_Delay
				;;	CS HANDLING:
				;;	DO A LITTLE F8 LED FLICKERING @ BS FORMATTING PROCESS
				call	LED_F8_off
		movlw	60				
		call    MIOS_Delay
		;; --------------------------------------------------------------------
		;; --------------------------------------------------------------------

		;; --------------------------------------------------------------------
		;; --[DO: GO ON AND FORMAT ANOTHER BANKSTICK PATCH      ]--------------
		;; MEMO:
		;; MORE INFORMATION @ format_bankstick.inc
		goto PATCH_WRITE_DO_FORMAT_BANKSTICK
		;; --------------------------------------------------------------------
		

PRINT_STATUS_PATCH_WRITING_OK_ON_LCD	
	;; ------------------------------------------------------------------------------
	;; ------------[STATE: A PATCH HAD BEEN WRITTEN               ]------------------
	;; ------------[STATE: BS FORMATTING MODE = OFF               ]------------------
	;; ------------------------------------------------------------------------------
	;; ------------------------------------------------------------------------------
	
 	;; CS HANDLING
	call	LED_F1_off
	call	LED_F2_off
	call	LED_F8_off
	

	;; CLR LCD ROW 3
	TABLE_ADDR LCD_CLEAR_ROW3
	call MIOS_LCD_PrintString
	
	;; DO PRINT ON LCD ROW 4
	;; "SAVE: OK" INFO 
	;; BECAUSE THE PATCH WRITING WAS SUCCSESSFULL! :-)
	TABLE_ADDR LCD_CLEAR_ROW4
	call    MIOS_LCD_PrintString
	TABLE_ADDR TEXT_AY_MB_AY_PATCH_WRITE_OK
	call    MIOS_LCD_PrintString
		
	;; CLEAR THE =>!<= @ ROW1
	;; PERHAPS THERE WAS A: =>!<= [PATCH NAME] ON LCD ROW1 
	;; LETS CLEAR THE "!"
	;; BECAUSER NOW THE WRITTEN PATCH HAS BECOME THE *CURRENT PATCH*
	;; SO NOW THE CURRENT PATCH = BROWSE PATCH
	movlw   LCD_ROW1 + 6
    call    MIOS_LCD_CursorSet
	movlw   ' '
	call    MIOS_LCD_PrintChar	
		
	;; PATCH HAD BEEN WRITTEN SO SET BIT 4
	call	SET_FLAG_PATCH_HAS_BEEN_WRITTEN_OR_LOADED

	;; DO A LITTLE DELAY THAT THE USER CAN READ THE LCD
	clrf	VAR_TMP_PATCH_DATA_CLIPBOARD
PATCH_WRITE_DO_DELAY_FOR_LCD
	movlw   255
    call	MIOS_Delay
    incf	VAR_TMP_PATCH_DATA_CLIPBOARD, F
    movlw	0x06	;; DO THE "HOW LONG" TIME JUSTAGE HERE 
    cpfsgt	VAR_TMP_PATCH_DATA_CLIPBOARD
		;; DO DELAY CYCLE
		goto	PATCH_WRITE_DO_DELAY_FOR_LCD
		
		;; RENEW / WRITE MENU1 on LCD
		goto MENU_01_PATCH
	;; ------------------------------------------------------------------------------
	;; ------------------------------------------------------------------------------
	;; ------------------------------------------------------------------------------
	;; ------------------------------------------------------------------------------



