; $Id: tia_wt.inc 111 2008-02-22 00:41:21Z tk $
;
; MIDIbox TIA
; Wavetable Sequencer
;
; MEMO - when MIDI sync is enabled, following WT clock rates are usefull:
;  126:	8 steps = 1/4 note
;  123:	8 steps = 1/2 note
;  117:	8 steps = 1 note
;
; ==========================================================================
;
;  Copyright 1998-2006 Thorsten Klose (tk@midibox.org)
;  Licensed for personal non-commercial use only.
;  All other rights reserved.
; 
; ==========================================================================

;; --------------------------------------------------------------------------
;;  TIA Wavetable Handler
;; --------------------------------------------------------------------------
TIA_WT_Handler
	SET_BSR	TIA_BASE			; init BSR

	;; switch to WT patch
	movff	TIA_PATCH, TIA_WT_SAVED_PATCH
	movff	TIA_WT_PATCH, TIA_PATCH

	;; exit handler if wavetable rate == 0
	movf	TIA_WT_RATE, W, BANKED
	skpnz
	rgoto	TIA_WT_End

	;; reset requested?
	BRA_IFCLR TIA_WT_STATE, WT_STATE_RESET, BANKED, TIA_WT_NoReset
TIA_WT_Reset
	bcf	TIA_WT_STATE, WT_STATE_RESET, BANKED
	bcf	TIA_WT_STATE, WT_STATE_STOP, BANKED
	bcf	TIA_WT_STATE, WT_STATE_SLIDE, BANKED
	bcf	TIA_WT_STATE, WT_STATE_SLIDE_PREV, BANKED
	clrf	TIA_WT_303_TICK_CTR, BANKED

	;; clear counter & position and request first entry
	IRQ_DISABLE
	BRA_IFCLR TIA_MIDI_SYNC, TIA_MIDI_SYNC_WT_ARP, BANKED, TIA_WT_Handler_IntClk
TIA_WT_Handler_ExtClk
	comf	TIA_WT_RATE, W, BANKED
	andlw	0x7f
	btfss	TIA_SE_OPTION, SE_OPTION_TB303, BANKED
	addlw 1
	movwf	TIA_WT_CTR, BANKED	
	rgoto	TIA_WT_Handler_ExtClk_C
TIA_WT_Handler_IntClk
	comf	TIA_WT_RATE, W, BANKED	; copy inverted rate * 2 into CTR register
	movwf	TIA_WT_CTR, BANKED
	clrc
	rlf	TIA_WT_CTR, F, BANKED
TIA_WT_Handler_ExtClk_C
	clrf	TIA_WT_POS, BANKED
	movlw	0x01
	movwf	TIA_WT_CLK_REQ_CTR, BANKED
	IRQ_ENABLE
TIA_WT_NoReset


	;; handle all requested clocks
TIA_WT_NextClkLoop
	movf	TIA_WT_CLK_REQ_CTR, W, BANKED
	bz	TIA_WT_End
	BRA_IFSET TIA_WT_STATE, WT_STATE_STOP, BANKED, TIA_WT_End
	decf	TIA_WT_CLK_REQ_CTR, F, BANKED

	;; get first entry
	rcall	TIA_WT_Hlp_CalcPos
	call	TIA_BANK_Read
	movwf	TMP4
TIA_WT_Loop
	;; branch depending on entry ID
	movf	TMP4, W
	andlw	0x03
	JUMPTABLE_2BYTES_UNSECURE
	rgoto	TIA_WT_Branch_Inc
	rgoto	TIA_WT_Branch_Play
	rgoto	TIA_WT_Branch_Goto
	rgoto	TIA_WT_Branch_End
	
TIA_WT_Branch_Play
	;; send MIDI clock if enabled for synchronization of external sequencers or similar
	movlw	0xf8
	CALL_IFSET TIA_MIDI_SYNC, TIA_MIDI_SYNC_SEND_CLK, BANKED, MIOS_MIDI_TxBufferPut
	SET_BSR	TIA_BASE
    
#if 0
	BRA_IFCLR TIA_SE_OPTION, SE_OPTION_TB303, BANKED, TIA_WT_Branch_Play_NotTB303
TIA_WT_Branch_Play_TB303
	;; in TB303 mode:
	;; increment tick counter, reset if counter >= 6
	incf	TIA_WT_303_TICK_CTR, F, BANKED
	movlw	0x6
	cpfslt	TIA_WT_303_TICK_CTR, BANKED
	clrf	TIA_WT_303_TICK_CTR, BANKED

	;; play note when counter-1 == 0
	decf	TIA_WT_303_TICK_CTR, W, BANKED
	bz	TIA_WT_Branch_Play_TB303Note
	;; release gate when counter-1 == 3
	decf	TIA_WT_303_TICK_CTR, W, BANKED
	xorlw	3
	bz	TIA_WT_Branch_Play_TB303G0
	rgoto	TIA_WT_NextClkLoop

TIA_WT_Branch_Play_TB303G0
	IRQ_DISABLE
	;; exception: don't clear when slide is active
	BRA_IFCLR TIA_WT_STATE, WT_STATE_SLIDE, BANKED, TIA_WT_Branch_Play_TB303G0_Clr
TIA_WT_Branch_Play_TB303G0_Slide
	bsf	TIA_WT_STATE, WT_STATE_SLIDE_PREV, BANKED
	rgoto	TIA_WT_Branch_Play_TB303G0_End

TIA_WT_Branch_Play_TB303G0_Clr
	bcf	TIA_WT_STATE, WT_STATE_SLIDE_PREV, BANKED
	bcf	TIA_V1_BASE + TIA_Vx_MODE, TIA_Vx_MODE_GATE_SET_REQ, BANKED
	bsf	TIA_V1_BASE + TIA_Vx_MODE, TIA_Vx_MODE_GATE_CLR_REQ, BANKED
	;; 	rgoto	TIA_WT_Branch_Play_TB303G0_End

TIA_WT_Branch_Play_TB303G0_End
	IRQ_ENABLE
	rgoto	TIA_WT_NextClkLoop
TIA_WT_Branch_Play_TB303Note
TIA_WT_Branch_Play_NotTB303

	;; disable interrupts until all tracks have been handled!
	IRQ_DISABLE

	;; first parameter
	call	TIA_BANK_Read
	movwf	TMP2

	BRA_IFCLR TIA_SE_OPTION, SE_OPTION_TB303, BANKED, TIA_WT_Branch_PlayP1_NotTB303
TIA_WT_Branch_PlayP1_TB303
	;; set gate flag
	bcf	TIA_WT_STATE, WT_STATE_GATE, BANKED
	btfsc	TMP2, 4
	bsf	TIA_WT_STATE, WT_STATE_GATE, BANKED

	;; slide flag
	bcf	TIA_WT_STATE, WT_STATE_SLIDE, BANKED
	btfsc	TMP2, 5
	bsf	TIA_WT_STATE, WT_STATE_SLIDE, BANKED

	;; set accent flag of voice 1 if velocity >= 8
	bcf	TIA_V1_BASE + TIA_Vx_MODE, TIA_Vx_MODE_ACCENT
	btfsc	TMP2, 3
	bsf	TIA_V1_BASE + TIA_Vx_MODE, TIA_Vx_MODE_ACCENT

	;; modify sustain if gate flag set and no active slide (which wouldn't retrigger the gate)
	BRA_IFCLR TIA_WT_STATE, WT_STATE_GATE, BANKED, TIA_WT_Branch_Play_TB303NoteNSus
	BRA_IFSET TIA_WT_STATE, WT_STATE_SLIDE_PREV, BANKED, TIA_WT_Branch_Play_TB303NoteNSus
	BRA_IFSET TIA_SE_OPTION, SE_OPTION_GSA, BANKED, TIA_WT_Branch_Play_TB303NoteNSus
TIA_WT_Branch_Play_TB303NoteSus
	;; 0x08 + accent/2
	rlf	TMP2, W
	rlf	WREG, W
	addlw	0x08
	andlw	0x78

	movwf	TMP2
	movlw	57		; CC#57: Voice 1 Sustain
	movwf	TMP3
	rcall	TIA_WT_Hlp_Play_P_Cont
TIA_WT_Branch_Play_TB303NoteNSus
	rgoto	TIA_WT_Branch_PlayP1_TB303Cont
    
#endif

TIA_WT_Branch_PlayP1_NotTB303
	btfsc	TMP4, 4
	bsf	TMP2, 7
	movf	TIA_ASSIGN_WT_P1, W, BANKED
	skpz
	rcall	TIA_WT_Hlp_Play_P
TIA_WT_Branch_PlayP1_TB303Cont

	;; second parameter
	bsf	TIA_WT_STATE, WT_STATE_PLAY_2ND, BANKED	; will only be used in TB303 mode
	call	TIA_BANK_Read
	movwf	TMP2
	btfsc	TMP4, 5
	bsf	TMP2, 7
	;; in TB303 mode: always assigned to CC#9 (play note of voice 1)
	movlw	9
	BRA_IFSET TIA_SE_OPTION, SE_OPTION_TB303, BANKED, TIA_WT_Branch_PlayP2_TB303
	;; else play assigned parameter
	movf	TIA_ASSIGN_WT_P2, W, BANKED
	bz	TIA_WT_Branch_PlayP2_Skip
TIA_WT_Branch_PlayP2_TB303
	rcall	TIA_WT_Hlp_Play_P
TIA_WT_Branch_PlayP2_Skip

	;; third parameter
	call	TIA_BANK_Read
	movwf	TMP2
	btfsc	TMP4, 6
	bsf	TMP2, 7
	movf	TIA_ASSIGN_WT_P3, W, BANKED
	skpz
	rcall	TIA_WT_Hlp_Play_P
	bcf	TIA_WT_STATE, WT_STATE_PLAY_2ND, BANKED

	IRQ_ENABLE		; enable interrupts again

TIA_WT_Branch_Play_End
	rgoto	TIA_WT_Branch_Inc

	;; ---
TIA_WT_Branch_End
	bsf	TIA_WT_STATE, WT_STATE_STOP, BANKED
	rgoto	TIA_WT_NextClkLoop
	
	;; ---
TIA_WT_Branch_Goto
	bcf	TIA_WT_STATE, WT_STATE_SLIDE, BANKED
	bcf	TIA_WT_STATE, WT_STATE_SLIDE_PREV, BANKED

	call	TIA_BANK_Read
	andlw	0x1f
	movwf	TIA_WT_POS, BANKED
	rcall	TIA_WT_Hlp_CalcPos
	call	TIA_BANK_Read	; prevent endless loops
	movwf	TMP4
	andlw	0x03
	xorlw	0x02
	bz	TIA_WT_Branch_End
	rgoto	TIA_WT_Loop
	
	;; ---
TIA_WT_Branch_Inc
	incf	TIA_WT_POS, W, BANKED
	andlw	0x1f
	movwf	TIA_WT_POS, BANKED
	rgoto	TIA_WT_NextClkLoop

;; ---
TIA_WT_End
	;; restore saved patch
	movff	TIA_WT_SAVED_PATCH, TIA_PATCH
	return

;; ---
	;; calculate address to WT entry
TIA_WT_Hlp_CalcPos
	rlf	TIA_WT_POS, W, BANKED
	rlf	WREG, W
	andlw	0x7c
	addlw	0x80
	movwf	EEADR
	return
;; ---
	;; play a WT entry
TIA_WT_Hlp_Play_P
	movwf	TMP3	; save CC number in TMP3

	BRA_IFSET TMP2, 7, ACCESS, TIA_WT_Hlp_Play_P_Cont

	;; add/subtract with saturation
	call	TIA_CCOUT_Get

	BRA_IFSET TMP2, 6, ACCESS, TIA_WT_Hlp_Play_P_Sub
TIA_WT_Hlp_Play_P_Add
	addwf	TMP2, F
	BRA_IFCLR TMP2, 7, ACCESS, TIA_WT_Hlp_Play_P_Cont
	movlw	0x7f
	movwf	TMP2	
	goto	TIA_WT_Hlp_Play_P_Cont	
TIA_WT_Hlp_Play_P_Sub
	bsf	TMP2, 7
	addwf	TMP2, F
	BRA_IFCLR TMP2, 7, ACCESS, TIA_WT_Hlp_Play_P_Cont
	clrf	TMP2
	;; 	rgoto	TIA_WT_Hlp_Play_P_Cont	

TIA_WT_Hlp_Play_P_Cont
	movf	TMP2, W
	andlw	0x7f
	movwf	MIOS_PARAMETER1
	movf	TMP3, W
	goto	TIA_CCIN_Set
