; $Id: main.inc bdupeyron.tech@gmail.com(Antichambre)
;
; MIOS Application
; MIDIbox TIA
;
; -> see README.txt for details
;
; ==========================================================================
;
;  Copyright 1998-2006 Thorsten Klose (tk@midibox.org)
;  Licensed for personal non-commercial use only.
;  All other rights reserved.
; 
; ==========================================================================
;
; Version:                <-------------------->
#define MBTIA_VERSION_STR "MIDIboxTIA V1.beta  "
; (fixed string length - 20 characters!)
;

;; ---[ MIOS header file ]---
#include <mios.h>

;; ---[ useful macros ]---
#include <macros.h>

;; ---[ vectors to MIOS functions (never change!) ]---
#include <mios_vectors.inc>

;; ---[ user hooks (never change!) ]---
#include <user_vectors.inc>

;; ---[ variables used by application ]---
#include "app_defines.h"

; ==========================================================================

;; ---[ configuration table for MIDI processor and rotary encoders ]---
#include "mios_tables.inc"

;; ---[ Custom LCD driver ]---
#include "app_lcd.inc"

;; ==========================================================================
;;  All MIOS hooks in one file
;; ==========================================================================

;; --------------------------------------------------------------------------
;;  This function is called by MIOS after startup to initialize the 
;;  application
;; --------------------------------------------------------------------------
USER_Init
	;; initialize application specific variables
	clrf	TIA_STAT
	clrf	TIA_SYSEX_STATE
	clrf	TIA_SYSEX_ACTION
	setf	TIA_BANKSTICK_CHK_CTR	; (we have to start with BS0 in TIA_BANK_CheckStick)

	;; initialize the timer for the TIA_SW handler
	movlw	8190 & 0xff		; every 819 us
	movwf	MIOS_PARAMETER1
	movlw	8190 >> 8
	movwf	MIOS_PARAMETER2
	movlw	0x00			; prescaler 1:1
	call	MIOS_TIMER_Init

	;; initialize the MBHP_TIA module
	call    TIA_SR_Init
  

	;; init patch
	clrf	TIA_PATCH
	clrf	TIA_PBANK
	call	TIA_PATCH_Init
    
;;#if TIA_LEDMTR_SRIO == 1
	;; initialize the shift registers
	movlw	0x01			; use only first register (maximum would be 16!)
	call	MIOS_SRIO_NumberSet
	movlw	0x08			; set update frequncy
	call	MIOS_SRIO_UpdateFrqSet
	movlw	0x00			; disable touch sensor
	call	MIOS_SRIO_TS_SensitivitySet
;;#endif
#if TIA_LEDMTR_ENABLE
    call   TIA_LEDMTR_Init
#endif     

	;; initialize J5 for driving LEDs if enabled
#if ENABLE_J5
	movlw	0x00
	call	J5_IO_Init
#endif

#if MIDI_RXTX_USE_IO 
    call    MIDI_RXTX_IO_Init
#endif

#if ENABLE_AIN_LFO_WAVEFORM
	movlw	0x06			; enable the first 6 analog inputs
	call	MIOS_AIN_NumberSet
	call	MIOS_AIN_UnMuxed	; not multiplexed
	movlw	0x03			; 8 bit resolution
#endif

	;; initialize the AOUT module
	;call	AOUT_Init

	;; initialize the integrated MIDI merger
	movlw	MIOS_MIDI_MERGER_DISABLED	; should be disabled for a synthesizer
	call	MIOS_MIDI_MergerSet

	return



;; --------------------------------------------------------------------------
;;  This function is called by MIOS in the mainloop when nothing else is to do
;; --------------------------------------------------------------------------
USER_Tick

	;; ---[ check BankStick status ]---
	call	TIA_BANK_CheckStick

 	;; ---[ update AOUTs channels (if enabled) ]---
;	IRQ_DISABLE
;	call	AOUT_Update
;	IRQ_ENABLE

	;; ---[ call TIA shift register handler ]---
	call	TIA_SR_Handler

	;; ---[ handle with CC dump reuqests ]---
	call	TIA_CCOUT_Handler
    


	return


;; --------------------------------------------------------------------------
;;  This function is periodically called by MIOS. The frequency has to be
;;  initialized with MIOS_Timer_Set
;;  Note that this is an interrupt service routine! Use FSR2 instead of FSR0
;;  and IRQ_TMPx instead of TMPx -- and make the routine as fast as possible!
;; --------------------------------------------------------------------------
USER_Timer

	;; ---[ call Software TIA Handler ]---
	call	TIA_SW_Handler

	return

;; --------------------------------------------------------------------------
;;  This function is called by MIOS when a debug command has been received
;;  via SysEx
;;  Input:
;;     o WREG, MIOS_PARAMETER1, MIOS_PARAMETER2, MIOS_PARAMETER3 like
;;       specified in the debug command
;;  Output:
;;     o return values WREG, MIOS_PARAMETER1, MIOS_PARAMETER2, MIOS_PARAMETER3
;; --------------------------------------------------------------------------
USER_MPROC_DebugTrigger
	return


;; --------------------------------------------------------------------------
;;  This function is called by MIOS when the display content should be 
;;  initialized. Thats the case during startup and after a temporary message
;;  has been printed on the screen
;; --------------------------------------------------------------------------
USER_DISPLAY_Init
    return

;; --------------------------------------------------------------------------
;;  This function is called in the mainloop when no temporary message is shown
;;  on screen. Print the realtime messages here
;; --------------------------------------------------------------------------
USER_DISPLAY_Tick
	;; call MIDI RxTx handler and exit
	call	MIDI_RXTX_Handler

#if TIA_LEDMTR_ENABLE
    call    TIA_LEDMTR_Handler
#endif     



	return

;; --------------------------------------------------------------------------
;;  This function is called by MIOS when a complete MIDI event has been received
;;  Input:
;;     o first  MIDI event byte in MIOS_PARAMETER1
;;     o second MIDI event byte in MIOS_PARAMETER2
;;     o third  MIDI event byte in MIOS_PARAMETER3
;; --------------------------------------------------------------------------
USER_MPROC_NotifyReceivedEvent
	;; branch to ReceiveEvent function of TIA synth

	goto	TIA_MIDI_NotifyReceivedEvent
    
	return

;; --------------------------------------------------------------------------
;;  This function is called by MIOS when a MIDI event has been received
;;  which has been specified in the CONFIG_MIDI_IN table
;;  Input:
;;     o number of entry in WREG
;;     o first  MIDI event byte in MIOS_PARAMETER1
;;     o second MIDI event byte in MIOS_PARAMETER2
;;     o third  MIDI event byte in MIOS_PARAMETER3
;; --------------------------------------------------------------------------
USER_MPROC_NotifyFoundEvent

	return


;; --------------------------------------------------------------------------
;;  This function is called by MIOS when a MIDI event has not been completly
;;  received within 2 seconds
;; --------------------------------------------------------------------------
USER_MPROC_NotifyTimeout
	;; -> jump to "ActionInvalid" for a proper reset of the sysex parser
	goto	TIA_SYSEX_ActionInvalid
	return
    
;; --------------------------------------------------------------------------
;;  This function is called by MIOS when a MIDI byte has been received
;;  Input:
;;     o received MIDI byte in WREG and MIOS_PARAMETER1
;; --------------------------------------------------------------------------
USER_MPROC_NotifyReceivedByte
	;; -> continue at TIA_MPROC_SysExCheck
	goto	TIA_SYSEX_SysExCheck
	return
    	
;; --------------------------------------------------------------------------
;;  This function is called by MIOS before the transfer of a MIDI byte. 
;;  It can be used to monitor the Tx activity or to do any other actions
;;  (e.g. to switch a pin for multiplexed MIDI Outs) before the byte will 
;;  be sent.
;;  Note that this is an interrupt service routine! Use FSR2 instead of FSR0
;;  and IRQ_TMPx instead of TMPx -- and make the routine as fast as possible!
;;  Input:
;;     o transmitted byte in WREG
;; --------------------------------------------------------------------------
USER_MIDI_NotifyTx
	;; notify Tx event to MIDI_RXTX handler
	goto	MIDI_RXTX_NotifyTx
	return
    
;; --------------------------------------------------------------------------
;;  This function is called by MIOS when a MIDI byte has been received.
;;  It can be used to monitor the Rx activity or to do any action - e.g.
;;  to react on realtime events like MIDI clock (0xf8) with a minimum latency
;;  Note that this is an interrupt service routine! Use FSR2 instead of FSR0
;;  and IRQ_TMPx instead of TMPx -- and make the routine as fast as possible!
;;  Input:
;;     o received byte in WREG
;; --------------------------------------------------------------------------
USER_MIDI_NotifyRx
	;; temporary save received byte in IRQ_TMP1
	movwf	IRQ_TMP1

	;; if MIDI clock: notify clock
	lfsr	FSR2, TIA_MIDI_SYNC
	xorlw	0xf8
	bnz USER_MIDI_NotifyRx_NoF8
	bsf	INDF2, TIA_MIDI_SYNC_F8
    goto	MIDI_RXTX_NotifyRx_BeatClk
USER_MIDI_NotifyRx_NoF8
	;; if MIDI start: notify start
	movf	IRQ_TMP1, W
	xorlw	0xfa
    bnz USER_MIDI_NotifyRx_NoFA
	bsf	INDF2, TIA_MIDI_SYNC_FA
    clrf    MIDI_RXTX_BEAT_CTR
USER_MIDI_NotifyRx_NoFA
    
	;; notify Rx event to MIDI_RXTX handler
	goto	MIDI_RXTX_NotifyRx

    
	return
    
;; --------------------------------------------------------------------------
;;  This function is called by MIOS when an button has been toggled
;;  Input:
;;     o Button number in WREG and MIOS_PARAMETER1
;;     o Button value MIOS_PARAMETER2:
;;       - 1 if button has been released (=5V)
;;       - 0 if button has been pressed (=0V)
;; --------------------------------------------------------------------------
USER_DIN_NotifyToggle
	return


;; --------------------------------------------------------------------------
;;  This function is called by MIOS when an encoder has been moved
;;  Input:
;;     o Encoder number in WREG and MIOS_PARAMETER1
;;     o signed incrementer value in MIOS_PARAMETER2:
;;       - is positive when encoder has been turned clockwise
;;       - is negative when encoder has been turned counter clockwise
;; --------------------------------------------------------------------------
USER_ENC_NotifyChange
	return


;; --------------------------------------------------------------------------
;;  This function is called by MIOS before the shift register are loaded
;;  Note that this is an interrupt service routine! Use FSR2 instead of FSR0
;;  and IRQ_TMPx instead of TMPx -- and make the routine as fast as possible
;; --------------------------------------------------------------------------
USER_SR_Service_Prepare
	return
    
;; --------------------------------------------------------------------------
;;  This function is called by MIOS after the shift register have been loaded
;;  Note that this is an interrupt service routine! Use FSR2 instead of FSR0
;;  and IRQ_TMPx instead of TMPx -- and make the routine as fast as possible
;; --------------------------------------------------------------------------
USER_SR_Service_Finish
	return

;; --------------------------------------------------------------------------
;;  This function is called by MIOS when a pot has been moved
;;  Input:
;;     o Pot number in WREG and MIOS_PARAMETER1
;;     o LSB value in MIOS_PARAMETER2
;;     o MSB value in MIOS_PARAMETER3
;; --------------------------------------------------------------------------
USER_AIN_NotifyChange
	return


;; ==========================================================================
;;  Application code (see comments in files)
;; ==========================================================================

;; ---[ modules from code library ]---
; override default pin definitions of AOUT driver
;#define AOUT_LAT_CS	LATC	; The chip select pin CS#
;#define AOUT_TRIS_CS	TRISC	; is connected to Port C.3 
;#define AOUT_PIN_CS	3	; (CANNOT be shared with other outputs!)
;
;#define AOUT_LAT_DIN	LATC	; The data input pin DIN
;#define AOUT_TRIS_DIN	TRISC	; is connected to Port C.1
;#define AOUT_PIN_DIN	1	; (can be shared with other outputs)
;;
;#define AOUT_LAT_SCLK	LATC	; The shift clock input pin SCLK
;#define AOUT_TRIS_SCLK	TRISC	; is connected to Port C.0
;#define AOUT_PIN_SCLK	0	; (can be shared with other outputs)
; include AOUT driver (located in $MIOS_PATH/modules/aout/)
;#include <aout.inc>

;#define J5_IO_DONT_USE_INPUT_FUNCTIONS 1
;#include <j5_io.inc>

;; ---[ reusable functions ]---
#include "math_mul16_16.inc"
#include "midi_rxtx.inc"
#include "special_characters.inc"

;; ---[ TIA kernel ]---
#include "tia_led_meter.inc"
#include "tia_patch.inc"
#include "tia_bank.inc"
#include "tia_tune.inc"
#include "tia_sr.inc"
#include "tia_sw.inc"
#include "tia_midi.inc"
#include "tia_sysex.inc"
#include "tia_ccin.inc"
#include "tia_ccout.inc"
#include "tia_cc_table.inc"
#include "tia_sysex_table.inc"
#include "tia_env_table.inc"
#include "tia_lfo_table.inc"

;; these three tables are now included from the mios_tables.inc file
;; to save code space
	;; #include "tia_frq_table.inc"
	;; #include "tia_sin_table.inc"
	;; #include "tia_depth_table.inc"

;; ---[ TIA EEPROM content ]---
#include "tia_presets.inc"

END
