; $Id: tia_ccin.inc bdupeyron.tech@gmail.com(Antichambre)
;
; MIDIbox TIA
; CC Input Handling
;
; ==========================================================================
;
;  Copyright 1998-2006 Thorsten Klose (tk@midibox.org)
;  Licensed for personal non-commercial use only.
;  All other rights reserved.
; 
; ==========================================================================

;; --------------------------------------------------------------------------
;;  IN: index of CC parameter in WREG, value in MIOS_PARAMETER1
;; --------------------------------------------------------------------------
TIA_CCIN_Set
	rcall	TIA_CC_TABLE_Get	; prepare a CC action
	;; now:
	;; value     is in MIOS_PARAMETER1
	;; command   is in MIOS_PARAMETER2
	;; parameter is in FSR1 (pointer)

	;; branch depending on command
	movf	MIOS_PARAMETER2, W
	andlw	0x0f
	JUMPTABLE_2BYTES_UNSECURE
	rgoto	TIA_CCIN_Cmd_NOP
	rgoto	TIA_CCIN_Cmd_V12
	rgoto	TIA_CCIN_Cmd_7BIT
	rgoto	TIA_CCIN_Cmd_7BIT_W_PORTA
	rgoto	TIA_CCIN_Cmd_7BIT_4L
	rgoto	TIA_CCIN_Cmd_7BIT_4U
	rgoto	TIA_CCIN_Cmd_SUSKEY
	rgoto	TIA_CCIN_Cmd_VEL
	rgoto	TIA_CCIN_Cmd_AFTERTOUCH
	rgoto	TIA_CCIN_Cmd_MODWHEEL
	rgoto	TIA_CCIN_Cmd_WAVEFORM
    rgoto	TIA_CCIN_Cmd_NOP
	rgoto	TIA_CCIN_Cmd_NOP
	rgoto	TIA_CCIN_Cmd_NOP
	rgoto	TIA_CCIN_Cmd_NOP
	rgoto	TIA_CCIN_Cmd_PlayNote

; ==========================================================================

;; --------------------------------------------------------------------------
TIA_CCIN_Cmd_NOP
	;; no jump to end, since no CS update is required
	;; 	rgoto	TIA_CCIN_Cmd_End
	return

;; --------------------------------------------------------------------------
TIA_CCIN_Cmd_V12
	movf	FSR1L, W		; parameter contains first CC, save it
	movwf	MIOS_PARAMETER3
	rcall	TIA_CCIN_Set		; set first voice
	incf	MIOS_PARAMETER3, F
	movf	MIOS_PARAMETER3, W
	rgoto	TIA_CCIN_Set		; set second voice

;; --------------------------------------------------------------------------
TIA_CCIN_Cmd_7BIT
    ;; special treatment, GSA falling -> Gate falls
	movlw   (TIA_V1_BASE + TIA_Vx_MODE) & 0xff  ;; V1 MODE register
    xorwf   FSR1L, W
    bz      TIA_CCIN_Cmd_7BIT_GSA_Fall
    movlw   (TIA_V2_BASE + TIA_Vx_MODE) & 0xff  ;; V2 MODE register
    xorwf   FSR1L, W
    bnz     TIA_CCIN_Cmd_7BIT_End
TIA_CCIN_Cmd_7BIT_GSA_Fall    ;; detect fall of GSA
    btfsc   INDF1, Vx_MODE_GSA_ACTIVE
    btfsc   MIOS_PARAMETER1, Vx_MODE_GSA_ACTIVE
    bra     TIA_CCIN_Cmd_7BIT_End
    ;; clear gate
    decf    FSR1L, F    ;; Vx STAT register
    bcf     INDF1, Vx_STAT_GATE_ACTIVE
    incf    FSR1L, F    ;; Vx MODE register
TIA_CCIN_Cmd_7BIT_End
    ;; normal treatment
    movff	MIOS_PARAMETER1, INDF1
    
	rgoto	TIA_CCIN_Cmd_End
    
;; --------------------------------------------------------------------------
TIA_CCIN_Cmd_7BIT_W_PORTA
	bcf	TIA_STAT, TIA_STAT_SAVED_GIE	; for nested IRQ disables
	btfsc	INTCON, GIE
	bsf	TIA_STAT, TIA_STAT_SAVED_GIE
	IRQ_DISABLE

	;; works only with TIA_Vx_TRANSPOSE,  _PITCHRANGE
	movff	MIOS_PARAMETER1, INDF1

#if 0
	;; enable portamento if rate is > 0
	;; switch to TIA_Vx_PORTA_RATE
	movf	FSR1L, W
	andlw	0x03
	iorlw	TIA_V1_PORTA_RATE & 0xfc
	movwf	FSR1L
	movf	INDF1, W
	bz	TIA_CCIN_Cmd_7BIT_W_PORTA_End

	movf	FSR1L, W
	andlw	0x03
	iorlw	TIA_V1_MODE & 0xfc
	movwf	FSR1L
	bsf	INDF1, Vx_STAT_PORTA_ENABLE
#endif

TIA_CCIN_Cmd_7BIT_W_PORTA_End
	;; 	IRQ_ENABLE
	btfsc	TIA_STAT, TIA_STAT_SAVED_GIE	; nested IRQ enable
	bsf	INTCON, GIE
	
	rgoto	TIA_CCIN_Cmd_End


;; --------------------------------------------------------------------------
TIA_CCIN_Cmd_7BIT_4L
	movlw	0xf0
	andwf	INDF1, F
	movf	MIOS_PARAMETER1, W
	andlw	0x0f
	iorwf	INDF1, F
	rgoto	TIA_CCIN_Cmd_End

;; --------------------------------------------------------------------------
TIA_CCIN_Cmd_7BIT_4U
	movlw	0x0f
	andwf	INDF1, F
	swapf	MIOS_PARAMETER1, W
	andlw	0xf0
	iorwf	INDF1, F
	rgoto	TIA_CCIN_Cmd_End

;; --------------------------------------------------------------------------
TIA_CCIN_Cmd_7BIT_TO_7_4
	movlw	0x0f
	andwf	INDF1, F
	rlf     MIOS_PARAMETER1, W
	andlw	0xf0
	iorwf	INDF1, F
	rgoto	TIA_CCIN_Cmd_End

;; --------------------------------------------------------------------------
TIA_CCIN_Cmd_7BIT_TO_3_0
	movlw	0xf0
	andwf	INDF1, F
	rrf	MIOS_PARAMETER1, W
	rrf	WREG, F
	rrf	WREG, W
	andlw	0x0f
	iorwf	INDF1, F
	rgoto	TIA_CCIN_Cmd_End

;; --------------------------------------------------------------------------
TIA_CCIN_Cmd_SUSKEY
	bcf	TIA_PLAY_MODE, TIA_PLAY_MODE_SUS_KEY, BANKED
	movf	MIOS_PARAMETER1, W
	skpz
	bsf	TIA_PLAY_MODE, TIA_PLAY_MODE_SUS_KEY, BANKED

	;rrf	MIOS_PARAMETER1, W
	;andlw	0x3f
	;movwf	TIA_KEYTRACKING, BANKED

	rgoto	TIA_CCIN_Cmd_End

; ==========================================================================

	;; ------------------------------------------------------------------
	;; Controller Handler Macro
	;; ------------------------------------------------------------------
TIA_CCIN_SETHLP_MACRO_DO_CTRL MACRO BASE, LAST_VALUE, DEPTH_VALUE, INIT_VALUE, ASSIGN_VALUE
	LOCAL	TIA_CCIN_CmdHlp_DoCtrl_Neg
	LOCAL	TIA_CCIN_CmdHlp_DoCtrl_Pos
    LOCAL   TIA_CCIN_CmdHlp_DoCtrl_NoDepth
	LOCAL	TIA_CCIN_CmdHlp_DoCtrl_Cont

    ;; Velocity calc
    movf	BASE + DEPTH_VALUE, W, BANKED	; calc (DEPTH+1)*4 * LAST_VALUE
    xorlw   0x40
    bz      TIA_CCIN_CmdHlp_DoCtrl_NoDepth
    
    movf	BASE + DEPTH_VALUE, W, BANKED
	andlw	0x3f
	clrc
	rlf	WREG, W
    ;movwf   MIOS_PARAMETER1
   
	btfss	BASE + DEPTH_VALUE, 6, BANKED
    rgoto   TIA_CCIN_CmdHlp_DoCtrl_Neg
    
TIA_CCIN_CmdHlp_DoCtrl_Pos    
	addlw	2
    movwf   MIOS_PARAMETER1
    
    movf	BASE + LAST_VALUE, W, BANKED
    mulwf   MIOS_PARAMETER1
    clrc
    rlf     PRODL, F
    rlf     PRODH, W
	addlw	1
    movwf   MIOS_PARAMETER1
    
    movf	BASE + INIT_VALUE, W, BANKED
    sublw   0x7f
    mulwf   MIOS_PARAMETER1
    rlf     PRODL, F
    rlf     PRODH, W
    addwf   BASE + INIT_VALUE, W, BANKED
    rgoto   TIA_CCIN_CmdHlp_DoCtrl_Cont

TIA_CCIN_CmdHlp_DoCtrl_Neg
    comf    WREG, W
    andlw   0x7f
    addlw	2
    movwf   MIOS_PARAMETER1

    movf	BASE + LAST_VALUE, W, BANKED
    mulwf   MIOS_PARAMETER1
    clrc
    rlf     PRODL, F
    rlf     PRODH, W
	addlw	1
    movwf   MIOS_PARAMETER1

    movf	BASE + INIT_VALUE, W, BANKED
    mulwf   MIOS_PARAMETER1
    rlf     PRODL, F
    rlf     PRODH, W
    subwf   BASE + INIT_VALUE, W, BANKED
    rgoto   TIA_CCIN_CmdHlp_DoCtrl_Cont
    
TIA_CCIN_CmdHlp_DoCtrl_NoDepth
    movf	BASE + INIT_VALUE, W, BANKED
    
TIA_CCIN_CmdHlp_DoCtrl_Cont
    movwf   MIOS_PARAMETER1
	movf	BASE + ASSIGN_VALUE, W, BANKED

	ENDM

; ==========================================================================
TIA_CCIN_Cmd_VEL

	movff	MIOS_PARAMETER1, INDF1
TIA_CCIN_Cmd_VELOCITY_SkpCopy
    movlw   TIA_V2_BASE & 0xff
    cpfslt  FSR1L, ACCESS
    rgoto   TIA_CCIN_Cmd_VELOCITY_A1
    
TIA_CCIN_Cmd_VELOCITY_A0

	movf	TIA_V1_BASE + TIA_Vx_ASSIGN_VEL, W, BANKED	; exit when velocity assigned to 0
    bz	TIA_CCIN_Cmd_VELOCITY_End
	xorlw	5				; CC#5 is Velocity Init
	bz	TIA_CCIN_Cmd_VELOCITY_End	; prevent endless loop
	movf	TIA_V1_BASE + TIA_Vx_ASSIGN_VEL, W, BANKED
	xorlw	14				; CC#14 is Velocity Depth
	bz	TIA_CCIN_Cmd_VELOCITY_End	; prevent endless loop

	TIA_CCIN_SETHLP_MACRO_DO_CTRL TIA_V1_BASE, TIA_Vx_LAST_VEL, TIA_Vx_DEPTH_VEL, TIA_Vx_INIT_VEL, TIA_Vx_ASSIGN_VEL

    rgoto   TIA_CCIN_Cmd_VELOCITY_Set
    
TIA_CCIN_Cmd_VELOCITY_A1

	movf	TIA_V2_BASE + TIA_Vx_ASSIGN_VEL, W, BANKED	; exit when velocity assigned to 0
	bz	TIA_CCIN_Cmd_VELOCITY_End
	xorlw	6				; CC#6 is Velocity Init
	bz	TIA_CCIN_Cmd_VELOCITY_End	; prevent endless loop
	movf	TIA_V1_BASE + TIA_Vx_ASSIGN_VEL, W, BANKED
	xorlw	15				; CC#15 is Velocity Depth
	bz	TIA_CCIN_Cmd_VELOCITY_End	; prevent endless loop

	TIA_CCIN_SETHLP_MACRO_DO_CTRL TIA_V2_BASE, TIA_Vx_LAST_VEL, TIA_Vx_DEPTH_VEL, TIA_Vx_INIT_VEL, TIA_Vx_ASSIGN_VEL
    rgoto   TIA_CCIN_Cmd_VELOCITY_Set
    
TIA_CCIN_Cmd_VELOCITY_Set
	rgoto	TIA_CCIN_Set
	
TIA_CCIN_Cmd_VELOCITY_End
	rgoto	TIA_CCIN_Cmd_End

;; --------------------------------------------------------------------------
TIA_CCIN_Cmd_AFTERTOUCH
	movff	MIOS_PARAMETER1, INDF1

	movf	TIA_CTRL_AFTERTOUCH_BASE + TIA_CTRLx_ASSIGN, W, BANKED
    ;; exit when aftertouch assigned to 0
	bz	TIA_CCIN_Cmd_AFTERTOUCH_End
	xorlw	3				; CC#3 is Aftertouch Init
	bz	TIA_CCIN_Cmd_AFTERTOUCH_End	; prevent endless loop
	movf	TIA_CTRL_AFTERTOUCH_BASE + TIA_CTRLx_ASSIGN, W, BANKED
	xorlw	12				; CC#12 is Aftertouch Depth
	bz	TIA_CCIN_Cmd_AFTERTOUCH_End	; prevent endless loop

	TIA_CCIN_SETHLP_MACRO_DO_CTRL TIA_CTRL_AFTERTOUCH_BASE, TIA_CTRLx_LAST, TIA_CTRLx_DEPTH, TIA_CTRLx_INIT, TIA_CTRLx_ASSIGN
	rgoto	TIA_CCIN_Set
	
TIA_CCIN_Cmd_AFTERTOUCH_End
	rgoto	TIA_CCIN_Cmd_End

;; --------------------------------------------------------------------------
TIA_CCIN_Cmd_MODWHEEL
	movff	MIOS_PARAMETER1, INDF1
	movf	TIA_CTRL_MODWHEEL_BASE + TIA_CTRLx_ASSIGN, W, BANKED	
    ;; exit when modwheel assigned to 0
	bz	TIA_CCIN_Cmd_MODWHEEL_End
	decf	TIA_CTRL_MODWHEEL_BASE + TIA_CTRLx_ASSIGN, W, BANKED	
    ;; prevent endless loop if assigned to CC#1
	bz	TIA_CCIN_Cmd_MODWHEEL_End
	movf	TIA_CTRL_MODWHEEL_BASE + TIA_CTRLx_ASSIGN, W, BANKED
	xorlw	2				; CC#2 is Modwheel Init
	bz	TIA_CCIN_Cmd_MODWHEEL_End	; prevent endless loop
	movf	TIA_CTRL_MODWHEEL_BASE + TIA_CTRLx_ASSIGN, W, BANKED
	xorlw	11				; CC#11 is Modulation Wheel Depth
	bz	TIA_CCIN_Cmd_MODWHEEL_End	; prevent endless loop

	TIA_CCIN_SETHLP_MACRO_DO_CTRL TIA_CTRL_MODWHEEL_BASE, TIA_CTRLx_LAST, TIA_CTRLx_DEPTH, TIA_CTRLx_INIT, TIA_CTRLx_ASSIGN
	rgoto	TIA_CCIN_Set

TIA_CCIN_Cmd_MODWHEEL_End
	rgoto	TIA_CCIN_Cmd_End

;; --------------------------------------------------------------------------
TIA_CCIN_Cmd_WAVEFORM
    incf    MIOS_PARAMETER1, F  ;; skip 0
    movlw   0x05
    cpfslt  MIOS_PARAMETER1, ACCESS     ;; skip 5
    incf    MIOS_PARAMETER1, F
    
    movlw   0x08             
    cpfsgt  MIOS_PARAMETER1, ACCESS     ;; skip 8-11
    rgoto   TIA_CCIN_Cmd_WAVEFORM_Cont
    movlw   0x03
    addwf   MIOS_PARAMETER1, F    

TIA_CCIN_Cmd_WAVEFORM_Cont
    movlw   0x0d                ;; skip 13
    cpfslt  MIOS_PARAMETER1, ACCESS
    incf    MIOS_PARAMETER1, F    
    movf    MIOS_PARAMETER1, W     
	movwf	INDF1

	rgoto	TIA_CCIN_Cmd_End

;; --------------------------------------------------------------------------
;TIA_CCIN_Cmd_MONO
;	bsf	TIA_PLAY_MODE, TIA_PLAY_MODE_LEGATO_OFF, BANKED
;	bsf	TIA_PLAY_MODE, TIA_PLAY_MODE_POLY, BANKED
;	movf	MIOS_PARAMETER1, W
;	skpz
;	bcf	TIA_PLAY_MODE, TIA_PLAY_MODE_POLY, BANKED
;	rgoto	TIA_CCIN_Cmd_End

;; --------------------------------------------------------------------------
TIA_CCIN_Cmd_PLAY_MODE
	bcf	TIA_PLAY_MODE, TIA_PLAY_MODE_POLY, BANKED
	;bsf	TIA_PLAY_MODE, TIA_PLAY_MODE_LEGATO_OFF, BANKED
	;bsf	TIA_PLAY_MODE, TIA_PLAY_MODE_ONLY_WT_OFF, BANKED

	;btfsc	MIOS_PARAMETER1, 0
	;bcf	TIA_PLAY_MODE, TIA_PLAY_MODE_LEGATO_OFF, BANKED

	;btfsc	MIOS_PARAMETER1, 1
	;bcf	TIA_PLAY_MODE, TIA_PLAY_MODE_ONLY_WT_OFF, BANKED

	btfsc	MIOS_PARAMETER1, 0
	bsf	TIA_PLAY_MODE, TIA_PLAY_MODE_POLY, BANKED

	;btfsc	TIA_PLAY_MODE, TIA_PLAY_MODE_POLY, BANKED
	;bsf	TIA_PLAY_MODE, TIA_PLAY_MODE_ONLY_WT_OFF, BANKED

	rgoto	TIA_CCIN_Cmd_End    

;; --------------------------------------------------------------------------
TIA_CCIN_Cmd_PlayNote
	movf	MIOS_PARAMETER1, W	; do nothing if 0x25 played (hold note)
    xorlw   0x25
	bz	TIA_CCIN_Cmd_PlayNote_End

	bcf	TIA_STAT, TIA_STAT_SAVED_GIE	; for nested IRQ disables
	btfsc	INTCON, GIE
	bsf	TIA_STAT, TIA_STAT_SAVED_GIE
	IRQ_DISABLE

	movf	FSR1L, W		; parameter contains voice offset, calc base address
	lfsr	FSR1, TIA_V1_BASE
    skpz
	lfsr	FSR1, TIA_V2_BASE

	;; set/clear gate bit
	;BRA_IFCLR TIA_SE_OPTION, SE_OPTION_TB303, BANKED, TIA_CCIN_Cmd_PlayNote_NotTB303
	;BRA_IFCLR TIA_WT_STATE, WT_STATE_PLAY_2ND, BANKED, TIA_CCIN_Cmd_PlayNote_NotTB303
;TIA_CCIN_Cmd_PlayNote_TB303
	;BRA_IFSET TIA_WT_STATE, WT_STATE_SLIDE_PREV, BANKED, TIA_CCIN_Cmd_PlayNote_Cont
	;BRA_IFSET TIA_WT_STATE, WT_STATE_GATE, BANKED, TIA_CCIN_Cmd_PlayNote_On
	;; gate will be released by sequencer
	;rgoto	TIA_CCIN_Cmd_PlayNote_Cont
TIA_CCIN_Cmd_PlayNote_NotTB303

	movf	MIOS_PARAMETER1, W
	bnz	TIA_CCIN_Cmd_PlayNote_On
TIA_CCIN_Cmd_PlayNote_Off
	;; clear gate bit + note and branch to end
	movlw	TIA_Vx_STAT
	bcf	PLUSW1, Vx_STAT_GATE_SET_REQ
	bsf	PLUSW1, Vx_STAT_GATE_CLR_REQ
    bcf	PLUSW1, Vx_STAT_VOICE_ACTIVE
	rgoto	TIA_CCIN_Cmd_PlayNote_End

TIA_CCIN_Cmd_PlayNote_On
	;; set gate bit
	movlw	TIA_Vx_STAT
	;BRA_IFCLR PLUSW1, Vx_STAT_VOICE_ACTIVE, ACCESS, TIA_CCIN_Cmd_PlayNote_Cont
	bsf	PLUSW1, Vx_STAT_GATE_CLR_REQ
	bsf	PLUSW1, Vx_STAT_GATE_SET_REQ
    bsf	PLUSW1, Vx_STAT_VOICE_ACTIVE

	;BRA_IFCLR TIA_SE_OPTION, SE_OPTION_TB303, BANKED, TIA_CCIN_Cmd_PlayNote_On_NoTB303
	;BRA_IFCLR TIA_WT_STATE, WT_STATE_PLAY_2ND, BANKED, TIA_CCIN_Cmd_PlayNote_On_NoTB303
	rgoto	TIA_CCIN_Cmd_PlayNote_Cont
TIA_CCIN_Cmd_PlayNote_On_NoTB303
	rcall	TIA_CCIN_Cmd_PlayNote_PHelp	; help function for alternative portamento
	;; enable portamento if rate > 0
	movlw	TIA_Vx_PORTA_RATE
	movf	PLUSW1, W
	bz	TIA_CCIN_Cmd_PlayNote_Cont
	movlw	TIA_Vx_STAT
	bsf	PLUSW1, Vx_STAT_PORTA_ENABLE
TIA_CCIN_Cmd_PlayNote_Cont

	;BRA_IFCLR TIA_SE_OPTION, SE_OPTION_TB303, BANKED, TIA_CCIN_Cmd_PlayNote_NoTB303Sl
	;BRA_IFCLR TIA_WT_STATE, WT_STATE_PLAY_2ND, BANKED, TIA_CCIN_Cmd_PlayNote_NoTB303Sl
;TIA_CCIN_Cmd_PlayNote_TB303Sl
	;; enable portamento depending on previous step
	;bcf	TIA_V1_BASE + TIA_Vx_MODE, TIA_MODE_PORTA_ENABLE, BANKED
	;btfsc	TIA_WT_STATE, WT_STATE_SLIDE_PREV, BANKED
	;bsf	TIA_V1_BASE + TIA_Vx_MODE, TIA_MODE_PORTA_ENABLE, BANKED
	;rcall	TIA_CCIN_Cmd_PlayNote_PHelp	; help function for alternative portamento
TIA_CCIN_Cmd_PlayNote_NoTB303Sl
	;; set new note
	;; if > 0x20, play arpeggiator note
	;movlw	0x20
	;cpfslt	MIOS_PARAMETER1, ACCESS
	;rgoto TIA_CCIN_Cmd_PlayNote_Arp
TIA_CCIN_Cmd_PlayNote_Norm
	movlw	TIA_Vx_MODE
	BRA_IFSET PLUSW1, Vx_MODE_KEY_EXTENDED, ACCESS, TIA_CCIN_Cmd_PlayNote_KeyMode_Extended    
TIA_CCIN_Cmd_PlayNote_KeyMode_NonExtended 
    decf    MIOS_PARAMETER1, F
    clrc
    movlw   TIA_Vx_KEY_OFFSET
    movf    PLUSW1, W
    addwf   MIOS_PARAMETER1, F
	movlw	TIA_Vx_NOTE
	movff	MIOS_PARAMETER1, PLUSW1
    rgoto   TIA_CCIN_Cmd_PlayNote_End 

TIA_CCIN_Cmd_PlayNote_KeyMode_Extended      
    ;;etendu (5bit pitch to 7bit note)
    decf    MIOS_PARAMETER1, F
    clrc
    rlf     MIOS_PARAMETER1, F
    rlf     MIOS_PARAMETER1, F  
	movlw	TIA_Vx_NOTE
	movff	MIOS_PARAMETER1, PLUSW1
	rgoto	TIA_CCIN_Cmd_PlayNote_End

TIA_CCIN_Cmd_PlayNote_Arp
	movlw	TIA_Vx_ARP_NOTE_0
	addwf	MIOS_PARAMETER1, W
	addlw	-0x20
	movf	PLUSW1, W
	bnz	TIA_CCIN_Cmd_PlayNote_ArpNow
	movlw	TIA_Vx_ARP_NOTE_0	; if xth key not pressed: play first ARP note
	movf	PLUSW1, W
TIA_CCIN_Cmd_PlayNote_ArpNow
	movwf	PRODL
	movlw	TIA_Vx_NOTE
	movff	PRODL, PLUSW1

TIA_CCIN_Cmd_PlayNote_End
	;;IRQ_ENABLE
	btfsc	TIA_STAT, TIA_STAT_SAVED_GIE	; nested IRQ enable
	bsf	INTCON, GIE
	;;rgoto	TIA_CCIN_Cmd_End

;; --------
;; help function for alternative portamento effect
TIA_CCIN_Cmd_PlayNote_PHelp
	;btfss	TIA_SE_OPTION, Vx_OPTION_ENV2PORTA, BANKED
	return

	;; reset ENV2
	;call	TIA_SW_Hlp_ENV2Reset
	
	;; store current frequency in TIA_Vx_PORTA_FRQ_L

	movlw	TIA_Vx_FRQ_L
	movff	PLUSW1, PRODL
	movlw	TIA_Vx_FRQ_H
	movff	PLUSW1, PRODH    

	movlw	TIA_Vx_PORTA_FRQ_L
	movff	PRODL, PLUSW1
	movlw	TIA_Vx_PORTA_FRQ_H
	movff	PRODH, PLUSW1   

    movlw   TIA_Vx_PORTA_CTR_L 
	clrf	PLUSW1
    movlw   TIA_Vx_PORTA_CTR_H 
	clrf	PLUSW1
    
	return


;; --------------------------------------------------------------------------
TIA_CCIN_Cmd_End
	return

