; $Id: tia_ccout.inc bdupeyron.tech@gmail.com(Antichambre)
;
; MIDIbox TIA
; CC Output Handling
;
; ==========================================================================
;
;  Copyright 1998-2006 Thorsten Klose (tk@midibox.org)
;  Licensed for personal non-commercial use only.
;  All other rights reserved.
; 
; ==========================================================================

;; --------------------------------------------------------------------------
;;  reacts on a CC dump request
;; --------------------------------------------------------------------------
TIA_CCOUT_Handler
	;; do nothing if dump has not been requested
	btfss	TIA_STAT, TIA_STAT_CC_DUMP_REQ
	return

	;; clear request
	bcf	TIA_STAT, TIA_STAT_CC_DUMP_REQ

	clrf	TMP1			; TMP1 used as loop counter
TIA_CCOUT_Handler_Loop
	movf	TMP1, W
	call	TIA_CCOUT_Get		; get CC parameter value
	movwf	TMP2			; store value in TMP2
	BRA_IFSET TMP2, 7, ACCESS, TIA_CCOUT_Handler_Next ; (returns WREG[7] if non-CC value)

	;; send CC
	movff	TIA_V1_BASE + TIA_Vx_MIDI_CHANNEL, WREG
	iorlw	0xb0
	call	MIOS_MIDI_TxBufferPut
	movf	TMP1, W
	call	MIOS_MIDI_TxBufferPut
	movf	TMP2, W
	call	MIOS_MIDI_TxBufferPut

	movlw	8			; add a short delay of 8 mS for slow sequencers
	call	MIOS_Delay

TIA_CCOUT_Handler_Next
	incf	TMP1, F			; loop until 128 (bit 8 set)
	BRA_IFCLR TMP1, 7, ACCESS, TIA_CCOUT_Handler_Loop
	
	return

;; --------------------------------------------------------------------------
;;  IN: index of CC parameter in WREG
;;  OUT: CC value in WREG
;; --------------------------------------------------------------------------
TIA_CCOUT_Get
	rcall	TIA_CC_TABLE_Get	; prepare a CC action
	;; now:
	;; command   is in MIOS_PARAMETER2
	;; parameter is in FSR1 (pointer)

TIA_CCOUT_Set_Cmd
	;; branch depending on command
	movf	MIOS_PARAMETER2, W
	andlw	0x0f
	JUMPTABLE_2BYTES_UNSECURE
	rgoto	TIA_CCOUT_Cmd_NOP
	rgoto	TIA_CCOUT_Cmd_V12
	rgoto	TIA_CCOUT_Cmd_7BIT
	rgoto	TIA_CCOUT_Cmd_7BIT; (W_PORTA ignored here)
	rgoto	TIA_CCOUT_Cmd_7BIT_4L
	rgoto	TIA_CCOUT_Cmd_7BIT_4U
	rgoto	TIA_CCOUT_Cmd_SUSKEY
	rgoto	TIA_CCOUT_Cmd_VEL
	rgoto	TIA_CCOUT_Cmd_AFTERTOUCH
	rgoto	TIA_CCOUT_Cmd_MODWHEEL
	rgoto	TIA_CCOUT_Cmd_WAVEFORM
	rgoto	TIA_CCOUT_Cmd_NOP
	rgoto	TIA_CCOUT_Cmd_NOP
	rgoto	TIA_CCOUT_Cmd_Cmd_PLAY_MODE
	rgoto	TIA_CCOUT_Cmd_NOP
	rgoto	TIA_CCOUT_Cmd_NOP; (PLAY_NOTE)

; ==========================================================================


;; --------------------------------------------------------------------------
TIA_CCOUT_Cmd_NOP
	return

;; --------------------------------------------------------------------------
TIA_CCOUT_Cmd_V12
	movf	FSR1L, W		; parameter contains first CC, only return this parameter!
	rgoto	TIA_CCOUT_Get

;; --------------------------------------------------------------------------
TIA_CCOUT_Cmd_7BIT
	movf	INDF1, W
	return

;; --------------------------------------------------------------------------
TIA_CCOUT_Cmd_7BIT_4L
	movf	INDF1, W
	andlw	0x0f
	return

;; --------------------------------------------------------------------------
TIA_CCOUT_Cmd_7BIT_4U
	swapf	INDF1, W
	andlw	0x0f
	return

;; --------------------------------------------------------------------------
TIA_CCOUT_Cmd_7BIT_TO_7_4
	rrf	INDF1, W
	andlw	0x78
	return

;; --------------------------------------------------------------------------
TIA_CCOUT_Cmd_7BIT_TO_3_0
	rlf	INDF1, W
	rlf	WREG, F
	rlf	WREG, W
	andlw	0x78
	return

;; --------------------------------------------------------------------------
TIA_CCOUT_Cmd_SUSKEY
	;rrf	TIA_KEYTRACKING, W, BANKED
	;andlw	0x7e

	btfsc	TIA_PLAY_MODE, TIA_PLAY_MODE_SUS_KEY, BANKED
	movlw 0x01
	return

;; --------------------------------------------------------------------------
TIA_CCOUT_Cmd_VEL
	rgoto	TIA_CCOUT_Cmd_7BIT

;; --------------------------------------------------------------------------
TIA_CCOUT_Cmd_AFTERTOUCH
	rgoto	TIA_CCOUT_Cmd_7BIT

;; --------------------------------------------------------------------------
TIA_CCOUT_Cmd_MODWHEEL
	rgoto	TIA_CCOUT_Cmd_7BIT

;; --------------------------------------------------------------------------
TIA_CCOUT_Cmd_WAVEFORM
	movf	INDF1, W
    andlw   0x0f
    movwf   MIOS_PARAMETER1
    movlw   0x0d                ;; skip 13
    cpfslt  MIOS_PARAMETER1
    decf    MIOS_PARAMETER1, F 

    movlw   0x08             
    cpfsgt  MIOS_PARAMETER1     ;; skip 8-11
    rgoto   TIA_CCOUT_Cmd_WAVEFORM_Cont
    movlw   0x03
    subwf   MIOS_PARAMETER1, F    

TIA_CCOUT_Cmd_WAVEFORM_Cont   

    movlw   0x05
    cpfslt  MIOS_PARAMETER1     ;; skip 5
    decf    MIOS_PARAMETER1, F
    
    decf    MIOS_PARAMETER1, F  ;; skip 0
    movf	MIOS_PARAMETER1, W

	return

;; --------------------------------------------------------------------------
TIA_CCOUT_Cmd_MONO
	return			; (ignored)

;; --------------------------------------------------------------------------
TIA_CCOUT_Cmd_Cmd_PLAY_MODE
	movlw	0x00
	;btfss	TIA_PLAY_MODE, TIA_PLAY_MODE_LEGATO_OFF, BANKED
	;movlw 0x01
	;btfss	TIA_PLAY_MODE, TIA_PLAY_MODE_ONLY_WT_OFF, BANKED
	;movlw 0x03
	btfsc	TIA_PLAY_MODE, TIA_PLAY_MODE_POLY, BANKED
	movlw 0x01
	return
