; ==========================================================================
;
; MIOS Audio Mixer
;
; (C)2007, 2008 Lyle Hazelwood (lylehaze@bellsouth.net)
; 
; ==========================================================================
;
; The files used in the making of this application are (c) 2008 Lyle Hazelwood
; They may be used without charge for personal, non-profit use only.
; Sale of any product that contains code from this project, in whole or part, 
; requires previous consent in writing from the author.
;
; ==========================================================================
;Convert 0-256 in W into Log curve 0-255
LogByte
	movwf	loghold			;hold the requested input value(0-255)
	TABLE_ADDR_FULL logtable	;set the table address to logtable
	movf	loghold,W		;get our input value into W
	addwf	TBLPTRL,F		;add it to the low address byte
	btfsc	STATUS,C		;if we carry over a page boundary
	incf	TBLPTRH			;increment the page counter
	tblrd*					;finally, we read the value
	movf	TABLAT,W		;put it back into W
	return

;The table value holds two bytes per instruction word
;bytes are in reverse-endian order, just to be a PITA
logtable
  dw  0X2000,0X4033,0X524A,0X6059,0X6A65,0X726E,0X7976,0X7F7D
  dw  0X8582,0X8A87,0X8E8C,0X9290,0X9694,0X9998,0X9C9B,0X9F9E
  dw  0XA2A1,0XA5A3,0XA7A6,0XAAA8,0XACAB,0XAEAD,0XB0AF,0XB2B1
  dw  0XB4B3,0XB6B5,0XB7B7,0XB9B8,0XBBBA,0XBCBB,0XBEBD,0XBFBF
  dw  0XC1C0,0XC2C1,0XC3C3,0XC5C4,0XC6C5,0XC7C7,0XC8C8,0XC9C9
  dw  0XCBCA,0XCCCB,0XCDCC,0XCECD,0XCFCE,0XD0CF,0XD1D0,0XD2D1
  dw  0XD3D2,0XD4D3,0XD5D4,0XD6D5,0XD6D6,0XD7D7,0XD8D8,0XD9D9
  dw  0XDAD9,0XDBDA,0XDBDB,0XDCDC,0XDDDD,0XDEDD,0XDEDE,0XDFDF
  dw  0XE0DF,0XE1E0,0XE1E1,0XE2E2,0XE3E2,0XE3E3,0XE4E4,0XE5E4
  dw  0XE5E5,0XE6E5,0XE6E6,0XE7E7,0XE8E7,0XE8E8,0XE9E9,0XE9E9
  dw  0XEAEA,0XEBEA,0XEBEB,0XECEB,0XECEC,0XEDEC,0XEDED,0XEEED
  dw  0XEEEE,0XEFEF,0XEFEF,0XF0F0,0XF0F0,0XF1F1,0XF1F1,0XF2F2
  dw  0XF2F2,0XF3F2,0XF3F3,0XF4F3,0XF4F4,0XF5F4,0XF5F5,0XF5F5
  dw  0XF6F6,0XF6F6,0XF7F7,0XF7F7,0XF8F7,0XF8F8,0XF8F8,0XF9F9
  dw  0XF9F9,0XFAF9,0XFAFA,0XFAFA,0XFBFB,0XFBFB,0XFCFB,0XFCFC
  dw  0XFCFC,0XFDFD,0XFDFD,0XFEFD,0XFEFE,0XFEFE,0XFFFE,0XFFFF


;for example, the first six entries and responses:
;0,0x00
;1,0x20
;2,0x33
;3,0x40
;4,0x4A
;5,0x52
;will translate into reverse-byte order of three words
;	dw	0x2400,0x493A,0x5E55

AntiLog
;convert 0-255 log value back into 0-255 linear value
;my ears have a log response, my eyes don't. This will
;re-adjust values to scale properly on the meter
	movwf	loghold			;hold the requested input value(0-255)
	TABLE_ADDR_FULL alogtable	;set the table address to alogtable
	movf	loghold,W		;get our input value into W
	addwf	TBLPTRL,F		;add it to the low address byte
	btfsc	STATUS,C		;if we carry over a page boundary
	incf	TBLPTRH			;increment the page counter
	tblrd*					;finally, we read the value
	movf	TABLAT,W		;put it back into W
	return

alogtable
	dw	0x0200,0x0202,0x0202,0x0202,0x0202,0x0202,0x0202,0x0202
	dw	0x0202,0x0202,0x0202,0x0202,0x0202,0x0202,0x0202,0x0202
	dw	0x0202,0x0202,0x0202,0x0202,0x0202,0x0202,0x0202,0x0202
	dw	0x0404,0x0404,0x0404,0x0404,0x0404,0x0404,0x0404,0x0404
	dw	0x0404,0x0606,0x0606,0x0606,0x0606,0x0606,0x0606,0x0606
	dw	0x0808,0x0808,0x0808,0x0808,0x0808,0x0A0A,0x0A0A,0x0A0A
	dw	0x0A0A,0x0C0A,0x0C0C,0x0C0C,0x0C0C,0x0E0E,0x0E0E,0x0E0E
	dw	0x100E,0x1010,0x1010,0x1210,0x1212,0x1212,0x1414,0x1414
	dw	0x1614,0x1616,0x1616,0x1818,0x1818,0x1A1A,0x1C1A,0x1C1C
	dw	0x1E1C,0x1E1E,0x2020,0x2220,0x2222,0x2424,0x2624,0x2826
	dw	0x2828,0x2A2A,0x2D2D,0x2F2D,0x312F,0x3331,0x3533,0x3735
	dw	0x3937,0x3B39,0x3D3D,0x3F3F,0x4341,0x4543,0x4747,0x4B49
	dw	0x4D4B,0x514F,0x5353,0x5755,0x5B59,0x5F5D,0x615F,0x6563
	dw	0x6967,0x6D6B,0x736F,0x7775,0x7B79,0x7F7D,0x8681,0x8A88
	dw	0x908C,0x9692,0x9A98,0xA09E,0xA6A4,0xAEAA,0xB4B0,0xBAB8
	dw	0xC2BE,0xCAC6,0xD0CC,0xD9D4,0xE5DD,0xEDE9,0xF7F1,0xFFFB
