; ==========================================================================
;
; MIOS Audio Mixer
;
; (C)2007, 2008 Lyle Hazelwood (lylehaze@bellsouth.net)
; Based on example code Copyright (C) 2005  Pilo Chambert (pilo.c@wanadoo.fr)
; 
; ==========================================================================
;
; The files used in the making of this application are (c) 2008 Lyle Hazelwood
; They may be used without charge for personal, non-profit use only.
; Sale of any product that contains code from this project, in whole or part, 
; requires previous consent in writing from the author.
;
; ==========================================================================

;setlevels.inc
;Simple.. Call Mid2Gain to read a variety of MIDI controls and create
;channel gain settings for the PGA volume array.
;
;Inputs:
;MIDI1  Table of 16 * 8 bytes of MIDI data
;mastr  Master volume register, values from 0 to 127
;
;outputs:
;CHANNEL_GAIN_0	A table of up to 64 volume settings, each valued from 0 to 255
;This tables values will be overwritten with each call to setlevels.
;

#DEFINE center 64	;the center of volume/pan settings
#DEFINE fx1pre  mybits,0    ;FX1 will be pre-fader if set           (CC80) > 63 ON,< 64 OFF
#DEFINE fx2pre  mybits,1    ;FX2 will be pre-fader if set           (CC81) > 63 ON,< 64 OFF
#DEFINE fx1mute mybits,2    ;FX1 will be MUTED if set               (CC82) > 63 ON,< 64 OFF
#DEFINE fx2mute mybits,3    ;FX2 will be MUTED if set               (CC83) > 63 ON,< 64 OFF
#DEFINE withfx  mybits,4    ;This channel includes 2 FX sends       (CC15) > 63 ON,< 64 OFF

#DEFINE validdata mybits,6
#DEFINE needcalc mybits,7   ;This channels settings have changed.   (internal)

;This will multiply 16 bit unsigned values in ARG1H:L and ARG2H:L
;Placing the result into RES3:RES0
;This was lifted straight from MChip example code
Mult16
        MOVF ARG1L, W
        MULWF ARG2L ; ARG1L * ARG2L ->
        ; PRODH:PRODL
        MOVFF PRODH, RES1 ;
        MOVFF PRODL, RES0 ;
        ;
        MOVF ARG1H, W
        MULWF ARG2H ; ARG1H * ARG2H ->
        ; PRODH:PRODL
        MOVFF PRODH, RES3 ;
        MOVFF PRODL, RES2 ;
        ;
        MOVF ARG1L, W
        MULWF ARG2H ; ARG1L * ARG2H ->
        ; PRODH:PRODL
        MOVF PRODL, W ;
        ADDWF RES1 ; Add cross
        MOVF PRODH, W ; products
        ADDWFC RES2 ;
        CLRF WREG ;
        ADDWFC RES3 ;
        ;
        MOVF ARG1H, W ;
        MULWF ARG2L ; ARG1H * ARG2L ->
        ; PRODH:PRODL
        MOVF PRODL, W ;
        ADDWF RES1 ; Add cross
        MOVF PRODH, W ; products
        ADDWFC RES2 ;
        CLRF WREG ;
        ADDWFC RES3 ;
        RETURN

; This method uses a structure of Flag Bits, Vol,Expression,Balance,FX1,FX2
; Master is in Access Ram
;starting at MIDI1
Mid2Gain
;This routine will scan 16 channels of MIDI settings and create a table of
;gain outputs to be sent to the PGA array.
;Only channels with the "need calc" bit set will be processed.
        LFSR    FSR1,CHANNEL_GAIN_0 ;point to first element of output table
        LFSR    FSR0,MIDI1          ;point to first element in first channel
        MOVLW   16                  ;we process 16 channels
        MOVWF   paircount           ;our channel counter
nxchan          ;for each channel...
        BTFSC   INDF0,7             ;test "need calc" bit
        BRA     calcchannel         ;yes, go do calculations
        MOVLW   2                   ;or skip 2 or 4 PGA channels
        ADDWF   FSR1L
        BTFSC   INDF0,4             ;depending on "withFX" bit
        ADDWF   FSR1L
        MOVLW   8                   ;then skip this channel data
        ADDWF   FSR0L
        BRA     fini
calcchannel                         ;from here, we will calculate all channel settings
        MOVF    INDF0,W
        MOVWF   mybits              ;get this channels flag bits into mybits
        
        BCF     POSTINC0,7          ;reset "Need Calc" bit

        MOVF    POSTINC0,W          ;Load V into W
        MULWF   POSTINC0            ;multiply with E
        MOVFF   PRODH,ARG1H         ;Volume * Expression now into ARG1H:L
        MOVFF   PRODL,ARG1L
        MOVF    INDF0,W             ;Get balance setting
        SUBLW   .128                ;Left side inversion
        MULWF   mastr               ;Mult with Master Volume
        MOVFF   PRODH,ARG2H         ;Bal * Mastr in Arg2H:L
        MOVFF   PRODL,ARG2L
        
        CALL Mult16
; We now have a 32 bit result in RES3:RES0 for left channel level.
;Bitmap shows VVVV VHHH , HLLL LXXX , XXXX XXXX , XXXX XXXX
;where V=Overflow value, H is high nibble of result, L is low nibble
        ;test for saturation
        MOVF    RES3,W
        ANDLW   0xF8    ;test for over max volume
        BZ      DoLeft  ;if result is zero, calc
        MOVLW   0xFF
        MOVWF   POSTINC1 ;saturate left channel
        BRA     StartRight
        ;
DoLeft  ;If not saturated, do a proper calculation
        RLCF    RES2,W  ;low result in top half of RES2
        ANDLW   0XF0
        MOVWF   RES2
        RLCF    RES3,W  ;high result in bottom half of RES3
        ANDLW   0x0F
        IORWF   RES2,W  ;combined, low over high
        SWAPF   WREG    ;now fixed properly
        CALL    LogByte ;apply Log curve
        MOVWF   POSTINC1    ;load out to gain table Left
        
        ;from this point, assume that ARG1H:L still have accurate
        ;V*E data.
StartRight
        MOVF    POSTINC0,W          ;Get balance setting
        MULWF   mastr               ;Mult with Master Volume
        MOVFF   PRODH,ARG2H         ;Bal * Mastr in Arg2
        MOVFF   PRODL,ARG2L
        
        CALL    Mult16
; We now have a 32 bit result in RES3:RES0 for right channel level.
;Bitmap shows VVVV VHHH , HLLL LXXX , XXXX XXXX , XXXX XXXX
;where V=Overflow value, H is high nibble of result, L is low nibble
        ;test for saturation
        MOVF    RES3,W
        ANDLW   0xF8    ;test for over max volume
        BZ      GetRight ;if result is zero, skip this return
        MOVLW   0xFF
        MOVWF   POSTINC1 ;Saturate right
        BRA     CheckFX
        ;
GetRight
        RLCF    RES2,W  ;result in top half of RES2
        ANDLW   0XF0
        MOVWF   RES2
        RLCF    RES3,W  ;and bottom half of RES3
        ANDLW   0x0F
        IORWF   RES2,W
        SWAPF   WREG
        CALL    LogByte ;apply Log curve
        MOVWF   POSTINC1    ;load out to gain table Right
CheckFX
        ;if we do not have Fx attached, we are done with this channel
        BTFSC   withfx
        BRA     StartF1
        MOVLW   4
        ADDWF   FSR0L   ;update data pointer to next channel
        BRA     fini

StartF1 ; we begin with Effects Loop 1 may be muted
        BTFSS   fx1mute ;are we muted?
        BRA     F1NotMute
        CLRF    POSTINC1    ;mute this output
        MOVF    POSTINC0    ;advance to next data position
        BRA     StartF2
F1NotMute
        BTFSS   fx1pre  ;are we pre or post?
        BRA     Post1
        MOVF    POSTINC0,W  ;Get FX1 setting
        MULWF   mastr       ;multiply with Master Volume
        ;result is now VVHH HHLL, LLXX XXXX
        ;with V=Overflow, H=High nibble, L=Low Nibble, X=ignore
        MOVF    PRODH,W     ;Check high byte of result
        ANDLW   0xC0        ;test for saturation
        BZ      DoF1Pre
        MOVLW   0xFF
        MOVWF   POSTINC1    ;saturate F1
        BRA     StartF2     ;go on to next FX loop
DoF1Pre
        RLCF    PRODL
        RLCF    PRODH
        RLCF    PRODL
        RLCF    PRODH,W
        CALL    LogByte
        MOVWF   POSTINC1    ;pre-fader FX is set
        BRA     StartF2

Post1
        ;Post-Fader, including Master
        MOVF    POSTINC0,W  ;Get FX1 setting
        MULWF   mastr
        MOVFF   PRODH,ARG2H         ;FX1 * Mastr in Arg2
        MOVFF   PRODL,ARG2L
        
        CALL    Mult16
; We now have a 32 bit result in RES3:RES0 for fx1 level.

        ;test for saturation
        MOVF    RES3,W
        ANDLW   0xF0    ;test for over max volume
        BZ      GetF1 ;if result is zero, skip this return
        MOVLW   0xFF
        MOVWF   POSTINC1 ;Saturate F1
        BRA     StartF2
        ;
GetF1
        MOVF    RES2,W  ;result in top half of RES2
        ANDLW   0XF0
        MOVWF   RES2
        MOVF    RES3,W  ;and bottom half of RES3
        ANDLW   0x0F
        IORWF   RES2,W
        SWAPF   WREG
        CALL    LogByte     ;apply Log curve
        MOVWF   POSTINC1    ;load out to FX1
StartF2
        BTFSS   fx2mute     ;are we muted?
        BRA     F2NotMute
        CLRF    POSTINC1    ;mute this output
        MOVF    POSTINC0    ;advance to next data position
        MOVF    POSTINC0    ;advance to next data position
        MOVF    POSTINC0    ;advance to next data position
        BRA     fini
F2NotMute
        BTFSS   fx2pre      ;are we pre or post?
        BRA     Post2
        MOVF    POSTINC0,W  ;Get FX2 setting
        MOVF    POSTINC0    ;advance to next data position
        MOVF    POSTINC0    ;advance to next data position
        MULWF   mastr       ;multiply with Master Volume
        MOVF    PRODH,W     ;Check high byte of result
        ANDLW   0xC0        ;test for saturation
        BZ      DoF2Pre
        MOVLW   0xFF
        MOVWF   POSTINC1    ;saturate F2
        BRA     fini
DoF2Pre
        RLCF    PRODL
        RLCF    PRODH
        RLCF    PRODL
        RLCF    PRODH,W
        CALL    LogByte
        MOVWF   POSTINC1    ;pre-fader FX2 is set
        BRA     fini    

Post2
        ;Post-Fader, including Master
        MOVF    POSTINC0,W  ;Get FX2 setting
        MULWF   mastr
        MOVF    POSTINC0    ;update FSR0 to next channel
        MOVF    POSTINC0
        MOVFF   PRODH,ARG2H         ;FX1 * Mastr in Arg2
        MOVFF   PRODL,ARG2L
        
        CALL    Mult16
; We now have a 32 bit result in RES3:RES0 for fx1 level.

        ;test for saturation
        MOVF    RES3,W
        ANDLW   0xF0    ;test for over max volume
        BZ      GetF2 ;if result is zero, skip this return
        MOVLW   0xFF
        MOVWF   POSTINC1 ;Saturate F2
        BRA     fini
        ;
GetF2
        MOVF    RES2,W  ;result in top half of RES2
        ANDLW   0XF0
        MOVWF   RES2
        MOVF    RES3,W  ;and bottom half of RES3
        ANDLW   0x0F
        IORWF   RES2,W
        SWAPF   WREG
        CALL    LogByte ;apply Log curve
        MOVWF   POSTINC1    ;load out to FX2

fini
        DECFSZ  paircount
        BRA     nxchan
        return
        
