;
; PGA Example, Part 1
;
; Purpose:
;    -> Set the gain of a PGA chip (PGA2310/2311/4311)
;    -> Allow control by local encoder(s) or MIDI.
;    -> Display name and levels of last change.
;
; ==========================================================================
;
; MIOS Audio Mixer
;
; (C)2007, 2008 Lyle Hazelwood (lylehaze@bellsouth.net)
; Based on example code Copyright (C) 2005  Pilo Chambert (pilo.c@wanadoo.fr)
; 
; ==========================================================================
;
; The files used in the making of this application are (c) 2008 Lyle Hazelwood
; They may be used without charge for personal, non-profit use only.
; Sale of any product that contains code from this project, in whole or part, 
; requires previous consent in writing from the author.
;
; ==========================================================================
;; ---[ MIOS header file ]---
#include "mios.h"

;; ---[ useful macros ]---
#include "macros.h"

;; ---[ vectors to MIOS functions (never change!) ]---
#include "mios_vectors.inc"

;; ---[ user hooks (never change!) ]---
#include "user_vectors.inc"

;; ==========================================================================
;;  General Application Settings
;; ==========================================================================

;; ---[ variables used by application ]---
#include "app_defines.h"

; ==========================================================================

;; ---[ configuration table for MIDI processor and rotary encoders ]---
#include "mios_tables.inc"
	
;; lcd fucntions
#include "user_lcd.inc"

;; pga functions
#include "pga.inc"
	
#include "preset.inc"

	;MIDI volume/Pan/Balance handling
#include "setlevels.inc"

	;logarithmic conversion tables
#include "logbyte.inc"
;; ==========================================================================
;;  All MIOS hooks in one file
;; ==========================================================================



;; --------------------------------------------------------------------------
;;  This function is called by MIOS after startup to initialize the
;;  application
;; --------------------------------------------------------------------------
USER_Init
	;; define number of shift registers: for 128 IOs, we need
	;; 16 registers. Btw.: thats the maximum number of supported DIN/DOUTs
	movlw	1
	call	MIOS_SRIO_NumberSet

	;; define the update frequency (latency) of DIN/DOUTs in mS
	movlw	1 ; ms
	call	MIOS_SRIO_UpdateFrqSet

	;; Setup pga and gain to 0dB
	call	PGA_Init

;	call	PGA_LoadPreset	;removed because I don't use it.
	return


;; --------------------------------------------------------------------------
;;  This function is called by MIOS in the mainloop when nothing else is to do
;; --------------------------------------------------------------------------
USER_Tick

	return

;; --------------------------------------------------------------------------
;;  This function is periodically called by MIOS. The frequency has to be
;;  initialized with MIOS_Timer_Set
;;  Note that this is an interrupt service routine! Use FSR2 instead of FSR0
;;  and IRQ_TMPx instead of TMPx -- and make the routine as fast as possible!
;; --------------------------------------------------------------------------
USER_Timer
	return


;; --------------------------------------------------------------------------
;;  This function is called by MIOS when a debug command has been received
;;  via SysEx
;;  Input:
;;     o WREG, MIOS_PARAMETER1, MIOS_PARAMETER2, MIOS_PARAMETER3 like
;;       specified in the debug command
;;  Output:
;;     o return values WREG, MIOS_PARAMETER1, MIOS_PARAMETER2, MIOS_PARAMETER3
;; --------------------------------------------------------------------------
USER_MPROC_DebugTrigger
	return


;; --------------------------------------------------------------------------
;;  This function is called by MIOS when the display content should be
;;  initialized. Thats the case during startup and after a temporary message
;;  has been printed on the screen
;; --------------------------------------------------------------------------
USER_DISPLAY_Init
	call	MIOS_LCD_Clear			; clear LCD

	TABLE_ADDR TEXT_WELCOME_0		; print welcome message
	call	MIOS_LCD_PrintString
	TABLE_ADDR TEXT_WELCOME_1		; print welcome message
	call	MIOS_LCD_PrintString

	return
; Here's my tacky startup text
TEXT_WELCOME_0	STRING 20, 0x00, " MIDIBox Mixer V2.0 "
TEXT_WELCOME_1	STRING 20, 0x40, "   Lyle Hazelwood   "


;; --------------------------------------------------------------------------
;;  This function is called by MIOS when a complete MIDI event has been received
;;  Input:
;;     o first  MIDI event byte in MIOS_PARAMETER1
;;     o second MIDI event byte in MIOS_PARAMETER2
;;     o third  MIDI event byte in MIOS_PARAMETER3
;; --------------------------------------------------------------------------
;We simply look for messages we are interested in
USER_MPROC_NotifyReceivedEvent
	movf	MIOS_PARAMETER1,W	;get status byte
	andlw	0xF0				;mask out low half (ignore channel info)
	sublw	0xB0				;compare to control change?
	bz		contchg					
	movf	MIOS_PARAMETER1,W	;get status byte
	andlw	0xF0				;mask out low half (ignore channel info)
	sublw	0xC0				;compare to program change?
    btfss   STATUS,Z   
    return
    bra     progchg

contchg							;if we get here, we know it's SOME kind of control change
    LFSR    FSR0,MIDI1          ;point to MIDI data table
    MOVF    MIOS_PARAMETER1,W
    ANDLW   0x0F                ;channel number
    SWAPF   WREG                ;X 16
    RRNCF   WREG                ; / 2
    ADDWF   FSR0L               ;Now points to selected channel

    BSF     INDF0,7             ;set "recalc" bit
	movf	MIOS_PARAMETER1,W
	andlw	0x0F
	movwf	MIDI_DISP_CHAN
ck80
    MOVLW   .80                 ;looking for FX1 Pre/Post
    CPFSEQ  MIOS_PARAMETER2     ;compare to this CC
    BRA     ck81
    BTFSS   MIOS_PARAMETER3,6
    BCF     INDF0,0
    BTFSC   MIOS_PARAMETER3,6
    BSF     INDF0,0
    BRA     ccout
ck81    
    MOVLW   .81                 ;looking for FX2 Pre/Post
    CPFSEQ  MIOS_PARAMETER2     ;compare to this CC
    BRA     ck82
    BTFSS   MIOS_PARAMETER3,6
    BCF     INDF0,1
    BTFSC   MIOS_PARAMETER3,6
    BSF     INDF0,1
    BRA     ccout
ck82
    MOVLW   .82                 ;looking for FX1 Mute
    CPFSEQ  MIOS_PARAMETER2     ;compare to this CC
    BRA     ck83
    BTFSS   MIOS_PARAMETER3,6
    BCF     INDF0,2
    BTFSC   MIOS_PARAMETER3,6
    BSF     INDF0,2
    BRA     ccout
ck83
    MOVLW   .83                 ;looking for FX2 Mute
    CPFSEQ  MIOS_PARAMETER2     ;compare to this CC
    BRA     ck15
    BTFSS   MIOS_PARAMETER3,6
    BCF     INDF0,3
    BTFSC   MIOS_PARAMETER3,6
    BSF     INDF0,3
    BRA     ccout
ck15
    MOVLW   .15                 ;looking for WithFX
    CPFSEQ  MIOS_PARAMETER2     ;compare to this CC
    BRA     ck20
    BTFSS   MIOS_PARAMETER3,6
    BCF     INDF0,4
    BTFSC   MIOS_PARAMETER3,6
    BSF     INDF0,4
    BRA     ccout
ck20
    MOVLW   .20                 ;looking for SetFlags
    CPFSEQ  MIOS_PARAMETER2     ;compare to this CC
    BRA     ck22
    MOVFF   MIOS_PARAMETER3,INDF0
    BSF     INDF0,7
    BRA     ccout
ck22
    MOVLW   .22                 ;looking for SaveBank
    CPFSEQ  MIOS_PARAMETER2     ;compare to this CC
    BRA     ck120
    MOVF    MIOS_PARAMETER3,W
    CALL	saveboard
    BRA     ccout
ck120
    MOVLW   .120                ;looking for ALL RESET
    CPFSEQ  MIOS_PARAMETER2     ;compare to this CC
    BRA     ck7
    call 	PGA_Init
    return
ck7
    MOVF    PREINC0             ;advance to Volume Register
    MOVLW   .7                  ;looking for Volume
    CPFSEQ  MIOS_PARAMETER2     ;compare to this CC
    BRA     ck11
    MOVF    MIOS_PARAMETER3,W
    MOVWF   INDF0               ;new volume stored
    BRA     ccout
ck11
    MOVF    PREINC0             ;advance to Expression Register
    MOVLW   .11                 ;looking for Expression
    CPFSEQ  MIOS_PARAMETER2     ;compare to this CC
    BRA     ck8
    MOVF    MIOS_PARAMETER3,W
    MOVWF   INDF0               ;new Expression stored
    BRA     ccout
ck8
    MOVF    PREINC0             ;advance to Bal/Pan Register
    MOVLW   .8                  ;looking for Expression
    CPFSEQ  MIOS_PARAMETER2     ;compare to this CC
    BRA     ck10
    MOVF    MIOS_PARAMETER3,W
    MOVWF   INDF0               ;new Bal/Pan stored
    BRA     ccout
ck10
    MOVLW   .10                 ;looking for Pan
    CPFSEQ  MIOS_PARAMETER2     ;compare to this CC
    BRA     ck12
    MOVF    MIOS_PARAMETER3,W
    MOVWF   INDF0               ;new Bal/Pan stored
    BRA     ccout
ck12
    MOVF    PREINC0             ;advance to FX1 Register
    MOVLW   .12                 ;looking for FX1
    CPFSEQ  MIOS_PARAMETER2     ;compare to this CC
    BRA     ck13
    MOVF    MIOS_PARAMETER3,W
    MOVWF   INDF0               ;new FX1 stored
    BRA     ccout
ck13
    MOVF    PREINC0             ;advance to FX2 Register
    MOVLW   .13                 ;looking for FX2
    CPFSEQ  MIOS_PARAMETER2     ;compare to this CC
    BRA     ck21
    MOVF    MIOS_PARAMETER3,W
    MOVWF   INDF0               ;new FX2 stored
    BRA     ccout
ck21
    MOVLW   .21                 ;looking for SendMix
    CPFSEQ  MIOS_PARAMETER2     ;compare to this CC
    BRA     ck24
    MOVLW   0x0F
    ANDWF   MIOS_PARAMETER1,W
    CALL    txchan
    RETURN
ck24
	MOVLW	.24					; looking for Load preset(full bank)
	CPFSEQ	MIOS_PARAMETER2
	BRA		ck23
	MOVF	MIOS_PARAMETER3,W
	CALL	loadboard
ck23
    MOVLW   .23                 ;looking for MasterVol
    CPFSEQ  MIOS_PARAMETER2     ;compare to this CC
    BRA     ccout
    MOVF	MIOS_PARAMETER3,W
    MOVWF   mastr
    ; "fall through" to chg16
chg16
   ;modify all 16 channels for edit here
    LFSR	FSR0,MIDI1
    MOVLW	8
loopall16
    BSF		INDF0,7
    ADDWF	FSR0L
    BTFSS	FSR0L,7
    BRA		loopall16
    ; "fall through" to ccout
ccout
	call	Mid2Gain			;convert all MIDI settings into gain settings
	call	PGA_SEND_GAIN		;and send those settings out to the chips
	bsf		DISPLAY_UPDATE_REQ,0	;update the display
	return

progchg         ;If we get here, it's some kind of Program Change
    LFSR    FSR0,MIDI1          ;point to MIDI data table
    MOVF    MIOS_PARAMETER1,W
    ANDLW   0x0F                ;channel number
	MOVWF	MIDI_DISP_CHAN
    SWAPF   WREG                ;X 16
    RRNCF   WREG                ; / 2
    ADDWF   FSR0L               ;Now points to selected channel
    BSF     INDF0,5             ;set "recalc" bit
cklp    ;check for "Load Preset" 0 to 63
    BTFSC	MIOS_PARAMETER2,6   ;do we load or save?
    BRA		weload
wesave
	CALL	savechan
	BRA		ccout
weload
    CALL	loadchan
    bra     ccout               ;send data and return


;; --------------------------------------------------------------------------
;;  This function is called by MIOS when a MIDI event has been received
;;  which has been specified in the MIOS_MPROC_EVENT_TABLE table
;;  Input:
;;     o number of entry in WREG
;;     o first  MIDI event byte in MIOS_PARAMETER1
;;     o second MIDI event byte in MIOS_PARAMETER2
;;     o third  MIDI event byte in MIOS_PARAMETER3
;; --------------------------------------------------------------------------
USER_MPROC_NotifyFoundEvent
	return


;; --------------------------------------------------------------------------
;;  This function is called by MIOS when a MIDI event has not been completly
;;  received within 2 seconds
;; --------------------------------------------------------------------------
USER_MPROC_NotifyTimeout
	return


;; --------------------------------------------------------------------------
;;  This function is called by MIOS when a MIDI byte has been received
;;  Input:
;;     o received MIDI byte in WREG and MIOS_PARAMETER1
;; --------------------------------------------------------------------------
USER_MPROC_NotifyReceivedByte
	return


;; --------------------------------------------------------------------------
;;  This function is called by MIOS when an button has been toggled
;;  Input:
;;     o Button number in WREG and MIOS_PARAMETER1
;;     o Button value MIOS_PARAMETER2:
;;       - 1 if button has been released (=5V)
;;       - 0 if button has been pressed (=0V)
;; --------------------------------------------------------------------------
USER_DIN_NotifyToggle

	btfss	MIOS_PARAMETER2,0	;skip next line if button released
	return						;return if the button was pressed
	bsf	DISPLAY_UPDATE_REQ, 0	;update the display
	incf	MIDI_DISP_CHAN,f	;add one to the display channel
	movlw	channels-1
	cpfsgt	MIDI_DISP_CHAN		;if the channel number is greater than pairs,
	return
	clrf	MIDI_DISP_CHAN		;reset to zero
	return

;; --------------------------------------------------------------------------
;;  This function is called by MIOS when an encoder has been moved
;;  Input:
;;     o Encoder number in WREG and MIOS_PARAMETER1
;;     o signed incrementer value in MIOS_PARAMETER2:
;;       - is positive when encoder has been turned clockwise
;;       - is negative when encoder has been turned counter clockwise
;; --------------------------------------------------------------------------
USER_ENC_NotifyChange
	;; an encoder has been moved. 

	;; save encoder number in ENC_NUMBER
	movff	MIOS_PARAMETER1, ENC_NUMBER
	;; save incrementer in ENC_INC
	movff	MIOS_PARAMETER2, ENC_INC

	rgoto	USER_ENC_GAIN

;;--------------------------------------------------------------------------
USER_ENC_GAIN
	;; inc or dec the value store at MIDI channel selected
	;;
	bcf		DISPLAY_UPDATE_REQ,7
	movlw	d'2'				; the pin number for our pushbutton
	call	MIOS_DIN_PinGet		;check to see if button is pushed
	btfsc	WREG,0
	bsf		DISPLAY_UPDATE_REQ,7
				; DISPLAY_UPDATE_REQ bit 7 now reflects button up/down
				
	lfsr	FSR0,MIDI1			;point to stat of MIDI dats table
	movf	MIDI_DISP_CHAN,W	;Figure out what channel to play with
	swapf	WREG				;multiply channel by 8
	rrncf	WREG
	addwf	FSR0L				;now we point to the FLAGS of the channel in question
	
	bsf		POSTINC0,7			;edit flag set, we now point to volume
	
	movlw	2
	btfss	DISPLAY_UPDATE_REQ,7	;or maybe
	addwf	FSR0L			     ;MIDI Balance table

	;; branch depending on clockwise/counter clockwise turn
 	btfsc	MIOS_PARAMETER2, 7
	rgoto	USER_ENC_Handler_Para_Dec

USER_ENC_Handler_Para_Inc
	;; add incrementer to current parameter value
	movf	MIOS_PARAMETER2, W
	addwf	INDF0, F
	;; continue if value <= 0x7f
	movlw	0x7f
	cpfsgt	INDF0
	rgoto USER_ENC_Handler_Para_Cont
	;; else set max value
	movlw	0x7f
	movwf	INDF0
	rgoto	USER_ENC_Handler_Para_Cont

USER_ENC_Handler_Para_Dec
	;; subtract incrementer from current parameter value
	movf	MIOS_PARAMETER2, W	; (it's a negative value...)
	addwf	INDF0, F
	;; continue if no overflow
	bc	USER_ENC_Handler_Para_Cont
	;; else set value to zero
	clrf	INDF0
	;; 	rgoto	TC_ENC_Handler_Para_Cont

USER_ENC_Handler_Para_Cont
				;this will send the change out the MIDI Port.
	call	MIOS_MIDI_BeginStream
	movlw	0xB0
	addwf	MIDI_DISP_CHAN,W
	call	MIOS_MIDI_TxBufferPut
	movlw	0x07
	btfss	DISPLAY_UPDATE_REQ,7
	movlw	0x0a
	call	MIOS_MIDI_TxBufferPut
	movf	INDF0,W
	call	MIOS_MIDI_TxBufferPut
	call	MIOS_MIDI_EndStream

	bsf		DISPLAY_UPDATE_REQ, 0	;update the display
	call 	Mid2Gain
	call	PGA_SEND_GAIN
;	call	PGA_SavePreset	;I don't want to burn Flash every time I change the mix.
	return

;; --------------------------------------------------------------------------
;;  This function is called by MIOS before the shift register are loaded
;;  Note that this is an interrupt service routine! Use FSR2 instead of FSR0
;;  and IRQ_TMPx instead of TMPx -- and make the routine as fast as possible
;; --------------------------------------------------------------------------
USER_SR_Service_Prepare
	return


;; --------------------------------------------------------------------------
;;  This function is called by MIOS after the shift register have been loaded
;;  Note that this is an interrupt service routine! Use FSR2 instead of FSR0
;;  and IRQ_TMPx instead of TMPx -- and make the routine as fast as possible
;; --------------------------------------------------------------------------
USER_SR_Service_Finish
	return

;; --------------------------------------------------------------------------
;;  This function is called by MIOS when a pot has been moved
;;  Input:
;;     o Pot number in WREG and MIOS_PARAMETER1
;;     o LSB value in MIOS_PARAMETER2
;;     o MSB value in MIOS_PARAMETER3
;; --------------------------------------------------------------------------
USER_AIN_NotifyChange
	return

testhere
    ;status byte Bn for Control, Cn for ProgChange
;    MOVLW   0xB0
;    MOVWF   MIOS_PARAMETER1
    ;Which control or program change?
;    MOVLW   0x07
;    MOVWF   MIOS_PARAMETER2
    ;New value for Control CHange
;    MOVLW   0x07
;    MOVWF   MIOS_PARAMETER3
    CALL    USER_MPROC_NotifyReceivedEvent
    BRA     testhere
	END
