; ==========================================================================
;
; MIOS Audio Mixer
;
; (C)2007, 2008 Lyle Hazelwood (lylehaze@bellsouth.net)
; Based on example code Copyright (C) 2005  Pilo Chambert (pilo.c@wanadoo.fr)
; 
; ==========================================================================
;
; The files used in the making of this application are (c) 2008 Lyle Hazelwood
; They may be used without charge for personal, non-profit use only.
; Sale of any product that contains code from this project, in whole or part, 
; requires previous consent in writing from the author.
;
; ==========================================================================
;;----------------------------------------------------------
;; routines for saving and loading channels and entire banks
;;----------------------------------------------------------

#define saveblock   0x6000  ; we use 0x6000 to 0x7FFF
;; Each channel is 8 bytes, 16 channels make a board
;; 64 boards are available for saving and loading.

;loadboard will load the entire board from slot W
loadboard
	movwf	mybank			;0-63 source of copy
	TABLE_ADDR	saveblock	;start at the first board
	rrncf	mybank,W			;divide by two
	bcf		WREG,7				;reset top bit
	addwf	TBLPTRH,f			;add result to high table pointer
	movlw	0x80
	btfsc	mybank,0		;if we want an odd bank number
	addwf	TBLPTRL,f			;add an offset of 0x80 to the lower table pointer
    lfsr    1,MIDI1			; set the destination as our current settings.
	call	MIOS_FLASH_Read		;read half the board
    lfsr    1,MIDI9			;set our destination as the second half of current
	call	MIOS_FLASH_Read		;read the second half
		; now we need to flag everything as modified
	lfsr	1,MIDI1			;set the destination as our current settings
	clrf	WREG			;we start at the very beginning...
another
	bsf		PLUSW1,7		;set the modified bit for this channel
	bsf		PLUSW1,6		;settings are valid
	addlw	8				;point to next channel
	btfss	WREG,7			;test for end of board
	bra		another
	return

;loadchan is called to load a single channel
;from a given bank.
;channel is from low 4 bits of MIOS_PARAMETER1
;Bank is from low 6 bits of MIOS_PARAMETER2
loadchan
	TABLE_ADDR	saveblock	;now points to 0x6000 (start of bank memory)
	movlw	0x3F	;low 6 bits only 
	andwf	MIOS_PARAMETER2,W	;(board 0-63)
	movwf	mybank				;store full bank number in mybank
	rrncf	mybank,W			;divide bank num by 2
	bcf		WREG,7
	addwf	TBLPTRH,f	;high table pointer is now set
	movlw	0x80
	btfsc	mybank,0	;if it's an odd bank number, add 0x80
	addwf	TBLPTRL,f	;we now point to the start of the bank
	movlw	0x40
	btfsc	MIOS_PARAMETER1,3	;if we want an upper channel
	addwf	TBLPTRL,f	;table pointer is now at correct half-group
	lfsr	1,MEMBANK	;load to our buffer space
	call	MIOS_FLASH_Read	;half-bank now in MEMBANK
	lfsr	0,MIDI1		;FSR0 now points to current settings table
	btfsc	MIOS_PARAMETER1,3
	lfsr	0,MIDI9		;fsr0 now points to current half-table
	movlw	0x07	;low 3 bits of channel only
	andwf	MIOS_PARAMETER1,W
	swapf	WREG		; X 8
	rrncf	WREG
	addwf	FSR1L,f	;add offset to our membank
	addwf	FSR0L,f	;and add to our data pointer
	clrf	WREG
loophere	
	movff	PLUSW1,PLUSW0
	incf	WREG
	btfss	WREG,3
	bra		loophere
	bsf		INDF0,7
	bsf		INDF0,6
	return

;savechan is called with channel number in low nibble of MIOS_PARAMETER1
;and block number in low 6 bits of MIOS_PARAMETER2
savechan
	TABLE_ADDR	saveblock	;now points to 0x6000 (start of bank memory)
	movlw	0x3F	;low 6 bits only 
	andwf	MIOS_PARAMETER2,W	;(board 0-63)
	movwf	mybank				;store full bank number in mybank
	rrncf	mybank,W			;divide bank num by 2
	bcf		WREG,7
	addwf	TBLPTRH,f	;high table pointer is now set
	movlw	0x80
	btfsc	mybank,0	;if it's an odd bank number, add 0x80
	addwf	TBLPTRL,f	;we now point to the start of the bank
	movlw	0x40
	btfsc	MIOS_PARAMETER1,3	;if we want an upper channel
	addwf	TBLPTRL,f	;table pointer is now at correct half-group
	
	lfsr	1,MEMBANK	;load to our buffer space
	call	MIOS_FLASH_Read	;half-bank now in MEMBANK

	lfsr	0,MIDI1		;FSR0 now points to current settings table
	btfsc	MIOS_PARAMETER1,3
	lfsr	0,MIDI9		;fsr0 now points to current half-table
	;we need to increment fsr0 by chan half-group * 8
	movlw	0x07	;low 3 bits of channel
	andwf	MIOS_PARAMETER1,W	;now in W
	swapf	WREG
	rrncf	WREG	;X 8
	addwf	FSR0L,f
	clrf	WREG
wrtchan		
	movff	PLUSW0,PLUSW1	; copy current data to buffer space
	incf	WREG
	btfss	WREG,3
	bra		wrtchan	

	TABLE_ADDR	saveblock	;now points to 0x6000 (start of bank memory)
	rrncf	mybank,W			;divide bank num by 2
	bcf		WREG,7
	addwf	TBLPTRH,f	;high table pointer is now set
	movlw	0x80
	btfsc	mybank,0	;if it's an odd bank number, add 0x80
	addwf	TBLPTRL,f	;we now point to the start of the bank
	movlw	0x40
	btfsc	MIOS_PARAMETER1,3	;if we want an upper channel
	addwf	TBLPTRL,f	;table pointer is now at correct half-group

	call	MIOS_FLASH_Write

	return

;save entire board into slot W
saveboard
	movwf	mybank	;save off our bank number
	TABLE_ADDR	saveblock
	rrncf	mybank,W
	bcf		WREG,7
	addwf	TBLPTRH,f
	movlw	0x80
	btfsc	mybank,0
	addwf	TBLPTRL,f
	lfsr	1,MIDI1
	call	MIOS_FLASH_Write
	lfsr	1,MIDI9
	call MIOS_FLASH_Write
	return

