;; MBStor
; A SysEx interface to the Vinculum VMusic2 device

;
#define VIN_LAT_CS		LATC	; The chip select pin CS#
#define VIN_TRIS_CS		TRISC	; is connected to Port C.0
#define VIN_PIN_CS		0		; (CANNOT be shared with other outputs!)
#define VIN_CS			VIN_LAT_CS,VIN_PIN_CS
;
#define VIN_LAT_SCLK	LATC	; The Shift Clock pin SCLK
#define VIN_TRIS_SCLK	TRISC	; is connected to Port C.1
#define VIN_PIN_SCLK	1		
#define VIN_SCLK		VIN_LAT_SCLK,VIN_PIN_SCLK
;
#define VIN_LAT_DOUT	LATC	; The DATA OUT to MBStor
#define VIN_TRIS_DOUT	TRISC	; is connected to Port C.2
#define VIN_PIN_DOUT	2		
#DEFINE VIN_DOUT		VIN_LAT_DOUT,VIN_PIN_DOUT
;
#define VIN_PORT_DIN	PORTC	; The DATA IN from MBStor
#define VIN_TRIS_DIN	TRISC	; is connected to Port C.3
#define VIN_PIN_DIN		3		
#define VIN_DIN			VIN_PORT_DIN,VIN_PIN_DIN

#define vin_rcvsx  vin_bits,0
#define vin_byte2go vin_bits,1
#define vin_status vin_bits,2
#define vin_waswrite vin_bits,3

VIN_Init

	call	MIOS_MF_Disable
	call	MIOS_AIN_UnMuxed
	;; enable pin drivers
	bcf	VIN_LAT_CS,		VIN_PIN_CS
	bcf	VIN_TRIS_CS, 	VIN_PIN_CS
	bcf	VIN_LAT_SCLK,	VIN_PIN_SCLK
	bcf	VIN_TRIS_SCLK, 	VIN_PIN_SCLK
	bcf	VIN_LAT_DOUT,	VIN_PIN_DOUT
	bcf	VIN_TRIS_DOUT,	VIN_PIN_DOUT
	bsf	VIN_TRIS_DIN,	VIN_PIN_DIN
	
	return

VIN_PulseClock
	bcf	VIN_SCLK
	bsf	VIN_SCLK
	bcf	VIN_SCLK
	return
	
VIN_WriteBit
	btfsc	WREG,7
	bsf		VIN_DOUT
	btfss	WREG,7
	bcf		VIN_DOUT
	return

VIN_ReadBit
	btfsc	VIN_DIN
	bsf		WREG,0
	return

VIN_ReadStatus
	bcf		vin_status
	btfsc	VIN_DIN
	bsf		vin_status
	return
	 
VIN_Write
	movwf	vin_data		; store byte
	bsf	vin_byte2go			; set transmit bit

	bcf	VIN_DOUT			; bang the data out
	bcf	VIN_CS
	bcf	VIN_SCLK	;W1
	bsf	VIN_CS
	bsf	VIN_DOUT
	call VIN_PulseClock				; W2
	bcf	VIN_DOUT
	call VIN_PulseClock				; W3
	call VIN_PulseClock
	call VIN_WriteBit				; D1
	call VIN_PulseClock
	rlncf	WREG,f
	call VIN_WriteBit				; D2
	call VIN_PulseClock
	rlncf	WREG,f
	call VIN_WriteBit				; D3
	call VIN_PulseClock
	rlncf	WREG,f
	call VIN_WriteBit				; D4
	call VIN_PulseClock
	rlncf	WREG,f
	call VIN_WriteBit				; D5
	call VIN_PulseClock
	rlncf	WREG,f
	call VIN_WriteBit				; D6
	call VIN_PulseClock
	rlncf	WREG,f
	call VIN_WriteBit				; D7
	call VIN_PulseClock
	rlncf	WREG,f
	call VIN_WriteBit				; C1
	call VIN_PulseClock
	call VIN_ReadStatus
	call VIN_PulseClock
	bcf	VIN_CS
	call VIN_PulseClock
	;; now we have to sort out the results.
	btfss	vin_status	; was byte received OK?
	bcf		vin_byte2go	; yes, clear the send bit
	return
	
	
VIN_Read
	clrf	WREG
	bcf	VIN_DOUT
	bcf	VIN_CS
	bcf	VIN_SCLK	; R1
	bsf	VIN_CS
	bsf	VIN_DOUT
	call VIN_PulseClock				; R2
	call VIN_PulseClock				; R3
	bcf	VIN_DOUT
	call VIN_PulseClock
	call VIN_ReadBit				; D1
	call VIN_PulseClock
	rlncf	WREG,f
	call VIN_ReadBit				; D2
	call VIN_PulseClock
	rlncf	WREG,f
	call VIN_ReadBit				; D3
	call VIN_PulseClock
	rlncf	WREG,f
	call VIN_ReadBit				; D4
	call VIN_PulseClock
	rlncf	WREG,f
	call VIN_ReadBit				; D5
	call VIN_PulseClock
	rlncf	WREG,f
	call VIN_ReadBit				; D6
	call VIN_PulseClock
	rlncf	WREG,f
	call VIN_ReadBit				; D7
	call VIN_PulseClock
	rlncf	WREG,f
	call VIN_ReadBit				; C1
	call VIN_PulseClock
	call VIN_ReadStatus
	call VIN_PulseClock
	bcf	VIN_CS
	call VIN_PulseClock
	;; now we have to sort out the results.

	btfss	vin_status	; was byte received OK?
	call	xreply	    ; yes, pass along to user
	return
	