//MSQ-CC-BCR=========================================================================//
//======Synth-Programmer with CC-Automation==========================================//
//============2015 by Michael Sigl aka "Phatline,GreatFullTekk,GuteSigl,Technomiliz..."//
//non-commercial use only. All other rights reserved. Mios32 Based > www.ucapps.de=====//
//thx credits and all the best to TK...who have much off this possible...==============//
//=====================================================================================//

//NORD DRUM II ---- EDITON//
#include <mios32.h>
#include "app.h"
#include <FreeRTOS.h>
#include <portmacro.h>
#include <task.h>
#include <queue.h>
#include <semphr.h>
#include "tasks.h"
#include "file.h"
#include <string.h>
#include <stdio.h>
#include <math.h>
#include <seq_bpm.h>
#include "seq.h"
#include <app_lcd.h>

u16 song_step_pos_counter;

static void TASK_SEQ(void *pvParameters);
#define PRIORITY_TASK_SEQ		( tskIDLE_PRIORITY + 4 ) // higher priority than MIDI receive task!
static s32 NOTIFY_MIDI_Rx(mios32_midi_port_t port, u8 byte);
#define PRIORITY_TASK_PERIOD1MS          ( tskIDLE_PRIORITY + 2 ) // lower than MIDI

xSemaphoreHandle xSDCardSemaphore; 	// take and give access to SD-Card

static file_t midifile_fi; //used to read files from SD-Card

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//Patch Variables >>> Saved on SDCards (4x1000 Patches)
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
   u8 CC_SEQ[32] = {}; // Sequencer Variables which should be static, and not be morphed!!!!
   u8 Patch_Var_Automorph = 0; //morph data instead of switching between the states... this is only relevant for synth out not controller
   u8 Patch_Var_Automorph_time = 63; //Automorph time in CC 0-127
   u8 Patch_Var_Morph = 0; //if not in auto mode it can be done with cc

   //MSQ-CC-Based-Stuff
   u8 Button_Bank = 0; 
   u8 Velo_Morph_Clear_Sel = 0;
   u8 Velo_Morph_Clear_All = 0;
   u8 Velo_From_Note[8] = {0,0,0,0,0,0,0,0};
   u8 Velo_Morph_BTN = 0;
   u8 Velo_Morph_Offset[8] = {63,63,63,63,63,63,63,63};
   
   u8 Velo_Morph[8][32] = {//middle postion 0 64=+1  63=-1
      {63,63,63,63,63,63,63,63, 63,63,63,63,63,63,63,63, 63,63,63,63,63,63,63,63, 63,63,63,63,63,63,63,63},
      {63,63,63,63,63,63,63,63, 63,63,63,63,63,63,63,63, 63,63,63,63,63,63,63,63, 63,63,63,63,63,63,63,63},
      {63,63,63,63,63,63,63,63, 63,63,63,63,63,63,63,63, 63,63,63,63,63,63,63,63, 63,63,63,63,63,63,63,63},
      {63,63,63,63,63,63,63,63, 63,63,63,63,63,63,63,63, 63,63,63,63,63,63,63,63, 63,63,63,63,63,63,63,63},
      {63,63,63,63,63,63,63,63, 63,63,63,63,63,63,63,63, 63,63,63,63,63,63,63,63, 63,63,63,63,63,63,63,63},
      {63,63,63,63,63,63,63,63, 63,63,63,63,63,63,63,63, 63,63,63,63,63,63,63,63, 63,63,63,63,63,63,63,63},
      {63,63,63,63,63,63,63,63, 63,63,63,63,63,63,63,63, 63,63,63,63,63,63,63,63, 63,63,63,63,63,63,63,63},
      {63,63,63,63,63,63,63,63, 63,63,63,63,63,63,63,63, 63,63,63,63,63,63,63,63, 63,63,63,63,63,63,63,63}};

   u8 Mod_Matrix[8][32][32] = {{{}}}; //PLACHOLDER on SD-Card  for  Synths with Built In Modulation Matrix.... this would need a Hardware Matrix additional. 

   u8 CC_Store[8][32] = {{}}; //[Parts][CCs]  
   
   u8 MSQ_Store[8][32][256] =  {{}}; //[Parts][CCs][Step>Value] 
    
   u8 MSQ_Active[8] = {1,1,1,1,1,1,0,0};
   u8 MSQ_Active_mem[8] = {1,1,1,1,1,1,0,0};//to save and tomparary overide MSQ_Active
   u8 MSQ_LastMoved[8] = {};
   u8 MSQ_Loop_Indicator[8]  = {};
   u8 MSQ_Loop_Length_Set[8] = {1,1,1,1, 1,1,1,1}; //0-15 = Value of LED of a ring
   u8 MSQ_Clear_Sel = 0;
   u8 MSQ_Clear_All = 0;   
   u8 MSQ_Rec[8] = {};
   u8 MSQ_Rec_mem[8] = {}; //to save and tomparary overide MSQ_REC
   u8 MSQ_Mute_Remote = 0; //just mute the Datastream to the BCR
   

   //Sequencer Stuff
   u8  Rythm = 4;       //4x4=16, 5x3=15 usw... to calculate maximal duration per matrix page
   u8  RythmRepeat = 4; //4x4=16 === to get to a maximal loop length
       //Loop Stuff
   u8  SyncFlag = 0;    //to indicate that Loop Length has changed....  
   u16 StepPerPage = 16;//calculate from 0 on....so 0-15 are 16 Steps that are visible on the BLM with a 4/4Beat  
   u16 MainLoop = 16;   //max Length of the mainloop, if you always play shorter then 256 then you should set this to shorter values!!! (syncing all tracks togeter...)

  //Tact-Related Sequencer Stuff @ 384 PPQN
  s16 BaseTic = 12;  // 128th    12    Dotted 128th     18   128th Triplet     8   //32x12=384 tics
  s16 Tic = 384;  //32x12=384 tics between 2 Notes -- not to be saved ... just to calculate
  s8  PpqnDivider = 8; //4=16th speed, 2:8th speed
  s8  PpqnDividerCount = 1; //only to calculate....
  u8  BPM = 100;



//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//System Variables
////////////////////////////////////////////////

  //External MidiController Remote
  u8 Remote1Port = 32;  //connect there BCR2000     [32=UART0=Midi-A, 33=UART1=Midi-B]...
  u8 Remote1_Automate_CH = 0; //only the Synthesizer CCs
  u8 Remote1_Setting_CH  = 1; //only the Application Remote CCs (Record, Mute...)

  //Note, Clock, PC  SOURCE  &&  DESTINATION
  u8 PCChIN = 6;  //ProgramChange Input Channel  
  u8 PCPort = 33; //normaly same as MeloPort!!! 
  u8 MeloPort = 33; //connect there @IN SEQUENCER    @OUT SYNTHESIZERs
  u8 MeloCh[8]   ={6,7,8,9,10,11,4,5};   // receive Triggers (4 Melody Morph)  &  send the CCs to this CHannels  //ACT ALSO AS MIDIFILTER! avoid to much traffic!
  u8 DumpOutRate = 4; //starting with 0>1x34ms, 1>2*34=68ms, 2>3*34=102ms 3>4x34=136ms....every 2ms one of 34 CCs on 8 MidiChannels is dumped out 

  u8 TrigMidiThruClock = 1; //MeloPort send Midiclock reroute that to the UART-Outputs
  u8 TrigMidiThruTransport = 1; //If you have massive jitter, its maybe better to use the synths internal Clock and start it via Midi.
  
  u16 LED_Gestic_Rate = 100; //in milli seconds - changing Parameter Blinks and Actions
  u16 LED_Gestic_Duration = 1200; //Duration of the LED-Animation in ms (1500 = 1,5s)
  
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//CC Mapping- Internal > External
/////////////////////////////////
// What is IO Mapping: short: >>> PRESET >>> Routing! --- make it Fit to your SYNTH or SYNTHs! 
// I = Internal > the communication between BCR2000 & MSQ_CC_BCR
// O = External >  SYNTH

  u8 CC_Map_Mode = 0;  // 0:Deep Edit: ALL Automatable controlls for 1 Channel 
                        //              all 29 (of 32) Encoders on the BCR representing a Single Part.  
                        //              Here Automations REC & PLAY is possible
                        // 1:Channel Strip: 4 Controls on 8 Channels
                        //                  8x4 Vertical Rows, each Row representing 4CCs of one of the 8 Parts... take it as a Mixer-overview... 4 the most importent CCs 
                        //                  No Automation REC, because we automate already in Deep Edit 
                        //                  By using the 8 Buttons you can now switch between......?????
                        // There is a Switch on the BCR to toggle between both modes... so here you just initalize
      u8 Active_Part; //selected Synthpart-Remote
      // 4 CC_Route_Mode = 0:                  
      u8 CC_Map0[8][32] = { //CC_Map0 [Part] [Internal CC Nr] = value of external CC   >>    CC_Map1 [MidiChannel] [Remote/Source] Value = Value of Synth/Destination
            //  1st Row Horizontal     //  2nd Row Horizontal    //  3rd Row Horizontal    //  4th Row Horizontal
            {57,56,24,23,26,25,10,7,   15,17,14,16,18,19,20,21,  46,52,53,47,48,54,55,127, 50,51,49,30,58, 255,255,255},   // Nord Drum 2    Voice 1   MidiCh  7
            {57,56,24,23,26,25,10,7,   15,17,14,16,18,19,20,21,  46,52,53,47,48,54,55,127, 50,51,49,30,58, 255,255,255},   // Nord Drum 2    Voice 2   MidiCh  8
            {57,56,24,23,26,25,10,7,   15,17,14,16,18,19,20,21,  46,52,53,47,48,54,55,127, 50,51,49,30,58, 255,255,255},   // Nord Drum 2    Voice 3   MidiCH  9
            {57,56,24,23,26,25,10,7,   15,17,14,16,18,19,20,21,  46,52,53,47,48,54,55,127, 50,51,49,30,58, 255,255,255},   // Nord Drum 2    Voice 4   MidiCh 10
            {57,56,24,23,26,25,10,7,   15,17,14,16,18,19,20,21,  46,52,53,47,48,54,55,127, 50,51,49,30,58, 255,255,255},   // Nord Drum 2    Voice 5   MidiCh 11
            {57,56,24,23,26,25,10,7,   15,17,14,16,18,19,20,21,  46,52,53,47,48,54,55,127, 50,51,49,30,58, 255,255,255},   // Nord Drum 2    Voice 6   MidiCh 12
            {255,255,255,255,255,255,255,255,  255,255,255,255,255,255,255,255,  255,255,255,255,255,255,255,255,  255,255,255,255,255,255,255,255},  //not in Use
            {255,255,255,255,255,255,255,255,  255,255,255,255,255,255,255,255,  255,255,255,255,255,255,255,255,  255,255,255,255,255,255,255,255}}; //not in Use          
       //   {45,46,47,48,62,5,63,61,   18,19,20,21,30,31,58,57,  14,15,16,17,28,29,54,55,  56,50,51,52,53, 255,255,255},   // Waldorf Pulse1 Page  1   MidiCh  6
       //   {32,36,102,24,109,112,115, 33,37,103,25,108,111,117, 34,38,106,26,110,113,116, 35,39,41,40,27, 255,255,255}};  // Waldorf Pulse1 Page  2   MidiCh  6
        //  {100,101,102,103,104,105,106,107,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, //example Jomox Mbase01 100-107

      u8 Active_Strip_Set = 0; //Active Channel Strip SET
      u8 Strip_CH = 0; //last Mooved Encoder makes Channelstrip Nummer...?
      // 4 CC_Route_Mode = 1:                  
      u8 CC_Map1[8][32] = { //CC_Map1 [Active_Strip_Set] [CC to remap to Map0]
            //  1st Row Horizontal     //  2nd Row Horizontal    //  3rd Row Horizontal    //  4th Row Horizontal
            {1, 1, 1, 1, 1, 1, 255,255, 28,28,28,28,28,28, 255,255, 3, 3, 3, 3, 3, 3,  255,255, 7, 7, 7, 7, 7, 7, 255,255},   // Channel-Strip-Set1 (Mixer)
            {8, 8, 8, 8, 8, 8, 255,255, 9, 9, 9, 9, 9, 9,  255,255, 4, 4, 4, 4, 4, 4,  255,255, 5, 5, 5, 5, 5, 5, 255,255},   // Channel-Strip-Set2 (Filter)
            {15,15,15,15,15,15,255,255, 19,19,19,19,19,19, 255,255, 24,24,24,24,24,24, 255,255, 25,25,25,25,25,25,255,255},   // Channel-Strip-Set2 (Decay)
            {255,255,255,255,255,255,255,255, 255,255,255,255,255,255,255,255, 255,255,255,255,255,255,255,255, 255,255,255,255,255,255,255,255}, //not used
            {255,255,255,255,255,255,255,255, 255,255,255,255,255,255,255,255, 255,255,255,255,255,255,255,255, 255,255,255,255,255,255,255,255}, //not used
            {255,255,255,255,255,255,255,255, 255,255,255,255,255,255,255,255, 255,255,255,255,255,255,255,255, 255,255,255,255,255,255,255,255}, //not used
            {255,255,255,255,255,255,255,255, 255,255,255,255,255,255,255,255, 255,255,255,255,255,255,255,255, 255,255,255,255,255,255,255,255}, //not used
            {255,255,255,255,255,255,255,255, 255,255,255,255,255,255,255,255, 255,255,255,255,255,255,255,255, 255,255,255,255,255,255,255,255}};//not used


      // POSSIBLE VALUES:
      // * 0-127 CC (normal Midi ControlChange)
      // The Following are Master OFFsets for CCs: what is a Master-Offset? > 
      // * 128: Master Offset for CC0
      // * 129: Master Offset for CC1
      // * 130: Master Offset for CC2
      // * 131: Master Offset for CC3
      // * 255: should make always BLANK dont matter what you moove - to indicate there is nothing to control with, why are the last 3 always 255? because i need that controlls for the APP.
      //        However we loose the Offset-Mapping for the 128th CC with that!




/*
//CC-Routing-2-Synth MIN MAX Value >>> PRESET >>> Routing! ... for example you dont need full Attack (because it is a bassliner) but want to use alle 16LEDs to show it...
  //Example Waldorf Pulse 2    
  u8  CC_Map0_MinMax[8][32][2] = {
      {0,0,0,0,0,0,0,0,       0,0,0,0,0,0,0,0,       0,0,0,0,0,0,0,0,       0,0,0,0,0,0,0,0}
      {127,127,127,127,127,127,127,127,   127,127,127,127,127,127,127,127,   127,127,127,127,127,,127,127,127,   127,127,127,127,127,127,127,127},
 
      */

     

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//Coding only Variables --- No normally user Settings here
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

   //AutoMorph
   u8 Patch_Var_Automorph_count = 0;
   u8 CC_Store_Morph_Calc_Flag = 0; //say that it has to calculated the Morphfactor fist bevor dumping out
   u8 CC_Store_old[8][32] = {{}};//actual CC_Store
   u8 CC_Store_Automorph[8][32] = {{}}; //something between old and new state (to switch between Patch-variants))
   //LED Gestics
   u8 LED_Gestic = 0; //0:Just Display Rythm Set and BPM blink
  u16 LED_Gestic_count = 0;
   u8 LED_toggle = 0;
  u16 LED_Gestic_move = 0;
  u16 LED_Gestic_Duration_Count = 0;
  u16 LED_Gestic_Blink_count = 0;
  u16 LED_Gestic_Blink = 1;
   u8 LED_Gestic_Blink_toggle = 1;  
  
   u8 ONEFLAG  = 0; //ONE TIME OPERATION FLAG -- for not looped gestics
   u8 BUSYFLAG = 0; //dont change the Gestic!
   u8 Dump_Patch_Out_Flag = 0;
  u16 DumpCount = 0;
   u8 DumpRateCount = 0;
   u8 SYX_FLAG = 0;
   
   u8 Patch_Morph[8] = {63,63,63,63,63,63,63,63};
   u16 PCIN = 0; //received Programchange Value 

    u8 sdcard_available;
    u8 availableSD;
 
//Store-Load Variables

   u8 System_First_Run_Flag = 1; // when first Run the machine, and you dont load a Preset, and you program a sound, and then you switch 
   u16 LoadCount = 200;
   u8 Patch_Var_Dummy[4] = {}; //just need to load data into when loading a patch variante, but not wanting to load the Variante Nr to recalled!!!
   u8 Patch_Var_Active[4] = {0,0,0,0};   //Actual Loaded Variant ....only use 1 of it...
   u8 Patch_Var_Save = 0;
   u8 Patch_Var_Load = 0;
   u8 Patch_Save = 0;
   u8 Patch_Load = 0;
   u8 Patch_Var_Copy = 0;
   u8 Patch_Var_Paste = 0;
   
   u16 Patch_Nr_Load = 0;			  
   u16 Patch_Nr_Save = 0;
   
   char file_typeBank[4] = "MQ01";	//should always be 4, and not longer then 4 chars!!! //definie the Filetype which is later saved via "FILE_WriteBuffer" into the file header (use Text/Hex-Editor to proove)
   char filepathS[8];				//STORE-path - Number of Pathsymbols t/512.tm >>> 8! >> again: dont change the length, or you will have to change the code	
   char filepathL[8];				//LOAD -path - Number of Pathsymbols t/512.tm >>> 8! >> again: dont change the length, or you will have to change the code	
   u8  PCLoad;                //if 0 then load the Programchange that is currently changed (Load Button)
   s8  statusSD = 0;					//Status of the SDCard--connected? fat?
   s8 statusDir = 0;					//Status "is" your direction "sdcard/t" there?
   u16 SDCardCount = 0;
   u8 LoadFlag =  0;
   u8 PCLoadFlag = 0;          //Activate Timer to Load ProgramChanges from external source after a time (2seconds)
   u8 PCLoadFlagCount = 0;     //and a timer for that

//Task Prioritys	
#define PRIORITY_StoreLoad          ( tskIDLE_PRIORITY + 2 ) //3:Mios standart
#define PRIORITY_MSQ	            ( tskIDLE_PRIORITY + 2 ) //4:high
#define PRIORITY_Patch_Morph        ( tskIDLE_PRIORITY + 2 ) //4:high                   
#define PRIORITY_APP_Tick	        ( tskIDLE_PRIORITY + 2 ) //2 lower then midi

// local prototype of the task function
static void StoreLoad(u8 tick, u16 order);
static void Router(u32 port, u32 channel, u32 control, s32 value);
static void Patch_Morphing(u8 update);

void APP_Init(void){
  // initialize all LEDs
  MIOS32_BOARD_LED_Init(0xffffffff);
  
  // initialize J5A pin1-3 & J5B pin0-3 as outputs in Push-Pull Mode
  int pin;
  for(pin=1; pin<8; ++pin) {MIOS32_BOARD_J5_PinInit(pin, MIOS32_BOARD_PIN_MODE_OUTPUT_PP);}
     int a; for(a=1; a<8; a++) { MIOS32_BOARD_J5_PinSet(a, 0);} //Turn off all LEDs
      
  // initialize pin 0 of J5A,  as Digital input with internal Pull-Up
    MIOS32_BOARD_J5_PinInit(0, MIOS32_BOARD_PIN_MODE_INPUT_PU);    
    
    Tic = 32 * BaseTic; //32x12=384  //here is the screw to change the Sequencer Resulution!!! make 64 or 16 for example instead of 32

	xSDCardSemaphore 	= xSemaphoreCreateRecursiveMutex();												// create semaphores
	FILE_Init(0);																						// initialize file functions


  // SEQUENCER TASKS
  MIOS32_BOARD_LED_Set(1, 0);
  SEQ_Init(0);   // initialize sequencer
  MIOS32_MIDI_DirectRxCallback_Init(NOTIFY_MIDI_Rx);
  xTaskCreate(TASK_SEQ, (signed portCHAR *)"SEQ", configMINIMAL_STACK_SIZE, NULL, PRIORITY_TASK_SEQ, NULL);   // install sequencer task     
  
  //Clear Motion Sequences
  int x; for(x=0; x<32; x++) { int y; for(y=0; y<256; y++) { MSQ_Store[0][x][y]=128;
                                                             MSQ_Store[1][x][y]=128;
                                                             MSQ_Store[2][x][y]=128;
                                                             MSQ_Store[3][x][y]=128;
                                                             MSQ_Store[4][x][y]=128;
                                                             MSQ_Store[5][x][y]=128;
                                                             MSQ_Store[6][x][y]=128;
                                                             MSQ_Store[7][x][y]=128; }} //[Parts][CCs][Step>Value]  
                                                                                                             
     LED_Gestic=0; //LED-Gestic Show Rythm-Set 

    //Dump Remote Buttons Out     
    MIOS32_MIDI_SendCC(Remote1Port, Remote1_Setting_CH, 15, CC_Map_Mode);                                                                              
}

void APP_Background(void){ //Set Bet Structure without LCD but with PIN 1 of J5A
 
  u8 old_state;
     old_state = 1;   // initialize pin state to inactive value
  u8 state_count = 0; // to avoid double triggering - since we have to values by pressing and depressing!!!!
  u8 rythm_count = 1;

//BCR-LAYOUT-SYSEX-DUMP
if(MIOS32_BOARD_J5_PinGet(0) == 0) {SYX_FLAG = 1;}//The "RYTHM" Button was presse while powering up: make sysexdump to BCR2000 with preset from SD-Card, to initalize the BCR-Layout HURRAY!

  while( 1 ) { // endless loop
    // check each J5 pin 0 for changes
      u8 new_state = MIOS32_BOARD_J5_PinGet(0);

      // pin changed?
      if( new_state != old_state ) {
    // store new state
    old_state = new_state;
      
      state_count++;
      if(state_count == 2){ 
                state_count = 0;
                rythm_count++;
                    //how many steps has a page? --- this comes from LED-Button-Matrix Sequencers...
                    if(rythm_count == 1)  {Rythm = 3; StepPerPage = 12;}                  //3/4
                    if(rythm_count == 2)  {Rythm = 4; StepPerPage = 16;}                  //4/4
                    if(rythm_count == 3)  {Rythm = 5; StepPerPage = 10;}                  //5/4
                    if(rythm_count == 4)  {Rythm = 6; StepPerPage = 12;}                  //6/4
                    if(rythm_count == 5)  {Rythm = 7; StepPerPage = 14;}                  //7/4
                    if(rythm_count == 6)  {Rythm = 8; StepPerPage = 16;}                  //8/4
                    if(rythm_count  > 6)  {Rythm = 9; StepPerPage =  9; rythm_count = 0;} //9/4
    
                //Rythm repeats...5x5? or 5x50?
                    MainLoop = Rythm * RythmRepeat;
                    SyncFlag = 1;    //to give the order to change the loop...after some time it will change.
    
                    LED_Gestic=0; //LED-Gestic "Indicate Rythm & Show Rythm-Set"     
          
      }
      }
  }

}   

static void Router(u32 port, u32 channel, u32 control, s32 value) { //DIN, ENCs, MidiCC all together
    
  //CC-Automated CCs for Synths
  if(port == 0 && channel == 0) {
      
        // 0: Deep Edit Mode - ALL controlls for 1 Channel 
        if(CC_Map_Mode == 0) { 
            
            MSQ_LastMoved[Active_Part] = control; //save the last moved CC from your BCR2000 (need later to delete MotionSequences on it...)
            
            // Store CC
            if(Velo_Morph_BTN == 0){CC_Store[Active_Part][control] = value;}  //into CC-Storage for Automation
            if(Velo_Morph_BTN == 1){Velo_Morph[Active_Part][control] = value;}//into Velocity Morph for Velocity Automation!
    
            // Clear Selected Motion Sequences
            if(MSQ_Clear_Sel == 1) { //CLEAR MSQ only by pressed button
              int x; for(x=0; x<256; x++) {MSQ_Store[Active_Part][MSQ_LastMoved[Active_Part]][x]=128;}}
              
            // Talk to SYNTH
            if(Velo_Morph_BTN == 0){
                // Send CC       //Midi Port //Channel            //CC-Number                                       //CC-Value
                //                             of Active Part        of  [Part Number][last mooved CC Number]          of   [Part Number][last mooved CC Number]
                MIOS32_MIDI_SendCC(MeloPort, MeloCh[Active_Part], CC_Map0[Active_Part][MSQ_LastMoved[Active_Part]], CC_Store[Active_Part][MSQ_LastMoved[Active_Part]]);} 
        }

        // 1: Channel Strip - 4 Controls on 8 Channels
        if(CC_Map_Mode == 1) {
            
            // get Strip_CH
            if (control == 0 || control == 8  || control == 16 || control == 24) {Strip_CH = 0;}
            if (control == 1 || control == 9  || control == 17 || control == 25) {Strip_CH = 1;}
            if (control == 2 || control == 10 || control == 18 || control == 26) {Strip_CH = 2;}
            if (control == 3 || control == 11 || control == 19 || control == 27) {Strip_CH = 3;}
            if (control == 4 || control == 12 || control == 20 || control == 28) {Strip_CH = 4;}
            if (control == 5 || control == 13 || control == 21 || control == 29) {Strip_CH = 5;}
            if (control == 6 || control == 14 || control == 22 || control == 30) {Strip_CH = 6;}
            if (control == 7 || control == 15 || control == 23 || control == 31) {Strip_CH = 7;}
            
            // Store CC
            CC_Store[Strip_CH]  [ CC_Map1[Active_Strip_Set][control] ] = value;    //CC_Map1[8][32] 
            
            // Send CC       //Midi Port //Channel                  //CC-Number                                                   //CC-Value
            //                             of Active Part         of   [StripNr]  [Remapping]                                of       Strip CH    REMAP    Strip CH    Remap      Strip Set        BCR-CC
            MIOS32_MIDI_SendCC(MeloPort,  MeloCh[Strip_CH],    CC_Map0 [Strip_CH] [CC_Map1[Active_Strip_Set][control] ],     CC_Store[Strip_CH]  [CC_Map0 [Strip_CH] [CC_Map1[Active_Strip_Set][control]] ]);
        }                                                    
}    

  //CC-REMOTE THIS APP  
  if(port == 1 && channel == 0) {
      
        // Map Mode Toggle Switch
            if(control == 16) { CC_Map_Mode = value;
            
                // DUMP OUT 0: Deep Edit Mode - ALL controlls for 1 Channel 
                if(CC_Map_Mode == 0) {
                    
                    // Dump Rotary CCs 2 Remote out
                    int y; for(y=0; y<32; y++) { 
                        //But only if the CC is really used (128: not used/mapped)
                        if(CC_Store[Active_Part][y] != 128) {
                            MIOS32_MIDI_SendCC(Remote1Port, Remote1_Automate_CH, y, CC_Store[Active_Part][y]); 
                            }
                        //else turn off Encoder
                        else if(CC_Store[Active_Part][y] == 128) {
                            MIOS32_MIDI_SendCC(Remote1Port,   Remote1_Automate_CH,  y,  0);
                        }       
                    } 
                    // Dump Different States out
                    MIOS32_MIDI_SendCC(Remote1Port, Remote1_Setting_CH, 19, MSQ_Rec[Active_Part]); 
                    MIOS32_MIDI_SendCC(Remote1Port, Remote1_Setting_CH, 37, MSQ_Loop_Length_Set[Active_Part]);             
                    MIOS32_MIDI_SendCC(Remote1Port, Remote1_Setting_CH, 38, Velo_Morph_Offset[Active_Part]);  
                }
                    
                // DUMP OUT 1: Channel Strip - 4 Controls on 8 Channels
                if(CC_Map_Mode == 1) {                
                    
                    // Disable Record Switch
                    MIOS32_MIDI_SendCC(Remote1Port, Remote1_Setting_CH, 19, 0); 
     
                    // FIX THIS !!!
                    // Dump Rotary CCs 2 Remote out
                    int y; for(y=0; y<32; y++) { 
                        if(CC_Map1[Active_Strip_Set][y] != 255) {  // FIX
                            
                        // Send CC         //Midi Port    //Channel              //CC-Number                        //CC-Value
                        //                                of BCR                 of      [Strip Set num]  [0-32]    of       Strip CH    REMAP    Strip CH  Remap    Strip Set       BCR-CC
                        MIOS32_MIDI_SendCC(Remote1Port,   Remote1_Automate_CH,   y,    CC_Store[Strip_CH]  [CC_Map0 [Strip_CH] [CC_Map1[Active_Strip_Set][y]] ]);
                        } 
        
                        //else turn off Encoder
                        else if(CC_Map1[Active_Strip_Set][y] == 128) {
                            MIOS32_MIDI_SendCC(Remote1Port,   Remote1_Automate_CH,  y,  0);
                        } 
                    }                 
                }
                }       
                   
            // 0: Deep Edit Mode - ALL controlls for 1 Channel 
            if(CC_Map_Mode == 0) {      
                     
                    // Select Part Number
                    if(control < 8 && control >= 0) {
                        
                        // Active Part Number                
                        Active_Part = control;
                        
                            // Disable ALL Active-Part Switches, except the New one
                            int x; for(x=0; x<8; x++) {   if(x != Active_Part){ MIOS32_MIDI_SendCC(Remote1Port, Remote1_Setting_CH, x, 0);} }
                            //Enable the new Active Part Switch
                            MIOS32_MIDI_SendCC(Remote1Port, Remote1_Setting_CH, Active_Part, 1);
                            
                            // Dump Different Button States out
                            MIOS32_MIDI_SendCC(Remote1Port, Remote1_Setting_CH, 19, MSQ_Rec[Active_Part]); 
                            MIOS32_MIDI_SendCC(Remote1Port, Remote1_Setting_CH, 37, MSQ_Loop_Length_Set[Active_Part]);             
                            MIOS32_MIDI_SendCC(Remote1Port, Remote1_Setting_CH, 38, Velo_Morph_Offset[Active_Part]); 
                            
                            // Dump Rotary CCs 2 Remote out
                            int y; for(y=0; y<32; y++) { MIOS32_MIDI_SendCC(Remote1Port, Remote1_Automate_CH, y, CC_Store[Active_Part] [y] );}
                            }
                        
                    // The Rest of the Controlls
    
                    // MSQ Record - Btn & FootSwitch
                    if(control == 19 || control == 26) {MSQ_Rec[Active_Part] =! MSQ_Rec[Active_Part];   MIOS32_MIDI_SendCC(Remote1Port, Remote1_Setting_CH, 19, MSQ_Rec[Active_Part]); }     
                    // Rotary Loop Length Set
                    if(control == 37) {MSQ_Loop_Length_Set[Active_Part] = value; SyncFlag = 1;}  
                    // Rotary Global Morph Offset        
                    if(control == 38) {Velo_Morph_Offset[Active_Part] = value;} 
                    // Rotary Patch-Var-Morph  --- currently physically not there.
                    if(control == 39) {Patch_Var_Morph = value;}
                    // MSQ_Clear_Select - Btn & Footswitch              
                    if(control == 18 || control == 27) {MSQ_Clear_Sel = value;} //CLEAR LAST Selected Motion Sequence
                    //CLEAR ALL MSQs   
                    if(control == 17) {MSQ_Clear_All = value;  
                                        if(MSQ_Clear_All == 1) { //CLEAR MSQ only by pressed button
                                        int x; for(x=0; x<256; x++) { int y; for(y=0; y<32; y++) {MSQ_Store[Active_Part][y][x]=128;}}}}
                    //Velocity Morph Assign Btn  
                    if(control == 29) {Velo_Morph_BTN = value; //Velocity Morph Button
                                       if(Velo_Morph_BTN == 0) {MSQ_Rec[Active_Part]   = MSQ_Rec_mem[Active_Part];    //Recall Patch & States 
                                                     MSQ_Mute_Remote = 0; //Recall Patch & States 
                                                    //Recall All Encoder Rings
                                                     int x; for(x=0; x<32; x++) {MIOS32_MIDI_SendCC(Remote1Port, Remote1_Automate_CH, x, CC_Store[Active_Part][x]);}} 
                                     
                                       if(Velo_Morph_BTN == 1) {MSQ_Rec_mem[Active_Part]   = MSQ_Rec[Active_Part];    MSQ_Rec[Active_Part] = 0;    //REC-State-Save & Deactivate 
                                                     MSQ_Mute_Remote = 1;  
                                              
                                       //Set Velocity Offset
                                        //Deactivate All Encoder Rings
                                        int x; for(x=0; x<32; x++) {MIOS32_MIDI_SendCC(Remote1Port, Remote1_Automate_CH, x, Velo_Morph[Active_Part][x]);}}      
                                        }
                        
                    //Clear ALL Velo-Morphs
                    if(control == 30) {Velo_Morph_Clear_All = value;  //CLEAR ALL Morphs
                            if(Velo_Morph_Clear_All == 1) { //CLEAR Morph only by pressed button
                                int x; for(x=0; x<8; x++) { int y; for(y=0; y<32; y++) {Velo_Morph[x][y]=63;}}}}
                                
                    }   
                    
                    
            // 1: Channel Strip - 4 Controls on 8 Channels
            if(CC_Map_Mode == 1) {     
                  
                    // Select Strip Number
                    if(control < 8 && control >= 0) {
                        
                        // Active Part Number  
                        Active_Strip_Set = control;
                        
                        // Disable ALL Strip-Part Switches, except the New one
                        int x; for(x=0; x<8; x++) {   if(x != Active_Strip_Set){ MIOS32_MIDI_SendCC(Remote1Port, Remote1_Setting_CH, x, 0);} }
                        //Enable the new Active Part Switch
                        MIOS32_MIDI_SendCC(Remote1Port, Remote1_Setting_CH, Active_Strip_Set, 1);
                        
                        // Disable "in this mode un-used" Buttons (MSQ & Morph) 
                        
                        MIOS32_MIDI_SendCC(Remote1Port, Remote1_Setting_CH, 19, 0); 
                        MIOS32_MIDI_SendCC(Remote1Port, Remote1_Setting_CH, 37, 0);             
                        MIOS32_MIDI_SendCC(Remote1Port, Remote1_Setting_CH, 38, 0); 

                        //fix this
                        // Dump Rotary CCs 2 Remote out
                        int y; for(y=0; y<32; y++) { 
                                if(CC_Store[Active_Strip_Set][y] != 255) {  // FIX    
                                        // get Strip_CH
                                        if (y == 0 || y == 8  || y == 16 || y == 24) {Strip_CH = 0;}
                                        if (y == 1 || y == 9  || y == 17 || y == 25) {Strip_CH = 1;}
                                        if (y == 2 || y == 10 || y == 18 || y == 26) {Strip_CH = 2;}
                                        if (y == 3 || y == 11 || y == 19 || y == 27) {Strip_CH = 3;}
                                        if (y == 4 || y == 12 || y == 20 || y == 28) {Strip_CH = 4;}
                                        if (y == 5 || y == 13 || y == 21 || y == 29) {Strip_CH = 5;}
                                        if (y == 6 || y == 14 || y == 22 || y == 30) {Strip_CH = 6;}
                                        if (y == 7 || y == 15 || y == 23 || y == 31) {Strip_CH = 7;}
                                
                        // Send CC         //Midi Port    //Channel          //CC-Number                        //CC-Value
                        //                                of BCR              of[0-32]    of       Strip CH    REMAP    Strip CH  Remap    Strip Set       BCR-CC
                        MIOS32_MIDI_SendCC(Remote1Port,   Remote1_Automate_CH,   y,    CC_Store[Strip_CH]  [CC_Map0 [Strip_CH] [CC_Map1[Active_Strip_Set][y]] ]);
                                                                                //CC-Number     
                                                                                //of      [Strip Set num]  [0-32]    
                                                                                //CC_Map1 [Active_Strip_Set] [y],  
                                }
                                //else turn off Encoder
                                else if(CC_Store[Active_Strip_Set][y] == 128) {
                                    MIOS32_MIDI_SendCC(Remote1Port,   Remote1_Automate_CH,  y,  0);
                                }
                                
                        }
                   }     
            }
                   
 
        // GLOBAL APP REMOTE PARAMETERS
        
        //Button Bank Switch  +  Virtual Button Group "Button_Bank" for the upper 8 horizontal LED-Buttons...
        if(control == 24) {Button_Bank = 0;  MIOS32_MIDI_SendCC(Remote1Port, Remote1_Setting_CH, 24, 1); //MSQ_ACTIVE-Bank --- is MSQ Active
                                             MIOS32_MIDI_SendCC(Remote1Port, Remote1_Setting_CH, 25, 0);
                                             
                 int x; for(x=0; x<8; x++) { MIOS32_MIDI_SendCC(Remote1Port, Remote1_Setting_CH, x+8, MSQ_Active[x]);}}                                             
        
        
        //Button Bank Switch  +  Virtual Button Group "Button_Bank" for the upper 8 horizontal LED-Buttons...                                                                        
        if(control == 25) {Button_Bank = 1;  MIOS32_MIDI_SendCC(Remote1Port, Remote1_Setting_CH, 24, 0); 
                                             MIOS32_MIDI_SendCC(Remote1Port, Remote1_Setting_CH, 25, 1);
                                             
                 int x; for(x=0; x<8; x++)        { MIOS32_MIDI_SendCC(Remote1Port, Remote1_Setting_CH, x+8,0);}  //Clear All Buttons States
                      if(Patch_Var_Active[0] == 0){ MIOS32_MIDI_SendCC(Remote1Port, Remote1_Setting_CH, 8,  1);}  //BTN 0
                 else if(Patch_Var_Active[0] == 1){ MIOS32_MIDI_SendCC(Remote1Port, Remote1_Setting_CH, 9,  1);}  //BTN 1
                 else if(Patch_Var_Active[0] == 2){ MIOS32_MIDI_SendCC(Remote1Port, Remote1_Setting_CH, 10, 1);}  //BTN 2
                 else if(Patch_Var_Active[0] == 3){ MIOS32_MIDI_SendCC(Remote1Port, Remote1_Setting_CH, 11, 1);}  //BTN 3
                 }   
        
        
        //Patch Variants Load Save Copy Paste    //    MSQ-Mute Buttons
        if(control > 7 && control < 16) { //Button_Bank Btns  MSQ-Mute VS Save, Load, Snapshot
            
                 //MSQ - Mute Buttons
                 if(Button_Bank == 0) {MSQ_Active[control-8] =! MSQ_Active[control-8];}
                   
            //Bank_Variants 0-3, Paste, Copy, Load, Store
            else if(Button_Bank  == 1) { 
                        if(value == 1) {
                                //Bank Variants
                                if(control ==  8) {Patch_Var_Active[1] = 0;} //VAR 0  
                                if(control ==  9) {Patch_Var_Active[1] = 1;} //VAR 1  
                                if(control == 10) {Patch_Var_Active[1] = 2;} //VAR 2 
                                if(control == 11) {Patch_Var_Active[1] = 3;} //VAR 3  

                                                
                                                               
        //Save Patch
            if(control > 7 && control < 12){
        
              MUTEX_SDCARD_TAKE; statusDir = FILE_DirExists("mq"); MUTEX_SDCARD_GIVE; //ask file.c: exist a folder "mq/" on the CARD?
              if(statusDir != 1) { LED_Gestic=3; }  //NO SD-CARD connected
              if(statusDir == 1) { //YES CARD!  >>> next: check Card-content 
                                        SDCardCount = 0; //Avoid double triggering
                        //WRITE  Variables in ArrayBank_Var_Active
                        CC_SEQ[0]=BPM;
                        CC_SEQ[1]=PpqnDivider;
                        CC_SEQ[2]=BaseTic;
                        CC_SEQ[3]=Rythm;
                        CC_SEQ[4]=RythmRepeat;
                        CC_SEQ[5]=MainLoop;
                        CC_SEQ[6]=StepPerPage;  
                        CC_SEQ[7]=Patch_Var_Automorph;                
                        CC_SEQ[8]=Patch_Var_Automorph_time;                
                        CC_SEQ[9]=Patch_Var_Morph; 
        
                        MUTEX_SDCARD_TAKE; //access to SD-Card only the next few lines long.... 
                                sprintf(filepathS, "mq/%d.mq", (Patch_Nr_Save + (Patch_Var_Active[0]*1000)) ); //+give offset for Bank Variante
                                    FILE_WriteOpen	(filepathS, 1);                  //WRITE!!!!
                                        FILE_WriteBuffer((u8  *)file_typeBank,       4);  //"MQ01" = 4 Positons
                                        FILE_WriteBuffer((u8  *)Patch_Var_Active,    4);  //Active Patch Variante Bank Variable                           
                                        FILE_WriteBuffer((u8  *)MSQ_Active,          8);  //Motion-Sequencer ON OFF
                                        FILE_WriteBuffer((u8  *)MSQ_Loop_Length_Set, 8);  //Motion-Sequencer ON OFF  
                                        FILE_WriteBuffer((u8  *)Velo_Morph_Offset,   8);  //Add Velocity to the Automated Parameters                              
                                        FILE_WriteBuffer((u8  *)CC_SEQ,             32);  //Container for static not touchable Variables      
                                        FILE_WriteBuffer((u8  *)Velo_Morph,        256);  //Here we have 8x32=256, 
                                        FILE_WriteBuffer((u8  *)CC_Store,          256);  //  
                                        FILE_WriteBuffer((u8  *)Mod_Matrix,       8192);   //8x32x32  For Synths witch built in Mod Matrix                          
                                        FILE_WriteBuffer((u8  *)MSQ_Store,       65536);  //Motion-Sequence-Data 8x32*256=65536          65536           
                                    FILE_WriteClose	();  
                        MUTEX_SDCARD_GIVE;	 
                                    MIOS32_MIDI_SendCC(Remote1Port, Remote1_Setting_CH, 15, 0); //deactivate the Store button on the BCR, so you notice that it is done!   
                                    //store-operation Done
                                    Patch_Var_Active[0] = Patch_Var_Active[1]; //set new ACTIVE , ready to load
        
                //LOAD PRESETS
                     //LOAD, Patch Variant
                        MUTEX_SDCARD_TAKE;  statusDir = FILE_DirExists("mq"); MUTEX_SDCARD_GIVE;
                          if(statusDir != 1) {  LED_Gestic=3; }     //NO File Exists
                          if(statusDir == 1) {                      //Busy... loading files
                     //Save actual Stage, in order to Morph between the 2 Presets smoothly
                     int u; for(u=0; u<8; u++) { int v; for(v=0; v<32; v++) {CC_Store_old[u][v] = CC_Store[u][v];;}}
                        //Load whole Patch                         
                        MUTEX_SDCARD_TAKE       
                                   sprintf(filepathL, "mq/%d.mq", (Patch_Nr_Load + (Patch_Var_Active[0]*1000)) );
                                   FILE_ReadOpen	(&midifile_fi, filepathL);
                                   FILE_ReadBuffer((u8  *)file_typeBank,       4);  //"MQ01" = 4 Positons   u8 Bank_Var_Active = 0;
                                   FILE_ReadBuffer((u8  *)Patch_Var_Dummy ,    4);  //Do not change the Active States!!!
                                   FILE_ReadBuffer((u8  *)MSQ_Active,          8);  //Motion-Sequencer ON OFF
                                   FILE_ReadBuffer((u8  *)MSQ_Loop_Length_Set, 8);  //Motion-Sequencer ON OFF  
                                   FILE_ReadBuffer((u8  *)Velo_Morph_Offset,   8);  //Add Velocity to the Automated Parameters            
                                   FILE_ReadBuffer((u8  *)CC_SEQ,             32);  //Container for static not touchable Variables      
                                   FILE_ReadBuffer((u8  *)Velo_Morph,        256);  //Here we have 8x32=256, 
                                   FILE_ReadBuffer((u8  *)CC_Store,          256);  //Here we have 8x128=256, 
                                   FILE_ReadBuffer((u8  *)Mod_Matrix,       8192);  //8x32x32  For Synths witch built in Mod Matrix   
                                   FILE_ReadBuffer((u8  *)MSQ_Store,       65536);  //Motion-Sequence-Data 8x32*256=65536  
                                   FILE_ReadClose	(&midifile_fi);
                       MUTEX_SDCARD_GIVE
               
                        // Dump OUT REMOTE CCs to BCR      
                        //0: Deep Edit Mode - ALL controlls for 1 Channel 
                        if(CC_Map_Mode == 0) {  
                                    int x; for(x=0; x<8; x++) { MIOS32_MIDI_SendCC(Remote1Port, Remote1_Setting_CH, x, 0);}//disable old PART LEDs
                                    MIOS32_MIDI_SendCC(Remote1Port, Remote1_Setting_CH, Active_Part, 1);
                                    MIOS32_MIDI_SendCC(Remote1Port, Remote1_Setting_CH, 19, MSQ_Rec[Active_Part]); 
                                    MIOS32_MIDI_SendCC(Remote1Port, Remote1_Setting_CH, 37, MSQ_Loop_Length_Set[Active_Part]);             
                                    MIOS32_MIDI_SendCC(Remote1Port, Remote1_Setting_CH, 38, Velo_Morph_Offset[Active_Part]);                                     
                                    int y; for(y=0; y<32; y++) { MIOS32_MIDI_SendCC(Remote1Port, Remote1_Automate_CH, y, CC_Store[Active_Part][y]);}
                                    }
                        //1: Channelstrip Mode - 4 controlls for 8 Channels 
                        if(CC_Map_Mode == 1) {  
                                    int x; for(x=0; x<8; x++) { MIOS32_MIDI_SendCC(Remote1Port, Remote1_Setting_CH, x, 0);}//disable old PART LEDs
                                    MIOS32_MIDI_SendCC(Remote1Port, Remote1_Setting_CH, Active_Part, 1);
                                    MIOS32_MIDI_SendCC(Remote1Port, Remote1_Setting_CH, 19, MSQ_Rec[Active_Part]); 
                                    MIOS32_MIDI_SendCC(Remote1Port, Remote1_Setting_CH, 37, MSQ_Loop_Length_Set[Active_Part]);             
                                    MIOS32_MIDI_SendCC(Remote1Port, Remote1_Setting_CH, 38, Velo_Morph_Offset[Active_Part]);                                     
                                    int y; for(y=0; y<32; y++) { MIOS32_MIDI_SendCC(Remote1Port, Remote1_Automate_CH, y, CC_Store[Active_Strip_Set][y]);}  //FIX
                                    }                        
                        
                                    //Dump Out to SYNTH
                        Dump_Patch_Out_Flag = 1; //dump it anywhere out where you can controll the OutputStream!!! -there also the LED_Gestic is handled       
                            int x; for(x=0; x<4; x++){MIOS32_MIDI_SendCC(Remote1Port, Remote1_Setting_CH, x+8,0);}  //Clear Active_Patch_Variante LEDs
                            }
                }
            }
                    
            //LOAD OLD PRESET
            if(control == 12){//LOAD OLD PRESET
                 //LOAD, Patch Variant
                    MUTEX_SDCARD_TAKE;  statusDir = FILE_DirExists("mq"); MUTEX_SDCARD_GIVE;
                      if(statusDir != 1) {  LED_Gestic=3; }     //NO File Exists
                      if(statusDir == 1) {                      //Busy... loading files
                 //Save actual Stage, in order to Morph between the 2 Presets smoothly
                 int u; for(u=0; u<8; u++) { int v; for(v=0; v<32; v++) {CC_Store_old[u][v] = CC_Store[u][v];;}}
                 CC_Store_Morph_Calc_Flag = 1;
                 
                    //Load whole Patch                         
                    MUTEX_SDCARD_TAKE       
                               sprintf(filepathL, "mq/%d.mq", (Patch_Nr_Load + (Patch_Var_Active[0]*1000)) );
                               FILE_ReadOpen	(&midifile_fi, filepathL);
                               FILE_ReadBuffer((u8  *)file_typeBank,       4);  //"MQ01" = 4 Positons   u8 Bank_Var_Active = 0;
                               FILE_ReadBuffer((u8  *)Patch_Var_Dummy ,    4);  //Do not change the Active States!!!
                               FILE_ReadBuffer((u8  *)MSQ_Active,          8);  //Motion-Sequencer ON OFF
                               FILE_ReadBuffer((u8  *)MSQ_Loop_Length_Set, 8);  //Motion-Sequencer ON OFF  
                               FILE_ReadBuffer((u8  *)Velo_Morph_Offset,   8);  //Add Velocity to the Automated Parameters            
                               FILE_ReadBuffer((u8  *)CC_SEQ,             32);  //Container for static not touchable Variables      
                               FILE_ReadBuffer((u8  *)Velo_Morph,        256);  //Here we have 8x32 
                               FILE_ReadBuffer((u8  *)CC_Store,          256);  
                               FILE_ReadBuffer((u8  *)Mod_Matrix,       8192);    //8x32x32  For Synths witch built in Mod Matrix                     
                               FILE_ReadBuffer((u8  *)MSQ_Store,       65536);  //Motion-Sequence-Data 8x32*256  
                               FILE_ReadClose	(&midifile_fi);
                   MUTEX_SDCARD_GIVE
            
                // Dump OUT REMOTE CCs to BCR      
                //0: Deep Edit Mode - ALL controlls for 1 Channel 
                if(CC_Map_Mode == 0) {  
                            int x; for(x=0; x<8; x++) { MIOS32_MIDI_SendCC(Remote1Port, Remote1_Setting_CH, x, 0);}//disable old PART LEDs
                            MIOS32_MIDI_SendCC(Remote1Port, Remote1_Setting_CH, Active_Part, 1);
                            MIOS32_MIDI_SendCC(Remote1Port, Remote1_Setting_CH, 19, MSQ_Rec[Active_Part]); 
                            MIOS32_MIDI_SendCC(Remote1Port, Remote1_Setting_CH, 37, MSQ_Loop_Length_Set[Active_Part]);             
                            MIOS32_MIDI_SendCC(Remote1Port, Remote1_Setting_CH, 38, Velo_Morph_Offset[Active_Part]);                                     
                            int y; for(y=0; y<32; y++) { MIOS32_MIDI_SendCC(Remote1Port, Remote1_Automate_CH, y, CC_Store[Active_Part][y]);}
                            }
           //1: Channelstrip Mode - 4 controlls for 8 Channels 
                if(CC_Map_Mode == 1) {  
                            int x; for(x=0; x<8; x++) { MIOS32_MIDI_SendCC(Remote1Port, Remote1_Setting_CH, x, 0);}//disable old PART LEDs
                            MIOS32_MIDI_SendCC(Remote1Port, Remote1_Setting_CH, Active_Part, 1);
                            MIOS32_MIDI_SendCC(Remote1Port, Remote1_Setting_CH, 19, MSQ_Rec[Active_Part]); 
                            MIOS32_MIDI_SendCC(Remote1Port, Remote1_Setting_CH, 37, MSQ_Loop_Length_Set[Active_Part]);             
                            MIOS32_MIDI_SendCC(Remote1Port, Remote1_Setting_CH, 38, Velo_Morph_Offset[Active_Part]);                                     
                            int y; for(y=0; y<32; y++) { MIOS32_MIDI_SendCC(Remote1Port, Remote1_Automate_CH, y, CC_Store[Active_Strip_Set][y]);}  //FIX
                            }                        
                
                //Dump Out to SYNTH
                Dump_Patch_Out_Flag = 1; //dump it anywhere out where you can controll the OutputStream!!! -there also the LED_Gestic is handled       
                    int x; for(x=0; x<4; x++){MIOS32_MIDI_SendCC(Remote1Port, Remote1_Setting_CH, x+8,0);}  //Clear Active_Patch_Variante LEDs
                };
        }
                
            //Copy Patch Variant
            if(control == 13){//copy actual Patch into storage
                  MUTEX_SDCARD_TAKE; statusDir = FILE_DirExists("mq"); MUTEX_SDCARD_GIVE; //ask file.c: exist a folder "mq/" on the CARD?
                  if(statusDir != 1) { LED_Gestic=3; }  //NO SD-CARD connectedfloat CC_Store_Morph_Factor[8][32] = {{}};
                  if(statusDir == 1) { //YES CARD!  >>> next: check Card-content 
                                            SDCardCount = 0; //Avoid double triggering
                                            
                 //Save actual Stage, in order to Morph between the 2 Presets smoothly
                 int u; for(u=0; u<8; u++) { int v; for(v=0; v<32; v++) {CC_Store_old[u][v] = CC_Store[u][v];;}}
                 CC_Store_Morph_Calc_Flag = 1;
            
                            //WRITE  Variables in ArrayBank_Var_Active
                            CC_SEQ[0]=BPM;
                            CC_SEQ[1]=PpqnDivider;
                            CC_SEQ[2]=BaseTic;
                            CC_SEQ[3]=Rythm;
                            CC_SEQ[4]=RythmRepeat;
                            CC_SEQ[5]=MainLoop;
                            CC_SEQ[6]=StepPerPage;   
                            CC_SEQ[7]=Patch_Var_Automorph;                
                            CC_SEQ[8]=Patch_Var_Automorph_time;                
                            CC_SEQ[9]=Patch_Var_Morph; 
                            
                            MUTEX_SDCARD_TAKE; //access to SD-Card only the next few lines long.... 
                                    sprintf(filepathS, "mq/%d.mq", 4001); //+give offset for Bank Variante
                                        FILE_WriteOpen	(filepathS, 1);                  //WRITE!!!!
                                            FILE_WriteBuffer((u8  *)file_typeBank,       4);  //"MQ01" = 4 Positons
                                            FILE_WriteBuffer((u8  *)Patch_Var_Active,    4);  //Active Patch Variante Bank Variable                           
                                            FILE_WriteBuffer((u8  *)MSQ_Active,          8);  //Motion-Sequencer ON OFF
                                            FILE_WriteBuffer((u8  *)MSQ_Loop_Length_Set, 8);  //Motion-Sequencer ON OFF  
                                            FILE_WriteBuffer((u8  *)Velo_Morph_Offset,   8);  //Add Velocity to the Automated Parameters                              
                                            FILE_WriteBuffer((u8  *)CC_SEQ,             32);  //Container for static not touchable Variables      
                                            FILE_WriteBuffer((u8  *)Velo_Morph,        256);  //Here we have 8x32 
                                            FILE_WriteBuffer((u8  *)CC_Store,          256);  //   
                                            FILE_WriteBuffer((u8  *)Mod_Matrix,       8192);    //8x32x32  For Synths witch built in Mod Matrix  
                                            FILE_WriteBuffer((u8  *)MSQ_Store,       65536);  //Motion-Sequence-Data 8x32*256=65536          65536           
                                        FILE_WriteClose	();  
                            MUTEX_SDCARD_GIVE;	 
                                        MIOS32_MIDI_SendCC(Remote1Port, Remote1_Setting_CH, 13, 0); //deactivate copy button on the BCR, so you notice that it is done!   
                                        LED_Gestic=3; //a nother way to see that it is done
                                        }}//store-operation Done    
            
            //Paste Patch Variant
            if(control == 14){//paste data from Storage to actual patch
                 //LOAD, Patch Variant
                    MUTEX_SDCARD_TAKE;  statusDir = FILE_DirExists("mq"); MUTEX_SDCARD_GIVE;
                      if(statusDir != 1) {  LED_Gestic=3; }     //NO File Exists
                      if(statusDir == 1) {                      //Busy... loading files
            
                    //Load whole Patch                         
                    MUTEX_SDCARD_TAKE       
                               sprintf(filepathL, "mq/%d.mq", 4001);
                               FILE_ReadOpen	(&midifile_fi, filepathL);
                               FILE_ReadBuffer((u8  *)file_typeBank,       4);  //"MQ01" = 4 Positons   u8 Bank_Var_Active = 0;
                               FILE_ReadBuffer((u8  *)Patch_Var_Dummy ,    4);  //Do not change the Active States!!!
                               FILE_ReadBuffer((u8  *)MSQ_Active,          8);  //Motion-Sequencer ON OFF
                               FILE_ReadBuffer((u8  *)MSQ_Loop_Length_Set, 8);  //Motion-Sequencer ON OFF  
                               FILE_ReadBuffer((u8  *)Velo_Morph_Offset,   8);  //Add Velocity to the Automated Parameters            
                               FILE_ReadBuffer((u8  *)CC_SEQ,             32);  //Container for static not touchable Variables      
                               FILE_ReadBuffer((u8  *)Velo_Morph,        256);  //Here we have 8x32
                               FILE_ReadBuffer((u8  *)CC_Store,          256);  
                               FILE_ReadBuffer((u8  *)Mod_Matrix,       8192);  //8x32x32  For Synths witch built in Mod Matrix  
                               FILE_ReadBuffer((u8  *)MSQ_Store,       65536);  //Motion-Sequence-Data 8x32*256=65536  
                               FILE_ReadClose	(&midifile_fi);
                   MUTEX_SDCARD_GIVE
            
                // Dump OUT REMOTE CCs to BCR      
                //0: Deep Edit Mode - ALL controlls for 1 Channel 
                if(CC_Map_Mode == 0) {  
                            int x; for(x=0; x<8; x++) { MIOS32_MIDI_SendCC(Remote1Port, Remote1_Setting_CH, x, 0);}//disable old PART LEDs
                            MIOS32_MIDI_SendCC(Remote1Port, Remote1_Setting_CH, Active_Part, 1);
                            MIOS32_MIDI_SendCC(Remote1Port, Remote1_Setting_CH, 19, MSQ_Rec[Active_Part]); 
                            MIOS32_MIDI_SendCC(Remote1Port, Remote1_Setting_CH, 37, MSQ_Loop_Length_Set[Active_Part]);             
                            MIOS32_MIDI_SendCC(Remote1Port, Remote1_Setting_CH, 38, Velo_Morph_Offset[Active_Part]);                                     
                            int y; for(y=0; y<32; y++) { MIOS32_MIDI_SendCC(Remote1Port, Remote1_Automate_CH, y, CC_Store[Active_Part][y]);}
                            }
           //1: Channelstrip Mode - 4 controlls for 8 Channels 
                if(CC_Map_Mode == 1) {  
                            int x; for(x=0; x<8; x++) { MIOS32_MIDI_SendCC(Remote1Port, Remote1_Setting_CH, x, 0);}//disable old PART LEDs
                            MIOS32_MIDI_SendCC(Remote1Port, Remote1_Setting_CH, Active_Part, 1);
                            MIOS32_MIDI_SendCC(Remote1Port, Remote1_Setting_CH, 19, MSQ_Rec[Active_Part]); 
                            MIOS32_MIDI_SendCC(Remote1Port, Remote1_Setting_CH, 37, MSQ_Loop_Length_Set[Active_Part]);             
                            MIOS32_MIDI_SendCC(Remote1Port, Remote1_Setting_CH, 38, Velo_Morph_Offset[Active_Part]);                                     
                            int y; for(y=0; y<32; y++) { MIOS32_MIDI_SendCC(Remote1Port, Remote1_Automate_CH, y, CC_Store[Active_Strip_Set][y]);}  //FIX
                            }                        
                
                            //Dump Out to SYNTH
                Dump_Patch_Out_Flag = 1; //dump it anywhere out where you can controll the OutputStream!!! -there also the LED_Gestic is handled       
                    int x; for(x=0; x<4; x++){MIOS32_MIDI_SendCC(Remote1Port, Remote1_Setting_CH, x+8,0);}  //Clear Active_Patch_Variante LEDs
                    };
            
            //Automorph between Patch-Variant switches
            if(control == 15) {Patch_Var_Automorph =! Patch_Var_Automorph;}
                
            }

        }      
        }                      
        }

}
}//End Hook
	
void APP_Tick(void){ // called each mS from main task which also handles DIN, ENC and AIN events. You could add more jobs here - dont do more than 300uS!

//Blink Counter for Varios functions...

LED_Gestic_Blink_count++; 
    if(LED_Gestic_Blink_count >= LED_Gestic_Rate*2) { LED_Gestic_Blink_count = 0;
                                                      LED_Gestic_Blink_toggle =! LED_Gestic_Blink_toggle;
        if(LED_Gestic_Blink_toggle == 0){//Do blinking OFF
                        if(Button_Bank == 1) {MIOS32_MIDI_SendCC(Remote1Port, Remote1_Setting_CH, Patch_Var_Active[0]+8, 0);}
                
        }
        
        if(LED_Gestic_Blink_toggle == 1){//Do blinking ON
                        if(Button_Bank == 1) {MIOS32_MIDI_SendCC(Remote1Port, Remote1_Setting_CH, Patch_Var_Active[0]+8, 1);}
                        
        }}  
                
    //Gestics off the minimal LED-Interface
    //Visualize LEDs @ J5A Pin1-3 and J5B Pin 0-3 dont use Pin0 of J5B because it is the Button Input for RYTHM > see APP_Background 
    //Normal Mode Just dumpout RYTHM-SET-LED
    if(LED_Gestic == 0)  { ONEFLAG = 0;
        int x; for(x=0; x<8; x++) {MIOS32_BOARD_J5_PinSet(x, 0);}      //Turn off all LEDs
                                   MIOS32_BOARD_J5_PinSet(Rythm-2, 1);} //Turn on one LED - Indicate Rythmset (4/4 by default)

    //Operating - busy
    if(LED_Gestic == 1)  { ONEFLAG = 0;
            LED_Gestic_count++; 
            if(LED_Gestic_count >= LED_Gestic_Rate) {LED_Gestic_count = 0;          //some time has passed do something
                    int x; for(x=0; x<8; x++) {MIOS32_BOARD_J5_PinSet(x, 0);} //Turn off all LEDs
                    LED_Gestic_move++; //counter for the led sequence
                    if(LED_Gestic_move > 6) {LED_Gestic_move=0;}
                    if(LED_Gestic_move == 0) {MIOS32_BOARD_J5_PinSet(1, 1);}  //X......
                    if(LED_Gestic_move == 1) {MIOS32_BOARD_J5_PinSet(2, 1);}  //.X.....
                    if(LED_Gestic_move == 2) {MIOS32_BOARD_J5_PinSet(3, 1);}  //..X....
                    if(LED_Gestic_move == 3) {MIOS32_BOARD_J5_PinSet(4, 1);}  //...X...
                    if(LED_Gestic_move == 4) {MIOS32_BOARD_J5_PinSet(5, 1);}  //....X..
                    if(LED_Gestic_move == 5) {MIOS32_BOARD_J5_PinSet(6, 1);}  //.....X.
                    if(LED_Gestic_move == 6) {MIOS32_BOARD_J5_PinSet(7, 1);}}}//......X
                    //Endless Sequence, unless something out there change the LED_Gestic value  
                    
    //YES! operation done
    if(LED_Gestic == 2 && ONEFLAG == 0)  {
            LED_Gestic_count++; 
            if(LED_Gestic_count >= LED_Gestic_Rate*2) {LED_Gestic_count = 0;  //some time has passed do something
                    int x; for(x=0; x<8; x++) {MIOS32_BOARD_J5_PinSet(x, 0);} //Turn off all LEDs
                    LED_Gestic_move++; //counter for the led sequence
                    if(LED_Gestic_move > 3)  {LED_Gestic_move=0; ONEFLAG = 1; LED_Gestic = 0;}
                    
                    if(LED_Gestic_move == 0) {MIOS32_BOARD_J5_PinSet(7, 1);    //X.....X
                                              MIOS32_BOARD_J5_PinSet(1, 1);}
                    if(LED_Gestic_move == 1) {MIOS32_BOARD_J5_PinSet(6, 1);    //.X...X. 
                                              MIOS32_BOARD_J5_PinSet(2, 1);} 
                    if(LED_Gestic_move == 2) {MIOS32_BOARD_J5_PinSet(5, 1);    //..X.X..
                                              MIOS32_BOARD_J5_PinSet(3, 1);}     
                    if(LED_Gestic_move == 3) {MIOS32_BOARD_J5_PinSet(4, 1);}}} //...X...
 
    //Nope! something went wrong!                                                
    if(LED_Gestic == 3)  { ONEFLAG = 0;
        LED_Gestic_Duration_Count++; //timer
        if(LED_Gestic_Duration_Count < 3 * LED_Gestic_Duration) { //as long we are in Animation time, do following:
            LED_Gestic_count++; 
            if(LED_Gestic_count >= LED_Gestic_Rate) {LED_Gestic_count = 0;          //some time has passed do something
                    int x; for(x=0; x<8; x++) {MIOS32_BOARD_J5_PinSet(x, 0);} //Turn off all LEDs
                    LED_Gestic_move++; //counter for the led sequence
                    if(LED_Gestic_move == 0) {MIOS32_BOARD_J5_PinSet(4, 1);} //...X...//activate middle LED (we have 7 LEDs)
                    if(LED_Gestic_move == 1) {MIOS32_BOARD_J5_PinSet(3, 1);  //..X.X..
                                              MIOS32_BOARD_J5_PinSet(5, 1);}
                    if(LED_Gestic_move == 2) {MIOS32_BOARD_J5_PinSet(2, 1);  //.X...X. 
                                              MIOS32_BOARD_J5_PinSet(6, 1);} 
                    if(LED_Gestic_move == 3) {MIOS32_BOARD_J5_PinSet(1, 1);  //X.....X
                                              MIOS32_BOARD_J5_PinSet(7, 1);}                      
                    if(LED_Gestic_move >= 3) {LED_Gestic_move=0;}} //End Of Sequence, begin again
            }
        
        if(LED_Gestic_Duration_Count > 3 * LED_Gestic_Duration) {LED_Gestic_Duration_Count=0; LED_Gestic = 0;}} //goto normal mode again    
        
    SDCardCount = SDCardCount + 1; if(SDCardCount > 2000){SDCardCount = 0; StoreLoad(1, 3);}//} //5s Counter > send Check-SDCard-Commant to StoreLoad-Function


if(LoadFlag == 1) {  LoadCount = LoadCount + 1; 
     if(LoadCount > 250){  LoadCount = 0;  LoadFlag=0;  StoreLoad(1, 1);}} //the direct imideatly Btn Action from a BLMx dont react...so delay here.



      
if(PCLoadFlag == 1){PCLoadFlagCount = PCLoadFlagCount + 1; 
     if(PCLoadFlagCount > 250)  {   PCLoadFlagCount = 0;  //init counter for the next run
                                    StoreLoad(1, 1);
                                    PCLoadFlag = 0;}}  //Kill Flag to avoid double triggering events	  


MIOS32_BOARD_LED_Set(1, SEQ_BPM_IsRunning() ? 1 : 0);    // set LED depending on sequencer run state
}

//Timer that Triggers Function:Patch_Morph --- = Dump-Rate!
void APP_MIDI_Tick(void){ //@1mS rate, dont do more then 300uS!
    DumpRateCount = DumpRateCount+1;
    if(DumpOutRate >= DumpRateCount)  { DumpRateCount=0;
                                        Patch_Morphing(0);}  //trigger Patch_Morph Function every view ms
    }

//Dump the CC-Storage more Slowly out!   &&   Morph Between Patch-Variants
static void Patch_Morphing(u8 update){//will be triggerd from APP_MIDI_Tick every view ms...depending on the DumpOutRate

    //Automatic & Prompt Switching to other VARIANT 
    if(Dump_Patch_Out_Flag == 1) {
      
            //Switch almost imideatly
            if(Patch_Var_Automorph >= 0) { ////////  ACHTUNG dass noch anpassen1!!!! gemacht weil das Programchang nicht funktioniert hat
                if(DumpOutRate >= DumpRateCount) {DumpRateCount = 0;
                                                  DumpCount = DumpCount + 1; 
                                                  if(DumpCount > 31){ DumpCount = 0; Dump_Patch_Out_Flag = 0;}//when all CCs are sent out, delete the Flag...
                                        
                                                  //only Dump out if the CC is really in use! (255=not used)
                                                  if(CC_Store[0][DumpCount] != 128){
                                                        MIOS32_MIDI_SendCC(MeloPort, MeloCh[0], CC_Map0[0][DumpCount], CC_Store[0][DumpCount]);} 
                                                  else if(CC_Store[0][DumpCount] == 128){         
                                                        MIOS32_MIDI_SendCC(MeloPort, MeloCh[0], CC_Map0[0][DumpCount], 0);}   
                                                  if(CC_Store[1][DumpCount] != 128){    
                                                        MIOS32_MIDI_SendCC(MeloPort, MeloCh[1], CC_Map0[1][DumpCount], CC_Store[1][DumpCount]);} 
                                                  else if(CC_Store[1][DumpCount] == 128){         
                                                        MIOS32_MIDI_SendCC(MeloPort, MeloCh[1], CC_Map0[1][DumpCount], 1);}   
                                                  if(CC_Store[2][DumpCount] != 128){         
                                                        MIOS32_MIDI_SendCC(MeloPort, MeloCh[2], CC_Map0[2][DumpCount], CC_Store[2][DumpCount]);} 
                                                  else if(CC_Store[2][DumpCount] == 128){         
                                                        MIOS32_MIDI_SendCC(MeloPort, MeloCh[2], CC_Map0[2][DumpCount], 2);}   
                                                  if(CC_Store[3][DumpCount] != 128){          
                                                        MIOS32_MIDI_SendCC(MeloPort, MeloCh[3], CC_Map0[3][DumpCount], CC_Store[3][DumpCount]);} 
                                                  else if(CC_Store[3][DumpCount] == 128){         
                                                        MIOS32_MIDI_SendCC(MeloPort, MeloCh[3], CC_Map0[3][DumpCount], 3);}   
                                                  if(CC_Store[4][DumpCount] != 128){          
                                                        MIOS32_MIDI_SendCC(MeloPort, MeloCh[4], CC_Map0[4][DumpCount], CC_Store[4][DumpCount]);} 
                                                  else if(CC_Store[4][DumpCount] == 128){         
                                                        MIOS32_MIDI_SendCC(MeloPort, MeloCh[4], CC_Map0[4][DumpCount], 4);}   
                                                  if(CC_Store[5][DumpCount] != 128){          
                                                        MIOS32_MIDI_SendCC(MeloPort, MeloCh[5], CC_Map0[5][DumpCount], CC_Store[5][DumpCount]);} 
                                                  else if(CC_Store[5][DumpCount] == 128){         
                                                        MIOS32_MIDI_SendCC(MeloPort, MeloCh[5], CC_Map0[5][DumpCount], 5);}     
                                                  if(CC_Store[6][DumpCount] != 128){          
                                                        MIOS32_MIDI_SendCC(MeloPort, MeloCh[6], CC_Map0[6][DumpCount], CC_Store[6][DumpCount]);}  
                                                  else if(CC_Store[6][DumpCount] == 128){         
                                                        MIOS32_MIDI_SendCC(MeloPort, MeloCh[6], CC_Map0[6][DumpCount], 6);}       
                                                  if(CC_Store[7][DumpCount] != 128){         
                                                        MIOS32_MIDI_SendCC(MeloPort, MeloCh[7], CC_Map0[7][DumpCount], CC_Store[7][DumpCount]);}
                                                  else if(CC_Store[7][DumpCount] == 128){         
                                                        MIOS32_MIDI_SendCC(MeloPort, MeloCh[7], CC_Map0[7][DumpCount], 7);}                                              
                                              }
                            //Disable RELOAD Button
                            if(Button_Bank == 1) {  MIOS32_MIDI_SendCC(Remote1Port, Remote1_Setting_CH, 12, 0);  
                                                    MIOS32_MIDI_SendCC(Remote1Port, Remote1_Setting_CH, 13, 0);} 

                                              
            LED_Gestic=2;} //LED-Gestic "DONE"
}
}

void APP_MIDI_NotifyPackage(mios32_midi_port_t port, mios32_midi_package_t midi_package){   
  //Forward MidiRemote
  if(port==Remote1Port && (midi_package.chn == Remote1_Automate_CH)) 
    {Router(0, 0, midi_package.cc_number, midi_package.value);}
  if(port==Remote1Port && (midi_package.chn == Remote1_Setting_CH)) 
    {Router(1, 0, midi_package.cc_number, midi_package.value);}

  //Forward Clock, Transport
  if(port==MeloPort){ 
      //forwarding Midiclock & Transport only
      if(TrigMidiThruClock==1 && TrigMidiThruTransport==1 && (midi_package.evnt0==248 || midi_package.evnt0==250 || midi_package.evnt0==251 || midi_package.evnt0==252))//248CLK,250Strt,251Cont,252Stp
        {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);}
      //forwarding Transport Only   
      if(TrigMidiThruClock==0 && TrigMidiThruTransport==1 && (midi_package.evnt0==250 || midi_package.evnt0==251 || midi_package.evnt0==252))//NO CLOCK but Start&Stop >> use synths internal clock..
        {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);}
      }

//PC LOAD
if(midi_package.evnt0 != 248 && midi_package.evnt0 != 187){//avoid that Midiclock DataMess
  //Receive ProgramChange Information
  if(port == PCPort) {
    //Set MidiChannel && Programchange-Channel     set Song Nr with Programchange Nr  show Page PC  setLoadProgram     LOAD command   
    if(PCChIN == 0  && midi_package.evnt0 == 192) {Patch_Nr_Load = midi_package.evnt1;  PCLoadFlag = 1;}
    if(PCChIN == 1  && midi_package.evnt0 == 193) {Patch_Nr_Load = midi_package.evnt1;  PCLoadFlag = 1;} 
    if(PCChIN == 2  && midi_package.evnt0 == 194) {Patch_Nr_Load = midi_package.evnt1;  PCLoadFlag = 1;}
    if(PCChIN == 3  && midi_package.evnt0 == 195) {Patch_Nr_Load = midi_package.evnt1;  PCLoadFlag = 1;} 
    if(PCChIN == 4  && midi_package.evnt0 == 196) {Patch_Nr_Load = midi_package.evnt1;  PCLoadFlag = 1;}
    if(PCChIN == 5  && midi_package.evnt0 == 197) {Patch_Nr_Load = midi_package.evnt1;  PCLoadFlag = 1;} 
    if(PCChIN == 6  && midi_package.evnt0 == 198) {Patch_Nr_Load = midi_package.evnt1;  PCLoadFlag = 1;} 
    if(PCChIN == 7  && midi_package.evnt0 == 199) {Patch_Nr_Load = midi_package.evnt1;  PCLoadFlag = 1;} 
    if(PCChIN == 8  && midi_package.evnt0 == 200) {Patch_Nr_Load = midi_package.evnt1;  PCLoadFlag = 1;} 
    if(PCChIN == 9  && midi_package.evnt0 == 201) {Patch_Nr_Load = midi_package.evnt1;  PCLoadFlag = 1;} 
    if(PCChIN == 10 && midi_package.evnt0 == 202) {Patch_Nr_Load = midi_package.evnt1;  PCLoadFlag = 1;} 
    if(PCChIN == 11 && midi_package.evnt0 == 203) {Patch_Nr_Load = midi_package.evnt1;  PCLoadFlag = 1;} 
    if(PCChIN == 12 && midi_package.evnt0 == 204) {Patch_Nr_Load = midi_package.evnt1;  PCLoadFlag = 1;} 
    if(PCChIN == 13 && midi_package.evnt0 == 205) {Patch_Nr_Load = midi_package.evnt1;  PCLoadFlag = 1;} 
    if(PCChIN == 14 && midi_package.evnt0 == 206) {Patch_Nr_Load = midi_package.evnt1;  PCLoadFlag = 1;} 
    if(PCChIN == 15 && midi_package.evnt0 == 207) {Patch_Nr_Load = midi_package.evnt1;  PCLoadFlag = 1;}
}}

  //Make Velocity
  if(midi_package.type == NoteOn && midi_package.chn == MeloCh[0] && midi_package.velocity > 0) {Velo_From_Note[0] = midi_package.velocity;}
  if(midi_package.type == NoteOn && midi_package.chn == MeloCh[1] && midi_package.velocity > 0) {Velo_From_Note[1] = midi_package.velocity;}
  if(midi_package.type == NoteOn && midi_package.chn == MeloCh[2] && midi_package.velocity > 0) {Velo_From_Note[2] = midi_package.velocity;}  
  if(midi_package.type == NoteOn && midi_package.chn == MeloCh[3] && midi_package.velocity > 0) {Velo_From_Note[3] = midi_package.velocity;}  
  if(midi_package.type == NoteOn && midi_package.chn == MeloCh[4] && midi_package.velocity > 0) {Velo_From_Note[4] = midi_package.velocity;}  
  if(midi_package.type == NoteOn && midi_package.chn == MeloCh[5] && midi_package.velocity > 0) {Velo_From_Note[5] = midi_package.velocity;}
  if(midi_package.type == NoteOn && midi_package.chn == MeloCh[6] && midi_package.velocity > 0) {Velo_From_Note[6] = midi_package.velocity;}  
  if(midi_package.type == NoteOn && midi_package.chn == MeloCh[7] && midi_package.velocity > 0) {Velo_From_Note[7] = midi_package.velocity;}  

      //forwarding Notes
      if(midi_package.evnt0==144) {//Note @ Midi Channel 1
             if(MeloCh[0]==0)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);}
        else if(MeloCh[1]==0)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
        else if(MeloCh[2]==0)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
        else if(MeloCh[3]==0)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
        else if(MeloCh[4]==0)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
        else if(MeloCh[5]==0)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
        else if(MeloCh[6]==0)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
        else if(MeloCh[7]==0)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} }
      if(midi_package.evnt0==145) {//Note @ Midi Channel 2
             if(MeloCh[0]==1)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);}
        else if(MeloCh[1]==1)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
        else if(MeloCh[2]==1)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
        else if(MeloCh[3]==1)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
        else if(MeloCh[4]==1)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
        else if(MeloCh[5]==1)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
        else if(MeloCh[6]==1)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
        else if(MeloCh[7]==1)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} }
      if(midi_package.evnt0==146) {//Note @ Midi Channel 3
             if(MeloCh[0]==2)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);}
        else if(MeloCh[1]==2)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
        else if(MeloCh[2]==2)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
        else if(MeloCh[3]==2)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
        else if(MeloCh[4]==2)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
        else if(MeloCh[5]==2)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
        else if(MeloCh[6]==2)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
        else if(MeloCh[7]==2)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} }
      if(midi_package.evnt0==147) {//Note @ Midi Channel 4
             if(MeloCh[0]==3)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);}
        else if(MeloCh[1]==3)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
        else if(MeloCh[2]==3)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
        else if(MeloCh[3]==3)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
        else if(MeloCh[4]==3)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
        else if(MeloCh[5]==3)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
        else if(MeloCh[6]==3)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
        else if(MeloCh[7]==3)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} }
      if(midi_package.evnt0==148) {//Note @ Midi Channel 5
             if(MeloCh[0]==4)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);}
        else if(MeloCh[1]==4)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
        else if(MeloCh[2]==4)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
        else if(MeloCh[3]==4)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
        else if(MeloCh[4]==4)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
        else if(MeloCh[5]==4)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
        else if(MeloCh[6]==4)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
        else if(MeloCh[7]==4)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} }
      if(midi_package.evnt0==149) {//Note @ Midi Channel 6
             if(MeloCh[0]==5)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);}
        else if(MeloCh[1]==5)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
        else if(MeloCh[2]==5)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
        else if(MeloCh[3]==5)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
        else if(MeloCh[4]==5)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
        else if(MeloCh[5]==5)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
        else if(MeloCh[6]==5)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
        else if(MeloCh[7]==5)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} }
      if(midi_package.evnt0==150) {//Note @ Midi Channel 7
             if(MeloCh[0]==6)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);}
        else if(MeloCh[1]==6)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
        else if(MeloCh[2]==6)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
        else if(MeloCh[3]==6)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
        else if(MeloCh[4]==6)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
        else if(MeloCh[5]==6)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
        else if(MeloCh[6]==6)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
        else if(MeloCh[7]==6)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} }
      if(midi_package.evnt0==151) {//Note @ Midi Channel 8
             if(MeloCh[0]==7)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);}
        else if(MeloCh[1]==7)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
        else if(MeloCh[2]==7)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
        else if(MeloCh[3]==7)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
        else if(MeloCh[4]==7)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
        else if(MeloCh[5]==7)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
        else if(MeloCh[6]==7)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
        else if(MeloCh[7]==7)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} }
      if(midi_package.evnt0==152) {//Note @ Midi Channel 9
             if(MeloCh[0]==8)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);}
        else if(MeloCh[1]==8)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
        else if(MeloCh[2]==8)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
        else if(MeloCh[3]==8)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
        else if(MeloCh[4]==8)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
        else if(MeloCh[5]==8)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
        else if(MeloCh[6]==8)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
        else if(MeloCh[7]==8)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} }
      if(midi_package.evnt0==153) {//Note @ Midi Channel 10
             if(MeloCh[0]==9)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);}
        else if(MeloCh[1]==9)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
        else if(MeloCh[2]==9)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
        else if(MeloCh[3]==9)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
        else if(MeloCh[4]==9)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
        else if(MeloCh[5]==9)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
        else if(MeloCh[6]==9)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
        else if(MeloCh[7]==9)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} }
      if(midi_package.evnt0==154) {//Note @ Midi Channel 11
             if(MeloCh[0]==10)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);}
        else if(MeloCh[1]==10)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
        else if(MeloCh[2]==10)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);}   
        else if(MeloCh[3]==10)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
        else if(MeloCh[4]==10)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
        else if(MeloCh[5]==10)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
        else if(MeloCh[6]==10)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
        else if(MeloCh[7]==10)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} }
      if(midi_package.evnt0==155) {//Note @ Midi Channel 12
             if(MeloCh[0]==11)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);}
        else if(MeloCh[1]==11)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
        else if(MeloCh[2]==11)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
        else if(MeloCh[3]==11)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
        else if(MeloCh[4]==11)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
        else if(MeloCh[5]==11)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
        else if(MeloCh[6]==11)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
        else if(MeloCh[7]==11)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} }
      if(midi_package.evnt0==156) {//Note @ Midi Channel 13
             if(MeloCh[0]==12)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);}
        else if(MeloCh[1]==12)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
        else if(MeloCh[2]==12)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
        else if(MeloCh[3]==12)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
        else if(MeloCh[4]==12)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
        else if(MeloCh[5]==12)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
        else if(MeloCh[6]==12)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
        else if(MeloCh[7]==12)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} }
      if(midi_package.evnt0==157) {//Note @ Midi Channel 14
             if(MeloCh[0]==13)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);}
        else if(MeloCh[1]==13)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
        else if(MeloCh[2]==13)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
        else if(MeloCh[3]==13)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
        else if(MeloCh[4]==13)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
        else if(MeloCh[5]==13)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
        else if(MeloCh[6]==13)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
        else if(MeloCh[7]==13)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} }
      if(midi_package.evnt0==158) {//Note @ Midi Channel 15
             if(MeloCh[0]==14)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);}
        else if(MeloCh[1]==14)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
        else if(MeloCh[2]==14)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
        else if(MeloCh[3]==14)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
        else if(MeloCh[4]==14)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
        else if(MeloCh[5]==14)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
        else if(MeloCh[6]==14)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
        else if(MeloCh[7]==14)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} }
      if(midi_package.evnt0==159) {//Note @ Midi Channel 16
             if(MeloCh[0]==15)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);}
        else if(MeloCh[1]==15)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
        else if(MeloCh[2]==15)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
        else if(MeloCh[3]==15)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
        else if(MeloCh[4]==15)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
        else if(MeloCh[5]==15)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
        else if(MeloCh[6]==15)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} 
        else if(MeloCh[7]==15)   {MIOS32_MIDI_SendPackage(MeloPort,  midi_package);} } 
}

void APP_SRIO_ServicePrepare(void){} //called before shift register chain is scanned
void APP_SRIO_ServiceFinish(void){}  // call the BLM_GetRow function after scan is finished to capture the read DIN values
void APP_DIN_NotifyToggle(u32 pin, u32 pin_value){}
void APP_ENC_NotifyChange(u32 encoder, s32 incrementer){}
void APP_AIN_NotifyChange(u32 pin, u32 pin_value){} //called when a pot has been moved

// SEQ  This task is called periodically each mS to handle sequencer requests
static void TASK_SEQ(void *pvParameters){
  portTickType xLastExecutionTime;

  // Initialise the xLastExecutionTime variable on task entry
  xLastExecutionTime = xTaskGetTickCount();

  while( 1 ) {
    vTaskDelayUntil(&xLastExecutionTime, 1 / portTICK_RATE_MS);

    // execute sequencer handler
    SEQ_Handler();

  }
}

// SEQ --- Installed via MIOS32_MIDI_DirectRxCallback_Init
static s32 NOTIFY_MIDI_Rx(mios32_midi_port_t port, u8 midi_byte){//filter Midiclock Port and rerout it to SEQUENCER-BPM
if(port == MeloPort) { SEQ_BPM_NotifyMIDIRx(midi_byte); }
  return 0; // no error, no filtering
}

//CC Automation - Motion Sequencer
u8 MSQ(u8 port, u8 step) {

 //Play MSQ @ REMOTE
 if(Active_Part == port && MSQ_Mute_Remote == 0 && CC_Map_Mode == 0 ) { 
     int x; for(x=0; x<32; x++) {
       if(MSQ_Store[port][x][step] != 128) { 
         //2 Remote
         MIOS32_MIDI_SendCC(Remote1Port, Remote1_Automate_CH, x, MSQ_Store[port][x][step]);}}//but only if there is data in there!
   //REC MSQ
   if(MSQ_Rec[port] == 1) {  MSQ_Store[port][MSQ_LastMoved[Active_Part]][step] = CC_Store[Active_Part][MSQ_LastMoved[Active_Part]]; }
   }
       
 //Play MSQ @ SYNTH
 if(port < 8) {
   int x; for(x=0; x<32; x++) {
     if(MSQ_Store[port][x][step] != 128) {
       //Talk to SYNTH   --- and ADD Velocity Morph!
       MIOS32_MIDI_SendCC(MeloPort, MeloCh[port], CC_Map0[port][x], ( MSQ_Store[port][x][step]) + ((((Velo_From_Note[port]/127.0) * (Velo_Morph[port][x]-64.0))  / 64.0) *  Velo_Morph_Offset[port]));}}  
    }
  return 0; // no error,
}

//Initalize SD-Card, do PC-based LOAD
static void StoreLoad(u8 tick, u16 order){  
    //LOAD, via PC only
    if(tick == 1 && order == 1){ //Load Data & update the Load NR & Name and also Store Nr & Store Name
      MUTEX_SDCARD_TAKE;  statusDir = FILE_DirExists("mq"); MUTEX_SDCARD_GIVE;
          if(statusDir != 1) {  LED_Gestic=3; }     //NO File Exists
          if(statusDir == 1) {                      //Busy... loading files
                                SDCardCount = 0;    //Avoid double triggering
       //Fint out Variante of Patch                         
       MUTEX_SDCARD_TAKE       
                   sprintf(filepathL, "mq/%d.mq", Patch_Nr_Load);
                   FILE_ReadOpen	(&midifile_fi, filepathL);
                   FILE_ReadBuffer((u8  *)file_typeBank,       4);  //"MQ01" = 4 Positons   u8 Bank_Var_Active = 0;
                   FILE_ReadBuffer((u8  *)Patch_Var_Active,    4);  //Active Patch Variante Bank Variable
                   FILE_ReadClose	(&midifile_fi);
       MUTEX_SDCARD_GIVE
                               
       //Load whole Patch                         
       MUTEX_SDCARD_TAKE       
                   sprintf(filepathL, "mq/%d.mq", (Patch_Nr_Save + (Patch_Var_Active[0]*1000)) );
                   FILE_ReadOpen	(&midifile_fi, filepathL);
                   FILE_ReadBuffer((u8  *)file_typeBank,       4);  //"MQ01" = 4 Positons   u8 Bank_Var_Active = 0;
                   FILE_ReadBuffer((u8  *)Patch_Var_Active,    4);  //Active Patch Variante Bank Variable
                   FILE_ReadBuffer((u8  *)MSQ_Active,          8);  //Motion-Sequencer ON OFF
                   FILE_ReadBuffer((u8  *)MSQ_Loop_Length_Set, 8);  //Motion-Sequencer ON OFF  
                   FILE_ReadBuffer((u8  *)Velo_Morph_Offset,   8);  //Add Velocity to the Automated Parameters            
                   FILE_ReadBuffer((u8  *)CC_SEQ,             32);  //Container for static not touchable Variables      
                   FILE_ReadBuffer((u8  *)Velo_Morph,        256);  //Here we have 8x32 
                   FILE_ReadBuffer((u8  *)CC_Store,         256);  
                   FILE_ReadBuffer((u8  *)Mod_Matrix,       8192);   //8x32x32  For Synths witch built in Mod Matrix   
                   FILE_ReadBuffer((u8  *)MSQ_Store,       65536);  //Motion-Sequence-Data 8x32*256=65536  
                   FILE_ReadClose	(&midifile_fi);
       MUTEX_SDCARD_GIVE

               //Paste  Variables from Array
                BPM                = CC_SEQ[0];
                PpqnDivider        = CC_SEQ[1];
                BaseTic            = CC_SEQ[2];
                Rythm              = CC_SEQ[3];
                RythmRepeat        = CC_SEQ[4];
                MainLoop           = CC_SEQ[5];
                StepPerPage        = CC_SEQ[6];            
                Patch_Var_Automorph= CC_SEQ[7];                
                Patch_Var_Automorph_time= CC_SEQ[8];               
                Patch_Var_Morph         = CC_SEQ[9]; 
                //Dump out Sequencer Data
                SEQ_BPM_Set(BPM);
                Tic = 32 * BaseTic; //32x12=384
                SyncFlag = 1; //update ClockCounter when ready...
       

                                // Dump OUT REMOTE CCs to BCR      
                //0: Deep Edit Mode - ALL controlls for 1 Channel 
                if(CC_Map_Mode == 0) {  
                            int x; for(x=0; x<8; x++) { MIOS32_MIDI_SendCC(Remote1Port, Remote1_Setting_CH, x, 0);}//disable old PART LEDs
                            MIOS32_MIDI_SendCC(Remote1Port, Remote1_Setting_CH, Active_Part, 1);
                            MIOS32_MIDI_SendCC(Remote1Port, Remote1_Setting_CH, 19, MSQ_Rec[Active_Part]); 
                            MIOS32_MIDI_SendCC(Remote1Port, Remote1_Setting_CH, 37, MSQ_Loop_Length_Set[Active_Part]);             
                            MIOS32_MIDI_SendCC(Remote1Port, Remote1_Setting_CH, 38, Velo_Morph_Offset[Active_Part]);                                     
                            int y; for(y=0; y<32; y++) { MIOS32_MIDI_SendCC(Remote1Port, Remote1_Automate_CH, y, CC_Store[Active_Part][y]);}
                            }
           //1: Channelstrip Mode - 4 controlls for 8 Channels 
                if(CC_Map_Mode == 1) {  
                            int x; for(x=0; x<8; x++) { MIOS32_MIDI_SendCC(Remote1Port, Remote1_Setting_CH, x, 0);}//disable old PART LEDs
                            MIOS32_MIDI_SendCC(Remote1Port, Remote1_Setting_CH, Active_Part, 1);
                            MIOS32_MIDI_SendCC(Remote1Port, Remote1_Setting_CH, 19, MSQ_Rec[Active_Part]); 
                            MIOS32_MIDI_SendCC(Remote1Port, Remote1_Setting_CH, 37, MSQ_Loop_Length_Set[Active_Part]);             
                            MIOS32_MIDI_SendCC(Remote1Port, Remote1_Setting_CH, 38, Velo_Morph_Offset[Active_Part]);                                     
                            int y; for(y=0; y<32; y++) { MIOS32_MIDI_SendCC(Remote1Port, Remote1_Automate_CH, y, CC_Store[Active_Strip_Set][y]);}  //FIX
                            }                        
                
                            //Dump Out to SYNTH
                Dump_Patch_Out_Flag = 1; //dump it anywhere out where you can controll the OutputStream!!! -there also the LED_Gestic is handled       
                    int x; for(x=0; x<4; x++){MIOS32_MIDI_SendCC(Remote1Port, Remote1_Setting_CH, x+8,0);}  //Clear Active_Patch_Variante LED
                

                Patch_Nr_Save = Patch_Nr_Load; //transfiar load nr 2 store nr.	
                             }}//
   
    //SD-Card Initalize - SONG
    if(tick == 1 && order == 3){ //CHECK SD-Card/Initalize Card
        //Check SD-Card
        MUTEX_SDCARD_TAKE;      
            availableSD = FILE_SDCardAvailable();
            statusSD    = FILE_CheckSDCard();
            statusDir   = FILE_DirExists("mq");
        MUTEX_SDCARD_GIVE;
    
        if (availableSD  == 0) { LED_Gestic=3; }//NO CARD
        
        if (availableSD  == 1) { //YES CARD!  >>> next: check Card-content
        
            if(statusDir == 1) { LED_Gestic=0; }//File-Dir Exist  --- make Exist Gestik
    
            if(SYX_FLAG  == 1) { MUTEX_SDCARD_TAKE; //the flag is normally activated by pressing a button connected to J5A Pin0 while powering up the core
                                    FILE_SendSyxDump( "/bcr1.syx", Remote1Port, 15*DumpOutRate); 	 //Send SYSEX FILE to BCR2000 - to change the CC-Layout.
                                MUTEX_SDCARD_GIVE;	
                                SYX_FLAG = 0;}} //avoid loop
                                
        //create SONG filestructure take about 16minutes!!!!); 
        if(statusDir <= 0 && availableSD == 1){  
                int x; for(x=0; x<8; x++) {MIOS32_BOARD_J5_PinSet(x, 1);}//show that there is something working!!! Let the machine do
                        //collect variable into arrays to easyer manage the save process
                        CC_SEQ[0]=BPM;
                        CC_SEQ[1]=PpqnDivider;
                        CC_SEQ[2]=BaseTic;
                        CC_SEQ[3]=Rythm;
                        CC_SEQ[4]=RythmRepeat;
                        CC_SEQ[5]=MainLoop;
                        CC_SEQ[6]=StepPerPage; 
                        CC_SEQ[7]=Patch_Var_Automorph;                
                        CC_SEQ[8]=Patch_Var_Automorph_time;                
                        CC_SEQ[9]=Patch_Var_Morph; 
                                MUTEX_SDCARD_TAKE; //SD-Card access closed for all other purposes
                        FILE_MakeDir("mq");                //make a folder "mq" on the SD-Card (root/t/)
                        sprintf(filepathS, "mq/0.mq");     //First Pattern --- will be later copied 511 times!	
                        FILE_WriteOpen	(filepathS, 1);              
                                    FILE_WriteBuffer((u8  *)file_typeBank,       4);    //"MQ01" = 4 Positons
                                    FILE_WriteBuffer((u8  *)Patch_Var_Active,    4);    //Active Patch Variante Bank Variable  
                                    FILE_WriteBuffer((u8  *)MSQ_Active,          8);    //Motion-Sequencer ON OFF
                                    FILE_WriteBuffer((u8  *)MSQ_Loop_Length_Set, 8);    //Motion-Sequencer ON OFF  
                                    FILE_WriteBuffer((u8  *)Velo_Morph_Offset,   8);    //Add Velocity to the Automated Parameters                              
                                    FILE_WriteBuffer((u8  *)CC_SEQ,             32);    //Container for static not touchable Variables      
                                    FILE_WriteBuffer((u8  *)Velo_Morph,        256);    //Here we have 8x32
                                    FILE_WriteBuffer((u8  *)CC_Store,         256);      
                                    FILE_WriteBuffer((u8  *)Mod_Matrix,       8192);    //8x32x32  For Synths witch built in Mod Matrix                                          
                                    FILE_WriteBuffer((u8  *)MSQ_Store,       65536);    //Motion-Sequence-Data 8x32*256=65536        
                        FILE_WriteClose	(); //The First File named "0" is locatet @ SDCARD/mq/0.mq, now its time to copy this 999 times, I want 1000 Banks/files :)
        
                    //duplicate file 1000x - these will get the patches
                    int patch; 
                    for(patch=0; patch<128; patch++) {//countes 2 999 and do following commandos 999 times in a loop:
                                                    int snapshot; 
                                                    for(snapshot=0; snapshot<4; snapshot++) {//having 4 Snapshot per Song    
                                                        char copyfilepath[8];
                                                        sprintf(copyfilepath, "mq/%d.mq", patch+(snapshot*1000)); //0-999 1000-1999 2000-2999 3000-3999 this will take 10minutes!
                                                        FILE_Copy ((char *)"mq/0.mq", (char *)copyfilepath);}} //copy the File 0.mq to all other 4000 Presets files... HURRAY
                    MUTEX_SDCARD_GIVE; //SD-Card is now free 4 access
                    LED_Gestic=2;	}}
        }
