#include <mios32.h>
#include <seq_bpm.h>
#include <seq_midi_out.h>
#include "seq.h"
#include "app.h"

static s32 SEQ_Tick(u32 bpm_tick);

static u16 main_step_pos = 1; // the Main - Song position (you dont hear that, that is only for SYNC.
static u16 loop_step_pos[8] = {1,1,1,1, 1,1,1,1}; // straight step position bevore swing
       u16 Last[8] = {16,16,16,16, 16,16,16,16}; //calculated Last Step
    u8 Active_Part = 0; //selected Synthpart-Remote  

   u8 Remote1Port;
   u8 Remote1_Setting_CH;
   u8 MSQ_Active[0];
   u8 Rythm;
   u8 CC_Map_Mode;
   
static u8 seq_pause = 0; // pause mode (will be controlled from user interface)

static u16 setPpqnDivider = 8; //to be shure that the 16th-PPQM-divider is changed in main-sync
       s16 TicSend = 0;


s32 SEQ_Init(u32 mode){
    SEQ_Reset();  // reset sequencer
    SEQ_BPM_Init(0);  // init BPM generator
    SEQ_BPM_PPQN_Set(Tic);
    SEQ_BPM_Set(BPM);
    SEQ_BPM_TickSet(0); 
  return 0; // no error
}

s32 SEQ_Handler(void){ // this sequencer handler is called periodically to check for new requests from BPM generator
  // handle requests

  u8 num_loops = 0;
  u8 again = 0;
  do {
    ++num_loops;

    // note: don't remove any request check - clocks won't be propagated
    // so long any Stop/Cont/Start/SongPos event hasn't been flagged to the sequencer
    if( SEQ_BPM_ChkReqStop() ) {
     // SEQ_PlayOffEvents();
    }

    if( SEQ_BPM_ChkReqCont() ) {
      // release pause mode
      seq_pause = 0;
    }

    if( SEQ_BPM_ChkReqStart() ) {
      SEQ_Reset();
    }

    u16 new_song_pos;
    if( SEQ_BPM_ChkReqSongPos(&new_song_pos) ) {
   //   SEQ_PlayOffEvents();
    }

    u32 bpm_tick;
    if( SEQ_BPM_ChkReqClk(&bpm_tick) > 0 ) {
      again = 1; // check all requests again after execution of this part

      SEQ_Tick(bpm_tick);
    }
  } while( again && num_loops < 10 );

  return 0; // no error
}

s32 SEQ_Reset(void){
  seq_pause = 0;   // release pause mode
  SEQ_BPM_TickSet(0);   // reset BPM tick
  return 0; // no error
}

s32 SEQ_Loop(void){return 0;}


static s32 SEQ_Tick(u32 bpm_tick){  // performs a single bpm tick
  //MAIN RESET ON FIRST TIC EVER... (PLAY-MSQ_Active[0]Button)
  if( bpm_tick == 0 ) { main_step_pos = -1; SyncFlag = 1; 
                        loop_step_pos[0] = 0;loop_step_pos[1] = 0;loop_step_pos[2] = 0;loop_step_pos[3] = 0;
                        loop_step_pos[4] = 0;loop_step_pos[5] = 0;loop_step_pos[6] = 0;loop_step_pos[7] = 0;}   // start immediatly @ Loop Point

  //96tic loop
  TicSend = (bpm_tick % (SEQ_BPM_PPQN_Get()/setPpqnDivider));

  if(TicSend == 0 ) { // whenever we reach a new 16th note (e.g 96 tics @384 ppqn):
         //MAIN LOOP COUNTER
         if( ++main_step_pos >= MainLoop ) main_step_pos = 0; // increment step number until it reaches the mainloop length of e.g. 64, encrease song steps

         if(main_step_pos == 0) {

                if(SyncFlag  == 1){//Something has changed, Set new Loop point when MainLoop is finished
                   Last[0]  = (MSQ_Loop_Length_Set[0]*StepPerPage)+StepPerPage; //Last step in loop = (0Page*16Perpage)+16=16
                   Last[1]  = (MSQ_Loop_Length_Set[1]*StepPerPage)+StepPerPage;                
                   Last[2]  = (MSQ_Loop_Length_Set[2]*StepPerPage)+StepPerPage;                
                   Last[3]  = (MSQ_Loop_Length_Set[3]*StepPerPage)+StepPerPage;                  
                   Last[4]  = (MSQ_Loop_Length_Set[4]*StepPerPage)+StepPerPage;                  
                   Last[5]  = (MSQ_Loop_Length_Set[5]*StepPerPage)+StepPerPage;                  
                   Last[6]  = (MSQ_Loop_Length_Set[6]*StepPerPage)+StepPerPage;                  
                   Last[7]  = (MSQ_Loop_Length_Set[7]*StepPerPage)+StepPerPage;                     

                   SyncFlag = 3; //New SyncFlag to avoid double triggering events.
                   //set new step position
                   loop_step_pos[0] = 0; loop_step_pos[1] = 0; loop_step_pos[2] = 0; loop_step_pos[3] = 0; //StepPerPAge = 0-15, PageFirst 0-15 > 0x0=0 1x15= 15
                   loop_step_pos[4] = 0; loop_step_pos[5] = 0; loop_step_pos[6] = 0; loop_step_pos[7] = 0;} 

              if(SyncFlag == 4) {
                 SEQ_BPM_PPQN_Set(Tic); //set TICs (normally 384)
                 SyncFlag = 3;} //New SyncFlag to avoid double triggering events.

              if(SyncFlag == 5) {
                 setPpqnDivider = PpqnDivider; //set PPQN Divider in time
                 SyncFlag = 3;} //New SyncFlag to avoid double triggering events.

              if(SyncFlag == 4) {
                 SEQ_BPM_PPQN_Set(Tic); //set TICs (normally 384)
                 SyncFlag = 3;} //New SyncFlag to avoid double triggering events.

              if(SyncFlag == 5) {
                 setPpqnDivider = PpqnDivider; //set PPQN Divider in time
                 SyncFlag = 3;} //New SyncFlag to avoid double triggering events.
             }
             

           //Avoid Additional Counter ++ after giving new Loop Step Positions
	       if(SyncFlag != 3) { if( ++loop_step_pos[0] >= Last[0]) loop_step_pos[0] = 0;
                               if( ++loop_step_pos[1] >= Last[1]) loop_step_pos[1] = 0;
                               if( ++loop_step_pos[2] >= Last[2]) loop_step_pos[2] = 0;
                               if( ++loop_step_pos[3] >= Last[3]) loop_step_pos[3] = 0;
                               if( ++loop_step_pos[4] >= Last[4]) loop_step_pos[4] = 0;
                               if( ++loop_step_pos[5] >= Last[5]) loop_step_pos[5] = 0;
                               if( ++loop_step_pos[6] >= Last[6]) loop_step_pos[6] = 0;
                               if( ++loop_step_pos[7] >= Last[7]) loop_step_pos[7] = 0;
           }
           //Reset Syncflac
	       if(SyncFlag == 3) { SyncFlag = 0;}

   //2 Synths and Remote
   if(MSQ_Active[0] == 1) {MSQ(0, loop_step_pos[0]);}
   
   if(Active_Part == 0 && CC_Map_Mode == 0) {
       //BCR2000 Loop Position Indication
       int IND; 
           IND = ((10000*loop_step_pos[0]/(StepPerPage*(MSQ_Loop_Length_Set[0]+1))) * 16)/10000;        
           MIOS32_MIDI_SendCC(Remote1Port, Remote1_Setting_CH, 36, IND);} //show Loop Position on a LED-RING    
      
   //2 Synths and Remote
   if(MSQ_Active[1] == 1) {MSQ(1, loop_step_pos[1]);}
   
   if(Active_Part == 1 && CC_Map_Mode == 0) {
       //BCR2000 Loop Position Indication
       int IND; 
           IND = ((10000*loop_step_pos[1]/(StepPerPage*(MSQ_Loop_Length_Set[1]+1))) * 16)/10000;        
           MIOS32_MIDI_SendCC(Remote1Port, Remote1_Setting_CH, 36, IND);} //show Loop Position on a LED-RING    
      
   //2 Synths and Remote
   if(MSQ_Active[2] == 1) {MSQ(2, loop_step_pos[2]);}
   
   if(Active_Part == 2 && CC_Map_Mode == 0) {
       //BCR2000 Loop Position Indication
       int IND; 
           IND = ((10000*loop_step_pos[2]/(StepPerPage*(MSQ_Loop_Length_Set[2]+1))) * 16)/10000;        
           MIOS32_MIDI_SendCC(Remote1Port, Remote1_Setting_CH, 36, IND);} //show Loop Position on a LED-RING       
      
   //2 Synths and Remote
   if(MSQ_Active[3] == 1) {MSQ(3, loop_step_pos[3]);}
   
   if(Active_Part == 3 && CC_Map_Mode == 0) {
       //BCR2000 Loop Position Indication
       //u16 IND; // should give us 0-15 - because we have 16 LEDs to enlight...
       int IND; 
           IND = ((10000*loop_step_pos[3]/(StepPerPage*(MSQ_Loop_Length_Set[3]+1))) * 16)/10000;        
           MIOS32_MIDI_SendCC(Remote1Port, Remote1_Setting_CH, 36, IND);} //show Loop Position on a LED-RING       
      
   //2 Synths and Remote
   if(MSQ_Active[4] == 1) {MSQ(4, loop_step_pos[4]);}
   
   if(Active_Part == 4 && CC_Map_Mode == 0) {
       //BCR2000 Loop Position Indication
        int IND; 
           IND = ((10000*loop_step_pos[4]/(StepPerPage*(MSQ_Loop_Length_Set[4]+1))) * 16)/10000;        
           MIOS32_MIDI_SendCC(Remote1Port, Remote1_Setting_CH, 36, IND);} //show Loop Position on a LED-RING       
      
   //2 Synths and Remote
   if(MSQ_Active[5] == 1) {MSQ(5, loop_step_pos[5]);}
   
   if(Active_Part == 5 && CC_Map_Mode == 0) {
       //BCR2000 Loop Position Indication
       //u16 IND; // should give us 0-15 - because we have 16 LEDs to enlight...
       int IND; 
           IND = ((10000*loop_step_pos[5]/(StepPerPage*(MSQ_Loop_Length_Set[5]+1))) * 16)/10000;        
           MIOS32_MIDI_SendCC(Remote1Port, Remote1_Setting_CH, 36, IND);} //show Loop Position on a LED-RING       
      
   //2 Synths and Remote
   if(MSQ_Active[6] == 1) {MSQ(6, loop_step_pos[6]);}
   
   if(Active_Part == 6 && CC_Map_Mode == 0) {
       //BCR2000 Loop Position Indication
       int IND; 
           IND = ((10000*loop_step_pos[6]/(StepPerPage*(MSQ_Loop_Length_Set[6]+1))) * 16)/10000;        
           MIOS32_MIDI_SendCC(Remote1Port, Remote1_Setting_CH, 36, IND);} //show Loop Position on a LED-RING       
      
   //2 Synths and Remote
   if(MSQ_Active[7] == 1 && CC_Map_Mode == 0) {MSQ(7, loop_step_pos[7]);}
   
   if(Active_Part == 7) {
       //BCR2000 Loop Position Indication
       int IND; 
           IND = ((10000*loop_step_pos[7]/(StepPerPage*(MSQ_Loop_Length_Set[7]+1))) * 16)/10000;        
           MIOS32_MIDI_SendCC(Remote1Port, Remote1_Setting_CH, 36, IND);} //show Loop Position on a LED-RING           
       
       
     } //END "If Tic=0"...
     


//End-drum-trigger
  return 0;} // no error,
