#include <mios32.h>
#include <seq_bpm.h>
#include <seq_midi_out.h>
#include "app.h"

static s32 SEQ_Tick(u32 bpm_tick);

static u16 main_step_pos = 1; // the Main - Song position (you dont hear that, that is only for SYNC.

       u16 last[8] = {16,16,16,16, 16,16,16,16}; //calculated Last Step

   u8 Rythm;
   u8 CC_Map_Mode;
   
static u8 seq_pause = 0; // pause mode (will be controlled from user interface)

       s16 TicSend = 0;


s32 SEQ_Init(u32 mode){
    SEQ_Reset();  //  reset sequencer
    SEQ_BPM_Init(0);  //  init BPM generator
    SEQ_BPM_PPQN_Set(384);
    SEQ_BPM_Set(beat[0].bpm);
    SEQ_BPM_TickSet(0);

    u8 x; for(x=0; x<8; x++) {loop_step_pos[x] = 1;} // straight step position bevore swing
    
    
  return 0; // no error
}

s32 SEQ_Handler(void){ // this sequencer handler is called periodically to check for new requests from BPM generator
  // handle requests

  u8 num_loops = 0;
  u8 again = 0;
  do {
    ++num_loops;

    // note: don't remove any request check - clocks won't be propagated
    // so long any Stop/Cont/Start/SongPos event hasn't been flagged to the sequencer
    if( SEQ_BPM_ChkReqStop() ) {
     // SEQ_PlayOffEvents();
    }

    if( SEQ_BPM_ChkReqCont() ) {
      // release pause mode
      seq_pause = 0;
    }

    if( SEQ_BPM_ChkReqStart() ) {
      SEQ_Reset();
    }

    u16 new_song_pos;
    if( SEQ_BPM_ChkReqSongPos(&new_song_pos) ) {
   //   SEQ_PlayOffEvents();
    }

    u32 bpm_tick;
    if( SEQ_BPM_ChkReqClk(&bpm_tick) > 0 ) {
      again = 1; // check all requests again after execution of this part

      SEQ_Tick(bpm_tick);
    }
  } while( again && num_loops < 10 );

  return 0; // no error
}

s32 SEQ_Reset(void){
  seq_pause = 0;   // release pause mode
  SEQ_BPM_TickSet(0);   // reset BPM tick
  return 0; // no error
}

s32 SEQ_Loop(void){return 0;}


static s32 SEQ_Tick(u32 bpm_tick){  // performs a single bpm tick
static u8 track = 0;


  // MAIN RESET ON FIRST TIC EVER... (PLAY-Button, PLAY-beat.MSQ_Active[0]Button)
  if(  bpm_tick == 0 ) {        
            flag.FirstTic =  1;
            main_step_pos = -2;
            flag.NeedSync =  1;
            loop_step_pos[0] = 0;
            loop_step_pos[1] = 0;
            loop_step_pos[2] = 0;
            loop_step_pos[3] = 0;
            loop_step_pos[4] = 0;
            loop_step_pos[5] = 0;
            loop_step_pos[6] = 0;
            loop_step_pos[7] = 0;}

  // 32th tic calculation/generation
  TicSend = (bpm_tick % (SEQ_BPM_PPQN_Get()/8));


  if(TicSend == 0 ) { // whenever we reach a new 16th note (e.g 96 tics @384 ppqn):
         //MAIN LOOP COUNTER
         if( ++main_step_pos >= beat[0].MainLoop ) { main_step_pos = 0; } //  increment step number until it reaches the mainloop length

         if(main_step_pos == 0) {
                    
                // We have started the Sequencer right now... now do something
                if(flag.NeedSync == 1) {
                    for(track=0; track<8; track++) {
                    last[track]  = (beat[track].loop_lenght_set*beat[0].PAGE_Steps) + beat[0].PAGE_Steps; } //Last step in loop = (0Page*16Perpage)+16=16                    

                if( flag.FirstTic == 1 ) { // set new step position
                    for(track=0; track<8; track++) {    loop_step_pos[track] = 0; } //set new step position
                    flag.FirstTic = 0; }
                    
                    flag.NeedSync = 0;} } // disable Flag to avoid double triggering of events..


        for(track=0; track<8; track++) {    if( ++loop_step_pos[track] >= last[track]) loop_step_pos[track] = 0;   }
       } //END "If Tic=0"...        


        
      if(TicSend == 1 ) { // a little delay... more stabile programm...
        // Send CC to Synths
        MSQ(0, loop_step_pos[0]) ;
        MSQ(1, loop_step_pos[1]) ;}
    
      if(TicSend == 2 ) { // a little delay... more stabile programm...
        // Send CC to Synths
        MSQ(2, loop_step_pos[2]) ;
        MSQ(3, loop_step_pos[3]) ;}    
    
      if(TicSend == 3 ) { // a little delay... more stabile programm...
        // Send CC to Synths
        MSQ(4, loop_step_pos[4]) ;
        MSQ(5, loop_step_pos[5]) ;} 

      if(TicSend == 4 ) { // a little delay... more stabile programm...
        // Send CC to Synths
        MSQ(6, loop_step_pos[6]) ;
        MSQ(7, loop_step_pos[7]) ;} 
     
//End-drum-trigger
  return 0;} // no error,
