//www.ucapps.de - diy - open - free
#include <mios32.h>
#include "app.h"
#include <blm_x.h>
#include <FreeRTOS.h>
#include <task.h>
#include <queue.h>
#include <app_lcd.h>

#define PRIORITY_TASK_BLM_CHECK    ( tskIDLE_PRIORITY + 2 )

static void TASK_BLM_Check(void *pvParameters);
    s16 enc[17] = {};
    s16 encDiv16[17] = {};

static int steptime = 0; //milisecond step duration


//ENCODERs
const mios32_enc_config_t encoders[17] = {//(SR begin with 1, ENC with 0) // setup the Pinout of Encoders
	{ .cfg.type=DETENTED2, .cfg.speed=FAST, .cfg.speed_par=2, .cfg.sr=1, .cfg.pos=6 },		//Menue Encoder 0 
	{ .cfg.type=DETENTED2, .cfg.speed=FAST, .cfg.speed_par=2, .cfg.sr=1, .cfg.pos=4 },		//Menue Encoder 1
	{ .cfg.type=DETENTED2, .cfg.speed=FAST, .cfg.speed_par=2, .cfg.sr=1, .cfg.pos=2 },      //Menue Encoder 2
	{ .cfg.type=DETENTED2, .cfg.speed=FAST, .cfg.speed_par=2, .cfg.sr=1, .cfg.pos=0 },      //Menue Encoder 3
	{ .cfg.type=DETENTED2, .cfg.speed=FAST, .cfg.speed_par=2, .cfg.sr=3, .cfg.pos=6 },      //Menue Encoder 4
	{ .cfg.type=DETENTED2, .cfg.speed=FAST, .cfg.speed_par=2, .cfg.sr=3, .cfg.pos=4 },      //Menue Encoder 5
	{ .cfg.type=DETENTED2, .cfg.speed=FAST, .cfg.speed_par=2, .cfg.sr=3, .cfg.pos=2 },      //Menue Encoder 6	
	{ .cfg.type=DETENTED2, .cfg.speed=FAST, .cfg.speed_par=2, .cfg.sr=3, .cfg.pos=0 },      //Menue Encoder 7	
	{ .cfg.type=DETENTED2, .cfg.speed=FAST, .cfg.speed_par=2, .cfg.sr=4, .cfg.pos=6 },      //Menue Encoder 8
	{ .cfg.type=DETENTED2, .cfg.speed=FAST, .cfg.speed_par=2, .cfg.sr=4, .cfg.pos=4 },      //Menue Encoder 9
	{ .cfg.type=DETENTED2, .cfg.speed=FAST, .cfg.speed_par=2, .cfg.sr=4, .cfg.pos=2 },      //Menue Encoder 10
	{ .cfg.type=DETENTED2, .cfg.speed=FAST, .cfg.speed_par=2, .cfg.sr=4, .cfg.pos=0 },      //Menue Encoder 11
	{ .cfg.type=DETENTED2, .cfg.speed=FAST, .cfg.speed_par=2, .cfg.sr=5, .cfg.pos=6 },      //Menue Encoder 12
	{ .cfg.type=DETENTED2, .cfg.speed=FAST, .cfg.speed_par=2, .cfg.sr=5, .cfg.pos=4 },      //Menue Encoder 13
	{ .cfg.type=DETENTED2, .cfg.speed=FAST, .cfg.speed_par=2, .cfg.sr=5, .cfg.pos=2 },      //Menue Encoder 14
	{ .cfg.type=DETENTED2, .cfg.speed=FAST, .cfg.speed_par=2, .cfg.sr=5, .cfg.pos=0 },      //Menue Encoder 15	
	{ .cfg.type=DETENTED2, .cfg.speed=FAST, .cfg.speed_par=2, .cfg.sr=6, .cfg.pos=2 },      //Menue Encoder MENUE PAGE ENCODER - JOG
	};

void APP_Init(void){

    // Get and Set Multiple LCDs
    MIOS32_LCD_DeviceSet(0);
    MIOS32_LCD_Init(0);
    MIOS32_LCD_DeviceSet(1);
    MIOS32_LCD_Init(0);
    
//BLM driver
  blm_x_config_t blm_x_conf;
  BLM_X_Init();
  blm_x_conf = BLM_X_ConfigGet();
  blm_x_conf.debounce_delay = 10;
  BLM_X_ConfigSet(blm_x_conf);
  xTaskCreate(TASK_BLM_Check, (signed portCHAR *)"BLM_Check", configMINIMAL_STACK_SIZE, NULL, PRIORITY_TASK_BLM_CHECK, NULL);
//ENCODER
  s16 i = 0;
  for(i=0; i<18; ++i) MIOS32_ENC_ConfigSet(i, encoders[i]);		
  }


void APP_Background(void){
    
   // All Led Blinking  // delete this section if you dont want to blink that leds
   static int x = 0;
   static int y = 0;
   
    steptime++;
    if (steptime >= 900000) {     steptime = 0;
    
                                
                                
                                if (x == 1) { for(y=0; y<128; y++) { BLM_X_LEDColorSet(y,0);} }// deactivate LEDs

                                if (x == 0) { for(y=0; y<128; y++) { BLM_X_LEDColorSet(y,1);} }// deactivate LEDs

                                x++;

                                if (x >  1) { x = 0;}
    }
}
    
void APP_MIDI_NotifyPackage(mios32_midi_port_t port, mios32_midi_package_t midi_package){}

void APP_SRIO_ServicePrepare(void){ 
    // BLM DRIVER
    BLM_X_PrepareRow(); //prepare DOUT registers to drive the row
}


void APP_SRIO_ServiceFinish(void){ BLM_X_GetRow(); }   // call the BLM_GetRow function after scan is finished to capture the read DIN values

void APP_DIN_NotifyToggle(u32 pin, u32 pin_value){}

void APP_ENC_NotifyChange(u32 encoder, s32 incrementer){
MIOS32_LCD_DeviceSet  (0); //=1st 2x40 LCD-screen 
MIOS32_LCD_Clear();    //clear screen

//The following lines are not needet, only for test/show you
enc[encoder] = enc[encoder] + incrementer;
if (enc[encoder] <= 0) {enc[encoder] = 0;}
if (enc[encoder] >= 127) {enc[encoder] = 127;}
MIOS32_LCD_DeviceSet  (0); //=1st 2x40 LCD-screen 
MIOS32_LCD_Clear();    //clear screen
MIOS32_LCD_CursorSet(10, 0);  MIOS32_LCD_PrintFormattedString("Encoder: %d  value:%d",encoder, enc[encoder]);
    }
    
void APP_AIN_NotifyChange(u32 pin, u32 pin_value){}

void BLM_Button_NotifyToggle(u32 btn, u32 value){ // will be called on BLM pin changes (see TASK_BLM_Check)
//The following lines are not needet, only for test/show you
MIOS32_LCD_DeviceSet  (0); //=1st 2x40 LCD-screen 
MIOS32_LCD_Clear();    //clear screen
MIOS32_LCD_CursorSet(0, 0);  MIOS32_LCD_PrintFormattedString("%s", "JOG>select LED//button Activates");
MIOS32_LCD_CursorSet(0, 1);  MIOS32_LCD_PrintFormattedString("%s %d   %s %d", "BTN Nr", btn, "LED Nr", enc[16]);
 
BLM_X_LEDColorSet(enc[16],value); //Actaviate LED in the BLMx
  }

static void TASK_BLM_Check(void *pvParameters){
  portTickType xLastExecutionTime;
    // Initialize the xLastExecutionTime variable on task entry
    xLastExecutionTime = xTaskGetTickCount();
    while( 1 ) {
     vTaskDelayUntil(&xLastExecutionTime, 1 / portTICK_RATE_MS);
      // check for BLM pin changes, call BLM_Button_NotifyToggle on each toggled pin
      BLM_X_BtnHandler(BLM_Button_NotifyToggle);
      }
  }
