#ifndef _APP_H
#define _APP_H
extern void APP_Init(void);
extern void APP_Background(void);
extern void APP_Tick(void);
extern void APP_MIDI_Tick(void);
extern void APP_MIDI_NotifyPackage(mios32_midi_port_t port, mios32_midi_package_t midi_package);
extern void APP_SRIO_ServicePrepare(void);
extern void APP_SRIO_ServiceFinish(void);
extern void APP_DIN_NotifyToggle(u32 pin, u32 pin_value);
extern void APP_ENC_NotifyChange(u32 encoder, s32 incrementer);
extern void APP_AIN_NotifyChange(u32 pin, u32 pin_value);

extern u8  PageLast; //>Loop Length - END 
extern u16 MainLoop; //in order to switch in sync

extern u8 ActualSEQ;
 
extern char NeedSync;
extern u8   StepOffset;
extern u16  main_step_pos;  // the Main - Song position (you dont hear that, that is only for SYNC.
extern u16  loop_step_pos[8];
extern char mute[8];
extern char REC[8];
extern u32  IND[8];

extern s16 MainDelay; //the main TIC-Delay

extern s16 BaseTic;  // 128th    12    Dotted 128th     18   128th Triplet     8
extern s16 Tic;  //32x12=384 tics between 2 Notes
extern s8  PpqnDivider;

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//Patch Variables >>> Saved on SDCard (512 Patches)
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
 typedef struct storage {   // to optimize SD-Load-Time, each clips data is stored in this struct
        u16  PB [512];      //  Pitchband inital = 8192 = No Pitchbend! 
         u8  SEQ[512] [8];  //  512Steps, 8NotePolyphony                                      
         u8  MSQ[512];      //  Motion-SEQ of one CC ...eg.:Control-Wheel of Keyboard   
         
        char  leader;       // Programchange able? - only 1 of 4 Song-Clips can send Programchanges via BLMatrix
        char  virgin;       // is there any data in the clip? need to display on a ButtonLed Matrix-Launcher   
         u8   length;       // 1x16, 2x16...
         u8   decay;        // 60ms... could be set with Encoder, but I dont need a variable, since the melody out will be used by the Triggermatrix...
         u8   rythm;        // 4x4=16, 5x3=15 usw... to calculate maximal duration per UI-matrix page
        u16   bpm;   
} store_t;

extern store_t loop[8];


#endif /* _APP_H */
