//16th fixed MelodySequencer, =========================================================
//connect to a Triggermatrix with melody retrigger - to get melody-beatstructure=======
//============2017 by Michael Sigl aka "Phatline,GreatFullTekk,GuteSigl,Technomiliz..."
//non-commercial use only. All other rights reserved. Mioint Based > www.ucapps.de=====
//thx @ TK 4 MIOS==============//
//=====================================================================================
#include <mios32.h>
#include "app.h"
#include <FreeRTOS.h>
#include <portmacro.h>
#include <task.h>
#include <queue.h>
#include <semphr.h>
#include "tasks.h"
#include "file.h"
#include <string.h>
#include <stdio.h>
#include <math.h>
#include <seq_bpm.h>
#include <seq_midi_out.h>
#include "seq.h"
#include <app_lcd.h>


static  void TASK_SEQ       (void *pvParameters);
#define PRIORITY_TASK_SEQ	( tskIDLE_PRIORITY + 4 ) // higher priority than MIDI receive task!
static  s32 NOTIFY_MIDI_Rx  (mios32_midi_port_t port, u8 byte);
static  s32 APP_MIDI_TimeOut(mios32_midi_port_t port);


xSemaphoreHandle xSDCardSemaphore; 	// take and give access to SD-Card
xSemaphoreHandle xLCDSemaphore;		// take and give access to LCD

static file_t midifile_fi; //used to read files from SD-Card

#define MUTEX_LCD_TAKE { while( xSemaphoreTakeRecursive(xLCDSemaphore, (portTickType)0) != pdTRUE ); }  //a Mutex reserve a Resoure (LCD or SD-Card) for a task, until it is given away...
#define MUTEX_LCD_GIVE { xSemaphoreGiveRecursive(xLCDSemaphore); }

  
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//Patch Variables >>> Saved on SDCards (511 Patches)
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
char file_typeBank[4] = "SIGL";	//definie the Filetype which is later saved via "FILE_WriteBuffer" into the file header (use Text/Hex-Editor to proove)
 u16 Sequence[8][512][8]={{{}}};     //8Tracks, 512Steps, 8NotePolyphony
 u16   CC_MSQ[8][512] =  {};//Motion-Sequence of one CC (Control-Wheel of Keyboard
 u16       PB[8][512] = {{}};    // 8192: inital No Pitchbend! 
 u8    CC_SD [8][32] =   {}; //Save all other Variables into this Array - for SD-Card...
 u8 clip_is_virgin = 1; 
 u8 Loop_Length [8] = {1,4,1,4, 1,4,1,4}; //0-15 = Value of LED of a ring
 u8 SetDecayTime[8] = {60,60,60,60, 60,60,60,60}; //60ms... could be set with Encoder, but I dont need a variable, since the melody out will be used by the Triggermatrix...
 u8 Rythm = 4;       //4x4=16, 5x3=15 usw... to calculate maximal duration per UI-matrix page
 u8 BPM = 120;
 
 int RecPitchBuff = {8192};    // 8192: inital No Pitchbend! - 2midichannels...

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////     


//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//System Variables >>> 
////////////////////////////////////////////////
    int ClockPortIN = 32;    //Midiclock Input Port (Midiclock Slave)
    int MelPortOut  = 33;     //MeloTrigger Midi-Port, [32=UART0=Midi-A, 33=UART1=Midi-B]...
    int MeloOutCh[16] ={0,0,1,1,2,2, 3,3,4,4,5,5, 6,6,7,7};  //Midi-Output-Channel Set...0-5 Poly-Melody && 6-15 is not used.
    
//ProgramChange //Send Receive  		
    int PCPortIN = 32; //Receives ProgramChange Messages on Port?
    int PCReceive = 1; //Activate Programchange Receive
    int PCChIN = 15;   //ProgramChange Input Channel

//Melody - Keyboard input
    int MelPortIn = 33;	//MidiPort - Melody-Line-Input
    int melo_input_ch[2] = {0,1}; //Midi-Input-Channels, you can connect 2 devices 0=Midichannel 1, 1=Midichannel 2,... 15=Midichannel 16
    int MelIroute[2] = {1,1}; //Melody Input Channel select (for example in use of 2 keyboards

//Syncronize Setting  -  Timing
    int RecOffset = 1;
    int RecOffsetCalc = 1;
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////   

     
  int MelOmute[8] = {1,1,1,1,1,1,1,1}; //ACTIVATE Button
  int REC[8] = {};

//Loop Stuff
   int NeedSync = 0;    //to indicate that PageFirst/Last has changed, or the DIRECTION, or Loop LengthBtn....
   int MainLoop = 16;
   int Loop[8] = {0,0,0,0,0,0,0,0};
   int MainDelay = 0; //the main TIC-Delay
   int loop_step_pos[8] = {1,1,1,1, 1,1,1,1}; // straight step position
   int main_step_pos = 1;  // the Main - Song position (you dont hear that, that is only for SYNC.

//Tact-Related Sequencer Stuff @ 384 PPQN
  int StepFocus[8] = {0,0,0,0,0,0,0,0}; //Currently edited Step of Track
  int Tic = 384;  //32x12=384 tics between 2 Notes -- not to be saved ... just to calculate
  int PpqnDivider = 4; //4=16th speed, 2:8th speed
  int TrackFocus = 0;               //Currently edited Track
  int TrackClipboard[512][8]  = {{}}; //Copy actual Track into ClipboardBuffer
  int StepClipBoard[8][8] = {};   //Just a memory container to copy paste Sequencer Steps
  int RecMode = 0; //0:Realtime, 1:StepEnter
  int StepLCD = 0; //Which Step and its Notes is Displayed in LCD


/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//Coding only Variables >>>No Settings here<<<
////should not be saved in Patchfile on SD
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

//Retrigger
   int MeloDecayTIMER[8][128] ={{}};//MidiDecayCounter --- Note OFF Handling
   int RecNoteBuff[8] = {24,48,60,128,128,128,128,128};  //Save Incoming 8xPoly-Notes into a temporar BUFFER...waiting to be recordet INTO Sequencer-Matrix "128=No Note"  
   int NoteCount = 0;              //Melody-Input-Buffer from Keyboard, in order to count note number in chord-stack
   int Decay     = 400;            //only initial... later processed via CC


//Menue Store-Load Variables   
   int statusSD;					//Status of the SDCard--connected? fat?
   int statusDir;					//Status "is" your direction "sdcard/t" there?
   
   int SongNrLoad   = 0;				
   int SongNrStor   = 0;
   int MenueUpdateFlag  = 1;         //Flag to force the MenueUpdateCounter to count a periode of time, after the time "update the menue"
   int MenueUpdateCount = 0;  
   int SD_Load_Count = 0;
   int SD_Stor_Count = 0; 
   int SDCardCount  = 0;
   int StoreCount   = 0;
   int LoadCount    = 0; 
     
   int Update_LCD_s  = 0;            //normal LCD-Labeling in back again in secunds
   int Upd_LCD_count = 0;
        
   int StoreFlag   = 0;
   int LoadFlag    = 0;
   int SaveNextFlag = 0;
   int LoadNextFlag = 0;

   int i = 0;						//only to count some things in for loops...
   int Boot_Flag   = 1;            //Update LCDs after Startup
   int PCLoadFlag  = 0;            //Activate Timer to Load ProgramChanges from external source after a time (2seconds)
   int PCLoadFlagCount = 0;        //and a timer for that
   
   char filepathS[16];				//STORE-path - Number of Pathsymbols t/512.tm >>> 8! >> again: dont change the length, or you will have to change the code	
   char filepathL[16];				//LOAD -path - Number of Pathsymbols t/512.tm >>> 8! >> again: dont change the length, or you will have to change the code	
   

//LEDRING
    int IND[8] = {};
    int LED_RING_Common = 0;     //only to calculate   ... count thru common-pins of LED-Rings

    
//LED
    int Blink_Button_time [4] = {125, 250, 500, 1000};// Setup Blink-time in milli seconds
    int Blink_Button_count[4] = {0,   0,   0,   0}; // used as timer only (change nothing here) 
    int Blink_Button[4]       = {0,   0,   0,   0};   //0 LED-OFF, 1 LED-ON
    int SRIO_UpdateFlag = 0;
    int Beat_Flag = 0;

//V-LEDs-Switches...
    int Menue[2]   = { 1, 0 }; //I have 2 PAGE Radio-Switches...
    int ActualMenue     = 0;
    int ActualSequence  = 0; //which Sequence is currently editet (mostly by LCD-MENUE)



   
   //Note Number > Note Name Conversion (for LCD)
   char NoteName[128][3] = {    {"C 0"},{"C#0"},{"D 0"},{"D#0"},{"E 0"},{"F 0"},{"F#0"},{"G 0"},{"G#0"},{"A0"},{"A#0"},{"B 0"},
                                {"C 1"},{"C#1"},{"D 1"},{"D#1"},{"E 1"},{"F 1"},{"F#1"},{"G 1"},{"G#1"},{"A1"},{"A#1"},{"B 1"},
                                {"C 2"},{"C#2"},{"D 2"},{"D#2"},{"E 2"},{"F 2"},{"F#2"},{"G 2"},{"G#2"},{"A2"},{"A#2"},{"B 2"},
                                {"C 3"},{"C#3"},{"D 3"},{"D#3"},{"E 3"},{"F 3"},{"F#3"},{"G 3"},{"G#3"},{"A3"},{"A#3"},{"B 3"},
                                {"C 4"},{"C#4"},{"D 4"},{"D#4"},{"E 4"},{"F 4"},{"F#4"},{"G 4"},{"G#4"},{"A4"},{"A#4"},{"B 4"},
                                {"C 5"},{"C#5"},{"D 5"},{"D#5"},{"E 5"},{"F 5"},{"F#5"},{"G 5"},{"G#5"},{"A5"},{"A#5"},{"B 5"},
                                {"C 6"},{"C#6"},{"D 6"},{"D#6"},{"E 6"},{"F 6"},{"F#6"},{"G 6"},{"G#6"},{"A6"},{"A#6"},{"B 6"},
                                {"C 7"},{"C#7"},{"D 7"},{"D#7"},{"E 7"},{"F 7"},{"F#7"},{"G 7"},{"G#7"},{"A7"},{"A#7"},{"B 7"},
                                {"C 8"},{"C#8"},{"D 8"},{"D#8"},{"E 8"},{"F 8"},{"F#8"},{"G 8"},{"G#8"},{"A8"},{"A#8"},{"B 8"},
                                {"C 9"},{"C#9"},{"D 9"},{"D#9"},{"E 9"},{"F 9"},{"F#9"},{"G 9"},{"G#9"},{"A9"},{"A#9"},{"B 9"},
                                {"C x"},{"C#x"},{"D x"},{"D#x"},{"E x"},{"F x"},{"F#x"},{"G x"}
       };   
   

//Task Prioritys	
#define PRIORITY_TASK_Midi_Decay0	( tskIDLE_PRIORITY + 2 ) //3:Mios standart ---- 5highest, 1lowest Priority
#define PRIORITY_TASK_Midi_Decay1	( tskIDLE_PRIORITY + 2 ) //3:Mios standart
#define PRIORITY_TASK_Midi_Decay2	( tskIDLE_PRIORITY + 2 ) //3:Mios standart
#define PRIORITY_TASK_Midi_Decay3	( tskIDLE_PRIORITY + 2 ) //3:Mios standart
#define PRIORITY_TASK_Midi_Decay4	( tskIDLE_PRIORITY + 2 ) //3:Mios standart ---- 5highest, 1lowest Priority
#define PRIORITY_TASK_Midi_Decay5	( tskIDLE_PRIORITY + 2 ) //3:Mios standart
#define PRIORITY_TASK_Midi_Decay6	( tskIDLE_PRIORITY + 2 ) //3:Mios standart
#define PRIORITY_TASK_Midi_Decay7	( tskIDLE_PRIORITY + 2 ) //3:Mios standart

#define PRIORITY_TASK_Blink_Decay	( tskIDLE_PRIORITY + 2 ) //3:Mios standart
    
#define PRIORITY_SD                 ( tskIDLE_PRIORITY + 3 ) //3:Mios standart
#define PRIORITY_MELODY_BUFFER   	( tskIDLE_PRIORITY + 2 ) //3:Mios standart

#define PRIORITY_APP_NOTEPROCESS	( tskIDLE_PRIORITY + 3 ) //4:high
#define PRIORITY_MENUE	            ( tskIDLE_PRIORITY + 3 ) //2:slow

// local prototype of the task function
static void TASK_Midi_Decay0(void *pvParameters);
static void TASK_Midi_Decay1(void *pvParameters);
static void TASK_Midi_Decay2(void *pvParameters);
static void TASK_Midi_Decay3(void *pvParameters);
static void TASK_Midi_Decay4(void *pvParameters);
static void TASK_Midi_Decay5(void *pvParameters);
static void TASK_Midi_Decay6(void *pvParameters);
static void TASK_Midi_Decay7(void *pvParameters);

static void TASK_Blink_Decay(void *pvParameters);
static void SD(s32 track, s32 clip, s32 job);

static void MELODY_BUFFER(s32 velocity,  s32 note);

void APP_Init(void){

  MIOS32_BOARD_LED_Init(0xffffffff);   // initialize all LEDs
  MIOS32_MIDI_TimeOutCallback_Init(APP_MIDI_TimeOut);  // install timeout callback function

  xTaskCreate(TASK_Midi_Decay0,  (signed portCHAR *)"Midi_Decay0",     64, NULL, 2, NULL);   // start task
  xTaskCreate(TASK_Midi_Decay1,  (signed portCHAR *)"Midi_Decay1",     64, NULL, 2, NULL);   // start task
  xTaskCreate(TASK_Midi_Decay2,  (signed portCHAR *)"Midi_Decay2",     64, NULL, 2, NULL);   // start task
  xTaskCreate(TASK_Midi_Decay3,  (signed portCHAR *)"Midi_Decay3",     64, NULL, 2, NULL);   // start task
  xTaskCreate(TASK_Midi_Decay4,  (signed portCHAR *)"Midi_Decay4",     64, NULL, 2, NULL);   // start task
  xTaskCreate(TASK_Midi_Decay5,  (signed portCHAR *)"Midi_Decay5",     64, NULL, 2, NULL);   // start task
  xTaskCreate(TASK_Midi_Decay6,  (signed portCHAR *)"Midi_Decay6",     64, NULL, 2, NULL);   // start task
  xTaskCreate(TASK_Midi_Decay7,  (signed portCHAR *)"Midi_Decay7",     64, NULL, 2, NULL);   // start task 
   
  xTaskCreate(TASK_Blink_Decay,  (signed portCHAR *)"Blink_Decay",    128, NULL, 2, NULL);   // start task  
  xTaskCreate(TASK_SEQ,          (signed portCHAR *)"SEQ", configMINIMAL_STACK_SIZE, NULL, PRIORITY_TASK_SEQ, NULL);   // install sequencer task 
  
  // SEQUENCER TASKS
  SEQ_MIDI_OUT_Init(0);   // initialize MIDI handler
  SEQ_Init(0);   // initialize sequencer
  MIOS32_MIDI_DirectRxCallback_Init(NOTIFY_MIDI_Rx); 

  xLCDSemaphore = xSemaphoreCreateRecursiveMutex(); // create Mutex for LCD access
       
  //Get and Set Multiple LCDs
    MUTEX_LCD_TAKE;
      MIOS32_LCD_DeviceSet(0);
      MIOS32_LCD_Init(0);
      MIOS32_LCD_DeviceSet(1);
      MIOS32_LCD_Init(0);
      MIOS32_LCD_DeviceSet(2);
      MIOS32_LCD_Init(0);
    MUTEX_LCD_GIVE;	

  xSDCardSemaphore 	= xSemaphoreCreateRecursiveMutex();	//create Mutex for SD-Card access	

  FILE_Init(0);// initialize file functions  
  
  //initiate Pitchbend
  s32 x; for(x=0; x<512; x++)    {    s32 y; for(y=0; y<8; y++)    {      PB[y][x] = 8192;}}    // 8192: inital No Pitchbend! 
}

void APP_Background(void){}

	
void APP_Tick(void){} //@1mS rate, dont do more then 300uS!// called from main task which also handles DIN, ENC and AIN events.


void APP_MIDI_Tick(void){} //@1mS rate, dont do more then 300uS!


void APP_MIDI_NotifyPackage(mios32_midi_port_t port, mios32_midi_package_t midi_package){
  //MIOS32_LCD_CursorSet(0, 0);  MIOS32_LCD_PrintFormattedString("%d %d %d %d", port, midi_package.chn, midi_package.note, midi_package.velocity);

if(midi_package.evnt0 != 248 && midi_package.evnt0 != 187){//Midi-Clock Filter - avoid that Midiclock DataMess
  
      //Receive ProgramChange Information
      if(port == PCPortIN && PCReceive == 1) {
        //Set MidiChannel && Programchange-Channel     set Song Nr with Programchange Nr  show Page PC  setLoadProgram     LOAD command   
        if(PCChIN == 0  && midi_package.evnt0 == 192) {SongNrLoad = midi_package.evnt1; MENUE(0, 0); PCLoadFlag = 1;}
        if(PCChIN == 1  && midi_package.evnt0 == 193) {SongNrLoad = midi_package.evnt1; MENUE(0, 0); PCLoadFlag = 1;} 
        if(PCChIN == 2  && midi_package.evnt0 == 194) {SongNrLoad = midi_package.evnt1; MENUE(0, 0); PCLoadFlag = 1;}
        if(PCChIN == 3  && midi_package.evnt0 == 195) {SongNrLoad = midi_package.evnt1; MENUE(0, 0); PCLoadFlag = 1;} 
        if(PCChIN == 4  && midi_package.evnt0 == 196) {SongNrLoad = midi_package.evnt1; MENUE(0, 0); PCLoadFlag = 1;}
        if(PCChIN == 5  && midi_package.evnt0 == 197) {SongNrLoad = midi_package.evnt1; MENUE(0, 0); PCLoadFlag = 1;} 
        if(PCChIN == 6  && midi_package.evnt0 == 198) {SongNrLoad = midi_package.evnt1; MENUE(0, 0); PCLoadFlag = 1;} 
        if(PCChIN == 7  && midi_package.evnt0 == 199) {SongNrLoad = midi_package.evnt1; MENUE(0, 0); PCLoadFlag = 1;} 
        if(PCChIN == 8  && midi_package.evnt0 == 200) {SongNrLoad = midi_package.evnt1; MENUE(0, 0); PCLoadFlag = 1;} 
        if(PCChIN == 9  && midi_package.evnt0 == 201) {SongNrLoad = midi_package.evnt1; MENUE(0, 0); PCLoadFlag = 1;} 
        if(PCChIN == 10 && midi_package.evnt0 == 202) {SongNrLoad = midi_package.evnt1; MENUE(0, 0); PCLoadFlag = 1;} 
        if(PCChIN == 11 && midi_package.evnt0 == 203) {SongNrLoad = midi_package.evnt1; MENUE(0, 0); PCLoadFlag = 1;} 
        if(PCChIN == 12 && midi_package.evnt0 == 204) {SongNrLoad = midi_package.evnt1; MENUE(0, 0); PCLoadFlag = 1;} 
        if(PCChIN == 13 && midi_package.evnt0 == 205) {SongNrLoad = midi_package.evnt1; MENUE(0, 0); PCLoadFlag = 1;} 
        if(PCChIN == 14 && midi_package.evnt0 == 206) {SongNrLoad = midi_package.evnt1; MENUE(0, 0); PCLoadFlag = 1;} 
        if(PCChIN == 15 && midi_package.evnt0 == 207) {SongNrLoad = midi_package.evnt1; MENUE(0, 0); PCLoadFlag = 1;}
    
    
    //MIOS32_LCD_Clear(); //clear screen 
    //MIOS32_LCD_CursorSet(0,  0);MIOS32_LCD_PrintFormattedString("%d %d %d", midi_package.evnt0, midi_package.evnt1, midi_package.evnt2);
    //MIOS32_LCD_CursorSet(0,  1);MIOS32_LCD_PrintFormattedString("%d %d", SongNrLoad, PCPortIN);
    
    }
    
      //ReRoute PitchBend, CC & NOTE Inputs  - send them to different Functions        
      if(port==MelPortIn){//MELODY-INPUT-BUFFER////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// 
    
        
            //Pitchbend intbit Value Calculation
            s32 channel = 0;
            if(midi_package.evnt0 >= 224 && midi_package.evnt0 <= 239) {channel = midi_package.evnt0 - 224; //Offset to MidiChannel 0-15
                
                    if ((channel==melo_input_ch[0]) && (MelIroute[0]==1))  { //filter Pitchband-Midi-Channel 0   
                            s32 msb = midi_package.evnt2 << 7;
                            RecPitchBuff = midi_package.evnt1 + msb;}
                            
                            
                            
               else if ((channel==melo_input_ch[1]) && (MelIroute[1]==1))  { //filter Pitchband-Midi-Channel 1   
                            s32 msb = midi_package.evnt2 << 7;
                            RecPitchBuff = midi_package.evnt1 + msb;}
            }
        
    
          //Melody-Buffer
           if((midi_package.chn==melo_input_ch[0]) && (MelIroute[0]==1)){ //MATRIX = Melody Routing > which MidiChannel-IN to which MidiChannel-OUT
              if((midi_package.type==NoteOn && midi_package.velocity<=0) || (midi_package.type == NoteOff)) { MELODY_BUFFER(0, midi_package.note);}
              if( midi_package.type==NoteOn && midi_package.velocity>=1)                                    { MELODY_BUFFER(1, midi_package.note);}
           }

           if((midi_package.chn==melo_input_ch[1]) && (MelIroute[1]==1)){ //MATRIX = Melody Routing > which MidiChannel-IN to which MidiChannel-OUT
              if((midi_package.type==NoteOn && midi_package.velocity<=0) || (midi_package.type == NoteOff)) { MELODY_BUFFER(0, midi_package.note);}
              if( midi_package.type==NoteOn && midi_package.velocity>=1)                                    { MELODY_BUFFER(1, midi_package.note);}
           }
           
    } //END MelodyPort-Filter
  } //END MidiClock-Filter
}


static s32 APP_MIDI_TimeOut(mios32_midi_port_t port) { // parse incoming sysex stream for MIOS32 commands
  return 0; // no error
}


void APP_SRIO_ServicePrepare(void){//  L E D  /called before shift register get updates
////////////////////////////////////////////////////////////////////////////////////////
//    
//    #        #####    ###       ####     #    #    #     ###     
//    #        #        #  #      #   #    #    ##   #    #        
//    #        #####    #   #     ###      #    # #  #    #  ##    
//    #        #        #  #      #  #     #    #  # #    #   #    
//    #####    #####    ###       #   #    #    #   ##     ####    
//
//
////STEP-POSITION INDICATION////

//1. Deactivate all Leds from a Ledring
    s32 u = 0;
    for(u = 0; u < 16; u++) {MIOS32_DOUT_PinSet(u, 0);} 
  
//2. Deactivate Common-Pins from all Ledrings
    s32 v = 0;
    for(v = 0; v < 8; v++) {MIOS32_DOUT_PinSet(v+16, 1);} 

//3. Activate Common PIN
    //count thru the Ring-Common-Pins
    LED_RING_Common++; if(LED_RING_Common > 7) {LED_RING_Common = 0;}
    
    switch(LED_RING_Common) {
        case 0: if (MelOmute[0] == 1) { MIOS32_DOUT_PinSet(16,  0);}  break;
        case 1: if (MelOmute[1] == 1) { MIOS32_DOUT_PinSet(17,  0);}  break;            
        case 2: if (MelOmute[2] == 1) { MIOS32_DOUT_PinSet(18,  0);}  break;            
        case 3: if (MelOmute[3] == 1) { MIOS32_DOUT_PinSet(19,  0);}  break;
        case 4: if (MelOmute[4] == 1) { MIOS32_DOUT_PinSet(20,  0);}  break;
        case 5: if (MelOmute[5] == 1) { MIOS32_DOUT_PinSet(21,  0);}  break;
        case 6: if (MelOmute[6] == 1) { MIOS32_DOUT_PinSet(22,  0);}  break;
        case 7: if (MelOmute[7] == 1) { MIOS32_DOUT_PinSet(23,  0);}  break; 
    }

//4. Activate LED-PIN for current Step
    MIOS32_DOUT_PinSet(IND[LED_RING_Common],     1);

//5. Blinking Actual-Sequence-Showup-Indicator
    if(ActualSequence == 0 && LED_RING_Common == 0) {MIOS32_DOUT_PinSet(7,  Blink_Button[1]);}
    if(ActualSequence == 1 && LED_RING_Common == 1) {MIOS32_DOUT_PinSet(7,  Blink_Button[1]);}
    if(ActualSequence == 2 && LED_RING_Common == 2) {MIOS32_DOUT_PinSet(7,  Blink_Button[1]);}
    if(ActualSequence == 3 && LED_RING_Common == 3) {MIOS32_DOUT_PinSet(7,  Blink_Button[1]);}
    if(ActualSequence == 4 && LED_RING_Common == 4) {MIOS32_DOUT_PinSet(7,  Blink_Button[1]);}
    if(ActualSequence == 5 && LED_RING_Common == 5) {MIOS32_DOUT_PinSet(7,  Blink_Button[1]);}
    if(ActualSequence == 6 && LED_RING_Common == 6) {MIOS32_DOUT_PinSet(7,  Blink_Button[1]);}
    if(ActualSequence == 7 && LED_RING_Common == 7) {MIOS32_DOUT_PinSet(7,  Blink_Button[1]);}

/////////////////////////////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////////////////////////////////
//    
//    #        #####    ###        
//    #        #        #  #            
//    #        #####    #   #        
//    #        #        #  #       
//    #####    #####    ###        
//
//

//MENUE-LEDs
if(ActualMenue == 0){
    if(SRIO_UpdateFlag == 0) {
        SRIO_UpdateFlag = 1; //RESET FLAG
        
    //Indicate the PageGroup 0
        MIOS32_DOUT_PinSet(40, 0);  //Turn OFF Menue[1] Bank - LEDs
        MIOS32_DOUT_PinSet(41, 0);  //Turn OFF Menue[1] Bank - LEDs
        MIOS32_DOUT_PinSet(42, 0);  //Turn OFF Menue[1] Bank - LEDs                              
        MIOS32_DOUT_PinSet(43, 0);  //Turn OFF Menue[1] Bank - LEDs 
 
        switch(Menue[0])    {       //Turn ON/OFF Menue[0] Bank - LEDs
            case 0:         MIOS32_DOUT_PinSet(32, 1); 
                            MIOS32_DOUT_PinSet(33, 0);
                            MIOS32_DOUT_PinSet(34, 0);                         
                            MIOS32_DOUT_PinSet(35, 0);  break;
    
            case 1:         MIOS32_DOUT_PinSet(32, 0);
                            MIOS32_DOUT_PinSet(33, 1);
                            MIOS32_DOUT_PinSet(34, 0);                              
                            MIOS32_DOUT_PinSet(35, 0);  break;
    
            case 2:         MIOS32_DOUT_PinSet(32, 0);
                            MIOS32_DOUT_PinSet(33, 0);
                            MIOS32_DOUT_PinSet(34, 1);                              
                            MIOS32_DOUT_PinSet(35, 0);  break;
    
            case 3:         MIOS32_DOUT_PinSet(32, 0);
                            MIOS32_DOUT_PinSet(33, 0);
                            MIOS32_DOUT_PinSet(34, 0);                              
                            MIOS32_DOUT_PinSet(35, 1);  break;
                            }
      }

    
    if(Menue[0] == 0){
      //1st Line of Virtual-LEDs
      MIOS32_DOUT_PinSet( 48, Blink_Button[2]);
      MIOS32_DOUT_PinSet( 49, Blink_Button[2]); 
      MIOS32_DOUT_PinSet( 50, Blink_Button[2]);    
      MIOS32_DOUT_PinSet( 51, Blink_Button[2]);     
      MIOS32_DOUT_PinSet( 52, Blink_Button[2]); 	       
      MIOS32_DOUT_PinSet( 53, Blink_Button[2]);      
      MIOS32_DOUT_PinSet( 54, Blink_Button[2]);       
      MIOS32_DOUT_PinSet( 55, Blink_Button[2]);
      //2nd Line of Virtual-LEDs
      MIOS32_DOUT_PinSet( 56, REC[0]);
      MIOS32_DOUT_PinSet( 57, REC[1]); 
      MIOS32_DOUT_PinSet( 58, REC[2]);        
      MIOS32_DOUT_PinSet( 59, REC[3]);        
      MIOS32_DOUT_PinSet( 60, REC[4]);        
      MIOS32_DOUT_PinSet( 61, REC[5]); 
      MIOS32_DOUT_PinSet( 62, REC[6]);                                                     
      MIOS32_DOUT_PinSet( 63, REC[7]);}

    if(Menue[0] == 1){ // Start, Stop, BPM, 4/4 5/4..., Store Load
      //1st Line of Virtual-LEDs
        //SEQ-Is-Running-LED
        if(SEQ_BPM_IsRunning()==1) {MIOS32_DOUT_PinSet(48,1);
                                    MIOS32_DOUT_PinSet(56,0);}
        else                       {MIOS32_DOUT_PinSet(48,0);
                                    MIOS32_DOUT_PinSet(56,1);}}
      //2nd Line of Virtual-LEDs
      //MIOS32_DOUT_PinSet( 62, REC[6]);}
}

//MENUE-LEDs
if(ActualMenue == 1) {
    if(SRIO_UpdateFlag == 0) {
        SRIO_UpdateFlag = 1; //RESET FLAG
        
        
    //Indicate the PageGroup 0
        MIOS32_DOUT_PinSet(32, 0);  //Turn OFF Menue[0] Bank - LEDs
        MIOS32_DOUT_PinSet(33, 0);  //Turn OFF Menue[0] Bank - LEDs
        MIOS32_DOUT_PinSet(34, 0);  //Turn OFF Menue[0] Bank - LEDs                              
        MIOS32_DOUT_PinSet(35, 0);  //Turn OFF Menue[0] Bank - LEDs 
 
        switch(Menue[1])    {       //Turn ON/OFF Menue[1] Bank - LEDs
            case 0:         MIOS32_DOUT_PinSet(40, 1); 
                            MIOS32_DOUT_PinSet(41, 0);
                            MIOS32_DOUT_PinSet(42, 0);                         
                            MIOS32_DOUT_PinSet(43, 0);  break;

            case 1:         MIOS32_DOUT_PinSet(40, 0); 
                            MIOS32_DOUT_PinSet(41, 1);
                            MIOS32_DOUT_PinSet(42, 0);                         
                            MIOS32_DOUT_PinSet(43, 0);  break;
                            
            case 2:         MIOS32_DOUT_PinSet(40, 0); 
                            MIOS32_DOUT_PinSet(41, 0);
                            MIOS32_DOUT_PinSet(42, 1);                         
                            MIOS32_DOUT_PinSet(43, 0);  break;

            case 3:         MIOS32_DOUT_PinSet(40, 0); 
                            MIOS32_DOUT_PinSet(41, 0);
                            MIOS32_DOUT_PinSet(42, 0);                         
                            MIOS32_DOUT_PinSet(43, 1);  break;
                            }
                }


    if(Menue[1] == 0) {
      //1st Line of Virtual-LEDs
      MIOS32_DOUT_PinSet( 48, MelOmute[0]);
      MIOS32_DOUT_PinSet( 49, MelOmute[1]); 
      MIOS32_DOUT_PinSet( 50, MelOmute[2]);    
      MIOS32_DOUT_PinSet( 51, MelOmute[3]);     
      MIOS32_DOUT_PinSet( 52, MelOmute[4]); 	       
      MIOS32_DOUT_PinSet( 53, MelOmute[5]);      
      MIOS32_DOUT_PinSet( 54, MelOmute[6]);       
      MIOS32_DOUT_PinSet( 55, MelOmute[7]);
      //2nd Line of Virtual-LEDs
      MIOS32_DOUT_PinSet( 56, REC[0]);
      MIOS32_DOUT_PinSet( 57, REC[1]); 
      MIOS32_DOUT_PinSet( 58, REC[2]);        
      MIOS32_DOUT_PinSet( 59, REC[3]);        
      MIOS32_DOUT_PinSet( 60, REC[4]);        
      MIOS32_DOUT_PinSet( 61, REC[5]); 
      MIOS32_DOUT_PinSet( 62, REC[6]);                                                     
      MIOS32_DOUT_PinSet( 63, REC[7]);}
}

//SEQ-Is-Running-LED
if(SEQ_BPM_IsRunning()==0) { MIOS32_DOUT_PinSet(37,1);}//Play LED Deactive 
                      else { if(Beat_Flag == 0)   { MIOS32_DOUT_PinSet(37,0);} //Play LED ACTIVE
                             else {MIOS32_DOUT_PinSet(37,1); }//Play LED Deactive
                            }
}	
    
    
void APP_SRIO_ServiceFinish(void){} //called after shift register chain was scanned



void APP_DIN_NotifyToggle(u32 pin, u32 pin_value){
    
    if(pin_value == 0) {
            
         switch(pin) { //Bank Buttons, and Actual Track Indication, Rerouting of pins
       
            //Bank Button
            case  0:    //Button-Bank-Switch 0  to  switch between Pages of Actual BANK 0
                        if(ActualMenue != 0) {ActualMenue = 0; MenueUpdateFlag=0;}
                        else  { Menue[0]++;    //count thru the pages
                                if(Menue[0] <= 0)  {Menue[0] = 0;};
                                if(Menue[0] >  3)  {Menue[0] = 0;}; 
                                MenueUpdateFlag=0;}   
                        pin = 80;
                                                    break;          
                        
            case  1:    //Button-Bank-Switch 0  to  switch between Pages of Actual BANK 0
                        if(ActualMenue != 1) {ActualMenue = 1; MenueUpdateFlag=0;}
                        else  { Menue[1]++;    //count thru the pages
                                if(Menue[1] <= 0)  {Menue[1] = 0;};
                                if(Menue[1] >  3)  {Menue[1] = 0;}; 
                                MenueUpdateFlag=0;}
                        pin = 81;
                                                    break;              
                                        
            //16x Button
            case  8:    ActualSequence = 0;     pin = 0;    break;
            case  9:    ActualSequence = 1;     pin = 1;    break;
            case 10:    ActualSequence = 2;     pin = 2;    break;
            case 11:    ActualSequence = 3;     pin = 3;    break;
            case 12:    ActualSequence = 4;     pin = 4;    break;
            case 13:    ActualSequence = 5;     pin = 5;    break;
            case 14:    ActualSequence = 6;     pin = 6;    break;
            case 15:    ActualSequence = 7;     pin = 7;    break;
            case 16:    ActualSequence = 0;     pin = 8;    break;
            case 17:    ActualSequence = 1;     pin = 9;    break;
            case 18:    ActualSequence = 2;     pin = 10;   break;
            case 19:    ActualSequence = 3;     pin = 11;   break;
            case 20:    ActualSequence = 4;     pin = 12;   break;
            case 21:    ActualSequence = 5;     pin = 13;   break;
            case 22:    ActualSequence = 6;     pin = 14;   break;
            case 23:    ActualSequence = 7;     pin = 15;   break;
            }

                    
    ////////////////////////////////////////////////////////////////
    //                                                            //
    //  M       E     EEEEEEE    N     N     U     U     EEEEEEE  //                                                                
    //  M E   U E     E          N N   N     U     U     E        //                                                          
    //  M   N   E     EEEE       N  N  N     U     U     EEEE     //                                                          
    //  M       E     E          N   N N     U     U     E        //                                                          
    //  M       E     EEEEEEE    N    NN     UUUUUUU     EEEEEEE  //                                                  
    //                                                            //
    
    ////////////////////////////////////////////////////////////////                          
    //Upper Pages
    if (ActualMenue == 0) {  
                        
        //Page 0 - Loop-length , Record Notes
        if(Menue[0] == 0) {
            
            switch (pin) { //Loop Length  +++  Record-Buttons
                //LOOP-LENGTH-BLOCK      \/Double Looplength on LCD                       ----      Set new Loop-Length   &   Change in SYNC
                case 0:     Loop_Length[0] = Loop_Length[0]  * 2;   if(Loop_Length[0] > MainLoop)  {Loop_Length[0]  = 1;    Loop[0] = Loop_Length[0] * MainLoop;    NeedSync = 1;};    MenueUpdateFlag=0;   break; //new Loop point 
                case 1:     Loop_Length[1] = Loop_Length[1]  * 2;   if(Loop_Length[1] > MainLoop)  {Loop_Length[1]  = 1;    Loop[1] = Loop_Length[1] * MainLoop;    NeedSync = 1;};    MenueUpdateFlag=0;   break; //when MainLoop is finished}}
                case 2:     Loop_Length[2] = Loop_Length[2]  * 2;   if(Loop_Length[2] > MainLoop)  {Loop_Length[2]  = 1;    Loop[2] = Loop_Length[2] * MainLoop;    NeedSync = 1;};    MenueUpdateFlag=0;   break; 
                case 3:     Loop_Length[3] = Loop_Length[3]  * 2;   if(Loop_Length[3] > MainLoop)  {Loop_Length[3]  = 1;    Loop[3] = Loop_Length[3] * MainLoop;    NeedSync = 1;};    MenueUpdateFlag=0;   break; 
                case 4:     Loop_Length[4] = Loop_Length[4]  * 2;   if(Loop_Length[4] > MainLoop)  {Loop_Length[4]  = 1;    Loop[4] = Loop_Length[4] * MainLoop;    NeedSync = 1;};    MenueUpdateFlag=0;   break; 
                case 5:     Loop_Length[5] = Loop_Length[5]  * 2;   if(Loop_Length[5] > MainLoop)  {Loop_Length[5]  = 1;    Loop[5] = Loop_Length[5] * MainLoop;    NeedSync = 1;};    MenueUpdateFlag=0;   break; 
                case 6:     Loop_Length[6] = Loop_Length[6]  * 2;   if(Loop_Length[6] > MainLoop)  {Loop_Length[6]  = 1;    Loop[6] = Loop_Length[6] * MainLoop;    NeedSync = 1;};    MenueUpdateFlag=0;   break; 
                case 7:     Loop_Length[7] = Loop_Length[7]  * 2;   if(Loop_Length[7] > MainLoop)  {Loop_Length[7]  = 1;    Loop[7] = Loop_Length[7] * MainLoop;    NeedSync = 1;};    MenueUpdateFlag=0;   break; 
                //Record-Block
                case  8:    REC[0]  =! REC[0];     if(REC[0] > 1)  {REC[0]  = 1;}; break;
                case  9:    REC[1]  =! REC[1];     if(REC[1] > 1)  {REC[1]  = 1;}; break;
                case 10:    REC[2]  =! REC[2];     if(REC[2] > 1)  {REC[2]  = 1;}; break;
                case 11:    REC[3]  =! REC[3];     if(REC[3] > 1)  {REC[3]  = 1;}; break;
                case 12:    REC[4]  =! REC[4];     if(REC[4] > 1)  {REC[4]  = 1;}; break;
                case 13:    REC[5]  =! REC[5];     if(REC[5] > 1)  {REC[5]  = 1;}; break;
                case 14:    REC[6]  =! REC[6];     if(REC[6] > 1)  {REC[6]  = 1;}; break;
                case 15:    REC[7]  =! REC[7];     if(REC[7] > 1)  {REC[7]  = 1;}; break;
            }
        }

  
        //Page 1 - Start-Stop Internal Clock   -    Beat-Structure  SET  4/4 5/4 6/4 7/4 9/4...   -   Record-Settings
        if(Menue[0] == 1) {
            
            switch(pin) {
                
                case 0:     SEQ_BPM_Start();                    break;
                case 8:     SEQ_BPM_Stop();     SEQ_Init(0);    break;
                
                case 1:     BPM = BPM +20;  if(BPM > 200) {BPM = 20;}  SEQ_BPM_Set(BPM);    NeedSync = 1;       MenueUpdateFlag=0;  break;
                case 9:     BPM = BPM -1;   if(BPM < 20)  {BPM = 20;}  SEQ_BPM_Set(BPM);    NeedSync = 1;       MenueUpdateFlag=0;  break;
                
                case 2:     Rythm++;  
                            if(Rythm  <  2) {Rythm = 2;}
                            if(Rythm  > 16) {Rythm = 2;}
                            NeedSync = 1;                               MenueUpdateFlag=0;  break;   
                            
                case 3:     RecOffset++;    if (RecOffset >= 4)     {RecOffset = 0;}        MenueUpdateFlag=0; break;  
                
                case 4:     SongNrStor++;   if (SongNrStor > 126)   {SongNrStor = 127;}     MenueUpdateFlag=0;  break;
                            
                case 12:    SongNrStor--; 
                            if(SongNrStor <   0) {SongNrStor = 0;}   
                            if(SongNrStor >  127){SongNrStor = 0;}      MenueUpdateFlag=0;  break;

                case 5:     SongNrLoad++;   if(SongNrLoad > 126)    {SongNrLoad = 127;}     MenueUpdateFlag=0;  break;
                            
                case 13:    SongNrLoad--; 
                            if(SongNrLoad <   0) {SongNrLoad = 0;}   
                            if(SongNrLoad >  127){SongNrLoad = 0;}      MenueUpdateFlag=0;  break;
                            
                            //Store/load @ ProgramChange
                case 6:     StoreFlag = 1; break;         //Job1=load, Job2=store, Job3=initalize card 
                
                case 14:    LoadFlag  = 1; break;         //Job1=load, Job2=store, Job3=initalize card 
                                    
            }
        }
    
    }
    
    /////////////////////////////////////////////////////////////////
    //Lower Pages
    if (ActualMenue == 1) {  
                        
        //Page 0 - Loop-length , Record Notes
        if(Menue[1] == 0) {    
            
            switch(pin) {
                //Mute-Block
                case 0:     MelOmute[0] =! MelOmute[0];    if(MelOmute[0] > 1) {MelOmute[0] = 1;}; break;
                case 1:     MelOmute[1] =! MelOmute[1];    if(MelOmute[1] > 1) {MelOmute[1] = 1;}; break;
                case 2:     MelOmute[2] =! MelOmute[2];    if(MelOmute[2] > 1) {MelOmute[2] = 1;}; break;
                case 3:     MelOmute[3] =! MelOmute[3];    if(MelOmute[3] > 1) {MelOmute[3] = 1;}; break;
                case 4:     MelOmute[4] =! MelOmute[4];    if(MelOmute[4] > 1) {MelOmute[4] = 1;}; break;
                case 5:     MelOmute[5] =! MelOmute[5];    if(MelOmute[5] > 1) {MelOmute[5] = 1;}; break;
                case 6:     MelOmute[6] =! MelOmute[6];    if(MelOmute[6] > 1) {MelOmute[6] = 1;}; break;
                case 7:     MelOmute[7] =! MelOmute[7];    if(MelOmute[7] > 1) {MelOmute[7] = 1;}; break;
                //Record-Block
                case  8:    REC[0]  =! REC[0];      if(REC[0] > 1)  {REC[0]  = 1;}; break;
                case  9:    REC[1]  =! REC[1];      if(REC[1] > 1)  {REC[1]  = 1;}; break;
                case 10:    REC[2]  =! REC[2];      if(REC[2] > 1)  {REC[2]  = 1;}; break;
                case 11:    REC[3]  =! REC[3];      if(REC[3] > 1)  {REC[3]  = 1;}; break;
                case 12:    REC[4]  =! REC[4];      if(REC[4] > 1)  {REC[4]  = 1;}; break;
                case 13:    REC[5]  =! REC[5];      if(REC[5] > 1)  {REC[5]  = 1;}; break;
                case 14:    REC[6]  =! REC[6];      if(REC[6] > 1)  {REC[6]  = 1;}; break;
                case 15:    REC[7]  =! REC[7];      if(REC[7] > 1)  {REC[7]  = 1;}; break;
            }
        }
    }
    
    //Update UI
    SRIO_UpdateFlag=0; //activate 
    }
}


void APP_ENC_NotifyChange(s32 encoder, s32 incrementer){}


static void TASK_SEQ(void *pvParameters){ //called periodically each mS to handle sequencer requests
  portTickType xLastExecutionTime;

  // Initialise the xLastExecutionTime variable on task entry
  xLastExecutionTime = xTaskGetTickCount();

  while( 1 ) {
    vTaskDelayUntil(&xLastExecutionTime, 1 / portTICK_RATE_MS);

    // execute sequencer handler
    SEQ_Handler();

  }
}

static s32 NOTIFY_MIDI_Rx(mios32_midi_port_t port,  u8 midi_byte){//filter Midiclock Port and rerout it to SEQUENCER-BPM
if(port == ClockPortIN) { SEQ_BPM_NotifyMIDIRx(midi_byte); }
  return 0; // no error, no filtering
}


///////////////////////////////////////////////
//Melody-Out-Generation - via incoming sequence
s32 APP_NOTEPROCESS(s32 port, s32 note, s32 velocity, s32 step, s32 tic){ //do triggering
           
if (port == 0) { //Messages from Sequencer-Tic and Steps

//////////////////////////////////////////////////////////////////////////////////////// 
//RECORD Tracks
    s32 recNr;	for(recNr=0; recNr<8; ++recNr) {  //Record-Tracks [0] - [7] 
         
          if(REC[recNr] == 1) {//Record Switch Active?
                      //Write Notes in currently played Step
                      if(tic <= 48 )  {
                          RecOffsetCalc = loop_step_pos[recNr] - RecOffset;
                          if(RecOffsetCalc < 0) {RecOffsetCalc = (Loop_Length[recNr] * MainLoop) - RecOffsetCalc;} 
                          if(RecOffsetCalc > (Loop_Length[recNr] * MainLoop)) {RecOffsetCalc = RecOffsetCalc - (Loop_Length[recNr] * MainLoop);}
                          
                          s32 x=0;	for(x=0; x<8; ++x) {
                            Sequence[recNr] [RecOffsetCalc] [x] = RecNoteBuff[x];} 
                        
                         //Write Pitchbend in currently played Step
                             PB[recNr] [RecOffsetCalc] = RecPitchBuff;                            
                      }
                      
                      else { //UP-QUANTIZE > Write Notes into Next Step
                          RecOffsetCalc = loop_step_pos[recNr] - RecOffset + 1;
                          if(RecOffsetCalc < 0) {RecOffsetCalc = (Loop_Length[recNr] * MainLoop) - RecOffsetCalc;} 
                          if(RecOffsetCalc > (Loop_Length[recNr] * MainLoop)) {RecOffsetCalc = RecOffsetCalc - (Loop_Length[recNr] * MainLoop);}
                          
                          s32 x=0;	for(x=0; x<8; ++x) {
                            Sequence[recNr] [RecOffsetCalc] [x] = RecNoteBuff[x];} 
                        
                            //Write Pitchbend up quantized
                            PB[recNr] [RecOffsetCalc] = RecPitchBuff;  
    }}}


////////////////////////////////////////////////////////////////////////////////////////
//    
//    #####      ####     #     ###     
//      #        #   #    #    #        
//      #        ###      #    #  ##    
//      #        #  #     #    #   #    
//      #        #   #    #    #####    
//
////////////////////////////////////////////////////////////////////
if(MainDelay  == tic) {          s32 trigNr=0;	for(trigNr=0; trigNr<8; ++trigNr) {  //Trigger [0] - [7]  
                 
       if ( (MelOmute[trigNr]==1) &&  //ACTIVATE Button 
            (   (Sequence[trigNr] [loop_step_pos[trigNr]] [0] > 0)  || //any Note in Sequencer Step? Right Tic?
                (Sequence[trigNr] [loop_step_pos[trigNr]] [1] > 0)  ||
                (Sequence[trigNr] [loop_step_pos[trigNr]] [2] > 0)  ||
                (Sequence[trigNr] [loop_step_pos[trigNr]] [3] > 0)  ||
                (Sequence[trigNr] [loop_step_pos[trigNr]] [4] > 0)  ||
                (Sequence[trigNr] [loop_step_pos[trigNr]] [5] > 0)  ||
                (Sequence[trigNr] [loop_step_pos[trigNr]] [6] > 0)  ||
                (Sequence[trigNr] [loop_step_pos[trigNr]] [7] > 0)  ||
                ((REC[trigNr] == 1) && (MainDelay == tic))
            )   )
         {  //send Poly Melody NoteOut
                    Decay = SetDecayTime[trigNr]; //get predefinied Melody-Decay-Time
                    
                if(REC[trigNr] == 0) { //Trigger actual step
                    s32 buf;	for(buf=0; buf<8; ++buf) {                     

                            if(Sequence[trigNr][loop_step_pos[trigNr]][buf] < 128) {
                                MIOS32_MIDI_SendNoteOn(MelPortOut, MeloOutCh[trigNr], Sequence[trigNr][loop_step_pos[trigNr]][buf], 127); 
                                MeloDecayTIMER[trigNr][Sequence[trigNr][loop_step_pos[trigNr]][buf]] = Decay;} 
                    }
                                            //if(RecPitchBuff =! 8192) { //send Pitchbend-Values only if they are
                            MIOS32_MIDI_SendPitchBend(MelPortOut, MeloOutCh[trigNr], PB[trigNr][loop_step_pos[trigNr]]);
                                
                                 
                }               
                
                if(REC[trigNr] == 1) { //Trigger while recording
                    s32 buf;	for(buf=0; buf<8; ++buf) {                     

                            if(RecNoteBuff[buf] < 128) {
                                MIOS32_MIDI_SendNoteOn(MelPortOut, MeloOutCh[trigNr], RecNoteBuff[buf], 127); 
                                MeloDecayTIMER[trigNr][Sequence[trigNr][loop_step_pos[trigNr]][buf]] = Decay;}
                            
                            //if(RecPitchBuff =! 8192) { //send Pitchbend-Values only if they are
                            MIOS32_MIDI_SendPitchBend(MelPortOut, MeloOutCh[trigNr], RecPitchBuff);
                    }               }   
        }

}}
////////////////////Beat_Flag = 0;////////////////////////////////////////////////////////////////////



//MENU PAGE: chord-display
if( (tic == 60) && (Menue[1] == 0) && (ActualMenue == 1) ) { MENUE(125, 0);}     //update MENUE after a while...but only by tic 20 in order to get more CPU-time...   
}        
//Beat LED
if(tic > 0)     {Beat_Flag = 0;}//Play LED Deactive
else            {Beat_Flag = 1;};    

  return 0; // no error,
}


// S T O R A G E - SD - C A R D      ///  read write clips/programchanges
static void SD(s32 track, s32 clip, s32 job){         //Job1=load all, Job2=store all, Job3=initalize card
    s32 t = 0; //track counter initation
    
    switch(job) {   
 
// R E A D /////////////////////////////////////////////////////////////////////////////////////////////////////// 
          
            case 1: //LOAD single Clip
                        MUTEX_SDCARD_TAKE;  
                               sprintf(filepathL, "sq/%d-%d.sq", track, clip);
                               FILE_ReadOpen  (&midifile_fi, filepathL);
                               FILE_ReadBuffer((u8  *)file_typeBank,        4); 	
                               FILE_ReadBuffer((u8  *)Sequence[track],  sizeof(Sequence [track])); //u8 Sequence[8][512][8]  
                               FILE_ReadBuffer((u8  *)CC_MSQ  [track],  sizeof(CC_MSQ   [track])); //Control-Change-Motion-Sequence
                               FILE_ReadBuffer((u8  *)PB      [track],  sizeof(PB       [track]));     
                               FILE_ReadBuffer((u8  *)CC_SD   [track],  sizeof(CC_SD    [track]));
                               FILE_ReadClose	(&midifile_fi);
                        MUTEX_SDCARD_GIVE;      
                            
                        //write  Variables to Array    
                        clip_is_virgin       = CC_SD[track][0];    
                        SetDecayTime[track]  = CC_SD[track][1];
                        Loop_Length [track]  = CC_SD[track][2];
                        Rythm                = CC_SD[track][3];
                        BPM                  = CC_SD[track][4];

                        
                        //Calculate new Loop Lengths
                        Loop[track]         = Loop_Length[track] * MainLoop;
                        
    
                        //SEQ_BPM_Set(BPM);
                        NeedSync = 1; //update ClockCounter when ready...
               
                        SongNrStor = SongNrLoad; //transfair load nr 2 store nr.
                    break;
                    
            case 2: //LOAD all Clips - FOR  P R O G R A M  C H A N G E
                          for( t=0; t<8; t++) { 
                                MUTEX_SDCARD_TAKE;  
                                       sprintf(filepathL, "sq/%d-%d.sq", t, clip);
                                       FILE_ReadOpen  (&midifile_fi, filepathL);
                                       FILE_ReadBuffer((u8  *)file_typeBank,     4); 	
                                       FILE_ReadBuffer((u8  *)Sequence[t],  sizeof(Sequence [t])); //u8 Sequence[8][512][8]  
                                       FILE_ReadBuffer((u8  *)CC_MSQ  [t],  sizeof(CC_MSQ   [t])); //Control-Change-Motion-Sequence
                                       FILE_ReadBuffer((u8  *)PB      [t],  sizeof(PB       [t]));     
                                       FILE_ReadBuffer((u8  *)CC_SD   [t],  sizeof(CC_SD    [t]));            
                                       FILE_ReadClose	(&midifile_fi);
                                MUTEX_SDCARD_GIVE;     
                                 
                        //get  Variables from Array    
                        clip_is_virgin   = CC_SD[t][0];    
                        SetDecayTime[t]  = CC_SD[t][1];
                        Loop_Length [t]  = CC_SD[t][2];
                        Rythm            = CC_SD[t][3];
                        BPM              = CC_SD[t][4];
                                
                                //Calculate new Loop Lengths
                                Loop[t]         = Loop_Length[t] * MainLoop;
                        }
                            


                        //SEQ_BPM_Set(BPM);
                        NeedSync = 1; //update ClockCounter when ready...
               
                        SongNrStor = SongNrLoad; //transfair load nr 2 store nr.
                        
                        MUTEX_LCD_TAKE; 
                            MIOS32_LCD_DeviceSet(2); MIOS32_LCD_Clear(); MIOS32_LCD_CursorSet(0, 0); 
                            MIOS32_LCD_PrintFormattedString	("%s", "PROGRAM LOAD - Finished");
                        MUTEX_LCD_GIVE; 
                        Update_LCD_s = 1; //normal LCD-Labeling in back again in a second
                    break;
                	
                    
// S T O R E /////////////////////////////////////////////////////////////////////////////////////////////////////               
  
            case 3: //S T O R E Single Clip
            
                                //get  Variables from Array      
                                CC_SD[track][0]    =  clip_is_virgin;   
                                CC_SD[track][1]    =  SetDecayTime[track];
                                CC_SD[track][2]    =  Loop_Length [track];
                                CC_SD[track][3]    =  Rythm;
                                CC_SD[track][4]    =  BPM;
            
                                MUTEX_SDCARD_TAKE;
                                        //Write to File
                                        sprintf(filepathS, "sq/%d-%d.sq", track, clip);             
                                        FILE_WriteOpen	(filepathS,                    1);               
                                        FILE_WriteBuffer((u8  *)file_typeBank,         4); //"SQ01" = 4 Positons    
                                        FILE_WriteBuffer((u8  *)Sequence[track],  sizeof(Sequence[track])); //u8 Sequence[8][512][8]    
                                        FILE_WriteBuffer((u8  *)CC_MSQ  [track],  sizeof(CC_MSQ  [track])); //Control-Change-Motion-Sequence
                                        FILE_WriteBuffer((u8  *)PB      [track],  sizeof(PB      [track])); 
                                        FILE_WriteBuffer((u8  *)CC_SD   [track],  sizeof(CC_SD   [track])); //Track Variables like Looplenght 
                                        FILE_WriteClose	(); 
                                MUTEX_SDCARD_GIVE;  //SD-Card is now free 4 access
                                Update_LCD_s = 1; //normal LCD-Labeling in back again in secunds
                                
                                SongNrLoad = SongNrStor; //transfair load nr 2 store nr.
                    break;
                                
            case 4: //S T O R E all Clips - FOR  P R O G R A M  C H A N G E
                    
                        for( t=0; t<8; t++)     { // store file once  by once
                            
                                //get  Variables from Array      
                                CC_SD[t][0]    =  clip_is_virgin;   
                                CC_SD[t][1]    =  SetDecayTime[t];
                                CC_SD[t][2]    =  Loop_Length [t];
                                CC_SD[t][3]    =  Rythm;
                                CC_SD[t][4]    =  BPM;
                                        
                                MUTEX_SDCARD_TAKE;
                                        //Write to File
                                        sprintf(filepathS, "sq/%d-%d.sq", t, clip);             
                                        FILE_WriteOpen	(filepathS,                1);               
                                        FILE_WriteBuffer((u8  *)file_typeBank,     4);  //"SQ01" = 4 Positons      
                                        FILE_WriteBuffer((u8  *)Sequence[t],    sizeof(Sequence[t])); //u8 Sequence[8][512][8]    
                                        FILE_WriteBuffer((u8  *)CC_MSQ  [t],    sizeof(CC_MSQ  [t])); //Control-Change-Motion-Sequence
                                        FILE_WriteBuffer((u8  *)PB      [t],    sizeof(PB      [t])); 
                                        FILE_WriteBuffer((u8  *)CC_SD   [t],    sizeof(CC_SD   [t])); //Track Variables like Looplenght 
                                        FILE_WriteClose	(); 
                                MUTEX_SDCARD_GIVE;  //SD-Card is now free 4 access
                                }
                                
                        SongNrLoad = SongNrStor; //transfair load nr 2 store nr.
                        
                        MUTEX_LCD_TAKE; 
                            MIOS32_LCD_DeviceSet(2); MIOS32_LCD_Clear(); MIOS32_LCD_CursorSet(0, 0); 
                            MIOS32_LCD_PrintFormattedString	("%s", "PROGRAM STORE - Finished");
                        MUTEX_LCD_GIVE;
                        Update_LCD_s = 1; //normal LCD-Labeling in back again in secunds
                                                       
                    break;
    

//  I N I T - S D - CARD //////////////////////////////////////////////////////////////////////////////////7//////   
  
            case 5: //SD-Card Initalize
                    MUTEX_SDCARD_TAKE;					//SD-Card is now only for the following LINES reserved:
                      statusSD = FILE_CheckSDCard();
                      switch(statusSD) {
                          case 2: MUTEX_LCD_TAKE;  MIOS32_LCD_DeviceSet(2); MIOS32_LCD_Clear(); MIOS32_LCD_CursorSet(0, 0); MIOS32_LCD_PrintFormattedString	("%s", "NO SD-Card"); MUTEX_LCD_GIVE;  break; 
                          case 3:
                             if	(!FILE_SDCardAvailable() ) {MUTEX_LCD_TAKE; MIOS32_LCD_DeviceSet(2); MIOS32_LCD_Clear(); MIOS32_LCD_CursorSet(0, 0); MIOS32_LCD_PrintFormattedString	("%s", "Insert-FAT-Formated-SD-Card"); MUTEX_LCD_GIVE; break;} 
                             if	(!FILE_VolumeAvailable() ) {MUTEX_LCD_TAKE; MIOS32_LCD_DeviceSet(2); MIOS32_LCD_Clear(); MIOS32_LCD_CursorSet(0, 0); MIOS32_LCD_PrintFormattedString	("%s", "Format SD-Format to FAT first!"); MUTEX_LCD_GIVE; break;} break;
                          case 1: // YES CARD!  >>> next: check Card-content
                             statusDir = FILE_DirExists("sq");																								//ask file.c: exist a folder "t/" on the CARD?
                             if(statusDir == 1){MUTEX_LCD_TAKE; MIOS32_LCD_DeviceSet(2); MIOS32_LCD_Clear(); MIOS32_LCD_CursorSet(0, 0); MIOS32_LCD_PrintFormattedString	("%s", "good SD-file structure");MenueUpdateFlag = 0;MUTEX_LCD_GIVE; break;} 
                             
                             if(statusDir == 0){MUTEX_LCD_TAKE; MIOS32_LCD_DeviceSet(2); MIOS32_LCD_Clear(); MIOS32_LCD_CursorSet(0, 0); MIOS32_LCD_PrintFormattedString	("%s", "create 4096 Files on SDC it takes 20min - really!-wait!!! ");MUTEX_LCD_GIVE;
                                                           
                                        //get  Variables from Array      
                                        CC_SD[track][0]    =  clip_is_virgin;   
                                        CC_SD[track][1]    =  SetDecayTime[track];
                                        CC_SD[track][2]    =  Loop_Length [track];
                                        CC_SD[track][3]    =  Rythm;
                                        CC_SD[track][4]    =  BPM;
                                
                                        FILE_MakeDir("sq");                           

                                        //Write to File
                                        sprintf(filepathS, "sq/%d-%d.sq", track, clip);             
                                        FILE_WriteOpen	(filepathS,                     1);               
                                        FILE_WriteBuffer((u8  *)file_typeBank,         4); //"SQ01" = 4 Positons      
                                        FILE_WriteBuffer((u8  *)Sequence[track],  sizeof(Sequence[track])); //u8 Sequence[8][512][8]    
                                        FILE_WriteBuffer((u8  *)CC_MSQ  [track],  sizeof(CC_MSQ  [track])); //Control-Change-Motion-Sequence
                                        FILE_WriteBuffer((u8  *)PB      [track],  sizeof(PB      [track])); 
                                        FILE_WriteBuffer((u8  *)CC_SD   [track],  sizeof(CC_SD   [track])); //Track Variables like Looplenght 
                                        FILE_WriteClose	(); 
                                                            
                                            //copy-prototype file to 512x8 clip files on SD-Card
                                            for(t=0; t<8; t++){ 
                                                
                                                u8 clipcount = 0; //declare and set the Bank Counter inital value to 0 
                                                for(clipcount=0; clipcount<512; clipcount++){  //countes 2 511 and do following commandos 511 times in a loop:
                                                    char copyfilepath[16];
                                                    sprintf(copyfilepath, "sq/%d-%d.sq", t, clipcount); //make a new filename depending on the counter value 1.sq, 2.sq, 3.sq...511.sq
                                                    FILE_Copy ((char *)"sq/0-0.sq", (char *)copyfilepath);} //copy the File 0.tm to all other 511 files...
                                            }
                                        
                                
                                                                    //SD-Card is now free 4 apbess
                        MUTEX_LCD_TAKE; MIOS32_LCD_DeviceSet(0); MIOS32_LCD_Clear(); MIOS32_LCD_CursorSet(0, 0); MIOS32_LCD_PrintFormattedString	("%s", "SD-CARD - INIT - FINISHED"); MUTEX_LCD_GIVE;MenueUpdateFlag = 0;} break;
                        }
                        MUTEX_SDCARD_GIVE;	
                        }
}


static void MELODY_BUFFER(s32 velocity, s32 note){  //Melody Input buffer    -    wich we write into the current step of the sequence (used in Function: APP_NOTEPROCESS)
    
    if(note > 0  &&  note < 127  &&  velocity >= 1){    // Only Note Numbers in Midi-Range 0-127 && Only Note On Messages       
                                
       //CLEAR NOTE BUFFER
         if(NoteCount==0){s32 i0b;for(i0b=0; i0b<8; ++i0b)RecNoteBuff[i0b] = 128;}//set to Note Nr 128, which we filter later out
         
       //FILL  NOTE BUFFER
         if(NoteCount == 0) {RecNoteBuff[0]  = note;}
         if(NoteCount == 1) {RecNoteBuff[1]  = note;}          
         if(NoteCount == 2) {RecNoteBuff[2]  = note;}
         if(NoteCount == 3) {RecNoteBuff[3]  = note;}
         if(NoteCount == 4) {RecNoteBuff[4]  = note;}
         if(NoteCount == 5) {RecNoteBuff[5]  = note;}
         if(NoteCount == 6) {RecNoteBuff[6]  = note;}
         if(NoteCount == 7) {RecNoteBuff[7]  = note;}                                                                                      
                               
       //NOTE COUNTER 
         NoteCount++; //(cheap Polyphony) counts from 0-7 >> this numbers route the notes in their buffers, when it reaches 8 it begins from 0 again = note overflow
     }
     
    //Count Reset
    if( (velocity >= 1 && NoteCount >= 8) || (velocity == 0) )   {NoteCount = 0;} //begin again from 0 when reaching max Count of 8 Fingers on Keyboard = max 8 Poly-Chord-Note
}//END of FUNCTION
 
/////////////////////
//Note Off Generation
static void TASK_Midi_Decay0(void *pvParameters){  //Send Note OFFs after a while
   portTickType xLastExecutionTime;
   xLastExecutionTime = xTaskGetTickCount();       // Initialise the xLastExecutionTime variable on task entry
  while( 1 ) {
    vTaskDelayUntil(&xLastExecutionTime, 1 / portTICK_RATE_MS);
    
   if   (MeloDecayTIMER[0][1] != 0) {
	     MeloDecayTIMER[0][1]--;
	  if(MeloDecayTIMER[0][1] == 0) {
		   MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 1, 0); //Port, Chn, Note, Velocity 
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 1, 0);}}  
   if   (MeloDecayTIMER[0][2] != 0) {
	     MeloDecayTIMER[0][2]--;
	  if(MeloDecayTIMER[0][2] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 2, 0); //Port, Chn, Note, Velocity 
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 2, 0);}}   
   if   (MeloDecayTIMER[0][3] != 0) {
	     MeloDecayTIMER[0][3]--;
	  if(MeloDecayTIMER[0][3] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 3, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 3, 0);}}
   if   (MeloDecayTIMER[0][4] != 0) {
	     MeloDecayTIMER[0][4]--;
	  if(MeloDecayTIMER[0][4] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 4, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 4, 0);}} 
   if   (MeloDecayTIMER[0][5] != 0) {
	     MeloDecayTIMER[0][5]--;
	  if(MeloDecayTIMER[0][5] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 5, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 5, 0);}} 
   if   (MeloDecayTIMER[0][6] != 0) {
	     MeloDecayTIMER[0][6]--;
	  if(MeloDecayTIMER[0][6] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 6, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 6, 0);}} 
   if   (MeloDecayTIMER[0][7] != 0) {
	     MeloDecayTIMER[0][7]--;
	  if(MeloDecayTIMER[0][7] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 7, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 7, 0);}}   
   if   (MeloDecayTIMER[0][8] != 0) {
	     MeloDecayTIMER[0][8]--;
	  if(MeloDecayTIMER[0][8] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 8, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 8, 0);}}   
   if   (MeloDecayTIMER[0][9] != 0) {
	     MeloDecayTIMER[0][9]--;
	  if(MeloDecayTIMER[0][9] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 9, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 9, 0);}}   
   if   (MeloDecayTIMER[0][10] != 0) {
	     MeloDecayTIMER[0][10]--;
	  if(MeloDecayTIMER[0][10] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 10, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 10, 0);}}   
   if   (MeloDecayTIMER[0][11] != 0) {
	     MeloDecayTIMER[0][11]--;
	  if(MeloDecayTIMER[0][11] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 11, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 11, 0);}}   
   if   (MeloDecayTIMER[0][12] != 0) {
	     MeloDecayTIMER[0][12]--;
	  if(MeloDecayTIMER[0][12] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 12, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 12, 0);}}   
   if   (MeloDecayTIMER[0][13] != 0) {
	     MeloDecayTIMER[0][13]--;
	  if(MeloDecayTIMER[0][13] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 13, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 13, 0);}}   
   if   (MeloDecayTIMER[0][14] != 0) {
	     MeloDecayTIMER[0][14]--;
	  if(MeloDecayTIMER[0][14] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 14, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 14, 0);}}   
   if   (MeloDecayTIMER[0][15] != 0) {
	     MeloDecayTIMER[0][15]--;
	  if(MeloDecayTIMER[0][15] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 15, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 15, 0);}}   
   if   (MeloDecayTIMER[0][16] != 0) {
	     MeloDecayTIMER[0][16]--;
	  if(MeloDecayTIMER[0][16] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 16, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 16, 0);}}   
   if   (MeloDecayTIMER[0][17] != 0) {
	     MeloDecayTIMER[0][17]--;
	  if(MeloDecayTIMER[0][17] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 17, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 17, 0);}}   
   if   (MeloDecayTIMER[0][18] != 0) {
	     MeloDecayTIMER[0][18]--;
	  if(MeloDecayTIMER[0][18] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 18, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 18, 0);}}   
   if   (MeloDecayTIMER[0][19] != 0) {
	     MeloDecayTIMER[0][19]--;
	  if(MeloDecayTIMER[0][19] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 19, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 19, 0);}}   
   if   (MeloDecayTIMER[0][20] != 0) {
	     MeloDecayTIMER[0][20]--;
	  if(MeloDecayTIMER[0][20] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 20, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 20, 0);}}   
   if   (MeloDecayTIMER[0][21] != 0) {
	     MeloDecayTIMER[0][21]--;
	  if(MeloDecayTIMER[0][21] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 21, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 21, 0);}}   
   if   (MeloDecayTIMER[0][22] != 0) {
	     MeloDecayTIMER[0][22]--;
	  if(MeloDecayTIMER[0][22] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 22, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 22, 0);}}   
   if   (MeloDecayTIMER[0][23] != 0) {
	     MeloDecayTIMER[0][23]--;
	  if(MeloDecayTIMER[0][23] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 23, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 23, 0);}}   
   if   (MeloDecayTIMER[0][24] != 0) {
	     MeloDecayTIMER[0][24]--;
	  if(MeloDecayTIMER[0][24] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 24, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 24, 0);}}   
   if   (MeloDecayTIMER[0][25] != 0) {
	     MeloDecayTIMER[0][25]--;
	  if(MeloDecayTIMER[0][25] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 25, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 25, 0);}}   
   if   (MeloDecayTIMER[0][26] != 0) {
	     MeloDecayTIMER[0][26]--;
	  if(MeloDecayTIMER[0][26] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 26, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 26, 0);}}   
   if   (MeloDecayTIMER[0][27] != 0) {
	     MeloDecayTIMER[0][27]--;
	  if(MeloDecayTIMER[0][27] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 27, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 27, 0);}}   
   if   (MeloDecayTIMER[0][28] != 0) {
	     MeloDecayTIMER[0][28]--;
	  if(MeloDecayTIMER[0][28] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 28, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 28, 0);}}   
   if   (MeloDecayTIMER[0][29] != 0) {
	     MeloDecayTIMER[0][29]--;
	  if(MeloDecayTIMER[0][29] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 29, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 29, 0);}}   
   if   (MeloDecayTIMER[0][30] != 0) {
	     MeloDecayTIMER[0][30]--;
	  if(MeloDecayTIMER[0][30] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 30, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 30, 0);}}   
   if   (MeloDecayTIMER[0][31] != 0) {
	     MeloDecayTIMER[0][31]--;
	  if(MeloDecayTIMER[0][31] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 31, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 31, 0);}}   
   if   (MeloDecayTIMER[0][32] != 0) {
	     MeloDecayTIMER[0][32]--;
	  if(MeloDecayTIMER[0][32] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 32, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 32, 0);}}   
   if   (MeloDecayTIMER[0][33] != 0) {
	     MeloDecayTIMER[0][33]--;
	  if(MeloDecayTIMER[0][33] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 33, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 33, 0);}}   
   if   (MeloDecayTIMER[0][34] != 0) {
	     MeloDecayTIMER[0][34]--;
	  if(MeloDecayTIMER[0][34] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 34, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 34, 0);}}   
   if   (MeloDecayTIMER[0][35] != 0) {
	     MeloDecayTIMER[0][35]--;
	  if(MeloDecayTIMER[0][35] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 35, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 35, 0);}}   
   if   (MeloDecayTIMER[0][36] != 0) {
	     MeloDecayTIMER[0][36]--;
	  if(MeloDecayTIMER[0][36] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 36, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 36, 0);}}   
   if   (MeloDecayTIMER[0][37] != 0) {
	     MeloDecayTIMER[0][37]--;
	  if(MeloDecayTIMER[0][37] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 37, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 37, 0);}}   
   if   (MeloDecayTIMER[0][38] != 0) {
	     MeloDecayTIMER[0][38]--;
	  if(MeloDecayTIMER[0][38] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 38, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 38, 0);}}         
   if   (MeloDecayTIMER[0][39] != 0) {
	     MeloDecayTIMER[0][39]--;
	  if(MeloDecayTIMER[0][39] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 39, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 39, 0);}}              
   if   (MeloDecayTIMER[0][40] != 0) {
	     MeloDecayTIMER[0][40]--;
	  if(MeloDecayTIMER[0][40] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 40, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 40, 0);}}              
   if   (MeloDecayTIMER[0][41] != 0) {
	     MeloDecayTIMER[0][41]--;
	  if(MeloDecayTIMER[0][41] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 41, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 41, 0);}}              
   if   (MeloDecayTIMER[0][42] != 0) {
	     MeloDecayTIMER[0][42]--;
	  if(MeloDecayTIMER[0][42] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 42, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 42, 0);}}             
   if   (MeloDecayTIMER[0][43] != 0) {
	     MeloDecayTIMER[0][43]--;
	  if(MeloDecayTIMER[0][43] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 43, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 43, 0);}}              
   if   (MeloDecayTIMER[0][44] != 0) {
	     MeloDecayTIMER[0][44]--;
	  if(MeloDecayTIMER[0][44] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 44, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 44, 0);}}              
   if   (MeloDecayTIMER[0][45] != 0) {
	     MeloDecayTIMER[0][45]--;
	  if(MeloDecayTIMER[0][45] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 45, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 45, 0);}}              
   if   (MeloDecayTIMER[0][46] != 0) {
	     MeloDecayTIMER[0][46]--;
	  if(MeloDecayTIMER[0][46] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 46, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 46, 0);}}              
   if   (MeloDecayTIMER[0][47] != 0) {
	     MeloDecayTIMER[0][47]--;
	  if(MeloDecayTIMER[0][47] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 47, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 47, 0);}}              
   if   (MeloDecayTIMER[0][48] != 0) {
	     MeloDecayTIMER[0][48]--;
	  if(MeloDecayTIMER[0][48] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 48, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 48, 0);}}              
   if   (MeloDecayTIMER[0][49] != 0) {
	     MeloDecayTIMER[0][49]--;
	  if(MeloDecayTIMER[0][49] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 49, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 49, 0);}}              
   if   (MeloDecayTIMER[0][50] != 0) {
	     MeloDecayTIMER[0][50]--;
	  if(MeloDecayTIMER[0][50] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 50, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 50, 0);}}              
   if   (MeloDecayTIMER[0][51] != 0) {
	     MeloDecayTIMER[0][51]--;
	  if(MeloDecayTIMER[0][51] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 51, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 51, 0);}}              
   if   (MeloDecayTIMER[0][52] != 0) {
	     MeloDecayTIMER[0][52]--;
	  if(MeloDecayTIMER[0][52] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 52, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 52, 0);}}    
   if   (MeloDecayTIMER[0][53] != 0) {
	     MeloDecayTIMER[0][53]--;
	  if(MeloDecayTIMER[0][53] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 53, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 53, 0);}}              
   if   (MeloDecayTIMER[0][54] != 0) {
	     MeloDecayTIMER[0][54]--;
	  if(MeloDecayTIMER[0][54] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 54, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 54, 0);}}              
   if   (MeloDecayTIMER[0][55] != 0) {
	     MeloDecayTIMER[0][55]--;
	  if(MeloDecayTIMER[0][55] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 55, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 55, 0);}}              
   if   (MeloDecayTIMER[0][56] != 0) {
	     MeloDecayTIMER[0][56]--;
	  if(MeloDecayTIMER[0][56] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 56, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 56, 0);}}              
   if   (MeloDecayTIMER[0][57] != 0) {
	     MeloDecayTIMER[0][57]--;
	  if(MeloDecayTIMER[0][57] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 57, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 57, 0);}}              
   if   (MeloDecayTIMER[0][58] != 0) {
	     MeloDecayTIMER[0][58]--;
	  if(MeloDecayTIMER[0][58] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 58, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 58, 0);}}              
   if   (MeloDecayTIMER[0][59] != 0) {
	     MeloDecayTIMER[0][59]--;
	  if(MeloDecayTIMER[0][59] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 59, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 59, 0);}}              
   if   (MeloDecayTIMER[0][60] != 0) {
	     MeloDecayTIMER[0][60]--;
	  if(MeloDecayTIMER[0][60] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 60, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 60, 0);}}              
   if   (MeloDecayTIMER[0][61] != 0) {
	     MeloDecayTIMER[0][61]--;
	  if(MeloDecayTIMER[0][61] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 61, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 61, 0);}}              
   if   (MeloDecayTIMER[0][62] != 0) {
	     MeloDecayTIMER[0][62]--;
	  if(MeloDecayTIMER[0][62] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 62, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 62, 0);}}              
   if   (MeloDecayTIMER[0][63] != 0) {
	     MeloDecayTIMER[0][63]--;
	  if(MeloDecayTIMER[0][63] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 63, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 63, 0);}}              
   if   (MeloDecayTIMER[0][64] != 0) {
	     MeloDecayTIMER[0][64]--;
	  if(MeloDecayTIMER[0][64] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 64, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 64, 0);}}              
   if   (MeloDecayTIMER[0][65] != 0) {
	     MeloDecayTIMER[0][65]--;
	  if(MeloDecayTIMER[0][65] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 65, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 65, 0);}}              
   if   (MeloDecayTIMER[0][66] != 0) {
	     MeloDecayTIMER[0][66]--;
	  if(MeloDecayTIMER[0][66] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 66, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 66, 0);}}              
   if   (MeloDecayTIMER[0][67] != 0) {
	     MeloDecayTIMER[0][67]--;
	  if(MeloDecayTIMER[0][67] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 67, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 67, 0);}}              
   if   (MeloDecayTIMER[0][68] != 0) {
	     MeloDecayTIMER[0][68]--;
	  if(MeloDecayTIMER[0][68] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 68, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 68, 0);}}              
   if   (MeloDecayTIMER[0][69] != 0) {
	     MeloDecayTIMER[0][69]--;
	  if(MeloDecayTIMER[0][69] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 69, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 69, 0);}}              
   if   (MeloDecayTIMER[0][70] != 0) {
	     MeloDecayTIMER[0][70]--;
	  if(MeloDecayTIMER[0][70] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 70, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 70, 0);}}              
   if   (MeloDecayTIMER[0][71] != 0) {
	     MeloDecayTIMER[0][71]--;
	  if(MeloDecayTIMER[0][71] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 71, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 71, 0);}}              
   if   (MeloDecayTIMER[0][72] != 0) {
	     MeloDecayTIMER[0][72]--;
	  if(MeloDecayTIMER[0][72] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 72, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 72, 0);}}              
   if   (MeloDecayTIMER[0][73] != 0) {
	     MeloDecayTIMER[0][73]--;
	  if(MeloDecayTIMER[0][73] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 73, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 73, 0);}}              
   if   (MeloDecayTIMER[0][74] != 0) {
	     MeloDecayTIMER[0][74]--;
	  if(MeloDecayTIMER[0][74] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 74, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 74, 0);}}              
   if   (MeloDecayTIMER[0][75] != 0) {
	     MeloDecayTIMER[0][75]--;
	  if(MeloDecayTIMER[0][75] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 75, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 75, 0);}}              
   if   (MeloDecayTIMER[0][76] != 0) {
	     MeloDecayTIMER[0][76]--;
	  if(MeloDecayTIMER[0][76] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 76, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 76, 0);}}              
   if   (MeloDecayTIMER[0][77] != 0) {
	     MeloDecayTIMER[0][77]--;
	  if(MeloDecayTIMER[0][77] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 77, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 77, 0);}}              
   if   (MeloDecayTIMER[0][78] != 0) {
	     MeloDecayTIMER[0][78]--;
	  if(MeloDecayTIMER[0][78] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 78, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 78, 0);}}              
   if   (MeloDecayTIMER[0][79] != 0) {
	     MeloDecayTIMER[0][79]--;
	  if(MeloDecayTIMER[0][79] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 79, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 79, 0);}}              
   if   (MeloDecayTIMER[0][80] != 0) {
	     MeloDecayTIMER[0][80]--;
	  if(MeloDecayTIMER[0][80] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 80, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 80, 0);}}              
   if   (MeloDecayTIMER[0][81] != 0) {
	     MeloDecayTIMER[0][81]--;
	  if(MeloDecayTIMER[0][81] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 81, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 81, 0);}}              
   if   (MeloDecayTIMER[0][82] != 0) {
	     MeloDecayTIMER[0][82]--;
	  if(MeloDecayTIMER[0][82] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 82, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 82, 0);}}              
   if   (MeloDecayTIMER[0][83] != 0) {
	     MeloDecayTIMER[0][83]--;
	  if(MeloDecayTIMER[0][83] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 83, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 83, 0);}}              
   if   (MeloDecayTIMER[0][84] != 0) {
	     MeloDecayTIMER[0][84]--;
	  if(MeloDecayTIMER[0][84] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 84, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 84, 0);}}              
   if   (MeloDecayTIMER[0][85] != 0) {
	     MeloDecayTIMER[0][85]--;
	  if(MeloDecayTIMER[0][85] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 85, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 85, 0);}}              
   if   (MeloDecayTIMER[0][86] != 0) {
	     MeloDecayTIMER[0][86]--;
	  if(MeloDecayTIMER[0][86] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 86, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 86, 0);}}              
   if   (MeloDecayTIMER[0][87] != 0) {
	     MeloDecayTIMER[0][87]--;
	  if(MeloDecayTIMER[0][87] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 87, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 87, 0);}}              
   if   (MeloDecayTIMER[0][88] != 0) {
	     MeloDecayTIMER[0][88]--;
	  if(MeloDecayTIMER[0][88] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 88, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 88, 0);}}              
   if   (MeloDecayTIMER[0][89] != 0) {
	     MeloDecayTIMER[0][89]--;
	  if(MeloDecayTIMER[0][89] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 89, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 89, 0);}}                    
   if   (MeloDecayTIMER[0][90] != 0) {
	     MeloDecayTIMER[0][90]--;
	  if(MeloDecayTIMER[0][90] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 90, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 90, 0);}}              
   if   (MeloDecayTIMER[0][91] != 0) {
	     MeloDecayTIMER[0][91]--;
	  if(MeloDecayTIMER[0][91] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 91, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 91, 0);}}              
   if   (MeloDecayTIMER[0][92] != 0) {
	     MeloDecayTIMER[0][92]--;
	  if(MeloDecayTIMER[0][92] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 92, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 92, 0);}}              
   if   (MeloDecayTIMER[0][93] != 0) {
	     MeloDecayTIMER[0][93]--;
	  if(MeloDecayTIMER[0][93] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 93, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 93, 0);}}   
   if   (MeloDecayTIMER[0][94] != 0) {
	     MeloDecayTIMER[0][94]--;
	  if(MeloDecayTIMER[0][94] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 94, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 94, 0);}}               
   if   (MeloDecayTIMER[0][95] != 0) {
	     MeloDecayTIMER[0][95]--;
	  if(MeloDecayTIMER[0][95] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 95, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 95, 0);}}              
   if   (MeloDecayTIMER[0][96] != 0) {
	     MeloDecayTIMER[0][96]--;
	  if(MeloDecayTIMER[0][96] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 96, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 96, 0);}}              
   if   (MeloDecayTIMER[0][97] != 0) {
	     MeloDecayTIMER[0][97]--;
	  if(MeloDecayTIMER[0][97] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 97, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 97, 0);}}              
   if   (MeloDecayTIMER[0][98] != 0) {
	     MeloDecayTIMER[0][98]--;
	  if(MeloDecayTIMER[0][98] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 98, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 98, 0);}}              
   if   (MeloDecayTIMER[0][99] != 0) {
	     MeloDecayTIMER[0][99]--;
	  if(MeloDecayTIMER[0][99] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 99, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 99, 0);}}              
   if   (MeloDecayTIMER[0][100] != 0) {
	     MeloDecayTIMER[0][100]--;
	  if(MeloDecayTIMER[0][100] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 100, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 100, 0);}}              
   if   (MeloDecayTIMER[0][101] != 0) {
	     MeloDecayTIMER[0][101]--;
	  if(MeloDecayTIMER[0][101] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 101, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 101, 0);}}              
   if   (MeloDecayTIMER[0][102] != 0) {
	     MeloDecayTIMER[0][102]--;
	  if(MeloDecayTIMER[0][102] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 102, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 102, 0);}}              
   if   (MeloDecayTIMER[0][103] != 0) {
	     MeloDecayTIMER[0][103]--;
	  if(MeloDecayTIMER[0][103] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 103, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 103, 0);}}              
   if   (MeloDecayTIMER[0][104] != 0) {
	     MeloDecayTIMER[0][104]--;
	  if(MeloDecayTIMER[0][104] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 104, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 104, 0);}}              
   if   (MeloDecayTIMER[0][105] != 0) {
	     MeloDecayTIMER[0][105]--;
	  if(MeloDecayTIMER[0][105] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 105, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 105, 0);}}              
   if   (MeloDecayTIMER[0][106] != 0) {
	     MeloDecayTIMER[0][106]--;
	  if(MeloDecayTIMER[0][106] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 106, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 106, 0);}}              
   if   (MeloDecayTIMER[0][107] != 0) {
	     MeloDecayTIMER[0][107]--;
	  if(MeloDecayTIMER[0][107] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 107, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 107, 0);}}              
   if   (MeloDecayTIMER[0][108] != 0) {
	     MeloDecayTIMER[0][108]--;
	  if(MeloDecayTIMER[0][108] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 108, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 108, 0);}}              
   if   (MeloDecayTIMER[0][109] != 0) {
	     MeloDecayTIMER[0][109]--;
	  if(MeloDecayTIMER[0][109] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 109, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 109, 0);}}              
   if   (MeloDecayTIMER[0][110] != 0) {
	     MeloDecayTIMER[0][110]--;
	  if(MeloDecayTIMER[0][110] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 110, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 110, 0);}}              
   if   (MeloDecayTIMER[0][111] != 0) {
	     MeloDecayTIMER[0][111]--;
	  if(MeloDecayTIMER[0][111] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 111, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 111, 0);}}              
   if   (MeloDecayTIMER[0][112] != 0) {
	     MeloDecayTIMER[0][112]--;
	  if(MeloDecayTIMER[0][112] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 112, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 112, 0);}}              
   if   (MeloDecayTIMER[0][113] != 0) {
	     MeloDecayTIMER[0][113]--;
	  if(MeloDecayTIMER[0][113] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 113, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 113, 0);}}              
   if   (MeloDecayTIMER[0][114] != 0) {
	     MeloDecayTIMER[0][114]--;
	  if(MeloDecayTIMER[0][114] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 114, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 114, 0);}}              
   if   (MeloDecayTIMER[0][115] != 0) {
	     MeloDecayTIMER[0][115]--;
	  if(MeloDecayTIMER[0][115] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 115, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 115, 0);}}              
   if   (MeloDecayTIMER[0][116] != 0) {
	     MeloDecayTIMER[0][116]--;
	  if(MeloDecayTIMER[0][116] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 116, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 116, 0);}}              
   if   (MeloDecayTIMER[0][117] != 0) {
	     MeloDecayTIMER[0][117]--;
	  if(MeloDecayTIMER[0][117] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 117, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 117, 0);}}              
   if   (MeloDecayTIMER[0][118] != 0) {
	     MeloDecayTIMER[0][118]--;
	  if(MeloDecayTIMER[0][118] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 118, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 118, 0);}}              
   if   (MeloDecayTIMER[0][119] != 0) {
	     MeloDecayTIMER[0][119]--;
	  if(MeloDecayTIMER[0][119] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 119, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 119, 0);}}              
   if   (MeloDecayTIMER[0][120] != 0) {
	     MeloDecayTIMER[0][120]--;
	  if(MeloDecayTIMER[0][120] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 120, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 120, 0);}}              
   if   (MeloDecayTIMER[0][121] != 0) {
	     MeloDecayTIMER[0][121]--;
	  if(MeloDecayTIMER[0][121] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 121, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 121, 0);}}              
   if   (MeloDecayTIMER[0][122] != 0) {
	     MeloDecayTIMER[0][122]--;
	  if(MeloDecayTIMER[0][122] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 122, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 122, 0);}}              
   if   (MeloDecayTIMER[0][123] != 0) {
	     MeloDecayTIMER[0][123]--;
	  if(MeloDecayTIMER[0][23] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 123, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 123, 0);}}              
   if   (MeloDecayTIMER[0][124] != 0) {
	     MeloDecayTIMER[0][124]--;
	  if(MeloDecayTIMER[0][124] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 124, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 124, 0);}}              
   if   (MeloDecayTIMER[0][125] != 0) {
	     MeloDecayTIMER[0][125]--;
	  if(MeloDecayTIMER[0][125] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 125, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 125, 0);}}              
   if   (MeloDecayTIMER[0][126] != 0) {
	     MeloDecayTIMER[0][126]--;
	  if(MeloDecayTIMER[0][126] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 126, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 126, 0);}}              
   if   (MeloDecayTIMER[0][127] != 0) {
	     MeloDecayTIMER[0][127]--;
	  if(MeloDecayTIMER[0][127] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, 0, 127, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, 0, 127, 0);}}                                       
}//End While
}//End TICK 0 >>> 1ms Task...

static void TASK_Midi_Decay1(void *pvParameters){  //Send Note OFFs after a while
   portTickType xLastExecutionTime;
   xLastExecutionTime = xTaskGetTickCount();       // Initialise the xLastExecutionTime variable on task entry

  while( 1 ) {
    vTaskDelayUntil(&xLastExecutionTime, 1 / portTICK_RATE_MS);
    
   if   (MeloDecayTIMER[1][1] != 0) {
	     MeloDecayTIMER[1][1]--;
	  if(MeloDecayTIMER[1][1] == 0) {
		   MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[1], 1, 0); //Port, Chn, Note, Velocity 
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[1], 1, 0);}}  
   if   (MeloDecayTIMER[1][2] != 0) {
	     MeloDecayTIMER[1][2]--;
	  if(MeloDecayTIMER[1][2] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[1], 2, 0); //Port, Chn, Note, Velocity 
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[1], 2, 0);}}   
   if   (MeloDecayTIMER[1][3] != 0) {
	     MeloDecayTIMER[1][3]--;
	  if(MeloDecayTIMER[1][3] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[1], 3, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[1], 3, 0);}}
   if   (MeloDecayTIMER[1][4] != 0) {
	     MeloDecayTIMER[1][4]--;
	  if(MeloDecayTIMER[1][4] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[1], 4, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[1], 4, 0);}} 
   if   (MeloDecayTIMER[1][5] != 0) {
	     MeloDecayTIMER[1][5]--;
	  if(MeloDecayTIMER[1][5] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[1], 5, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[1], 5, 0);}} 
   if   (MeloDecayTIMER[1][6] != 0) {
	     MeloDecayTIMER[1][6]--;
	  if(MeloDecayTIMER[1][6] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[1], 6, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[1], 6, 0);}} 
   if   (MeloDecayTIMER[1][7] != 0) {
	     MeloDecayTIMER[1][7]--;
	  if(MeloDecayTIMER[1][7] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[1], 7, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[1], 7, 0);}}   
   if   (MeloDecayTIMER[1][8] != 0) {
	     MeloDecayTIMER[1][8]--;
	  if(MeloDecayTIMER[1][8] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[1], 8, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[1], 8, 0);}}   
   if   (MeloDecayTIMER[1][9] != 0) {
	     MeloDecayTIMER[1][9]--;
	  if(MeloDecayTIMER[1][9] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[1], 9, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[1], 9, 0);}}   
   if   (MeloDecayTIMER[1][10] != 0) {
	     MeloDecayTIMER[1][10]--;
	  if(MeloDecayTIMER[1][10] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[1], 10, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[1], 10, 0);}}   
   if   (MeloDecayTIMER[1][11] != 0) {
	     MeloDecayTIMER[1][11]--;
	  if(MeloDecayTIMER[1][11] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[1], 11, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[1], 11, 0);}}   
   if   (MeloDecayTIMER[1][12] != 0) {
	     MeloDecayTIMER[1][12]--;
	  if(MeloDecayTIMER[1][12] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[1], 12, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[1], 12, 0);}}   
   if   (MeloDecayTIMER[1][13] != 0) {
	     MeloDecayTIMER[1][13]--;
	  if(MeloDecayTIMER[1][13] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[1], 13, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[1], 13, 0);}}   
   if   (MeloDecayTIMER[1][14] != 0) {
	     MeloDecayTIMER[1][14]--;
	  if(MeloDecayTIMER[1][14] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[1], 14, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[1], 14, 0);}}   
   if   (MeloDecayTIMER[1][15] != 0) {
	     MeloDecayTIMER[1][15]--;
	  if(MeloDecayTIMER[1][15] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[1], 15, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[1], 15, 0);}}   
   if   (MeloDecayTIMER[1][16] != 0) {
	     MeloDecayTIMER[1][16]--;
	  if(MeloDecayTIMER[1][16] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[1], 16, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[1], 16, 0);}}   
   if   (MeloDecayTIMER[1][17] != 0) {
	     MeloDecayTIMER[1][17]--;
	  if(MeloDecayTIMER[1][17] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[1], 17, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[1], 17, 0);}}   
   if   (MeloDecayTIMER[1][18] != 0) {
	     MeloDecayTIMER[1][18]--;
	  if(MeloDecayTIMER[1][18] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[1], 18, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[1], 18, 0);}}   
   if   (MeloDecayTIMER[1][19] != 0) {
	     MeloDecayTIMER[1][19]--;
	  if(MeloDecayTIMER[1][19] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[1], 19, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[1], 19, 0);}}   
   if   (MeloDecayTIMER[1][20] != 0) {
	     MeloDecayTIMER[1][20]--;
	  if(MeloDecayTIMER[1][20] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[1], 20, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[1], 20, 0);}}   
   if   (MeloDecayTIMER[1][21] != 0) {
	     MeloDecayTIMER[1][21]--;
	  if(MeloDecayTIMER[1][21] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[1], 21, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[1], 21, 0);}}   
   if   (MeloDecayTIMER[1][22] != 0) {
	     MeloDecayTIMER[1][22]--;
	  if(MeloDecayTIMER[1][22] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[1], 22, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[1], 22, 0);}}   
   if   (MeloDecayTIMER[1][23] != 0) {
	     MeloDecayTIMER[1][23]--;
	  if(MeloDecayTIMER[1][23] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[1], 23, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[1], 23, 0);}}   
   if   (MeloDecayTIMER[1][24] != 0) {
	     MeloDecayTIMER[1][24]--;
	  if(MeloDecayTIMER[1][24] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[1], 24, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[1], 24, 0);}}   
   if   (MeloDecayTIMER[1][25] != 0) {
	     MeloDecayTIMER[1][25]--;
	  if(MeloDecayTIMER[1][25] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[1], 25, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[1], 25, 0);}}   
   if   (MeloDecayTIMER[1][26] != 0) {
	     MeloDecayTIMER[1][26]--;
	  if(MeloDecayTIMER[1][26] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[1], 26, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[1], 26, 0);}}   
   if   (MeloDecayTIMER[1][27] != 0) {
	     MeloDecayTIMER[1][27]--;
	  if(MeloDecayTIMER[1][27] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[1], 27, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[1], 27, 0);}}   
   if   (MeloDecayTIMER[1][28] != 0) {
	     MeloDecayTIMER[1][28]--;
	  if(MeloDecayTIMER[1][28] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[1], 28, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[1], 28, 0);}}   
   if   (MeloDecayTIMER[1][29] != 0) {
	     MeloDecayTIMER[1][29]--;
	  if(MeloDecayTIMER[1][29] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[1], 29, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[1], 29, 0);}}   
   if   (MeloDecayTIMER[1][30] != 0) {
	     MeloDecayTIMER[1][30]--;
	  if(MeloDecayTIMER[1][30] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[1], 30, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[1], 30, 0);}}   
   if   (MeloDecayTIMER[1][31] != 0) {
	     MeloDecayTIMER[1][31]--;
	  if(MeloDecayTIMER[1][31] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[1], 31, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[1], 31, 0);}}   
   if   (MeloDecayTIMER[1][32] != 0) {
	     MeloDecayTIMER[1][32]--;
	  if(MeloDecayTIMER[1][32] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[1], 32, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[1], 32, 0);}}   
   if   (MeloDecayTIMER[1][33] != 0) {
	     MeloDecayTIMER[1][33]--;
	  if(MeloDecayTIMER[1][33] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[1], 33, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[1], 33, 0);}}   
   if   (MeloDecayTIMER[1][34] != 0) {
	     MeloDecayTIMER[1][34]--;
	  if(MeloDecayTIMER[1][34] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[1], 34, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[1], 34, 0);}}   
   if   (MeloDecayTIMER[1][35] != 0) {
	     MeloDecayTIMER[1][35]--;
	  if(MeloDecayTIMER[1][35] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[1], 35, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[1], 35, 0);}}   
   if   (MeloDecayTIMER[1][36] != 0) {
	     MeloDecayTIMER[1][36]--;
	  if(MeloDecayTIMER[1][36] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[1], 36, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[1], 36, 0);}}   
   if   (MeloDecayTIMER[1][37] != 0) {
	     MeloDecayTIMER[1][37]--;
	  if(MeloDecayTIMER[1][37] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[1], 37, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[1], 37, 0);}}   
   if   (MeloDecayTIMER[1][38] != 0) {
	     MeloDecayTIMER[1][38]--;
	  if(MeloDecayTIMER[1][38] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[1], 38, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[1], 38, 0);}}         
   if   (MeloDecayTIMER[1][39] != 0) {
	     MeloDecayTIMER[1][39]--;
	  if(MeloDecayTIMER[1][39] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[1], 39, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[1], 39, 0);}}              
   if   (MeloDecayTIMER[1][40] != 0) {
	     MeloDecayTIMER[1][40]--;
	  if(MeloDecayTIMER[1][40] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[1], 40, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[1], 40, 0);}}              
   if   (MeloDecayTIMER[1][41] != 0) {
	     MeloDecayTIMER[1][41]--;
	  if(MeloDecayTIMER[1][41] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[1], 41, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[1], 41, 0);}}              
   if   (MeloDecayTIMER[1][42] != 0) {
	     MeloDecayTIMER[1][42]--;
	  if(MeloDecayTIMER[1][42] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[1], 42, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[1], 42, 0);}}             
   if   (MeloDecayTIMER[1][43] != 0) {
	     MeloDecayTIMER[1][43]--;
	  if(MeloDecayTIMER[1][43] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[1], 43, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[1], 43, 0);}}              
   if   (MeloDecayTIMER[1][44] != 0) {
	     MeloDecayTIMER[1][44]--;
	  if(MeloDecayTIMER[1][44] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[1], 44, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[1], 44, 0);}}              
   if   (MeloDecayTIMER[1][45] != 0) {
	     MeloDecayTIMER[1][45]--;
	  if(MeloDecayTIMER[1][45] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[1], 45, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[1], 45, 0);}}              
   if   (MeloDecayTIMER[1][46] != 0) {
	     MeloDecayTIMER[1][46]--;
	  if(MeloDecayTIMER[1][46] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[1], 46, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[1], 46, 0);}}              
   if   (MeloDecayTIMER[1][47] != 0) {
	     MeloDecayTIMER[1][47]--;
	  if(MeloDecayTIMER[1][47] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[1], 47, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[1], 47, 0);}}              
   if   (MeloDecayTIMER[1][48] != 0) {
	     MeloDecayTIMER[1][48]--;
	  if(MeloDecayTIMER[1][48] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[1], 48, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[1], 48, 0);}}              
   if   (MeloDecayTIMER[1][49] != 0) {
	     MeloDecayTIMER[1][49]--;
	  if(MeloDecayTIMER[1][49] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[1], 49, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[1], 49, 0);}}              
   if   (MeloDecayTIMER[1][50] != 0) {
	     MeloDecayTIMER[1][50]--;
	  if(MeloDecayTIMER[1][50] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[1], 50, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[1], 50, 0);}}              
   if   (MeloDecayTIMER[1][51] != 0) {
	     MeloDecayTIMER[1][51]--;
	  if(MeloDecayTIMER[1][51] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[1], 51, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[1], 51, 0);}}              
   if   (MeloDecayTIMER[1][52] != 0) {
	     MeloDecayTIMER[1][52]--;
	  if(MeloDecayTIMER[1][52] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[1], 52, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[1], 52, 0);}}    
   if   (MeloDecayTIMER[1][53] != 0) {
	     MeloDecayTIMER[1][53]--;
	  if(MeloDecayTIMER[1][53] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[1], 53, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[1], 53, 0);}}              
   if   (MeloDecayTIMER[1][54] != 0) {
	     MeloDecayTIMER[1][54]--;
	  if(MeloDecayTIMER[1][54] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[1], 54, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[1], 54, 0);}}              
   if   (MeloDecayTIMER[1][55] != 0) {
	     MeloDecayTIMER[1][55]--;
	  if(MeloDecayTIMER[1][55] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[1], 55, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[1], 55, 0);}}              
   if   (MeloDecayTIMER[1][56] != 0) {
	     MeloDecayTIMER[1][56]--;
	  if(MeloDecayTIMER[1][56] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[1], 56, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[1], 56, 0);}}              
   if   (MeloDecayTIMER[1][57] != 0) {
	     MeloDecayTIMER[1][57]--;
	  if(MeloDecayTIMER[1][57] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[1], 57, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[1], 57, 0);}}              
   if   (MeloDecayTIMER[1][58] != 0) {
	     MeloDecayTIMER[1][58]--;
	  if(MeloDecayTIMER[1][58] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[1], 58, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[1], 58, 0);}}              
   if   (MeloDecayTIMER[1][59] != 0) {
	     MeloDecayTIMER[1][59]--;
	  if(MeloDecayTIMER[1][59] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[1], 59, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[1], 59, 0);}}              
   if   (MeloDecayTIMER[1][60] != 0) {
	     MeloDecayTIMER[1][60]--;
	  if(MeloDecayTIMER[1][60] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[1], 60, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[1], 60, 0);}}              
   if   (MeloDecayTIMER[1][61] != 0) {
	     MeloDecayTIMER[1][61]--;
	  if(MeloDecayTIMER[1][61] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[1], 61, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[1], 61, 0);}}              
   if   (MeloDecayTIMER[1][62] != 0) {
	     MeloDecayTIMER[1][62]--;
	  if(MeloDecayTIMER[1][62] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[1], 62, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[1], 62, 0);}}              
   if   (MeloDecayTIMER[1][63] != 0) {
	     MeloDecayTIMER[1][63]--;
	  if(MeloDecayTIMER[1][63] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[1], 63, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[1], 63, 0);}}              
   if   (MeloDecayTIMER[1][64] != 0) {
	     MeloDecayTIMER[1][64]--;
	  if(MeloDecayTIMER[1][64] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[1], 64, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[1], 64, 0);}}              
   if   (MeloDecayTIMER[1][65] != 0) {
	     MeloDecayTIMER[1][65]--;
	  if(MeloDecayTIMER[1][65] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[1], 65, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[1], 65, 0);}}              
   if   (MeloDecayTIMER[1][66] != 0) {
	     MeloDecayTIMER[1][66]--;
	  if(MeloDecayTIMER[1][66] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[1], 66, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[1], 66, 0);}}              
   if   (MeloDecayTIMER[1][67] != 0) {
	     MeloDecayTIMER[1][67]--;
	  if(MeloDecayTIMER[1][67] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[1], 67, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[1], 67, 0);}}              
   if   (MeloDecayTIMER[1][68] != 0) {
	     MeloDecayTIMER[1][68]--;
	  if(MeloDecayTIMER[1][68] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[1], 68, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[1], 68, 0);}}              
   if   (MeloDecayTIMER[1][69] != 0) {
	     MeloDecayTIMER[1][69]--;
	  if(MeloDecayTIMER[1][69] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[1], 69, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[1], 69, 0);}}              
   if   (MeloDecayTIMER[1][70] != 0) {
	     MeloDecayTIMER[1][70]--;
	  if(MeloDecayTIMER[1][70] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[1], 70, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[1], 70, 0);}}              
   if   (MeloDecayTIMER[1][71] != 0) {
	     MeloDecayTIMER[1][71]--;
	  if(MeloDecayTIMER[1][71] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[1], 71, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[1], 71, 0);}}              
   if   (MeloDecayTIMER[1][72] != 0) {
	     MeloDecayTIMER[1][72]--;
	  if(MeloDecayTIMER[1][72] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[1], 72, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[1], 72, 0);}}              
   if   (MeloDecayTIMER[1][73] != 0) {
	     MeloDecayTIMER[1][73]--;
	  if(MeloDecayTIMER[1][73] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[1], 73, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[1], 73, 0);}}              
   if   (MeloDecayTIMER[1][74] != 0) {
	     MeloDecayTIMER[1][74]--;
	  if(MeloDecayTIMER[1][74] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[1], 74, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[1], 74, 0);}}              
   if   (MeloDecayTIMER[1][75] != 0) {
	     MeloDecayTIMER[1][75]--;
	  if(MeloDecayTIMER[1][75] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[1], 75, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[1], 75, 0);}}              
   if   (MeloDecayTIMER[1][76] != 0) {
	     MeloDecayTIMER[1][76]--;
	  if(MeloDecayTIMER[1][76] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[1], 76, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[1], 76, 0);}}              
   if   (MeloDecayTIMER[1][77] != 0) {
	     MeloDecayTIMER[1][77]--;
	  if(MeloDecayTIMER[1][77] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[1], 77, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[1], 77, 0);}}              
   if   (MeloDecayTIMER[1][78] != 0) {
	     MeloDecayTIMER[1][78]--;
	  if(MeloDecayTIMER[1][78] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[1], 78, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[1], 78, 0);}}              
   if   (MeloDecayTIMER[1][79] != 0) {
	     MeloDecayTIMER[1][79]--;
	  if(MeloDecayTIMER[1][79] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[1], 79, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[1], 79, 0);}}              
   if   (MeloDecayTIMER[1][80] != 0) {
	     MeloDecayTIMER[1][80]--;
	  if(MeloDecayTIMER[1][80] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[1], 80, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[1], 80, 0);}}              
   if   (MeloDecayTIMER[1][81] != 0) {
	     MeloDecayTIMER[1][81]--;
	  if(MeloDecayTIMER[1][81] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[1], 81, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[1], 81, 0);}}              
   if   (MeloDecayTIMER[1][82] != 0) {
	     MeloDecayTIMER[1][82]--;
	  if(MeloDecayTIMER[1][82] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[1], 82, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[1], 82, 0);}}              
   if   (MeloDecayTIMER[1][83] != 0) {
	     MeloDecayTIMER[1][83]--;
	  if(MeloDecayTIMER[1][83] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[1], 83, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[1], 83, 0);}}              
   if   (MeloDecayTIMER[1][84] != 0) {
	     MeloDecayTIMER[1][84]--;
	  if(MeloDecayTIMER[1][84] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[1], 84, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[1], 84, 0);}}              
   if   (MeloDecayTIMER[1][85] != 0) {
	     MeloDecayTIMER[1][85]--;
	  if(MeloDecayTIMER[1][85] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[1], 85, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[1], 85, 0);}}              
   if   (MeloDecayTIMER[1][86] != 0) {
	     MeloDecayTIMER[1][86]--;
	  if(MeloDecayTIMER[1][86] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[1], 86, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[1], 86, 0);}}              
   if   (MeloDecayTIMER[1][87] != 0) {
	     MeloDecayTIMER[1][87]--;
	  if(MeloDecayTIMER[1][87] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[1], 87, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[1], 87, 0);}}              
   if   (MeloDecayTIMER[1][88] != 0) {
	     MeloDecayTIMER[1][88]--;
	  if(MeloDecayTIMER[1][88] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[1], 88, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[1], 88, 0);}}              
   if   (MeloDecayTIMER[1][89] != 0) {
	     MeloDecayTIMER[1][89]--;
	  if(MeloDecayTIMER[1][89] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[1], 89, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[1], 89, 0);}}                    
   if   (MeloDecayTIMER[1][90] != 0) {
	     MeloDecayTIMER[1][90]--;
	  if(MeloDecayTIMER[1][90] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[1], 90, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[1], 90, 0);}}              
   if   (MeloDecayTIMER[1][91] != 0) {
	     MeloDecayTIMER[1][91]--;
	  if(MeloDecayTIMER[1][91] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[1], 91, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[1], 91, 0);}}              
   if   (MeloDecayTIMER[1][92] != 0) {
	     MeloDecayTIMER[1][92]--;
	  if(MeloDecayTIMER[1][92] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[1], 92, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[1], 92, 0);}}              
   if   (MeloDecayTIMER[1][93] != 0) {
	     MeloDecayTIMER[1][93]--;
	  if(MeloDecayTIMER[1][93] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[1], 93, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[1], 93, 0);}}   
   if   (MeloDecayTIMER[1][94] != 0) {
	     MeloDecayTIMER[1][94]--;
	  if(MeloDecayTIMER[1][94] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[1], 94, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[1], 94, 0);}}               
   if   (MeloDecayTIMER[1][95] != 0) {
	     MeloDecayTIMER[1][95]--;
	  if(MeloDecayTIMER[1][95] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[1], 95, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[1], 95, 0);}}              
   if   (MeloDecayTIMER[1][96] != 0) {
	     MeloDecayTIMER[1][96]--;
	  if(MeloDecayTIMER[1][96] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[1], 96, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[1], 96, 0);}}              
   if   (MeloDecayTIMER[1][97] != 0) {
	     MeloDecayTIMER[1][97]--;
	  if(MeloDecayTIMER[1][97] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[1], 97, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[1], 97, 0);}}              
   if   (MeloDecayTIMER[1][98] != 0) {
	     MeloDecayTIMER[1][98]--;
	  if(MeloDecayTIMER[1][98] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[1], 98, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[1], 98, 0);}}              
   if   (MeloDecayTIMER[1][99] != 0) {
	     MeloDecayTIMER[1][99]--;
	  if(MeloDecayTIMER[1][99] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[1], 99, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[1], 99, 0);}}              
   if   (MeloDecayTIMER[1][100] != 0) {
	     MeloDecayTIMER[1][100]--;
	  if(MeloDecayTIMER[1][100] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[1], 100, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[1], 100, 0);}}              
   if   (MeloDecayTIMER[1][101] != 0) {
	     MeloDecayTIMER[1][101]--;
	  if(MeloDecayTIMER[1][101] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[1], 101, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[1], 101, 0);}}              
   if   (MeloDecayTIMER[1][102] != 0) {
	     MeloDecayTIMER[1][102]--;
	  if(MeloDecayTIMER[1][102] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[1], 102, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[1], 102, 0);}}              
   if   (MeloDecayTIMER[1][103] != 0) {
	     MeloDecayTIMER[1][103]--;
	  if(MeloDecayTIMER[1][103] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[1], 103, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[1], 103, 0);}}              
   if   (MeloDecayTIMER[1][104] != 0) {
	     MeloDecayTIMER[1][104]--;
	  if(MeloDecayTIMER[1][104] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[1], 104, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[1], 104, 0);}}              
   if   (MeloDecayTIMER[1][105] != 0) {
	     MeloDecayTIMER[1][105]--;
	  if(MeloDecayTIMER[1][105] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[1], 105, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[1], 105, 0);}}              
   if   (MeloDecayTIMER[1][106] != 0) {
	     MeloDecayTIMER[1][106]--;
	  if(MeloDecayTIMER[1][106] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[1], 106, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[1], 106, 0);}}              
   if   (MeloDecayTIMER[1][107] != 0) {
	     MeloDecayTIMER[1][107]--;
	  if(MeloDecayTIMER[1][107] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[1], 107, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[1], 107, 0);}}              
   if   (MeloDecayTIMER[1][108] != 0) {
	     MeloDecayTIMER[1][108]--;
	  if(MeloDecayTIMER[1][108] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[1], 108, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[1], 108, 0);}}              
   if   (MeloDecayTIMER[1][109] != 0) {
	     MeloDecayTIMER[1][109]--;
	  if(MeloDecayTIMER[1][109] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[1], 109, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[1], 109, 0);}}              
   if   (MeloDecayTIMER[1][110] != 0) {
	     MeloDecayTIMER[1][110]--;
	  if(MeloDecayTIMER[1][110] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[1], 110, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[1], 110, 0);}}              
   if   (MeloDecayTIMER[1][111] != 0) {
	     MeloDecayTIMER[1][111]--;
	  if(MeloDecayTIMER[1][111] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[1], 111, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[1], 111, 0);}}              
   if   (MeloDecayTIMER[1][112] != 0) {
	     MeloDecayTIMER[1][112]--;
	  if(MeloDecayTIMER[1][112] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[1], 112, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[1], 112, 0);}}              
   if   (MeloDecayTIMER[1][113] != 0) {
	     MeloDecayTIMER[1][113]--;
	  if(MeloDecayTIMER[1][113] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[1], 113, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[1], 113, 0);}}              
   if   (MeloDecayTIMER[1][114] != 0) {
	     MeloDecayTIMER[1][114]--;
	  if(MeloDecayTIMER[1][114] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[1], 114, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[1], 114, 0);}}              
   if   (MeloDecayTIMER[1][115] != 0) {
	     MeloDecayTIMER[1][115]--;
	  if(MeloDecayTIMER[1][115] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[1], 115, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[1], 115, 0);}}              
   if   (MeloDecayTIMER[1][116] != 0) {
	     MeloDecayTIMER[1][116]--;
	  if(MeloDecayTIMER[1][116] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[1], 116, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[1], 116, 0);}}              
   if   (MeloDecayTIMER[1][117] != 0) {
	     MeloDecayTIMER[1][117]--;
	  if(MeloDecayTIMER[1][117] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[1], 117, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[1], 117, 0);}}              
   if   (MeloDecayTIMER[1][118] != 0) {
	     MeloDecayTIMER[1][118]--;
	  if(MeloDecayTIMER[1][118] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[1], 118, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[1], 118, 0);}}              
   if   (MeloDecayTIMER[1][119] != 0) {
	     MeloDecayTIMER[1][119]--;
	  if(MeloDecayTIMER[1][119] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[1], 119, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[1], 119, 0);}}              
   if   (MeloDecayTIMER[1][120] != 0) {
	     MeloDecayTIMER[1][120]--;
	  if(MeloDecayTIMER[1][120] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[1], 120, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[1], 120, 0);}}              
   if   (MeloDecayTIMER[1][121] != 0) {
	     MeloDecayTIMER[1][121]--;
	  if(MeloDecayTIMER[1][121] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[1], 121, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[1], 121, 0);}}              
   if   (MeloDecayTIMER[1][122] != 0) {
	     MeloDecayTIMER[1][122]--;
	  if(MeloDecayTIMER[1][122] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[1], 122, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[1], 122, 0);}}              
   if   (MeloDecayTIMER[1][123] != 0) {
	     MeloDecayTIMER[1][123]--;
	  if(MeloDecayTIMER[1][23] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[1], 123, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[1], 123, 0);}}              
   if   (MeloDecayTIMER[1][124] != 0) {
	     MeloDecayTIMER[1][124]--;
	  if(MeloDecayTIMER[1][124] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[1], 124, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[1], 124, 0);}}              
   if   (MeloDecayTIMER[1][125] != 0) {
	     MeloDecayTIMER[1][125]--;
	  if(MeloDecayTIMER[1][125] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[1], 125, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[1], 125, 0);}}              
   if   (MeloDecayTIMER[1][126] != 0) {
	     MeloDecayTIMER[1][126]--;
	  if(MeloDecayTIMER[1][126] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[1], 126, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[1], 126, 0);}}              
   if   (MeloDecayTIMER[1][127] != 0) {
	     MeloDecayTIMER[1][127]--;
	  if(MeloDecayTIMER[1][127] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[1], 127, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[1], 127, 0);}}                                       
}//End While
}//End TICK 0 >>> 1ms Task...

static void TASK_Midi_Decay2(void *pvParameters){  //Send Note OFFs after a while
   portTickType xLastExecutionTime;
   xLastExecutionTime = xTaskGetTickCount();       // Initialise the xLastExecutionTime variable on task entry

  while( 1 ) {
    vTaskDelayUntil(&xLastExecutionTime, 1 / portTICK_RATE_MS);
    
   if   (MeloDecayTIMER[2][1] != 0) {
	     MeloDecayTIMER[2][1]--;
	  if(MeloDecayTIMER[2][1] == 0) {
		   MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[2], 1, 0); //Port, Chn, Note, Velocity 
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[2], 1, 0);}}  
   if   (MeloDecayTIMER[2][2] != 0) {
	     MeloDecayTIMER[2][2]--;
	  if(MeloDecayTIMER[2][2] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[2], 2, 0); //Port, Chn, Note, Velocity 
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[2], 2, 0);}}   
   if   (MeloDecayTIMER[2][3] != 0) {
	     MeloDecayTIMER[2][3]--;
	  if(MeloDecayTIMER[2][3] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[2], 3, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[2], 3, 0);}}
   if   (MeloDecayTIMER[2][4] != 0) {
	     MeloDecayTIMER[2][4]--;
	  if(MeloDecayTIMER[2][4] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[2], 4, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[2], 4, 0);}} 
   if   (MeloDecayTIMER[2][5] != 0) {
	     MeloDecayTIMER[2][5]--;
	  if(MeloDecayTIMER[2][5] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[2], 5, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[2], 5, 0);}} 
   if   (MeloDecayTIMER[2][6] != 0) {
	     MeloDecayTIMER[2][6]--;
	  if(MeloDecayTIMER[2][6] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[2], 6, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[2], 6, 0);}} 
   if   (MeloDecayTIMER[2][7] != 0) {
	     MeloDecayTIMER[2][7]--;
	  if(MeloDecayTIMER[2][7] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[2], 7, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[2], 7, 0);}}   
   if   (MeloDecayTIMER[2][8] != 0) {
	     MeloDecayTIMER[2][8]--;
	  if(MeloDecayTIMER[2][8] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[2], 8, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[2], 8, 0);}}   
   if   (MeloDecayTIMER[2][9] != 0) {
	     MeloDecayTIMER[2][9]--;
	  if(MeloDecayTIMER[2][9] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[2], 9, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[2], 9, 0);}}   
   if   (MeloDecayTIMER[2][10] != 0) {
	     MeloDecayTIMER[2][10]--;
	  if(MeloDecayTIMER[2][10] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[2], 10, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[2], 10, 0);}}   
   if   (MeloDecayTIMER[2][11] != 0) {
	     MeloDecayTIMER[2][11]--;
	  if(MeloDecayTIMER[2][11] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[2], 11, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[2], 11, 0);}}   
   if   (MeloDecayTIMER[2][12] != 0) {
	     MeloDecayTIMER[2][12]--;
	  if(MeloDecayTIMER[2][12] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[2], 12, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[2], 12, 0);}}   
   if   (MeloDecayTIMER[2][13] != 0) {
	     MeloDecayTIMER[2][13]--;
	  if(MeloDecayTIMER[2][13] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[2], 13, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[2], 13, 0);}}   
   if   (MeloDecayTIMER[2][14] != 0) {
	     MeloDecayTIMER[2][14]--;
	  if(MeloDecayTIMER[2][14] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[2], 14, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[2], 14, 0);}}   
   if   (MeloDecayTIMER[2][15] != 0) {
	     MeloDecayTIMER[2][15]--;
	  if(MeloDecayTIMER[2][15] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[2], 15, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[2], 15, 0);}}   
   if   (MeloDecayTIMER[2][16] != 0) {
	     MeloDecayTIMER[2][16]--;
	  if(MeloDecayTIMER[2][16] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[2], 16, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[2], 16, 0);}}   
   if   (MeloDecayTIMER[2][17] != 0) {
	     MeloDecayTIMER[2][17]--;
	  if(MeloDecayTIMER[2][17] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[2], 17, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[2], 17, 0);}}   
   if   (MeloDecayTIMER[2][18] != 0) {
	     MeloDecayTIMER[2][18]--;
	  if(MeloDecayTIMER[2][18] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[2], 18, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[2], 18, 0);}}   
   if   (MeloDecayTIMER[2][19] != 0) {
	     MeloDecayTIMER[2][19]--;
	  if(MeloDecayTIMER[2][19] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[2], 19, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[2], 19, 0);}}   
   if   (MeloDecayTIMER[2][20] != 0) {
	     MeloDecayTIMER[2][20]--;
	  if(MeloDecayTIMER[2][20] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[2], 20, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[2], 20, 0);}}   
   if   (MeloDecayTIMER[2][21] != 0) {
	     MeloDecayTIMER[2][21]--;
	  if(MeloDecayTIMER[2][21] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[2], 21, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[2], 21, 0);}}   
   if   (MeloDecayTIMER[2][22] != 0) {
	     MeloDecayTIMER[2][22]--;
	  if(MeloDecayTIMER[2][22] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[2], 22, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[2], 22, 0);}}   
   if   (MeloDecayTIMER[2][23] != 0) {
	     MeloDecayTIMER[2][23]--;
	  if(MeloDecayTIMER[2][23] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[2], 23, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[2], 23, 0);}}   
   if   (MeloDecayTIMER[2][24] != 0) {
	     MeloDecayTIMER[2][24]--;
	  if(MeloDecayTIMER[2][24] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[2], 24, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[2], 24, 0);}}   
   if   (MeloDecayTIMER[2][25] != 0) {
	     MeloDecayTIMER[2][25]--;
	  if(MeloDecayTIMER[2][25] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[2], 25, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[2], 25, 0);}}   
   if   (MeloDecayTIMER[2][26] != 0) {
	     MeloDecayTIMER[2][26]--;
	  if(MeloDecayTIMER[2][26] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[2], 26, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[2], 26, 0);}}   
   if   (MeloDecayTIMER[2][27] != 0) {
	     MeloDecayTIMER[2][27]--;
	  if(MeloDecayTIMER[2][27] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[2], 27, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[2], 27, 0);}}   
   if   (MeloDecayTIMER[2][28] != 0) {
	     MeloDecayTIMER[2][28]--;
	  if(MeloDecayTIMER[2][28] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[2], 28, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[2], 28, 0);}}   
   if   (MeloDecayTIMER[2][29] != 0) {
	     MeloDecayTIMER[2][29]--;
	  if(MeloDecayTIMER[2][29] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[2], 29, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[2], 29, 0);}}   
   if   (MeloDecayTIMER[2][30] != 0) {
	     MeloDecayTIMER[2][30]--;
	  if(MeloDecayTIMER[2][30] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[2], 30, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[2], 30, 0);}}   
   if   (MeloDecayTIMER[2][31] != 0) {
	     MeloDecayTIMER[2][31]--;
	  if(MeloDecayTIMER[2][31] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[2], 31, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[2], 31, 0);}}   
   if   (MeloDecayTIMER[2][32] != 0) {
	     MeloDecayTIMER[2][32]--;
	  if(MeloDecayTIMER[2][32] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[2], 32, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[2], 32, 0);}}   
   if   (MeloDecayTIMER[2][33] != 0) {
	     MeloDecayTIMER[2][33]--;
	  if(MeloDecayTIMER[2][33] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[2], 33, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[2], 33, 0);}}   
   if   (MeloDecayTIMER[2][34] != 0) {
	     MeloDecayTIMER[2][34]--;
	  if(MeloDecayTIMER[2][34] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[2], 34, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[2], 34, 0);}}   
   if   (MeloDecayTIMER[2][35] != 0) {
	     MeloDecayTIMER[2][35]--;
	  if(MeloDecayTIMER[2][35] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[2], 35, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[2], 35, 0);}}   
   if   (MeloDecayTIMER[2][36] != 0) {
	     MeloDecayTIMER[2][36]--;
	  if(MeloDecayTIMER[2][36] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[2], 36, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[2], 36, 0);}}   
   if   (MeloDecayTIMER[2][37] != 0) {
	     MeloDecayTIMER[2][37]--;
	  if(MeloDecayTIMER[2][37] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[2], 37, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[2], 37, 0);}}   
   if   (MeloDecayTIMER[2][38] != 0) {
	     MeloDecayTIMER[2][38]--;
	  if(MeloDecayTIMER[2][38] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[2], 38, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[2], 38, 0);}}         
   if   (MeloDecayTIMER[2][39] != 0) {
	     MeloDecayTIMER[2][39]--;
	  if(MeloDecayTIMER[2][39] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[2], 39, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[2], 39, 0);}}              
   if   (MeloDecayTIMER[2][40] != 0) {
	     MeloDecayTIMER[2][40]--;
	  if(MeloDecayTIMER[2][40] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[2], 40, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[2], 40, 0);}}              
   if   (MeloDecayTIMER[2][41] != 0) {
	     MeloDecayTIMER[2][41]--;
	  if(MeloDecayTIMER[2][41] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[2], 41, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[2], 41, 0);}}              
   if   (MeloDecayTIMER[2][42] != 0) {
	     MeloDecayTIMER[2][42]--;
	  if(MeloDecayTIMER[2][42] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[2], 42, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[2], 42, 0);}}             
   if   (MeloDecayTIMER[2][43] != 0) {
	     MeloDecayTIMER[2][43]--;
	  if(MeloDecayTIMER[2][43] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[2], 43, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[2], 43, 0);}}              
   if   (MeloDecayTIMER[2][44] != 0) {
	     MeloDecayTIMER[2][44]--;
	  if(MeloDecayTIMER[2][44] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[2], 44, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[2], 44, 0);}}              
   if   (MeloDecayTIMER[2][45] != 0) {
	     MeloDecayTIMER[2][45]--;
	  if(MeloDecayTIMER[2][45] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[2], 45, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[2], 45, 0);}}              
   if   (MeloDecayTIMER[2][46] != 0) {
	     MeloDecayTIMER[2][46]--;
	  if(MeloDecayTIMER[2][46] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[2], 46, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[2], 46, 0);}}              
   if   (MeloDecayTIMER[2][47] != 0) {
	     MeloDecayTIMER[2][47]--;
	  if(MeloDecayTIMER[2][47] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[2], 47, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[2], 47, 0);}}              
   if   (MeloDecayTIMER[2][48] != 0) {
	     MeloDecayTIMER[2][48]--;
	  if(MeloDecayTIMER[2][48] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[2], 48, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[2], 48, 0);}}              
   if   (MeloDecayTIMER[2][49] != 0) {
	     MeloDecayTIMER[2][49]--;
	  if(MeloDecayTIMER[2][49] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[2], 49, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[2], 49, 0);}}              
   if   (MeloDecayTIMER[2][50] != 0) {
	     MeloDecayTIMER[2][50]--;
	  if(MeloDecayTIMER[2][50] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[2], 50, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[2], 50, 0);}}              
   if   (MeloDecayTIMER[2][51] != 0) {
	     MeloDecayTIMER[2][51]--;
	  if(MeloDecayTIMER[2][51] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[2], 51, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[2], 51, 0);}}              
   if   (MeloDecayTIMER[2][52] != 0) {
	     MeloDecayTIMER[2][52]--;
	  if(MeloDecayTIMER[2][52] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[2], 52, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[2], 52, 0);}}    
   if   (MeloDecayTIMER[2][53] != 0) {
	     MeloDecayTIMER[2][53]--;
	  if(MeloDecayTIMER[2][53] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[2], 53, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[2], 53, 0);}}              
   if   (MeloDecayTIMER[2][54] != 0) {
	     MeloDecayTIMER[2][54]--;
	  if(MeloDecayTIMER[2][54] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[2], 54, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[2], 54, 0);}}              
   if   (MeloDecayTIMER[2][55] != 0) {
	     MeloDecayTIMER[2][55]--;
	  if(MeloDecayTIMER[2][55] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[2], 55, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[2], 55, 0);}}              
   if   (MeloDecayTIMER[2][56] != 0) {
	     MeloDecayTIMER[2][56]--;
	  if(MeloDecayTIMER[2][56] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[2], 56, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[2], 56, 0);}}              
   if   (MeloDecayTIMER[2][57] != 0) {
	     MeloDecayTIMER[2][57]--;
	  if(MeloDecayTIMER[2][57] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[2], 57, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[2], 57, 0);}}              
   if   (MeloDecayTIMER[2][58] != 0) {
	     MeloDecayTIMER[2][58]--;
	  if(MeloDecayTIMER[2][58] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[2], 58, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[2], 58, 0);}}              
   if   (MeloDecayTIMER[2][59] != 0) {
	     MeloDecayTIMER[2][59]--;
	  if(MeloDecayTIMER[2][59] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[2], 59, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[2], 59, 0);}}              
   if   (MeloDecayTIMER[2][60] != 0) {
	     MeloDecayTIMER[2][60]--;
	  if(MeloDecayTIMER[2][60] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[2], 60, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[2], 60, 0);}}              
   if   (MeloDecayTIMER[2][61] != 0) {
	     MeloDecayTIMER[2][61]--;
	  if(MeloDecayTIMER[2][61] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[2], 61, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[2], 61, 0);}}              
   if   (MeloDecayTIMER[2][62] != 0) {
	     MeloDecayTIMER[2][62]--;
	  if(MeloDecayTIMER[2][62] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[2], 62, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[2], 62, 0);}}              
   if   (MeloDecayTIMER[2][63] != 0) {
	     MeloDecayTIMER[2][63]--;
	  if(MeloDecayTIMER[2][63] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[2], 63, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[2], 63, 0);}}              
   if   (MeloDecayTIMER[2][64] != 0) {
	     MeloDecayTIMER[2][64]--;
	  if(MeloDecayTIMER[2][64] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[2], 64, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[2], 64, 0);}}              
   if   (MeloDecayTIMER[2][65] != 0) {
	     MeloDecayTIMER[2][65]--;
	  if(MeloDecayTIMER[2][65] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[2], 65, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[2], 65, 0);}}              
   if   (MeloDecayTIMER[2][66] != 0) {
	     MeloDecayTIMER[2][66]--;
	  if(MeloDecayTIMER[2][66] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[2], 66, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[2], 66, 0);}}              
   if   (MeloDecayTIMER[2][67] != 0) {
	     MeloDecayTIMER[2][67]--;
	  if(MeloDecayTIMER[2][67] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[2], 67, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[2], 67, 0);}}              
   if   (MeloDecayTIMER[2][68] != 0) {
	     MeloDecayTIMER[2][68]--;
	  if(MeloDecayTIMER[2][68] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[2], 68, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[2], 68, 0);}}              
   if   (MeloDecayTIMER[2][69] != 0) {
	     MeloDecayTIMER[2][69]--;
	  if(MeloDecayTIMER[2][69] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[2], 69, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[2], 69, 0);}}              
   if   (MeloDecayTIMER[2][70] != 0) {
	     MeloDecayTIMER[2][70]--;
	  if(MeloDecayTIMER[2][70] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[2], 70, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[2], 70, 0);}}              
   if   (MeloDecayTIMER[2][71] != 0) {
	     MeloDecayTIMER[2][71]--;
	  if(MeloDecayTIMER[2][71] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[2], 71, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[2], 71, 0);}}              
   if   (MeloDecayTIMER[2][72] != 0) {
	     MeloDecayTIMER[2][72]--;
	  if(MeloDecayTIMER[2][72] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[2], 72, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[2], 72, 0);}}              
   if   (MeloDecayTIMER[2][73] != 0) {
	     MeloDecayTIMER[2][73]--;
	  if(MeloDecayTIMER[2][73] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[2], 73, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[2], 73, 0);}}              
   if   (MeloDecayTIMER[2][74] != 0) {
	     MeloDecayTIMER[2][74]--;
	  if(MeloDecayTIMER[2][74] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[2], 74, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[2], 74, 0);}}              
   if   (MeloDecayTIMER[2][75] != 0) {
	     MeloDecayTIMER[2][75]--;
	  if(MeloDecayTIMER[2][75] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[2], 75, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[2], 75, 0);}}              
   if   (MeloDecayTIMER[2][76] != 0) {
	     MeloDecayTIMER[2][76]--;
	  if(MeloDecayTIMER[2][76] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[2], 76, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[2], 76, 0);}}              
   if   (MeloDecayTIMER[2][77] != 0) {
	     MeloDecayTIMER[2][77]--;
	  if(MeloDecayTIMER[2][77] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[2], 77, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[2], 77, 0);}}              
   if   (MeloDecayTIMER[2][78] != 0) {
	     MeloDecayTIMER[2][78]--;
	  if(MeloDecayTIMER[2][78] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[2], 78, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[2], 78, 0);}}              
   if   (MeloDecayTIMER[2][79] != 0) {
	     MeloDecayTIMER[2][79]--;
	  if(MeloDecayTIMER[2][79] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[2], 79, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[2], 79, 0);}}              
   if   (MeloDecayTIMER[2][80] != 0) {
	     MeloDecayTIMER[2][80]--;
	  if(MeloDecayTIMER[2][80] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[2], 80, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[2], 80, 0);}}              
   if   (MeloDecayTIMER[2][81] != 0) {
	     MeloDecayTIMER[2][81]--;
	  if(MeloDecayTIMER[2][81] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[2], 81, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[2], 81, 0);}}              
   if   (MeloDecayTIMER[2][82] != 0) {
	     MeloDecayTIMER[2][82]--;
	  if(MeloDecayTIMER[2][82] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[2], 82, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[2], 82, 0);}}              
   if   (MeloDecayTIMER[2][83] != 0) {
	     MeloDecayTIMER[2][83]--;
	  if(MeloDecayTIMER[2][83] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[2], 83, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[2], 83, 0);}}              
   if   (MeloDecayTIMER[2][84] != 0) {
	     MeloDecayTIMER[2][84]--;
	  if(MeloDecayTIMER[2][84] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[2], 84, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[2], 84, 0);}}              
   if   (MeloDecayTIMER[2][85] != 0) {
	     MeloDecayTIMER[2][85]--;
	  if(MeloDecayTIMER[2][85] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[2], 85, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[2], 85, 0);}}              
   if   (MeloDecayTIMER[2][86] != 0) {
	     MeloDecayTIMER[2][86]--;
	  if(MeloDecayTIMER[2][86] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[2], 86, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[2], 86, 0);}}              
   if   (MeloDecayTIMER[2][87] != 0) {
	     MeloDecayTIMER[2][87]--;
	  if(MeloDecayTIMER[2][87] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[2], 87, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[2], 87, 0);}}              
   if   (MeloDecayTIMER[2][88] != 0) {
	     MeloDecayTIMER[2][88]--;
	  if(MeloDecayTIMER[2][88] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[2], 88, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[2], 88, 0);}}              
   if   (MeloDecayTIMER[2][89] != 0) {
	     MeloDecayTIMER[2][89]--;
	  if(MeloDecayTIMER[2][89] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[2], 89, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[2], 89, 0);}}                    
   if   (MeloDecayTIMER[2][90] != 0) {
	     MeloDecayTIMER[2][90]--;
	  if(MeloDecayTIMER[2][90] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[2], 90, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[2], 90, 0);}}              
   if   (MeloDecayTIMER[2][91] != 0) {
	     MeloDecayTIMER[2][91]--;
	  if(MeloDecayTIMER[2][91] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[2], 91, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[2], 91, 0);}}              
   if   (MeloDecayTIMER[2][92] != 0) {
	     MeloDecayTIMER[2][92]--;
	  if(MeloDecayTIMER[2][92] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[2], 92, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[2], 92, 0);}}              
   if   (MeloDecayTIMER[2][93] != 0) {
	     MeloDecayTIMER[2][93]--;
	  if(MeloDecayTIMER[2][93] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[2], 93, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[2], 93, 0);}}   
   if   (MeloDecayTIMER[2][94] != 0) {
	     MeloDecayTIMER[2][94]--;
	  if(MeloDecayTIMER[2][94] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[2], 94, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[2], 94, 0);}}               
   if   (MeloDecayTIMER[2][95] != 0) {
	     MeloDecayTIMER[2][95]--;
	  if(MeloDecayTIMER[2][95] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[2], 95, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[2], 95, 0);}}              
   if   (MeloDecayTIMER[2][96] != 0) {
	     MeloDecayTIMER[2][96]--;
	  if(MeloDecayTIMER[2][96] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[2], 96, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[2], 96, 0);}}              
   if   (MeloDecayTIMER[2][97] != 0) {
	     MeloDecayTIMER[2][97]--;
	  if(MeloDecayTIMER[2][97] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[2], 97, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[2], 97, 0);}}              
   if   (MeloDecayTIMER[2][98] != 0) {
	     MeloDecayTIMER[2][98]--;
	  if(MeloDecayTIMER[2][98] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[2], 98, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[2], 98, 0);}}              
   if   (MeloDecayTIMER[2][99] != 0) {
	     MeloDecayTIMER[2][99]--;
	  if(MeloDecayTIMER[2][99] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[2], 99, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[2], 99, 0);}}              
   if   (MeloDecayTIMER[2][100] != 0) {
	     MeloDecayTIMER[2][100]--;
	  if(MeloDecayTIMER[2][100] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[2], 100, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[2], 100, 0);}}              
   if   (MeloDecayTIMER[2][101] != 0) {
	     MeloDecayTIMER[2][101]--;
	  if(MeloDecayTIMER[2][101] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[2], 101, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[2], 101, 0);}}              
   if   (MeloDecayTIMER[2][102] != 0) {
	     MeloDecayTIMER[2][102]--;
	  if(MeloDecayTIMER[2][102] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[2], 102, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[2], 102, 0);}}              
   if   (MeloDecayTIMER[2][103] != 0) {
	     MeloDecayTIMER[2][103]--;
	  if(MeloDecayTIMER[2][103] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[2], 103, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[2], 103, 0);}}              
   if   (MeloDecayTIMER[2][104] != 0) {
	     MeloDecayTIMER[2][104]--;
	  if(MeloDecayTIMER[2][104] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[2], 104, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[2], 104, 0);}}              
   if   (MeloDecayTIMER[2][105] != 0) {
	     MeloDecayTIMER[2][105]--;
	  if(MeloDecayTIMER[2][105] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[2], 105, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[2], 105, 0);}}              
   if   (MeloDecayTIMER[2][106] != 0) {
	     MeloDecayTIMER[2][106]--;
	  if(MeloDecayTIMER[2][106] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[2], 106, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[2], 106, 0);}}              
   if   (MeloDecayTIMER[2][107] != 0) {
	     MeloDecayTIMER[2][107]--;
	  if(MeloDecayTIMER[2][107] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[2], 107, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[2], 107, 0);}}              
   if   (MeloDecayTIMER[2][108] != 0) {
	     MeloDecayTIMER[2][108]--;
	  if(MeloDecayTIMER[2][108] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[2], 108, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[2], 108, 0);}}              
   if   (MeloDecayTIMER[2][109] != 0) {
	     MeloDecayTIMER[2][109]--;
	  if(MeloDecayTIMER[2][109] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[2], 109, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[2], 109, 0);}}              
   if   (MeloDecayTIMER[2][110] != 0) {
	     MeloDecayTIMER[2][110]--;
	  if(MeloDecayTIMER[2][110] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[2], 110, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[2], 110, 0);}}              
   if   (MeloDecayTIMER[2][111] != 0) {
	     MeloDecayTIMER[2][111]--;
	  if(MeloDecayTIMER[2][111] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[2], 111, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[2], 111, 0);}}              
   if   (MeloDecayTIMER[2][112] != 0) {
	     MeloDecayTIMER[2][112]--;
	  if(MeloDecayTIMER[2][112] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[2], 112, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[2], 112, 0);}}              
   if   (MeloDecayTIMER[2][113] != 0) {
	     MeloDecayTIMER[2][113]--;
	  if(MeloDecayTIMER[2][113] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[2], 113, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[2], 113, 0);}}              
   if   (MeloDecayTIMER[2][114] != 0) {
	     MeloDecayTIMER[2][114]--;
	  if(MeloDecayTIMER[2][114] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[2], 114, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[2], 114, 0);}}              
   if   (MeloDecayTIMER[2][115] != 0) {
	     MeloDecayTIMER[2][115]--;
	  if(MeloDecayTIMER[2][115] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[2], 115, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[2], 115, 0);}}              
   if   (MeloDecayTIMER[2][116] != 0) {
	     MeloDecayTIMER[2][116]--;
	  if(MeloDecayTIMER[2][116] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[2], 116, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[2], 116, 0);}}              
   if   (MeloDecayTIMER[2][117] != 0) {
	     MeloDecayTIMER[2][117]--;
	  if(MeloDecayTIMER[2][117] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[2], 117, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[2], 117, 0);}}              
   if   (MeloDecayTIMER[2][118] != 0) {
	     MeloDecayTIMER[2][118]--;
	  if(MeloDecayTIMER[2][118] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[2], 118, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[2], 118, 0);}}              
   if   (MeloDecayTIMER[2][119] != 0) {
	     MeloDecayTIMER[2][119]--;
	  if(MeloDecayTIMER[2][119] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[2], 119, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[2], 119, 0);}}              
   if   (MeloDecayTIMER[2][120] != 0) {
	     MeloDecayTIMER[2][120]--;
	  if(MeloDecayTIMER[2][120] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[2], 120, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[2], 120, 0);}}              
   if   (MeloDecayTIMER[2][121] != 0) {
	     MeloDecayTIMER[2][121]--;
	  if(MeloDecayTIMER[2][121] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[2], 121, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[2], 121, 0);}}              
   if   (MeloDecayTIMER[2][122] != 0) {
	     MeloDecayTIMER[2][122]--;
	  if(MeloDecayTIMER[2][122] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[2], 122, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[2], 122, 0);}}              
   if   (MeloDecayTIMER[2][123] != 0) {
	     MeloDecayTIMER[2][123]--;
	  if(MeloDecayTIMER[2][23] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[2], 123, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[2], 123, 0);}}              
   if   (MeloDecayTIMER[2][124] != 0) {
	     MeloDecayTIMER[2][124]--;
	  if(MeloDecayTIMER[2][124] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[2], 124, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[2], 124, 0);}}              
   if   (MeloDecayTIMER[2][125] != 0) {
	     MeloDecayTIMER[2][125]--;
	  if(MeloDecayTIMER[2][125] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[2], 125, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[2], 125, 0);}}              
   if   (MeloDecayTIMER[2][126] != 0) {
	     MeloDecayTIMER[2][126]--;
	  if(MeloDecayTIMER[2][126] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[2], 126, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[2], 126, 0);}}              
   if   (MeloDecayTIMER[2][127] != 0) {
	     MeloDecayTIMER[2][127]--;
	  if(MeloDecayTIMER[2][127] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[2], 127, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[2], 127, 0);}}                                       
}//End While
}//End TICK 0 >>> 1ms Task...

static void TASK_Midi_Decay3(void *pvParameters){  //Send Note OFFs after a while
   portTickType xLastExecutionTime;
   xLastExecutionTime = xTaskGetTickCount();       // Initialise the xLastExecutionTime variable on task entry

  while( 1 ) {
    vTaskDelayUntil(&xLastExecutionTime, 1 / portTICK_RATE_MS);
    
   if   (MeloDecayTIMER[3][1] != 0) {
	     MeloDecayTIMER[3][1]--;
	  if(MeloDecayTIMER[3][1] == 0) {
		   MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[3], 1, 0); //Port, Chn, Note, Velocity 
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[3], 1, 0);}}  
   if   (MeloDecayTIMER[3][2] != 0) {
	     MeloDecayTIMER[3][2]--;
	  if(MeloDecayTIMER[3][2] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[3], 2, 0); //Port, Chn, Note, Velocity 
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[3], 2, 0);}}   
   if   (MeloDecayTIMER[3][3] != 0) {
	     MeloDecayTIMER[3][3]--;
	  if(MeloDecayTIMER[3][3] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[3], 3, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[3], 3, 0);}}
   if   (MeloDecayTIMER[3][4] != 0) {
	     MeloDecayTIMER[3][4]--;
	  if(MeloDecayTIMER[3][4] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[3], 4, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[3], 4, 0);}} 
   if   (MeloDecayTIMER[3][5] != 0) {
	     MeloDecayTIMER[3][5]--;
	  if(MeloDecayTIMER[3][5] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[3], 5, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[3], 5, 0);}} 
   if   (MeloDecayTIMER[3][6] != 0) {
	     MeloDecayTIMER[3][6]--;
	  if(MeloDecayTIMER[3][6] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[3], 6, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[3], 6, 0);}} 
   if   (MeloDecayTIMER[3][7] != 0) {
	     MeloDecayTIMER[3][7]--;
	  if(MeloDecayTIMER[3][7] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[3], 7, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[3], 7, 0);}}   
   if   (MeloDecayTIMER[3][8] != 0) {
	     MeloDecayTIMER[3][8]--;
	  if(MeloDecayTIMER[3][8] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[3], 8, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[3], 8, 0);}}   
   if   (MeloDecayTIMER[3][9] != 0) {
	     MeloDecayTIMER[3][9]--;
	  if(MeloDecayTIMER[3][9] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[3], 9, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[3], 9, 0);}}   
   if   (MeloDecayTIMER[3][10] != 0) {
	     MeloDecayTIMER[3][10]--;
	  if(MeloDecayTIMER[3][10] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[3], 10, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[3], 10, 0);}}   
   if   (MeloDecayTIMER[3][11] != 0) {
	     MeloDecayTIMER[3][11]--;
	  if(MeloDecayTIMER[3][11] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[3], 11, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[3], 11, 0);}}   
   if   (MeloDecayTIMER[3][12] != 0) {
	     MeloDecayTIMER[3][12]--;
	  if(MeloDecayTIMER[3][12] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[3], 12, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[3], 12, 0);}}   
   if   (MeloDecayTIMER[3][13] != 0) {
	     MeloDecayTIMER[3][13]--;
	  if(MeloDecayTIMER[3][13] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[3], 13, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[3], 13, 0);}}   
   if   (MeloDecayTIMER[3][14] != 0) {
	     MeloDecayTIMER[3][14]--;
	  if(MeloDecayTIMER[3][14] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[3], 14, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[3], 14, 0);}}   
   if   (MeloDecayTIMER[3][15] != 0) {
	     MeloDecayTIMER[3][15]--;
	  if(MeloDecayTIMER[3][15] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[3], 15, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[3], 15, 0);}}   
   if   (MeloDecayTIMER[3][16] != 0) {
	     MeloDecayTIMER[3][16]--;
	  if(MeloDecayTIMER[3][16] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[3], 16, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[3], 16, 0);}}   
   if   (MeloDecayTIMER[3][17] != 0) {
	     MeloDecayTIMER[3][17]--;
	  if(MeloDecayTIMER[3][17] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[3], 17, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[3], 17, 0);}}   
   if   (MeloDecayTIMER[3][18] != 0) {
	     MeloDecayTIMER[3][18]--;
	  if(MeloDecayTIMER[3][18] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[3], 18, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[3], 18, 0);}}   
   if   (MeloDecayTIMER[3][19] != 0) {
	     MeloDecayTIMER[3][19]--;
	  if(MeloDecayTIMER[3][19] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[3], 19, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[3], 19, 0);}}   
   if   (MeloDecayTIMER[3][20] != 0) {
	     MeloDecayTIMER[3][20]--;
	  if(MeloDecayTIMER[3][20] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[3], 20, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[3], 20, 0);}}   
   if   (MeloDecayTIMER[3][21] != 0) {
	     MeloDecayTIMER[3][21]--;
	  if(MeloDecayTIMER[3][21] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[3], 21, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[3], 21, 0);}}   
   if   (MeloDecayTIMER[3][22] != 0) {
	     MeloDecayTIMER[3][22]--;
	  if(MeloDecayTIMER[3][22] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[3], 22, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[3], 22, 0);}}   
   if   (MeloDecayTIMER[3][23] != 0) {
	     MeloDecayTIMER[3][23]--;
	  if(MeloDecayTIMER[3][23] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[3], 23, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[3], 23, 0);}}   
   if   (MeloDecayTIMER[3][24] != 0) {
	     MeloDecayTIMER[3][24]--;
	  if(MeloDecayTIMER[3][24] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[3], 24, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[3], 24, 0);}}   
   if   (MeloDecayTIMER[3][25] != 0) {
	     MeloDecayTIMER[3][25]--;
	  if(MeloDecayTIMER[3][25] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[3], 25, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[3], 25, 0);}}   
   if   (MeloDecayTIMER[3][26] != 0) {
	     MeloDecayTIMER[3][26]--;
	  if(MeloDecayTIMER[3][26] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[3], 26, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[3], 26, 0);}}   
   if   (MeloDecayTIMER[3][27] != 0) {
	     MeloDecayTIMER[3][27]--;
	  if(MeloDecayTIMER[3][27] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[3], 27, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[3], 27, 0);}}   
   if   (MeloDecayTIMER[3][28] != 0) {
	     MeloDecayTIMER[3][28]--;
	  if(MeloDecayTIMER[3][28] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[3], 28, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[3], 28, 0);}}   
   if   (MeloDecayTIMER[3][29] != 0) {
	     MeloDecayTIMER[3][29]--;
	  if(MeloDecayTIMER[3][29] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[3], 29, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[3], 29, 0);}}   
   if   (MeloDecayTIMER[3][30] != 0) {
	     MeloDecayTIMER[3][30]--;
	  if(MeloDecayTIMER[3][30] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[3], 30, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[3], 30, 0);}}   
   if   (MeloDecayTIMER[3][31] != 0) {
	     MeloDecayTIMER[3][31]--;
	  if(MeloDecayTIMER[3][31] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[3], 31, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[3], 31, 0);}}   
   if   (MeloDecayTIMER[3][32] != 0) {
	     MeloDecayTIMER[3][32]--;
	  if(MeloDecayTIMER[3][32] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[3], 32, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[3], 32, 0);}}   
   if   (MeloDecayTIMER[3][33] != 0) {
	     MeloDecayTIMER[3][33]--;
	  if(MeloDecayTIMER[3][33] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[3], 33, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[3], 33, 0);}}   
   if   (MeloDecayTIMER[3][34] != 0) {
	     MeloDecayTIMER[3][34]--;
	  if(MeloDecayTIMER[3][34] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[3], 34, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[3], 34, 0);}}   
   if   (MeloDecayTIMER[3][35] != 0) {
	     MeloDecayTIMER[3][35]--;
	  if(MeloDecayTIMER[3][35] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[3], 35, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[3], 35, 0);}}   
   if   (MeloDecayTIMER[3][36] != 0) {
	     MeloDecayTIMER[3][36]--;
	  if(MeloDecayTIMER[3][36] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[3], 36, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[3], 36, 0);}}   
   if   (MeloDecayTIMER[3][37] != 0) {
	     MeloDecayTIMER[3][37]--;
	  if(MeloDecayTIMER[3][37] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[3], 37, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[3], 37, 0);}}   
   if   (MeloDecayTIMER[3][38] != 0) {
	     MeloDecayTIMER[3][38]--;
	  if(MeloDecayTIMER[3][38] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[3], 38, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[3], 38, 0);}}         
   if   (MeloDecayTIMER[3][39] != 0) {
	     MeloDecayTIMER[3][39]--;
	  if(MeloDecayTIMER[3][39] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[3], 39, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[3], 39, 0);}}              
   if   (MeloDecayTIMER[3][40] != 0) {
	     MeloDecayTIMER[3][40]--;
	  if(MeloDecayTIMER[3][40] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[3], 40, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[3], 40, 0);}}              
   if   (MeloDecayTIMER[3][41] != 0) {
	     MeloDecayTIMER[3][41]--;
	  if(MeloDecayTIMER[3][41] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[3], 41, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[3], 41, 0);}}              
   if   (MeloDecayTIMER[3][42] != 0) {
	     MeloDecayTIMER[3][42]--;
	  if(MeloDecayTIMER[3][42] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[3], 42, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[3], 42, 0);}}             
   if   (MeloDecayTIMER[3][43] != 0) {
	     MeloDecayTIMER[3][43]--;
	  if(MeloDecayTIMER[3][43] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[3], 43, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[3], 43, 0);}}              
   if   (MeloDecayTIMER[3][44] != 0) {
	     MeloDecayTIMER[3][44]--;
	  if(MeloDecayTIMER[3][44] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[3], 44, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[3], 44, 0);}}              
   if   (MeloDecayTIMER[3][45] != 0) {
	     MeloDecayTIMER[3][45]--;
	  if(MeloDecayTIMER[3][45] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[3], 45, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[3], 45, 0);}}              
   if   (MeloDecayTIMER[3][46] != 0) {
	     MeloDecayTIMER[3][46]--;
	  if(MeloDecayTIMER[3][46] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[3], 46, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[3], 46, 0);}}              
   if   (MeloDecayTIMER[3][47] != 0) {
	     MeloDecayTIMER[3][47]--;
	  if(MeloDecayTIMER[3][47] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[3], 47, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[3], 47, 0);}}              
   if   (MeloDecayTIMER[3][48] != 0) {
	     MeloDecayTIMER[3][48]--;
	  if(MeloDecayTIMER[3][48] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[3], 48, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[3], 48, 0);}}              
   if   (MeloDecayTIMER[3][49] != 0) {
	     MeloDecayTIMER[3][49]--;
	  if(MeloDecayTIMER[3][49] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[3], 49, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[3], 49, 0);}}              
   if   (MeloDecayTIMER[3][50] != 0) {
	     MeloDecayTIMER[3][50]--;
	  if(MeloDecayTIMER[3][50] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[3], 50, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[3], 50, 0);}}              
   if   (MeloDecayTIMER[3][51] != 0) {
	     MeloDecayTIMER[3][51]--;
	  if(MeloDecayTIMER[3][51] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[3], 51, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[3], 51, 0);}}              
   if   (MeloDecayTIMER[3][52] != 0) {
	     MeloDecayTIMER[3][52]--;
	  if(MeloDecayTIMER[3][52] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[3], 52, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[3], 52, 0);}}    
   if   (MeloDecayTIMER[3][53] != 0) {
	     MeloDecayTIMER[3][53]--;
	  if(MeloDecayTIMER[3][53] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[3], 53, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[3], 53, 0);}}              
   if   (MeloDecayTIMER[3][54] != 0) {
	     MeloDecayTIMER[3][54]--;
	  if(MeloDecayTIMER[3][54] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[3], 54, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[3], 54, 0);}}              
   if   (MeloDecayTIMER[3][55] != 0) {
	     MeloDecayTIMER[3][55]--;
	  if(MeloDecayTIMER[3][55] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[3], 55, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[3], 55, 0);}}              
   if   (MeloDecayTIMER[3][56] != 0) {
	     MeloDecayTIMER[3][56]--;
	  if(MeloDecayTIMER[3][56] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[3], 56, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[3], 56, 0);}}              
   if   (MeloDecayTIMER[3][57] != 0) {
	     MeloDecayTIMER[3][57]--;
	  if(MeloDecayTIMER[3][57] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[3], 57, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[3], 57, 0);}}              
   if   (MeloDecayTIMER[3][58] != 0) {
	     MeloDecayTIMER[3][58]--;
	  if(MeloDecayTIMER[3][58] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[3], 58, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[3], 58, 0);}}              
   if   (MeloDecayTIMER[3][59] != 0) {
	     MeloDecayTIMER[3][59]--;
	  if(MeloDecayTIMER[3][59] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[3], 59, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[3], 59, 0);}}              
   if   (MeloDecayTIMER[3][60] != 0) {
	     MeloDecayTIMER[3][60]--;
	  if(MeloDecayTIMER[3][60] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[3], 60, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[3], 60, 0);}}              
   if   (MeloDecayTIMER[3][61] != 0) {
	     MeloDecayTIMER[3][61]--;
	  if(MeloDecayTIMER[3][61] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[3], 61, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[3], 61, 0);}}              
   if   (MeloDecayTIMER[3][62] != 0) {
	     MeloDecayTIMER[3][62]--;
	  if(MeloDecayTIMER[3][62] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[3], 62, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[3], 62, 0);}}              
   if   (MeloDecayTIMER[3][63] != 0) {
	     MeloDecayTIMER[3][63]--;
	  if(MeloDecayTIMER[3][63] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[3], 63, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[3], 63, 0);}}              
   if   (MeloDecayTIMER[3][64] != 0) {
	     MeloDecayTIMER[3][64]--;
	  if(MeloDecayTIMER[3][64] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[3], 64, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[3], 64, 0);}}              
   if   (MeloDecayTIMER[3][65] != 0) {
	     MeloDecayTIMER[3][65]--;
	  if(MeloDecayTIMER[3][65] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[3], 65, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[3], 65, 0);}}              
   if   (MeloDecayTIMER[3][66] != 0) {
	     MeloDecayTIMER[3][66]--;
	  if(MeloDecayTIMER[3][66] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[3], 66, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[3], 66, 0);}}              
   if   (MeloDecayTIMER[3][67] != 0) {
	     MeloDecayTIMER[3][67]--;
	  if(MeloDecayTIMER[3][67] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[3], 67, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[3], 67, 0);}}              
   if   (MeloDecayTIMER[3][68] != 0) {
	     MeloDecayTIMER[3][68]--;
	  if(MeloDecayTIMER[3][68] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[3], 68, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[3], 68, 0);}}              
   if   (MeloDecayTIMER[3][69] != 0) {
	     MeloDecayTIMER[3][69]--;
	  if(MeloDecayTIMER[3][69] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[3], 69, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[3], 69, 0);}}              
   if   (MeloDecayTIMER[3][70] != 0) {
	     MeloDecayTIMER[3][70]--;
	  if(MeloDecayTIMER[3][70] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[3], 70, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[3], 70, 0);}}              
   if   (MeloDecayTIMER[3][71] != 0) {
	     MeloDecayTIMER[3][71]--;
	  if(MeloDecayTIMER[3][71] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[3], 71, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[3], 71, 0);}}              
   if   (MeloDecayTIMER[3][72] != 0) {
	     MeloDecayTIMER[3][72]--;
	  if(MeloDecayTIMER[3][72] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[3], 72, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[3], 72, 0);}}              
   if   (MeloDecayTIMER[3][73] != 0) {
	     MeloDecayTIMER[3][73]--;
	  if(MeloDecayTIMER[3][73] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[3], 73, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[3], 73, 0);}}              
   if   (MeloDecayTIMER[3][74] != 0) {
	     MeloDecayTIMER[3][74]--;
	  if(MeloDecayTIMER[3][74] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[3], 74, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[3], 74, 0);}}              
   if   (MeloDecayTIMER[3][75] != 0) {
	     MeloDecayTIMER[3][75]--;
	  if(MeloDecayTIMER[3][75] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[3], 75, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[3], 75, 0);}}              
   if   (MeloDecayTIMER[3][76] != 0) {
	     MeloDecayTIMER[3][76]--;
	  if(MeloDecayTIMER[3][76] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[3], 76, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[3], 76, 0);}}              
   if   (MeloDecayTIMER[3][77] != 0) {
	     MeloDecayTIMER[3][77]--;
	  if(MeloDecayTIMER[3][77] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[3], 77, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[3], 77, 0);}}              
   if   (MeloDecayTIMER[3][78] != 0) {
	     MeloDecayTIMER[3][78]--;
	  if(MeloDecayTIMER[3][78] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[3], 78, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[3], 78, 0);}}              
   if   (MeloDecayTIMER[3][79] != 0) {
	     MeloDecayTIMER[3][79]--;
	  if(MeloDecayTIMER[3][79] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[3], 79, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[3], 79, 0);}}              
   if   (MeloDecayTIMER[3][80] != 0) {
	     MeloDecayTIMER[3][80]--;
	  if(MeloDecayTIMER[3][80] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[3], 80, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[3], 80, 0);}}              
   if   (MeloDecayTIMER[3][81] != 0) {
	     MeloDecayTIMER[3][81]--;
	  if(MeloDecayTIMER[3][81] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[3], 81, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[3], 81, 0);}}              
   if   (MeloDecayTIMER[3][82] != 0) {
	     MeloDecayTIMER[3][82]--;
	  if(MeloDecayTIMER[3][82] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[3], 82, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[3], 82, 0);}}              
   if   (MeloDecayTIMER[3][83] != 0) {
	     MeloDecayTIMER[3][83]--;
	  if(MeloDecayTIMER[3][83] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[3], 83, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[3], 83, 0);}}              
   if   (MeloDecayTIMER[3][84] != 0) {
	     MeloDecayTIMER[3][84]--;
	  if(MeloDecayTIMER[3][84] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[3], 84, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[3], 84, 0);}}              
   if   (MeloDecayTIMER[3][85] != 0) {
	     MeloDecayTIMER[3][85]--;
	  if(MeloDecayTIMER[3][85] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[3], 85, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[3], 85, 0);}}              
   if   (MeloDecayTIMER[3][86] != 0) {
	     MeloDecayTIMER[3][86]--;
	  if(MeloDecayTIMER[3][86] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[3], 86, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[3], 86, 0);}}              
   if   (MeloDecayTIMER[3][87] != 0) {
	     MeloDecayTIMER[3][87]--;
	  if(MeloDecayTIMER[3][87] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[3], 87, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[3], 87, 0);}}              
   if   (MeloDecayTIMER[3][88] != 0) {
	     MeloDecayTIMER[3][88]--;
	  if(MeloDecayTIMER[3][88] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[3], 88, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[3], 88, 0);}}              
   if   (MeloDecayTIMER[3][89] != 0) {
	     MeloDecayTIMER[3][89]--;
	  if(MeloDecayTIMER[3][89] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[3], 89, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[3], 89, 0);}}                    
   if   (MeloDecayTIMER[3][90] != 0) {
	     MeloDecayTIMER[3][90]--;
	  if(MeloDecayTIMER[3][90] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[3], 90, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[3], 90, 0);}}              
   if   (MeloDecayTIMER[3][91] != 0) {
	     MeloDecayTIMER[3][91]--;
	  if(MeloDecayTIMER[3][91] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[3], 91, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[3], 91, 0);}}              
   if   (MeloDecayTIMER[3][92] != 0) {
	     MeloDecayTIMER[3][92]--;
	  if(MeloDecayTIMER[3][92] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[3], 92, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[3], 92, 0);}}              
   if   (MeloDecayTIMER[3][93] != 0) {
	     MeloDecayTIMER[3][93]--;
	  if(MeloDecayTIMER[3][93] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[3], 93, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[3], 93, 0);}}   
   if   (MeloDecayTIMER[3][94] != 0) {
	     MeloDecayTIMER[3][94]--;
	  if(MeloDecayTIMER[3][94] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[3], 94, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[3], 94, 0);}}               
   if   (MeloDecayTIMER[3][95] != 0) {
	     MeloDecayTIMER[3][95]--;
	  if(MeloDecayTIMER[3][95] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[3], 95, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[3], 95, 0);}}              
   if   (MeloDecayTIMER[3][96] != 0) {
	     MeloDecayTIMER[3][96]--;
	  if(MeloDecayTIMER[3][96] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[3], 96, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[3], 96, 0);}}              
   if   (MeloDecayTIMER[3][97] != 0) {
	     MeloDecayTIMER[3][97]--;
	  if(MeloDecayTIMER[3][97] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[3], 97, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[3], 97, 0);}}              
   if   (MeloDecayTIMER[3][98] != 0) {
	     MeloDecayTIMER[3][98]--;
	  if(MeloDecayTIMER[3][98] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[3], 98, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[3], 98, 0);}}              
   if   (MeloDecayTIMER[3][99] != 0) {
	     MeloDecayTIMER[3][99]--;
	  if(MeloDecayTIMER[3][99] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[3], 99, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[3], 99, 0);}}              
   if   (MeloDecayTIMER[3][100] != 0) {
	     MeloDecayTIMER[3][100]--;
	  if(MeloDecayTIMER[3][100] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[3], 100, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[3], 100, 0);}}              
   if   (MeloDecayTIMER[3][101] != 0) {
	     MeloDecayTIMER[3][101]--;
	  if(MeloDecayTIMER[3][101] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[3], 101, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[3], 101, 0);}}              
   if   (MeloDecayTIMER[3][102] != 0) {
	     MeloDecayTIMER[3][102]--;
	  if(MeloDecayTIMER[3][102] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[3], 102, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[3], 102, 0);}}              
   if   (MeloDecayTIMER[3][103] != 0) {
	     MeloDecayTIMER[3][103]--;
	  if(MeloDecayTIMER[3][103] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[3], 103, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[3], 103, 0);}}              
   if   (MeloDecayTIMER[3][104] != 0) {
	     MeloDecayTIMER[3][104]--;
	  if(MeloDecayTIMER[3][104] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[3], 104, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[3], 104, 0);}}              
   if   (MeloDecayTIMER[3][105] != 0) {
	     MeloDecayTIMER[3][105]--;
	  if(MeloDecayTIMER[3][105] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[3], 105, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[3], 105, 0);}}              
   if   (MeloDecayTIMER[3][106] != 0) {
	     MeloDecayTIMER[3][106]--;
	  if(MeloDecayTIMER[3][106] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[3], 106, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[3], 106, 0);}}              
   if   (MeloDecayTIMER[3][107] != 0) {
	     MeloDecayTIMER[3][107]--;
	  if(MeloDecayTIMER[3][107] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[3], 107, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[3], 107, 0);}}              
   if   (MeloDecayTIMER[3][108] != 0) {
	     MeloDecayTIMER[3][108]--;
	  if(MeloDecayTIMER[3][108] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[3], 108, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[3], 108, 0);}}              
   if   (MeloDecayTIMER[3][109] != 0) {
	     MeloDecayTIMER[3][109]--;
	  if(MeloDecayTIMER[3][109] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[3], 109, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[3], 109, 0);}}              
   if   (MeloDecayTIMER[3][110] != 0) {
	     MeloDecayTIMER[3][110]--;
	  if(MeloDecayTIMER[3][110] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[3], 110, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[3], 110, 0);}}              
   if   (MeloDecayTIMER[3][111] != 0) {
	     MeloDecayTIMER[3][111]--;
	  if(MeloDecayTIMER[3][111] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[3], 111, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[3], 111, 0);}}              
   if   (MeloDecayTIMER[3][112] != 0) {
	     MeloDecayTIMER[3][112]--;
	  if(MeloDecayTIMER[3][112] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[3], 112, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[3], 112, 0);}}              
   if   (MeloDecayTIMER[3][113] != 0) {
	     MeloDecayTIMER[3][113]--;
	  if(MeloDecayTIMER[3][113] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[3], 113, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[3], 113, 0);}}              
   if   (MeloDecayTIMER[3][114] != 0) {
	     MeloDecayTIMER[3][114]--;
	  if(MeloDecayTIMER[3][114] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[3], 114, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[3], 114, 0);}}              
   if   (MeloDecayTIMER[3][115] != 0) {
	     MeloDecayTIMER[3][115]--;
	  if(MeloDecayTIMER[3][115] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[3], 115, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[3], 115, 0);}}              
   if   (MeloDecayTIMER[3][116] != 0) {
	     MeloDecayTIMER[3][116]--;
	  if(MeloDecayTIMER[3][116] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[3], 116, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[3], 116, 0);}}              
   if   (MeloDecayTIMER[3][117] != 0) {
	     MeloDecayTIMER[3][117]--;
	  if(MeloDecayTIMER[3][117] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[3], 117, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[3], 117, 0);}}              
   if   (MeloDecayTIMER[3][118] != 0) {
	     MeloDecayTIMER[3][118]--;
	  if(MeloDecayTIMER[3][118] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[3], 118, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[3], 118, 0);}}              
   if   (MeloDecayTIMER[3][119] != 0) {
	     MeloDecayTIMER[3][119]--;
	  if(MeloDecayTIMER[3][119] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[3], 119, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[3], 119, 0);}}              
   if   (MeloDecayTIMER[3][120] != 0) {
	     MeloDecayTIMER[3][120]--;
	  if(MeloDecayTIMER[3][120] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[3], 120, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[3], 120, 0);}}              
   if   (MeloDecayTIMER[3][121] != 0) {
	     MeloDecayTIMER[3][121]--;
	  if(MeloDecayTIMER[3][121] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[3], 121, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[3], 121, 0);}}              
   if   (MeloDecayTIMER[3][122] != 0) {
	     MeloDecayTIMER[3][122]--;
	  if(MeloDecayTIMER[3][122] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[3], 122, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[3], 122, 0);}}              
   if   (MeloDecayTIMER[3][123] != 0) {
	     MeloDecayTIMER[3][123]--;
	  if(MeloDecayTIMER[3][23] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[3], 123, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[3], 123, 0);}}              
   if   (MeloDecayTIMER[3][124] != 0) {
	     MeloDecayTIMER[3][124]--;
	  if(MeloDecayTIMER[3][124] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[3], 124, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[3], 124, 0);}}              
   if   (MeloDecayTIMER[3][125] != 0) {
	     MeloDecayTIMER[3][125]--;
	  if(MeloDecayTIMER[3][125] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[3], 125, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[3], 125, 0);}}              
   if   (MeloDecayTIMER[3][126] != 0) {
	     MeloDecayTIMER[3][126]--;
	  if(MeloDecayTIMER[3][126] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[3], 126, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[3], 126, 0);}}              
   if   (MeloDecayTIMER[3][127] != 0) {
	     MeloDecayTIMER[3][127]--;
	  if(MeloDecayTIMER[3][127] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[3], 127, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[3], 127, 0);}}                                       
}//End While
}//End TICK 0 >>> 1ms Task...

static void TASK_Midi_Decay4(void *pvParameters){  //Send Note OFFs after a while
   portTickType xLastExecutionTime;
   xLastExecutionTime = xTaskGetTickCount();       // Initialise the xLastExecutionTime variable on task entry

  while( 1 ) {
    vTaskDelayUntil(&xLastExecutionTime, 1 / portTICK_RATE_MS);
    
   if   (MeloDecayTIMER[4][1] != 0) {
	     MeloDecayTIMER[4][1]--;
	  if(MeloDecayTIMER[4][1] == 0) {
		   MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[4], 1, 0); //Port, Chn, Note, Velocity 
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[4], 1, 0);}}  
   if   (MeloDecayTIMER[4][2] != 0) {
	     MeloDecayTIMER[4][2]--;
	  if(MeloDecayTIMER[4][2] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[4], 2, 0); //Port, Chn, Note, Velocity 
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[4], 2, 0);}}   
   if   (MeloDecayTIMER[4][3] != 0) {
	     MeloDecayTIMER[4][3]--;
	  if(MeloDecayTIMER[4][3] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[4], 3, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[4], 3, 0);}}
   if   (MeloDecayTIMER[4][4] != 0) {
	     MeloDecayTIMER[4][4]--;
	  if(MeloDecayTIMER[4][4] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[4], 4, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[4], 4, 0);}} 
   if   (MeloDecayTIMER[4][5] != 0) {
	     MeloDecayTIMER[4][5]--;
	  if(MeloDecayTIMER[4][5] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[4], 5, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[4], 5, 0);}} 
   if   (MeloDecayTIMER[4][6] != 0) {
	     MeloDecayTIMER[4][6]--;
	  if(MeloDecayTIMER[4][6] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[4], 6, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[4], 6, 0);}} 
   if   (MeloDecayTIMER[4][7] != 0) {
	     MeloDecayTIMER[4][7]--;
	  if(MeloDecayTIMER[4][7] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[4], 7, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[4], 7, 0);}}   
   if   (MeloDecayTIMER[4][8] != 0) {
	     MeloDecayTIMER[4][8]--;
	  if(MeloDecayTIMER[4][8] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[4], 8, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[4], 8, 0);}}   
   if   (MeloDecayTIMER[4][9] != 0) {
	     MeloDecayTIMER[4][9]--;
	  if(MeloDecayTIMER[4][9] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[4], 9, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[4], 9, 0);}}   
   if   (MeloDecayTIMER[4][10] != 0) {
	     MeloDecayTIMER[4][10]--;
	  if(MeloDecayTIMER[4][10] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[4], 10, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[4], 10, 0);}}   
   if   (MeloDecayTIMER[4][11] != 0) {
	     MeloDecayTIMER[4][11]--;
	  if(MeloDecayTIMER[4][11] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[4], 11, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[4], 11, 0);}}   
   if   (MeloDecayTIMER[4][12] != 0) {
	     MeloDecayTIMER[4][12]--;
	  if(MeloDecayTIMER[4][12] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[4], 12, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[4], 12, 0);}}   
   if   (MeloDecayTIMER[4][13] != 0) {
	     MeloDecayTIMER[4][13]--;
	  if(MeloDecayTIMER[4][13] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[4], 13, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[4], 13, 0);}}   
   if   (MeloDecayTIMER[4][14] != 0) {
	     MeloDecayTIMER[4][14]--;
	  if(MeloDecayTIMER[4][14] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[4], 14, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[4], 14, 0);}}   
   if   (MeloDecayTIMER[4][15] != 0) {
	     MeloDecayTIMER[4][15]--;
	  if(MeloDecayTIMER[4][15] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[4], 15, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[4], 15, 0);}}   
   if   (MeloDecayTIMER[4][16] != 0) {
	     MeloDecayTIMER[4][16]--;
	  if(MeloDecayTIMER[4][16] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[4], 16, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[4], 16, 0);}}   
   if   (MeloDecayTIMER[4][17] != 0) {
	     MeloDecayTIMER[4][17]--;
	  if(MeloDecayTIMER[4][17] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[4], 17, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[4], 17, 0);}}   
   if   (MeloDecayTIMER[4][18] != 0) {
	     MeloDecayTIMER[4][18]--;
	  if(MeloDecayTIMER[4][18] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[4], 18, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[4], 18, 0);}}   
   if   (MeloDecayTIMER[4][19] != 0) {
	     MeloDecayTIMER[4][19]--;
	  if(MeloDecayTIMER[4][19] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[4], 19, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[4], 19, 0);}}   
   if   (MeloDecayTIMER[4][20] != 0) {
	     MeloDecayTIMER[4][20]--;
	  if(MeloDecayTIMER[4][20] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[4], 20, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[4], 20, 0);}}   
   if   (MeloDecayTIMER[4][21] != 0) {
	     MeloDecayTIMER[4][21]--;
	  if(MeloDecayTIMER[4][21] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[4], 21, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[4], 21, 0);}}   
   if   (MeloDecayTIMER[4][22] != 0) {
	     MeloDecayTIMER[4][22]--;
	  if(MeloDecayTIMER[4][22] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[4], 22, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[4], 22, 0);}}   
   if   (MeloDecayTIMER[4][23] != 0) {
	     MeloDecayTIMER[4][23]--;
	  if(MeloDecayTIMER[4][23] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[4], 23, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[4], 23, 0);}}   
   if   (MeloDecayTIMER[4][24] != 0) {
	     MeloDecayTIMER[4][24]--;
	  if(MeloDecayTIMER[4][24] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[4], 24, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[4], 24, 0);}}   
   if   (MeloDecayTIMER[4][25] != 0) {
	     MeloDecayTIMER[4][25]--;
	  if(MeloDecayTIMER[4][25] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[4], 25, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[4], 25, 0);}}   
   if   (MeloDecayTIMER[4][26] != 0) {
	     MeloDecayTIMER[4][26]--;
	  if(MeloDecayTIMER[4][26] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[4], 26, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[4], 26, 0);}}   
   if   (MeloDecayTIMER[4][27] != 0) {
	     MeloDecayTIMER[4][27]--;
	  if(MeloDecayTIMER[4][27] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[4], 27, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[4], 27, 0);}}   
   if   (MeloDecayTIMER[4][28] != 0) {
	     MeloDecayTIMER[4][28]--;
	  if(MeloDecayTIMER[4][28] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[4], 28, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[4], 28, 0);}}   
   if   (MeloDecayTIMER[4][29] != 0) {
	     MeloDecayTIMER[4][29]--;
	  if(MeloDecayTIMER[4][29] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[4], 29, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[4], 29, 0);}}   
   if   (MeloDecayTIMER[4][30] != 0) {
	     MeloDecayTIMER[4][30]--;
	  if(MeloDecayTIMER[4][30] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[4], 30, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[4], 30, 0);}}   
   if   (MeloDecayTIMER[4][31] != 0) {
	     MeloDecayTIMER[4][31]--;
	  if(MeloDecayTIMER[4][31] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[4], 31, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[4], 31, 0);}}   
   if   (MeloDecayTIMER[4][32] != 0) {
	     MeloDecayTIMER[4][32]--;
	  if(MeloDecayTIMER[4][32] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[4], 32, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[4], 32, 0);}}   
   if   (MeloDecayTIMER[4][33] != 0) {
	     MeloDecayTIMER[4][33]--;
	  if(MeloDecayTIMER[4][33] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[4], 33, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[4], 33, 0);}}   
   if   (MeloDecayTIMER[4][34] != 0) {
	     MeloDecayTIMER[4][34]--;
	  if(MeloDecayTIMER[4][34] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[4], 34, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[4], 34, 0);}}   
   if   (MeloDecayTIMER[4][35] != 0) {
	     MeloDecayTIMER[4][35]--;
	  if(MeloDecayTIMER[4][35] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[4], 35, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[4], 35, 0);}}   
   if   (MeloDecayTIMER[4][36] != 0) {
	     MeloDecayTIMER[4][36]--;
	  if(MeloDecayTIMER[4][36] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[4], 36, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[4], 36, 0);}}   
   if   (MeloDecayTIMER[4][37] != 0) {
	     MeloDecayTIMER[4][37]--;
	  if(MeloDecayTIMER[4][37] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[4], 37, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[4], 37, 0);}}   
   if   (MeloDecayTIMER[4][38] != 0) {
	     MeloDecayTIMER[4][38]--;
	  if(MeloDecayTIMER[4][38] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[4], 38, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[4], 38, 0);}}         
   if   (MeloDecayTIMER[4][39] != 0) {
	     MeloDecayTIMER[4][39]--;
	  if(MeloDecayTIMER[4][39] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[4], 39, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[4], 39, 0);}}              
   if   (MeloDecayTIMER[4][40] != 0) {
	     MeloDecayTIMER[4][40]--;
	  if(MeloDecayTIMER[4][40] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[4], 40, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[4], 40, 0);}}              
   if   (MeloDecayTIMER[4][41] != 0) {
	     MeloDecayTIMER[4][41]--;
	  if(MeloDecayTIMER[4][41] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[4], 41, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[4], 41, 0);}}              
   if   (MeloDecayTIMER[4][42] != 0) {
	     MeloDecayTIMER[4][42]--;
	  if(MeloDecayTIMER[4][42] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[4], 42, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[4], 42, 0);}}             
   if   (MeloDecayTIMER[4][43] != 0) {
	     MeloDecayTIMER[4][43]--;
	  if(MeloDecayTIMER[4][43] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[4], 43, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[4], 43, 0);}}              
   if   (MeloDecayTIMER[4][44] != 0) {
	     MeloDecayTIMER[4][44]--;
	  if(MeloDecayTIMER[4][44] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[4], 44, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[4], 44, 0);}}              
   if   (MeloDecayTIMER[4][45] != 0) {
	     MeloDecayTIMER[4][45]--;
	  if(MeloDecayTIMER[4][45] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[4], 45, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[4], 45, 0);}}              
   if   (MeloDecayTIMER[4][46] != 0) {
	     MeloDecayTIMER[4][46]--;
	  if(MeloDecayTIMER[4][46] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[4], 46, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[4], 46, 0);}}              
   if   (MeloDecayTIMER[4][47] != 0) {
	     MeloDecayTIMER[4][47]--;
	  if(MeloDecayTIMER[4][47] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[4], 47, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[4], 47, 0);}}              
   if   (MeloDecayTIMER[4][48] != 0) {
	     MeloDecayTIMER[4][48]--;
	  if(MeloDecayTIMER[4][48] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[4], 48, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[4], 48, 0);}}              
   if   (MeloDecayTIMER[4][49] != 0) {
	     MeloDecayTIMER[4][49]--;
	  if(MeloDecayTIMER[4][49] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[4], 49, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[4], 49, 0);}}              
   if   (MeloDecayTIMER[4][50] != 0) {
	     MeloDecayTIMER[4][50]--;
	  if(MeloDecayTIMER[4][50] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[4], 50, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[4], 50, 0);}}              
   if   (MeloDecayTIMER[4][51] != 0) {
	     MeloDecayTIMER[4][51]--;
	  if(MeloDecayTIMER[4][51] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[4], 51, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[4], 51, 0);}}              
   if   (MeloDecayTIMER[4][52] != 0) {
	     MeloDecayTIMER[4][52]--;
	  if(MeloDecayTIMER[4][52] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[4], 52, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[4], 52, 0);}}    
   if   (MeloDecayTIMER[4][53] != 0) {
	     MeloDecayTIMER[4][53]--;
	  if(MeloDecayTIMER[4][53] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[4], 53, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[4], 53, 0);}}              
   if   (MeloDecayTIMER[4][54] != 0) {
	     MeloDecayTIMER[4][54]--;
	  if(MeloDecayTIMER[4][54] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[4], 54, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[4], 54, 0);}}              
   if   (MeloDecayTIMER[4][55] != 0) {
	     MeloDecayTIMER[4][55]--;
	  if(MeloDecayTIMER[4][55] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[4], 55, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[4], 55, 0);}}              
   if   (MeloDecayTIMER[4][56] != 0) {
	     MeloDecayTIMER[4][56]--;
	  if(MeloDecayTIMER[4][56] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[4], 56, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[4], 56, 0);}}              
   if   (MeloDecayTIMER[4][57] != 0) {
	     MeloDecayTIMER[4][57]--;
	  if(MeloDecayTIMER[4][57] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[4], 57, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[4], 57, 0);}}              
   if   (MeloDecayTIMER[4][58] != 0) {
	     MeloDecayTIMER[4][58]--;
	  if(MeloDecayTIMER[4][58] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[4], 58, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[4], 58, 0);}}              
   if   (MeloDecayTIMER[4][59] != 0) {
	     MeloDecayTIMER[4][59]--;
	  if(MeloDecayTIMER[4][59] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[4], 59, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[4], 59, 0);}}              
   if   (MeloDecayTIMER[4][60] != 0) {
	     MeloDecayTIMER[4][60]--;
	  if(MeloDecayTIMER[4][60] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[4], 60, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[4], 60, 0);}}              
   if   (MeloDecayTIMER[4][61] != 0) {
	     MeloDecayTIMER[4][61]--;
	  if(MeloDecayTIMER[4][61] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[4], 61, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[4], 61, 0);}}              
   if   (MeloDecayTIMER[4][62] != 0) {
	     MeloDecayTIMER[4][62]--;
	  if(MeloDecayTIMER[4][62] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[4], 62, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[4], 62, 0);}}              
   if   (MeloDecayTIMER[4][63] != 0) {
	     MeloDecayTIMER[4][63]--;
	  if(MeloDecayTIMER[4][63] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[4], 63, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[4], 63, 0);}}              
   if   (MeloDecayTIMER[4][64] != 0) {
	     MeloDecayTIMER[4][64]--;
	  if(MeloDecayTIMER[4][64] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[4], 64, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[4], 64, 0);}}              
   if   (MeloDecayTIMER[4][65] != 0) {
	     MeloDecayTIMER[4][65]--;
	  if(MeloDecayTIMER[4][65] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[4], 65, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[4], 65, 0);}}              
   if   (MeloDecayTIMER[4][66] != 0) {
	     MeloDecayTIMER[4][66]--;
	  if(MeloDecayTIMER[4][66] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[4], 66, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[4], 66, 0);}}              
   if   (MeloDecayTIMER[4][67] != 0) {
	     MeloDecayTIMER[4][67]--;
	  if(MeloDecayTIMER[4][67] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[4], 67, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[4], 67, 0);}}              
   if   (MeloDecayTIMER[4][68] != 0) {
	     MeloDecayTIMER[4][68]--;
	  if(MeloDecayTIMER[4][68] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[4], 68, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[4], 68, 0);}}              
   if   (MeloDecayTIMER[4][69] != 0) {
	     MeloDecayTIMER[4][69]--;
	  if(MeloDecayTIMER[4][69] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[4], 69, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[4], 69, 0);}}              
   if   (MeloDecayTIMER[4][70] != 0) {
	     MeloDecayTIMER[4][70]--;
	  if(MeloDecayTIMER[4][70] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[4], 70, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[4], 70, 0);}}              
   if   (MeloDecayTIMER[4][71] != 0) {
	     MeloDecayTIMER[4][71]--;
	  if(MeloDecayTIMER[4][71] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[4], 71, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[4], 71, 0);}}              
   if   (MeloDecayTIMER[4][72] != 0) {
	     MeloDecayTIMER[4][72]--;
	  if(MeloDecayTIMER[4][72] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[4], 72, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[4], 72, 0);}}              
   if   (MeloDecayTIMER[4][73] != 0) {
	     MeloDecayTIMER[4][73]--;
	  if(MeloDecayTIMER[4][73] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[4], 73, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[4], 73, 0);}}              
   if   (MeloDecayTIMER[4][74] != 0) {
	     MeloDecayTIMER[4][74]--;
	  if(MeloDecayTIMER[4][74] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[4], 74, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[4], 74, 0);}}              
   if   (MeloDecayTIMER[4][75] != 0) {
	     MeloDecayTIMER[4][75]--;
	  if(MeloDecayTIMER[4][75] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[4], 75, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[4], 75, 0);}}              
   if   (MeloDecayTIMER[4][76] != 0) {
	     MeloDecayTIMER[4][76]--;
	  if(MeloDecayTIMER[4][76] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[4], 76, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[4], 76, 0);}}              
   if   (MeloDecayTIMER[4][77] != 0) {
	     MeloDecayTIMER[4][77]--;
	  if(MeloDecayTIMER[4][77] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[4], 77, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[4], 77, 0);}}              
   if   (MeloDecayTIMER[4][78] != 0) {
	     MeloDecayTIMER[4][78]--;
	  if(MeloDecayTIMER[4][78] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[4], 78, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[4], 78, 0);}}              
   if   (MeloDecayTIMER[4][79] != 0) {
	     MeloDecayTIMER[4][79]--;
	  if(MeloDecayTIMER[4][79] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[4], 79, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[4], 79, 0);}}              
   if   (MeloDecayTIMER[4][80] != 0) {
	     MeloDecayTIMER[4][80]--;
	  if(MeloDecayTIMER[4][80] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[4], 80, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[4], 80, 0);}}              
   if   (MeloDecayTIMER[4][81] != 0) {
	     MeloDecayTIMER[4][81]--;
	  if(MeloDecayTIMER[4][81] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[4], 81, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[4], 81, 0);}}              
   if   (MeloDecayTIMER[4][82] != 0) {
	     MeloDecayTIMER[4][82]--;
	  if(MeloDecayTIMER[4][82] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[4], 82, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[4], 82, 0);}}              
   if   (MeloDecayTIMER[4][83] != 0) {
	     MeloDecayTIMER[4][83]--;
	  if(MeloDecayTIMER[4][83] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[4], 83, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[4], 83, 0);}}              
   if   (MeloDecayTIMER[4][84] != 0) {
	     MeloDecayTIMER[4][84]--;
	  if(MeloDecayTIMER[4][84] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[4], 84, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[4], 84, 0);}}              
   if   (MeloDecayTIMER[4][85] != 0) {
	     MeloDecayTIMER[4][85]--;
	  if(MeloDecayTIMER[4][85] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[4], 85, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[4], 85, 0);}}              
   if   (MeloDecayTIMER[4][86] != 0) {
	     MeloDecayTIMER[4][86]--;
	  if(MeloDecayTIMER[4][86] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[4], 86, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[4], 86, 0);}}              
   if   (MeloDecayTIMER[4][87] != 0) {
	     MeloDecayTIMER[4][87]--;
	  if(MeloDecayTIMER[4][87] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[4], 87, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[4], 87, 0);}}              
   if   (MeloDecayTIMER[4][88] != 0) {
	     MeloDecayTIMER[4][88]--;
	  if(MeloDecayTIMER[4][88] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[4], 88, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[4], 88, 0);}}              
   if   (MeloDecayTIMER[4][89] != 0) {
	     MeloDecayTIMER[4][89]--;
	  if(MeloDecayTIMER[4][89] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[4], 89, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[4], 89, 0);}}                    
   if   (MeloDecayTIMER[4][90] != 0) {
	     MeloDecayTIMER[4][90]--;
	  if(MeloDecayTIMER[4][90] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[4], 90, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[4], 90, 0);}}              
   if   (MeloDecayTIMER[4][91] != 0) {
	     MeloDecayTIMER[4][91]--;
	  if(MeloDecayTIMER[4][91] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[4], 91, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[4], 91, 0);}}              
   if   (MeloDecayTIMER[4][92] != 0) {
	     MeloDecayTIMER[4][92]--;
	  if(MeloDecayTIMER[4][92] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[4], 92, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[4], 92, 0);}}              
   if   (MeloDecayTIMER[4][93] != 0) {
	     MeloDecayTIMER[4][93]--;
	  if(MeloDecayTIMER[4][93] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[4], 93, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[4], 93, 0);}}   
   if   (MeloDecayTIMER[4][94] != 0) {
	     MeloDecayTIMER[4][94]--;
	  if(MeloDecayTIMER[4][94] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[4], 94, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[4], 94, 0);}}               
   if   (MeloDecayTIMER[4][95] != 0) {
	     MeloDecayTIMER[4][95]--;
	  if(MeloDecayTIMER[4][95] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[4], 95, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[4], 95, 0);}}              
   if   (MeloDecayTIMER[4][96] != 0) {
	     MeloDecayTIMER[4][96]--;
	  if(MeloDecayTIMER[4][96] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[4], 96, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[4], 96, 0);}}              
   if   (MeloDecayTIMER[4][97] != 0) {
	     MeloDecayTIMER[4][97]--;
	  if(MeloDecayTIMER[4][97] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[4], 97, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[4], 97, 0);}}              
   if   (MeloDecayTIMER[4][98] != 0) {
	     MeloDecayTIMER[4][98]--;
	  if(MeloDecayTIMER[4][98] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[4], 98, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[4], 98, 0);}}              
   if   (MeloDecayTIMER[4][99] != 0) {
	     MeloDecayTIMER[4][99]--;
	  if(MeloDecayTIMER[4][99] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[4], 99, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[4], 99, 0);}}              
   if   (MeloDecayTIMER[4][100] != 0) {
	     MeloDecayTIMER[4][100]--;
	  if(MeloDecayTIMER[4][100] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[4], 100, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[4], 100, 0);}}              
   if   (MeloDecayTIMER[4][101] != 0) {
	     MeloDecayTIMER[4][101]--;
	  if(MeloDecayTIMER[4][101] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[4], 101, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[4], 101, 0);}}              
   if   (MeloDecayTIMER[4][102] != 0) {
	     MeloDecayTIMER[4][102]--;
	  if(MeloDecayTIMER[4][102] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[4], 102, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[4], 102, 0);}}              
   if   (MeloDecayTIMER[4][103] != 0) {
	     MeloDecayTIMER[4][103]--;
	  if(MeloDecayTIMER[4][103] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[4], 103, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[4], 103, 0);}}              
   if   (MeloDecayTIMER[4][104] != 0) {
	     MeloDecayTIMER[4][104]--;
	  if(MeloDecayTIMER[4][104] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[4], 104, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[4], 104, 0);}}              
   if   (MeloDecayTIMER[4][105] != 0) {
	     MeloDecayTIMER[4][105]--;
	  if(MeloDecayTIMER[4][105] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[4], 105, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[4], 105, 0);}}              
   if   (MeloDecayTIMER[4][106] != 0) {
	     MeloDecayTIMER[4][106]--;
	  if(MeloDecayTIMER[4][106] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[4], 106, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[4], 106, 0);}}              
   if   (MeloDecayTIMER[4][107] != 0) {
	     MeloDecayTIMER[4][107]--;
	  if(MeloDecayTIMER[4][107] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[4], 107, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[4], 107, 0);}}              
   if   (MeloDecayTIMER[4][108] != 0) {
	     MeloDecayTIMER[4][108]--;
	  if(MeloDecayTIMER[4][108] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[4], 108, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[4], 108, 0);}}              
   if   (MeloDecayTIMER[4][109] != 0) {
	     MeloDecayTIMER[4][109]--;
	  if(MeloDecayTIMER[4][109] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[4], 109, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[4], 109, 0);}}              
   if   (MeloDecayTIMER[4][110] != 0) {
	     MeloDecayTIMER[4][110]--;
	  if(MeloDecayTIMER[4][110] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[4], 110, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[4], 110, 0);}}              
   if   (MeloDecayTIMER[4][111] != 0) {
	     MeloDecayTIMER[4][111]--;
	  if(MeloDecayTIMER[4][111] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[4], 111, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[4], 111, 0);}}              
   if   (MeloDecayTIMER[4][112] != 0) {
	     MeloDecayTIMER[4][112]--;
	  if(MeloDecayTIMER[4][112] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[4], 112, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[4], 112, 0);}}              
   if   (MeloDecayTIMER[4][113] != 0) {
	     MeloDecayTIMER[4][113]--;
	  if(MeloDecayTIMER[4][113] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[4], 113, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[4], 113, 0);}}              
   if   (MeloDecayTIMER[4][114] != 0) {
	     MeloDecayTIMER[4][114]--;
	  if(MeloDecayTIMER[4][114] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[4], 114, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[4], 114, 0);}}              
   if   (MeloDecayTIMER[4][115] != 0) {
	     MeloDecayTIMER[4][115]--;
	  if(MeloDecayTIMER[4][115] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[4], 115, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[4], 115, 0);}}              
   if   (MeloDecayTIMER[4][116] != 0) {
	     MeloDecayTIMER[4][116]--;
	  if(MeloDecayTIMER[4][116] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[4], 116, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[4], 116, 0);}}              
   if   (MeloDecayTIMER[4][117] != 0) {
	     MeloDecayTIMER[4][117]--;
	  if(MeloDecayTIMER[4][117] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[4], 117, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[4], 117, 0);}}              
   if   (MeloDecayTIMER[4][118] != 0) {
	     MeloDecayTIMER[4][118]--;
	  if(MeloDecayTIMER[4][118] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[4], 118, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[4], 118, 0);}}              
   if   (MeloDecayTIMER[4][119] != 0) {
	     MeloDecayTIMER[4][119]--;
	  if(MeloDecayTIMER[4][119] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[4], 119, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[4], 119, 0);}}              
   if   (MeloDecayTIMER[4][120] != 0) {
	     MeloDecayTIMER[4][120]--;
	  if(MeloDecayTIMER[4][120] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[4], 120, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[4], 120, 0);}}              
   if   (MeloDecayTIMER[4][121] != 0) {
	     MeloDecayTIMER[4][121]--;
	  if(MeloDecayTIMER[4][121] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[4], 121, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[4], 121, 0);}}              
   if   (MeloDecayTIMER[4][122] != 0) {
	     MeloDecayTIMER[4][122]--;
	  if(MeloDecayTIMER[4][122] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[4], 122, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[4], 122, 0);}}              
   if   (MeloDecayTIMER[4][123] != 0) {
	     MeloDecayTIMER[4][123]--;
	  if(MeloDecayTIMER[4][23] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[4], 123, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[4], 123, 0);}}              
   if   (MeloDecayTIMER[4][124] != 0) {
	     MeloDecayTIMER[4][124]--;
	  if(MeloDecayTIMER[4][124] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[4], 124, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[4], 124, 0);}}              
   if   (MeloDecayTIMER[4][125] != 0) {
	     MeloDecayTIMER[4][125]--;
	  if(MeloDecayTIMER[4][125] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[4], 125, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[4], 125, 0);}}              
   if   (MeloDecayTIMER[4][126] != 0) {
	     MeloDecayTIMER[4][126]--;
	  if(MeloDecayTIMER[4][126] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[4], 126, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[4], 126, 0);}}              
   if   (MeloDecayTIMER[4][127] != 0) {
	     MeloDecayTIMER[4][127]--;
	  if(MeloDecayTIMER[4][127] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[4], 127, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[4], 127, 0);}}                                       
}//End While
}//End TICK 0 >>> 1ms Task...

static void TASK_Midi_Decay5(void *pvParameters){  //Send Note OFFs after a while
   portTickType xLastExecutionTime;
   xLastExecutionTime = xTaskGetTickCount();       // Initialise the xLastExecutionTime variable on task entry

  while( 1 ) {
    vTaskDelayUntil(&xLastExecutionTime, 1 / portTICK_RATE_MS);
    
   if   (MeloDecayTIMER[5][1] != 0) {
	     MeloDecayTIMER[5][1]--;
	  if(MeloDecayTIMER[5][1] == 0) {
		   MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[5], 1, 0); //Port, Chn, Note, Velocity 
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[5], 1, 0);}}  
   if   (MeloDecayTIMER[5][2] != 0) {
	     MeloDecayTIMER[5][2]--;
	  if(MeloDecayTIMER[5][2] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[5], 2, 0); //Port, Chn, Note, Velocity 
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[5], 2, 0);}}   
   if   (MeloDecayTIMER[5][3] != 0) {
	     MeloDecayTIMER[5][3]--;
	  if(MeloDecayTIMER[5][3] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[5], 3, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[5], 3, 0);}}
   if   (MeloDecayTIMER[5][4] != 0) {
	     MeloDecayTIMER[5][4]--;
	  if(MeloDecayTIMER[5][4] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[5], 4, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[5], 4, 0);}} 
   if   (MeloDecayTIMER[5][5] != 0) {
	     MeloDecayTIMER[5][5]--;
	  if(MeloDecayTIMER[5][5] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[5], 5, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[5], 5, 0);}} 
   if   (MeloDecayTIMER[5][6] != 0) {
	     MeloDecayTIMER[5][6]--;
	  if(MeloDecayTIMER[5][6] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[5], 6, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[5], 6, 0);}} 
   if   (MeloDecayTIMER[5][7] != 0) {
	     MeloDecayTIMER[5][7]--;
	  if(MeloDecayTIMER[5][7] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[5], 7, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[5], 7, 0);}}   
   if   (MeloDecayTIMER[5][8] != 0) {
	     MeloDecayTIMER[5][8]--;
	  if(MeloDecayTIMER[5][8] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[5], 8, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[5], 8, 0);}}   
   if   (MeloDecayTIMER[5][9] != 0) {
	     MeloDecayTIMER[5][9]--;
	  if(MeloDecayTIMER[5][9] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[5], 9, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[5], 9, 0);}}   
   if   (MeloDecayTIMER[5][10] != 0) {
	     MeloDecayTIMER[5][10]--;
	  if(MeloDecayTIMER[5][10] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[5], 10, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[5], 10, 0);}}   
   if   (MeloDecayTIMER[5][11] != 0) {
	     MeloDecayTIMER[5][11]--;
	  if(MeloDecayTIMER[5][11] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[5], 11, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[5], 11, 0);}}   
   if   (MeloDecayTIMER[5][12] != 0) {
	     MeloDecayTIMER[5][12]--;
	  if(MeloDecayTIMER[5][12] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[5], 12, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[5], 12, 0);}}   
   if   (MeloDecayTIMER[5][13] != 0) {
	     MeloDecayTIMER[5][13]--;
	  if(MeloDecayTIMER[5][13] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[5], 13, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[5], 13, 0);}}   
   if   (MeloDecayTIMER[5][14] != 0) {
	     MeloDecayTIMER[5][14]--;
	  if(MeloDecayTIMER[5][14] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[5], 14, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[5], 14, 0);}}   
   if   (MeloDecayTIMER[5][15] != 0) {
	     MeloDecayTIMER[5][15]--;
	  if(MeloDecayTIMER[5][15] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[5], 15, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[5], 15, 0);}}   
   if   (MeloDecayTIMER[5][16] != 0) {
	     MeloDecayTIMER[5][16]--;
	  if(MeloDecayTIMER[5][16] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[5], 16, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[5], 16, 0);}}   
   if   (MeloDecayTIMER[5][17] != 0) {
	     MeloDecayTIMER[5][17]--;
	  if(MeloDecayTIMER[5][17] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[5], 17, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[5], 17, 0);}}   
   if   (MeloDecayTIMER[5][18] != 0) {
	     MeloDecayTIMER[5][18]--;
	  if(MeloDecayTIMER[5][18] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[5], 18, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[5], 18, 0);}}   
   if   (MeloDecayTIMER[5][19] != 0) {
	     MeloDecayTIMER[5][19]--;
	  if(MeloDecayTIMER[5][19] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[5], 19, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[5], 19, 0);}}   
   if   (MeloDecayTIMER[5][20] != 0) {
	     MeloDecayTIMER[5][20]--;
	  if(MeloDecayTIMER[5][20] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[5], 20, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[5], 20, 0);}}   
   if   (MeloDecayTIMER[5][21] != 0) {
	     MeloDecayTIMER[5][21]--;
	  if(MeloDecayTIMER[5][21] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[5], 21, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[5], 21, 0);}}   
   if   (MeloDecayTIMER[5][22] != 0) {
	     MeloDecayTIMER[5][22]--;
	  if(MeloDecayTIMER[5][22] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[5], 22, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[5], 22, 0);}}   
   if   (MeloDecayTIMER[5][23] != 0) {
	     MeloDecayTIMER[5][23]--;
	  if(MeloDecayTIMER[5][23] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[5], 23, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[5], 23, 0);}}   
   if   (MeloDecayTIMER[5][24] != 0) {
	     MeloDecayTIMER[5][24]--;
	  if(MeloDecayTIMER[5][24] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[5], 24, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[5], 24, 0);}}   
   if   (MeloDecayTIMER[5][25] != 0) {
	     MeloDecayTIMER[5][25]--;
	  if(MeloDecayTIMER[5][25] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[5], 25, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[5], 25, 0);}}   
   if   (MeloDecayTIMER[5][26] != 0) {
	     MeloDecayTIMER[5][26]--;
	  if(MeloDecayTIMER[5][26] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[5], 26, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[5], 26, 0);}}   
   if   (MeloDecayTIMER[5][27] != 0) {
	     MeloDecayTIMER[5][27]--;
	  if(MeloDecayTIMER[5][27] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[5], 27, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[5], 27, 0);}}   
   if   (MeloDecayTIMER[5][28] != 0) {
	     MeloDecayTIMER[5][28]--;
	  if(MeloDecayTIMER[5][28] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[5], 28, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[5], 28, 0);}}   
   if   (MeloDecayTIMER[5][29] != 0) {
	     MeloDecayTIMER[5][29]--;
	  if(MeloDecayTIMER[5][29] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[5], 29, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[5], 29, 0);}}   
   if   (MeloDecayTIMER[5][30] != 0) {
	     MeloDecayTIMER[5][30]--;
	  if(MeloDecayTIMER[5][30] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[5], 30, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[5], 30, 0);}}   
   if   (MeloDecayTIMER[5][31] != 0) {
	     MeloDecayTIMER[5][31]--;
	  if(MeloDecayTIMER[5][31] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[5], 31, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[5], 31, 0);}}   
   if   (MeloDecayTIMER[5][32] != 0) {
	     MeloDecayTIMER[5][32]--;
	  if(MeloDecayTIMER[5][32] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[5], 32, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[5], 32, 0);}}   
   if   (MeloDecayTIMER[5][33] != 0) {
	     MeloDecayTIMER[5][33]--;
	  if(MeloDecayTIMER[5][33] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[5], 33, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[5], 33, 0);}}   
   if   (MeloDecayTIMER[5][34] != 0) {
	     MeloDecayTIMER[5][34]--;
	  if(MeloDecayTIMER[5][34] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[5], 34, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[5], 34, 0);}}   
   if   (MeloDecayTIMER[5][35] != 0) {
	     MeloDecayTIMER[5][35]--;
	  if(MeloDecayTIMER[5][35] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[5], 35, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[5], 35, 0);}}   
   if   (MeloDecayTIMER[5][36] != 0) {
	     MeloDecayTIMER[5][36]--;
	  if(MeloDecayTIMER[5][36] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[5], 36, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[5], 36, 0);}}   
   if   (MeloDecayTIMER[5][37] != 0) {
	     MeloDecayTIMER[5][37]--;
	  if(MeloDecayTIMER[5][37] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[5], 37, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[5], 37, 0);}}   
   if   (MeloDecayTIMER[5][38] != 0) {
	     MeloDecayTIMER[5][38]--;
	  if(MeloDecayTIMER[5][38] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[5], 38, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[5], 38, 0);}}         
   if   (MeloDecayTIMER[5][39] != 0) {
	     MeloDecayTIMER[5][39]--;
	  if(MeloDecayTIMER[5][39] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[5], 39, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[5], 39, 0);}}              
   if   (MeloDecayTIMER[5][40] != 0) {
	     MeloDecayTIMER[5][40]--;
	  if(MeloDecayTIMER[5][40] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[5], 40, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[5], 40, 0);}}              
   if   (MeloDecayTIMER[5][41] != 0) {
	     MeloDecayTIMER[5][41]--;
	  if(MeloDecayTIMER[5][41] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[5], 41, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[5], 41, 0);}}              
   if   (MeloDecayTIMER[5][42] != 0) {
	     MeloDecayTIMER[5][42]--;
	  if(MeloDecayTIMER[5][42] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[5], 42, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[5], 42, 0);}}             
   if   (MeloDecayTIMER[5][43] != 0) {
	     MeloDecayTIMER[5][43]--;
	  if(MeloDecayTIMER[5][43] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[5], 43, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[5], 43, 0);}}              
   if   (MeloDecayTIMER[5][44] != 0) {
	     MeloDecayTIMER[5][44]--;
	  if(MeloDecayTIMER[5][44] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[5], 44, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[5], 44, 0);}}              
   if   (MeloDecayTIMER[5][45] != 0) {
	     MeloDecayTIMER[5][45]--;
	  if(MeloDecayTIMER[5][45] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[5], 45, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[5], 45, 0);}}              
   if   (MeloDecayTIMER[5][46] != 0) {
	     MeloDecayTIMER[5][46]--;
	  if(MeloDecayTIMER[5][46] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[5], 46, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[5], 46, 0);}}              
   if   (MeloDecayTIMER[5][47] != 0) {
	     MeloDecayTIMER[5][47]--;
	  if(MeloDecayTIMER[5][47] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[5], 47, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[5], 47, 0);}}              
   if   (MeloDecayTIMER[5][48] != 0) {
	     MeloDecayTIMER[5][48]--;
	  if(MeloDecayTIMER[5][48] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[5], 48, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[5], 48, 0);}}              
   if   (MeloDecayTIMER[5][49] != 0) {
	     MeloDecayTIMER[5][49]--;
	  if(MeloDecayTIMER[5][49] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[5], 49, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[5], 49, 0);}}              
   if   (MeloDecayTIMER[5][50] != 0) {
	     MeloDecayTIMER[5][50]--;
	  if(MeloDecayTIMER[5][50] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[5], 50, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[5], 50, 0);}}              
   if   (MeloDecayTIMER[5][51] != 0) {
	     MeloDecayTIMER[5][51]--;
	  if(MeloDecayTIMER[5][51] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[5], 51, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[5], 51, 0);}}              
   if   (MeloDecayTIMER[5][52] != 0) {
	     MeloDecayTIMER[5][52]--;
	  if(MeloDecayTIMER[5][52] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[5], 52, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[5], 52, 0);}}    
   if   (MeloDecayTIMER[5][53] != 0) {
	     MeloDecayTIMER[5][53]--;
	  if(MeloDecayTIMER[5][53] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[5], 53, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[5], 53, 0);}}              
   if   (MeloDecayTIMER[5][54] != 0) {
	     MeloDecayTIMER[5][54]--;
	  if(MeloDecayTIMER[5][54] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[5], 54, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[5], 54, 0);}}              
   if   (MeloDecayTIMER[5][55] != 0) {
	     MeloDecayTIMER[5][55]--;
	  if(MeloDecayTIMER[5][55] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[5], 55, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[5], 55, 0);}}              
   if   (MeloDecayTIMER[5][56] != 0) {
	     MeloDecayTIMER[5][56]--;
	  if(MeloDecayTIMER[5][56] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[5], 56, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[5], 56, 0);}}              
   if   (MeloDecayTIMER[5][57] != 0) {
	     MeloDecayTIMER[5][57]--;
	  if(MeloDecayTIMER[5][57] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[5], 57, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[5], 57, 0);}}              
   if   (MeloDecayTIMER[5][58] != 0) {
	     MeloDecayTIMER[5][58]--;
	  if(MeloDecayTIMER[5][58] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[5], 58, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[5], 58, 0);}}              
   if   (MeloDecayTIMER[5][59] != 0) {
	     MeloDecayTIMER[5][59]--;
	  if(MeloDecayTIMER[5][59] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[5], 59, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[5], 59, 0);}}              
   if   (MeloDecayTIMER[5][60] != 0) {
	     MeloDecayTIMER[5][60]--;
	  if(MeloDecayTIMER[5][60] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[5], 60, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[5], 60, 0);}}              
   if   (MeloDecayTIMER[5][61] != 0) {
	     MeloDecayTIMER[5][61]--;
	  if(MeloDecayTIMER[5][61] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[5], 61, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[5], 61, 0);}}              
   if   (MeloDecayTIMER[5][62] != 0) {
	     MeloDecayTIMER[5][62]--;
	  if(MeloDecayTIMER[5][62] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[5], 62, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[5], 62, 0);}}              
   if   (MeloDecayTIMER[5][63] != 0) {
	     MeloDecayTIMER[5][63]--;
	  if(MeloDecayTIMER[5][63] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[5], 63, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[5], 63, 0);}}              
   if   (MeloDecayTIMER[5][64] != 0) {
	     MeloDecayTIMER[5][64]--;
	  if(MeloDecayTIMER[5][64] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[5], 64, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[5], 64, 0);}}              
   if   (MeloDecayTIMER[5][65] != 0) {
	     MeloDecayTIMER[5][65]--;
	  if(MeloDecayTIMER[5][65] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[5], 65, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[5], 65, 0);}}              
   if   (MeloDecayTIMER[5][66] != 0) {
	     MeloDecayTIMER[5][66]--;
	  if(MeloDecayTIMER[5][66] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[5], 66, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[5], 66, 0);}}              
   if   (MeloDecayTIMER[5][67] != 0) {
	     MeloDecayTIMER[5][67]--;
	  if(MeloDecayTIMER[5][67] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[5], 67, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[5], 67, 0);}}              
   if   (MeloDecayTIMER[5][68] != 0) {
	     MeloDecayTIMER[5][68]--;
	  if(MeloDecayTIMER[5][68] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[5], 68, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[5], 68, 0);}}              
   if   (MeloDecayTIMER[5][69] != 0) {
	     MeloDecayTIMER[5][69]--;
	  if(MeloDecayTIMER[5][69] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[5], 69, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[5], 69, 0);}}              
   if   (MeloDecayTIMER[5][70] != 0) {
	     MeloDecayTIMER[5][70]--;
	  if(MeloDecayTIMER[5][70] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[5], 70, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[5], 70, 0);}}              
   if   (MeloDecayTIMER[5][71] != 0) {
	     MeloDecayTIMER[5][71]--;
	  if(MeloDecayTIMER[5][71] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[5], 71, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[5], 71, 0);}}              
   if   (MeloDecayTIMER[5][72] != 0) {
	     MeloDecayTIMER[5][72]--;
	  if(MeloDecayTIMER[5][72] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[5], 72, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[5], 72, 0);}}              
   if   (MeloDecayTIMER[5][73] != 0) {
	     MeloDecayTIMER[5][73]--;
	  if(MeloDecayTIMER[5][73] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[5], 73, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[5], 73, 0);}}              
   if   (MeloDecayTIMER[5][74] != 0) {
	     MeloDecayTIMER[5][74]--;
	  if(MeloDecayTIMER[5][74] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[5], 74, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[5], 74, 0);}}              
   if   (MeloDecayTIMER[5][75] != 0) {
	     MeloDecayTIMER[5][75]--;
	  if(MeloDecayTIMER[5][75] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[5], 75, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[5], 75, 0);}}              
   if   (MeloDecayTIMER[5][76] != 0) {
	     MeloDecayTIMER[5][76]--;
	  if(MeloDecayTIMER[5][76] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[5], 76, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[5], 76, 0);}}              
   if   (MeloDecayTIMER[5][77] != 0) {
	     MeloDecayTIMER[5][77]--;
	  if(MeloDecayTIMER[5][77] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[5], 77, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[5], 77, 0);}}              
   if   (MeloDecayTIMER[5][78] != 0) {
	     MeloDecayTIMER[5][78]--;
	  if(MeloDecayTIMER[5][78] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[5], 78, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[5], 78, 0);}}              
   if   (MeloDecayTIMER[5][79] != 0) {
	     MeloDecayTIMER[5][79]--;
	  if(MeloDecayTIMER[5][79] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[5], 79, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[5], 79, 0);}}              
   if   (MeloDecayTIMER[5][80] != 0) {
	     MeloDecayTIMER[5][80]--;
	  if(MeloDecayTIMER[5][80] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[5], 80, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[5], 80, 0);}}              
   if   (MeloDecayTIMER[5][81] != 0) {
	     MeloDecayTIMER[5][81]--;
	  if(MeloDecayTIMER[5][81] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[5], 81, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[5], 81, 0);}}              
   if   (MeloDecayTIMER[5][82] != 0) {
	     MeloDecayTIMER[5][82]--;
	  if(MeloDecayTIMER[5][82] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[5], 82, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[5], 82, 0);}}              
   if   (MeloDecayTIMER[5][83] != 0) {
	     MeloDecayTIMER[5][83]--;
	  if(MeloDecayTIMER[5][83] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[5], 83, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[5], 83, 0);}}              
   if   (MeloDecayTIMER[5][84] != 0) {
	     MeloDecayTIMER[5][84]--;
	  if(MeloDecayTIMER[5][84] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[5], 84, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[5], 84, 0);}}              
   if   (MeloDecayTIMER[5][85] != 0) {
	     MeloDecayTIMER[5][85]--;
	  if(MeloDecayTIMER[5][85] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[5], 85, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[5], 85, 0);}}              
   if   (MeloDecayTIMER[5][86] != 0) {
	     MeloDecayTIMER[5][86]--;
	  if(MeloDecayTIMER[5][86] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[5], 86, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[5], 86, 0);}}              
   if   (MeloDecayTIMER[5][87] != 0) {
	     MeloDecayTIMER[5][87]--;
	  if(MeloDecayTIMER[5][87] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[5], 87, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[5], 87, 0);}}              
   if   (MeloDecayTIMER[5][88] != 0) {
	     MeloDecayTIMER[5][88]--;
	  if(MeloDecayTIMER[5][88] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[5], 88, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[5], 88, 0);}}              
   if   (MeloDecayTIMER[5][89] != 0) {
	     MeloDecayTIMER[5][89]--;
	  if(MeloDecayTIMER[5][89] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[5], 89, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[5], 89, 0);}}                    
   if   (MeloDecayTIMER[5][90] != 0) {
	     MeloDecayTIMER[5][90]--;
	  if(MeloDecayTIMER[5][90] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[5], 90, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[5], 90, 0);}}              
   if   (MeloDecayTIMER[5][91] != 0) {
	     MeloDecayTIMER[5][91]--;
	  if(MeloDecayTIMER[5][91] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[5], 91, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[5], 91, 0);}}              
   if   (MeloDecayTIMER[5][92] != 0) {
	     MeloDecayTIMER[5][92]--;
	  if(MeloDecayTIMER[5][92] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[5], 92, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[5], 92, 0);}}              
   if   (MeloDecayTIMER[5][93] != 0) {
	     MeloDecayTIMER[5][93]--;
	  if(MeloDecayTIMER[5][93] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[5], 93, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[5], 93, 0);}}   
   if   (MeloDecayTIMER[5][94] != 0) {
	     MeloDecayTIMER[5][94]--;
	  if(MeloDecayTIMER[5][94] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[5], 94, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[5], 94, 0);}}               
   if   (MeloDecayTIMER[5][95] != 0) {
	     MeloDecayTIMER[5][95]--;
	  if(MeloDecayTIMER[5][95] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[5], 95, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[5], 95, 0);}}              
   if   (MeloDecayTIMER[5][96] != 0) {
	     MeloDecayTIMER[5][96]--;
	  if(MeloDecayTIMER[5][96] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[5], 96, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[5], 96, 0);}}              
   if   (MeloDecayTIMER[5][97] != 0) {
	     MeloDecayTIMER[5][97]--;
	  if(MeloDecayTIMER[5][97] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[5], 97, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[5], 97, 0);}}              
   if   (MeloDecayTIMER[5][98] != 0) {
	     MeloDecayTIMER[5][98]--;
	  if(MeloDecayTIMER[5][98] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[5], 98, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[5], 98, 0);}}              
   if   (MeloDecayTIMER[5][99] != 0) {
	     MeloDecayTIMER[5][99]--;
	  if(MeloDecayTIMER[5][99] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[5], 99, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[5], 99, 0);}}              
   if   (MeloDecayTIMER[5][100] != 0) {
	     MeloDecayTIMER[5][100]--;
	  if(MeloDecayTIMER[5][100] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[5], 100, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[5], 100, 0);}}              
   if   (MeloDecayTIMER[5][101] != 0) {
	     MeloDecayTIMER[5][101]--;
	  if(MeloDecayTIMER[5][101] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[5], 101, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[5], 101, 0);}}              
   if   (MeloDecayTIMER[5][102] != 0) {
	     MeloDecayTIMER[5][102]--;
	  if(MeloDecayTIMER[5][102] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[5], 102, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[5], 102, 0);}}              
   if   (MeloDecayTIMER[5][103] != 0) {
	     MeloDecayTIMER[5][103]--;
	  if(MeloDecayTIMER[5][103] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[5], 103, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[5], 103, 0);}}              
   if   (MeloDecayTIMER[5][104] != 0) {
	     MeloDecayTIMER[5][104]--;
	  if(MeloDecayTIMER[5][104] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[5], 104, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[5], 104, 0);}}              
   if   (MeloDecayTIMER[5][105] != 0) {
	     MeloDecayTIMER[5][105]--;
	  if(MeloDecayTIMER[5][105] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[5], 105, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[5], 105, 0);}}              
   if   (MeloDecayTIMER[5][106] != 0) {
	     MeloDecayTIMER[5][106]--;
	  if(MeloDecayTIMER[5][106] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[5], 106, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[5], 106, 0);}}              
   if   (MeloDecayTIMER[5][107] != 0) {
	     MeloDecayTIMER[5][107]--;
	  if(MeloDecayTIMER[5][107] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[5], 107, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[5], 107, 0);}}              
   if   (MeloDecayTIMER[5][108] != 0) {
	     MeloDecayTIMER[5][108]--;
	  if(MeloDecayTIMER[5][108] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[5], 108, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[5], 108, 0);}}              
   if   (MeloDecayTIMER[5][109] != 0) {
	     MeloDecayTIMER[5][109]--;
	  if(MeloDecayTIMER[5][109] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[5], 109, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[5], 109, 0);}}              
   if   (MeloDecayTIMER[5][110] != 0) {
	     MeloDecayTIMER[5][110]--;
	  if(MeloDecayTIMER[5][110] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[5], 110, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[5], 110, 0);}}              
   if   (MeloDecayTIMER[5][111] != 0) {
	     MeloDecayTIMER[5][111]--;
	  if(MeloDecayTIMER[5][111] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[5], 111, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[5], 111, 0);}}              
   if   (MeloDecayTIMER[5][112] != 0) {
	     MeloDecayTIMER[5][112]--;
	  if(MeloDecayTIMER[5][112] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[5], 112, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[5], 112, 0);}}              
   if   (MeloDecayTIMER[5][113] != 0) {
	     MeloDecayTIMER[5][113]--;
	  if(MeloDecayTIMER[5][113] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[5], 113, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[5], 113, 0);}}              
   if   (MeloDecayTIMER[5][114] != 0) {
	     MeloDecayTIMER[5][114]--;
	  if(MeloDecayTIMER[5][114] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[5], 114, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[5], 114, 0);}}              
   if   (MeloDecayTIMER[5][115] != 0) {
	     MeloDecayTIMER[5][115]--;
	  if(MeloDecayTIMER[5][115] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[5], 115, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[5], 115, 0);}}              
   if   (MeloDecayTIMER[5][116] != 0) {
	     MeloDecayTIMER[5][116]--;
	  if(MeloDecayTIMER[5][116] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[5], 116, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[5], 116, 0);}}              
   if   (MeloDecayTIMER[5][117] != 0) {
	     MeloDecayTIMER[5][117]--;
	  if(MeloDecayTIMER[5][117] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[5], 117, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[5], 117, 0);}}              
   if   (MeloDecayTIMER[5][118] != 0) {
	     MeloDecayTIMER[5][118]--;
	  if(MeloDecayTIMER[5][118] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[5], 118, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[5], 118, 0);}}              
   if   (MeloDecayTIMER[5][119] != 0) {
	     MeloDecayTIMER[5][119]--;
	  if(MeloDecayTIMER[5][119] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[5], 119, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[5], 119, 0);}}              
   if   (MeloDecayTIMER[5][120] != 0) {
	     MeloDecayTIMER[5][120]--;
	  if(MeloDecayTIMER[5][120] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[5], 120, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[5], 120, 0);}}              
   if   (MeloDecayTIMER[5][121] != 0) {
	     MeloDecayTIMER[5][121]--;
	  if(MeloDecayTIMER[5][121] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[5], 121, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[5], 121, 0);}}              
   if   (MeloDecayTIMER[5][122] != 0) {
	     MeloDecayTIMER[5][122]--;
	  if(MeloDecayTIMER[5][122] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[5], 122, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[5], 122, 0);}}              
   if   (MeloDecayTIMER[5][123] != 0) {
	     MeloDecayTIMER[5][123]--;
	  if(MeloDecayTIMER[5][23] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[5], 123, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[5], 123, 0);}}              
   if   (MeloDecayTIMER[5][124] != 0) {
	     MeloDecayTIMER[5][124]--;
	  if(MeloDecayTIMER[5][124] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[5], 124, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[5], 124, 0);}}              
   if   (MeloDecayTIMER[5][125] != 0) {
	     MeloDecayTIMER[5][125]--;
	  if(MeloDecayTIMER[5][125] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[5], 125, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[5], 125, 0);}}              
   if   (MeloDecayTIMER[5][126] != 0) {
	     MeloDecayTIMER[5][126]--;
	  if(MeloDecayTIMER[5][126] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[5], 126, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[5], 126, 0);}}              
   if   (MeloDecayTIMER[5][127] != 0) {
	     MeloDecayTIMER[5][127]--;
	  if(MeloDecayTIMER[5][127] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[5], 127, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[5], 127, 0);}}                                       
}//End While
}//End TICK 0 >>> 1ms Task...

static void TASK_Midi_Decay6(void *pvParameters){  //Send Note OFFs after a while
   portTickType xLastExecutionTime;
   xLastExecutionTime = xTaskGetTickCount();       // Initialise the xLastExecutionTime variable on task entry

  while( 1 ) {
    vTaskDelayUntil(&xLastExecutionTime, 1 / portTICK_RATE_MS);
    
   if   (MeloDecayTIMER[6][1] != 0) {
	     MeloDecayTIMER[6][1]--;
	  if(MeloDecayTIMER[6][1] == 0) {
		   MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[6], 1, 0); //Port, Chn, Note, Velocity 
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[6], 1, 0);}}  
   if   (MeloDecayTIMER[6][2] != 0) {
	     MeloDecayTIMER[6][2]--;
	  if(MeloDecayTIMER[6][2] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[6], 2, 0); //Port, Chn, Note, Velocity 
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[6], 2, 0);}}   
   if   (MeloDecayTIMER[6][3] != 0) {
	     MeloDecayTIMER[6][3]--;
	  if(MeloDecayTIMER[6][3] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[6], 3, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[6], 3, 0);}}
   if   (MeloDecayTIMER[6][4] != 0) {
	     MeloDecayTIMER[6][4]--;
	  if(MeloDecayTIMER[6][4] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[6], 4, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[6], 4, 0);}} 
   if   (MeloDecayTIMER[6][5] != 0) {
	     MeloDecayTIMER[6][5]--;
	  if(MeloDecayTIMER[6][5] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[6], 5, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[6], 5, 0);}} 
   if   (MeloDecayTIMER[6][6] != 0) {
	     MeloDecayTIMER[6][6]--;
	  if(MeloDecayTIMER[6][6] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[6], 6, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[6], 6, 0);}} 
   if   (MeloDecayTIMER[6][7] != 0) {
	     MeloDecayTIMER[6][7]--;
	  if(MeloDecayTIMER[6][7] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[6], 7, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[6], 7, 0);}}   
   if   (MeloDecayTIMER[6][8] != 0) {
	     MeloDecayTIMER[6][8]--;
	  if(MeloDecayTIMER[6][8] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[6], 8, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[6], 8, 0);}}   
   if   (MeloDecayTIMER[6][9] != 0) {
	     MeloDecayTIMER[6][9]--;
	  if(MeloDecayTIMER[6][9] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[6], 9, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[6], 9, 0);}}   
   if   (MeloDecayTIMER[6][10] != 0) {
	     MeloDecayTIMER[6][10]--;
	  if(MeloDecayTIMER[6][10] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[6], 10, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[6], 10, 0);}}   
   if   (MeloDecayTIMER[6][11] != 0) {
	     MeloDecayTIMER[6][11]--;
	  if(MeloDecayTIMER[6][11] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[6], 11, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[6], 11, 0);}}   
   if   (MeloDecayTIMER[6][12] != 0) {
	     MeloDecayTIMER[6][12]--;
	  if(MeloDecayTIMER[6][12] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[6], 12, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[6], 12, 0);}}   
   if   (MeloDecayTIMER[6][13] != 0) {
	     MeloDecayTIMER[6][13]--;
	  if(MeloDecayTIMER[6][13] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[6], 13, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[6], 13, 0);}}   
   if   (MeloDecayTIMER[6][14] != 0) {
	     MeloDecayTIMER[6][14]--;
	  if(MeloDecayTIMER[6][14] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[6], 14, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[6], 14, 0);}}   
   if   (MeloDecayTIMER[6][15] != 0) {
	     MeloDecayTIMER[6][15]--;
	  if(MeloDecayTIMER[6][15] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[6], 15, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[6], 15, 0);}}   
   if   (MeloDecayTIMER[6][16] != 0) {
	     MeloDecayTIMER[6][16]--;
	  if(MeloDecayTIMER[6][16] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[6], 16, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[6], 16, 0);}}   
   if   (MeloDecayTIMER[6][17] != 0) {
	     MeloDecayTIMER[6][17]--;
	  if(MeloDecayTIMER[6][17] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[6], 17, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[6], 17, 0);}}   
   if   (MeloDecayTIMER[6][18] != 0) {
	     MeloDecayTIMER[6][18]--;
	  if(MeloDecayTIMER[6][18] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[6], 18, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[6], 18, 0);}}   
   if   (MeloDecayTIMER[6][19] != 0) {
	     MeloDecayTIMER[6][19]--;
	  if(MeloDecayTIMER[6][19] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[6], 19, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[6], 19, 0);}}   
   if   (MeloDecayTIMER[6][20] != 0) {
	     MeloDecayTIMER[6][20]--;
	  if(MeloDecayTIMER[6][20] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[6], 20, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[6], 20, 0);}}   
   if   (MeloDecayTIMER[6][21] != 0) {
	     MeloDecayTIMER[6][21]--;
	  if(MeloDecayTIMER[6][21] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[6], 21, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[6], 21, 0);}}   
   if   (MeloDecayTIMER[6][22] != 0) {
	     MeloDecayTIMER[6][22]--;
	  if(MeloDecayTIMER[6][22] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[6], 22, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[6], 22, 0);}}   
   if   (MeloDecayTIMER[6][23] != 0) {
	     MeloDecayTIMER[6][23]--;
	  if(MeloDecayTIMER[6][23] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[6], 23, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[6], 23, 0);}}   
   if   (MeloDecayTIMER[6][24] != 0) {
	     MeloDecayTIMER[6][24]--;
	  if(MeloDecayTIMER[6][24] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[6], 24, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[6], 24, 0);}}   
   if   (MeloDecayTIMER[6][25] != 0) {
	     MeloDecayTIMER[6][25]--;
	  if(MeloDecayTIMER[6][25] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[6], 25, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[6], 25, 0);}}   
   if   (MeloDecayTIMER[6][26] != 0) {
	     MeloDecayTIMER[6][26]--;
	  if(MeloDecayTIMER[6][26] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[6], 26, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[6], 26, 0);}}   
   if   (MeloDecayTIMER[6][27] != 0) {
	     MeloDecayTIMER[6][27]--;
	  if(MeloDecayTIMER[6][27] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[6], 27, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[6], 27, 0);}}   
   if   (MeloDecayTIMER[6][28] != 0) {
	     MeloDecayTIMER[6][28]--;
	  if(MeloDecayTIMER[6][28] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[6], 28, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[6], 28, 0);}}   
   if   (MeloDecayTIMER[6][29] != 0) {
	     MeloDecayTIMER[6][29]--;
	  if(MeloDecayTIMER[6][29] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[6], 29, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[6], 29, 0);}}   
   if   (MeloDecayTIMER[6][30] != 0) {
	     MeloDecayTIMER[6][30]--;
	  if(MeloDecayTIMER[6][30] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[6], 30, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[6], 30, 0);}}   
   if   (MeloDecayTIMER[6][31] != 0) {
	     MeloDecayTIMER[6][31]--;
	  if(MeloDecayTIMER[6][31] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[6], 31, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[6], 31, 0);}}   
   if   (MeloDecayTIMER[6][32] != 0) {
	     MeloDecayTIMER[6][32]--;
	  if(MeloDecayTIMER[6][32] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[6], 32, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[6], 32, 0);}}   
   if   (MeloDecayTIMER[6][33] != 0) {
	     MeloDecayTIMER[6][33]--;
	  if(MeloDecayTIMER[6][33] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[6], 33, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[6], 33, 0);}}   
   if   (MeloDecayTIMER[6][34] != 0) {
	     MeloDecayTIMER[6][34]--;
	  if(MeloDecayTIMER[6][34] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[6], 34, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[6], 34, 0);}}   
   if   (MeloDecayTIMER[6][35] != 0) {
	     MeloDecayTIMER[6][35]--;
	  if(MeloDecayTIMER[6][35] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[6], 35, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[6], 35, 0);}}   
   if   (MeloDecayTIMER[6][36] != 0) {
	     MeloDecayTIMER[6][36]--;
	  if(MeloDecayTIMER[6][36] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[6], 36, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[6], 36, 0);}}   
   if   (MeloDecayTIMER[6][37] != 0) {
	     MeloDecayTIMER[6][37]--;
	  if(MeloDecayTIMER[6][37] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[6], 37, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[6], 37, 0);}}   
   if   (MeloDecayTIMER[6][38] != 0) {
	     MeloDecayTIMER[6][38]--;
	  if(MeloDecayTIMER[6][38] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[6], 38, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[6], 38, 0);}}         
   if   (MeloDecayTIMER[6][39] != 0) {
	     MeloDecayTIMER[6][39]--;
	  if(MeloDecayTIMER[6][39] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[6], 39, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[6], 39, 0);}}              
   if   (MeloDecayTIMER[6][40] != 0) {
	     MeloDecayTIMER[6][40]--;
	  if(MeloDecayTIMER[6][40] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[6], 40, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[6], 40, 0);}}              
   if   (MeloDecayTIMER[6][41] != 0) {
	     MeloDecayTIMER[6][41]--;
	  if(MeloDecayTIMER[6][41] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[6], 41, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[6], 41, 0);}}              
   if   (MeloDecayTIMER[6][42] != 0) {
	     MeloDecayTIMER[6][42]--;
	  if(MeloDecayTIMER[6][42] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[6], 42, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[6], 42, 0);}}             
   if   (MeloDecayTIMER[6][43] != 0) {
	     MeloDecayTIMER[6][43]--;
	  if(MeloDecayTIMER[6][43] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[6], 43, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[6], 43, 0);}}              
   if   (MeloDecayTIMER[6][44] != 0) {
	     MeloDecayTIMER[6][44]--;
	  if(MeloDecayTIMER[6][44] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[6], 44, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[6], 44, 0);}}              
   if   (MeloDecayTIMER[6][45] != 0) {
	     MeloDecayTIMER[6][45]--;
	  if(MeloDecayTIMER[6][45] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[6], 45, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[6], 45, 0);}}              
   if   (MeloDecayTIMER[6][46] != 0) {
	     MeloDecayTIMER[6][46]--;
	  if(MeloDecayTIMER[6][46] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[6], 46, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[6], 46, 0);}}              
   if   (MeloDecayTIMER[6][47] != 0) {
	     MeloDecayTIMER[6][47]--;
	  if(MeloDecayTIMER[6][47] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[6], 47, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[6], 47, 0);}}              
   if   (MeloDecayTIMER[6][48] != 0) {
	     MeloDecayTIMER[6][48]--;
	  if(MeloDecayTIMER[6][48] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[6], 48, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[6], 48, 0);}}              
   if   (MeloDecayTIMER[6][49] != 0) {
	     MeloDecayTIMER[6][49]--;
	  if(MeloDecayTIMER[6][49] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[6], 49, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[6], 49, 0);}}              
   if   (MeloDecayTIMER[6][50] != 0) {
	     MeloDecayTIMER[6][50]--;
	  if(MeloDecayTIMER[6][50] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[6], 50, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[6], 50, 0);}}              
   if   (MeloDecayTIMER[6][51] != 0) {
	     MeloDecayTIMER[6][51]--;
	  if(MeloDecayTIMER[6][51] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[6], 51, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[6], 51, 0);}}              
   if   (MeloDecayTIMER[6][52] != 0) {
	     MeloDecayTIMER[6][52]--;
	  if(MeloDecayTIMER[6][52] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[6], 52, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[6], 52, 0);}}    
   if   (MeloDecayTIMER[6][53] != 0) {
	     MeloDecayTIMER[6][53]--;
	  if(MeloDecayTIMER[6][53] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[6], 53, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[6], 53, 0);}}              
   if   (MeloDecayTIMER[6][54] != 0) {
	     MeloDecayTIMER[6][54]--;
	  if(MeloDecayTIMER[6][54] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[6], 54, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[6], 54, 0);}}              
   if   (MeloDecayTIMER[6][55] != 0) {
	     MeloDecayTIMER[6][55]--;
	  if(MeloDecayTIMER[6][55] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[6], 55, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[6], 55, 0);}}              
   if   (MeloDecayTIMER[6][56] != 0) {
	     MeloDecayTIMER[6][56]--;
	  if(MeloDecayTIMER[6][56] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[6], 56, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[6], 56, 0);}}              
   if   (MeloDecayTIMER[6][57] != 0) {
	     MeloDecayTIMER[6][57]--;
	  if(MeloDecayTIMER[6][57] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[6], 57, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[6], 57, 0);}}              
   if   (MeloDecayTIMER[6][58] != 0) {
	     MeloDecayTIMER[6][58]--;
	  if(MeloDecayTIMER[6][58] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[6], 58, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[6], 58, 0);}}              
   if   (MeloDecayTIMER[6][59] != 0) {
	     MeloDecayTIMER[6][59]--;
	  if(MeloDecayTIMER[6][59] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[6], 59, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[6], 59, 0);}}              
   if   (MeloDecayTIMER[6][60] != 0) {
	     MeloDecayTIMER[6][60]--;
	  if(MeloDecayTIMER[6][60] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[6], 60, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[6], 60, 0);}}              
   if   (MeloDecayTIMER[6][61] != 0) {
	     MeloDecayTIMER[6][61]--;
	  if(MeloDecayTIMER[6][61] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[6], 61, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[6], 61, 0);}}              
   if   (MeloDecayTIMER[6][62] != 0) {
	     MeloDecayTIMER[6][62]--;
	  if(MeloDecayTIMER[6][62] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[6], 62, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[6], 62, 0);}}              
   if   (MeloDecayTIMER[6][63] != 0) {
	     MeloDecayTIMER[6][63]--;
	  if(MeloDecayTIMER[6][63] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[6], 63, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[6], 63, 0);}}              
   if   (MeloDecayTIMER[6][64] != 0) {
	     MeloDecayTIMER[6][64]--;
	  if(MeloDecayTIMER[6][64] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[6], 64, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[6], 64, 0);}}              
   if   (MeloDecayTIMER[6][65] != 0) {
	     MeloDecayTIMER[6][65]--;
	  if(MeloDecayTIMER[6][65] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[6], 65, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[6], 65, 0);}}              
   if   (MeloDecayTIMER[6][66] != 0) {
	     MeloDecayTIMER[6][66]--;
	  if(MeloDecayTIMER[6][66] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[6], 66, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[6], 66, 0);}}              
   if   (MeloDecayTIMER[6][67] != 0) {
	     MeloDecayTIMER[6][67]--;
	  if(MeloDecayTIMER[6][67] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[6], 67, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[6], 67, 0);}}              
   if   (MeloDecayTIMER[6][68] != 0) {
	     MeloDecayTIMER[6][68]--;
	  if(MeloDecayTIMER[6][68] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[6], 68, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[6], 68, 0);}}              
   if   (MeloDecayTIMER[6][69] != 0) {
	     MeloDecayTIMER[6][69]--;
	  if(MeloDecayTIMER[6][69] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[6], 69, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[6], 69, 0);}}              
   if   (MeloDecayTIMER[6][70] != 0) {
	     MeloDecayTIMER[6][70]--;
	  if(MeloDecayTIMER[6][70] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[6], 70, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[6], 70, 0);}}              
   if   (MeloDecayTIMER[6][71] != 0) {
	     MeloDecayTIMER[6][71]--;
	  if(MeloDecayTIMER[6][71] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[6], 71, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[6], 71, 0);}}              
   if   (MeloDecayTIMER[6][72] != 0) {
	     MeloDecayTIMER[6][72]--;
	  if(MeloDecayTIMER[6][72] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[6], 72, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[6], 72, 0);}}              
   if   (MeloDecayTIMER[6][73] != 0) {
	     MeloDecayTIMER[6][73]--;
	  if(MeloDecayTIMER[6][73] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[6], 73, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[6], 73, 0);}}              
   if   (MeloDecayTIMER[6][74] != 0) {
	     MeloDecayTIMER[6][74]--;
	  if(MeloDecayTIMER[6][74] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[6], 74, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[6], 74, 0);}}              
   if   (MeloDecayTIMER[6][75] != 0) {
	     MeloDecayTIMER[6][75]--;
	  if(MeloDecayTIMER[6][75] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[6], 75, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[6], 75, 0);}}              
   if   (MeloDecayTIMER[6][76] != 0) {
	     MeloDecayTIMER[6][76]--;
	  if(MeloDecayTIMER[6][76] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[6], 76, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[6], 76, 0);}}              
   if   (MeloDecayTIMER[6][77] != 0) {
	     MeloDecayTIMER[6][77]--;
	  if(MeloDecayTIMER[6][77] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[6], 77, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[6], 77, 0);}}              
   if   (MeloDecayTIMER[6][78] != 0) {
	     MeloDecayTIMER[6][78]--;
	  if(MeloDecayTIMER[6][78] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[6], 78, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[6], 78, 0);}}              
   if   (MeloDecayTIMER[6][79] != 0) {
	     MeloDecayTIMER[6][79]--;
	  if(MeloDecayTIMER[6][79] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[6], 79, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[6], 79, 0);}}              
   if   (MeloDecayTIMER[6][80] != 0) {
	     MeloDecayTIMER[6][80]--;
	  if(MeloDecayTIMER[6][80] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[6], 80, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[6], 80, 0);}}              
   if   (MeloDecayTIMER[6][81] != 0) {
	     MeloDecayTIMER[6][81]--;
	  if(MeloDecayTIMER[6][81] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[6], 81, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[6], 81, 0);}}              
   if   (MeloDecayTIMER[6][82] != 0) {
	     MeloDecayTIMER[6][82]--;
	  if(MeloDecayTIMER[6][82] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[6], 82, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[6], 82, 0);}}              
   if   (MeloDecayTIMER[6][83] != 0) {
	     MeloDecayTIMER[6][83]--;
	  if(MeloDecayTIMER[6][83] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[6], 83, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[6], 83, 0);}}              
   if   (MeloDecayTIMER[6][84] != 0) {
	     MeloDecayTIMER[6][84]--;
	  if(MeloDecayTIMER[6][84] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[6], 84, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[6], 84, 0);}}              
   if   (MeloDecayTIMER[6][85] != 0) {
	     MeloDecayTIMER[6][85]--;
	  if(MeloDecayTIMER[6][85] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[6], 85, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[6], 85, 0);}}              
   if   (MeloDecayTIMER[6][86] != 0) {
	     MeloDecayTIMER[6][86]--;
	  if(MeloDecayTIMER[6][86] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[6], 86, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[6], 86, 0);}}              
   if   (MeloDecayTIMER[6][87] != 0) {
	     MeloDecayTIMER[6][87]--;
	  if(MeloDecayTIMER[6][87] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[6], 87, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[6], 87, 0);}}              
   if   (MeloDecayTIMER[6][88] != 0) {
	     MeloDecayTIMER[6][88]--;
	  if(MeloDecayTIMER[6][88] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[6], 88, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[6], 88, 0);}}              
   if   (MeloDecayTIMER[6][89] != 0) {
	     MeloDecayTIMER[6][89]--;
	  if(MeloDecayTIMER[6][89] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[6], 89, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[6], 89, 0);}}                    
   if   (MeloDecayTIMER[6][90] != 0) {
	     MeloDecayTIMER[6][90]--;
	  if(MeloDecayTIMER[6][90] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[6], 90, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[6], 90, 0);}}              
   if   (MeloDecayTIMER[6][91] != 0) {
	     MeloDecayTIMER[6][91]--;
	  if(MeloDecayTIMER[6][91] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[6], 91, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[6], 91, 0);}}              
   if   (MeloDecayTIMER[6][92] != 0) {
	     MeloDecayTIMER[6][92]--;
	  if(MeloDecayTIMER[6][92] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[6], 92, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[6], 92, 0);}}              
   if   (MeloDecayTIMER[6][93] != 0) {
	     MeloDecayTIMER[6][93]--;
	  if(MeloDecayTIMER[6][93] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[6], 93, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[6], 93, 0);}}   
   if   (MeloDecayTIMER[6][94] != 0) {
	     MeloDecayTIMER[6][94]--;
	  if(MeloDecayTIMER[6][94] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[6], 94, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[6], 94, 0);}}               
   if   (MeloDecayTIMER[6][95] != 0) {
	     MeloDecayTIMER[6][95]--;
	  if(MeloDecayTIMER[6][95] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[6], 95, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[6], 95, 0);}}              
   if   (MeloDecayTIMER[6][96] != 0) {
	     MeloDecayTIMER[6][96]--;
	  if(MeloDecayTIMER[6][96] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[6], 96, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[6], 96, 0);}}              
   if   (MeloDecayTIMER[6][97] != 0) {
	     MeloDecayTIMER[6][97]--;
	  if(MeloDecayTIMER[6][97] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[6], 97, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[6], 97, 0);}}              
   if   (MeloDecayTIMER[6][98] != 0) {
	     MeloDecayTIMER[6][98]--;
	  if(MeloDecayTIMER[6][98] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[6], 98, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[6], 98, 0);}}              
   if   (MeloDecayTIMER[6][99] != 0) {
	     MeloDecayTIMER[6][99]--;
	  if(MeloDecayTIMER[6][99] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[6], 99, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[6], 99, 0);}}              
   if   (MeloDecayTIMER[6][100] != 0) {
	     MeloDecayTIMER[6][100]--;
	  if(MeloDecayTIMER[6][100] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[6], 100, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[6], 100, 0);}}              
   if   (MeloDecayTIMER[6][101] != 0) {
	     MeloDecayTIMER[6][101]--;
	  if(MeloDecayTIMER[6][101] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[6], 101, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[6], 101, 0);}}              
   if   (MeloDecayTIMER[6][102] != 0) {
	     MeloDecayTIMER[6][102]--;
	  if(MeloDecayTIMER[6][102] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[6], 102, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[6], 102, 0);}}              
   if   (MeloDecayTIMER[6][103] != 0) {
	     MeloDecayTIMER[6][103]--;
	  if(MeloDecayTIMER[6][103] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[6], 103, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[6], 103, 0);}}              
   if   (MeloDecayTIMER[6][104] != 0) {
	     MeloDecayTIMER[6][104]--;
	  if(MeloDecayTIMER[6][104] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[6], 104, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[6], 104, 0);}}              
   if   (MeloDecayTIMER[6][105] != 0) {
	     MeloDecayTIMER[6][105]--;
	  if(MeloDecayTIMER[6][105] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[6], 105, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[6], 105, 0);}}              
   if   (MeloDecayTIMER[6][106] != 0) {
	     MeloDecayTIMER[6][106]--;
	  if(MeloDecayTIMER[6][106] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[6], 106, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[6], 106, 0);}}              
   if   (MeloDecayTIMER[6][107] != 0) {
	     MeloDecayTIMER[6][107]--;
	  if(MeloDecayTIMER[6][107] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[6], 107, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[6], 107, 0);}}              
   if   (MeloDecayTIMER[6][108] != 0) {
	     MeloDecayTIMER[6][108]--;
	  if(MeloDecayTIMER[6][108] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[6], 108, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[6], 108, 0);}}              
   if   (MeloDecayTIMER[6][109] != 0) {
	     MeloDecayTIMER[6][109]--;
	  if(MeloDecayTIMER[6][109] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[6], 109, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[6], 109, 0);}}              
   if   (MeloDecayTIMER[6][110] != 0) {
	     MeloDecayTIMER[6][110]--;
	  if(MeloDecayTIMER[6][110] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[6], 110, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[6], 110, 0);}}              
   if   (MeloDecayTIMER[6][111] != 0) {
	     MeloDecayTIMER[6][111]--;
	  if(MeloDecayTIMER[6][111] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[6], 111, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[6], 111, 0);}}              
   if   (MeloDecayTIMER[6][112] != 0) {
	     MeloDecayTIMER[6][112]--;
	  if(MeloDecayTIMER[6][112] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[6], 112, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[6], 112, 0);}}              
   if   (MeloDecayTIMER[6][113] != 0) {
	     MeloDecayTIMER[6][113]--;
	  if(MeloDecayTIMER[6][113] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[6], 113, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[6], 113, 0);}}              
   if   (MeloDecayTIMER[6][114] != 0) {
	     MeloDecayTIMER[6][114]--;
	  if(MeloDecayTIMER[6][114] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[6], 114, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[6], 114, 0);}}              
   if   (MeloDecayTIMER[6][115] != 0) {
	     MeloDecayTIMER[6][115]--;
	  if(MeloDecayTIMER[6][115] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[6], 115, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[6], 115, 0);}}              
   if   (MeloDecayTIMER[6][116] != 0) {
	     MeloDecayTIMER[6][116]--;
	  if(MeloDecayTIMER[6][116] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[6], 116, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[6], 116, 0);}}              
   if   (MeloDecayTIMER[6][117] != 0) {
	     MeloDecayTIMER[6][117]--;
	  if(MeloDecayTIMER[6][117] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[6], 117, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[6], 117, 0);}}              
   if   (MeloDecayTIMER[6][118] != 0) {
	     MeloDecayTIMER[6][118]--;
	  if(MeloDecayTIMER[6][118] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[6], 118, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[6], 118, 0);}}              
   if   (MeloDecayTIMER[6][119] != 0) {
	     MeloDecayTIMER[6][119]--;
	  if(MeloDecayTIMER[6][119] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[6], 119, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[6], 119, 0);}}              
   if   (MeloDecayTIMER[6][120] != 0) {
	     MeloDecayTIMER[6][120]--;
	  if(MeloDecayTIMER[6][120] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[6], 120, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[6], 120, 0);}}              
   if   (MeloDecayTIMER[6][121] != 0) {
	     MeloDecayTIMER[6][121]--;
	  if(MeloDecayTIMER[6][121] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[6], 121, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[6], 121, 0);}}              
   if   (MeloDecayTIMER[6][122] != 0) {
	     MeloDecayTIMER[6][122]--;
	  if(MeloDecayTIMER[6][122] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[6], 122, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[6], 122, 0);}}              
   if   (MeloDecayTIMER[6][123] != 0) {
	     MeloDecayTIMER[6][123]--;
	  if(MeloDecayTIMER[6][23] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[6], 123, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[6], 123, 0);}}              
   if   (MeloDecayTIMER[6][124] != 0) {
	     MeloDecayTIMER[6][124]--;
	  if(MeloDecayTIMER[6][124] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[6], 124, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[6], 124, 0);}}              
   if   (MeloDecayTIMER[6][125] != 0) {
	     MeloDecayTIMER[6][125]--;
	  if(MeloDecayTIMER[6][125] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[6], 125, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[6], 125, 0);}}              
   if   (MeloDecayTIMER[6][126] != 0) {
	     MeloDecayTIMER[6][126]--;
	  if(MeloDecayTIMER[6][126] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[6], 126, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[6], 126, 0);}}              
   if   (MeloDecayTIMER[6][127] != 0) {
	     MeloDecayTIMER[6][127]--;
	  if(MeloDecayTIMER[6][127] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[6], 127, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[6], 127, 0);}}                                       
}//End While
}//End TICK 0 >>> 1ms Task...

static void TASK_Midi_Decay7(void *pvParameters){  //Send Note OFFs after a while
   portTickType xLastExecutionTime;
   xLastExecutionTime = xTaskGetTickCount();       // Initialise the xLastExecutionTime variable on task entry

  while( 1 ) {
    vTaskDelayUntil(&xLastExecutionTime, 1 / portTICK_RATE_MS);
    
   if   (MeloDecayTIMER[7][1] != 0) {
	     MeloDecayTIMER[7][1]--;
	  if(MeloDecayTIMER[7][1] == 0) {
		   MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[7], 1, 0); //Port, Chn, Note, Velocity 
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[7], 1, 0);}}  
   if   (MeloDecayTIMER[7][2] != 0) {
	     MeloDecayTIMER[7][2]--;
	  if(MeloDecayTIMER[7][2] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[7], 2, 0); //Port, Chn, Note, Velocity 
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[7], 2, 0);}}   
   if   (MeloDecayTIMER[7][3] != 0) {
	     MeloDecayTIMER[7][3]--;
	  if(MeloDecayTIMER[7][3] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[7], 3, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[7], 3, 0);}}
   if   (MeloDecayTIMER[7][4] != 0) {
	     MeloDecayTIMER[7][4]--;
	  if(MeloDecayTIMER[7][4] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[7], 4, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[7], 4, 0);}} 
   if   (MeloDecayTIMER[7][5] != 0) {
	     MeloDecayTIMER[7][5]--;
	  if(MeloDecayTIMER[7][5] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[7], 5, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[7], 5, 0);}} 
   if   (MeloDecayTIMER[7][6] != 0) {
	     MeloDecayTIMER[7][6]--;
	  if(MeloDecayTIMER[7][6] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[7], 6, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[7], 6, 0);}} 
   if   (MeloDecayTIMER[7][7] != 0) {
	     MeloDecayTIMER[7][7]--;
	  if(MeloDecayTIMER[7][7] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[7], 7, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[7], 7, 0);}}   
   if   (MeloDecayTIMER[7][8] != 0) {
	     MeloDecayTIMER[7][8]--;
	  if(MeloDecayTIMER[7][8] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[7], 8, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[7], 8, 0);}}   
   if   (MeloDecayTIMER[7][9] != 0) {
	     MeloDecayTIMER[7][9]--;
	  if(MeloDecayTIMER[7][9] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[7], 9, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[7], 9, 0);}}   
   if   (MeloDecayTIMER[7][10] != 0) {
	     MeloDecayTIMER[7][10]--;
	  if(MeloDecayTIMER[7][10] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[7], 10, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[7], 10, 0);}}   
   if   (MeloDecayTIMER[7][11] != 0) {
	     MeloDecayTIMER[7][11]--;
	  if(MeloDecayTIMER[7][11] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[7], 11, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[7], 11, 0);}}   
   if   (MeloDecayTIMER[7][12] != 0) {
	     MeloDecayTIMER[7][12]--;
	  if(MeloDecayTIMER[7][12] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[7], 12, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[7], 12, 0);}}   
   if   (MeloDecayTIMER[7][13] != 0) {
	     MeloDecayTIMER[7][13]--;
	  if(MeloDecayTIMER[7][13] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[7], 13, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[7], 13, 0);}}   
   if   (MeloDecayTIMER[7][14] != 0) {
	     MeloDecayTIMER[7][14]--;
	  if(MeloDecayTIMER[7][14] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[7], 14, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[7], 14, 0);}}   
   if   (MeloDecayTIMER[7][15] != 0) {
	     MeloDecayTIMER[7][15]--;
	  if(MeloDecayTIMER[7][15] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[7], 15, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[7], 15, 0);}}   
   if   (MeloDecayTIMER[7][16] != 0) {
	     MeloDecayTIMER[7][16]--;
	  if(MeloDecayTIMER[7][16] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[7], 16, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[7], 16, 0);}}   
   if   (MeloDecayTIMER[7][17] != 0) {
	     MeloDecayTIMER[7][17]--;
	  if(MeloDecayTIMER[7][17] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[7], 17, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[7], 17, 0);}}   
   if   (MeloDecayTIMER[7][18] != 0) {
	     MeloDecayTIMER[7][18]--;
	  if(MeloDecayTIMER[7][18] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[7], 18, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[7], 18, 0);}}   
   if   (MeloDecayTIMER[7][19] != 0) {
	     MeloDecayTIMER[7][19]--;
	  if(MeloDecayTIMER[7][19] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[7], 19, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[7], 19, 0);}}   
   if   (MeloDecayTIMER[7][20] != 0) {
	     MeloDecayTIMER[7][20]--;
	  if(MeloDecayTIMER[7][20] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[7], 20, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[7], 20, 0);}}   
   if   (MeloDecayTIMER[7][21] != 0) {
	     MeloDecayTIMER[7][21]--;
	  if(MeloDecayTIMER[7][21] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[7], 21, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[7], 21, 0);}}   
   if   (MeloDecayTIMER[7][22] != 0) {
	     MeloDecayTIMER[7][22]--;
	  if(MeloDecayTIMER[7][22] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[7], 22, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[7], 22, 0);}}   
   if   (MeloDecayTIMER[7][23] != 0) {
	     MeloDecayTIMER[7][23]--;
	  if(MeloDecayTIMER[7][23] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[7], 23, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[7], 23, 0);}}   
   if   (MeloDecayTIMER[7][24] != 0) {
	     MeloDecayTIMER[7][24]--;
	  if(MeloDecayTIMER[7][24] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[7], 24, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[7], 24, 0);}}   
   if   (MeloDecayTIMER[7][25] != 0) {
	     MeloDecayTIMER[7][25]--;
	  if(MeloDecayTIMER[7][25] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[7], 25, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[7], 25, 0);}}   
   if   (MeloDecayTIMER[7][26] != 0) {
	     MeloDecayTIMER[7][26]--;
	  if(MeloDecayTIMER[7][26] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[7], 26, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[7], 26, 0);}}   
   if   (MeloDecayTIMER[7][27] != 0) {
	     MeloDecayTIMER[7][27]--;
	  if(MeloDecayTIMER[7][27] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[7], 27, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[7], 27, 0);}}   
   if   (MeloDecayTIMER[7][28] != 0) {
	     MeloDecayTIMER[7][28]--;
	  if(MeloDecayTIMER[7][28] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[7], 28, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[7], 28, 0);}}   
   if   (MeloDecayTIMER[7][29] != 0) {
	     MeloDecayTIMER[7][29]--;
	  if(MeloDecayTIMER[7][29] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[7], 29, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[7], 29, 0);}}   
   if   (MeloDecayTIMER[7][30] != 0) {
	     MeloDecayTIMER[7][30]--;
	  if(MeloDecayTIMER[7][30] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[7], 30, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[7], 30, 0);}}   
   if   (MeloDecayTIMER[7][31] != 0) {
	     MeloDecayTIMER[7][31]--;
	  if(MeloDecayTIMER[7][31] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[7], 31, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[7], 31, 0);}}   
   if   (MeloDecayTIMER[7][32] != 0) {
	     MeloDecayTIMER[7][32]--;
	  if(MeloDecayTIMER[7][32] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[7], 32, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[7], 32, 0);}}   
   if   (MeloDecayTIMER[7][33] != 0) {
	     MeloDecayTIMER[7][33]--;
	  if(MeloDecayTIMER[7][33] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[7], 33, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[7], 33, 0);}}   
   if   (MeloDecayTIMER[7][34] != 0) {
	     MeloDecayTIMER[7][34]--;
	  if(MeloDecayTIMER[7][34] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[7], 34, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[7], 34, 0);}}   
   if   (MeloDecayTIMER[7][35] != 0) {
	     MeloDecayTIMER[7][35]--;
	  if(MeloDecayTIMER[7][35] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[7], 35, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[7], 35, 0);}}   
   if   (MeloDecayTIMER[7][36] != 0) {
	     MeloDecayTIMER[7][36]--;
	  if(MeloDecayTIMER[7][36] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[7], 36, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[7], 36, 0);}}   
   if   (MeloDecayTIMER[7][37] != 0) {
	     MeloDecayTIMER[7][37]--;
	  if(MeloDecayTIMER[7][37] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[7], 37, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[7], 37, 0);}}   
   if   (MeloDecayTIMER[7][38] != 0) {
	     MeloDecayTIMER[7][38]--;
	  if(MeloDecayTIMER[7][38] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[7], 38, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[7], 38, 0);}}         
   if   (MeloDecayTIMER[7][39] != 0) {
	     MeloDecayTIMER[7][39]--;
	  if(MeloDecayTIMER[7][39] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[7], 39, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[7], 39, 0);}}              
   if   (MeloDecayTIMER[7][40] != 0) {
	     MeloDecayTIMER[7][40]--;
	  if(MeloDecayTIMER[7][40] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[7], 40, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[7], 40, 0);}}              
   if   (MeloDecayTIMER[7][41] != 0) {
	     MeloDecayTIMER[7][41]--;
	  if(MeloDecayTIMER[7][41] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[7], 41, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[7], 41, 0);}}              
   if   (MeloDecayTIMER[7][42] != 0) {
	     MeloDecayTIMER[7][42]--;
	  if(MeloDecayTIMER[7][42] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[7], 42, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[7], 42, 0);}}             
   if   (MeloDecayTIMER[7][43] != 0) {
	     MeloDecayTIMER[7][43]--;
	  if(MeloDecayTIMER[7][43] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[7], 43, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[7], 43, 0);}}              
   if   (MeloDecayTIMER[7][44] != 0) {
	     MeloDecayTIMER[7][44]--;
	  if(MeloDecayTIMER[7][44] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[7], 44, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[7], 44, 0);}}              
   if   (MeloDecayTIMER[7][45] != 0) {
	     MeloDecayTIMER[7][45]--;
	  if(MeloDecayTIMER[7][45] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[7], 45, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[7], 45, 0);}}              
   if   (MeloDecayTIMER[7][46] != 0) {
	     MeloDecayTIMER[7][46]--;
	  if(MeloDecayTIMER[7][46] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[7], 46, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[7], 46, 0);}}              
   if   (MeloDecayTIMER[7][47] != 0) {
	     MeloDecayTIMER[7][47]--;
	  if(MeloDecayTIMER[7][47] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[7], 47, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[7], 47, 0);}}              
   if   (MeloDecayTIMER[7][48] != 0) {
	     MeloDecayTIMER[7][48]--;
	  if(MeloDecayTIMER[7][48] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[7], 48, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[7], 48, 0);}}              
   if   (MeloDecayTIMER[7][49] != 0) {
	     MeloDecayTIMER[7][49]--;
	  if(MeloDecayTIMER[7][49] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[7], 49, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[7], 49, 0);}}              
   if   (MeloDecayTIMER[7][50] != 0) {
	     MeloDecayTIMER[7][50]--;
	  if(MeloDecayTIMER[7][50] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[7], 50, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[7], 50, 0);}}              
   if   (MeloDecayTIMER[7][51] != 0) {
	     MeloDecayTIMER[7][51]--;
	  if(MeloDecayTIMER[7][51] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[7], 51, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[7], 51, 0);}}              
   if   (MeloDecayTIMER[7][52] != 0) {
	     MeloDecayTIMER[7][52]--;
	  if(MeloDecayTIMER[7][52] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[7], 52, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[7], 52, 0);}}    
   if   (MeloDecayTIMER[7][53] != 0) {
	     MeloDecayTIMER[7][53]--;
	  if(MeloDecayTIMER[7][53] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[7], 53, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[7], 53, 0);}}              
   if   (MeloDecayTIMER[7][54] != 0) {
	     MeloDecayTIMER[7][54]--;
	  if(MeloDecayTIMER[7][54] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[7], 54, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[7], 54, 0);}}              
   if   (MeloDecayTIMER[7][55] != 0) {
	     MeloDecayTIMER[7][55]--;
	  if(MeloDecayTIMER[7][55] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[7], 55, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[7], 55, 0);}}              
   if   (MeloDecayTIMER[7][56] != 0) {
	     MeloDecayTIMER[7][56]--;
	  if(MeloDecayTIMER[7][56] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[7], 56, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[7], 56, 0);}}              
   if   (MeloDecayTIMER[7][57] != 0) {
	     MeloDecayTIMER[7][57]--;
	  if(MeloDecayTIMER[7][57] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[7], 57, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[7], 57, 0);}}              
   if   (MeloDecayTIMER[7][58] != 0) {
	     MeloDecayTIMER[7][58]--;
	  if(MeloDecayTIMER[7][58] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[7], 58, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[7], 58, 0);}}              
   if   (MeloDecayTIMER[7][59] != 0) {
	     MeloDecayTIMER[7][59]--;
	  if(MeloDecayTIMER[7][59] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[7], 59, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[7], 59, 0);}}              
   if   (MeloDecayTIMER[7][60] != 0) {
	     MeloDecayTIMER[7][60]--;
	  if(MeloDecayTIMER[7][60] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[7], 60, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[7], 60, 0);}}              
   if   (MeloDecayTIMER[7][61] != 0) {
	     MeloDecayTIMER[7][61]--;
	  if(MeloDecayTIMER[7][61] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[7], 61, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[7], 61, 0);}}              
   if   (MeloDecayTIMER[7][62] != 0) {
	     MeloDecayTIMER[7][62]--;
	  if(MeloDecayTIMER[7][62] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[7], 62, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[7], 62, 0);}}              
   if   (MeloDecayTIMER[7][63] != 0) {
	     MeloDecayTIMER[7][63]--;
	  if(MeloDecayTIMER[7][63] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[7], 63, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[7], 63, 0);}}              
   if   (MeloDecayTIMER[7][64] != 0) {
	     MeloDecayTIMER[7][64]--;
	  if(MeloDecayTIMER[7][64] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[7], 64, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[7], 64, 0);}}              
   if   (MeloDecayTIMER[7][65] != 0) {
	     MeloDecayTIMER[7][65]--;
	  if(MeloDecayTIMER[7][65] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[7], 65, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[7], 65, 0);}}              
   if   (MeloDecayTIMER[7][66] != 0) {
	     MeloDecayTIMER[7][66]--;
	  if(MeloDecayTIMER[7][66] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[7], 66, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[7], 66, 0);}}              
   if   (MeloDecayTIMER[7][67] != 0) {
	     MeloDecayTIMER[7][67]--;
	  if(MeloDecayTIMER[7][67] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[7], 67, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[7], 67, 0);}}              
   if   (MeloDecayTIMER[7][68] != 0) {
	     MeloDecayTIMER[7][68]--;
	  if(MeloDecayTIMER[7][68] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[7], 68, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[7], 68, 0);}}              
   if   (MeloDecayTIMER[7][69] != 0) {
	     MeloDecayTIMER[7][69]--;
	  if(MeloDecayTIMER[7][69] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[7], 69, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[7], 69, 0);}}              
   if   (MeloDecayTIMER[7][70] != 0) {
	     MeloDecayTIMER[7][70]--;
	  if(MeloDecayTIMER[7][70] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[7], 70, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[7], 70, 0);}}              
   if   (MeloDecayTIMER[7][71] != 0) {
	     MeloDecayTIMER[7][71]--;
	  if(MeloDecayTIMER[7][71] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[7], 71, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[7], 71, 0);}}              
   if   (MeloDecayTIMER[7][72] != 0) {
	     MeloDecayTIMER[7][72]--;
	  if(MeloDecayTIMER[7][72] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[7], 72, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[7], 72, 0);}}              
   if   (MeloDecayTIMER[7][73] != 0) {
	     MeloDecayTIMER[7][73]--;
	  if(MeloDecayTIMER[7][73] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[7], 73, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[7], 73, 0);}}              
   if   (MeloDecayTIMER[7][74] != 0) {
	     MeloDecayTIMER[7][74]--;
	  if(MeloDecayTIMER[7][74] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[7], 74, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[7], 74, 0);}}              
   if   (MeloDecayTIMER[7][75] != 0) {
	     MeloDecayTIMER[7][75]--;
	  if(MeloDecayTIMER[7][75] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[7], 75, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[7], 75, 0);}}              
   if   (MeloDecayTIMER[7][76] != 0) {
	     MeloDecayTIMER[7][76]--;
	  if(MeloDecayTIMER[7][76] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[7], 76, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[7], 76, 0);}}              
   if   (MeloDecayTIMER[7][77] != 0) {
	     MeloDecayTIMER[7][77]--;
	  if(MeloDecayTIMER[7][77] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[7], 77, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[7], 77, 0);}}              
   if   (MeloDecayTIMER[7][78] != 0) {
	     MeloDecayTIMER[7][78]--;
	  if(MeloDecayTIMER[7][78] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[7], 78, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[7], 78, 0);}}              
   if   (MeloDecayTIMER[7][79] != 0) {
	     MeloDecayTIMER[7][79]--;
	  if(MeloDecayTIMER[7][79] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[7], 79, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[7], 79, 0);}}              
   if   (MeloDecayTIMER[7][80] != 0) {
	     MeloDecayTIMER[7][80]--;
	  if(MeloDecayTIMER[7][80] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[7], 80, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[7], 80, 0);}}              
   if   (MeloDecayTIMER[7][81] != 0) {
	     MeloDecayTIMER[7][81]--;
	  if(MeloDecayTIMER[7][81] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[7], 81, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[7], 81, 0);}}              
   if   (MeloDecayTIMER[7][82] != 0) {
	     MeloDecayTIMER[7][82]--;
	  if(MeloDecayTIMER[7][82] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[7], 82, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[7], 82, 0);}}              
   if   (MeloDecayTIMER[7][83] != 0) {
	     MeloDecayTIMER[7][83]--;
	  if(MeloDecayTIMER[7][83] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[7], 83, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[7], 83, 0);}}              
   if   (MeloDecayTIMER[7][84] != 0) {
	     MeloDecayTIMER[7][84]--;
	  if(MeloDecayTIMER[7][84] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[7], 84, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[7], 84, 0);}}              
   if   (MeloDecayTIMER[7][85] != 0) {
	     MeloDecayTIMER[7][85]--;
	  if(MeloDecayTIMER[7][85] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[7], 85, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[7], 85, 0);}}              
   if   (MeloDecayTIMER[7][86] != 0) {
	     MeloDecayTIMER[7][86]--;
	  if(MeloDecayTIMER[7][86] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[7], 86, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[7], 86, 0);}}              
   if   (MeloDecayTIMER[7][87] != 0) {
	     MeloDecayTIMER[7][87]--;
	  if(MeloDecayTIMER[7][87] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[7], 87, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[7], 87, 0);}}              
   if   (MeloDecayTIMER[7][88] != 0) {
	     MeloDecayTIMER[7][88]--;
	  if(MeloDecayTIMER[7][88] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[7], 88, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[7], 88, 0);}}              
   if   (MeloDecayTIMER[7][89] != 0) {
	     MeloDecayTIMER[7][89]--;
	  if(MeloDecayTIMER[7][89] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[7], 89, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[7], 89, 0);}}                    
   if   (MeloDecayTIMER[7][90] != 0) {
	     MeloDecayTIMER[7][90]--;
	  if(MeloDecayTIMER[7][90] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[7], 90, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[7], 90, 0);}}              
   if   (MeloDecayTIMER[7][91] != 0) {
	     MeloDecayTIMER[7][91]--;
	  if(MeloDecayTIMER[7][91] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[7], 91, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[7], 91, 0);}}              
   if   (MeloDecayTIMER[7][92] != 0) {
	     MeloDecayTIMER[7][92]--;
	  if(MeloDecayTIMER[7][92] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[7], 92, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[7], 92, 0);}}              
   if   (MeloDecayTIMER[7][93] != 0) {
	     MeloDecayTIMER[7][93]--;
	  if(MeloDecayTIMER[7][93] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[7], 93, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[7], 93, 0);}}   
   if   (MeloDecayTIMER[7][94] != 0) {
	     MeloDecayTIMER[7][94]--;
	  if(MeloDecayTIMER[7][94] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[7], 94, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[7], 94, 0);}}               
   if   (MeloDecayTIMER[7][95] != 0) {
	     MeloDecayTIMER[7][95]--;
	  if(MeloDecayTIMER[7][95] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[7], 95, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[7], 95, 0);}}              
   if   (MeloDecayTIMER[7][96] != 0) {
	     MeloDecayTIMER[7][96]--;
	  if(MeloDecayTIMER[7][96] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[7], 96, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[7], 96, 0);}}              
   if   (MeloDecayTIMER[7][97] != 0) {
	     MeloDecayTIMER[7][97]--;
	  if(MeloDecayTIMER[7][97] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[7], 97, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[7], 97, 0);}}              
   if   (MeloDecayTIMER[7][98] != 0) {
	     MeloDecayTIMER[7][98]--;
	  if(MeloDecayTIMER[7][98] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[7], 98, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[7], 98, 0);}}              
   if   (MeloDecayTIMER[7][99] != 0) {
	     MeloDecayTIMER[7][99]--;
	  if(MeloDecayTIMER[7][99] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[7], 99, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[7], 99, 0);}}              
   if   (MeloDecayTIMER[7][100] != 0) {
	     MeloDecayTIMER[7][100]--;
	  if(MeloDecayTIMER[7][100] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[7], 100, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[7], 100, 0);}}              
   if   (MeloDecayTIMER[7][101] != 0) {
	     MeloDecayTIMER[7][101]--;
	  if(MeloDecayTIMER[7][101] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[7], 101, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[7], 101, 0);}}              
   if   (MeloDecayTIMER[7][102] != 0) {
	     MeloDecayTIMER[7][102]--;
	  if(MeloDecayTIMER[7][102] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[7], 102, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[7], 102, 0);}}              
   if   (MeloDecayTIMER[7][103] != 0) {
	     MeloDecayTIMER[7][103]--;
	  if(MeloDecayTIMER[7][103] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[7], 103, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[7], 103, 0);}}              
   if   (MeloDecayTIMER[7][104] != 0) {
	     MeloDecayTIMER[7][104]--;
	  if(MeloDecayTIMER[7][104] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[7], 104, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[7], 104, 0);}}              
   if   (MeloDecayTIMER[7][105] != 0) {
	     MeloDecayTIMER[7][105]--;
	  if(MeloDecayTIMER[7][105] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[7], 105, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[7], 105, 0);}}              
   if   (MeloDecayTIMER[7][106] != 0) {
	     MeloDecayTIMER[7][106]--;
	  if(MeloDecayTIMER[7][106] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[7], 106, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[7], 106, 0);}}              
   if   (MeloDecayTIMER[7][107] != 0) {
	     MeloDecayTIMER[7][107]--;
	  if(MeloDecayTIMER[7][107] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[7], 107, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[7], 107, 0);}}              
   if   (MeloDecayTIMER[7][108] != 0) {
	     MeloDecayTIMER[7][108]--;
	  if(MeloDecayTIMER[7][108] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[7], 108, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[7], 108, 0);}}              
   if   (MeloDecayTIMER[7][109] != 0) {
	     MeloDecayTIMER[7][109]--;
	  if(MeloDecayTIMER[7][109] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[7], 109, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[7], 109, 0);}}              
   if   (MeloDecayTIMER[7][110] != 0) {
	     MeloDecayTIMER[7][110]--;
	  if(MeloDecayTIMER[7][110] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[7], 110, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[7], 110, 0);}}              
   if   (MeloDecayTIMER[7][111] != 0) {
	     MeloDecayTIMER[7][111]--;
	  if(MeloDecayTIMER[7][111] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[7], 111, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[7], 111, 0);}}              
   if   (MeloDecayTIMER[7][112] != 0) {
	     MeloDecayTIMER[7][112]--;
	  if(MeloDecayTIMER[7][112] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[7], 112, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[7], 112, 0);}}              
   if   (MeloDecayTIMER[7][113] != 0) {
	     MeloDecayTIMER[7][113]--;
	  if(MeloDecayTIMER[7][113] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[7], 113, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[7], 113, 0);}}              
   if   (MeloDecayTIMER[7][114] != 0) {
	     MeloDecayTIMER[7][114]--;
	  if(MeloDecayTIMER[7][114] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[7], 114, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[7], 114, 0);}}              
   if   (MeloDecayTIMER[7][115] != 0) {
	     MeloDecayTIMER[7][115]--;
	  if(MeloDecayTIMER[7][115] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[7], 115, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[7], 115, 0);}}              
   if   (MeloDecayTIMER[7][116] != 0) {
	     MeloDecayTIMER[7][116]--;
	  if(MeloDecayTIMER[7][116] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[7], 116, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[7], 116, 0);}}              
   if   (MeloDecayTIMER[7][117] != 0) {
	     MeloDecayTIMER[7][117]--;
	  if(MeloDecayTIMER[7][117] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[7], 117, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[7], 117, 0);}}              
   if   (MeloDecayTIMER[7][118] != 0) {
	     MeloDecayTIMER[7][118]--;
	  if(MeloDecayTIMER[7][118] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[7], 118, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[7], 118, 0);}}              
   if   (MeloDecayTIMER[7][119] != 0) {
	     MeloDecayTIMER[7][119]--;
	  if(MeloDecayTIMER[7][119] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[7], 119, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[7], 119, 0);}}              
   if   (MeloDecayTIMER[7][120] != 0) {
	     MeloDecayTIMER[7][120]--;
	  if(MeloDecayTIMER[7][120] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[7], 120, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[7], 120, 0);}}              
   if   (MeloDecayTIMER[7][121] != 0) {
	     MeloDecayTIMER[7][121]--;
	  if(MeloDecayTIMER[7][121] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[7], 121, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[7], 121, 0);}}              
   if   (MeloDecayTIMER[7][122] != 0) {
	     MeloDecayTIMER[7][122]--;
	  if(MeloDecayTIMER[7][122] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[7], 122, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[7], 122, 0);}}              
   if   (MeloDecayTIMER[7][123] != 0) {
	     MeloDecayTIMER[7][123]--;
	  if(MeloDecayTIMER[7][23] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[7], 123, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[7], 123, 0);}}              
   if   (MeloDecayTIMER[7][124] != 0) {
	     MeloDecayTIMER[7][124]--;
	  if(MeloDecayTIMER[7][124] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[7], 124, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[7], 124, 0);}}              
   if   (MeloDecayTIMER[7][125] != 0) {
	     MeloDecayTIMER[7][125]--;
	  if(MeloDecayTIMER[7][125] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[7], 125, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[7], 125, 0);}}              
   if   (MeloDecayTIMER[7][126] != 0) {
	     MeloDecayTIMER[7][126]--;
	  if(MeloDecayTIMER[7][126] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[7], 126, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[7], 126, 0);}}              
   if   (MeloDecayTIMER[7][127] != 0) {
	     MeloDecayTIMER[7][127]--;
	  if(MeloDecayTIMER[7][127] == 0) {
           MIOS32_MIDI_SendNoteOff(MelPortOut, MeloOutCh[7], 127, 0);
           MIOS32_MIDI_SendNoteOn (MelPortOut, MeloOutCh[7], 127, 0);}}                                       
}//End While
}//End TICK 0 >>> 1ms Task...


static void TASK_Blink_Decay(void *pvParameters){  //do all with counters, ms, times, flags.....
   portTickType xLastExecutionTime;
   xLastExecutionTime = xTaskGetTickCount();       // Initialise the xLastExecutionTime variable on task entry

  while( 1 ) {
    vTaskDelayUntil(&xLastExecutionTime, 1 / portTICK_RATE_MS);
        

        if(Boot_Flag == 1)  {MenueUpdateFlag = 0; Boot_Flag = 0;} //if booted then update the LCDs


        //Blinking LEDs...
       if   (Blink_Button_count[0] <= Blink_Button_time[0]) {
             Blink_Button_count[0]++;
          if(Blink_Button_count[0] >= Blink_Button_time[0])     { Blink_Button[0] =! Blink_Button[0]; Blink_Button_count[0] = 0;} }
    
       if   (Blink_Button_count[1] <= Blink_Button_time[1]) {
             Blink_Button_count[1]++;
          if(Blink_Button_count[1] >= Blink_Button_time[1])     { Blink_Button[1] =! Blink_Button[1]; Blink_Button_count[1] = 0;} }
          
       if   (Blink_Button_count[2] <= Blink_Button_time[2]) {
             Blink_Button_count[2]++;
          if(Blink_Button_count[2] >= Blink_Button_time[2])     { Blink_Button[2] =! Blink_Button[2]; Blink_Button_count[2] = 0;} }  
              
       if   (Blink_Button_count[3] <= Blink_Button_time[3]) {
             Blink_Button_count[3]++;
          if(Blink_Button_count[3] >= Blink_Button_time[3])     { Blink_Button[3] =! Blink_Button[3]; Blink_Button_count[3] = 0;} } 
          
                  
        SDCardCount++; 
        if(SDCardCount > 2000) { SDCardCount = 0; SD(0, 0, 5); } //2s Counter > send Check-SDCard-Commant to StoreLoad-Function (s32 track, s32 clip, s32 job){
        
        
        if(Update_LCD_s == 1) { Upd_LCD_count++;    if(Upd_LCD_count >= 2500) { Upd_LCD_count = 0; Update_LCD_s = 0;   MENUE(126, 0); }  }
            
        if(MenueUpdateFlag==0){MenueUpdateCount++; 
                    if(MenueUpdateCount > 250){MenueUpdateCount = 0; //update the Menue 0,15seconds after a message like "stored" (1.time!)
                                                MenueUpdateFlag=1; //deactivate Timer
                                                MENUE(126, 0);}} //Update LCD with the currently selected Menu}}
        

        //Store all Patterns
        if(StoreFlag == 1) {StoreCount++; 
                         if(StoreCount>250){ StoreCount=0; StoreFlag=0; SD(0, SongNrStor, 4); }} //the direct imideatly Btn Action from a button dont react...so delay here.
   
        //Load all Patterns of Song
        if(LoadFlag == 1) {LoadCount++; 
                        if(LoadCount>250){ LoadCount=0;  LoadFlag=0;  SD(0, SongNrLoad, 2); }} //the direct imideatly Btn Action from a button dont react...so delay here.
             
             
          
        //Programchange Load when Stopped turning the Wheel (from External Source, internal we use a LOAD-Button for that)
        if(PCLoadFlag==1){ PCLoadFlagCount++; 
                        if(PCLoadFlagCount >= 200) {
                                         PCLoadFlagCount = 0; //init counter for the next run
                                         SD(0, SongNrLoad, 2); //LOAD Program
                                         PCLoadFlag = 0;  //Kill Flag to avoid double triggering events
                                         MenueUpdateFlag=0;
                                         MENUE(126, 0);}} //Update LCD with the currently selected Menu}}

}//End While
}//End TICK 0 >>> 1ms Task...


s32 MENUE(s32 menue_cc, s32 menue_incrementer){  //dump out LCD-Data
////////////////////////////////////////////////////////////////
//                                                            //
//  M       E     EEEEEEE    N     N     U     U     EEEEEEE  //                                                                
//  M E   U E     E          N N   N     U     U     E        //                                                          
//  M   N   E     EEEE       N  N  N     U     U     EEEE     //                                                          
//  M       E     E          N   N N     U     U     E        //                                                          
//  M       E     EEEEEEE    N    NN     UUUUUUU     EEEEEEE  //                                                          
//                                                            //
switch (menue_cc) {

    // D U M P   O U T  C H O R D - N O T E S   T O   L C Ds @ 16TH   ---  Hardfault sensitive ;)
    case 125: 
    /////////////////////////////////
                  
                    //Chord-Display-Block
                    MUTEX_LCD_TAKE; //request LCD Access  
                            MIOS32_LCD_DeviceSet  (0);   //CLEAR LCD 0        
                            MIOS32_LCD_Clear();
                    MUTEX_LCD_GIVE;	 
                    
                            //Show RecNoteBuffer > C1 ... B10(= Bx)
                            if(RecNoteBuff[0] < 128) {      MUTEX_LCD_TAKE;     MIOS32_LCD_DeviceSet  (0); MIOS32_LCD_CursorSet(0, 0);        
                                MIOS32_LCD_PrintFormattedString("%c%c%c", NoteName[RecNoteBuff[0]][0], NoteName[RecNoteBuff[0]][1], NoteName[RecNoteBuff[0]][2]);       MUTEX_LCD_GIVE;}
                                
                            if(RecNoteBuff[1] < 128) {      MUTEX_LCD_TAKE;     MIOS32_LCD_DeviceSet  (0); MIOS32_LCD_CursorSet(5, 0);     
                                MIOS32_LCD_PrintFormattedString("%c%c%c", NoteName[RecNoteBuff[1]][0], NoteName[RecNoteBuff[1]][1], NoteName[RecNoteBuff[1]][2]);       MUTEX_LCD_GIVE;}
                                
                            if(RecNoteBuff[2] < 128) {      MUTEX_LCD_TAKE;     MIOS32_LCD_DeviceSet  (0); MIOS32_LCD_CursorSet(10,0);    
                                MIOS32_LCD_PrintFormattedString("%c%c%c", NoteName[RecNoteBuff[2]][0], NoteName[RecNoteBuff[2]][1], NoteName[RecNoteBuff[2]][2]);       MUTEX_LCD_GIVE;}
                                
                            if(RecNoteBuff[3] < 128) {      MUTEX_LCD_TAKE;     MIOS32_LCD_DeviceSet  (0); MIOS32_LCD_CursorSet(15,0);     
                                MIOS32_LCD_PrintFormattedString("%c%c%c", NoteName[RecNoteBuff[3]][0], NoteName[RecNoteBuff[3]][1], NoteName[RecNoteBuff[3]][2]);       MUTEX_LCD_GIVE;}
                                
                            if(RecNoteBuff[4] < 128) {      MUTEX_LCD_TAKE;     MIOS32_LCD_DeviceSet  (0); MIOS32_LCD_CursorSet(20,0);   
                                MIOS32_LCD_PrintFormattedString("%c%c%c", NoteName[RecNoteBuff[4]][0], NoteName[RecNoteBuff[4]][1], NoteName[RecNoteBuff[4]][2]);       MUTEX_LCD_GIVE;}
                                
                            if(RecNoteBuff[5] < 128) {      MUTEX_LCD_TAKE;     MIOS32_LCD_DeviceSet  (0); MIOS32_LCD_CursorSet(25,0);     
                                MIOS32_LCD_PrintFormattedString("%c%c%c", NoteName[RecNoteBuff[5]][0], NoteName[RecNoteBuff[5]][1], NoteName[RecNoteBuff[5]][2]);       MUTEX_LCD_GIVE;}
                                
                            if(RecNoteBuff[6] < 128) {      MUTEX_LCD_TAKE;     MIOS32_LCD_DeviceSet  (0); MIOS32_LCD_CursorSet(30,0);
                                MIOS32_LCD_PrintFormattedString("%c%c%c", NoteName[RecNoteBuff[6]][0], NoteName[RecNoteBuff[6]][1], NoteName[RecNoteBuff[6]][2]);       MUTEX_LCD_GIVE;}
                                
                            if(RecNoteBuff[7] < 128) {      MUTEX_LCD_TAKE;     MIOS32_LCD_DeviceSet  (0); MIOS32_LCD_CursorSet(35,0);     
                                MIOS32_LCD_PrintFormattedString("%c%c%c", NoteName[RecNoteBuff[7]][0], NoteName[RecNoteBuff[7]][1], NoteName[RecNoteBuff[7]][2]);       MUTEX_LCD_GIVE;}
                                    
                                    
                            //Show Sequence Notes > C1 ... B10
                            if(Sequence[ActualSequence][loop_step_pos[ActualSequence]][0] < 128) {      MUTEX_LCD_TAKE;     MIOS32_LCD_DeviceSet  (0); MIOS32_LCD_CursorSet(0,  1);    
                                MIOS32_LCD_PrintFormattedString("%c%c%c", 
                                NoteName[Sequence[ActualSequence] [loop_step_pos[ActualSequence]] [0]] [0], NoteName[Sequence[ActualSequence] [loop_step_pos[ActualSequence]] [0]] [1], NoteName[Sequence[ActualSequence] [loop_step_pos[ActualSequence]] [0]] [2]);
                            MUTEX_LCD_GIVE;}
      
                            if(Sequence[ActualSequence][loop_step_pos[ActualSequence]][1] < 128) {      MUTEX_LCD_TAKE;     MIOS32_LCD_DeviceSet  (0); MIOS32_LCD_CursorSet(5,  1);     
                                MIOS32_LCD_PrintFormattedString("%c%c%c", 
                                NoteName[Sequence[ActualSequence] [loop_step_pos[ActualSequence]] [1]] [0], NoteName[Sequence[ActualSequence] [loop_step_pos[ActualSequence]] [1]] [1], NoteName[Sequence[ActualSequence] [loop_step_pos[ActualSequence]] [1]] [2]);
                            MUTEX_LCD_GIVE;}
                            
                            if(Sequence[ActualSequence][loop_step_pos[ActualSequence]][2] < 128) {      MUTEX_LCD_TAKE;     MIOS32_LCD_DeviceSet  (0); MIOS32_LCD_CursorSet(10, 1);    
                                MIOS32_LCD_PrintFormattedString("%c%c%c", 
                                NoteName[Sequence[ActualSequence] [loop_step_pos[ActualSequence]] [2]] [0], NoteName[Sequence[ActualSequence] [loop_step_pos[ActualSequence]] [2]] [1], NoteName[Sequence[ActualSequence] [loop_step_pos[ActualSequence]] [2]] [2]);
                            MUTEX_LCD_GIVE;}
                            
                            if(Sequence[ActualSequence][loop_step_pos[ActualSequence]][3] < 128) {      MUTEX_LCD_TAKE;     MIOS32_LCD_DeviceSet  (0); MIOS32_LCD_CursorSet(15, 1);    
                                MIOS32_LCD_PrintFormattedString("%c%c%c", 
                                NoteName[Sequence[ActualSequence] [loop_step_pos[ActualSequence]] [3]] [0], NoteName[Sequence[ActualSequence] [loop_step_pos[ActualSequence]] [3]] [1], NoteName[Sequence[ActualSequence] [loop_step_pos[ActualSequence]] [3]] [2]);
                            MUTEX_LCD_GIVE;}
                            
                            if(Sequence[ActualSequence][loop_step_pos[ActualSequence]][4] < 128) {      MUTEX_LCD_TAKE;     MIOS32_LCD_DeviceSet  (0); MIOS32_LCD_CursorSet(20, 1);
                                MIOS32_LCD_PrintFormattedString("%c%c%c", 
                                NoteName[Sequence[ActualSequence] [loop_step_pos[ActualSequence]] [4]] [0], NoteName[Sequence[ActualSequence] [loop_step_pos[ActualSequence]] [4]] [1], NoteName[Sequence[ActualSequence] [loop_step_pos[ActualSequence]] [4]] [2]);
                            MUTEX_LCD_GIVE;}
                            
                            if(Sequence[ActualSequence][loop_step_pos[ActualSequence]][5] < 128) {      MUTEX_LCD_TAKE;     MIOS32_LCD_DeviceSet  (0); MIOS32_LCD_CursorSet(25, 1);     
                                MIOS32_LCD_PrintFormattedString("%c%c%c", 
                                NoteName[Sequence[ActualSequence] [loop_step_pos[ActualSequence]] [5]] [0], NoteName[Sequence[ActualSequence] [loop_step_pos[ActualSequence]] [5]] [1], NoteName[Sequence[ActualSequence] [loop_step_pos[ActualSequence]] [5]] [2]);
                            MUTEX_LCD_GIVE;}
                            
                            if(Sequence[ActualSequence][loop_step_pos[ActualSequence]][6] < 128) {      MUTEX_LCD_TAKE;     MIOS32_LCD_DeviceSet  (0); MIOS32_LCD_CursorSet(30, 1);    
                                MIOS32_LCD_PrintFormattedString("%c%c%c", 
                                NoteName[Sequence[ActualSequence] [loop_step_pos[ActualSequence]] [6]] [0], NoteName[Sequence[ActualSequence] [loop_step_pos[ActualSequence]] [6]] [1], NoteName[Sequence[ActualSequence] [loop_step_pos[ActualSequence]] [6]] [2]);
                            MUTEX_LCD_GIVE;}
                            
                            if(Sequence[ActualSequence][loop_step_pos[ActualSequence]][7] < 128) {      MUTEX_LCD_TAKE;     MIOS32_LCD_DeviceSet  (0); MIOS32_LCD_CursorSet(35, 1);    
                                MIOS32_LCD_PrintFormattedString("%c%c%c", 
                                NoteName[Sequence[ActualSequence] [loop_step_pos[ActualSequence]] [7]] [0], NoteName[Sequence[ActualSequence] [loop_step_pos[ActualSequence]] [7]] [1], NoteName[Sequence[ActualSequence] [loop_step_pos[ActualSequence]] [7]] [2]);
                            MUTEX_LCD_GIVE;}
    break;

    
    
    // D U M P   O U T   T O   L C Ds
    case 126:
    /////////////////////////////////
    
        if (ActualMenue == 0) {  //Upper Page Bank

            if(Menue[0] == 0) { //MENU PAGE: 0 - loop-length
                    
                    //calculate Loop-Length
                    s32 l = 0;
                    for(l=0; l<8; ++l) Loop[l] = Loop_Length[l] * MainLoop;
                        
                    MUTEX_LCD_TAKE;
                            MIOS32_LCD_DeviceSet  (0);  //LCD 0    
                            MIOS32_LCD_Clear();
                            MIOS32_LCD_CursorSet(0,  0); MIOS32_LCD_PrintFormattedString("%d x %d", Loop_Length[0], MainLoop);
                            MIOS32_LCD_CursorSet(17, 0); MIOS32_LCD_PrintFormattedString("%d x %d", Loop_Length[1], MainLoop);
                            MIOS32_LCD_CursorSet(34, 0); MIOS32_LCD_PrintFormattedString("%d x %d", Loop_Length[2], MainLoop);
            
                            MIOS32_LCD_CursorSet(0,  1); MIOS32_LCD_PrintFormattedString("=%d", Loop[0]);
                            MIOS32_LCD_CursorSet(17, 1); MIOS32_LCD_PrintFormattedString("=%d", Loop[1]);
                            MIOS32_LCD_CursorSet(34, 1); MIOS32_LCD_PrintFormattedString("=%d", Loop[2]);         
                    MUTEX_LCD_GIVE;
                            
                    MUTEX_LCD_TAKE;              
                            MIOS32_LCD_DeviceSet  (1);  //LCD 1          
                            MIOS32_LCD_Clear();
                            MIOS32_LCD_CursorSet(0,  0); MIOS32_LCD_PrintFormattedString("%d x %d", Loop_Length[3], MainLoop);
                            MIOS32_LCD_CursorSet(17, 0); MIOS32_LCD_PrintFormattedString("%d x %d", Loop_Length[4], MainLoop);
                            MIOS32_LCD_CursorSet(34, 0); MIOS32_LCD_PrintFormattedString("%d x %d", Loop_Length[5], MainLoop);
            
                            MIOS32_LCD_CursorSet(0,  1); MIOS32_LCD_PrintFormattedString("=%d", Loop[3]);
                            MIOS32_LCD_CursorSet(17, 1); MIOS32_LCD_PrintFormattedString("=%d", Loop[4]);
                            MIOS32_LCD_CursorSet(34, 1); MIOS32_LCD_PrintFormattedString("=%d", Loop[5]);    
                    MUTEX_LCD_GIVE;
                            
                    MUTEX_LCD_TAKE;                                  
                            MIOS32_LCD_DeviceSet  (2);  //LCD 2  
                            MIOS32_LCD_Clear();     
                            MIOS32_LCD_CursorSet(0,  0); MIOS32_LCD_PrintFormattedString("%d x %d", Loop_Length[6], MainLoop);
                            MIOS32_LCD_CursorSet(17, 0); MIOS32_LCD_PrintFormattedString("%d x %d", Loop_Length[7], MainLoop);
            
                            MIOS32_LCD_CursorSet(0,  1); MIOS32_LCD_PrintFormattedString("=%d", Loop[6]);
                            MIOS32_LCD_CursorSet(17, 1); MIOS32_LCD_PrintFormattedString("=%d", Loop[7]);
                
                            //Button-Bank-Describtion
                            MIOS32_LCD_CursorSet(29,0); MIOS32_LCD_PrintFormattedString("LOOP-length");                                
                            MIOS32_LCD_CursorSet(36,1); MIOS32_LCD_PrintFormattedString("REC");
                    MUTEX_LCD_GIVE;					// release LCD access for other tasks  	
            }         
            
            if(Menue[0] == 1) { //MENU PAGE: 1 - transport & Beat-Structure 4/4 5/4... Recording-Settings - Program-Change 0-128
                             
                    MUTEX_LCD_TAKE; //request LCD Access 
                            MIOS32_LCD_DeviceSet  (0);  //LCD 0       
                            MIOS32_LCD_Clear();  
                            MIOS32_LCD_CursorSet(0, 0);     MIOS32_LCD_PrintFormattedString("Start");
                            MIOS32_LCD_CursorSet(0, 1);     MIOS32_LCD_PrintFormattedString("Stop");
                            MIOS32_LCD_CursorSet(18, 0);    MIOS32_LCD_PrintFormattedString("BPM");
                            MIOS32_LCD_CursorSet(18, 1);    MIOS32_LCD_PrintFormattedString("%d", BPM);
                            MIOS32_LCD_CursorSet(36, 0);    MIOS32_LCD_PrintFormattedString("%d/4", Rythm);
                    MUTEX_LCD_GIVE;
                    
                    MUTEX_LCD_TAKE;
                            MIOS32_LCD_DeviceSet  (1);  //LCD 1     
                            MIOS32_LCD_Clear();  
                            MIOS32_LCD_CursorSet(0, 0);    MIOS32_LCD_PrintFormattedString("RecOffset");
                            MIOS32_LCD_CursorSet(0, 1);    MIOS32_LCD_PrintFormattedString("%d", 0 - RecOffset);
                            MIOS32_LCD_CursorSet(16, 0);    MIOS32_LCD_PrintFormattedString("Store Nr");
                            MIOS32_LCD_CursorSet(18, 1);    MIOS32_LCD_PrintFormattedString("%d", SongNrStor+1);
                            MIOS32_LCD_CursorSet(33, 0);    MIOS32_LCD_PrintFormattedString("Load Nr");                            
                            MIOS32_LCD_CursorSet(36, 1);    MIOS32_LCD_PrintFormattedString("%d", SongNrLoad+1);
                    MUTEX_LCD_GIVE;

                    MUTEX_LCD_TAKE;
                            MIOS32_LCD_DeviceSet  (2);  //LCD 2     
                            MIOS32_LCD_Clear();  
                            MIOS32_LCD_CursorSet(0, 0);    MIOS32_LCD_PrintFormattedString("Store");
                            MIOS32_LCD_CursorSet(0, 1);    MIOS32_LCD_PrintFormattedString("Load");
                            //MIOS32_LCD_CursorSet(18, 0);    MIOS32_LCD_PrintFormattedString("PC store Nr");
                            //MIOS32_LCD_CursorSet(18, 1);    MIOS32_LCD_PrintFormattedString("%d", SongNrStor+1);
                            //MIOS32_LCD_CursorSet(36, 0);    MIOS32_LCD_PrintFormattedString("PC load Nr");                            
                            //MIOS32_LCD_CursorSet(36, 1);    MIOS32_LCD_PrintFormattedString("%d", SongNrLoad+1);
                    MUTEX_LCD_GIVE;
                }
                
            if(Menue[0] == 2) { //empty
                    MUTEX_LCD_TAKE; //request LCD Access 
                            MIOS32_LCD_DeviceSet  (0);  //LCD 0       
                            MIOS32_LCD_Clear();  
                            MIOS32_LCD_DeviceSet  (1);  //LCD 1     
                            MIOS32_LCD_Clear();                             
                            MIOS32_LCD_DeviceSet  (2);  //LCD 2     
                            MIOS32_LCD_Clear();  
                    MUTEX_LCD_GIVE;
                }               

            if(Menue[0] == 3) { //empty
                    MUTEX_LCD_TAKE; //request LCD Access 
                            MIOS32_LCD_DeviceSet  (0);  //LCD 0       
                            MIOS32_LCD_Clear();  
                            MIOS32_LCD_DeviceSet  (1);  //LCD 1     
                            MIOS32_LCD_Clear();                             
                            MIOS32_LCD_DeviceSet  (2);  //LCD 2     
                            MIOS32_LCD_Clear();  
                    MUTEX_LCD_GIVE;
                }                    
            }
        
        
        else {  //Lower Page Bank
            
            //MENU PAGE: 0      -       MUTE & REC Sequences
            if(Menue[1] == 0) {

                    MUTEX_LCD_TAKE;
                            MIOS32_LCD_DeviceSet  (1);  //LCD 1       
                            MIOS32_LCD_Clear();  
                            //Button-Bank-Describtion
                            MIOS32_LCD_CursorSet(0, 0);     MIOS32_LCD_PrintFormattedString("Keyboard          3a                3b");
                            MIOS32_LCD_CursorSet(0, 1);     MIOS32_LCD_PrintFormattedString("Sequencer");
                    MUTEX_LCD_GIVE;
                    
                    MUTEX_LCD_TAKE;
                            MIOS32_LCD_DeviceSet  (2);  //LCD 2          
                            MIOS32_LCD_Clear();  
                            //Button-Bank-Describtion
                            MIOS32_LCD_CursorSet(0, 0);     MIOS32_LCD_PrintFormattedString("  4a              4b               MUTE");
                            MIOS32_LCD_CursorSet(0, 1);     MIOS32_LCD_PrintFormattedString("                                    REC");
                    MUTEX_LCD_GIVE;					// release LCD access for other tasks  	  
                }

             if(Menue[1] == 1) { //empty
                    MUTEX_LCD_TAKE; //request LCD Access 
                            MIOS32_LCD_DeviceSet  (0);  //LCD 0       
                            MIOS32_LCD_Clear();  
                            MIOS32_LCD_DeviceSet  (1);  //LCD 1     
                            MIOS32_LCD_Clear();                             
                            MIOS32_LCD_DeviceSet  (2);  //LCD 2     
                            MIOS32_LCD_Clear();  
                    MUTEX_LCD_GIVE;
                }               

            if(Menue[1] == 2) { //empty
                    MUTEX_LCD_TAKE; //request LCD Access 
                            MIOS32_LCD_DeviceSet  (0);  //LCD 0       
                            MIOS32_LCD_Clear();  
                            MIOS32_LCD_DeviceSet  (1);  //LCD 1     
                            MIOS32_LCD_Clear();                             
                            MIOS32_LCD_DeviceSet  (2);  //LCD 2     
                            MIOS32_LCD_Clear();  
                    MUTEX_LCD_GIVE;
                }                    
            }             

            if(Menue[1] == 3) { //empty
                    MUTEX_LCD_TAKE; //request LCD Access 
                            MIOS32_LCD_DeviceSet  (0);  //LCD 0       
                            MIOS32_LCD_Clear();  
                            MIOS32_LCD_DeviceSet  (1);  //LCD 1     
                            MIOS32_LCD_Clear();                             
                            MIOS32_LCD_DeviceSet  (2);  //LCD 2     
                            MIOS32_LCD_Clear();  
                    MUTEX_LCD_GIVE;
                }                    
    break;

    } 
  return 0; // no error,

}//END TASK///////////////////////////////////////////////////////////////////////////////////////////////////
