#include <mios32.h>
#include <seq_bpm.h>
#include "seq.h"
#include "app.h"

static  s32 SEQ_Tick(u32 bpm_tick);
static  int seq_pause = 0;       // pause mode (will be controlled from user interface)
static  int setPpqnDivider = 4; //to be shure that the 16th-PPQM-divider is changed in main-sync
        int TicSend = 0;
        int StepOffset = 0;      //Number off steps to delayd (in Order to get better in sync with other hardware)

s32 SEQ_Init(u32 mode){
    SEQ_Reset();  // reset sequencer
    SEQ_BPM_Init(0);  // init BPM generator
    SEQ_BPM_PPQN_Set(Tic);
    SEQ_BPM_Set(BPM);
    SEQ_BPM_TickSet(0); 
  return 0; // no error
}

s32 SEQ_Handler(void){ // this sequencer handler is called periodically to check for new requests from BPM generator
  // handle requests

  s32 num_loops = 0;
  s32 again = 0;
  do {
    ++num_loops;

    // note: don't remove any request check - clocks won't be propagated
    // so long any Stop/Cont/Start/SongPos event hasn't been flagged to the sequencer
    if( SEQ_BPM_ChkReqStop() ) {
     // SEQ_PlayOffEvents();
    }

    if( SEQ_BPM_ChkReqCont() ) {
      // release pause mode
      seq_pause = 0;
    }

    if( SEQ_BPM_ChkReqStart() ) {
      SEQ_Reset();
    }

    u16 new_song_pos;
    if( SEQ_BPM_ChkReqSongPos(&new_song_pos) ) {

    }

    u32 bpm_tick;
    if( SEQ_BPM_ChkReqClk(&bpm_tick) > 0 ) {
      again = 1; // check all requests again after execution of this part

      SEQ_Tick(bpm_tick);
    }
  } while( again && num_loops < 10 );

  return 0; // no error
}

s32 SEQ_Reset(void){
  seq_pause = 0;   // release pause mode
  SEQ_BPM_TickSet(0);   // reset BPM tick
  return 0; // no error
}

s32 SEQ_Loop(void){return 0;}


static s32 SEQ_Tick(u32 bpm_tick){  // performs a single bpm tick
    
  //MAIN RESET ON FIRST TIC EVER... (PLAY-Button)
  if( bpm_tick == 0 ) { main_step_pos = -1;
                        loop_step_pos[0] = StepOffset;  // start immediatly @ Loop Point
                        loop_step_pos[1] = StepOffset;  // start immediatly @ Loop Point
                        loop_step_pos[2] = StepOffset;  // start immediatly @ Loop Point
                        loop_step_pos[3] = StepOffset;  // start immediatly @ Loop Point
                        loop_step_pos[4] = StepOffset;  // start immediatly @ Loop Point
                        loop_step_pos[5] = StepOffset;  // start immediatly @ Loop Point
                        loop_step_pos[6] = StepOffset;  // start immediatly @ Loop Point
                        loop_step_pos[7] = StepOffset;}


  //96tic loop
  TicSend = (bpm_tick % (SEQ_BPM_PPQN_Get()/setPpqnDivider));

  //Step-Count --Running Light
  if(TicSend == 0 ) { // whenever we reach a new 16th note (e.g 96 tics @384 ppqn):
         //MAIN LOOP COUNTER
         if( ++main_step_pos >= MainLoop ) main_step_pos = 0; // increment step number until it reaches the mainloop length of a page /tact system


         //Set new Loop (in Main Sync)
         if(main_step_pos == 0) {
             
              if(NeedSync == 1){//Something has changed, Set new Loop point when MainLoop is finished
                   NeedSync = 3; //New NeedSync to avoid double triggering events.
                   //set new step position 
                    loop_step_pos[0] = StepOffset;
                    loop_step_pos[1] = StepOffset;
                    loop_step_pos[2] = StepOffset;
                    loop_step_pos[3] = StepOffset;
                    loop_step_pos[4] = StepOffset;
                    loop_step_pos[5] = StepOffset;
                    loop_step_pos[6] = StepOffset;
                    loop_step_pos[7] = StepOffset;}                 

              if(NeedSync == 4) {
                 SEQ_BPM_PPQN_Set(Tic); //set TICs (normally 384)
                 NeedSync = 3;} //New NeedSync to avoid double triggering events.

              if(NeedSync == 5) {
                 setPpqnDivider = PpqnDivider; //set PPQN Divider in time
                 NeedSync = 3;} //New NeedSync to avoid double triggering events
        }

//Avoid Additional Counter ++ after giving new Loop Step Positions
	       if(NeedSync != 3) { 
                                if( ++loop_step_pos[0] >= (Loop_Length[0] * MainLoop))    loop_step_pos[0] = StepOffset;
                                if( ++loop_step_pos[1] >= (Loop_Length[1] * MainLoop))    loop_step_pos[1] = StepOffset;
                                if( ++loop_step_pos[2] >= (Loop_Length[2] * MainLoop))    loop_step_pos[2] = StepOffset;
                                if( ++loop_step_pos[3] >= (Loop_Length[3] * MainLoop))    loop_step_pos[3] = StepOffset;
                                if( ++loop_step_pos[4] >= (Loop_Length[4] * MainLoop))    loop_step_pos[4] = StepOffset;
                                if( ++loop_step_pos[5] >= (Loop_Length[5] * MainLoop))    loop_step_pos[5] = StepOffset;
                                if( ++loop_step_pos[6] >= (Loop_Length[6] * MainLoop))    loop_step_pos[6] = StepOffset;
                                if( ++loop_step_pos[7] >= (Loop_Length[7] * MainLoop))    loop_step_pos[7] = StepOffset;}
           //Reset Syncflac
	       if(NeedSync == 3) { NeedSync = 0;}
           
           
     //LEDRING Loop Position Indication
        if( ( MelOmute[0] == 1) || (REC[0] == 1) ) {
               IND[0] = (((10000*loop_step_pos[0]) / (MainLoop * Loop_Length[0])) * 16)/10000;} //show Loop Position on a LED-RING 
    
        if( ( MelOmute[1] == 1) || (REC[1] == 1) ) {
               IND[1] = (((10000*loop_step_pos[1]) / (MainLoop * Loop_Length[1])) * 16)/10000;} //show Loop Position on a LED-RING 
    
        
        if( ( MelOmute[2] == 1) || (REC[2] == 1) ) {
               IND[2] = (((10000*loop_step_pos[2]) / (MainLoop * Loop_Length[2])) * 16)/10000;} //show Loop Position on a LED-RING 
    
        
        if( ( MelOmute[3] == 1) || (REC[3] == 1) ) {
               IND[3] = (((10000*loop_step_pos[3]) / (MainLoop * Loop_Length[3])) * 16)/10000;} //show Loop Position on a LED-RING 
    
        
        if( ( MelOmute[4] == 1) || (REC[4] == 1) ) {
               IND[4] = (((10000*loop_step_pos[4]) / (MainLoop * Loop_Length[4])) * 16)/10000;} //show Loop Position on a LED-RING 
        
        if( ( MelOmute[5] == 1) || (REC[5] == 1) ) {
               IND[5] = (((10000*loop_step_pos[5]) / (MainLoop * Loop_Length[5])) * 16)/10000;} //show Loop Position on a LED-RING 
    
        
        if( ( MelOmute[6] == 1) || (REC[6] == 1) ) {
               IND[6] = (((10000*loop_step_pos[6]) / (MainLoop * Loop_Length[6])) * 16)/10000;} //show Loop Position on a LED-RING 
    
        
        if( ( MelOmute[7] == 1) || (REC[7] == 1) ) {
               IND[7] = (((10000*loop_step_pos[7]) / (MainLoop * Loop_Length[7])) * 16)/10000;} //show Loop Position on a LED-RING 
   
   
} //END "If Tic=0"...

APP_NOTEPROCESS(0, 127, 0, main_step_pos, TicSend); //(s32 port, s32 note, s32 velocity, s32 step) Back to APP.c
    return 0; // no error 
}
