/** \file timer.c:
 * Handles time dependent events like querying external devices and waiting
 * for an answer. Here only global variables get counted up or down, that
 * trigger the appropriate function calls in MIOS_Tick.
 * This function is periodically called by MIOS. The frequency has to be
 * initialized with MIOS_Timer_Set
 */

void Timer(void) __wparam
{
unsigned char i=0x00;


	if(eb_request.error) {								//blinking LEDs if edit buffer does not arrive
		led_time++;
		return;
	}

	if (get_userdata>1) {								//circling LEDs if the MIDIbox is written to by the software
		led_time++;
		return;
	}
	/**
	 *  If editbuffer has to be sent back to the synthesizer while turning an encoder
 	 *  the sending has to be asynchroneus to turning, because sending takes very long
 	 *  and thus the input gets delayed. Also the synthesizer could not react to a fast
	 *  time between two edit buffers. Thats why we implemented a delay between sending
 	 *  editbuffers.
 	 */
	if (send_editbuffer>1) {
		send_editbuffer--;
	}




	/**
	 * When there is a chained list of edit buffer requests (MIDI X bar | Edit buffer request | ...)
	 * they are sent after each other from this timer. Like this, a timeout is realized between those requests.
	 */
	if(eb_request.active) {
		if(((eb_request.dump.typ>>6)&0x01)==1) {
			if(eb_request.timer>=(((eb_request.dump.typ>>2)&0x0F))) {
				requestNextDump();
			} else
				eb_request.timer++;
		} else if(((eb_request.dump.typ>>6)&0x01)==0) {
			if(eb_request.timer>(((eb_request.dump.typ>>2)&0x0F)*50)) {
				eb_request.error=1;
				update=0x08;
				eb_request.active=0;
				modus=MOD_MODUL;
				for(i=0;i<4;i++)
					MIOS_DOUT_PinSet(i,bank==i?1:0);
			}
			else
				eb_request.timer++;
		}
		//get_userdata=0x00;
		return;
	}

}
