/** \file wrapper.c:
 *  These functions are used to only utilize one general display function per task
 *  for all displays. For this, a function parameter "display" was added through
 *  which the receiving display is chosen.
 */

/**
 *  writes char "c" at display "display"
 * \param display target display
 * \param c character that is printed
 */
void printChar(unsigned char display,unsigned char c) {
	if(display==CURENT_DISPLAY)
		MIOS_LCD_PrintChar(c);
	else {
		MIOS_MIDI_BeginStream;
		MIOS_MIDI_TxBufferPut (0xF0);				//Sysex Start
		MIOS_MIDI_TxBufferPut (0x55);				//Unsere Hersteller ID
		MIOS_MIDI_TxBufferPut ('M');				//Buchstabe M
		MIOS_MIDI_TxBufferPut ('B');				//Buchstabe B
		MIOS_MIDI_TxBufferPut (FUNC_PRINT_CHAR);	//Art der getunnelten Funktion
		MIOS_MIDI_TxBufferPut (display);			//Zielort display

		MIOS_MIDI_TxBufferPut (c);					//Character

		MIOS_MIDI_TxBufferPut (0xF7);				//Sysex End
		MIOS_MIDI_EndStream;
	}

}


/**
 *  clears display "display"
 * \param display target display
 */
void clearLCD(unsigned char display) {
	if(display==CURENT_DISPLAY)
		MIOS_LCD_Clear();
	else {
		MIOS_MIDI_BeginStream;
		MIOS_MIDI_TxBufferPut (0xF0);				//Sysex Start
		MIOS_MIDI_TxBufferPut (0x55);				//Unsere Hersteller ID
		MIOS_MIDI_TxBufferPut ('M');				//Buchstabe M
		MIOS_MIDI_TxBufferPut ('B');				//Buchstabe B
		MIOS_MIDI_TxBufferPut (FUNC_CLEAR_LCD);		//Art der getunnelten Funktion
		MIOS_MIDI_TxBufferPut (display);			//Zielort display

		MIOS_MIDI_TxBufferPut (0xF7);				//Sysex End
		MIOS_MIDI_EndStream;
	}

}


/**
 *  sets cursor on display "display" at position "x,y"
 * \param display target display
 * \param x x coordinate in pixels
 * \param y y coordinate in lines
 */
void setCursor(unsigned char display,unsigned char x,unsigned char y) {
	if(display==CURENT_DISPLAY)
		MIOS_GLCD_GCursorSet(x,y);
	else {
		MIOS_MIDI_BeginStream;
		MIOS_MIDI_TxBufferPut (0xF0);				//Sysex Start
		MIOS_MIDI_TxBufferPut (0x55);				//Unsere Hersteller ID
		MIOS_MIDI_TxBufferPut ('M');				//Buchstabe M
		MIOS_MIDI_TxBufferPut ('B');				//Buchstabe B
		MIOS_MIDI_TxBufferPut (FUNC_SET_CURSOR);	//Art der getunnelten Funktion
		MIOS_MIDI_TxBufferPut (display);			//Zielort display

		MIOS_MIDI_TxBufferPut (x);				//x Position
		MIOS_MIDI_TxBufferPut (y);				//y Position

		MIOS_MIDI_TxBufferPut (0xF7);				//Sysex End
		MIOS_MIDI_EndStream;
	}

}


/**
 *  prints string at "*str" on display "display"
 * \param display target display
 * \param str string to print
 */
void printString(unsigned char display,code char *str) {
	int x;
	if(display==CURENT_DISPLAY)
		MIOS_LCD_PrintCString(str);
	else {
		MIOS_MIDI_BeginStream;
		MIOS_MIDI_TxBufferPut (0xF0);				//Sysex Start
		MIOS_MIDI_TxBufferPut (0x55);				//Unsere Hersteller ID
		MIOS_MIDI_TxBufferPut ('M');				//Buchstabe M
		MIOS_MIDI_TxBufferPut ('B');				//Buchstabe B
		MIOS_MIDI_TxBufferPut (FUNC_PRINT_STRING);	//Art der getunnelten Funktion
		MIOS_MIDI_TxBufferPut (display);			//Zielort display

		for(x=0;str[x]!=0;x++)
			MIOS_MIDI_TxBufferPut (str[x]);			//Character

		MIOS_MIDI_TxBufferPut (0xF7);				//Sysex End
		MIOS_MIDI_EndStream;
	}
}


/**
 *  writes char "v" as 1 digit BCD at display "display"
 * \param display target display
 * \param v value to print
 */
void printBCD1(unsigned char display,unsigned char v) {
	if(display==CURENT_DISPLAY)
			MIOS_LCD_PrintBCD1(v);
	else {
		MIOS_MIDI_BeginStream;
		MIOS_MIDI_TxBufferPut (0xF0);				//Sysex Start
		MIOS_MIDI_TxBufferPut (0x55);				//Unsere Hersteller ID
		MIOS_MIDI_TxBufferPut ('M');				//Buchstabe M
		MIOS_MIDI_TxBufferPut ('B');				//Buchstabe B
		MIOS_MIDI_TxBufferPut (FUNC_PRINT_BCD1);	//Art der getunnelten Funktion
		MIOS_MIDI_TxBufferPut (display);			//Zielort display

		MIOS_MIDI_TxBufferPut (v);					//Character

		MIOS_MIDI_TxBufferPut (0xF7);				//Sysex End
		MIOS_MIDI_EndStream;
	}

}

/**
 *  writes char "v" as 2 digit BCD at display "display"
 * \param display target display
 * \param v value to print
 */
void printBCD2(unsigned char display,unsigned char v) {
	if(display==CURENT_DISPLAY)
			MIOS_LCD_PrintBCD2(v);
	else {
		MIOS_MIDI_BeginStream;
		MIOS_MIDI_TxBufferPut (0xF0);				//Sysex Start
		MIOS_MIDI_TxBufferPut (0x55);				//Unsere Hersteller ID
		MIOS_MIDI_TxBufferPut ('M');				//Buchstabe M
		MIOS_MIDI_TxBufferPut ('B');				//Buchstabe B
		MIOS_MIDI_TxBufferPut (FUNC_PRINT_BCD2);	//Art der getunnelten Funktion
		MIOS_MIDI_TxBufferPut (display);			//Zielort display

		MIOS_MIDI_TxBufferPut (v);					//Character

		MIOS_MIDI_TxBufferPut (0xF7);				//Sysex End
		MIOS_MIDI_EndStream;
	}

}

/**
 *  writes char "v" as 3 digit BCD at display "display"
 * \param display target display
 * \param v value to print
 */
void printBCD3(unsigned char display,unsigned char v) {
	if(display==CURENT_DISPLAY)
			MIOS_LCD_PrintBCD3(v);
	else {
		MIOS_MIDI_BeginStream;
		MIOS_MIDI_TxBufferPut (0xF0);				//Sysex Start
		MIOS_MIDI_TxBufferPut (0x55);				//Unsere Hersteller ID
		MIOS_MIDI_TxBufferPut ('M');				//Buchstabe M
		MIOS_MIDI_TxBufferPut ('B');				//Buchstabe B
		MIOS_MIDI_TxBufferPut (FUNC_PRINT_BCD3);	//Art der getunnelten Funktion
		MIOS_MIDI_TxBufferPut (display);			//Zielort display

		MIOS_MIDI_TxBufferPut (v);					//Character

		MIOS_MIDI_TxBufferPut (0xF7);				//Sysex End
		MIOS_MIDI_EndStream;
	}
}

/*
 *  writes int "v" as 4 digit BCD at display "display"
 * \param display target display
 * \param v value to print
 */
void printBCD4(unsigned char display,unsigned int v) {
	if(display==CURENT_DISPLAY)
			MIOS_LCD_PrintBCD4(v);
	else {
		MIOS_MIDI_BeginStream;
		MIOS_MIDI_TxBufferPut (0xF0);				//Sysex Start
		MIOS_MIDI_TxBufferPut (0x55);				//Unsere Hersteller ID
		MIOS_MIDI_TxBufferPut ('M');				//Buchstabe M
		MIOS_MIDI_TxBufferPut ('B');				//Buchstabe B
		MIOS_MIDI_TxBufferPut (FUNC_PRINT_BCD4);	//Art der getunnelten Funktion
		MIOS_MIDI_TxBufferPut (display);			//Zielort display

		MIOS_MIDI_TxBufferPut ((char)(v>>7));					//Character
		MIOS_MIDI_TxBufferPut ((char)(v));
		MIOS_MIDI_TxBufferPut (0xF7);				//Sysex End
		MIOS_MIDI_EndStream;
	}
}


/**
 *  writes int "v" as 5 digit BCD at display "display"
 * \param display target display
 * \param v value to print
 */
void printBCD5(unsigned char display,unsigned int v) {
	if(display==CURENT_DISPLAY)
			MIOS_LCD_PrintBCD5(v);
	else {
		MIOS_MIDI_BeginStream;
		MIOS_MIDI_TxBufferPut (0xF0);				//Sysex Start
		MIOS_MIDI_TxBufferPut (0x55);				//Unsere Hersteller ID
		MIOS_MIDI_TxBufferPut ('M');				//Buchstabe M
		MIOS_MIDI_TxBufferPut ('B');				//Buchstabe B
		MIOS_MIDI_TxBufferPut (FUNC_PRINT_BCD5);	//Art der getunnelten Funktion
		MIOS_MIDI_TxBufferPut (display);			//Zielort display

		MIOS_MIDI_TxBufferPut ((char)(v>>7));					//Character
		MIOS_MIDI_TxBufferPut ((char)(v));
		MIOS_MIDI_TxBufferPut (0xF7);				//Sysex End
		MIOS_MIDI_EndStream;
	}
}
