/** \file globals.c:
 *  Creates all global variables, which are declared in globals.h.
 */

unsigned char modus;			//!< operating mode for MIDI-Plank. Determines which menu the user is in
unsigned long device;			//!< stores the device the user is in
unsigned long bank;			//!< stores the bank the user is in
unsigned long modul;			//!< stores the modul the user is in
unsigned char knobs;			//!< stores, which of the four menu buttons is being pressed
unsigned char display;			//!< determines if display 0 or 1 is connected to current core modul
int potis[18]; 				//!< stores MIDI values for all 16 encoders or knobs. last ints are status flags, stores if the encoder changed (potis[16]) and if the knob has been pressed (potis[17])
unsigned int stepwidth;			//!< used for scale=0
unsigned char bankstick;		//!< stores the currently slected bankstick
unsigned char bankchip;			//!< stores the chip of the bankstick which is currently being adressed
unsigned long mem_adress;		//!< while the MIDI Plank is receiving MIDI transmissions, this adress is set to the memory adress where writing begins, and incremented with every recieved byte
struct status stat;
unsigned char update;			//!< determines how the display is updated. see display.c

unsigned long storage_view;
unsigned int buffer_view;
unsigned char led_time;
unsigned char send_editbuffer;
unsigned char get_userdata;

unsigned long transfer_counter;		//!< send an OK all 64 bytes
//unsigned char transfer_buffer[64];	//!< transfer_buffer


Device selected_device;			//!< the device currently selected by the user
Modul selected_modul;			//!< the modul currently selected by the user
EB_request eb_request;			//!< stores the current request and status flags for the Edit Buffer
parameter parametersleft[8];	//!< buffer for the 8 parameters of the left display
parameter parametersright[8];	//!< buffer for the 8 parameters of the right display


unsigned long bankinitcount;					//!< Flag for progress of bankinit in INIT

unsigned char sysex = 0xFF ;           			//!< Flag for progress of Sysex-message
unsigned char received_func_flag;				//!< Flag for used function
unsigned char record_flag;						//!< Flag for state: Sysex received
unsigned char inc_buffer[5];				 	//!< 5 byte Buffer for tunneled Sysex-data
unsigned char evnt[3];							//!< send buffer for transmitting MIDI messages
unsigned char preset_flag;						//!< flag for Preset-Layer, 1 if preset was chosen, else 0
unsigned char preset_encoder;					//!< with what encoder preset was chosen
unsigned int preset_number[16];					//!< which preset was chosen

//unsigned char programming_buffer[64];
unsigned char check_sum;
unsigned char receive_escape;

//unsigned char last;

/**
 * the edit buffer is used as one array of the size 1.5k. These following 8 arrays
 * are connected in memory.c
 */
unsigned char edit_buffer0[256];
unsigned char edit_buffer1[256];
unsigned char edit_buffer2[256];
unsigned char edit_buffer3[256];
unsigned char edit_buffer4[256];
unsigned char edit_buffer5[256];
unsigned char edit_buffer6[2];
unsigned char edit_buffer7[2];
//! edit_buffer_header contains the transmission header for the edit buffer
unsigned char edit_buffer_header[256];

/**
 * send_buffer is a buffer for transmitting smaller sysex strings that are
 * read from the bankstick into this buffer, modified with the corresponding
 * data and then sent over MIDI
 */
unsigned char send_buffer[256];
