/*
 * MIOS SDCC Wrapper
 * -> VELOCITY CONVERTER
 * ==========================================================================
 *
 *  Copyright (C) <2007>  <bill> (<jambonbill@yahoo.fr>)
 *  Licensed for personal non-commercial use only.
 *  All other rights reserved.
 *
 * ==========================================================================
 */

#include "cmios.h"
#include "pic18f452.h"

#include "curve1.c"//user defined velocity curve
#include "curve2.c"//user defined velocity curve
#include "curve3.c"//user defined velocity curve
#include "curve4.c"//user defined velocity curve
#include "curve5.c"//user defined velocity curve
#include "curve6.c"//user defined velocity curve
#include "curve7.c"//user defined velocity curve
#include "curve8.c"//user defined velocity curve
#include "curve9.c"//user defined velocity curve
#include "curve10.c"//user defined velocity curve
#include "curve11.c"//user defined velocity curve
#include "curve12.c"//user defined velocity curve
#include "curve13.c"//user defined velocity curve
#include "curve14.c"//user defined velocity curve
#include "curve15.c"//user defined velocity curve
#include "curve16.c"//user defined velocity curve


unsigned char potpos;//4bit pot0 value
unsigned char velocity;//

/////////////////////////////////////////////////////////////////////////////
// This function is called by MIOS after startup to initialize the
// application
/////////////////////////////////////////////////////////////////////////////
void Init(void) __wparam
{
	// initialize the AIN driver
	MIOS_AIN_NumberSet(1);   // nb pots connected
	MIOS_AIN_UnMuxed();      // no AINX4 modules are used
	MIOS_AIN_DeadbandSet(7); // should be 7 when 7bit resolution is used
}

/////////////////////////////////////////////////////////////////////////////
// This function is called by MIOS in the mainloop when nothing else is to do
/////////////////////////////////////////////////////////////////////////////
void Tick(void) __wparam
{
}

/////////////////////////////////////////////////////////////////////////////
// This function is periodically called by MIOS. The frequency has to be
// initialized with MIOS_Timer_Set
/////////////////////////////////////////////////////////////////////////////
void Timer(void) __wparam
{
}

/////////////////////////////////////////////////////////////////////////////
// This function is called by MIOS when the display content should be
// initialized. Thats the case during startup and after a temporary message
// has been printed on the screen
/////////////////////////////////////////////////////////////////////////////
void DISPLAY_Init(void) __wparam
{
  MIOS_LCD_Clear();
  MIOS_LCD_CursorSet(0x00);
  MIOS_LCD_PrintCString("Velocity Converter V0.2");
}

/////////////////////////////////////////////////////////////////////////////
//  This function is called in the mainloop when no temporary message is shown
//  on screen. Print the realtime messages here
/////////////////////////////////////////////////////////////////////////////
void DISPLAY_Tick(void) __wparam
{
}

/////////////////////////////////////////////////////////////////////////////
//  This function is called by MIOS when a complete MIDI event has been received
/////////////////////////////////////////////////////////////////////////////
void MPROC_NotifyReceivedEvnt(unsigned char evnt0, unsigned char evnt1, unsigned char evnt2) __wparam
{

    // for understanding the MIDI coding, please refer to the MIDI spec
    // (-> http://www.borg.com/~jglatt/tech/midispec.htm)

	if(( evnt0 & 0xf0 )==0x90){//IF IT'S A NOTE-ON...

		// COMPUTE VELOCITY
		//velocity=(evnt2+gain);//SET NEW VELOCITY (simple gain)
		//if(velocity>0x7f)velocity=0x7f;//PAD
		switch(potpos){
			case 0: velocity=curve1[evnt2]; break;
			case 1: velocity=curve2[evnt2]; break;
			case 2: velocity=curve3[evnt2]; break;
			case 3: velocity=curve4[evnt2]; break;
			case 4: velocity=curve5[evnt2]; break;
			case 5: velocity=curve6[evnt2]; break;
			case 6: velocity=curve7[evnt2]; break;
			case 7: velocity=curve8[evnt2]; break;
			case 8: velocity=curve9[evnt2]; break;
			case 9: velocity=curve10[evnt2]; break;
			case 10: velocity=curve11[evnt2]; break;
			case 11: velocity=curve12[evnt2]; break;
			case 12: velocity=curve13[evnt2]; break;
			case 13: velocity=curve14[evnt2]; break;
			case 14: velocity=curve15[evnt2]; break;
			case 15: velocity=curve16[evnt2]; break;
		}		

		// FORWARD MIDI NOTE
		MIOS_MIDI_TxBufferPut(evnt0);//Note-On
		MIOS_MIDI_TxBufferPut(evnt1);//Note value
		MIOS_MIDI_TxBufferPut(velocity);//velocity
		

		// DISPLAY VALUES
		MIOS_LCD_CursorSet(0x00);
		MIOS_LCD_PrintCString("INP Velocity:");
		MIOS_LCD_PrintBCD3(evnt2);

		MIOS_LCD_CursorSet(0x40);
		MIOS_LCD_PrintCString("OUT Velocity:");
		MIOS_LCD_PrintBCD3(velocity);
	}
}


/////////////////////////////////////////////////////////////////////////////
// This function is called by MIOS when a MIDI event has been received
// which has been specified in the MIOS_MPROC_EVENT_TABLE
/////////////////////////////////////////////////////////////////////////////
void MPROC_NotifyFoundEvent(unsigned entry, unsigned char evnt0, unsigned char evnt1, unsigned char evnt2) __wparam
{
}

/////////////////////////////////////////////////////////////////////////////
// This function is called by MIOS when a MIDI event has not been completly
// received within 2 seconds
/////////////////////////////////////////////////////////////////////////////
void MPROC_NotifyTimeout(void) __wparam
{
}

/////////////////////////////////////////////////////////////////////////////
// This function is called by MIOS when a MIDI byte has been received
/////////////////////////////////////////////////////////////////////////////
void MPROC_NotifyReceivedByte(unsigned char byte) __wparam
{
}

/////////////////////////////////////////////////////////////////////////////
// This function is called by MIOS before the shift register are loaded
/////////////////////////////////////////////////////////////////////////////
void SR_Service_Prepare(void) __wparam
{
}

/////////////////////////////////////////////////////////////////////////////
// This function is called by MIOS after the shift register have been loaded
/////////////////////////////////////////////////////////////////////////////
void SR_Service_Finish(void) __wparam
{
}

/////////////////////////////////////////////////////////////////////////////
// This function is called by MIOS when an button has been toggled
// pin_value is 1 when button released, and 0 when button pressed
/////////////////////////////////////////////////////////////////////////////
void DIN_NotifyToggle(unsigned char pin, unsigned char pin_value) __wparam
{
}

/////////////////////////////////////////////////////////////////////////////
// This function is called by MIOS when an encoder has been moved
// incrementer is positive when encoder has been turned clockwise, else
// it is negative
/////////////////////////////////////////////////////////////////////////////
void ENC_NotifyChange(unsigned char encoder, char incrementer) __wparam
{
}

/////////////////////////////////////////////////////////////////////////////
// This function is called by MIOS when a pot has been moved
/////////////////////////////////////////////////////////////////////////////
void AIN_NotifyChange(unsigned char pin, unsigned int pin_value) __wparam
{

	switch(pin){
		case 0://POT 1
			//gain=pin_value >> 4;//10 to 6 bit division
			potpos=pin_value >> 6;//10 to 4 bit division
		
			// DISPLAY VALUES
			MIOS_LCD_CursorSet(0x00);
			MIOS_LCD_PrintCString("SELECT CURVE #");
			MIOS_LCD_PrintBCD2((pin_value+1));
			MIOS_LCD_PrintCString("     ");			
			break;
	
	}

	return;
}

