/*
 *  params.h
 *  
 *
 *  Created by Ingo on 06.02.13.
 *  Copyright 2013 __MyCompanyName__. All rights reserved.
 *
 */

// Compiler options

#define SENSE_PRESSURE			//output pressure data
#define SMART_GLITCH_SUPPRESSION		//enable glitch suppression


// Byte addresses of parameters

#define NAME			0		//16 chars
#define RIM_MIDICH		16		//MIDI channel for Rim
#define HEAD_MIDICH		17		//MIDI channel for Head
#define PRES_MIDICH		18		//MIDI channel for Pressure Sensor
#define RIM_NOTE		19		//base MIDI note number for Rim
#define HEAD_NOTE		20		//base MIDI note number for Head
#define PRES_CC			21		//MIDI cc for Pressure Sensor
#define THRESH			22		//adc value has to go beyond this threshold (in ADC units) to trigger a note
#ifdef DUMB_GLITCH_SUPPRESSION
#define ABV_THR_CNT_MAX	23		//at least so many ADC values need to be above threshold, otherwise it's considered a glitch
#endif
#define RIM_VEL_SCALE	24
#define HEAD_VEL_SCALE	25
#ifdef SMART_GLITCH_SUPPRESSION
#define BLW_THR_CNT_MAX	26		//max number of ADC values that are allowed to be below threshold in start zone, otherwise it's considered a glitch
#endif
#define SENDWAVE		27		//if !=0, wave buffer is sent as Sysex
#define SENDWAVE_OFF	0
#define SENDWAVE_WAVE	1
#define SENDWAVE_FFT	2

#define DEBOUNCE_TIME	28		//debounce time, in multiples of SAMPLE_INTERVAL*ADC_NUM (2 bytes)
#define OFFSET_FILTER	30
#define FFT_SCALE		31		//scale for FFT display
#define VARIANCE_SCALE	32		//scale for variance output (via CC), common for Head and Rim
#define AMPL_SCALE		33		//scale for FFT amplitude aoutput via note velocity, common for Head and Rim
#define VEL_SRC			34		//0: use max value as velocity; 1:use ampl from FFT as velocity
#define VAR_CC			35		//MIDI cc for Variance
#define RIM_FREQSCALE	36		//factor with which FFT center freq is taken into account in note number
#define HEAD_FREQSCALE	37
#define RIM_PRSSCALE	38		//factor with which pressure is taken into account in note number
#define HEAD_PRSSCALE	39
//Quantizer parameters
#define N_STEPS			40		//number of steps in scale, 5 for pentatonic, 7 for diatonic etc
#define REP_INTERVAL	41		//repetition interval, usually an octave i.e. 12
#define Q_TAB0			42		//interval of 1st note in scale, usually 0
#define Q_TAB1			43		//interval of 2nd note in scale
#define Q_TAB2			44		//etc...
#define Q_TAB3			45
#define Q_TAB4			46
#define Q_TAB5			47
#define Q_TAB6			48
#define Q_TAB7			49
#define Q_TAB8			50
#define Q_TAB9			51
#define Q_TAB10			52
#define Q_TAB11			53

// "Read-only" parameters

#define AMPLITUDE		175		//amplitude (sum of squares) of FFT output (2 bytes)
#define CENTERFREQ		177		//center freq of FFT output
#define VARIANCE		179		//variance of FFT output (2 bytes)
#define ZEROPRS			181		//zero pressure (2 bytes)
#define DETMIN			183		//detected min (2 bytes)
#define DETMAX			185		//detected max (2 bytes)
#define ZERO0			187		//zero adc0 (2 bytes)
#define ZERO1			189		//zero adc1 (2 bytes)
#define ACTIVE_CHNL		191		//adc from which the waveform was recorded 0=Rim, 1=Head
#define WAVE0			192		//read-only area for waveform buffer (64 bytes)
#define WAVE63			255		//read-only area for waveform buffer (64 bytes)


