// $Id: patch.h 1255 2011-07-16 22:56:01Z tk $
/*
 * Patch Layer
 * ID: added PATCH_ReadWord() and PATCH_WriteWord()
 *
 * ==========================================================================
 *
 *  Copyright (C) 2008 Thorsten Klose (tk@midibox.org)
 *  Licensed for personal non-commercial use only.
 *  All other rights reserved.
 * 
 * ==========================================================================
 */

#ifndef _PATCH_H
#define _PATCH_H

/////////////////////////////////////////////////////////////////////////////
// global definitions
/////////////////////////////////////////////////////////////////////////////

// 0: use internal EEPROM emulation, 1: use BankStick as patch storage
#define PATCH_USE_BANKSTICK   0

// the patch size
#define PATCH_SIZE    0x100  // 256 bytes


/////////////////////////////////////////////////////////////////////////////
// Type definitions
/////////////////////////////////////////////////////////////////////////////


/////////////////////////////////////////////////////////////////////////////
// Prototypes
/////////////////////////////////////////////////////////////////////////////

extern s32 PATCH_Init(u32 mode);

extern u8  PATCH_ReadByte(u16 addr);
extern u16 PATCH_ReadWord(u16 addr);
extern s32 PATCH_WriteByte(u16 addr, u8 byte);
extern s32 PATCH_WriteWord(u16 addr, u16 value);

extern s32 PATCH_Load(u8 bank, u8 patch);
extern s32 PATCH_Store(u8 bank, u8 patch);


/////////////////////////////////////////////////////////////////////////////
// Exported variables
/////////////////////////////////////////////////////////////////////////////

#endif /* _PATCH_H */
