/*
 * MIOS32 Wavedrum MIDI
 * Version 1.0
 * ==========================================================================
 *
 *  Copyright (C) 2013 Ingo Debus (<your email address>)
 *  Licensed for personal non-commercial use only.
 *  All other rights reserved.
 * 
 * ==========================================================================
 */



#include "lpc17xx.h"
#include <mios32.h>
#include "timer.h"




/******************************************************************************
** Function name:		enable_timer
**
** Descriptions:		Enable timer
**
** parameters:			timer number: 0 or 1 or 2 or 3
** Returned value:		None
** 
******************************************************************************/
void enable_timer( u8 timer_num )
{
  if ( timer_num == 0 )
  {
	LPC_TIM0->TCR = 1;
  }
  else if ( timer_num == 1 )
  {
	LPC_TIM1->TCR = 1;
  }
  else if ( timer_num == 2 )
  {
	LPC_TIM2->TCR = 1;
  }
  else if ( timer_num == 3 )
  {
	LPC_TIM3->TCR = 1;
  }
  return;
}

/******************************************************************************
** Function name:		disable_timer
**
** Descriptions:		Disable timer
**
** parameters:			timer number: 0 or 1 oe 2 or 3
** Returned value:		None
** 
******************************************************************************/
void disable_timer( u8 timer_num )
{
  if ( timer_num == 0 )
  {
	LPC_TIM0->TCR = 0;
  }
  else if ( timer_num == 1 )
  {
	LPC_TIM1->TCR = 0;
  }
  else if ( timer_num == 2 )
  {
	LPC_TIM2->TCR = 0;
  }
  else if ( timer_num == 3 )
  {
	LPC_TIM2->TCR = 0;
  }
  return;
}

/******************************************************************************
** Function name:		reset_timer
**
** Descriptions:		Reset timer
**
** parameters:			timer number: 0 or 1 or 2 or 3
** Returned value:		None
** 
******************************************************************************/
void reset_timer( u8 timer_num )
{
  u32 regVal;

  if ( timer_num == 0 )
  {
	regVal = LPC_TIM0->TCR;
	regVal |= 0x02;
	LPC_TIM0->TCR = regVal;
  }
  else if ( timer_num == 1 )
  {
	regVal = LPC_TIM1->TCR;
	regVal |= 0x02;
	LPC_TIM1->TCR = regVal;
  }
  else if ( timer_num == 2 )
  {
	regVal = LPC_TIM2->TCR;
	regVal |= 0x02;
	LPC_TIM2->TCR = regVal;
  }
  else if ( timer_num == 3 )
  {
	regVal = LPC_TIM3->TCR;
	regVal |= 0x02;
	LPC_TIM3->TCR = regVal;
  }
  return;
}

/******************************************************************************
** Function name:		init_timer0
**
** Descriptions:		Initialize timer, set timer interval, reset timer,
**						install timer interrupt handler
**
** parameters:			
** Returned value:		
** 
******************************************************************************/
void init_timer0 (void)
{
  u32 pclkdiv, pclk;

	LPC_SC->PCONP |= (0x01<<1);	//Timer/Counter 0 power/clock control bit

	//the following will toggle the P1.29 pin on every timer match event - useful for debugging
	LPC_PINCON->PINSEL3 &= ~((0x3<<24)|(0x3<<26));
	LPC_PINCON->PINSEL3 |= ((0x3<<24)|(0x3<<26));	//!!!!!assign MAT0.0 to P1.28 and MAT0.1 to P1.29

	LPC_TIM0->IR = 0x0F;          /* Clear MATx interrupt include DMA request */ 

	/* By default, the PCLKSELx value is zero, thus, the PCLK for
	all the peripherals is 1/4 of the SystemFrequency. */
	/* Bit 2~3 is for TIMER0 */
#if MIOS32_SYS_CPU_FREQUENCY != 120000000
# warning "Adapt here to achieve 2.5 MHz"
#endif
	pclkdiv = (LPC_SC->PCLKSEL0 >> 2) & 0x03;
	switch ( pclkdiv )
	{
	  case 0x00:
	  default:
//		pclk = SystemCoreClock/4;
		pclk = MIOS32_SYS_CPU_FREQUENCY/4;
		break;
	  case 0x01:
//		pclk = SystemCoreClock;
		pclk = MIOS32_SYS_CPU_FREQUENCY;
		break; 
	  case 0x02:
//		pclk = SystemCoreClock/2;
		pclk = MIOS32_SYS_CPU_FREQUENCY/2;
		break; 
	  case 0x03:
//		pclk = SystemCoreClock/8;
		pclk = MIOS32_SYS_CPU_FREQUENCY/8;
		break;
	}
	LPC_TIM0->PR  = pclk/1000000; /* set prescaler to get 1 M counts/sec */

	LPC_TIM0->MR1 = SAMPLE_INTERVAL; /* Set up SAMPLE_INTERVAL us interval */
// the following seems to be required...
	LPC_TIM0->EMR &= ~(0xFF<<4);			//set EMC0...3 to "do nothing"
//	LPC_TIM0->EMR |= ((0x3<<4)|(0x3<<6));	//set EMC0, EMC1 to "Toggle the corresponding External Match bit/output"
	LPC_TIM0->EMR |= (0x3<<6);				//set EMC1 to "Toggle the corresponding External Match bit/output"
//	LPC_TIM0->MCR = (0x3<<0)|(0x3<<3);	/* Interrupt and Reset on MR0 and MR1 */
	LPC_TIM0->MCR = 0x2<<3;				/* Reset on MR1 */
//	NVIC_EnableIRQ(TIMER0_IRQn);
}

/******************************************************************************
**                            End Of File
******************************************************************************/
